/**
 * Created by jiangbo1 on 2016/2/24.
 */

UI.moduleBuilder['liveTV']['passwordDialog'] = function () {

    var pwdData = {
        pwd_dlg_bg: UI.window_bg,
        pwd_pad_bg: UI.window_bg,
        pwdImg1: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg2: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg3: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg4: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdNumFocusImg: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdText1: " ",
        pwdText2: " ",
        pwdText3: " ",
        pwdText4: " ",
        delete_bg: UI.item_bg,
        zero_bg: UI.item_bg,
        delete_icon: "setting/key_delete.png",
        zeroText: "0",
        pwdTip: "[SE1543]"
    };

    var template = Util.readJson("module/liveTV/passwordDialog.json");
    var pwdDialog = SubModule.create(pwdData, template);

    var pwdDlgPanel = UI.getItem(pwdDialog, "pwdDlgPanel");
    var pwdPadPanel = UI.getItem(pwdDialog, "pwdPadPanel");
    var pwdNumFocusImg = UI.getItem(pwdDialog, "pwdNumFocusImg");

    var deleteBtn = UI.getItem(pwdPadPanel, "deleteBtn");
    var zeroBtn = UI.getItem(pwdPadPanel, "zeroBtn");

    var pwdNumArr = [], pwdImgArr = [], pwdTextArr = [], numList, crntIndex = 0, pinCode;

    var inputedArr = [], space = " ", btnMap = [
        "1", "2", "3",
        "4", "5", "6",
        "7", "8", "9",
    ];
    var numKeyMap = ["ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"];
    UI.setVoiceStr(deleteBtn,"[GE0014]");
    function initUIElement() {
        for (var i = 1; i <= 4; i++) {
            pwdNumArr.push(UI.getItem(pwdDlgPanel, "pwdNum" + i));
            pwdImgArr.push(UI.getItem(pwdNumArr[i - 1], "pwdImg" + i));
            pwdTextArr.push(UI.getItem(pwdNumArr[i - 1], "pwdText" + i));
        }
        numList = UI.getItem(pwdPadPanel, "numList");
        var gridInfo = {
            template: "NumPadTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceY: 20,
            distanceX: 40,
            container: numList
        };

        var allArray = [];
        for (var i = 0; i < btnMap.length; i++) {
            allArray.push(
                {
                    tileBg: UI.item_bg,
                    Num: btnMap[i],
                    name: "BTN" + i
                }
            )
        }
        Gird.create(allArray, gridInfo);
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
    }

    function moveBorderTo(frm, to) {
        if (to < 0 || to > 3) return;
        //if (frm >= 0) UI.setImage(pwdImgArr[frm], GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM);
        //if (frm >= 0) setLiveTVImage(pwdImgArr[frm], GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM);
        for (var i = 0; i < pwdImgArr.length; i++) {
            pwdImgArr[i].alpha = 1;
        }
        pwdImgArr[to].alpha = 0;
        pwdNumFocusImg.x = pwdNumArr[to].x;
        //UI.setImage(pwdImgArr[to], GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL);
        //setLiveTVImage(pwdImgArr[to], GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL);
        crntIndex = to;
    }

    pwdDlgPanel.onkey_LEFT = function () {
        if (0 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex - 1);
        return true;
    }

    pwdDlgPanel.onkey_RIGHT = function () {
        if (3 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex + 1);
        return true;
    }

    pwdPadPanel.onkey_RIGHT = function() {
        var index = numList.initSequence.indexOf(UI.getCurrSubModule().currFocus);
        if (index == 2 || index == 5) {
            UI.focusTo(deleteBtn);
        }
        else if (index == 8) {
            UI.focusTo(zeroBtn);
        }
        else {
            return true;
        }
    };
    deleteBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN2"))
    };
    zeroBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN8"))
    };

    deleteBtn.onkey_ENTER = function() {
        inputedArr[crntIndex] = "";
        moveBorderTo(crntIndex, crntIndex - 1);
        setLiveTVText(pwdTextArr[crntIndex], space);
        UI.updateStage();
    };

    zeroBtn.onkey_ENTER = function() {
        if (crntIndex < 4) {
            inputedArr[crntIndex] = "0";
            setLiveTVText(pwdTextArr[crntIndex], "*");
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        checkPwdAndUnlock(inputedArr);
        UI.updateStage();
    };

    /*pwdDlgPanel.onkey_DOWN = function (focus) {
        UI.focusTo(UI.getItem(numList, "BTN5"));
    }

    pwdPadPanel.onkey_UP = function () {
        var index = numList.initSequence.indexOf(UI.getCurrModule().currFocus);
        if (index == -1 || index > 3) return true;
        moveBorderTo(-1, crntIndex);
        UI.focusTo(pwdNumArr[crntIndex]);
        return false;
    }

    pwdPadPanel.onkey_DOWN = function () {
        var index = numList.initSequence.indexOf(UI.getCurrModule().currFocus);
        if (index < 8) return true;
        if (8 == index || 9 == index) {
            UI.focusTo(deleteBtn);
        }
        else if (10 == index || 11 == index) {
            UI.focusTo(zeroBtn);
        }
        return false;
    }*/

    function checkPwdAndUnlock(arr) {
        var pwd = arr.join("");
        if (pwd.length == 4) {
            DBG_INFO("password is: " + pwd);
            if (pwd == pinCode || pwd == GLOBAL.MASTER_KEY) {
                setTimeout(function(){
                    UI.popSubModule();
                    try {
                        var crntChannel = liveTV.getCurrentChannelInfo();
                        if (Config.tv && 1 == model.source.getInputCurrentInLock()) {
                            model.source.unlockInput(liveTV.getCurrentSourceObj().uid);
                        }
                        //if (Config.tv && SourceList.TV == GLOBAL.CURRENT_SOURCE/* && crntChannel.eCode == ECode.LOCK*/) {
                        //    model.tvservice.unLockPlayChannel(crntChannel.uid);
                        //}
                        if(liveTV.isParentalLockPinRequest())// add by samuel qin 2016/9/26
                        {
                            DBG_INFO("PinRequestConfirm:" + pwd);
                            model.parentlock.PinRequestConfirm(Parental_lockModel.PARENTAL_PIN_REQUEST_STATUS_CONFIRMED, pwd);
                        }
                        model.system.setOttPwdCheckFlag(1);
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    GLOBAL.UNLOCKED = true;
                    openLiveTVModule([Msg.PASSWORD, 0]);
                }, 50);
                return true;
            }
            else {
                DBG_TODO("password error.");
                for (var i = 0; i < 4; i++) {
                    setLiveTVText(pwdTextArr[i], space);
                }
                moveBorderTo(crntIndex, 0);
                inputedArr = [];
                GLOBAL.CURRENT_TOAST_TYPE=0;
                UI.pushGhostModule("setting","SettingSysToast");
                UI.updateStage();
            }
        }
        return false;
    }

    function passwordDialgHandler(focus, evt){
        if (crntIndex < 4) {
            inputedArr[crntIndex] = (evt.keyCode - CONST.KEY.VK_0) + "";
            setLiveTVText(pwdTextArr[crntIndex], "*");
            if(3 == crntIndex) UI.updateStage();
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        if(!checkPwdAndUnlock(inputedArr)){
//            UI.focusTo(pwdNumArr[crntIndex]);
        }
        UI.updateStage();
        return false;
    }

    pwdPadPanel.onkey_ENTER = function (focus) {
        switch (focus.name) {
            /*case "deleteBtn":
                moveBorderTo(crntIndex, crntIndex - 1);
                break;
            case "zeroBtn":
                moveBorderTo(crntIndex, crntIndex + 1);
                break;
            case "BTN7"://Dot
                return false;
            case "BTN3"://Delete
                if (space == UI.getText(pwdTextArr[crntIndex])) {
                    moveBorderTo(crntIndex, crntIndex - 1);
                }
                else {
                    inputedArr[crntIndex] = "";
                    setLiveTVText(pwdTextArr[crntIndex], space);
                }
                break;*/
            default :
                if (crntIndex < 4) {
                    inputedArr[crntIndex] = btnMap[numList.initSequence.indexOf(focus)];
                    setLiveTVText(pwdTextArr[crntIndex], "*");
                    moveBorderTo(crntIndex, crntIndex + 1);
                }
                break;
        }
        UI.updateStage();
        checkPwdAndUnlock(inputedArr);
    }

    function recoverInputBox(){
        for (var i = 0; i < 4; i++) {
            setLiveTVText(pwdTextArr[i], space);
        }
        moveBorderTo(crntIndex, 0);
        inputedArr = [];
    }

    pwdDialog.onPush = function () {
        DBG_ONXX(LIVETV.PASSWORD_DIALOG, "onPush");
        if (Config.tv) pinCode = model.parentlock.getPin();
        moveBorderTo(-1, 0);
    };

    pwdDialog.afterPush = function(){
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        pwdDialog.onFocus(pwdDialog.currFocus);
        UI.getTween(UI).wait(10000);
    };

    pwdDialog.onPop = function () {
        DBG_ONXX(LIVETV.PASSWORD_DIALOG, "onPop");
        recoverInputBox();
        UI.getTween(UI.base.cursor, true).to({scaleX: 1, scaleY: 1, alpha: 0}, 500, UI.ease.quartOut);
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
    };

    pwdDialog.onFocus = function (focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).to({x:1.05, y:1.05}, 200, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha:1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        UI.base.runText(focus);
    };

    pwdDialog.onNormal = function(focus){
        if (GLOBAL.HICONTRAST) {
            UI.base.toNormalContrast(focus);
        }
        createjs.Tween.removeTweens(focus.scale);
        focus.scale.x = 1;
        focus.scale.y = 1;
        UI.base.stopText(focus);
    };

    numKeyMap.forEach(function (v) {
//        pwdDlgPanel["onkey_" + v] = passwordDialgHandler;
        pwdPadPanel["onkey_" + v] = passwordDialgHandler;
    });

    initUIElement();
};