DBG_INFO("liveTVCtrl.js start " +  debugRunTime());
UI.templateManager["module/liveTV/liveTVCtrl.json"] = {
    liveTVCtrl: {
        type: 0,
        position: {
            x: 0,
            y: 0
        },
        items: {
            signalTip: {
                type: 0,
                position: {
                    x: 0,
                    y: 0
                },
                items: {
                    signal_img: {
                        type: 7,
                        bound: {
                            w: 1920,
                            h: 1080
                        },
                        position: {
                            x: 0,
                            y: 0
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    signal_txt: {
                        type: 6,
                        bound: {
                            w: 268,
                            h: 40
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "No Signal",
                        font: "36px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "center",
                        warp: true,
                        maxLines: 2,
                        position: {
                            x: 826,
                            y: 520
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    signal_txt_screenSaverMode: {
                        type: 6,
                        bound: {
                            w: 1560,
                            h: 72
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "Weak or No Signal",
                        font: "72px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "center",
                        position: {
                            x: 180,
                            y: 600
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    signal_txt_screenSaverMode_hisense: {
                        type: 6,
                        bound: {
                            w: 1560,
                            h: 48
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "Please check input",
                        font: "48px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        warp: true,
                        lineHeight: 16,
                        align: "center",
                        position: {
                            x: 180,
                            y: 708
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    signal_txt_screenSaverMode_sharp: {
                        type: 6,
                        bound: {
                            w: 888,
                            h: 36
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "Please check input",
                        font: "36px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        warp: true,
                        lineHeight: 16,
                        align: "center",
                        position: {
                            x: 516,
                            y: 534
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    "sourceIcon": {
                        "type": 7,
                        "bound": {
                            "w": 240,
                            "h": 240
                        },
                        "position": {
                            "x": 840,
                            "y": 240
                        },
                        "alpha":"0",
                        "navigation": {
                            "leftTo": null,
                            "rightTo": null,
                            "upTo": null,
                            "downTo": null
                        }
                    },
                    "sourceText": {
                        "type": 6,
                        "bound": {
                            "w": 1920,
                            "h": 96
                        },
                        "innerPos": {
                            "x": 960,
                            "y": 0
                        },
                        "value": "Cable",
                        "font": "48px SourceSansPro-Light",
                        "color": "0xFFFFFF",
                        "align": "center",
                        "position": {
                            "x": 0,
                            "y": 490
                        },
                        "alpha":"0",
                        "navigation": {
                            "leftTo": null,
                            "rightTo": null,
                            "upTo": null,
                            "downTo": null
                        }
                    }
                }
            },
            signalTipSecondType: {
                type: 0,
                position: {
                    x: 0,
                    y: 0
                },
                items: {
                    signal_img_SecondType: {
                        type: 7,
                        bound: {
                            w: 1597,
                            h: 322
                        },
                        position: {
                            x: 0,
                            y: 0
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    "signal_img_SecondType2": {
                        "type": 7,
                        "bound": {
                            "w": 284,
                            "h": 322
                        },
                        "alpha": 1,
                        "position": {
                            "x": 20,
                            "y": 0
                        },
                        "navigation": {
                            "leftTo": null,
                            "rightTo": null,
                            "upTo": null,
                            "downTo": null
                        }
                    },
                    "source_txt_SecondType": {
                        "type": 6,
                        "bound": {
                            "w": 264,
                            "h": 36
                        },
                        "innerPos": {
                            "x": 0,
                            "y": 0
                        },
                        "noCache": true,
                        "value": "HDMI 1",
                        "font": "36px SourceSansPro-Light",
                        "color": "0xFFFFFF",
                        "align": "center",
                        "alpha": 0.6,
                        "position": {
                            "x": 32,
                            "y": 232
                        },
                        "navigation": {
                            "leftTo": null,
                            "rightTo": null,
                            "upTo": null,
                            "downTo": null
                        }
                    },
                    signal_txt_SecondType: {
                        type: 6,
                        bound: {
                            w: 1160,
                            h: 60
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "No Signal",
                        font: "60px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "left",
                        position: {
                            x: 350,
                            y: 60
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    signal_txt_SecondType2: {
                        type: 6,
                        bound: {
                            w: 1160,
                            h: 30
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "No Signal",
                        font: "30px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "left",
                        position: {
                            x: 350,
                            y: 145
                        },
                        warp: true,
                        alpha: 0.7,
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            },
            numTip: {
                type: 0,
                position: {
                    x: 30,
                    y: 0
                },
                items: {
                    num_bg: {
                        type: 7,
                        bound: {
                            w: 570,
                            h: 240
                        },
                        position: {
                            x: 0,
                            y: 0
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    num_txt: {
                        type: 6,
                        bound: {
                            w: 530,
                            h: 60
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "0",
                        font: "60px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "center",
                        position: {
                            x: 20,
                            y: 90
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            },
            TVTypeTip: {
                type: 0,
                position: {
                    x: 60,
                    y: 800
                },
                items: {
                    tv_type_img: {
                        type: 7,
                        bound: {
                            w: 370,
                            h: 200
                        },
                        position: {
                            x: 0,
                            y: 0
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    tv_type_txt: {
                        type: 6,
                        bound: {
                            w: 370,
                            h: 40
                        },
                        innerPos: {
                            x: 185,
                            y: 0
                        },
                        noCache: true,
                        value: "Radio Channel",
                        font: "36px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "center",
                        position: {
                            x: 0,
                            y: 80
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            },
            defaultFocus: {
                type: 7,
                bound: {
                    w: 0,
                    h: 0
                },
                position: {
                    x: 1762,
                    y: 930
                },
                navigation: {
                    leftTo: null,
                    rightTo: null,
                    upTo: null,
                    downTo: null
                }
            },
            infoBarTV: {
                type: 0,
                position: {
                    x: 50,
                    y: 20
                },
                items: {
                    infoBarP1: {
                        type: 0,
                        position: {
                            x: 0,
                            y: 0
                        },
                        items: {
                            infoBarP1Left: {
                                type: 0,
                                position: {
                                    x: 0,
                                    y: 0
                                },
                                items: {
                                    tv_left_img_1: {
                                        type: 7,
                                        bound: {
                                            w: 570,
                                            h: 240
                                        },
                                        position: {
                                            x: -20,
                                            y: -20
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chNumP1: {
                                        type: 6,
                                        bound: {
                                            w: 200,
                                            h: 60
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Number",
                                        font: "48px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 30,
                                            y: 22
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chNameP1: {
                                        type: 6,
                                        bound: {
                                            w: 470,
                                            h: 60
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Time",
                                        font: "42px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 30,
                                            y: 84
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    crntTime: {
                                        type: 6,
                                        bound: {
                                            w: 470,
                                            h: 54
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Name",
                                        font: "30px SourceSansPro-Light",
                                        color: "0xFFFFFF",
                                        align: "left",
                                        position: {
                                            x: 30,
                                            y: 146
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chEncryptImg: {
                                        type: 7,
                                        bound: {
                                            w: 30,
                                            h: 30
                                        },
                                        position: {
                                            x: 250,
                                            y: 35
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chFAVImg: {
                                        type: 7,
                                        bound: {
                                            w: 30,
                                            h: 30
                                        },
                                        position: {
                                            x: 292,
                                            y: 35
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chLockImg: {
                                        type: 7,
                                        bound: {
                                            w: 30,
                                            h: 30
                                        },
                                        position: {
                                            x: 334,
                                            y: 35
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chTSText: {
                                        type: 6,
                                        bound: {
                                            w: 140,
                                            h: 30
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Cable",
                                        font: "30px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 380,
                                            y: 35
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    }
                                }
                            },
                            infoBarP1Right: {
                                type: 0,
                                position: {
                                    x: 541,
                                    y: 0
                                },
                                items: {
                                    tv_right_img_1: {
                                        type: 7,
                                        bound: {
                                            w: 1320,
                                            h: 240
                                        },
                                        position: {
                                            x: -20,
                                            y: -20
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    crntPrgmNameP1: {
                                        type: 6,
                                        bound: {
                                            w: 800,
                                            h: 64
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Current Program Name",
                                        font: "48px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 29,
                                            y: 24
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    crntLine: {
                                        type: 0,
                                        position: {
                                            x: 29,
                                            y: 88
                                        },
                                        items: {
                                            crntStartTime: {
                                                type: 6,
                                                bound: {
                                                    w: 300,
                                                    h: 58
                                                },
                                                innerPos: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                noCache: true,
                                                value: "Start Time",
                                                font: "30px SourceSansPro-Light",
                                                color: "0xFFFFFF",
                                                align: "left",
                                                position: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            },
                                            crntProgress: {
                                                type: 7,
                                                bound: {
                                                    w: 270,
                                                    h: 12
                                                },
                                                position: {
                                                    x: 212,
                                                    y: 24
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            },
                                            crntEndTime: {
                                                type: 6,
                                                bound: {
                                                    w: 300,
                                                    h: 58
                                                },
                                                innerPos: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                noCache: true,
                                                value: "End Time",
                                                font: "30px SourceSansPro-Light",
                                                color: "0xFFFFFF",
                                                align: "left",
                                                position: {
                                                    x: 494,
                                                    y: 0
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            }
                                        }
                                    },
                                    nextLine: {
                                        type: 0,
                                        position: {
                                            x: 29,
                                            y: 146
                                        },
                                        items: {
                                            nextTimeDuration: {
                                                type: 6,
                                                bound: {
                                                    w: 600,
                                                    h: 54
                                                },
                                                innerPos: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                noCache: true,
                                                value: "Next Time Duration",
                                                font: "30px SourceSansPro-Light",
                                                color: "0xFFFFFF",
                                                align: "left",
                                                position: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            },
                                            nextPrgmNameP1: {
                                                type: 6,
                                                bound: {
                                                    w: 400,
                                                    h: 54
                                                },
                                                innerPos: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                noCache: true,
                                                value: "Next Program Name",
                                                font: "30px SourceSansPro-Light",
                                                color: "0xF0F0F0",
                                                align: "left",
                                                position: {
                                                    x: 230,
                                                    y: 0
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            },
                                            nextRmdrImgP1: {
                                                type: 7,
                                                bound: {
                                                    w: 30,
                                                    h: 30
                                                },
                                                position: {
                                                    x: 650,
                                                    y: 5
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            }
                                        }
                                    },
                                    infoGroup: {
                                        type: 0,
                                        position: {
                                            x: 609,
                                            y: 36
                                        },
                                        items: {
                                            infoDPI: {
                                                type: 0,
                                                position: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_DPI: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_DPI: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoAspect: {
                                                type: 0,
                                                position: {
                                                    x: 65,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_Aspect: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_Aspect: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoTVType: {
                                                type: 0,
                                                position: {
                                                    x: 130,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_TVType: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_TVType: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoHBBTV: {
                                                type: 0,
                                                position: {
                                                    x: 195,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_HBBTV: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_HBBTV: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoRating: {
                                                type: 0,
                                                position: {
                                                    x: 260,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_Rating: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_Rating: {
                                                        type: 6,
                                                        bound: {
                                                            w: 500,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoCC: {
                                                type: 0,
                                                position: {
                                                    x: 326,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_CC: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_CC: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoSubT: {
                                                type: 0,
                                                position: {
                                                    x: 391,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_SubT: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_SubT: {
                                                        type: 6,
                                                        bound: {
                                                            w: 500,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoTTX: {
                                                type: 0,
                                                position: {
                                                    x: 456,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_TTX: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_TTX: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoSAP: {
                                                type: 0,
                                                position: {
                                                    x: 521,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_SAP: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_SAP: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "Info",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 4
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            },
                                            infoDolby: {
                                                type: 0,
                                                position: {
                                                    x: 586,
                                                    y: 0
                                                },
                                                items: {
                                                    infoSplit_Dolby: {
                                                        type: 7,
                                                        bound: {
                                                            w: 24,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoText_Dolby: {
                                                        type: 6,
                                                        bound: {
                                                            w: 200,
                                                            h: 30
                                                        },
                                                        innerPos: {
                                                            x: 0,
                                                            y: 0
                                                        },
                                                        noCache: true,
                                                        value: "ac3",
                                                        font: "28px SourceSansPro-Light",
                                                        color: "0xFFFFFF",
                                                        align: "left",
                                                        position: {
                                                            x: 24,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    },
                                                    infoImg_Dolby: {
                                                        type: 7,
                                                        bound: {
                                                            w: 30,
                                                            h: 30
                                                        },
                                                        position: {
                                                            x: 24,
                                                            y: 0
                                                        },
                                                        navigation: {
                                                            leftTo: null,
                                                            rightTo: null,
                                                            upTo: null,
                                                            downTo: null
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    arrowRight: {
                                        type: 7,
                                        bound: {
                                            w: 50,
                                            h: 70
                                        },
                                        position: {
                                            x: 1279,
                                            y: 65
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    }
                                }
                            }
                        }
                    },
                    infoBarP2: {
                        type: 0,
                        position: {
                            x: 1870,
                            y: 0
                        },
                        items: {
                            infoBarP2Left: {
                                type: 0,
                                position: {
                                    x: 0,
                                    y: 0
                                },
                                items: {
                                    tv_left_img_2: {
                                        type: 7,
                                        bound: {
                                            w: 570,
                                            h: 240
                                        },
                                        position: {
                                            x: 30,
                                            y: -20
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    chNameP2: {
                                        type: 6,
                                        bound: {
                                            w: 470,
                                            h: 62
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "Name",
                                        font: "42px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 80,
                                            y: 26
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    sigLevel: {
                                        type: 6,
                                        bound: {
                                            w: 470,
                                            h: 50
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "signal level",
                                        font: "36px SourceSansPro-Light",
                                        color: "0xFFFFFF",
                                        align: "left",
                                        position: {
                                            x: 80,
                                            y: 88
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    sigQuality: {
                                        type: 6,
                                        bound: {
                                            w: 470,
                                            h: 50
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "signal quality",
                                        font: "36px SourceSansPro-Light",
                                        color: "0xFFFFFF",
                                        align: "left",
                                        position: {
                                            x: 80,
                                            y: 138
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    arrowLeft: {
                                        type: 7,
                                        bound: {
                                            w: 50,
                                            h: 70
                                        },
                                        position: {
                                            x: 0,
                                            y: 65
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    }
                                }
                            },
                            infoBarP2Right: {
                                type: 0,
                                position: {
                                    x: 590,
                                    y: 0
                                },
                                items: {
                                    tv_right_img_2: {
                                        type: 7,
                                        bound: {
                                            w: 1320,
                                            h: 240
                                        },
                                        position: {
                                            x: -20,
                                            y: -20
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    crntPrgmNameP2: {
                                        type: 6,
                                        bound: {
                                            w: 1220,
                                            h: 48
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        value: "program name",
                                        font: "36px SourceSansPro-Light",
                                        color: "0xF0F0F0",
                                        align: "left",
                                        position: {
                                            x: 30,
                                            y: 24
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    crntPrgmDetailP2: {
                                        type: 6,
                                        bound: {
                                            w: 1220,
                                            h: 120
                                        },
                                        innerPos: {
                                            x: 0,
                                            y: 0
                                        },
                                        noCache: true,
                                        warp: true,
                                        maxLines: 2,
                                        value: "program detail",
                                        font: "30px SourceSansPro-Light",
                                        color: "0xFFFFFF",
                                        align: "left",
                                        position: {
                                            x: 30,
                                            y: 72
                                        },
                                        navigation: {
                                            leftTo: null,
                                            rightTo: null,
                                            upTo: null,
                                            downTo: null
                                        }
                                    },
                                    infoDetailBtn: {
                                        type: 0,
                                        position: {
                                            x: 900,
                                            y: 130
                                        },
                                        items: {
                                            infoDetailBtnIcon: {
                                                type: 7,
                                                bound: {
                                                    w: 48,
                                                    h: 48
                                                },
                                                position: {
                                                    x: 0,
                                                    y: 20
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            },
                                            infoDetailBtnText: {
                                                type: 6,
                                                bound: {
                                                    w: 300,
                                                    h: 48
                                                },
                                                innerPos: {
                                                    x: 0,
                                                    y: 0
                                                },
                                                noCache: true,
                                                value: "program detail",
                                                font: "28px SourceSansPro-Light",
                                                color: "0xFFFFFF",
                                                align: "right",
                                                position: {
                                                    x: 56,
                                                    y: 20
                                                },
                                                navigation: {
                                                    leftTo: null,
                                                    rightTo: null,
                                                    upTo: null,
                                                    downTo: null
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            },
            infoBarNTV: {
                type: 0,
                position: {
                    x: 50,
                    y: 20
                },
                items: {
                    ntv_img: {
                        type: 7,
                        bound: {
                            w: 570,
                            h: 190
                        },
                        position: {
                            x: -20,
                            y: -20
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    NTVIcon: {
                        type: 7,
                        bound: {
                            w: 60,
                            h: 60
                        },
                        position: {
                            x: 30,
                            y: 18
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    NTVText: {
                        type: 6,
                        bound: {
                            w: 330,
                            h: 62
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "HDMI",
                        font: "42px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "left",
                        position: {
                            x: 110,
                            y: 16
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    NTVLockImg: {
                        type: 7,
                        bound: {
                            w: 30,
                            h: 30
                        },
                        position: {
                            x: 400,
                            y: 30
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    MHLIcon: {
                        type: 7,
                        bound: {
                            w: 60,
                            h: 30
                        },
                        position: {
                            x: 440,
                            y: 30
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    NTVDPI: {
                        type: 6,
                        bound: {
                            w: 400,
                            h: 40
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        noCache: true,
                        value: "DPI",
                        font: "36px SourceSansPro-Light",
                        color: "0xFFFFFF",
                        align: "left",
                        position: {
                            x: 30,
                            y: 90
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            }
        }
    }
};


UI.moduleBuilder['liveTV']['liveTVCtrl'] = function(){
    /*default data*/
    var liveTVCtrlData = {
        num_bg: UI["liveTV_bg"],
        signal_img: (GLOBAL.LAUNCHER_BRAND == "his") ? "Screen/hisense_input_nosignal.png": "Screen/sharp_input_nosignal.png",
        signal_txt_screenSaverMode: "[SE3217]",
        signal_txt_screenSaverMode_hisense: "[SE3336]",
        signal_txt_screenSaverMode_sharp: "[SE3336]",
	sourceIcon: "liveTV/common/ic_nosignal_tips_cable.png",
        signal_img_SecondType: "liveTV/infobar/no_signal_bg.png",
        signal_img_SecondType2: "liveTV/infobar/no_signal_TV.png",
        signal_txt_SecondType: "[SE3217]",
        signal_txt_SecondType2: "[SE3218]\n[SE3230]",
        infoDetailBtnIcon: "EPG/epgMain/hotkey_epg_blue.png",
        infoDetailBtnText: "[SE1763]",
        tv_type_img: "liveTV/infobar/tv_type_bg.png",
        tv_right_img_1: UI["liveTV_bg"],
        tv_right_img_2: UI["liveTV_bg"],
        tv_left_img_1: UI["liveTV_bg"],
        tv_left_img_2: UI["liveTV_bg"],
        ntv_img: GLOBAL.IMAGE_LIST.INFO_BG_LEFT_NTV,
        chTSText: "",
        chFAVImg: GLOBAL.IMAGE_LIST.FAV30,
        chLockImg: GLOBAL.IMAGE_LIST.LOCK30,
        chEncryptImg: GLOBAL.IMAGE_LIST.ENCRYPT30,
        chNumP1: "",
        crntTime: "",
        chNameP1: "",
        crntPrgmNameP1: "",
        crntStartTime: "",
        crntEndTime: "",
        nextTimeDuration: "",
        nextPrgmNameP1: "",
        nextRmdrImgP1: GLOBAL.IMAGE_LIST.NONE,
        infoImg_Dolby: GLOBAL.IMAGE_LIST.DOLBY30,
        arrowRight: GLOBAL.IMAGE_LIST.ARROWRIGHT,
        arrowLeft: GLOBAL.IMAGE_LIST.ARROWLEFT,

        NTVIcon: GLOBAL.IMAGE_LIST.NONE,
        MHLIcon: GLOBAL.IMAGE_LIST.MHL60,
        NTVLockImg: GLOBAL.IMAGE_LIST.LOCK30
    };
    var infoGroupStr = ["DPI", "Aspect", "TVType", "HBBTV", "Rating", "CC", "SubT", "TTX", "SAP", "Dolby"];
    infoGroupStr.forEach(function (v) {
        liveTVCtrlData["infoSplit_" + v] = GLOBAL.IMAGE_LIST.SPLIT24;
        liveTVCtrlData["infoText_" + v] = "";
    });
    var numKeyMap = ["ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "SHORT_LINE"];
    var liveTVKeyMap = numKeyMap.concat([
        "UP", "LEFT", "DOWN", "RIGHT", "INFO",
        "BACKSPACE", "CH_LIST", "ENTER", "CC",
        "PLAY", "PAUSE", "STOP", "FAST_FWD", "FAST_BKW",
        "BLUE", "FAVCHANNEL","PRE_CH", "MTS", "NRT",'PLAYPAUSE'
    ]);
    var tunerMode = ["[SE0384]", "[SE0385]", "[SE0384]", "[SE0385]"];    //0"Antenna",1"Cable"
    var inputedNum = "", splitFlag = "-", reachMax, inputTimer, repeatTimes = 0;
    var template = Util.readJson("module/liveTV/liveTVCtrl.json");
    var liveTVCtrl = SubModule.create(liveTVCtrlData, template);
    liveTVCtrl.noAutoMemcControl = true;
    liveTVCtrl.alpha = 0;
    /*get the main container*/
    var infoDetailBtnIcon = UI.getItem(liveTVCtrl, "infoDetailBtnIcon");
    var infoDetailBtnText = UI.getItem(liveTVCtrl, "infoDetailBtnText");
    var numTip = UI.getItem(liveTVCtrl, "numTip"),
        TVTypeTip = UI.getItem(liveTVCtrl, "TVTypeTip"),
        signalTip = UI.getItem(liveTVCtrl, "signalTip"),
        signalTipSecondType = UI.getItem(liveTVCtrl, "signalTipSecondType"),
        defaultFocus = UI.getItem(liveTVCtrl, "defaultFocus"),
        infoBarTV = UI.getItem(liveTVCtrl, "infoBarTV"),
        infoBarNTV = UI.getItem(liveTVCtrl, "infoBarNTV"),
        infoBarP1 = UI.getItem(liveTVCtrl, "infoBarP1"),
        infoBarP2 = UI.getItem(liveTVCtrl, "infoBarP2"),
        sourceIcon = UI.getItem(liveTVCtrl, "sourceIcon"),
        sourceText = UI.getItem(liveTVCtrl, "sourceText");

    var TVP1Left = UI.getItem(infoBarP1, "infoBarP1Left"),
        TVP1Right = UI.getItem(infoBarP1, "infoBarP1Right"),
        TVP2Left = UI.getItem(infoBarP2, "infoBarP2Left"),
        TVP2Right = UI.getItem(infoBarP2, "infoBarP2Right");

    var UIElement = {
        chNumP1: UI.getItem(TVP1Left, "chNumP1"),
        chNameP1: UI.getItem(TVP1Left, "chNameP1"),
        crntTime: UI.getItem(TVP1Left, "crntTime"),
        chTSText: UI.getItem(TVP1Left, "chTSText"),
        chFAVImg: UI.getItem(TVP1Left, "chFAVImg"),
        chLockImg: UI.getItem(TVP1Left, "chLockImg"),
        chEncryptImg: UI.getItem(TVP1Left, "chEncryptImg"),

        crntPrgmNameP1: UI.getItem(TVP1Right, "crntPrgmNameP1"),
        crntStartTime: UI.getItem(TVP1Right, "crntStartTime"),
        crntProgress: UI.getItem(TVP1Right, "crntProgress"),
        crntEndTime: UI.getItem(TVP1Right, "crntEndTime"),
        nextTimeDuration: UI.getItem(TVP1Right, "nextTimeDuration"),
        nextPrgmNameP1: UI.getItem(TVP1Right, "nextPrgmNameP1"),
        nextRmdrImgP1: UI.getItem(TVP1Right, "nextRmdrImgP1"),
        infoGroup: UI.getItem(TVP1Right, "infoGroup"),
        crntLine: UI.getItem(TVP1Right, "crntLine"),
        nextLine: UI.getItem(TVP1Right, "nextLine"),

        chNameP2: UI.getItem(TVP2Left, "chNameP2"),
        sigLevel: UI.getItem(TVP2Left, "sigLevel"),
        sigQuality: UI.getItem(TVP2Left, "sigQuality"),
        crntPrgmNameP2: UI.getItem(TVP2Right, "crntPrgmNameP2"),
        crntPrgmDetailP2: UI.getItem(TVP2Right, "crntPrgmDetailP2"),

        NTVIcon: UI.getItem(infoBarNTV, "NTVIcon"),
        NTVText: UI.getItem(infoBarNTV, "NTVText"),
        MHLIcon: UI.getItem(infoBarNTV, "MHLIcon"),
        NTVDPI: UI.getItem(infoBarNTV, "NTVDPI"),
        NTVLockImg: UI.getItem(infoBarNTV, "NTVLockImg")
    };

    var signal_img_SecondType2 = UI.getItem(liveTVCtrl, "signal_img_SecondType2");
    var source_txt_SecondType = UI.getItem(liveTVCtrl, "source_txt_SecondType");
    var signal_txt_SecondType2 = UI.getItem(liveTVCtrl, "signal_txt_SecondType2");

    liveTVCtrl.currFocus = defaultFocus;

    liveTV.signalTip = signalTip;

    var signalTimer = 0, signalDelayTimer = 0, screenSaverAnimationTimer = 0, TVTypeTimer = 0, infoBarTimer = 0,
        powerOffCount = 0, openFlag = [], oprtData = {}, videoInfo = null,
        SAPTEXT = [/*"", */"[SE0828]", "[SE0453]", "[SE0827]"], firstLoad = true,
        defInterval = 5000, intervalOffset = 0, infoBarOpened = false, waitSourceChange = false;

    var pfResultNow = null; //todo 定义预制数据
    var pfResultNext = null;
    var videoFormatInfo = null;
    var videoFrameAspect = "";
    var CcExist = false;
    var audioFormatInfoP1 = "";
    var audioFormatInfoP2 = "";
    var audioFormatStr = null;
    var drawDelayFlag = false;   //延时画infobar右边标志
    var crntInfoPage = 0;
    var firstBootup = false;
    var screenSaverMode = false, signalEdge = {x: 0, y: 0};

    var displayElement = [infoBarTV, infoBarNTV, signalTip, signalTipSecondType, TVTypeTip, numTip];

    var audioISO639Map= getAudioList();

    Percent.create(UIElement.crntProgress, defaultFocus, 0);

    function resetLiveTVUI(inited) {
        signalTip.NO_SIGNAL = "[SE1368]";
        signalTip.LOCKED = "[TV0119]";
        signalTip.NOT_SUPPORTED = "[SE1396]";
        TVTypeTip.RADIO_CHANNEL = "[SE1946]";
        TVTypeTip.NO_SERVICE = "[SE0452]";
        signalTip.TOTAL_MINUTES = ("SA" == GLOBAL.CURRENT_AREA) ? 4 : 14;
        signalTip.SCREENSVER_PART1_MINUTES = 10;    //only NA
        clearOpenFlag();
        clearLiveTVUI();
        //if (inited) {
        //    showLiveTVUI();
        //    if (!liveTV.getInitedFlag() && Config.tv) {
        //        UI.registerKeyCodes(null);
        //        UI.setKeyGroup(7);
        //        UI.guiService.listen(1);
        //    }
        //}
    }

    function updateLiveTVUI(chnl, changeChannelFlag) {
        var crntChannel = chnl;
        if(!!changeChannelFlag) {
            pfResultNow = [];
            pfResultNext = [];
        }
        DBG_ERROR("updateLiveTVUI: current channel change");

        if (checkLiveTVState()) {
            drawDelayFlag = true;    //current singal chenge, 延时再画pf信息
        }

        if (!tv) {
            var dvbtime = parseInt(Date.now() / GLOBAL.MILLIBASE);

            setTimeout(function() {
//                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, null, [dvbtime - 1000, dvbtime + 2000, "1", "program name", "program detail", "TV-None"]);
//                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, null, [dvbtime + 2000, dvbtime + 4000, "1", "program name", "program detail", "TV-None"]);
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, null, ["", "", dvbtime - 1000, dvbtime + 2000, "program name", "short description", "long description", "feature flags", "PG12"]);
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, null, ["", "", dvbtime + 2000, dvbtime + 4000, "program name", "short description", "long description", "feature flags", "PG14"]);
            }, 4000);
            setTimeout(function() {
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.VIDEO_FORMAT_INFO_CHANGED, "730p,17:9");
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AUDIO_FORMAT_INFO_CHANGED, "1/4 eng Mono|ac3");
            }, 1000);

        }

        if ("base" == UI.getCurrModule().name) {
            //UI.pushSubModule("liveTV", "liveTVCtrl", true);
            //showLiveTVUI();
        }
        else if (checkLiveTVState()) {
            /*if (checkLiveTVState(LIVETV.PASSWORD_DIALOG)*//* && crntChannel.eCode != ECode.LOCK*//*) {
                UI.popSubModule();
                openLiveTVModule();
            }
            else {
                showLiveTVUI();
            }*/
            if(liveTV.repeatKey_CHUPDOWN_flag()){
                liveTV.drawShortInfo(chnl);
            }else{
                firstBootup = true;
                //showLiveTVUI();
            }
            showLiveTVUI(null,true);
        }
    }

    function openLiveTVSubModelNew(val, changeChlsuccessFlag) {
        DBG_INFO("openLiveTVSubModelNew start " + debugRunTime());
        DBG_ERROR("openLiveTVSubModelNew: signal val is " + val);

        if (GLOBAL.SOURCE_CHANGING) {
            DBG_ERROR("source changing, don't show livetv info");
            return;
        }

        if (checkHBBTVIsOn()){
            DBG_ERROR("checkHBBTVIsOn " + val);
            return;
        }
        if (checkLiveTVState(LIVETV.PASSWORD_DIALOG)) {
            if (val == SvrMsg.LOCKED_CH || val == SvrMsg.LOCKED_PROG || val == SvrMsg.LOCKED_INP) {
                DBG_ERROR("checkLiveTVState(LIVETV.PASSWORD_DIALOG): current page is LIVETV.PASSWORD_DIALOG" );
                return;
            }
            else {
                UI.popSubModule();
                UI.pushSubModule(LIVETV.MAIN, LIVETV.CONTROL, true);
            }
        }
        if (!checkLiveTVState(LIVETV.CONTROL)) {
            DBG_ERROR("currSubModule is not liveTVCtrl. It's " + (UI.getCurrSubModule() && UI.getCurrSubModule().name));
            return;
        }
        clearLiveTVUI(true);

        if (SourceList.TV != GLOBAL.CURRENT_SOURCE) {   //for TTS
            if (openFlag[Msg.INFO]) {
                openOtherInfo();
            }
        } else if (val != 0 && val != 1){
            if (openFlag[Msg.INFO]) {
                var crntChannel = liveTV.getCurrentChannelInfo();
                if (crntChannel.uid != 0) {
                    UI.callTTS("[SE0089] " + crntChannel.number + " " + crntChannel.name);
                }
            }
        }

        if (GLOBAL.CH_CHANED_ON_CHANNEL_LIST) {
            GLOBAL.CH_CHANED_ON_CHANNEL_LIST = false;
            if ((val == SvrMsg.EMPTY || val == SvrMsg.NO_SIGNAL) && openFlag[Msg.INFO]) {
                //will show infobar in switch below. Do nothing here
            }
            else {
                showInfoBar();
            }
        }

        switch (val) {
            case SvrMsg.EMPTY:
                if (openFlag[Msg.INFO]) {
                    showInfoBar(null, false, changeChlsuccessFlag);
                }
                break;
            case SvrMsg.NO_SIGNAL:
                if (openFlag[Msg.INFO]) {
                    showInfoBar(null, false, changeChlsuccessFlag);
                }
                if (openFlag[Msg.SIGNAL]) {
                    showSignalTip(signalTip.NO_SIGNAL);
                }
                break;
            case SvrMsg.SCAN_CH:
                break;
            case SvrMsg.GETTING_DATA:
                break;
            case SvrMsg.LOCKED_CH:
            case SvrMsg.LOCKED_PROG:
            case SvrMsg.LOCKED_INP:
                if (!liveTV.channelListInitFlag()) {
                    if (openFlag[Msg.PASSWORD]) {
                        UI.popSubModule();
                        UI.pushSubModule(LIVETV.MAIN, LIVETV.PASSWORD_DIALOG, true);
                    } else {
                        showSignalTip(signalTip.LOCKED);
                    }
                }
                else {
                    DBG_ERROR("initing list. Don't show passwordDialog");
                }
                break;
            case SvrMsg.NO_EVN_TILE:
                break;
            case SvrMsg.HIDDEN_CH:
                break;
            case SvrMsg.AUDIO_PROG:
                if (openFlag[Msg.AUDIO]) {
                    showTVTypeTip(TVTypeTip.RADIO_CHANNEL);
                }
                break;
            case SvrMsg.NO_EVN_DTIL:
                break;
            case SvrMsg.NO_CH_DTIL:
                break;
            case SvrMsg.NO_AUDIO_VIDEO:
                showTVTypeTip(TVTypeTip.NO_SIGNAL);
                break;
            case SvrMsg.NO_AUDIO_STRM:
            case SvrMsg.NO_VIDEO_STRM:
                showTVTypeTip(TVTypeTip.NO_SERVICE);
                break;
            case SvrMsg.PLS_WAIT:
                break;
            case SvrMsg.VIDEO_NOT_SUPPORT:
            case SvrMsg.HD_VIDEO_NOT_SUPPORT:
                showSignalTip(signalTip.NOT_SUPPORTED);
                break;
            case SvrMsg.NON_BRDCSTING:
                break;
            case SvrMsg.NO_CH_IN_LIST:
                break;
            case SvrMsg.TTX_SBTI_X_RATED_BLOCKED:
                break;
            case SvrMsg.SCRAMBLED:
                //todo 加密节目 欧洲才有
                break;
            case SvrMsg.NO_CHANNEL:
                if(getLiveTVSourceOpened() == "NOTOPEN") {
                    DBG_ERROR("user not set DefaultInput");
                    UI.popSubModule();
                    UI.pushSubModule("liveTV", "liveTVSource", true);
                    break;
                }
                if (!liveTV.channelListInitFlag() && SourceList.TV == GLOBAL.CURRENT_SOURCE && !liveTV.getHasChannelFlag()) {
                    if (openFlag[Msg.SEARCH]) {
                        UI.popSubModule();
                        UI.pushSubModule(LIVETV.MAIN, LIVETV.SEARCH_DIALOG, true);
                    }
                    else {
                        showSignalTip(signalTip.NO_SIGNAL);
                    }
                }
                break;
            case SvrMsg.LAST_VAILD_ENTRY:
                break;
        }
        DBG_INFO("openLiveTVSubModelNew end " + debugRunTime());
    }

    function liveTVSignalChanged(val) {
        DBG_ERROR("liveTVSignalChanged: signal val is " + val);

        GLOBAL.CURRENT_SVR_MSG = val;

        if (GLOBAL.SOURCE_CHANGING) {
            DBG_ERROR("source changing, don't show livetv info");
            return;
        }

        if (checkHBBTVIsOn()){
            DBG_ERROR("checkHBBTVIsOn " + val);
            return;
        }
        if (checkLiveTVState(LIVETV.PASSWORD_DIALOG)) {
            if (val == SvrMsg.LOCKED_CH || val == SvrMsg.LOCKED_PROG || val == SvrMsg.LOCKED_INP) {
                DBG_ERROR("checkLiveTVState(LIVETV.PASSWORD_DIALOG): current page is LIVETV.PASSWORD_DIALOG" );
                return;
            }
            else {
                UI.popSubModule();
                UI.pushSubModule(LIVETV.MAIN, LIVETV.CONTROL, true);
            }
        }
        if (!checkLiveTVState(LIVETV.CONTROL)) {
            DBG_ERROR("currSubModule is not liveTVCtrl. It's " + (UI.getCurrSubModule() && UI.getCurrSubModule().name));
            return;
        }
        clearLiveTVUI(true, (val == 1 && liveTV.showingNoSignalTip));
        
        switch (val) {
            case SvrMsg.EMPTY:
                break;
            case SvrMsg.NO_SIGNAL:
                if (openFlag[Msg.SIGNAL] && !liveTV.showingNoSignalTip) {
                    showSignalTip(signalTip.NO_SIGNAL);
                }
                break;
            case SvrMsg.SCAN_CH:
                break;
            case SvrMsg.GETTING_DATA:
                break;
            case SvrMsg.LOCKED_CH:
            case SvrMsg.LOCKED_PROG:
            case SvrMsg.LOCKED_INP:
                if (!liveTV.channelListInitFlag()) {
                    UI.popSubModule();
                    UI.pushSubModule(LIVETV.MAIN, LIVETV.PASSWORD_DIALOG, true);
                }
                else {
                    DBG_ERROR("initing list. Don't show passwordDialog");
                }
                break;
            case SvrMsg.NO_EVN_TILE:
                break;
            case SvrMsg.HIDDEN_CH:
                break;
            case SvrMsg.AUDIO_PROG:
                showTVTypeTip(TVTypeTip.RADIO_CHANNEL);
                break;
            case SvrMsg.NO_EVN_DTIL:
                break;
            case SvrMsg.NO_CH_DTIL:
                break;
            case SvrMsg.NO_AUDIO_VIDEO:
                showTVTypeTip(TVTypeTip.NO_SIGNAL);
                break;
            case SvrMsg.NO_AUDIO_STRM:
            case SvrMsg.NO_VIDEO_STRM:
                showTVTypeTip(TVTypeTip.NO_SERVICE);
                break;
            case SvrMsg.PLS_WAIT:
                break;
            case SvrMsg.VIDEO_NOT_SUPPORT:
            case SvrMsg.HD_VIDEO_NOT_SUPPORT:
                showSignalTip(signalTip.NOT_SUPPORTED);
                break;
            case SvrMsg.NON_BRDCSTING:
                break;
            case SvrMsg.NO_CH_IN_LIST:
                break;
            case SvrMsg.TTX_SBTI_X_RATED_BLOCKED:
                break;
            case SvrMsg.SCRAMBLED:
                //todo 加密节目 欧洲才有
                break;
            case SvrMsg.NO_CHANNEL:
                if(getLiveTVSourceOpened() == "NOTOPEN") {
                    DBG_ERROR("user not set DefaultInput");
                    UI.popSubModule();
                    UI.pushSubModule("liveTV", "liveTVSource", true);
                    break;
                }
                if (!liveTV.channelListInitFlag() && SourceList.TV == GLOBAL.CURRENT_SOURCE && !liveTV.getHasChannelFlag()) {
                    if (openFlag[Msg.SEARCH]) {
                        UI.popSubModule();
                        UI.pushSubModule(LIVETV.MAIN, LIVETV.SEARCH_DIALOG, true);
                    }
                    else {
                        showSignalTip(signalTip.NO_SIGNAL);
                    }
                }
                break;
            case SvrMsg.LAST_VAILD_ENTRY:
                break;
        }
    }

    function currentSourceChanged(uid) {
        DBG_INFO("currentSourceChanged: current source changed to " + uid + ", waitSourceChange is " + waitSourceChange);
        if (!checkLiveTVState(null) && !waitSourceChange) return;

        if (appControl.getCurrentAMState() == AMState.STOPPING) {
            DBG_ERROR("app stopping, don't show infobar");
            drawUIWhenSourceChange = false;
            return;
        }

        //DBG_TODO("show livetv again");
        waitSourceChange = false;

        //if (GLOBAL.CURRENT_SOURCE != SourceList.TV) {
            showLiveTVUI();
        //}
    }

    function inputNameChanged(val) {
        DBG_ERROR("input name changed: " + objToString(val));
        initAllInputsData();    //update GLOBAL.SOURCE_LIST
        var crntSourceObj = liveTV.getCurrentSourceObj();
        DBG_ERROR("crntSourceObj: " + objToString(crntSourceObj));
        if (crntSourceObj.id != SourceList.TV) {
            GLOBAL.S_NO_SIGNAL = (crntSourceObj.signal == SvrMsg.NO_SIGNAL);
            fetchSignalAndPublish();
        }
    }

    function tvSignalChanged(val) {
        DBG_ERROR("TV signal changed: " + val);
        if (GLOBAL.CURRENT_SOURCE == SourceList.TV) {
            GLOBAL.S_NO_SIGNAL = (val == SvrMsg.NO_SIGNAL);
            fetchSignalAndPublish();
        }
    }

    function onParentalLockPinRequest()
    {
        var pinRequest = liveTV.isParentalLockPinRequest();
        DBG_INFO("onParentalLockPinRequest: " + pinRequest);

        GLOBAL.S_LOCKING = !!pinRequest;
        fetchSignalAndPublish();
    }

    function onSourceVideoInfoChanged(val) {
        DBG_INFO("source video info changed: " + val);
        if (!val) return;
        if (SourceList.TV != GLOBAL.CURRENT_SOURCE && infoBarNTV.alpha != 0) {
            openOtherInfo(true);
        }
    }

    function onCecNotifyChangeSource(val) {
        DBG_ALWAYS("cec notify to change source[" + val + "]");
        try {
            if ((!!UI.getCurrSubModule() && UI.getCurrSubModule().protected)||GLOBAL.MEDIA_STARTUP_FLAG) {
                DBG_ALWAYS("current page is protected, do not receive update.");
                model.cec.setCecSourceChange(0);
                return;
            }
            if (Config.tv && 1 == model.channelSearch.getRunning()) {
                DBG_ALWAYS("channel searching, do not receive update.");
                model.cec.setCecSourceChange(0);
                return;
            }
            if(val!=1 && val!=2 && val!=3 && val!=4){
                DBG_ALWAYS("the target source if not exit  , return");
                model.cec.setCecSourceChange(0);
                return;
            }
            if (!!UI.getCurrSubModule() && UI.getCurrModule().name == "FTE") {
                DBG_ALWAYS("currModule is FTE, return");
                model.cec.setCecSourceChange(0);
                return;
            }

            var id = val + 3;
            changeSourceTo(id);
            UI.popAllModule();
            openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
            model.cec.setCecSourceChange(0);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onInputRenamed(actionId, val) {
        DBG_INFO("input[" + val[0] + "], renamed[" + val[1] + "]");
        var ret = objectFindByKey(GLOBAL.SOURCE_LIST, "id", val[0]);
        if (null != ret) {
            ret.rename = val[1];
        } else {
            DBG_ERROR("can not find source id [" + val[0] + "]");
        }
    }

    function onInputLockChanged(val) {
        DBG_ALWAYS("onCurrentInputLockChaged[" + val + "]");
        GLOBAL.LOCKED = getLockState(val);
        if (GLOBAL.LOCKED && checkLiveTVState(LIVETV.CONTROL)) {
            UI.popSubModule();
            UI.pushSubModule(LIVETV.MAIN, LIVETV.PASSWORD_DIALOG, true);
        } else if (!GLOBAL.LOCKED && checkLiveTVState(LIVETV.PASSWORD_DIALOG)) {
            UI.popSubModule();
            openLiveTVModule([Msg.PASSWORD, 0]);
        }
    }

    function setScreenSaverImage(idx) {
        try {
            if (screenSaverMode) {
                signalTip.children[1].alpha = 0;
                if(g_screenProtectPath.length == 0){
                    g_screenProtectPath = initScreenProtectPath();
                }
                var imagIndex = idx % (g_screenProtectPath.length - 1);
                setLiveTVImage(signalTip.children[0], g_screenProtectPath[imagIndex + 1]);

                signalTip.children[2].alpha = 0;
                signalTip.children[3].alpha = 0;
                signalTip.children[4].alpha = 0;
            }
            else {
                signalTip.children[1].alpha = 1;
                signalTip.children[2].alpha = 0;
                signalTip.children[3].alpha = 0;
                signalTip.children[4].alpha = 0;
            }
            var bnds = signalTip.children[0].getBounds();
            if (null == bnds) {
                signalEdge = {x: 250, y: 150};
            }
            else {
                signalEdge = {x: bnds.width, y: bnds.height};
            }
            //DBG_ERROR(signalEdge)
        }
        catch (ex) {
            signalEdge = {x: 250, y: 150};
            DBG_ERROR(ex.message);
        }
    }

    function _drawSignalTip() {
        if (/*!checkLiveTVState(LIVETV.CONTROL) ||*/ 2 == GLOBAL.TELETEXT_STATUS ||
            1 == GLOBAL.MHEG5_STATUS || checkHBBTVIsOn()) {
            hideSignalTip();
            DBG_ERROR("current state should hide nosignal.");
        }
        else {
            setScreenSaverImage(powerOffCount);

            if (screenSaverMode) {
                signalTip.x = 960;
                signalTip.y = 540;

                signalTip.alpha = 0;
                UI.getTween(signalTip).to({
                    alpha: 1
                }, 3000, UI.ease.linear).to({
                    alpha: 1
                }, 7000, UI.ease.linear).to({
                    alpha: 0
                }, 3000, UI.ease.linear);
            }
            else {
                signalTip.alpha = 1;
                signalTip.x = Math.max(parseInt(Math.random() * (1920 - signalEdge.x)), signalEdge.x);
                signalTip.y = Math.max(parseInt(Math.random() * (1080 - signalEdge.y)), signalEdge.y);
            }
            liveTVCtrlRefreshPage();
            powerOffCount++;
            if (powerOffCount >= signalTip.TOTAL_MINUTES * 60 / (screenSaverMode? 14: 1.5)) {
                hideSignalTip();
                onStandbyTipChanged(StandbyFlag.NO_SIGNAL);
            }
        }
    }

    function _drawSignalTipSecondStyle() {
        if (/*!checkLiveTVState(LIVETV.CONTROL) ||*/ 1 == GLOBAL.TELETEXT_STATUS ||
            1 == GLOBAL.MHEG5_STATUS || checkHBBTVIsOn()) {
            hideSignalTip();
            DBG_ERROR("current state should hide nosignal.");
        }
        else {
            var signalTipSecondTypeEdge = {x: 1597, y: 322};

            signalTipSecondType.alpha = 0;
            UI.getTween(signalTipSecondType).set({
                x: parseInt(signalTipSecondTypeEdge.x/2 + Math.random() * (1920 - signalTipSecondTypeEdge.x)),
                y: parseInt(signalTipSecondTypeEdge.y/2 + Math.random() * (1080 - signalTipSecondTypeEdge.y))
            }/*, 2500, UI.ease.quartOut*/).to({
                alpha: 1
            }, 2200, UI.ease.quartIn).to({
                alpha: 1
            }, 2000, UI.ease.quartOut).to({
                alpha: 0
            }, 2200, UI.ease.quartOut);
            liveTVCtrlRefreshPage();

            powerOffCount++;
            if (powerOffCount >= signalTip.TOTAL_MINUTES * 60 / 6) {
                if (!!UI.currModule && UI.currModule.name != LIVETV.MAIN) {
                    powerOffCount = 0;
                    return;
                }
                hideSignalTip();
                onStandbyTipChanged(StandbyFlag.NO_SIGNAL);
            }
        }
    }

    function initScreenProtectPath(){
        if(GLOBAL.UI_BRAND == "his"){
            return ["Screen/hisense_input_nosignal.png","Screen/his1.png","Screen/his2.png","Screen/his3.png","Screen/his4.png","Screen/his5.jpg"];
        } else if(GLOBAL.UI_BRAND == "tos") {
            return ["Screen/hisense_input_nosignal.png", "Screen/his1.png","Screen/his2.png","Screen/his3.png","Screen/his4.png"];
        } else {
            return ["Screen/sharp_input_nosignal.png","Screen/shp1.png","Screen/shp2.png","Screen/shp3.png","Screen/shp4.png","Screen/shp5.png"];
        }
    }
    g_screenProtectPath = initScreenProtectPath();

    function showSignalTip(tip) {
        clearInterval(signalTimer);
        clearTimeout(signalDelayTimer);
        clearTimeout(screenSaverAnimationTimer);
        screenSaverAnimationTimer = 0;
        powerOffCount = 0;
        if(g_screenProtectPath.length == 0){
            g_screenProtectPath = initScreenProtectPath();
        }
        screenSaverMode = (signalTip.NO_SIGNAL == tip &&
        null != g_screenProtectPath && g_screenProtectPath.length > 0 &&
        Config.tv && 1 == model.system.getScreenSaver()) || (!Config.tv && GLOBAL.SCREEN_SAVER);
        if(signalTip.NO_SIGNAL != tip ) {
            sourceIcon.alpha = 0;
            sourceText.alpha = 0;
        }

        if (signalTip.NO_SIGNAL != tip || screenSaverMode == true) {
            setLiveTVText(signalTip.children[1], screenSaverMode ? "" : tip);
            if (!screenSaverMode) {
                signalTip.children[0].width = 308;
                signalTip.children[0].height = 190;
                //UI.setImage(signalTip.children[0], UI.item_bg);
                setLiveTVImage(signalTip.children[0], "liveTV/infobar/signal_tip_bg.png");

                signalDelayTimer = setTimeout(function() {
                    signalTimer = setInterval(_drawSignalTip, screenSaverMode? 14000: 1500);
                    _drawSignalTip();
                    liveTVCtrlRefreshPage();
                }, 1000);
            }
            else {
                liveTV.showingNoSignalTip = true;
                signalTip.children[0].width = 1920;
                signalTip.children[0].height = 1080;
                signalTip.children[0].x = 960;
                signalTip.children[0].y = 540;

                signalTip.children[1].alpha = 0;
                signalTip.children[2].alpha = 0;
                signalTip.children[3].alpha = 0;
                signalTip.children[4].alpha = 0;

                if (CONST.PRELOADIMGS['liveTV']['livetvCtrl'].length > 0) {
                    while (CONST.PRELOADIMGS['liveTV']['livetvCtrl'].length > 0) {
                        var url = CONST.PRELOADIMGS['liveTV']['livetvCtrl'].pop();
                        PIXI.loader.add(themeDir + url, themeDir + url);
                    }
                    PIXI.loader.once('complete', function () {
                        DBG_ERROR("screenSaver image load complete");
                    });
                    PIXI.loader.load();
                }

                signalDelayTimer = setTimeout(function() {
                    drawForScreenSaverMode();
                }, 1000);
            }
        }
        else {  //no signal new style
            liveTV.showingNoSignalTip = true;
            var crntSrcObj = liveTV.getCurrentSourceObj();
            if (!crntSrcObj) {
                crntSrcObj = {};
                crntSrcObj.name = "TV"
            }
            if (SourceList.TV == GLOBAL.CURRENT_SOURCE) {
                UI.setText(signal_txt_SecondType2, "- [SE3218]\n\n- [SE3230]");
            }
            else {
                UI.setText(signal_txt_SecondType2, "\n- [SE3229]");
            }
            signalDelayTimer = setTimeout(function() {
                if (SourceList.TV == GLOBAL.CURRENT_SOURCE) {
                    UI.setImage(signal_img_SecondType2, "liveTV/infobar/no_signal_" + "TV" + ".png");
                }
                else {
                    UI.setImage(signal_img_SecondType2, "liveTV/infobar/no_signal_" + crntSrcObj.name.replace(" ", "").toUpperCase() + ".png");
                }

                setLiveTVText(source_txt_SecondType, crntSrcObj.rename);
                signalTimer = setInterval(_drawSignalTipSecondStyle, 6000);
                _drawSignalTipSecondStyle()
            }, 1000);
        }
    }

    function drawForScreenSaverMode() {
        hideSignalTip();
        liveTV.showingNoSignalTip = true;
        showNoSiganlForScreenSaverMode();
        clearTimeout(screenSaverAnimationTimer);
        screenSaverAnimationTimer = 0;
        screenSaverAnimationTimer = setTimeout(showAnimationForScreenSaverMode, signalTip.SCREENSVER_PART1_MINUTES * 60 * 1000)
    }

    function showNoSiganlForScreenSaverMode() {
        signalTip.x = 960;
        signalTip.y = 540;
        signalTip.children[2].alpha = 1;
        if (GLOBAL.LAUNCHER_BRAND == "his") {
            var tunnerTxt = "";
            sourceIcon.alpha = 1;
            sourceText.alpha = 1;
            if(GLOBAL.CURRENT_SOURCE == SourceList.TV) {
                try {
                    var scanType = tv ? model.channelSearch.getSource() : 0;
                    tunnerTxt = tunerMode[scanType % 15];
                } catch (ex) {
                    DBG_ERROR("tunerMode" + ex.message);
                    tunnerTxt = tunerMode[0];
                }
                UI.setImage(sourceIcon, "liveTV/common/ic_nosignal_tips_cable.png");
            } else {
                try {
                    var crntSrcObj = liveTV.getCurrentSourceObj();
                    tunnerTxt = crntSrcObj.name; //SourceList.ARRAY[crntSrcObj.innerId];
                    var imgUrl = GLOBAL.IMAGE_LIST[tunnerTxt + "_SIGNAL"]
                    if(!imgUrl) {
                        imgUrl = "";
                    }
                    UI.setImage(sourceIcon, imgUrl);
                } catch(ex) {
                    DBG_ERROR(" ERROR" + ex.message);
                }

            }
            UI.setText(sourceText, tunnerTxt);
            signalTip.children[2].y = 600 + 72/2;
            setLiveTVText(signalTip.children[3], GLOBAL.CURRENT_SOURCE == SourceList.TV? "[SE3336]": "[SE3869]");
            signalTip.children[3].alpha = 1;
            signalTip.children[4].alpha = 0;
        }
        else {
            sourceIcon.alpha = 0;
            sourceText.alpha = 0;
            signalTip.children[2].y = 384 + 72/2;
            signalTip.children[3].alpha = 0;
            setLiveTVText(signalTip.children[4], GLOBAL.CURRENT_SOURCE == SourceList.TV? "[SE3336]": "[SE3869]");
            signalTip.children[4].alpha = 1;
        }
        setLiveTVImage(signalTip.children[0], g_screenProtectPath[0]);
        signalTip.alpha = 1;
        liveTVCtrlRefreshPage();
        liveTVCtrlRefreshPage();
    }

    function showAnimationForScreenSaverMode() {
        powerOffCount = Math.ceil(signalTip.SCREENSVER_PART1_MINUTES * 60 / (screenSaverMode? 14: 1.5));
        signalTimer = setInterval(_drawSignalTip, screenSaverMode? 14000: 1500);
        sourceIcon.alpha = 0;
        sourceText.alpha = 0;
        _drawSignalTip();
        liveTVCtrlRefreshPage();
    }

    function hideSignalTip() {
        clearInterval(signalTimer);
        clearTimeout(signalDelayTimer);
        clearTimeout(screenSaverAnimationTimer);
        screenSaverAnimationTimer = 0;
        powerOffCount = 0;
        signalTip.alpha = 0;
        signalTipSecondType.alpha = 0;
        createjs.Tween.removeTweens(signalTip);
        createjs.Tween.removeTweens(signalTipSecondType);
        liveTV.showingNoSignalTip = false;
        liveTVCtrlRefreshPage();
    }

    function _drawTVTypeTip() {
        if (/*!checkLiveTVState(LIVETV.CONTROL) ||*/ 2 == GLOBAL.TELETEXT_STATUS ||
            1 == GLOBAL.MHEG5_STATUS || checkHBBTVIsOn()) {
            hideTVTypeTip();
            DBG_ERROR("current state should hide tvtype.");
        }
        else {
            TVTypeTip.alpha = 1;
            liveTVCtrlRefreshPage();
        }
    }

    function showTVTypeTip(tip) {
        clearInterval(TVTypeTimer);
        setLiveTVText(TVTypeTip.children[1], tip);
        TVTypeTimer = setTimeout(_drawTVTypeTip, 2000);
    }

    function hideTVTypeTip() {
        clearInterval(TVTypeTimer);
        TVTypeTip.alpha = 0;
        liveTVCtrlRefreshPage();
    }

    function clearOpenFlag() {
        var i = 0;
        while (i < Msg.MAX_COUNT) openFlag[i++] = 1;
    }

    function clearLiveTVUI(keepInfoBar, keepSignalTip) {
        numTip.alpha = 0;
        TVTypeTip.alpha = 0;
        if (!keepSignalTip) {
            signalTip.alpha = 0;
            signalTipSecondType.alpha = 0;
            createjs.Tween.removeTweens(signalTip);
            createjs.Tween.removeTweens(signalTipSecondType);
            powerOffCount = 0;
            clearInterval(signalTimer);
            clearTimeout(signalDelayTimer);
            clearTimeout(screenSaverAnimationTimer);
            screenSaverAnimationTimer = 0;
            liveTV.showingNoSignalTip = false;
        }
        defaultFocus.alpha = 0;
        clearInterval(TVTypeTimer);
        inputedNum = "";
        repeatTimes = 0;
        reachMax = false;
        setLiveTVText(numTip.children[1], "");
        if (!keepInfoBar) {
            hideInfoBar();
        }
        else {
            liveTVCtrlRefreshPage();
        }
    }

    function getLockState(v) {
        var lockState = false, crntChannel = liveTV.getCurrentChannelInfo();
        try {
            DBG_INFO("lock mode " + GLOBAL.PARENTAL_LOCK_SWITCH + ", unlocked[" + GLOBAL.UNLOCKED + "]");
            if (0 == GLOBAL.PARENTAL_LOCK_SWITCH || GLOBAL.UNLOCKED) {
                return lockState;
            }
            //TV
            lockState = GLOBAL.CURRENT_SOURCE == SourceList.TV && crntChannel.eCode == ECode.LOCK;
            //Other
            var isSrcLock = Config.tv ? (1 == model.source.getInputCurrentInLock()) : 1 == v;
            var lockTime = Config.tv ? (1 == model.source.getCurrentTimeInLock()) : 1 == v;
            DBG_INFO("Ecode[" + crntChannel.eCode + "], lock state[" + isSrcLock + "], lock time [" + lockTime + "]");
            lockState = lockState || (isSrcLock && lockTime);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
        return lockState;
    }

    function showLiveTVUI(onPushFlag,changeChlsuccessFlag) {
        DBG_INFO("showLiveTVUI start " + debugRunTime());
        try {
            if (waitSourceChange) {
                DBG_WARN("wait source changed notify.");
                return;
            }

            if(!!UI.getCurrSubModule() && UI.getCurrSubModule().name == LIVETV.OPERATE_TIP) {
                DBG_WARN("OPERATE_TIP ON");
                return;
            }

            var crntChannel = liveTV.getCurrentChannelInfo();
            DBG_ALWAYS("liveTV opened.");
            if (liveTV.checkOperateTip()) {
                if(UI.isLoadingModule) {
                    DBG_ERROR("isLoadingModule ...");
                    return;
                }
                liveTV.setFirstPlayFlag(false);
                UI.popSubModule();
                UI.pushSubModule(LIVETV.MAIN, LIVETV.OPERATE_TIP, true);
                UI.eatKey = true;
            }
            else
			{
                var parentLock = false;
                if(!!onPushFlag) {
                    var pinRequest = liveTV.isParentalLockPinRequest();
                    parentLock = !!pinRequest;
                    DBG_INFO("showLiveTVUI LockPinRequest: " + pinRequest);
                }
                if(!parentLock) {
                openLiveTVSubModelNew(GLOBAL.CURRENT_SVR_MSG, changeChlsuccessFlag);
                }
            }
            clearOpenFlag();
        } catch (e) {
            DBG_ERROR(e.stack);
        }
        DBG_INFO("showLiveTVUI end " + debugRunTime());
    }

    /*-------------------Info bar-------------------*/
    function onVideoFormatChanged(val) {
        if (GLOBAL.CURRENT_SOURCE == SourceList.TV) return;
        DBG_ALWAYS("current source video format changed[" + val + "]");
        if (checkLiveTVState() && !!val && !videoInfo) {
            showInfoBar();
        }
        //GLOBAL.NOT_SUPPORTED
    }

    function showInfoBar(keycode, ttsChannelInfo, changeChlsuccessFlag) {
        DBG_INFO("showInfoBar  start " + debugRunTime());
        tv &&model.message.setOsdVisible(1);  //dbtag;20161215 --rick
        var crntChannel = liveTV.getCurrentChannelInfo();
        DBG_INFO("showInfoBar crntChannel is " + objToString(crntChannel));
        DBG_INFO("GLOBAL.CURRENT_SOURCE is " + GLOBAL.CURRENT_SOURCE);
        if (GLOBAL.CURRENT_SOURCE == SourceList.TV) {
            if (!liveTV.getHasChannelFlag()) {
                DBG_ERROR("do not have chanels, show simple TV info");
                infoBarOpened = true;
                openInfoForTVWithoutChannels();
                return;
            }
            if (!crntChannel || !crntChannel.uid || 0 == crntChannel.uid || 256 == crntChannel.listUid ||
                (checkHBBTVIsOn() && keycode != "INFO")) return false;
            infoBarOpened = true;
            openTVInfo(changeChlsuccessFlag);
            if (ttsChannelInfo) {
                UI.callTTS(UI.setString("[SE1335]  [SE0089] " + crntChannel.number + " " + oprtData.crntName));
            }
            else {
                UI.callTTS("[SE0089] " + crntChannel.number + " " + crntChannel.name);
            }
        }
        else {
            infoBarOpened = true;
            openOtherInfo();
        }
        crntInfoPage = 0;
        DBG_INFO("showInfoBar  end " + debugRunTime());
    }
    liveTV.showInfoBar = showInfoBar;

    function hideInfoBar() {
        tv && model.message.setOsdVisible(0); //dbtag:20161215 --rick
        clearTimeout(infoBarTimer);
        oprtData.pfInd = 0;
        intervalOffset = 0;
        infoBarNTV.alpha = infoBarTV.alpha = 0;
        TVP1Left.alpha = TVP1Right.alpha = TVP2Left.alpha = TVP2Right.alpha = 0;
        UIElement.crntTime.alpha = UIElement.crntStartTime.alpha =
            UIElement.crntEndTime.alpha = UIElement.nextTimeDuration.alpha =
                UIElement.nextPrgmNameP1.alpha = UIElement.crntPrgmDetailP2.alpha = 0.6;
        UIElement.NTVDPI.alpha = 0.6;
        //UIElement.crntStartTime._bounds = null;
        //UIElement.crntEndTime._bounds = null;
        //UIElement.nextTimeDuration._bounds = null;
        //UIElement.nextPrgmNameP1._bounds = null;
        clearInfoBarGroup();
        infoBarTV.x = 1940;

        infoBarOpened = false;
        liveTVCtrlRefreshPage();
        DBG_ERROR("infobar hidden")
    }

    function timeoutHideInfoBar(interval) {
        clearTimeout(infoBarTimer);
        infoBarTimer = setTimeout(hideInfoBar, interval + intervalOffset);
    }

    function isHideAll(arr) {
        if (!arr || !Array.isArray(arr)) return;
        for (var i = 0; i < arr.length; i++) {
            if (arr[i].alpha != 0) {
                return false;
            }
        }
        return true;
    }

    function liveTVCtrlRefreshPage() {
        if (isHideAll(displayElement) && checkLiveTVState(LIVETV.CONTROL)) {
            UI.setOsdShowType(0);
        }
        else {
            UI.setOsdShowType(1);
        }
        UI.updateStage();
    }

    /*draw the left info bar of the first page*/
    function drawTVLeftP1(noTime) {
        setLiveTVText(UIElement.chNumP1, oprtData.number, true);
        setLiveTVText(UIElement.chNameP1, oprtData.name);
        setLiveTVText(UIElement.chTSText, oprtData.TS, true);
        if (noTime) {
            setLiveTVText(UIElement.crntTime, "");
        }
        else {
            var sysTime = getSystemTime();
            setLiveTVText(UIElement.crntTime, sysTime.format_time + " " + sysTime.date);
 
        }
        UIElement.chEncryptImg.alpha = oprtData.attrs[1];
        UIElement.chFAVImg.alpha = oprtData.attrs[2];
        UIElement.chLockImg.alpha = oprtData.attrs[3];
        TVP1Left.alpha = 1;
        infoBarTV.x = 1940;
        adjustChannelInfoPos();
        liveTVCtrlRefreshPage();
        timeoutHideInfoBar(defInterval);
    }

    /*draw the right info bar of the first and second page*/
    function drawTVRightP1P2(changeChlsuccessFlag) {
        DBG_INFO("drawTVRightP1P2:   "+changeChlsuccessFlag);
        if (!infoBarOpened) {
            DBG_ERROR("info bar is not open, audioFormatStr=" + audioFormatStr);
	    if (!!changeChlsuccessFlag && checkLiveTVState(LIVETV.CONTROL)) {
                liveTV.remoteAppFunc("drawTVRightP1P2");
            }
            return;
        }

        var crntChannel = liveTV.getCurrentChannelInfo();
        if (crntChannel.type != CONST.ATV) {
            if (!!audioFormatStr && !!audioFormatStr[0]) {
                if (audioFormatStr[0].toLowerCase().match("ac3") || audioFormatStr[0].toLowerCase().match("dolby")) {
                    oprtData.modeGroup[GroupTip.DOLBY] = 1
                }
                else {
                    oprtData.modeGroup[GroupTip.DOLBY] = (audioFormatStr[0] == "Not Available") ? "":audioFormatStr[0];
                }
            }

            oprtData.modeGroup[GroupTip.SUBT] = "";
            if (!!audioFormatInfoP1) {
                oprtData.modeGroup[GroupTip.SUBT] = audioFormatInfoP1;
            }
            audioFormatInfoP2 = !!audioFormatStr && audioFormatStr[1];
            if (!!audioFormatInfoP2) {
                if (!!oprtData.modeGroup[GroupTip.SUBT]) {
                    oprtData.modeGroup[GroupTip.SUBT] += " " + audioFormatInfoP2;
                }
                else {
                    oprtData.modeGroup[GroupTip.SUBT] +=  audioFormatInfoP2;
                }
            }
        }

        if (!!pfResultNow) {
            if (!GLOBAL.S_LOCKING) {
                oprtData.crntStart = !!pfResultNow[TvserviceModel.EIT_FIELD_START_TIME_UTC] ? parseInt(pfResultNow[TvserviceModel.EIT_FIELD_START_TIME_UTC]) : 0;
                oprtData.crntEnd = !!pfResultNow[TvserviceModel.EIT_FIELD_STOP_TIME_UTC] ? parseInt(pfResultNow[TvserviceModel.EIT_FIELD_STOP_TIME_UTC]) : 0;
                oprtData.crntName = filterUnicaode(!!pfResultNow[TvserviceModel.EIT_FIELD_TITLE] ? pfResultNow[TvserviceModel.EIT_FIELD_TITLE] : "[TV0009]");
                oprtData.detailInfo = filterUnicaode(!!pfResultNow[TvserviceModel.EIT_FIELD_LONG_DESCRIPTION] ? pfResultNow[TvserviceModel.EIT_FIELD_LONG_DESCRIPTION] : "[SE2734]");
                oprtData.modeGroup[GroupTip.RATING] = pfResultNow[TvserviceModel.EIT_FIELD_PARENTAL_RATING];
                oprtData.modeGroup[GroupTip.HBBTV] = "";//NA don't have hbbtv
            }
            else {
                oprtData.crntStart = 0;
                oprtData.crntEnd = 0;
                oprtData.crntName = "[TV0009]";
                oprtData.detailInfo = "[SE2734]";
                oprtData.modeGroup[GroupTip.RATING] = pfResultNow[TvserviceModel.EIT_FIELD_PARENTAL_RATING];
            }
        }

        if (!!pfResultNext) {
            if (!GLOBAL.S_LOCKING) {
                oprtData.nxtStart = !!pfResultNext[TvserviceModel.EIT_FIELD_START_TIME_UTC] ? parseInt(pfResultNext[TvserviceModel.EIT_FIELD_START_TIME_UTC]) : 0;
                oprtData.nxtEnd = !!pfResultNext[TvserviceModel.EIT_FIELD_STOP_TIME_UTC] ? parseInt(pfResultNext[TvserviceModel.EIT_FIELD_STOP_TIME_UTC]) : 0;
                oprtData.nxtName = filterUnicaode(!!pfResultNext[TvserviceModel.EIT_FIELD_TITLE] ? pfResultNext[TvserviceModel.EIT_FIELD_TITLE] : "[TV0009]");
            }
            else {
                oprtData.nxtStart = 0;
                oprtData.nxtEnd = 0;
                oprtData.nxtName = "[TV0009]";
            }
        }

        setLiveTVText(UIElement.crntPrgmNameP1, oprtData.crntName);
        if (0 != oprtData.crntStart) {
            setLiveTVText(UIElement.crntStartTime, getProgramLocalTime(oprtData.crntStart, 0, 3, null), true);
            setLiveTVText(UIElement.crntEndTime, getProgramLocalTime(oprtData.crntEnd, 0, 3, null), true);
            var crntTime = getDVBLongTime();
            UIElement.crntProgress.setPercentNoVoice(calculatePercent(oprtData.crntStart, crntTime, oprtData.crntEnd));
            //Percent.create(UIElement.crntProgress, defaultFocus, 50);
            refreshInfoBarView([UIElement.crntStartTime, UIElement.crntProgress, UIElement.crntEndTime]);
            UIElement.crntLine.alpha = 1;
        }
        else {
            UIElement.crntLine.alpha = 0;
        }

        if (0 != oprtData.nxtStart) {
            setLiveTVText(UIElement.nextTimeDuration, getProgramLocalTime(oprtData.nxtStart, oprtData.nxtEnd, 4, null), true);
            setLiveTVText(UIElement.nextPrgmNameP1, oprtData.nxtName);
            //UI.setImage(UIElement.nextRmdrImgP1, getReminderImg());
            setLiveTVImage(UIElement.nextRmdrImgP1, getReminderImg());
            refreshInfoBarView([UIElement.nextTimeDuration, UIElement.nextPrgmNameP1, UIElement.nextRmdrImgP1]);
            UIElement.nextLine.alpha = 1;
        }
        else {
            UIElement.nextLine.alpha = 0;
        }

        setInfoBarGroup();
        /*second page*/
        setLiveTVText(UIElement.chNameP2, oprtData.name);
        setLiveTVText(UIElement.crntPrgmNameP2, oprtData.crntName);
        setLiveTVText(UIElement.crntPrgmDetailP2, oprtData.detailInfo);
        infoDetailBtnIcon.x = 356 -  infoDetailBtnText.children[0].getBounds().width - infoDetailBtnIcon.children[0].getBounds().width / 2 - 12;
        oprtData.signalLevel = tv ? model.tvservice.getSignalMainLevels() : "10";
        oprtData.signalQuality = tv ? model.tvservice.getSignalMainCns() : "10";
        DBG_ERROR("signalLevel is " + objToString(oprtData.signalLevel));

        setLiveTVText(UIElement.sigLevel, Config.language["SE0122"] + ": " + oprtData.signalLevel[TvserviceModel.TUNERINFO_SIGNAL_PERCENTAGE] + "%");
        setLiveTVText(UIElement.sigQuality, Config.language["SE0121"] + ": " + oprtData.signalQuality[TvserviceModel.TUNERINFO_SIGNAL_PERCENTAGE] + "%");

        TVP1Right.alpha = TVP2Left.alpha = TVP2Right.alpha = 1;
        UIElement.sigLevel.alpha = (0 == oprtData.signalLevel[0]) ? 0 : 0.6;
        UIElement.sigQuality.alpha = (0 == oprtData.signalQuality[0]) ? 0 : 0.6;
        liveTVCtrlRefreshPage();
        if (!!changeChlsuccessFlag) {
            liveTV.remoteAppFunc("drawTVRightP1P2");
        }
        liveTVCtrlRefreshPage();
        //timeoutHideInfoBar(defInterval);

        drawDelayFlag = false;   //置为假，画infobar不延时
    }

    liveTV.drawShortInfo = function (chnl) {
        if (!chnl) return;
        if (!checkLiveTVState(LIVETV.CONTROL)) return;
        initInfoBarData(chnl);
        infoBarTV.alpha = 1;
        infoBarOpened = true;
        drawTVLeftP1(true);
    }

    /*auto float left*/
    function refreshInfoBarView(targets) {
        if (targets.length < 2) return;
        var bnds, base = 0;
        for (var i = 0; i < targets.length; i++) {
            bnds = targets[i].getBounds();
            targets[i].pivot.x = bnds.width / 2;
            targets[i].x = base + targets[i].pivot.x;
            base = targets[i].x + targets[i].pivot.x + 20;
        }
    }

    function adjustChannelInfoPos() {
        try {
            //UIElement.chNumP1._bounds = null;
            //UIElement.chTSText._bounds = null;
            var bnds, baseWidth = 510, minX;

            bnds = UIElement.chNumP1.getBounds();
	    if (!bnds)
                DBG_INFO("chNumP1 bnds is null");
            minX = parseInt(bnds.width + 150);

            bnds = UIElement.chTSText.getBounds();
            if (!bnds)
                DBG_INFO("chTSText bnds is null");
            UIElement.chTSText.pivot.x = parseInt(bnds.width / 2);
            UIElement.chTSText.x = baseWidth - UIElement.chTSText.pivot.x;

            if (UIElement.chTSText.x - UIElement.chTSText.pivot.x < minX) {
                UIElement.chTSText.x = UIElement.chTSText.pivot.x + minX;
            }
            UIElement.chLockImg.x = UIElement.chTSText.x - UIElement.chTSText.pivot.x - 36;
            UIElement.chFAVImg.x = UIElement.chLockImg.x - UIElement.chLockImg.pivot.x * 2 - 12;
            UIElement.chEncryptImg.x = UIElement.chFAVImg.x - UIElement.chFAVImg.pivot.x * 2 - 12;
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function getReminderImg() {
        if (oprtData.nxtReminde) return GLOBAL.IMAGE_LIST.REMINDER30;
        if (oprtData.nxtRecord) return GLOBAL.IMAGE_LIST.RECORD30;
        return GLOBAL.IMAGE_LIST.NONE;
    }

    function clearVideoInfo() {
        DBG_ERROR("clear video audio info");
        videoFrameAspect = "";
        CcExist = 0;
        audioFormatInfoP1 = "";
        audioFormatInfoP2 = "";
        audioFormatStr = null;
    }
    liveTV.clearVideoInfo = clearVideoInfo;

    function resetOperateData() {
        oprtData.pfInd = 0;
        oprtData.number = '';
        oprtData.attrs = [0, 0, 0, 0];//new Array(4);
        oprtData.name = '';
        oprtData.crntStart = 0;
        oprtData.crntEnd = 0;
        oprtData.crntName = '[TV0009]';
        oprtData.nxtStart = 0;
        oprtData.nxtEnd = 0;
        oprtData.nxtName = '[TV0009]';
        oprtData.nxtRecord = !Config.tv;
        oprtData.nxtReminde = !Config.tv;
        oprtData.modeGroup = new Array(14);
        for (var i = 0; i < 14; i++) oprtData.modeGroup[i] = "";
        oprtData.signalLevel = -1;
        oprtData.signalQuality = -1;
        oprtData.detailInfo = '[SE2734]';
        oprtData.guidance = "";
        oprtData.TS = "";
    }

    function initInfoBarData(chInfo) {
        resetOperateData();
        if (null == chInfo) return;
        oprtData.number = chInfo.number;
        oprtData.name = chInfo.name;
        oprtData.channelUid = chInfo.uid;
        oprtData.playId = chInfo.playId;
        oprtData.TS = (
            chInfo.listUid == 6 ? "[SE0384]" :
                chInfo.listUid == 7 ? "[SE0385]" :
                    chInfo.listUid == 5 ? "[SE0386]" : "");  // imgList.signallevel4;
        chInfo.isEncrypt && (oprtData.attrs[1] = 1);
        chInfo.favType && (oprtData.attrs[2] = 1);
        GLOBAL.PARENTAL_LOCK_SWITCH && chInfo.isLock && (oprtData.attrs[3] = 1);
        oprtData.modeGroup[GroupTip.TVTYPE] = (CONST.ATV == chInfo.type ? "[SE0097]" : "[SE0098]");
        oprtData.modeGroup[GroupTip.ASPECT] = (CONST.ATV == chInfo.type ? "" : "");

    }

    function setVideoAudioInfo(tvtype) {
        DBG_INFO("setVideoAudioInfo tvtype is " + tvtype);
        if (CONST.ATV == tvtype) {
            if ("SA" == GLOBAL.CURRENT_AREA || "NA" == GLOBAL.CURRENT_AREA || "COL" == GLOBAL.CURRENT_AREA) {
                var sap = Config.tv ? model.sound.getSap() : "1";
                DBG_INFO("sap[" + objToString(sap) + "]");
                oprtData.modeGroup[GroupTip.SAP] = SAPTEXT[sap];
            }
            else {
                var sapArr = Config.tv ? model.system.getATVAudioTrackList() : [];
                if (sapArr.length == 0) {
                    oprtData.modeGroup[GroupTip.SAP] = "";
                }
                else if (sapArr.length == 1) {
                    oprtData.modeGroup[GroupTip.SAP] = "[SE0828]";
                }
                else {
                    sapArr = ["[SE0828]", "[SE1947]", "[SE1948]", "[SE0453]"];
                    var sapIdx = Config.tv ? parseInt(model.system.getATVAudioTrackSelect()) : 0;
                    oprtData.modeGroup[GroupTip.SAP] = sapArr[sapIdx];
                }
            }
        }
        DBG_INFO("video info : "+ videoFormatInfo + ", Frame Aspect: " + videoFrameAspect + ", audio info: " + "");

        if(!!videoFormatInfo/*videoFormatInfo != ""*/)
        {
             var resolution = videoFormatInfo.split("/")[0];
             var vheight = resolution.split("*")[1];
        }
        oprtData.modeGroup[GroupTip.DPI] = vheight;
        oprtData.modeGroup[GroupTip.ASPECT] = videoFrameAspect;
        oprtData.modeGroup[GroupTip.CC] = (1 == CcExist) ? "[SE2410]" : "";


    }

    function onGetVideoFormatInfoResult(result) {
        DBG_ALWAYS("Video format info: " + objToString(result));
        if (-1 != result) {
            videoFormatInfo = result;
        }
        var crntChannel = liveTV.getCurrentChannelInfo();
        if (CONST.ATV == crntChannel.type) {
            setVideoAudioInfo(CONST.ATV);
        }
        else {
            setVideoAudioInfo(CONST.DTV);
        }
        drawTVRightP1P2();
    }

    function onVideoFormatChanged(val) {
        DBG_ALWAYS("Video format info: " + val);
        videoFormatInfo = val;
        var crntChannel = liveTV.getCurrentChannelInfo();
         if (CONST.ATV == crntChannel.type) {
            setVideoAudioInfo(CONST.ATV);
        }
        else {
            setVideoAudioInfo(CONST.DTV);
        }
        drawTVRightP1P2();
    }

    function onVideoFrameAspectChanged(val) {
        DBG_ALWAYS("Video frame aspect info: " + val);
        videoFrameAspect = val;
        var crntChannel = liveTV.getCurrentChannelInfo();
        if (CONST.ATV == crntChannel.type) {
            setVideoAudioInfo(CONST.ATV);
        }
        else {
            setVideoAudioInfo(CONST.DTV);
        }
        drawTVRightP1P2();
    }

    function onVideoCcExistChanged(val) {
        DBG_ALWAYS("Video Closed caption  Exist: " + val);
        CcExist = val;
        var crntChannel = liveTV.getCurrentChannelInfo();
        if (CONST.ATV == crntChannel.type) {
            setVideoAudioInfo(CONST.ATV);
        }
        else {
            setVideoAudioInfo(CONST.DTV);
        }
        drawTVRightP1P2();
    }

//    function onGetAudioFormatInfoResult(result) {
//        DBG_ALWAYS("Audio format info: " + objToString(result));
//        if (-1 != result) {
//            audioFormatInfo = result;
//        }
//        var crntChannel = liveTV.getCurrentChannelInfo();
//        if (CONST.ATV == crntChannel.type) {
//            setVideoAudioInfo(CONST.ATV);
//        }
//        else {
//            setVideoAudioInfo(CONST.DTV);
//        }
//        drawTVRightP1P2();
//    }

    function onGetNowPfResult(actionId, result) {
        DBG_ERROR("pf info now: " + objToString(result));
        if (-1 != result) {
            pfResultNow = result;
            /*oprtData.crntStart = !!result[Pf.START_TIME] ? parseInt(result[Pf.START_TIME]) : 0;
            oprtData.crntEnd = !!result[Pf.END_TIME] ? parseInt(result[Pf.END_TIME]) : 0;
            oprtData.crntName = filterUnicaode(!!result[Pf.TITLE] ? result[Pf.TITLE] : "[TV0009]");
            oprtData.detailInfo = filterUnicaode(!!result[Pf.DETAIL] ? result[Pf.DETAIL] : "[SE2734]");
            oprtData.modeGroup[GroupTip.RATING] = result[Pf.RATING];
            oprtData.modeGroup[GroupTip.HBBTV] = checkHBBTVIsOn() ? "HbbTV" : "";
            if ("NA" == GLOBAL.CURRENT_AREA || "SA" == GLOBAL.CURRENT_AREA) {
                oprtData.modeGroup[GroupTip.CC] = (1 == result[Pf.CC]) ? "[SE2410]" : "";
            }
            else {
                oprtData.modeGroup[GroupTip.CC] = (1 == result[Pf.CC]) ? "[SE0381]" : "";
            }*/
        }
        if (++oprtData.pfInd >= 2) drawTVRightP1P2(true);
    }

    function onGetNextPfResult(actionId, result) {
        DBG_ERROR("pf info next: " + objToString(result));
        if (-1 != result) {
            pfResultNext = result;
            /*oprtData.nxtStart = !!result[Pf.START_TIME] ? parseInt(result[Pf.START_TIME]) : 0;
            oprtData.nxtEnd = !!result[Pf.END_TIME] ? parseInt(result[Pf.END_TIME]) : 0;
            oprtData.nxtName = filterUnicaode(!!result[Pf.TITLE] ? result[Pf.TITLE] : "[TV0009]");*/
        }
        if (++oprtData.pfInd >= 2) drawTVRightP1P2(true);
    }

    function onEitNowChanged(val){
        DBG_ERROR(" Present change info :" + objToString(val));
        pfResultNow = val;
        drawTVRightP1P2(true);
    }

    function onEitNextChanged(val){
        DBG_ALWAYS(" Following change info :" + objToString(val));
        pfResultNext = val;
        drawTVRightP1P2(true);
    }

    function onCurAudioExistChaged(val){
        DBG_ALWAYS(" Present AudioExist info :" + objToString(val));
        /*if(val ==1 )
        {
            liveTV.readAudioTableInfo(ui_getAudioTableInfo);
        }*/
    }

    function onAudioLanguageInfoChanged(val) {
        try {
            DBG_ERROR("onAudioLanguageInfoChanged: " + val);
            if (!val) return;

            var crntChannel = liveTV.getCurrentChannelInfo();
            if (CONST.DTV == crntChannel.type) {
                var AudioLanguageInfo = JSON.parse(val);
                var audioInfoList = !!AudioLanguageInfo ? AudioLanguageInfo.AudioLanguageInfo : [];
                var crntAudioIndex = model.tvservice.getAudioIndex();
                DBG_ERROR("crntAudioIndex: " + crntAudioIndex);
                var crntAudioInfo = objectFindByKey(audioInfoList, "audioIndex", crntAudioIndex);
                if (!!crntAudioInfo) {
                    var target = objectFindByKey(audioISO639Map, "value", crntAudioInfo.audioIso639);
                    if (!!target) {
                        audioFormatInfoP1 = target.text;
                        if (audioInfoList.length > 1) {
                            audioFormatInfoP1 = (crntAudioIndex + 1) + "/" + audioInfoList.length + " " + audioFormatInfoP1;
                        }
                        drawTVRightP1P2();
                    }
                }
            }
        }
        catch (ex) {
            DBG_ERROR("onAudioLanguageInfoChanged: " + ex.message);
        }

    }

    function onAudioIndexChanged(val) {
        try {
            DBG_ERROR("onAudioIndexChanged: " + val);
            if (val < 0) return;

            var crntChannel = liveTV.getCurrentChannelInfo();
            if(CONST.DTV == crntChannel.type) {
                var AudioLanguageInfo = JSON.parse(model.tvservice.getAudioLanguageInfo());
                var audioInfoList = !!AudioLanguageInfo ? AudioLanguageInfo.AudioLanguageInfo : [];
                var crntAudioInfo = objectFindByKey(audioInfoList, "audioIndex", val);
                DBG_ERROR("crntAudioInfo: " + objToString(crntAudioInfo));
                if (!!crntAudioInfo) {
                    var target = objectFindByKey(audioISO639Map, "value", crntAudioInfo.audioIso639);
                    if (!!target) {
                        audioFormatInfoP1 = target.text;
                        if (audioInfoList.length > 1) {
                            audioFormatInfoP1 = (val + 1) + "/" + audioInfoList.length + " " + audioFormatInfoP1;
                        }
                        drawTVRightP1P2();
                    }
                }
            }
        }
        catch (ex) {
            DBG_ERROR("onAudioIndexChanged: " + ex.message);
        }

    }

    function onAudioFormatChanged(val) {
        DBG_ERROR("onAudioFormatChanged: " + val);
        if (appControl.getCurrentAMState() == AMState.STARTING  ||
            appControl.getCurrentAMState() == AMState.STARTED  ||
            appControl.getCurrentAMState() == AMState.STOPPING) {
            DBG_ERROR("app stopping, don't receive message");
            return;
        }
        var crntChannel = liveTV.getCurrentChannelInfo();
        if (CONST.ATV != crntChannel.type) {
            DBG_ERROR("set audioFormatStr value = " + val);
            audioFormatStr = val;
            drawTVRightP1P2();
        }
    }

    function onAudioOnlyChanged(val) {
        DBG_ERROR("onAudioOnlyChanged: " + val);
        GLOBAL.S_AUDIO_CHANNEL = val == 1;
        fetchSignalAndPublish();
    }

    function openTVInfo(changeChlsuccessFlag) {
        infoBarNTV.alpha = 0;
        infoBarTV.alpha = 1;
        var crntChannel = liveTV.getCurrentChannelInfo();
        initInfoBarData(crntChannel);
        drawTVLeftP1();
       //2016-09-18 maity temp fix, later will remove.
       // if (GLOBAL.NO_SIGNAL || liveTV.getIsSameChannel()) return;

        if (crntChannel.isHidden) {
            oprtData.crntName = "[SE1507]";
            drawTVRightP1P2(changeChlsuccessFlag);
        }
        else if (CONST.ATV == crntChannel.type) {
            setVideoAudioInfo(CONST.ATV);
            drawTVRightP1P2(changeChlsuccessFlag);
        }
        else {
            DBG_INFO("pub message with no refresh .");
            if (!!changeChlsuccessFlag) {
                liveTV.remoteAppFunc("openTVInfo");
            }
            /*if(tv){

            }*/

            /*2016-10-09 temp fix sometime can't show right infobar*/
           // if (!drawDelayFlag)
           {
                /*if (!tv) {
                    var dvbtime = parseInt(Date.now() / GLOBAL.MILLIBASE);

                    setTimeout(function() {
                        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, null, [dvbtime - 1000, dvbtime + 2000, "1", "program name", "program detail", "TV-None"]);
                        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, null, [dvbtime + 2000, dvbtime + 4000, "1", "program name", "program detail", "TV-None"]);
                    }, 2000);
                    setTimeout(function() {
                        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.VIDEO_FORMAT_INFO_CHANGED, "730p,17:9");
                        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AUDIO_FORMAT_INFO_CHANGED, "1/4 eng Mono|ac3");
                    }, 1000);

                }*/
                setVideoAudioInfo(CONST.DTV);
                drawTVRightP1P2(changeChlsuccessFlag);
            }
            /*if (Config.tv) {
                DBG_INFO("setVideoAudioInfo(CONST.DTV);  Config.tv")
//                model.tvservice.getChannelNowPfInfo();
//                model.tvservice.getChannelNextPfInfo();
            }
            else {
                setTimeout(function () {
                    var dvbtime = parseInt(Date.now() / GLOBAL.MILLIBASE);
                    UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, null, [dvbtime - 1000, dvbtime + 2000, "1", "program name", "program detail", "TV-None"]);
                    UIObserver.publishMessage(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, null, [dvbtime + 2000, dvbtime + 4000, "1", "program name", "program detail", "TV-None"]);
                    //UIObserver.notifyEventForPC(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, -1);
                    //UIObserver.notifyEventForPC(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, -1);
                }, 2000);
            }*/
        }
    }

    function openInfoForTVWithoutChannels() {
        infoBarTV.alpha = 0;
        UI.setImage(UIElement.NTVIcon, "liveTV/infobar/ic_tv.png");
        setLiveTVText(UIElement.NTVText, "TV");
        setLiveTVText(UIElement.NTVDPI, " ");
        UIElement.NTVLockImg.alpha = 0;
        UIElement.MHLIcon.alpha = 0;//GLOBAL.MHLAVAILABLE;
        infoBarNTV.alpha = 1;
        liveTVCtrlRefreshPage();
        timeoutHideInfoBar(defInterval);
    }

    function openOtherInfo(keepTimer) {
        infoBarNTV.alpha = 1;
        infoBarTV.alpha = 0;
        var crntSrcObj = liveTV.getCurrentSourceObj();

        setLiveTVImage(UIElement.NTVIcon, GLOBAL.IMAGE_LIST[SourceList.ARRAY[crntSrcObj.id] + "60"]);
        setLiveTVText(UIElement.NTVText, crntSrcObj.rename);
        
        if(!keepTimer) {
            UI.callTTS(crntSrcObj.rename);
        }
        if (GLOBAL.PARENTAL_LOCK_SWITCH && crntSrcObj.lock == 1 && getIsInlockTime()) {
            UIElement.NTVLockImg.alpha = 1;
        }
        else {
            UIElement.NTVLockImg.alpha = 0;
        }
        videoInfo = "";
        var hdrFlag = 0;
        if (!GLOBAL.NO_SIGNAL) {
            videoInfo = Config.tv ? model.servicemode.getSourceVideoInfo() : "1920,1080,60,1";
            hdrFlag = tv? model.video.getHdrFlag(): 1;
            DBG_ALWAYS("videoInfo[" + videoInfo + "], HDR[" + hdrFlag +"]");
        }
        var tempInfo = (videoInfo == "")? videoInfo: (videoInfo + "," + hdrFlag);
        setLiveTVText(UIElement.NTVDPI, parseVideoInfo(crntSrcObj.id, tempInfo));
        UIElement.MHLIcon.alpha = 0;//GLOBAL.MHLAVAILABLE;
        liveTVCtrlRefreshPage();
        if (!keepTimer) {
            timeoutHideInfoBar(defInterval);
        }
    }

    function parseVideoInfo(src, info) {
        if (!info) return "";

        var dpi = info.split(','), txt = "";
        if (dpi[0] == "0" || dpi[1] == "0") return "";
        if (SourceList.AV != src) {
            if (dpi[0] != "0") {
                txt = dpi[0] + "*" + dpi[1];
                if (txt != "640*480" && txt != "800*600" && txt != "1024*768") {
                    txt = txt + (dpi[3] == 0 ? "p" : "i");
                }
            }
        }
        else {
            txt = dpi[1] + (dpi[3] == 0 ? "p" : "i") + " " + ((dpi[1] == "576") ? "[SE2164]" : "[SE2166]");
        }
        if (!!dpi[2]) {
            txt = txt + " " + dpi[2] + "Hz";
        }
        if (!!dpi[4] && dpi[4] == "1") {
            txt = txt + " HDR";
        }
        return txt;
    }

    function clearInfoBarGroup() {
        for (var i = 0; i < infoGroupStr.length; i++) {
            //UIElement.infoGroup.children[i].children[1]._bounds = null;
            UIElement.infoGroup.children[i].alpha = 0;
            UIElement.infoGroup.children[i].children[1].alpha = 0.6;
        }
        UIElement.infoGroup.children[infoGroupStr.length - 1].children[1].alpha = 1;
    }

    function setInfoBarGroup() {
        var baseX = 620, baseY = 15, baseSplit = 24, bnds, grpKey, target;
        for (var i = 0; i < infoGroupStr.length; i++) {
            grpKey = infoGroupStr[i].toUpperCase();
            target = UIElement.infoGroup.children[i];//group
            target.alpha = 0;
            setLiveTVText(target.children[1], oprtData.modeGroup[GroupTip[grpKey]], true);
            if (GroupTip.DOLBY == i) {
                if (oprtData.modeGroup[GroupTip[grpKey]] == 1) {
                    target.children[2].alpha = 1;
                    setLiveTVText(target.children[1], " ", true);
                }
                else {
                    target.children[2].alpha = 0;
                }
            }
            if (!oprtData.modeGroup[GroupTip[grpKey]]) continue;
            if (GroupTip.DOLBY == i && oprtData.modeGroup[GroupTip[grpKey]] == 1) {
                bnds = target.children[2].getBounds();
            }
            else {
                bnds = target.children[1].getBounds();//text
            }
            target.pivot.x = (bnds.width + baseSplit) / 2;
            if (baseX - target.pivot.x - target.pivot.x < 240) {
                baseX = 620;
                baseY += 42;
            }
            target.x = baseX - target.pivot.x;
            target.y = baseY;
            baseX = target.x - target.pivot.x;
            target.alpha = 1;
        }
    }

    function moveToInfoPage(page) {
        timeoutHideInfoBar(defInterval);
        UI.callTTS(oprtData.detailInfo);
        UI.getTween(infoBarTV).to({
            x: 1 == page ? 1940 : 20
        }, 300, UI.ease.quartOut);
        crntInfoPage = page - 1;
    }

    /*-------------------Info bar-------------------*/
    liveTVCtrl.onFocus = function (target) {
        //UI.moveCursor(UI.adjustView());
        DBG_INFO("liveTVCtrl.onFocus");
        UI.getTween(UI.base.cursor, true).set({
            scaleX: 1,
            scaleY: 1,
            alpha: 0
        });
    };

    liveTVCtrl.onkey = function() {
        powerOffCount = 0;//set signal float counter to 0.
        liveTV.tryShowScreenSaver();
        return true;
    }

    liveTVCtrl.onPush = function () {
        DBG_INFO("liveTVCtrl.onPush");
        liveTVCtrl.alpha = 1;
        tv &&model.message.setOsdVisible(0);    //dbtag:20161203 --RICK
        if (!liveTV.getInitedFlag() || !firstLoad) return;
        if (HOTEKEY_MAP.NONE == GLOBAL.APP_POWER_ON) {
            if (GLOBAL.CURRENT_SVR_MSG == SvrMsg.AUDIO_PROG) {
                showInfoBar();  //MSD6586US-3148
            }
            showLiveTVUI(true);
            DBG_INFO("register all key codes");
            UI.registerKeyCodes(null);
            UI.setKeyGroup(7);
            UI.unlockAllKeys("init");
        }
        else {
            DBG_INFO("don't register all key codes");
            setTimeout(UI.popSubModule, 100);
        }

        firstLoad = false;
        DBG_ERROR("GUI Loaded.");
        UI.initRealFinished = true;

        //if (document.getElementById("powerOnLayer")) {
        //    document.body.removeChild(document.getElementById("powerOnLayer"));
        //}
        setTimeout(function(){
            if ((GLOBAL.APP_POWER_ON == 0 || getWizardSetFlag() == 1) && GLOBAL.NEED_START_OPERA4X) {
                DBG_ERROR("NEED_START_OPERA4X");
                sendAM(":am,am,:start=opera4x","opera4x","start","");
                GLOBAL.NEED_START_OPERA4X = false;
            }
        },2000);
        setTimeout(function(){
            tv && modeljs.sendAppMessage("apm",'{"type":"AppStatus","source":"launcher","status":"loaded"}');
        },6000);
    };

    liveTVCtrl.onPop = function (target) {
        DBG_INFO("liveTVCtrl.onPop");
        clearLiveTVUI();
        liveTV.cancelChangChByNum();
        tv && model.message.setOsdVisible(1);    //dbtag:20161203 --RICK
    }

    //liveTVCtrl.onExit = function (target) {
    //DBG_ONXX(LIVETV.CONTROL, "onExit");
    //clearLiveTVUI();
    //}

    function onMessageidChaged(val) {
        try{
            DBG_ERROR("onMessageidChaged: " + val);
        }
        catch(ex){
            DBG_ERROR(ex.message);
        }
    }

    liveTV.tryShowScreenSaver = function() {
        if (!!screenSaverAnimationTimer) {
            drawForScreenSaverMode()
        }
    };

    function liveTVHandlerProcess(focus, evt) {
        liveTV.clearLastPlayedChannel();
        powerOffCount = 0;//set signal float counter to 0.
        var keyCode = evt.keyCode;
        DBG_INFO("liveTVHandlerProcess keyCode is " + keyCode);
        if (infoBarOpened && CONST.KEY.VK_BACKSPACE == keyCode) {
            hideInfoBar();
        }
        else if (checkHBBTVIsOn()) {
            UI.sendKeyResult(null, false);
        }
        else if (checkCECControlIsOn() && CONST.CEC_KEYSET.indexOf(keyCode) > -1) {// cec
            //UI.sendKeyResult(null, false);
            sendKeyToCEC(keyCode);
        }
        else {
            if (SourceList.TV != GLOBAL.CURRENT_SOURCE && CONST.KEY.VK_UP != keyCode &&
                CONST.KEY.VK_INFO != keyCode && CONST.KEY.VK_PLAYPAUSE != keyCode) return false;//MT5658US-583
            switch (keyCode) {
                case CONST.KEY.VK_UP:
                    try {
                        var aa = model.message.getMessageid();
                        DBG_ERROR("getMessageid is " + aa);
                        var bb = model.tvservice.getNoSignalMain();
                        DBG_ERROR("getNoSignalMain is " + bb);
                        var cc = model.tvservice.getAudioIndex();
                        DBG_ERROR("getAudioIndex is " + cc);
                        var ee = model.tvservice.getAudioLanguageInfo();
                        DBG_ERROR("getAudioLanguageInfo is " + ee);
                        var ff = model.sound.getAudioFormat();
                        DBG_ERROR("getAudioFormat is " + objToString(ff));
                    }
                    catch (ex) {
                        DBG_ERROR("zny test error: " + ex.message);
                    }
                case CONST.KEY.VK_INFO:
                case CONST.KEY.VK_LEFT:
                case CONST.KEY.VK_RIGHT:
                case CONST.KEY.VK_BLUE:
                case CONST.KEY.VK_BACKSPACE:
                {
                    var continueProcess = infobarKeyHandler(keyCode);
                    return continueProcess;
                }
                case CONST.KEY.VK_ENTER:
                case CONST.KEY.VK_CH_LIST:
                {
                    showChannelListOrChangeChannel();
                    break;
                }
                case CONST.KEY.VK_FAVCHANNEL:
                {
                    showFavChannelList();
                    break;
                }
                case CONST.KEY.VK_PRE_CH:
                {
                    liveTV.changeToPreChannel();
                    break;
                }
                case CONST.KEY.VK_0:
                case CONST.KEY.VK_1:
                case CONST.KEY.VK_2:
                case CONST.KEY.VK_3:
                case CONST.KEY.VK_4:
                case CONST.KEY.VK_5:
                case CONST.KEY.VK_6:
                case CONST.KEY.VK_7:
                case CONST.KEY.VK_8:
                case CONST.KEY.VK_9:
                case CONST.KEY.VK_SHORT_LINE:
                {
                    if(GLOBAL.TTS) {
                        var ttsKeyvalue = (evt.keyCode - CONST.KEY.VK_0);
                        if (ttsKeyvalue >= 0 && ttsKeyvalue <= 9) {
                            UI.callTTS(ttsKeyvalue, 0);
                        }
                        else {
                            var txt = UI.setTtsString("[SE3236]");
                            UI.callTTS(txt, 0);
                        }
                    }
                    changeChannelByNum(focus, evt);
                    break;
                }
                case CONST.KEY.VK_CC:
                {
                    //UI.popSubModule();
                    //UI.pushSubModule("setting", "CC", true, 'liveTVCtrl',liveTV);
                    KeyCCHandler();
                    break;
                }
                case CONST.KEY.VK_MTS:
                    KeyMTSHandler();
                    break;
                case CONST.KEY.VK_NRT:
                    KeyNRTHandler();
                    break;
                case CONST.KEY.VK_PLAYPAUSE:
                    if(GLOBAL.CURRENT_SOURCE >= SourceList.HDMI1 && GLOBAL.CURRENT_SOURCE <= SourceList.HDMI4 && APPMODULE.LayoutToast == null){
                        UI.pushGhostModule("setting","LayoutToast");
                        APPMODULE.LayoutToast = "LayoutToast";
                    }
                    break;
                default:

                    break;
            }
        }
    }

    function infobarKeyHandler(keyCode) {
        if (liveTV.getChannelChangeFlag()) return false;
        switch (keyCode) {
            case CONST.KEY.VK_RIGHT:
                if (!infoBarOpened || 0 == infoBarTV.alpha || 0 == TVP2Left.alpha) return false;
                moveToInfoPage(2);
                break;
            case CONST.KEY.VK_LEFT:
                if (!infoBarOpened || 0 == infoBarTV.alpha) return false;
                moveToInfoPage(1);
                break;
            case CONST.KEY.VK_UP:
            case CONST.KEY.VK_INFO:
                if (infoBarOpened) {
                    hideInfoBar();
                }
                else {
                    intervalOffset = 5000;
                    showInfoBar(null, true);
                }
                DBG_ALWAYS("infobar opened: " + infoBarOpened);
                break;
            case CONST.KEY.VK_BLUE:
                if (infoBarOpened && crntInfoPage == 1) {
                    UI.popAllModule();
                    UI.pushSubModule(LIVETV.MAIN, LIVETV.INFO_DETAIL, true);
                }
                break;
            case CONST.KEY.VK_BACKSPACE:
                if (infoBarOpened) {
                    hideInfoBar();
                    return false;
                }
                else {
                    return true;
                }
                break;
            default :
                break;
        }
    }

    function showChannelListOrChangeChannel() {
        if (GLOBAL.SOURCE_CHANGING || !liveTV.getInitedFlag() || liveTV.getChannelChangeFlag()) return;
        if (liveTV.channelListInitFlag()) {
            DBG_ERROR("ChannelList is initing");
            openToastPage(TOASTTYPE.READCHLTIP);
            return;
        }

        if (1 == numTip.alpha) {
            doChannelChangeByNum(inputedNum);
        }
        else if (!liveTV.getHasChannelFlag()) {
            DBG_ERROR("do not have any channels.");
        }
        else {
            UI.popSubModule();
            UI.pushSubModule(LIVETV.MAIN, LIVETV.CHANNEL_LIST, true);
        }

    }

    function showFavChannelList() {
        if (GLOBAL.SOURCE_CHANGING || !liveTV.getInitedFlag() || liveTV.getChannelChangeFlag()) return;
        if (liveTV.channelListInitFlag()) {
            DBG_ERROR("ChannelList is initing");
            openToastPage(TOASTTYPE.READCHLTIP);
            return;
        }

        if (!liveTV.getHasChannelFlag()) {
            DBG_ERROR("do not have any channels.");
        }
        else {
            UI.popSubModule();
            UI.pushSubModule(LIVETV.MAIN, LIVETV.CHANNEL_LIST, true, "showFavList");
        }
    }

    /*mighty 2016-09-20*/
    function ui_getAudioTableInfo(event) {
    }
    liveTV.ui_getAudioTableInfo = ui_getAudioTableInfo;
    /**
     * 提供频道号切台接口
     * @param num 频道号
     */
    liveTV.changeByChannelNumber = function(num) {
        DBG_ERROR("change channel by number " + num);
        if (!UI.getCurrModule() || LIVETV.MAIN != UI.getCurrModule().name){
            DBG_ERROR("changeChannelByName LIVETV.MAIN != UI.getCurrModule().name return");
            return false;
        }
        if (GLOBAL.CURRENT_SOURCE != SourceList.TV) return false;

        doChannelChangeByNum(num);
    };
    function doChannelChangeByNum(num) {
        if ("" === num) return false;
        clearTimeout(inputTimer);
        reachMax = false;
        repeatTimes = 0;
        var chnl = liveTV.setStateBefChangeChannel(ChangeType.CH_NUM, num);
        if (!chnl) {
            GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.CHNL_NOT_FOUND;
            UI.pushGhostModule("setting", "SettingSysToast");
            openLiveTVModule([Msg.INFO, 0]);
        }
        liveTV.changeChannel(chnl);
    }

    function changeChannelByNum(focus, evt) {
        if (reachMax || SourceList.TV != GLOBAL.CURRENT_SOURCE) return false;
        if (CONST.KEY_STATE.REPEAT == evt.keyState) {
            if (++repeatTimes == 2) {
                doChannelChangeByNum(inputedNum);
            }
            return false;
        }
        repeatTimes = 0;
        var num = numKeyMap.indexOf(evt.value), maxNumLen = liveTV.getCurrentListMaxNum();
        if (-1 == num || -1 == maxNumLen) return false;
        if (infoBarOpened) hideInfoBar();
        if (num == numKeyMap.length - 1) {
            if ("" == inputedNum) inputedNum = "1" + splitFlag;
            else if (inputedNum.indexOf(splitFlag) < 0) inputedNum += splitFlag;
        }
        else {
            inputedNum += (num + "");
        }
        inputedNum = inputedNum.substring(inputedNum.length - maxNumLen, inputedNum.length);

        var iterval = (inputedNum.length == maxNumLen) ? 100 : 3000;
        if (100 == iterval) reachMax = true;
        clearTimeout(inputTimer);
        inputTimer = setTimeout(doChannelChangeByNum.bind(this, inputedNum), iterval);
        numTip.alpha = 1;
        UI.setText(numTip.children[1], inputedNum);
    }

    function recheckSourceData() {  //MSD6586US-5480
        DBG_ERROR("recheck source data ");
        initAllInputsData();
        var crntSourceObj = liveTV.getCurrentSourceObj();
        DBG_ERROR("crntSourceObj is " + objToString(crntSourceObj));
        if (SourceList.TV != crntSourceObj.id) {   //tv 通道自己会发，非TV通道UI模拟发送
            GLOBAL.S_NO_SIGNAL = (crntSourceObj.signal == SvrMsg.NO_SIGNAL);
        }
        else {
            GLOBAL.S_NO_SIGNAL = (model.tvservice.getNoSignalMain() == 1);
        }
        fetchSignalAndPublish();
    }

    liveTV.isNumTipOn = function() {
        return numTip.alpha == 1;
    };
    liveTV.cancelChangChByNum = function(refresh) {
        numTip.alpha = 0;
        inputedNum = "";
        clearTimeout(inputTimer);
        !!refresh && liveTVCtrlRefreshPage();
    };

    liveTVKeyMap.forEach(function (v) {
        liveTVCtrl["onkey_" + v] = liveTVHandlerProcess;
    });

    liveTV.clearLiveTVUI = clearLiveTVUI;
    liveTV.showLiveTVUI = showLiveTVUI;
    liveTV.setMsgFlag = function (msg) {
        if (!msg) return false;
        switch (msg[0]) {
            case Msg.OPERATETIP:
                Config.tv && model.tvservice.setPlaySuccessLiveTV(0);
                liveTV.setFirstPlayFlag(false);
                break;
            case Msg.RESUMEHBBTV:
                resumeHBBTV();
                break;
            case Msg.WAIT_SOURCE_CHANGE:
                waitSourceChange = (1 == msg[1]);
                break;
            default :
                for (var i = 0; i < msg.length / 2; i++) {
                    var group = msg.slice(i * 2, (i + 1) * 2);
                    openFlag[group[0]] = group[1];
                }
                break;
        }
    };

    liveTV.getLiveTVCtrlDataObj = function() {
        return oprtData;
    };
    liveTV.clearLiveTVStandby = function() {
        powerOffCount = 0;
    };
    liveTV.isInfobarOpened = function() {
        return infoBarOpened;
    };
liveTV.remoteAppFunc = function (val) {
        DBG_ERROR("liveTV.remoteAppFunc come " + val);
        try {
            var rCurSource = liveTV.getCurrentSourceObj();
            if (rCurSource.playId == "TV") {
                var crntChannel = liveTV.getCurrentChannelInfo();
                var list_param = crntChannel.playId + "#" + crntChannel.satId;
                var channel_param = crntChannel.playId + "#" + crntChannel.uid + "#" + crntChannel.listUid + "#0";
                var tmpDetail = pfResultNow ?
                    filterUnicaode(!!pfResultNow[TvserviceModel.EIT_FIELD_LONG_DESCRIPTION] ? pfResultNow[TvserviceModel.EIT_FIELD_LONG_DESCRIPTION] : "No program information"):"No program information";
                var id = ((null != crntChannel.number) ? crntChannel.number : "") + "";
                var tmpName = pfResultNow ?filterUnicaode(!!pfResultNow[TvserviceModel.EIT_FIELD_TITLE] ? pfResultNow[TvserviceModel.EIT_FIELD_TITLE] : "No program"):"No program";
                var eventid = ((null != crntChannel.eventid) ? crntChannel.eventid : "") + "";
//                oprtData.crntStart = !!pfResultNow[Pf.START_TIME] ? parseInt(pfResultNow[Pf.START_TIME]) : 0;
//                oprtData.crntEnd = !!pfResultNow[Pf.END_TIME] ? parseInt(pfResultNow[Pf.END_TIME]) : 0;
                var name = (null != crntChannel.name) ? crntChannel.name : "";
                DBG_INFO("[livetv]" + channel_param + "   " + name + "   " + rLiveTvLastP+  "  N "+rLiveTvLastN);
                var sourceid = rCurSource.id + "";
                if (channel_param != rLiveTvLastP || tmpName!=rLiveTvLastN || val == "openLiveTVModule") {//不重复发状态，但是openlivetv时必须发状态
                    pubStateLiveTV(list_param, id, eventid, tmpName, oprtData.crntStart, oprtData.crntEnd, tmpDetail, channel_param, name, sourceid);
                    rLiveTvLastP = channel_param;
                    rLiveTvLastN = tmpName;
                }
            } else {
                pubStateSourceSwitch(rCurSource.id, rCurSource.name, rCurSource.signal, rCurSource.locked ? 1 : 0, 0, rCurSource.rename);

            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        //crntChannel.channelUid;
    };
    liveTV.liveTVSignalChanged = liveTVSignalChanged;

    tv && model.servicemode.setSignalMainEnable(1);

    liveTVCtrl.onFirstPush = function () {
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_TV_SIGNAL_CHANGED, tvSignalChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_SOURCE_VIDEO_INFO_CHANGED, onSourceVideoInfoChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_VIDEO_VIDEO_FORMAT_INFO_CHANGED, onVideoFormatChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_VIDEO_FRAME_ASPECT_CHANGED, onVideoFrameAspectChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_CC_EXIST_CHANGED, onVideoCcExistChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_AUDIO_EXIST_CHANGED, onCurAudioExistChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_AUDIO_LANGUAGE_INFO_CHANGED, onAudioLanguageInfoChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_AUDIO_INDEX_CHANGED, onAudioIndexChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_AUDIO_FORMAT_CHANGED, onAudioFormatChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_AUDIO_ONLY_CHANGED, onAudioOnlyChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_EIT_MAIN_NOW_CHANGED, onEitNowChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_EIT_MAIN_NEXT_CHANGED, onEitNextChanged);

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SIGNAL_CHANGED, liveTVSignalChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MESSAGE_ID_CHANGED, onMessageidChaged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_SOURCE_CHANGED, currentSourceChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.REGISTER_NOTIFY_FINISH, recheckSourceData);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.INPUT_NAME_CHANGED, inputNameChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST, onParentalLockPinRequest);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_PROGRAM_INFO, onGetNowPfResult);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NEXT_PROGRAM_INFO, onGetNextPfResult);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.VIDEO_FORMAT_INFO_CHANGED, onGetVideoFormatInfoResult);
//        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_FORMAT_INFO_CHANGED, onGetAudioFormatInfoResult);

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.VIDEO_FORMAT_CHANGED, onVideoFormatChanged);

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.INPUT_RENAMED, onInputRenamed);
//    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_INPUT_LOCK_CHANGED, onInputLockChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_CHANGE_SOURCE, onCecNotifyChangeSource);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, updateLiveTVUI);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_INITED, resetLiveTVUI);
        resetLiveTVUI(false);
        resetOperateData();
        //UI.preloadModule("launcher");

        if (tv) {
            DBG_ERROR("-----------------get info for infobar------------------");
            videoFormatInfo = model.video.getVideoFormatInfo();
            videoFrameAspect = model.video.getVideoFrameAspect();
            CcExist = model.video.getCcExist();
            pfResultNow = model.tvservice.getEitMainNow();
            pfResultNext = model.tvservice.getEitMainNext();
            onAudioIndexChanged(model.tvservice.getAudioIndex());
            audioFormatStr = model.sound.getAudioFormat();

            var crntSourceObj = liveTV.getCurrentSourceObj();
            DBG_ERROR("crntSourceObj is " + objToString(crntSourceObj));

            if (SourceList.TV != crntSourceObj.id) {   //tv 通道自己会发，非TV通道UI模拟发送
                GLOBAL.S_NO_SIGNAL = (crntSourceObj.signal == SvrMsg.NO_SIGNAL);
            }
            else {
                GLOBAL.S_NO_SIGNAL = (model.tvservice.getNoSignalMain() == 1);
            }
            try {
                GLOBAL.S_AUDIO_CHANNEL = (model.tvservice.getAudioOnly() == 1);
            }
            catch (ex) {
                DBG_ERROR("getAudioOnly error: " + ex.message);
                GLOBAL.S_AUDIO_CHANNEL = false;
            }
            fetchSignalAndPublish();

            onParentalLockPinRequest();
        }
        else {
            videoFormatInfo = "720*480i/3Hz";
            videoFrameAspect = "16:9";
            CcExist = 1;
            var dvbtime = parseInt(Date.now() / GLOBAL.MILLIBASE);
            pfResultNow = ["", "", dvbtime - 1000, dvbtime + 2000, "program name", "short description", "long description", "feature flags", "TV-None"];
            pfResultNext = ["", "", dvbtime + 2000, dvbtime + 4000, "program name", "short description", "long description", "feature flags", "TV-None"];

            //GLOBAL.S_LOCKING = true;
            //GLOBAL.S_NO_SIGNAL = true;
            //fetchSignalAndPublish();

        }

        var preloadImgList = [
            "liveTV/channellist/bg_channellist.png",
            (GLOBAL.LAUNCHER_BRAND == "his") ? "Screen/hisense_input_nosignal.png": "Screen/sharp_input_nosignal.png"
        ];
        while (preloadImgList.length > 0) {
            var url = preloadImgList.pop();
            PIXI.loader.add(themeDir + url, themeDir + url);
        }
        PIXI.loader.once('complete', function () {
            DBG_ERROR("livetv preloadImgList load complete");
        });
        PIXI.loader.load();
    };
};
DBG_INFO("liveTVCtrl.js end " +  debugRunTime());
