DBG_INFO("liveTV.js start " + debugRunTime());
var liveTV = window[LIVETV.MAIN];

(function () {
    //UI.pushSubModule(LIVETV.MAIN, LIVETV.CONTROL, true);
    var readCount = 0;
    var crntChannel, lastChannel, userMode, firstPlay, liveTVInited;
    var listIterator, channelIterator, listUpdateIterator, channelUpdateIterator, readedCount = 0, maxNumLenMaps = {};
    var initingList, initAgain, chnlChging = false, chnlChgingTimer = 0;
    var expectChannel = null;
    var changeChannelTimer = 0;
    var lastChannelUid;
    var oprtData = {
        crntList: {},
        allLists: [],
        allChannels: {},
        favChannels: {},
        hisChannels: [],

        listIndex: 0,
        channelIndex: 0,
        channelNumberGrp: {},
        fullChannels: {}
    };
    liveTV.initLiveTV = function (init) {
        GLOBAL.CURRENT_SOURCE = SourceList.TV;

        if (!Config.tv) {
            crntChannel = liveTV.PCChannel;
            initAllInputsData();
            userMode = firstPlay = false;
        }
        else {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_MAIN_PLAY_CHANGED, mainPlayChanged);
                userMode = (1 == parseInt(model.hisfactory.getTofactoryOpition()));
                firstPlay = (1 == parseInt(model.tvservice.getPlaySuccessLiveTV()));
                GLOBAL.PARENTAL_LOCK_SWITCH = parseInt(model.parentlock.getSModel());
                initAllInputsData();
                DBG_ERROR("init SOURCE_LIST " + objToString(GLOBAL.SOURCE_LIST));
                GLOBAL.CURRENT_SOURCE = getCurrentSourceId();
                DBG_ERROR("init CURRENT_SOURCE " + objToString(GLOBAL.CURRENT_SOURCE));
                crntChannel = mainPlayToChannel();
                GLOBAL.CURRENT_CHLIST_INDEX = parseInt(model.tvservice.getPlayFavChannelList());
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        GLOBAL.NO_SIGNAL = liveTV.getNoSignalFlag(true);
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.LIVETV_INITED, init);
        liveTVInited = true;
    }

    liveTV.onPush = function() {
       // DBG_ERROR("try to load liveTV page:::::delayLoad");
      //  UI.delayLoad();
    };

    liveTV.setFirstPlayFlag = function(v){
        firstPlay = v;
        tv && model.tvservice.setPlaySuccessLiveTV(0);
    }

    liveTV.getInitedFlag = function () {
        return liveTVInited;
    }

    liveTV.getCurrentChannelInfo = function () {
        if (null == crntChannel) return {name: "", number: ""};
        if (!crntChannel.name) crntChannel.name = "";
        if (!crntChannel.number && 0 != crntChannel.number) crntChannel.number = "";
        return crntChannel;
    }
    liveTV.updateCurrentChannelInfo = function (curtChnl) {
        crntChannel = curtChnl;
    }
    liveTV.recheckCurrentChannelInfo = function () {
        if (!Config.tv) return crntChannel;
        var ecode = ECode.NONE;
        if (!!crntChannel && !!crntChannel.eCode) {
            ecode = crntChannel.eCode;
        }
        crntChannel = mainPlayToChannel(ecode);
        return crntChannel;
    }

    liveTV.getCurrentListMaxNum = function () {
        if (!oprtData.crntList || oprtData.crntList.name == "N/A") return -1;
        if (CHLISTINDEX.FAV == GLOBAL.CURRENT_CHLIST_INDEX) return maxNumLenMaps["FAV"];//FAV hav not add
        return maxNumLenMaps[oprtData.crntList.name];
    }

    liveTV.getChannelsByListIndex = function (lst, idx) {
        if (!lst) return [];
        var chnls;
        switch (idx) {
            case CHLISTINDEX.ALL:
                chnls = oprtData.allChannels[lst];
                break;
            case CHLISTINDEX.FAV:
                chnls = oprtData.favChannels[lst];
                break;
            case CHLISTINDEX.HIS:
                chnls = oprtData.hisChannels;
                break;
            default:
                return [];
        }
        return chnls ? chnls : [];
    }

    liveTV.getIsSameChannel = function () {

    }

    liveTV.clearLastPlayedChannel = function () {

    }

    liveTV.playAfterChangeTunerMode = function (index) {
        var listName = "";
        if (index === 0) {
            listName = "Antenna";
        } else {
            listName = "Cable";
        }
        DBG_INFO("tuner change: "+ oprtData.crntList.name + " -> " + listName);
        if (oprtData.crntList.name === listName) {
            UI.endLoading();
            return;
        }
        if (!!oprtData.allChannels[listName] && oprtData.allChannels[listName].length > 0) {
            //Play only when there are channels.
            var chnl = mainTunerModePlayToChannel(index);
            if (chnl.uid == 0){
                DBG_INFO("current channel is 0, play the first channel.");
                chnl = oprtData.allChannels[listName][0];
            }

            checkAndPlayChannel(chnl);
            lastChannelUid = 0;
            DBG_INFO("allChannels play first channel uid:" + chnl.uid);
        } else {
            DBG_INFO("current channel list is empty");
            tv && model.tvservice.stopChannel();    //调用stopChannel后，底层将会通过playMain发上来一个空数组
            lastChannel = crntChannel;
            lastChannelUid = 0;
        }
    }

    liveTV.getCurrentSourceObj = function () {
        DBG_ERROR("GLOBAL.CURRENT_SOURCE: " + GLOBAL.CURRENT_SOURCE);
        var crntSrc = objectFindByKey(GLOBAL.SOURCE_LIST, "id", GLOBAL.CURRENT_SOURCE);
        if (null == crntSrc) {
            var obj = objectFindByKey(GLOBAL.SOURCE_LIST, "id", getCurrentSourceId());
            DBG_ERROR("current source " + objToString(obj));
            GLOBAL.CURRENT_SOURCE = (null == obj) ? SourceList.TV : obj.id;
            return obj;
        }
        else {
            return crntSrc;
        }
    }

    function getEPGChannelIndex(list, chnl) {
        var idx = 0;
        if(null == list || !oprtData.allChannels[list.name]) {
            DBG_ERROR("get EPG Channel Index error. list[" + objToString(list) +
            "], channel[" + objToString(chnl) + "]");
        }
        else {
            var chlIdx = 0, item;
            while(chlIdx < oprtData.allChannels[list.name].length) {
                item = oprtData.allChannels[list.name][chlIdx];
                if(chnl.uid == item.uid && chnl.playId == item.playId) {
                    DBG_ALWAYS("current channel index gotted.[" + objToString(chnl) +
                    "][" + objToString(item) + "]");
                    break;
                }
                else if(CONST.ATV != item.type) {
                    idx++;
                }
                chlIdx++;
            }
            if(chlIdx == oprtData.allChannels[list.name].length) {
                DBG_ERROR("can not find current index.");
                idx = -1;
            }
        }
        return idx;
    }

    liveTV.getEPGCurrentChannel = function() {
        if(null == oprtData.crntList) {
            DBG_ERROR("can not find the list by channel[" + objToString(crntChannel) + "]");
            return null;
        }
        var currentPlay = {
            list: oprtData.crntList,
            listUid: crntChannel.listUid,
            listName: oprtData.crntList.name,
            satId: crntChannel.satId,
            channelIndex: getEPGChannelIndex(oprtData.crntList, crntChannel),
            channelId: crntChannel.uid
        };
        return currentPlay;
    }

    function onPlaySuccessLiveTVChanged(val) {
        DBG_INFO("success play changed[" + val + "]");
        firstPlay = (0 == parseInt(val));
    }

    function mainPlayChanged(val) {
        DBG_ERROR("current channel info is --" + objToString(val) + "--");
        if (!val || val.length == 0) {
            val = [0, 0, 0, "", 0, 0, 0, 0];
        }

        DBG_ERROR("expectChannel.uid: " + (!!expectChannel && expectChannel.uid));
        if (!!expectChannel && !!expectChannel.uid && val[MPChannel.UID] != expectChannel.uid) {
            DBG_ERROR("difference with expectChannel: " + expectChannel.uid);
            return;
        }
        expectChannel = null;
        clearTimeout(changeChannelTimer);

        var sourceList = ["TV", "AVS", "COMPONENT", "HDMI1", "HDMI2", "HDMI3", "HDMI4"];//,"DMP","VGA","SCART"];
        var index = sourceList.indexOf(("" + val[TvserviceModel.PLAY_UUID_SERVICE]).toUpperCase());
        if (index >= 0) {
            return;
        }

        GLOBAL.CURRENT_SOURCE = SourceList.TV;

        crntChannel = {
            listUid: val[TvserviceModel.PLAY_UUID_FOLDER],
            uid: val[TvserviceModel.PLAY_UUID_SERVICE],
            number: val[TvserviceModel.PLAY_FIELD_NO],
            name: val[TvserviceModel.PLAY_SERVICE_NAME],
            type: (getMaskValue(Mask.ANALOG, val[TvserviceModel.PLAY_ATTRIBUTES]) == 1)? CONST.ATV: CONST.DTV,
            attr: val[TvserviceModel.PLAY_ATTRIBUTES],
            playId: 0,//parseInt(val[MPChannel.LISTUID]) + 1,
            satId: 0,
            eCode: !!val[MPChannel.ECODE] ? val[MPChannel.ECODE] : ECode.NONE,
            playTime: Date.now()
        };
        setFlagByAttr(crntChannel, val[TvserviceModel.PLAY_ATTRIBUTES]);

        var tuner = tv? model.channelSearch.getSource(): 15;
        if (!crntChannel.listUid) {
            DBG_ERROR("tuner is " + tuner);
            if (tuner == 15) {
                crntChannel.listUid = 6;
            }
            else if (tuner == 16) {
                crntChannel.listUid = 7;
            }
        }
        else {
            if (crntChannel.listUid == 6 && tuner != 15) {
                tv && model.channelSearch.setSource(15);
                DBG_ERROR("zny set tuner 15");
            }
            else if (crntChannel.listUid == 7 && tuner != 16) {
                tv && model.channelSearch.setSource(16);
                DBG_ERROR("zny set tuner 16");
            }
        }

        GLOBAL.S_NO_SIGNAL = tv? (model.tvservice.getNoSignalMain() == 1): false;
        if (val[0] == 0) {
            GLOBAL.S_NO_SIGNAL = true;   //for model.tvservice.stopChannel();
        }
        //GLOBAL.S_AUDIO_CHANNEL = crntChannel.audioOnly;
        fetchSignalAndPublish();

        //DBG_TODO("check to update channel list");
        resetChannelListIndex();
        setChannelChangeFlag(false);

        tv && liveTV.readAudioTableInfo(liveTV.ui_getAudioTableInfo);

        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, crntChannel, 'mainPlayChanged');
    }

    function mainPlayToChannel() {
        var val = tv ? model.tvservice.getMainPlay():0;
        DBG_ERROR("recheck current channel info is --" + objToString(val) + "--");

        if(!!val && val.length > 0){
            var sourceList = Object.keys(LiveTVSourceMap);
            if (sourceList.indexOf(val[MPChannel.UID].toUpperCase().replace(" ", "")) > -1) {
                var tuner = tv? model.channelSearch.getSource(): 15;    //15 antena 16 cable
                DBG_ERROR("zny get tuner " + tuner);
                var tvChannel;
                if (tuner == 15) {
                    tvChannel = mainTunerModePlayToChannel(0);
                    if (!tvChannel || tvChannel.listUid == 0) {
                        tvChannel = mainTunerModePlayToChannel(1);
                    }
                }
                else {  //tuner == 16
                    tvChannel = mainTunerModePlayToChannel(1);
                    if (!tvChannel || tvChannel.listUid == 0) {
                        tvChannel = mainTunerModePlayToChannel(0);
                    }
                }

                return tvChannel;
            }
        }

        var tempChannel;
        if (0 == val.length) {
            val = [6, 0, 0, "", 0, 0, 0, 0];
        }

        tempChannel = {
            listUid: val[TvserviceModel.PLAY_UUID_FOLDER],
            uid: val[TvserviceModel.PLAY_UUID_SERVICE],
            number: val[TvserviceModel.PLAY_FIELD_NO],
            name: val[TvserviceModel.PLAY_SERVICE_NAME],
            type: (getMaskValue(Mask.ANALOG, val[TvserviceModel.PLAY_ATTRIBUTES]) == 1)? CONST.ATV: CONST.DTV,
            attr: val[TvserviceModel.PLAY_ATTRIBUTES],
            playId: 0,//parseInt(val[MPChannel.LISTUID]) + 1,
            satId: 0,
            playTime: Date.now()
        };
        setFlagByAttr(tempChannel, val[TvserviceModel.PLAY_ATTRIBUTES]);

        //GLOBAL.S_AUDIO_CHANNEL = tempChannel.audioOnly;

        return tempChannel;
    }
    function mainTunerModePlayToChannel(index) {
        var val = [];
        if (index === 0){
            var val = tv ? model.tvservice.getMainPlayAir():0;
            DBG_ERROR("air current channel info is --" + objToString(val) + "--");
        }else if (index === 1){
            var val = tv ? model.tvservice.getMainPlayCable():0;
            DBG_ERROR("cable current channel info is --" + objToString(val) + "--");
        }

        if (GLOBAL.S_NO_CHANNEL) { //MSD6586US-4654
            DBG_ERROR("GLOBAL.S_NO_CHANNEL true, set val to []");
            val = [];
        }

        if (!val || 0 == val.length) {
            val = [0, 0, 0, "", 0, 0, 0, 0];
        }

        var tempChannel;
        tempChannel = {
            listUid: val[TvserviceModel.PLAY_UUID_FOLDER],
            uid: val[TvserviceModel.PLAY_UUID_SERVICE],
            number: val[TvserviceModel.PLAY_FIELD_NO],
            name: val[TvserviceModel.PLAY_SERVICE_NAME],
            type: (getMaskValue(Mask.ANALOG, val[TvserviceModel.PLAY_ATTRIBUTES]) == 1)? CONST.ATV: CONST.DTV,
            attr: val[TvserviceModel.PLAY_ATTRIBUTES],
            favType: getMaskValue(Mask.FAVTYPE, val[TvserviceModel.PLAY_ATTRIBUTES]),
            isSkip: getMaskValue(Mask.SKIP, val[TvserviceModel.PLAY_ATTRIBUTES]),
            isLock: getMaskValue(Mask.LOCK, val[TvserviceModel.PLAY_ATTRIBUTES]),
            isEncrypt: getMaskValue(Mask.ENCRYPT, val[TvserviceModel.PLAY_ATTRIBUTES]),
            isHidden: getMaskValue(Mask.HIDDEN, val[TvserviceModel.PLAY_ATTRIBUTES]),
            playId: 0,//parseInt(val[MPChannel.LISTUID]) + 1,
            satId: 0,
            //eCode: !!ecode ? ecode : ECode.NONE,
            playTime: Date.now()
        };
        return tempChannel;
    }
    liveTV.mainTunerModePlayToChannel = mainTunerModePlayToChannel;
    /*function parseSourceList(arr) {
        //  ["TV","AVS","COMPONENT","HDMI1","HDMI2","HDMI3","HDMI4","DMP","VGA","SCART"]
        var srcKey = "EU" == GLOBAL.CURRENT_AREA ?
            [
                SourceList.TV, SourceList.AV,
                SourceList.COMPONENT, SourceList.SCART,
                SourceList.HDMI1, SourceList.HDMI2,
                SourceList.HDMI3, SourceList.HDMI4
            ] : "EM" == GLOBAL.CURRENT_AREA || "SA" == GLOBAL.CURRENT_AREA ?
            [
                SourceList.TV, SourceList.AV,
                SourceList.COMPONENT, SourceList.HDMI1,
                SourceList.HDMI2, SourceList.HDMI3,
                SourceList.HDMI4, SourceList.SCART
            ] : "NA" == GLOBAL.CURRENT_AREA ?
            [
                SourceList.TV, SourceList.AV,
                SourceList.COMPONENT, SourceList.HDMI1,
                SourceList.HDMI2, SourceList.HDMI3*//*, SourceList.HDMI4*//*    //6586 don't have HDMI4
            ] : [];
        if (!tv) {
            var itemCount = 6, items = [];
            for (var i = 0; i < arr.length / itemCount; i++) {
                var row = arr.slice(i * itemCount, (i + 1) * itemCount);
                items.push({
                    uid: row[SourceAttr.UID],
                    innerId: srcKey[row[SourceAttr.UID]],
                    name: row[SourceAttr.NAME],
                    noSignal: 1 == row[SourceAttr.SIGNAL],
                    isLock: 1 == row[SourceAttr.LOCK],
                    rename: !!row[SourceAttr.RENAME] ? row[SourceAttr.RENAME] : row[SourceAttr.NAME],
                    hotelLock: 1 == row[SourceAttr.HOTELLOCK]
                });
            }
            return items;
        }
        var itemCount = 3, items = [];
        for (var i = 0; i < arr.length / itemCount; i++) {
            var row = arr.slice(i * itemCount, (i + 1) * itemCount);
            items.push({
                uid: i,         //row[SourceAttr.UID],
                innerId: srcKey[i],     //srcKey[row[SourceAttr.UID]],
                name: row[0],   //row[SourceAttr.NAME],
                noSignal: row[1],    //1 == row[SourceAttr.SIGNAL],
                isLock: 0,      //1 == row[SourceAttr.LOCK],
                rename: row[2], //!!row[SourceAttr.RENAME] ? row[SourceAttr.RENAME] : row[SourceAttr.NAME],
                hotelLock: 0    //1 == row[SourceAttr.HOTELLOCK]
            });
        }
        return items;
    }*/


    function updateAttributeByChannel(chnls, channeluid, playId, keyIdx, val) {
        if (!chnls || 0 == chnls.length) return false;
        var ret = objectFindByKey(chnls, ["uid", "listUid"], [channeluid, playId]);
        if (null != ret) {
            ret[SPChannel.ARRAY[keyIdx]] = val;
            if (keyIdx == SPChannel.ATTRIBUTE) {
                setFlagByAttr(ret, val);
            }

            if (compareChannel(ret, crntChannel)) {
                crntChannel[SPChannel.ARRAY[keyIdx]] = val;
                if (keyIdx == SPChannel.ATTRIBUTE) {
                    setFlagByAttr(crntChannel, val);
                }
            }
            if (compareChannel(ret, lastChannel)) {
                lastChannel[SPChannel.ARRAY[keyIdx]] = val;
                if (keyIdx == SPChannel.ATTRIBUTE) {
                    setFlagByAttr(lastChannel, val);
                }
            }
        }
        else {
            DBG_ERROR("can not find channel[" + channeluid + "]");
        }
    }

    function clearAllBlockByChannels(chnls) {
        if (!chnls || 0 == chnls.length) return false;
        chnls.forEach(function (item) {
            item.attr = item.attr & 65279;
            item.isLock = false;
        });
    }

    function setHisChannelAfterEdit(chnl) {
        var ret = objectFindByKey(oprtData.hisChannels, ["uid", "playId"], [chnl.uid, chnl.playId]);
        if (null == ret) return;
        ret.favType = chnl.favType;
        ret.isSkip = chnl.isSkip;
        if (ret.isSkip) {
            var idx = oprtData.hisChannels.indexOf(ret);
            oprtData.hisChannels.splice(idx, 1);
        }
        writeFileToNative("hisenseUI/recentWatch", objToString(oprtData.hisChannels), 1);
    }

    function resetChannelsAfterSkip(listName, channels) {
        var i, chnls = [], favChnls = [];
        for (i = 0; i < channels.length; i++) {
            var chnl = channels[i];
            if (chnl.isSkip ) continue;//|| chnl.isHidden || !chnl.isVisible
            if (chnl.favType) favChnls.push(chnl);
            chnls.push(chnl);
        }
        oprtData.allChannels[listName] = chnls;
        oprtData.favChannels[listName] = favChnls;
    }

    liveTV.getNoSignalFlag = function (recheck) {
        var noSignal = false;
        if (GLOBAL.CURRENT_SOURCE == SourceList.TV) {
            noSignal = GLOBAL.S_NO_SIGNAL || GLOBAL.S_NO_CHANNEL;
        }
        else {
            noSignal = GLOBAL.S_NO_SIGNAL;
        }
        DBG_WARN("noSignal[" + noSignal + "]");
        return noSignal;
    }
    liveTV.getHasChannelFlag = function () {
        try {
            DBG_ERROR("has channel [" + !GLOBAL.S_NO_CHANNEL + "]");
            return !GLOBAL.S_NO_CHANNEL;

            /*//writeFileToNative("hisenseUI/channelListSaved", cty, 1);
            //文件写了之后立即读似乎有问题
            var flag = tv ? readFileFromNative("hisenseUI/channelListSaved", 1) : "true";
            //var len = liveTV.getRefChannels().length;
            //DBG_INFO("............................Current allChannels length: " + len + ".........................");
            //var flag = Config.tv ? parseInt(model.tvservice.getChannelListSaved()) : 1;
            //var flag = len === 0 ? 0 : 1;
            if (null == flag) {
                flag = "false";
                DBG_ERROR("reset channelListSaved to " + flag);
                writeFileToNative("hisenseUI/channelListSaved", flag, 1);   //写文件接口不能直接存数字
            }
            DBG_INFO("has channel [" + flag + "]");
            return ("true" == (flag + ""));*/
        }
        catch (ex) {
            DBG_ERROR("getHasChannelFlag error: " + ex.message);
            return true;
        }
    }
    liveTV.getCurrentListAllChannels = function () {
        var listName = oprtData.crntList.name;
        if (!oprtData.fullChannels[listName]) {
            return [];
        }
        else {
            var chnls = oprtData.fullChannels[listName];
            return chnls;
        }
    }
    liveTV.getRefChannels = function () {
        DBG_INFO("crntList.name[" + oprtData.crntList.name + "]");
        if (!oprtData.allChannels[oprtData.crntList.name]) {
            return [];
        }
        else {
            var listKey = oprtData.crntList.name;
            var chnls = oprtData.allChannels[listKey];//.concat(oprtData.skipped[listKey]);
            //chnls.sort(function (a, b) {
            //    return (a.oriIndex - b.oriIndex);
            //});
            return chnls;
        }
    }

    liveTV.updateChannelAttribute = function (listUid, channeluid, playId, keyIdx, val) {
        if (channeluid == crntChannel.uid) {
            liveTV.recheckCurrentChannelInfo();
        }
        var lst;
        if (-1 == listUid) {
            lst = oprtData.crntList;
        }
        else {
            lst = objectFindByKey(oprtData.allLists, "uid", listUid);
        }
        if (null == lst) return false;
        updateAttributeByChannel(oprtData.allChannels[lst.name], channeluid, playId, keyIdx, val);
        updateAttributeByChannel(oprtData.favChannels[lst.name], channeluid, playId, keyIdx, val);
        updateAttributeByChannel(oprtData.hisChannels, channeluid, playId, keyIdx, val);
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
    }

    liveTV.clearChannelBlock = function () {
        for (var i = 0; i < oprtData.allLists.length; i++) {
            DBG_INFO("clear list[" + oprtData.allLists[i].name + "] channel lock state");
            clearAllBlockByChannels(oprtData.allChannels[oprtData.allLists[i].name]);
            clearAllBlockByChannels(oprtData.favChannels[oprtData.allLists[i].name]);
            clearAllBlockByChannels(oprtData.hisChannels);
        }
        DBG_INFO("all channels' lock state have been cleared");
        liveTV.recheckCurrentChannelInfo();
        if (Config.tv) GLOBAL.PARENTAL_LOCK_SWITCH = parseInt(model.parentlock.getSModel());
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
    }

    liveTV.updateSourceAttribute = function (sourceuid, keyIdx, val) {
        var ret = objectFindByKey(GLOBAL.SOURCE_LIST, "id", sourceuid);
        if (null != ret) {
            ret[SourceAttr.ARRAY[keyIdx]] = val;
        }
        else {
            DBG_ERROR("can not find source id [" + sourceuid + "]");
        }
    };

    liveTV.clearSourceBlock = function(){
        for (var i = 0; i < GLOBAL.SOURCE_LIST.length; i++) {
            var ret = GLOBAL.SOURCE_LIST[i];
            if (null != ret) {
                ret[SourceAttr.ARRAY[SourceAttr.LOCK]] = false;
            }
        }
    };
    liveTV.updateListAttribute = function (listuid, satId, keyIdx, val) {
        var ret = objectFindByKey(oprtData.crntList, ["uid", "satId"], [listuid, satId]);
        if (null != ret) {
            ret[ChannelList.ARRAY[keyIdx]] = val;
        }
        else {
            DBG_ERROR("can not find list[" + listuid + "]")
        }
    }

    liveTV.checkOperateTip = function () {
        return (GLOBAL.CURRENT_SOURCE == SourceList.TV && userMode && firstPlay && !liveTV.channelListInitFlag() && liveTV.getHasChannelFlag());
    }

    liveTV.isCountryDisableKeyBack = function (country) {
        var disableBackMap = ["GBR", "AUS", "NZL", "gbr", "aus", "nzl"];
        return (disableBackMap.indexOf(country) > -1);
    }

    liveTV.setHisChannelAfterEdit = setHisChannelAfterEdit;

    function checkInitAgain() {
        initingList = false;
        if (initAgain) {
            DBG_ALWAYS("do init channel list again.");
            initAgain = false;
            liveTV.initChannelList();
        }
        return initingList;
    }

    function readChannelOneByOne(idx) {
        try {
            var lst = oprtData.allLists[idx];
            channelIterator[lst.name] = createChannelIterator(lst, onGetChannels);
            if (null != channelIterator[lst.name]) {
                DBG_INFO("fetchTotalCount:::" + lst.name);
                channelIterator[lst.name].fetchTotalCount();
            }
            else {
                initingList = false;
                DBG_ERROR("create channel iterator failed.");
            }
        }catch (ex) {
            DBG_ERROR("readChannelOneByOne: " + ex.message);
        }
    }

    function onGetChannelList(m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            //DBG_ALWAYS(m_event);
            oprtData.allLists = eventRowsToChannelList(m_event.rows);
            DBG_ERROR("oprtData.allLists is " + objToString(oprtData.allLists));
            readedCount = 0;
            readChannelOneByOne(0);
        }
    }

    function setChannelListSaved() {
        try {
            var keys = Object.keys(oprtData.fullChannels);
            var hasChannels = "false";

            for (var i = 0; i < keys.length; i++) {
                if (oprtData.fullChannels[keys[i]].length > 0) {
                    hasChannels = "true";
                    break;
                }
            }

            //tv && writeFileToNative("hisenseUI/channelListSaved", hasChannels, 1);  //写文件接口不能直接存数字

            GLOBAL.S_NO_CHANNEL = ("false" == hasChannels);
            fetchSignalAndPublish();

            tryToShowOperateTip();
        }
        catch (ex) {
            DBG_ERROR("setChannelListSaved: " + ex.message);
        }
    }

    function onGetChannels(list, m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_ERROR("onGetChannels TableIterator.EVENT_TYPE_ROWS_READ");
            eventRowsToChannels(m_event.rows, list);
            DBG_ERROR("oprtData.allChannels[" + list.name + "] is " + oprtData.allChannels[list.name].length);
            if (readCount > m_event.rows.length)
                readCount -= m_event.rows.length;
            else {
                readCount = 0;
                if (oprtData.allLists.length == ++readedCount) {
                    if (!checkInitAgain()) {
                        DBG_ERROR("all list gotted");
                        setChannelListSaved();
                        resetChannelListIndex();
                        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
                    }
                }
                else {
                    readChannelOneByOne(readedCount);
                }
                tv && channelIterator[list.name].disconnect();
            }
        }
        else if (m_event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            DBG_ERROR("total channels of list[" + list.name + "] is " + m_event.totalCount);
            oprtData.fullChannels[list.name] = [];
            oprtData.allChannels[list.name] = [];
            oprtData.favChannels[list.name] = [];
            oprtData.channelNumberGrp[list.name] = [];
            maxNumLenMaps[list.name] = 0;
            readCount = m_event.totalCount;
            if (m_event.totalCount == 0) {
                onGetChannels(list, {type: TableIterator.EVENT_TYPE_ROWS_READ, rows: []});
            }
            else {
                !tv && channelIterator[list.name].readNextRows(m_event.totalCount);
            }
        }else {
            DBG_INFO("other type ________________" + m_event.type);
        }
    }
    liveTV.disconnectAllChannelIterator = function() {
        try {
            var item;
            for (item in channelIterator) {
                DBG_ERROR("item: " + item);
                releaseIterator(channelIterator[item]);
            }
            initingList = false;
        }
        catch (ex) {
            DBG_ERROR("disconnectAllChannelIterator: " + ex.message);
        }
    }
    function eventRowsToChannelList(rows) {
        var lists = [], founded = false;
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i], lst = {};
            lst.name = !!row[ChannelList.NAME] ? row[ChannelList.NAME] : "N/A";
            lst.uid = row[ChannelList.UID];
            lst.satId = row[ChannelList.ATTRIBUTE];
            lst.display = 1 == row[ChannelList.DISPLAY];
            lst.rights = 1 == row[ChannelList.RIGHTS];

            if (null != crntChannel &&
                lst.uid == crntChannel.listUid &&
                lst.satId == crntChannel.satId) {
                founded = true;
                oprtData.crntList = copyObj(lst);
            }
            oprtData.favChannels[lst.name] = [];
            lists.push(lst);
        }
        if (!founded) {
            DBG_ERROR("can not find current list by current channel[" + objToString(crntChannel) + "]");
        }
        return lists;
    }


    function eventRowsToChannels(rows, list) {
        //var chnls = [], AllCurchnls = [];
        //maxNumLenMaps[list.name] = 0;
        DBG_INFO("Calling eventRowsToChannels");

        //oprtData.channelNumberGrp[list.name] = [];

        for (var i = 0; i < rows.length; i++) {
            var row = rows[i], chnl = {};
            chnl.oriIndex = i;
            chnl.name = row[SPChannel.NAME];
            chnl.number = row[SPChannel.NUMBER];
            chnl.frontend = row[SPChannel.FRONTEND];
            chnl.uid = row[SPChannel.UID];
            chnl.type = 0;//row[SPChannel.TYPE];
            chnl.attr = parseInt(row[SPChannel.ATTRIBUTE]);
            chnl.listUid = list.uid;
            chnl.satId = ("NA" == GLOBAL.CURRENT_AREA) ? 0 : list.satId;
            chnl.playId = 0;//("NA" == GLOBAL.CURRENT_AREA) ? parseInt(list.uid) + 1 : row[SPChannel.PLAYID];
            chnl.serviceType = 2;//row[SPChannel.SERVICETYPE];
            chnl.program = {name: "", startTime: 0, endTime: 0};
            chnl.updateTime = 0;
            setFlagByAttr(chnl, chnl.attr);
            /*if (chnl.isAnalog)
                chnl.number = row[SPChannel.MAJORCHANNELNUMBER];//row[SPChannel.NUMBER];
            else
                chnl.number = row[SPChannel.MAJORCHANNELNUMBER] + "-" + row[SPChannel.MINORCHANNELNUMBER];//row[SPChannel.NUMBER];
            */
            oprtData.fullChannels[list.name].push(chnl);
            //if (chnl.isSkip || chnl.isHidden || !chnl.isVisible) {
                //if (compareChannel(lastChannel, chnl)) {
                    //lastChannel = null;
                //}
                //continue;
            //}
            if(chnl.isSkip)
            {
                continue;
            }

            !!chnl.number && (oprtData.channelNumberGrp[list.name].push(chnl.number));

            if (2 == chnl.serviceType && compareChannel(chnl, crntChannel)) {
                //TODO: show radio only
            }
            maxNumLenMaps[list.name] = Math.max(maxNumLenMaps[list.name], ("" + chnl.number).length);
            oprtData.allChannels[list.name].push(chnl);
            if (chnl.favType) {
                maxNumLenMaps["FAV"] = Math.max(maxNumLenMaps["FAV"], ("" + chnl.number).length);
                oprtData.favChannels[list.name].push(chnl);
            }
        }

        //return chnls;
    }

    function updateFullChannels(newName, oldName) {
        try {
            oprtData.fullChannels[newName] = oprtData.fullChannels[oldName];
            delete oprtData.fullChannels[oldName];
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onUpdateListName(m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_ALWAYS("list updated: " + objToString(m_event));
            if(!Config.tv) m_event.rows[0][0] = "updateA";
            oprtData.allLists = eventRowsToChannelList(m_event.rows);
            var keys = Object.keys(oprtData.allChannels);
            DBG_ALWAYS("old list name: " + objToString(keys));
            for (var i = 0; i < keys.length; i++) {
                var tempChnl = !!oprtData.allChannels[keys[i]] ? oprtData.allChannels[keys[i]][0] : null;
                if (!tempChnl) continue;
                var lst = objectFindByKey(oprtData.allLists, ["uid", "satId"], [tempChnl.listUid, tempChnl.satId]);
                if (lst.name != keys[i]) {
                    DBG_ALWAYS("update " + keys[i] + " to " + lst.name);
                    oprtData.allChannels[lst.name] = oprtData.allChannels[keys[i]];
                    delete oprtData.allChannels[keys[i]];
                    updateFullChannels(lst.name, keys[i]);
                }
                else {
                    DBG_ALWAYS("do not need update " + lst.name);
                }
            }
            resetChannelListIndex();
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
        }
    }

    function listNameUpdateNotify() {
        DBG_ALWAYS("receive channel list name update.");
        if (initingList) {
            DBG_ALWAYS("channel list is initing, will init again after inited.");
            initAgain = true;
            return;
        }
        listIterator = createListIterator(onUpdateListName);
        listIterator.readNextRows(20);
    }

    function onUpdateList(listUid, m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_ALWAYS("list updated: " + objToString(m_event));
            oprtData.allLists = eventRowsToChannelList(m_event.rows);
            var lst = objectFindByKey(oprtData.allLists, "uid", listUid);
            channelUpdateIterator = createChannelIterator(lst, onUpdateChannels, 0);
            if (null != channelUpdateIterator) {
                channelUpdateIterator.fetchTotalCount();
            }
            else {
                initingList = false;
            }
        }
    }


    function onUpdateChannels(list, m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            initingList = false;
            eventRowsToChannels(m_event.rows, list);
            DBG_ALWAYS("list[" + list.name + "] channels updated.");
            if (readCount > m_event.rows.length)
                readCount -= m_event.rows.length;
            else {
                readCount = 0;
                if (!checkInitAgain()) {
                    resetChannelListIndex();
                    UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
                }
            }
        }
        else if (m_event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            DBG_ALWAYS("total channels of list[" + list.name + "] is " + m_event.totalCount);
            oprtData.fullChannels[list.name] = [];
            oprtData.allChannels[list.name] = [];
            oprtData.favChannels[list.name] = [];
            oprtData.channelNumberGrp[list.name] = [];
            maxNumLenMaps[list.name] = 0;
            readCount = m_event.totalCount;
            if (m_event.totalCount == 0) {
                onUpdateChannels(list, {type: TableIterator.EVENT_TYPE_ROWS_READ, rows: []});
            }
            else {
                !tv && channelUpdateIterator.readNextRows(m_event.totalCount);
            }
        }
    }

    function listUpdateNotify(listUid) {
        if (listUid > 10) {
            listUid -= 10;
        }
        DBG_INFO("receive channel list update[" + listUid + "].");
//        if (!checkLiveTVState(null)) return;
        if (UI.getCurrSubModule().name == "ChAutoScanPanel" || UI.getCurrSubModule().name == "ChManualScanPanel") {
            return;
        }
        /*var tempList = objectFindByKey(oprtData.allLists, "uid", listUid);
        if (initingList) {
            DBG_WARN("channel list is reading, do not receive update.");
        }
        else if (Config.tv && 1 == model.channelSearch.getRunning()) {
            DBG_WARN("channel searching, do not receive update.");
        }
        else if (null == tempList) {
            DBG_ALWAYS("can not find this list[" + listUid + "], recheck.");
            initingList = true;
            listIterator = createListIterator(onUpdateList.bind(this, listUid-1));
            listIterator.readNextRows(20);
        }
        else {
            initingList = true;
            listIterator = createListIterator(onUpdateList.bind(this, listUid-1));
            listIterator.readNextRows(20);
            listUpdateIterator = createChannelIterator(tempList, onUpdateChannels, 0);
            listUpdateIterator.fetchTotalCount();
        }*/
        liveTV.initChannelList();
    }

    /**
     * 返回需要切到的频道
     * @param chn
     */
    liveTV.onGetNameToInfo = onGetNameToInfo;
    function onGetNameToInfo(chn) {
         DBG_ERROR("onGetNameToInfo " + chn);
         if(!chn || chn =="NULL") {
            DBG_ERROR("can not find chn");
            return;
        }
         if (chn.length > 2) {
         var tmpcnl = {
             playId: "1",
             uid: "123",
             listUid: "0"
         };
         tmpcnl.playId = chn[0];
         tmpcnl.uid = chn[1];
         tmpcnl.listUid = chn[2];
         //changChannelByOBJ(tmpcnl);
         var ch = setStateBefChangeChannel(ChangeType.LIST_UID, tmpcnl.uid);
         liveTV.changeChannel(ch);
         channelChangeTime++;
         if (channelChangeTime > 100) {
             if (window.gc) window.gc();
                channelChangeTime = 0;
             }
         }
    }

    function setFlagByAttr(chnl, attr) {
        chnl.isSkip = getMaskValue(Mask.SKIP, attr);
        chnl.favType = getMaskValue(Mask.FAVTYPE, attr);
        chnl.isLock = getMaskValue(Mask.LOCK, attr);
        chnl.isEncrypt = getMaskValue(Mask.ENCRYPT, attr);
        chnl.isVisible = getMaskValue(Mask.VISIBLE, attr);
        chnl.isHidden = getMaskValue(Mask.HIDDEN, attr);
        chnl.isAnalog = getMaskValue(Mask.ANALOG, attr);
        chnl.audioOnly = getMaskValue(Mask.AUDIOONLY, attr);
    }

    function getRecentWatch() {
        var obj = Config.tv ? readFileFromNative("hisenseUI/recentWatch", 1) : [liveTV.PCChannel];
        if (null == obj) return [];
        return obj;
    }

    function setRecentWatch(chnl) {
        DBG_INFO("current channel IS [" + chnl.name + "]");
        var duration = Math.abs(Date.now() - chnl.playTime) / 1000;
        if (duration >= 5 * 60 || !Config.tv) {
            for (var i = 0; i < oprtData.hisChannels.length; i++) {
                if (compareChannel(oprtData.hisChannels[i], chnl)) {
                    oprtData.hisChannels.splice(i, 1);
                    break;
                }
            }
            chnl.duration = duration;
            oprtData.hisChannels.push(copyObj(chnl));
            oprtData.hisChannels.sort(function (a, b) {
                return (b.duration - a.duration);
            });
            writeFileToNative("hisenseUI/recentWatch", objToString(oprtData.hisChannels), 1);
        }
        else {
            DBG_INFO("current channel play time[" + duration + "] is too close ," +
            " do not need set recent watch.");
        }
    }

    function onSkipEdit(ret) {
        var val = ret[0], channelId = ret[1], listName = oprtData.crntList.name;
        var obj = objectFindByKey(oprtData.fullChannels[listName], "uid", channelId);
        if (null != obj) {
            obj.isSkip = (1 == val);
            obj.attr = obj.isSkip ?  obj.attr | ServicelistModel.SERVICE_BITMASK_IS_SKIPPED : obj.attr & (~ServicelistModel.SERVICE_BITMASK_IS_SKIPPED) ;
            resetChannelsAfterSkip(listName, oprtData.fullChannels[listName]);
            setHisChannelAfterEdit(obj);
            oprtData.channelIndex = getCurrentChannelIndex(oprtData.crntList, crntChannel);
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
        }
        else {
            DBG_ERROR("can not find channel[" + channelId + "]");
        }
    }
    liveTV.RefreshAftFavEdit  =function(Chnl){
        var listName = oprtData.crntList.name;
        tv && liveTV.updateChannelAttribute(-1,Chnl.uid,Chnl.listUid,SPChannel.ATTRIBUTE,Chnl.attr);
        oprtData.favChannels[listName] = liveTV.getFavChannels(oprtData.allChannels[listName]);
        resetChannelListIndex();
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
    }
    liveTV.getFavChannels =function(chnls) {
        var i, favChannels = [];
        for (i = 0; i < chnls.length; i++) {
            if (chnls[i].favType) favChannels.push(chnls[i]);
        }
        return favChannels;
    }
    liveTV.initChannelList = function (firstLoad) {
        if (initingList) {
            DBG_ERROR("channel list is initing, will init again after inited.");
            initAgain = true;
            return;
        }
        DBG_ERROR("begin get all list");
        oprtData.allLists = [];
        oprtData.allChannels = {};
        oprtData.favChannels = {};
        oprtData.hisChannels = [];
        oprtData.crntList = {};
        oprtData.fullChannels = {};
        initingList = true;
        initAgain = false;
        //lastChannel = null;
        if (firstLoad) {
            oprtData.hisChannels = getRecentWatch();
        }
        else {
            DBG_INFO("channel list updated, remove history channel.");
            writeFileToNative("hisenseUI/recentWatch", "[]", 1);
        }
        channelIterator = {};
        DBG_INFO("Calling createListIterator");
        listIterator = createListIterator(onGetChannelList);
        if (null != listIterator) {
        DBG_INFO("listIterator.readNextRows.");
            listIterator.readNextRows(20);
        }
        else {
            DBG_ERROR("create list iterator failed.");
        }
    };

    liveTV.delHisChannels = function() {
        {
            DBG_INFO("channel list updated, remove history channel.");
            writeFileToNative("hisenseUI/recentWatch", "[]", 1);
            oprtData.hisChannels = getRecentWatch();
        }
    }

    liveTV.channelListInitFlag = function () {
        return initingList;
    }

    liveTV.getChannelListOprtData = function () {
        oprtData.listIndex = GLOBAL.CURRENT_CHLIST_INDEX;
        return oprtData;
    }
    liveTV.setChannelListOprtData = function (listIndex, channelIndex) {
        try {
            GLOBAL.CURRENT_CHLIST_INDEX = listIndex;
            oprtData.channelIndex = channelIndex;
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function findChannelByNum(list, num) {
        var chnls = liveTV.getChannelsByListIndex(list.name, GLOBAL.CURRENT_CHLIST_INDEX);
        if (!chnls || 0 == chnls.length) return null;
        var chnl = chnls.filter(function (v) {
            return v.number == num;
        })[0];

        if (chnl) return chnl;
        var len = (num + "").length;
        chnl = chnls.filter(function (v) {
            return v.number.substring(0, len) == num;
        })[0];
        return chnl;
    }

    function getCurrentListByChannel(chnl) {
        if (null != chnl)
            DBG_INFO("getCurrentListByChannel chnl isn't null");
        else
            DBG_INFO("getCurrentListByChannel chnl is null");
        var currentList = objectFindByKey(oprtData.allLists, ["uid", "satId"], [chnl.listUid, chnl.satId]);
        if (null == currentList || null == currentList.name) return null;
        var idx = 0;
        while (!currentList.display && idx < oprtData.allLists.length - 1) {
            currentList = oprtData.allLists[idx];
            idx++;
        }
        return currentList;
    }

    function getCurrentChannelIndex(list, chnl) {
        if (null == list) return 0;
        var idx = 0;
        var founded = false;
        var chnls = liveTV.getChannelsByListIndex(list.name, GLOBAL.CURRENT_CHLIST_INDEX);
        for (var i = 0; i < chnls.length; i++) {
            if (compareChannel(chnl, chnls[i])) {
                idx = i;
                founded = true;
                break;
            }
        }
        if (!founded) {
            DBG_ERROR("can not find the index.[" + objToString(chnl) + "], list[" + list.name + "], index[" + idx + "]");
        }
        return idx;
    }

    function resetChannelListIndex() {
        DBG_INFO("resetChannelListIndex");
        oprtData.listIndex = GLOBAL.CURRENT_CHLIST_INDEX;
        var tempList = getCurrentListByChannel(crntChannel);
        if (null == tempList)
            DBG_INFO("resetChannelListIndex tempList is null");
        oprtData.channelIndex = getCurrentChannelIndex(tempList, crntChannel);
        DBG_INFO("resetChannelListIndex oprtData.channelIndex is " + oprtData.channelIndex);
        if (null == tempList ||
            oprtData.crntList.uid != tempList.uid ||
            oprtData.crntList.satId != tempList.satId) {
            //oprtData.crntList = null != tempList ? tempList : {name: "N/A", uid: -1, satId: -1};

            var tunerList = [
                "N/A", "N/A", "N/A", "N/A", "N/A", "N/A",
                "Antenna", "Cable"
            ];

            if (null != tempList) {
                oprtData.crntList = tempList;
            }
            else {
                var listName;
                if (!!crntChannel) {
                    listName = tunerList[crntChannel.listUid];
                }
                if (!listName) {
                    listName = "N/A";
                }
                oprtData.crntList = {name: listName, uid: -1, satId: -1};
            }
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_UPDATED, oprtData);
        }
    }
    liveTV.resetChannelListIndex = resetChannelListIndex;

    function setChannelChangeFlag(flag) {
        chnlChging = flag;
        clearTimeout(chnlChgingTimer);
        if (!chnlChging) return;
        chnlChgingTimer = setTimeout(function () {
            DBG_ERROR("change channel timeout.");
            chnlChging = false;
            expectChannel = null;
            liveTV.recheckCurrentChannelInfo();
        }, 15000);
    }

    liveTV.getChannelChangeFlag = function () {
        return chnlChging;
    }

    /**
     * 调用底层接口切台
     * @param playId 参数未使用
     * @param uid 参数未使用
     * @param listUid 参数未使用
     * @param num 参数未使用
     * @param chnl
     */
    function playChannel(playId, uid, listUid, num, chnl) {
        setChannelChangeFlag(true);
        DBG_ERROR("change channel to " + chnl.number);
        if (checkLiveTVState(LIVETV.PASSWORD_DIALOG)/* && crntChannel.eCode != ECode.LOCK*/) {
            UI.popSubModule();
            openLiveTVModule([Msg.INFO, 0, Msg.PASSWORD, 0]);
        }
        if (checkLiveTVState(LIVETV.INFO_DETAIL)) {
            UI.popSubModule();
            openLiveTVModule([Msg.INFO, 0, Msg.PASSWORD, 0]);
        }

        expectChannel = {   //maybe need other property
            uid: uid
        };
        repeatKey_CHUPDOWN = false;
        if (Config.tv) {
            DBG_ERROR("lastChannelUid:"+lastChannelUid+"uid::"+uid);
            if (GLOBAL.CURRENT_SOURCE == SourceList.TV && lastChannelUid == uid) {  //compareChannel(chnl, crntChannel)
                liveTV.rePublishCurrentChannnelInfo();
                if(!!UI.getCurrSubModule() && UI.getCurrSubModule().name =="ChMainPanel"){
                    DBG_ERROR("ChMainPanel change tuner, UI play channel should release loading");
                    UI.endLoading();
                }
            }
            else {
                liveTV.clearVideoInfo();
                GLOBAL.S_LOCKING = false;   //reset here, wait notify
                GLOBAL.S_AUDIO_CHANNEL = false;
                fetchSignalAndPublish(true);
                if(CONST.KEY_STATE.REPEAT == UI.keyState && ("CHUP" == UI.currKeyValue || "CHDOWN" == UI.currKeyValue)){
                    DBG_ERROR("playChannel:channel up/down repeat not change send message to biz!!!");
                    repeatKey_CHUPDOWN = true;
                    mainPlayChanged([
                        chnl.listUid,
                        chnl.uid,
                        chnl.number,
                        "",
                        "",
                        chnl.name,
                        "",
                        "",
                        chnl.attr
                    ]
                    );
                }else{
                    DBG_ERROR("play change channel to :: " + chnl.uid);
                    lastChannelUid = chnl.uid;
                    model.tvservice.playChannel("0", chnl.uid);
                }
            }
        }
        else {
            mainPlayChanged([
                    chnl.listUid,
                    chnl.uid,
                    chnl.number,
                    "",
                    "",
                    chnl.name,
                    "",
                    "",
                    chnl.attr
                ]
            );
        }
    }

    liveTV.rePublishCurrentChannnelInfo = function() {
        try {
            DBG_ERROR("same channel, will publish fake channel info");
            clearTimeout(changeChannelTimer);
            var chnl = liveTV.getCurrentChannelInfo();
            changeChannelTimer = setTimeout(function () {
                mainPlayChanged([chnl.listUid, chnl.uid, chnl.number, chnl.tvType, "subType", chnl.name,
                    1, "frontend=" + chnl.playId, chnl.attr]);
            }, 1000);
        }
        catch (ex) {
            DBG_ERROR("rePublishCurrentChannnelInfo: " + ex.message);
        }
    };

    /**
     * 检查 chnl合法性，对于合法的频道调用切台函数
     * @param chnl
     * @returns {boolean}
     */
    liveTV.changeChannel = function (chnl) {
        if (!chnl) return false;
        DBG_INFO("liveTV.changeChannel  chnl.uid = " + chnl.uid);
        if (typeof(chnl) == "string" || typeof(chnl) == "number") {
            if ((chnl + "").indexOf(".") >= 0 || (chnl + "").indexOf("-") >= 0) {
                DBG_INFO("current channel do not need search");
            }
            else {
                playChannel(0, 0, 0, chnl, chnl);
            }
        }
        else {
            playChannel(chnl.playId, chnl.uid, chnl.listUid, 0, chnl);
        }
        return true;
    };

    liveTV.onFocus = function (target) {
        DBG_ONXX(LIVETV.MAIN, "onFocus");
    };
    liveTV.onPop = function (target) {
        DBG_ONXX(LIVETV.MAIN, "onPop");
    };

    liveTV.onkey_EXIT = liveTV.onkey_BACKSPACE = function (focus, evt) {
        liveTV.tryShowScreenSaver();
        var backChannel = false;
        switch (UI.getCurrSubModule().name) {
            case LIVETV.PASSWORD_DIALOG:
                UI.popSubModule();
                openLiveTVModule([Msg.PASSWORD, 0]);
                break;
            case LIVETV.SEARCH_DIALOG:
                UI.popSubModule();
                openLiveTVModule([Msg.SEARCH, 0]);
                break;
            case LIVETV.CHANNEL_LIST:
                /*UI.popSubModule();
                openLiveTVModule([Msg.INFO, (GLOBAL.CH_CHANED_ON_CHANNEL_LIST? 1: 0)]);
                GLOBAL.CH_CHANED_ON_CHANNEL_LIST = false;
                break;*/
            case LIVETV.OPERATE_TIP:
            case LIVETV.MENU_CHIP:
            case LIVETV.NUMBER_KEYBOARD:
                UI.popSubModule();
                openLiveTVModule([Msg.INFO, 0]);
                break;
            default :
                if (liveTV.isNumTipOn()) {
                    liveTV.cancelChangChByNum(true);
                }
                else {
                    if (!!lastChannel) {
                        if (lastChannel.isSkip == true || lastChannel.isHidden == true) {
                            lastChannel = null;
                        }
                        else {
                            var target = objectFindByKey(oprtData.allChannels[oprtData.crntList.name], ["uid", "listUid"], [lastChannel.uid, lastChannel.listUid]);
                            if (!target) {
                                lastChannel = null;
                            }
                        }
                    }
                    backChannel = (
                        evt.keyCode == CONST.KEY.VK_BACKSPACE &&
                        GLOBAL.CURRENT_SOURCE == SourceList.TV &&
                        null != lastChannel && !compareChannel(lastChannel, crntChannel) && !lastChannel.isSkip);
                }
                break;
        }
        if (backChannel) {
            var chnl = setStateBefChangeChannel(ChangeType.KEY_BACK, lastChannel)
            if (chnl) liveTV.changeChannel(chnl);
        }
        return false;
    }

    liveTV.changeToPreChannel = function() {
        var backChannel = (
            GLOBAL.CURRENT_SOURCE == SourceList.TV &&
            null != lastChannel && !compareChannel(lastChannel, crntChannel));
        if (backChannel) {
            var chnl = setStateBefChangeChannel(ChangeType.KEY_BACK, lastChannel);
            if (chnl) liveTV.changeChannel(chnl);
        }
    }

    function setStateBefChangeChannel(chType, parameter) {
        if (GLOBAL.SOURCE_CHANGING) {
            DBG_ERROR("Wait source change notify. Don't allow change channel.");
            return;
        }
        if (liveTV.channelListInitFlag()) {
            DBG_ERROR("ChannelList is initing");
            openToastPage(TOASTTYPE.READCHLTIP);
            return null;
        }

        var chnls = liveTV.getChannelsByListIndex(oprtData.crntList.name, GLOBAL.CURRENT_CHLIST_INDEX);
        if (chType == ChangeType.CH_DOWN || chType == ChangeType.CH_UP) {
            if ((!chnls || chnls.length < 1)) {
                return null;
            }
            else if (chnls.length == 1 && !compareChannel(chnls[0], liveTV.getCurrentChannelInfo())) {   //only one channel && different with current channel
                chType = ChangeType.CH_OBJ;
                oprtData.channelIndex = 0;
                parameter = chnls[oprtData.channelIndex]
            }
        }
	    if(chType == ChangeType.JUMP_OVER) {//跳过几个频道
            var numPar = Math.abs(parameter);
            if ((!chnls || chnls.length == 0) && chnls.length <= numPar) return null;
        }

        liveTV.clearLiveTVUI();
        var preChannel;
        switch (chType) {
            case ChangeType.CH_DOWN:
                oprtData.channelIndex = (oprtData.channelIndex == 0 ? chnls.length - 1 : oprtData.channelIndex - 1);
                preChannel = chnls[oprtData.channelIndex];
                break;
            case ChangeType.CH_UP:
                oprtData.channelIndex = (oprtData.channelIndex == chnls.length - 1 ? 0 : oprtData.channelIndex + 1);
                preChannel = chnls[oprtData.channelIndex];
                break;
            case ChangeType.CH_OBJ:
                preChannel = parameter;
                break;
            case ChangeType.CH_NUM:
                //find channel
                preChannel = findChannelByNum(oprtData.crntList, parameter);
                break;
            case ChangeType.KEY_BACK:
                preChannel = copyObj(parameter);
                break;
            case ChangeType.LIST_UID:
                for(var i = 0; i < chnls.length; i++) {
                    DBG_ERROR("parameter = " + parameter +", parameter chnls[i].uid " + chnls[i].uid);
                    if(parameter == chnls[i].uid) {
                        preChannel = chnls[i];
                        break;
                    }
                }
                break;
	    case ChangeType.JUMP_OVER:
                 if (!!GLOBAL.SKIP_AS_CURRENT_CHANNEL/* && oprtData.fullChannels[oprtData.crntList.name].length < 2*/) {
                     GLOBAL.SKIP_AS_CURRENT_CHANNEL = false;
                     preChannel = getChannelShipAsCrntChannel(ChangeType.JUMP_OVER, parameter);
                 }
                 else {
                     var newIndex = oprtData.channelIndex + parameter;
                     if(newIndex >= chnls.length) {
                         oprtData.channelIndex = newIndex - chnls.length;
                     } else if(newIndex < 0) {
                         oprtData.channelIndex = newIndex + chnls.length;
                     } else {
                         oprtData.channelIndex = newIndex;
                     }
                     preChannel = chnls[oprtData.channelIndex];
                 }
                break;
            default :
                break
        }
        if (!compareChannel(lastChannel, crntChannel) && !compareChannel(crntChannel, preChannel)) {
            if(!!preChannel) {
                setRecentWatch(crntChannel);
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.SET_RECENT_WATCH, preChannel)
                lastChannel = crntChannel;
            }
        } else {
            DBG_INFO("not remember,same channel " + crntChannel.name)
        }

        if (!lastChannel || lastChannel.isSkip || lastChannel.isHidden || lastChannel.uid == 0) lastChannel = null;
        liveTV.drawShortInfo(preChannel);
        return preChannel;
    }

    var channelChangeTime = 0;
    var disableChKey = false;
    var disableChKeyTimer = 0;
    var disableKey_CHDOWN = false;
    var disableKey_CHUP = false;
    var repeatKey_CHUPDOWN = false;
    liveTV.repeatKey_CHUPDOWN_flag = function(){
        DBG_ERROR("liveTV.repeatKey_CHUPDOWN_flag:repeatKey_CHUPDOWN = "+repeatKey_CHUPDOWN);
        return repeatKey_CHUPDOWN;
    }
    function clearDisableChKeyFlag() {
        disableChKey = false;
        clearTimeout(disableChKeyTimer);

        if ("CHDOWN" == UI.currKeyValue && !disableKey_CHDOWN) {    //MSD6586US-1835 avoid accidental double hits
            disableKey_CHDOWN = true;
            setTimeout(function() {
                disableKey_CHDOWN = false;
            }, 250);
            if(tv && crntChannel && repeatKey_CHUPDOWN){
                repeatKey_CHUPDOWN =false;
                DBG_ERROR("clearDisableChKeyFlag:release key play");
                lastChannelUid = crntChannel.uid;
                model.tvservice.playChannel("0", crntChannel.uid);
            }
            channelChangeTime++;
        }
        else if ("CHUP" == UI.currKeyValue && !disableKey_CHUP) {
            disableKey_CHUP = true;
            setTimeout(function() {
                disableKey_CHUP = false;
            }, 250);

            if(tv && crntChannel && repeatKey_CHUPDOWN){
                repeatKey_CHUPDOWN =false;
                DBG_ERROR("clearDisableChKeyFlag:release key play");
                lastChannelUid = crntChannel.uid;
                model.tvservice.playChannel("0", crntChannel.uid);
            }
            channelChangeTime++;
        }
    }
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearDisableChKeyFlag);

    liveTV.onkey_CHDOWN = function (k) {
        if (disableChKey || disableKey_CHDOWN) {
            DBG_ERROR("disableChKey for press");
            return;
        }
        if (CONST.KEY_STATE.DOWN == UI.keyState) {
            disableChKey = true;
            clearTimeout(disableChKeyTimer);
            disableChKeyTimer = setTimeout(function() {
                disableChKey = false;
            }, 900);
        }

        if (GLOBAL.CURRENT_SOURCE != SourceList.TV) return false;
        var chnl = setStateBefChangeChannel(ChangeType.CH_DOWN, -1);
        if (chnl) liveTV.changeChannel(chnl);
        channelChangeTime++;
        if (channelChangeTime > 100) {
            if (window.gc) window.gc();
            channelChangeTime = 0;
        }
    };

    liveTV.onkey_CHUP = function (k) {
        if (disableChKey || disableKey_CHUP) {
            DBG_ERROR("disableChKey for press");
            return;
        }
        if (CONST.KEY_STATE.DOWN == UI.keyState) {
            disableChKey = true;
            clearTimeout(disableChKeyTimer);
            disableChKeyTimer = setTimeout(function () {
                disableChKey = false;
            }, 900);
        }

        if (GLOBAL.CURRENT_SOURCE != SourceList.TV) return false;
        var chnl = setStateBefChangeChannel(ChangeType.CH_UP, 1);
        if (chnl) liveTV.changeChannel(chnl);
        channelChangeTime++;
        if (channelChangeTime > 100) {
            if (window.gc) window.gc();
            channelChangeTime = 0;
        }
    };

    /**
     * 跳过 n 个频道
     * @param n
     * @returns {boolean}
     */
    liveTV.jumpOver = function (n) {
        DBG_ERROR("change Channel by jumpOver: " + n);
        if (!UI.getCurrModule() || LIVETV.MAIN != UI.getCurrModule().name){
            DBG_ERROR("liveTV.jumpOver LIVETV.MAIN != UI.getCurrModule().name return");
            return false;
        }
        if (GLOBAL.CURRENT_SOURCE != SourceList.TV) return false;
        if (liveTV.channelListInitFlag()) {
            DBG_ERROR("ChannelList is initing");
            return;
        }
        if(isNaN(n)) {
            DBG_ERROR("no a number " + n);
            return
        }
        var chnl = setStateBefChangeChannel(ChangeType.JUMP_OVER, n);
        if (chnl) liveTV.changeChannel(chnl);
        channelChangeTime++;
        if (channelChangeTime > 100) {
            if (window.gc) window.gc();
            channelChangeTime = 0;
        }
    };

    /**
     * 根据频道名称切台
     * @param channelName
     * @returns {boolean}
     */
    liveTV.changeChannelByName = function (channelName) {
        DBG_ERROR("change Channel by name");
        if (!UI.getCurrModule() || LIVETV.MAIN != UI.getCurrModule().name){
            DBG_ERROR("changeChannelByName LIVETV.MAIN != UI.getCurrModule().name return");
            return false;
        }
        if (GLOBAL.CURRENT_SOURCE != SourceList.TV) return false;
        if (liveTV.channelListInitFlag()) {
            DBG_ERROR("ChannelList is initing");
            return;
        }
        //var svlId = "1";  // 预留字段
        tv ? model.tvservice.setNameToInfo(createStringVector([channelName])):0;
    };

    liveTV.onkey_MENU = function () {
            UI.popSubModule();
        //var curModeIndex = tv? model.system.getUserMode(): 0;
        //if(curModeIndex != 0){
        //    UI.pushSubModule("setting",  "storeModeSettingMenu", true, {origin:"liveTV"});
        //}
        //else{
            UI.pushSubModule("setting", "menuChip", true, {origin: "liveTV"});
        //}
    }

    liveTV.setStateBefChangeChannel = setStateBefChangeChannel;

    liveTV.resetChnnelListIndex = resetChannelListIndex;

    liveTV.resetChnnelIndex = function() {
        oprtData.listIndex = GLOBAL.CURRENT_CHLIST_INDEX;
        var tempList = getCurrentListByChannel(crntChannel);
        oprtData.channelIndex = getCurrentChannelIndex(tempList, crntChannel);
    }

    liveTV.PCChannel = {
        "number": "1",
        "name": "DC04 1080i",
        "uid": "262273",
        "type": "2",
        "attr": 8719,
        "listUid": "7",
        "satId": "0",
        "playId": "2",
        "serviceType": "1",
        "updateTime": 0,
        "isSkip": false,
        "favType": true,
        "isLock": true,
        "isEncrypt": true,
        "eCode": ECode.NONE
    };
    liveTV.PCSourceList = [
        "0", "ANT/Cable", "0", "0", "", "0",
        "1", "AV", "1", "0", "", "0",
        "2", "COMPONENT", "1", "0", "", "0",
        "3", "HDMI 1", "1", "0", "", "0",
        "4", "HDMI 2", "1", "0", "", "0",
        "5", "HDMI 3", "1", "0", "", "0",
        "6", "HDMI 4", "1", "0", "", "0"
    ];

    if (Config.tv) {
        //model.tvservice.onChannelListNameUpdate = listNameUpdateNotify;
        //model.tvservice.onChannelListUpdate = listUpdateNotify;
	    //model.tvservice.onNameToInfo = onGetNameToInfo;
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_LIST_NAME_UPDATE, listNameUpdateNotify);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_LIST_UPDATE, listUpdateNotify);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.GET_NAME_TO_INFO, onGetNameToInfo);
    }
    else{
        liveTV.listNameUpdateNotify = listNameUpdateNotify;
        liveTV.listUpdateNotify = listUpdateNotify;
    }
    liveTV.initLiveTV(true);
    liveTV.initChannelList(true);
    DBG_ALWAYS("liveTV init complete!!!");
    GLOBAL.CURRENT_SVR_MSG = tv? model.tvservice.getNoSignalMain(): 0;
    DBG_ALWAYS("GLOBAL.CURRENT_SVR_MSG is " + GLOBAL.CURRENT_SVR_MSG);

    try{
        //sysUpgradeInit();
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SKIP_SET, onSkipEdit);
})();

function onFocusLiveTVTarget(target, scale, duration, noMarquee, curAlpha) {
    UI.moveCursor();
    UI.adjustView();
    //UI.getTween(target.scale).to({x: scale, y: scale}, duration, UI.ease.quartOut);
    UI.getTween(UI.base.cursor).to({alpha: 1}, duration, UI.ease.quartOut);
    if(0 === curAlpha){
        UI.base.cursor.alpha = 0;
    }
    else{
        //UI.getTween(UI.base.cursor, true).to({
        //    scaleX: scale,
        //    scaleY: scale,
        //    alpha: 1
        //}, duration, UI.ease.quartOut);
        //UI.getTween(UI.base.cursor.scale).to({x: scale, y: scale}, duration, UI.ease.quartOut);
        UI.getTween(target).to({alpha: 1}, duration, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha: 1}, duration, UI.ease.quartOut);
    }
    liveTVTimeoutCallTTS(target);
    liveTVHiContrastFocus(target);
    if(!noMarquee) liveTVSetMarquee(target, 1);
}

function onNormalLiveTVTarget(target, baseAlpha, baseDuration, noMarquee, curAlpha){
    //UI.getTween(target.scale).to({x: 1, y: 1}, baseDuration, UI.ease.quartOut);
    UI.getTween(UI.base.cursor).to({alpha: baseAlpha}, baseDuration, UI.ease.quartOut);
    if(0 === curAlpha){
        UI.base.cursor.alpha = 0;
    }
    else{
        //UI.getTween(UI.base.cursor.scale).to({x: 1, y: 1}, baseDuration, UI.ease.quartOut);
        UI.getTween(target).to({alpha: baseAlpha}, baseDuration, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha: 1}, baseDuration, UI.ease.quartOut);
    }
    liveTVHiContrastNormal(target);
    if(!noMarquee) liveTVSetMarquee(target, 0);
}

function checkLiveTVState(subName) {
    if (LIVETV.MAIN != UI.getCurrModule().name) return false;
    return (null == subName || (UI.getCurrSubModule() && UI.getCurrSubModule().name == subName));
}

function setLiveTVText(target, text, noMarquee, width) {
    try{
        UI.setText(target, text, true, noMarquee, width);
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }

}

function setLiveTVImage(target, img){
    UI.setImage(target, img, true);
}

function setPlayedChListIndex(idx) {
    GLOBAL.CURRENT_CHLIST_INDEX = idx;
    var wrIdx = (idx == CHLISTINDEX.HIS ? CHLISTINDEX.ALL : idx);
    if (Config.tv) model.tvservice.setPlayFavChannelList(wrIdx);
}


    function setPlayedChListIndexOnPop(idx, chnls) {
        GLOBAL.CURRENT_CHLIST_INDEX = (idx == CHLISTINDEX.HIS ? CHLISTINDEX.ALL : GLOBAL.CURRENT_CHLIST_INDEX);
        if(!chnls || chnls.length <= 0) {
            GLOBAL.CURRENT_CHLIST_INDEX = CHLISTINDEX.ALL;
        }
        if(GLOBAL.CURRENT_CHLIST_INDEX == CHLISTINDEX.ALL && idx == CHLISTINDEX.HIS) {
            liveTV.resetChnnelIndex();
        }
        if (Config.tv) model.tvservice.setPlayFavChannelList(GLOBAL.CURRENT_CHLIST_INDEX);
    }

    function checkAndPlayChannel(chnl, isFavList) {
    if (liveTV.setStateBefChangeChannel(ChangeType.CH_OBJ, chnl)) {
        setPlayedChListIndex(!!isFavList? CHLISTINDEX.FAV: CHLISTINDEX.ALL);
        return liveTV.changeChannel(chnl);
    }
    return false;
}

function removeLiveTVShape(target) {
    target.parent.removeChild(target.mask);
    target.parent.removeChild(target.viewRect);
    target.parent.removeChild(target.scrollbar);
    target.mask = null;
    target.viewRect = null;
    target.scrollbar = null;
}

function autoExitLiveTVSubModel(){
    if (UI.getCurrModule().name != LIVETV.MAIN) return;
    UI.popSubModule();
    openLiveTVModule([Msg.INFO, 0]);
}

var liveTVTTSTimer = 0;
function liveTVTimeoutCallTTS(focus){
    if(!GLOBAL.TTS) return false;
    clearTimeout(liveTVTTSTimer);
    liveTVTTSTimer = setTimeout(function(){
        if (focus.voiceStr) {
            UI.callTTS(focus.voiceStr);
        } else {
            UI.callTTS(UI.base.getVoiceStr(focus));
        }
    }, 200);
}

function liveTVHiContrastFocus(target){
    if(GLOBAL.HICONTRAST) UI.base.toHiContrast(target);
}

function liveTVHiContrastNormal(target){
    if(GLOBAL.HICONTRAST) UI.base.toNormalContrast(target);
}

function liveTVSetMarquee(target, run){
    try {
        if (1 == run) {
            UI.base.runText(target);
        }
        else {
            UI.base.stopText(target);
        }
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }
}
/*mighty 2016-09-20*/
var m_audioTrackIterator = null;
liveTV.readAudioTableInfo = function (onReadAudioTableInfo) {
    return;
    if (m_audioTrackIterator != null) {
        m_audioTrackIterator.disconnect();
    }

    m_audioTrackIterator = new TableIterator(
        model.tvservice.creatAudioTableIterator,
        true,
        [],
        [
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_ID,
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_NAME,
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_ISO639,
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_TYPE,
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_PURPOSE,
            TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_TRACK
        ],
        [
            {
                field: TvserviceModelDefines.ENUM_TVSERVICE_AUDIO_FIELD_ID,
                direction: 1
            }
        ],
        onReadAudioTableInfo
    );

    m_audioTrackIterator.seekToRow(0, TableIterator.SEEK_SET);
    m_audioTrackIterator.readNextRows(999);
}

// add by samuel qin 2016/9/26
liveTV.isParentalLockPinRequest = function()
{
    var pinRequest;
    if (!tv) return false;
    pinRequest = model.parentlock.getPinRequest();
    //DBG_ERROR("pinRequest:" + pinRequest.getstrings);

    if(pinRequest[Parental_lockModel.PARENTAL_LOCK_PIN_REQUEST_INDEX_ID]!=Parental_lockModel.PARENTAL_PIN_REQUEST_ID_NONE)
    {
        return true;
    }
    else
    {
        return false;
    }
}

 var crntDtvAudioList = [];
 var menuChipParam;
 var crntDtvAudioLanEvent={};
function getCurrentDtvAudioLangList() {
    return crntDtvAudioList;
}
function onDtvAudioLanguagePageInit(event){
    try {
        DBG_ERROR("onDtvAudioLanguagePageInit: "+objToString(event));
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_ERROR("event.rows.length: " + event.rows.length);
            if (event.rows.length <= 0) {
//                DBG_ERROR("UI.getCurrSubModule().name"+UI.getCurrSubModule().name);
//                if(UI.getCurrSubModule().name == "menuChip"){
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AUDIO_LANGUAGE_TIP;
                UI.pushGhostModule("setting", "SettingSysToast");
//                }
                return;
            }
            if (event.rows.length > 0) {
                DBG_ERROR(" event.rows[0][2]: " + event.rows[0][2]);
                if (event.rows[0][2] == "Audio 1") {//&&UI.getCurrSubModule().name == "menuChip"
                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AUDIO_LANGUAGE_TIP;
                    UI.pushGhostModule("setting", "SettingSysToast");
                    return;
                }
                var Array;
                for (var i = 0; i < event.rows.length; i++) {
                    var tempAudioInfo = {};
                    Array = event.rows[i];
                    tempAudioInfo.iso639 = Array[2];
                    tempAudioInfo.Type = Array[3];
                    tempAudioInfo.purpose = Array[4];
                    crntDtvAudioList.push(tempAudioInfo);
                }
                DBG_ERROR("UI.getCurrSubModule().name: "+UI.getCurrSubModule().name);
                if(UI.getCurrSubModule().name == "menuChip"){
                    UI.getCurrSubModule().close();
                }
                UI.pushSubModule("setting", "AudioLanguageList", true, menuChipParam);
            }
        }
    }catch (ex){
        DBG_ERROR(ex.message);
    }

}

liveTV.dtvAudioLanguagePageInit = function(param){
    try{
        menuChipParam = param;
        crntDtvAudioList = [];
        tv && liveTV.readAudioTableInfo(liveTV.ui_getAudioTableInfo);
//        tv&&onDtvAudioLanguagePageInit(crntDtvAudioLanEvent);

//        tv && liveTV.readAudioTableInfo(onDtvAudioLanguagePageInit);
        if(!tv){
            var AudioTableIterator = {
                type: TableIterator.EVENT_TYPE_ROWS_READ,
                rows: [
                    ["0","#3098 (Dolby D)","#3098",1,0],
                    [0, 0, "audio", 0, 4],
                    [0, 0, "#3008", 1, 5],
                    [0, 0, "mul",   2, 1],
                    [0, 0, "#3006", 3, 2],
                    [0, 0, "#3008", 0, 3],
                    [0, 0, "#3110", 1, 4],
                    [0, 0, "#3080", 3, 5]
                ]
            };
            crntDtvAudioLanEvent=AudioTableIterator;
            onDtvAudioLanguagePageInit(crntDtvAudioLanEvent);
        }
    }
    catch(ex){
        DBG_ERROR(" dtvAudioLanguagePageInit" + ex.message);
    }
};
DBG_INFO("liveTV.js end " + debugRunTime());

