UI.templateManager["module/launcher/mainTiles.json"] = {

    "mainTiles" : {
    "type": 0,
        "position": {"x": 0, "y": 0},
    "items": {
        "launcherTiles" : {
            "type" : 8,
                "position" : {"x":-200, "y":200}
        },
        "inputTiles" : {
            "type" : 8,
                "position" : {"x":-200, "y":900}
        },
        "appTiles" : {
            "type" : 8,
                "position" : {"x":-200, "y":1576}
        },
        "JumpTiles" : {
            "type" : 8,
            "position" : {"x":-825, "y":2130}
        },
        "channelTiles" : {
            "type" : 8,
                "position" : {"x":-200, "y":2252}
        },
        "moveIcons" : {
            "type" : 0,
                "position" : {"x" :-10, "y" :200},
            "items" : {
                "leftIcon" : {
                    "type" : 7,
                        "bound" : {"w" :96, "h" :96},
                    "position" : {"x" :0, "y" :100}
                },
                "deleteIcon" : {
                    "type" : 7,
                        "bound" : {"w" :96, "h" :96},
                    "position" : {"x" :250, "y" :0}
                },
                "rightIcon" : {
                    "type" : 7,
                        "bound" : {"w" :96, "h" :96},
                    "position" : {"x" :500, "y" :100}
                },
                "upIcon" : {
                    "type" : 7,
                        "bound" : {"w" :96, "h" :48},
                    "position" : {"x" :250, "y" :90}
                }
            }
        },
        "backArrow" : {
            "type" : 7,
                "bound" : {"w" :144, "h" :144},
            "position" : {"x" :-400, "y" :450}
        }
    }
}
};
UI.moduleBuilder['launcher']['mainTiles'] = function(){

    var mainTilesData = {
        leftIcon : "launcher/la_ic_arrow_left.png",
        rightIcon : "launcher/la_ic_arrow_right.png",
        deleteIcon : "launcher/la_ic_remove.png",
        backArrow : "launcher/la_p_ic_backarrow.png",
        upIcon : "launcher/la_ic_arrow_up_remove.png"
    };
    var template = Util.readJson("module/launcher/mainTiles.json");
    var mainTiles = SubModule.create(mainTilesData, template, "launcher");
    var launcherTiles, inputTiles, appTiles,JumpTiles,channelTiles, moveIcons, upIcon, statusBar,
        apps, setting, inputs, media, livetv, notification, reset, deleteIcon, leftIcon,
        rightIcon, backArrow,addIndex,arrangeImg1,arrangeImg2,secondaryImg,secondaryImg2,
        secondaryTxt,channelTxt,jumpTxt1,jumpTxt2,filter;
    var activeTimer = null;
    var showHintTimer = null;
    var hideHintTimer = null;
    var arraySymbol = [
        "A", "B", "C", "D", "E", "F",
        "G", "H", "I", "J", "K", "L",
        "M", "N", "O", "P", "Q", "R",
        "S", "T", "U", "V", "W", "X",
        "Y", "Z"
    ];
    launcherTiles = UI.getItem(mainTiles, "launcherTiles");
    inputTiles = UI.getItem(mainTiles, "inputTiles");
    appTiles = UI.getItem(mainTiles, "appTiles");
    JumpTiles = UI.getItem(mainTiles, "JumpTiles");
    channelTiles = UI.getItem(mainTiles, "channelTiles");
    moveIcons = UI.getItem(mainTiles, "moveIcons");
    upIcon = UI.getItem(mainTiles, "upIcon");
    deleteIcon = UI.getItem(moveIcons, "deleteIcon");
    leftIcon = UI.getItem(moveIcons, "leftIcon");
    leftIcon.doFlip = true;
    rightIcon = UI.getItem(moveIcons, "rightIcon");
    rightIcon.doFlip = true;
    backArrow = UI.getItem(mainTiles, "backArrow");
    backArrow.doFlip = true;
    backArrow.y = 310;

    statusBar = UI.getSubModule("statusBar");
    arrangeImg1 = UI.getItem(statusBar, "arrangeImg1");
    arrangeImg2 = UI.getItem(statusBar, "arrangeImg2");
    secondaryImg = UI.getItem(statusBar, "secondaryImg");
    secondaryImg2 = UI.getItem(statusBar, "secondaryImg2");
    secondaryTxt = UI.getItem(statusBar, "secondaryTxt");
    channelTxt = UI.getItem(statusBar, "channelTxt");
    jumpTxt1 = UI.getItem(statusBar, "jumpTxt1");
    jumpTxt2 = UI.getItem(statusBar, "jumpTxt2");

    upIcon.alpha = 0;
    moveIcons.alpha = 0;
    backArrow.alpha = 0;
    backArrow.doFlip = true;
    inputTiles.alpha = 0;
    appTiles.alpha = 0;
    JumpTiles.alpha = 0;
    channelTiles.alpha = 0;
    jumpTxt1.alpha = 0;
    jumpTxt2.alpha = 0;

    backArrow.x = backArrow.initPos.x + 200;
    channelTxt.y = channelTxt.initPos.y + 130;
    mainTiles.DestinationFlag = false;
    mainTiles.DestinationFlag2 = false;
    launcher.isEditMode = false;
    mainTiles.isFirstEditMode = false;

    mainTiles.x = mainTiles.initPos.x;
    mainTiles.y = mainTiles.initPos.y;
    UI.focusTo(UI.getCurrFocus());
    UI.getTween(statusBar).to({alpha:1}, 0);
    UI.setView(launcherTiles, 312, 312);
    UI.setView(inputTiles, 312, 312);
    UI.setView(appTiles, 312, 312);
    UI.setView(JumpTiles, 1500, 72);
    UI.setView(channelTiles, 312, 312);

    mainTiles.onShow = function(from) {
        if ((launcher.updateBlock
            || GLOBAL.LAUNCHER_FIRSTTIME
            || launcher.inputRenamed
            || launcher.searched
            || launcher.channelUpdate
            || launcher.inputChanged
            || (launcher.editRefresh && from != "resetConfirm" && from.name != "common")
            || launcher.deleteMainresult
            || launcherDataNeedToUpdate() == LauncherUpdate.SERVICE
        ) && from != "resetConfirm"){
            DBG_INFO("launcher.is Refresh");
            launcher.refreshLauncherData();
            launcher.searched = false;
            launcher.channelUpdate = false;
            launcher.inputRenamed = false;
            launcher.updateBlock = false;
            launcher.inputChanged = false;
            launcher.editRefresh = false;
            GLOBAL.LAUNCHER_FIRSTTIME = false;
            launcher.deleteMainresult = false;
            launcher.firstRefresh = true;
            launcher.allAppNeedUpdate = true;
            launcher.allInputNeedUpdate = true;
            launcher.AppInstallNeedUpdate = true;
        }
        if(!!launcher.firstRefresh){
            refreshTiles();
            DBG_INFO("launcher.firstRefresh is true");
            try{
                launcher.rememberLaunchArray=getCurrTileArray();
            }catch(ex){DBG_ERROR(ex.message)}
            mainTiles.toLaunchMode();
            launcher.firstRefresh = false;
        }
        launcherTiles.alpha = 1;
        backArrow.alpha = 0;
        mainTiles.newNotification = getNotificationDataNew();
        if(mainTiles.newNotification){
            if (notification) {
                var iconImg = UI.getItem(notification, "iconImg");
                UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_yes.png");
            }
        } else {
            if (notification) {
                var iconImg = UI.getItem(notification, "iconImg");
                UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_no.png");
            }
        }
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED, mainTitleOnSourceChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, mainTitleOnUsbChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NOTIFY_PULL_MESSAGE, mainTitleOnNotifyPullChanged);

        // UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST, mainTitleOnLockChanged);
        UI.showModule(launcher);

        try{
        UI.inactiveKey();
        DBG_INFO("Launcher is from :" + from + from.name);
        if (from == "allApps") {
            UI.getTween(launcherTiles).to({alpha:1}, 500);
            UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500);
                if( GLOBAL.LAUNCHER_INFO_EVENT == "ADDAPP"){
                    addToLauncher(from,apps);
                    GLOBAL.LAUNCHER_INFO_EVENT = null;
                }
            else{
                    mainTiles.currFocus = apps;
                    initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
                }
            UI.activeKey();
        } else if (from == "notifications") {
            UI.getTween(launcherTiles).to({alpha:1}, 500);
            UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500)
                .call(UI.activeKey);
            mainTiles.currFocus = notification;
            initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
        } else if (from == "allInputs") {
            UI.getTween(launcherTiles).to({alpha:1}, 500);
            UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500);
            if( GLOBAL.LAUNCHER_INFO_EVENT == "ADDINPUT"){
                addToLauncher(from,inputs);
                GLOBAL.LAUNCHER_INFO_EVENT = null;
            }
            else{
                mainTiles.currFocus = inputs;
                initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
           }
            UI.activeKey();
        } else if (from.name == "setting" || from == "setting") {
            launcher.setNoSignalTimeout();
            if(!!launcher.setting){
                mainTiles.currFocus = setting;
                launcher.setting = false;
            }else{
                launcher.currFocus = mainTiles.currFocus;
            }
            UI.getTween(launcherTiles).to({alpha:1}, 500);
            mainTiles.toLaunchMode();
            initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500)
                .call(function(){
                    if (statusBar) {
                      statusBar.onPush();
                        DBG_INFO("Launcher : StatusBar Refreshed");
                    }
                    UI.activeKey();
                });
        }
        else if (from.name == "common" || from == "common") {
            //launcher.currentData = getLauncherData();
            //refreshTiles();

            if (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode) {
                UI.activeKey();
            }
            else{
                UI.focusTo(launcherTiles.initSequence[1]);
                UI.getTween(launcherTiles).to({alpha:1}, 500);
                mainTiles.toLaunchMode()
                UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500)
                    .call(function(){
                        UI.activeKey();
                    });
                initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            }
        }
        else if (from == "resetConfirm") {
            createjs.Tween.removeAllTweens();
            if (launcher.resetResult) {
                try{
                    for (var j = 0; j < launcherTiles.initSequence.length; j++) {
                        if (launcherTiles.initSequence[j].data.cmd == LauncherCMD.BROWSER) {
                            if(launcherTiles.initSequence[j].data.obj.storeType == StoreType.BROWSER &&
                                launcherTiles.initSequence[j].data.obj.url != "browser"){
                                setLauncherDeleteFoxxumAppByUser(launcherTiles.initSequence[j].data.obj.url);
                            }
                        }
                    }
                }catch(e){
                    DBG_ERROR("delete foxxum app when reset mainTitles:"+ e.message);
                }
                launcherResetTitlesConfig();
                launcher.refreshLauncherData();
                refreshTiles();
                //launcherTiles.x = launcherTiles.initPos.x + launcherTiles.pivot.x;
                mainTiles.x = mainTiles.initPos.x;
                mainTiles.y = mainTiles.initPos.y;
                mainTiles.currFocus = launcherTiles.initSequence[0];
                UI.refreshView(launcherTiles, UI.getCurrFocus());
                UI._callBubble(UI.getCurrFocus(), "onFocus", UI.getCurrFocus());
                launcher.isEditMode = false;
                UI.getTween(statusBar).to({alpha:1}, 400);
                UI.getTween(helpInfo).to({alpha:0}, 400);
                launcher.resetResult = false;
                initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
                mainTiles.toLaunchMode();
                UI.activeKey();
            } else {
                UI.focusTo(reset);
                UI.activeKey();
            }
        }else if(from == "launcherPassword"){
            launcher.currFocus = mainTiles.currFocus;
            if(!!launcher.mainendfocus){
                var focus =  launcher.mainendfocus;
                    for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                        if(focus.name == launcherTiles.initSequence[i].name){
                            launcher.currFocus = launcherTiles.initSequence[i];
                            UI.focusTo(launcher.currFocus);
                            break;
                        }
                    }

            }
            else{
                mainTiles.currFocus = launcherTiles.initSequence[1];
                launcher.currFocus = mainTiles.currFocus;
            }
            initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            UI.activeKey();
        }else if(from == "selectFilter"){
            refreshChannelTiles();
            refreshJumpTiles();
            toEditMode();
            filter = UI.getItem(JumpTiles,"filter");
            UI.focusTo(filter);
            UI.activeKey();
        }
        else if(from == "statusBar"){
            refreshTiles();
            if(GLOBAL.LAUNCHER_INFO_EVENT == "ADDAPP"){
                UI.getTween(launcherTiles).to({alpha:1}, 500);
                UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500)
                    .call(addToLauncher, [from, apps]);
                activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},1700);
                //setTimeout(function() {
                //    UI.activeKey();
                //}, 1700);
            }
            else if(GLOBAL.LAUNCHER_INFO_EVENT == "ADDINPUT"){
                UI.getTween(launcherTiles).to({alpha:1}, 500);
                UI.getTween(backArrow).to({x:backArrow.initPos.x + 200, alpha:0}, 500)
                    .call(addToLauncher, [from, inputs]);
                activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},1700);
                //setTimeout(function() {
                //    UI.activeKey();
                //}, 1700);
            }
            else{
                try{
                    if(!launcherTiles.initSequence){
                        refreshTiles();
                    }
                } catch (e) {
                    DBG_ERROR("Creat launcher Failed : " + e.stack);
                }
                //if(!!launcher.mainkeyExit){
                //    launcher.currFocus =  mainTiles.currFocus = launcherTiles.initSequence[1];
                //    UI.focusTo(launcher.currFocus);
                //    launcher.mainkeyExit = false;
                //}else{
                    launcher.currFocus = mainTiles.currFocus;
                    if(!!launcher.mainendfocus){
                        var focus =  launcher.mainendfocus;
                        if(launcher.mainendfocus.name == "reset"){
                            mainTiles.currFocus = edit;
                            launcher.currFocus = mainTiles.currFocus;
                        }else{
                        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                            if(focus.name == launcherTiles.initSequence[i].name){
                                mainTiles.currFocus = launcherTiles.initSequence[i];
                                //UI.focusTo(launcher.currFocus);
                                break;
                            }
                        }
                        }
                    }
                    else{
                        mainTiles.currFocus = apps;
                    }

                mainTiles.toLaunchMode();
                initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
                UI.refreshView(launcherTiles, mainTiles.currFocus);
                UI.activeKey();
            }
        }  else if(from == "remote"){
            initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            UI.focusTo(launcherTiles.initSequence[1]);
            UI.activeKey();
        }else {
          UI.activeKey();
        }
        } catch (e) {
            DBG_ERROR("Push Module Failed : " + e.stack);
        }
        try{
            if(!launcherTiles.initSequence){
                refreshTiles();
                mainTiles.toLaunchMode();
                mainTiles.currFocus = launcherTiles.initSequence[1];
                initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            }

        } catch (e) {
            DBG_ERROR("Creat launcher Failed : " + e.stack);
        }
       // UI.refreshView(launcherTiles, mainTiles.currFocus);
        setAlpha();
    };

    mainTiles.onExit = function(to) {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED,mainTitleOnSourceChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED,mainTitleOnUsbChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.SIGNAL_CHANGED, mainTitleOnLockChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NOTIFY_PULL_MESSAGE, mainTitleOnNotifyPullChanged);
      //  UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST, mainTitleOnLockChanged);
        if(to == "mainPanel"){
            UI.clearLauncherMenuTimeout();
        }
        if (to == "notifications" || to == "allApps" || to == "allInputs" || to == "mainPanel") {
            UI.getTween(launcherTiles).to({alpha:0});
            UI.getTween(backArrow).to({x:backArrow.initPos.x, alpha:1});
        }
        moveIcons.alpha = 0;
        clearTimeout(activeTimer);
        clearTimeout(showHintTimer);
        clearTimeout(hideHintTimer);
    };
    mainTiles.onPop = function(to) {
        moveIcons.alpha = 0;
        clearTimeout(activeTimer);
        clearTimeout(showHintTimer);
        clearTimeout(hideHintTimer);
        var focus = mainTiles.currFocus;
        if( launcher.isEditMode){
            if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
                launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
            }
            mainTiles.prepareLaunchMode(focus);
            mainTiles.toLaunchMode();
            UI.focusTo(launcherTiles.initSequence[addIndex - 1]);
        }else if(launcher.isMoveMode){
            DBG_ERROR(mainTiles.initPos.y);
            onKeyDownForMoveMode(focus);
            UI.refreshView(launcherTiles, focus);
            resetVisible(launcherTiles);
            createjs.Tween.removeTweens(launcherTiles);
            mainTiles.toLaunchMode();
            UI.activeKey();
            UI.focusTo(focus);
        }else if(launcher.isDeleteMode){
            UI.getTween(deleteIcon.scale).to({x:1, y:1}, 400);
            UI.getTween(focus.scale).to({x:1.15, y:1.15}, 400);
            if (launcherTiles.focusIndex == 1) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }  else if (launcherTiles.focusIndex == launcherTiles.initSequence.length - 2) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 100, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }
            else if (launcherTiles.focusIndex > 1 &&launcherTiles.focusIndex < launcherTiles.initSequence.length - 2 ) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }
            UI.getTween(upIcon).to({alpha:0}, 400, UI.ease.quartOut);
            onKeyDownForMoveMode(focus);
            UI.refreshView(launcherTiles, focus);
            resetVisible(launcherTiles);
            createjs.Tween.removeTweens(launcherTiles);
            mainTiles.toLaunchMode();
            UI.activeKey();
            UI.focusTo(focus);
        }else{
            mainTiles.prepareLaunchMode(focus);
        }
    };

    mainTiles.onFocus = function(focus) {
        launcher.mainendfocus = focus;

        if (focus.children[0].name == "shadow") {
            focus.children[0].alpha = 0;
        }
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else if (!!focus.data && focus.data.voiceStr) {
                UI.callTTS(focus.data.voiceStr);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.NETFLIX) {
                UI.callTTS(APPNAME.NETFLIX);
            } else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZONRUBY) {
                UI.callTTS(APPNAME.AMAZONRUBY);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZON) {
                UI.callTTS(APPNAME.AMAZON);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.YOUTUBE) {
                UI.callTTS(APPNAME.YOUTUBE);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.VUDU) {
                UI.callTTS(APPNAME.VUDU);
            }
            else if(focus.name == "appInstaller"){
                //UI.callTTS(focus.name + focus.data.nameTxt);
            }
            else {
                UI.callTTS(UI.base.getVoiceStr(focus));
            }
        }

        UI.moveCursor(UI.adjustView(300));
        if(launcher.currSubModule && launcher.currSubModule.name == "appInstaller"){
            UI.getTween(focus.scale).to({x:1.1, y:1.1}, 500, UI.ease.quartOut);
        }
        else{
            UI.getTween(focus.scale).to({x:1.15, y:1.15}, 500, UI.ease.quartOut);
        }
        UI.getTween(UI.base.cursor).wait(200).to({alpha:1}, 300, UI.ease.quartOut);
        UI.moveTop(focus);

        UI.base.runText(focus);
    };

    inputTiles.onkey_DOWN = function(focus) {
        channelTiles.alpha = 1;
        UI.inactiveKey();
        UI.getTween(UI.base.cursor).set({alpha:0});
        inputTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 1390}, 400)
            .call(UI.focusTo, [appTiles.initSequence[appTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 3050}, 400)
    };

    inputTiles.onkey_UP = function(focus) {
        launcherTiles.alpha = 1;
        UI.inactiveKey();
        UI.getTween(UI.base.cursor).set({alpha:0});
        inputTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y}, 400)
            .call(UI.focusTo, [launcherTiles.lastFocus])
            .call(launcher.onNormal,[launcherTiles.initSequence[addIndex]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 400).call(
            function(){
                inputTiles.alpha = 0;
                appTiles.alpha = 0;
                //UI.getTween(launcher.overlayAdd).to({alpha:0}, 400);
                //UI.getTween(launcher.overlayEdit).to({alpha:1}, 0);
            });
    };

    appTiles.onkey_DOWN = function(focus) {
        //initVisible(channelTiles.lastFocus, channelTiles, 3, 3);
        UI.inactiveKey();
        UI.getTween(UI.base.cursor).set({alpha:0});
        appTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 2066}, 500)
            .call(UI.focusTo, [channelTiles.initSequence[channelTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 3725}, 500)
            .call(function(){
                inputTiles.alpha = 0;
            });
        if(!!JumpTiles.initSequence && !!JumpTiles.initSequence[JumpTiles.posCount] && channelTiles.initSequence.length>1){
            UI.getTween(JumpTiles).set({alpha:1});
            UI.getTween(channelTxt).to({y:channelTxt.initPos.y}, 500);
        }else{
            UI.getTween(channelTxt).to({y:channelTxt.initPos.y + 130}, 500);
        }
    };

    appTiles.onkey_UP = function(focus) {
        UI.inactiveKey();
        UI.getTween(UI.base.cursor).set({alpha:0});
        appTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 710}, 500)
            .call(UI.focusTo, [inputTiles.initSequence[inputTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 2380}, 500)
            .call(function(){
                channelTiles.alpha = 0;
            });
    };

    channelTiles.onkey_UP = function(focus) {
        inputTiles.alpha = 1;
        UI.inactiveKey();
        UI.getTween(UI.base.cursor).set({alpha:0});
        channelTiles.lastFocus = focus;
        if(!!JumpTiles.initSequence && !!JumpTiles.initSequence[JumpTiles.posCount] && channelTiles.initSequence.length>1){
            UI.focusTo(JumpTiles.initSequence[JumpTiles.posCount]);
        }else{
            UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 1390}, 500)
                .call(UI.focusTo, [appTiles.initSequence[appTiles.posCount]])
                .wait(400)
                .call(UI.activeKey);
            UI.getTween(statusBar).to({y:statusBar.initPos.y - 3050}, 500);
            UI.getTween(channelTxt).to({y:channelTxt.initPos.y + 130}, 500);
        }
        UI.activeKey();
    };

    JumpTiles.onkey_DOWN = function(focus) {
        UI.inactiveKey();
        clearTimeout(activeTimer);
        UI.getTween(UI.base.cursor).set({alpha:0});
        JumpTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 2066}, 500)
            .call(UI.focusTo, [channelTiles.initSequence[channelTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 3725}, 500)
            .call(function(){
                inputTiles.alpha = 0;
            })
    };
    JumpTiles.onkey_UP = function(focus) {
        inputTiles.alpha = 1;
        jumpTxt1.alpha = 0;
        jumpTxt2.alpha = 0;
        UI.inactiveKey();
        clearTimeout(activeTimer);
        UI.getTween(UI.base.cursor).set({alpha:0});
        JumpTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 1390}, 500)
            .call(UI.focusTo, [appTiles.initSequence[appTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 3050}, 500);
        UI.getTween(JumpTiles).set({alpha:0});
        UI.getTween(channelTxt).to({y:channelTxt.initPos.y + 130}, 500);
    };

    inputTiles.onkey_ENTER = function(focus) {

        if (launcherTiles.initSequence.length - 1 >= CONST.LAUNCHER_MAXTILES) {
            launcherTiles.alpha = 1;
            inputTiles.lastFocus = focus;
            UI.getTween(mainTiles).to({y:mainTiles.editModePos.y}, 400);
            UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 400)
                .call(function(){
                    showOnlyLauncherTiles();
                   // var helpInfo = UI.getSubModule("helpInfo");
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    UI.setText(msgTxt, "[SE3162]");
                    UI.callTTS("[SE3162]");
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                });
            UI.focusTo(launcherTiles.lastFocus);
            launcher.onNormal(focus);
            return;
        }

        launcherTiles.alpha = 1;
       // UI.getTween(mainTiles).to({y:mainTiles.editModePos.y}, 400);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 200)
            .call(function(){
                showOnlyLauncherTiles();
            });
        LogReportData.GTLauncherTitleActionAddFlag=true;

        var removed = inputTiles.data[inputTiles.currIndex];
        removed.name = "input" + inputTiles.data[inputTiles.currIndex].name;
        removed.template = "launcher_tile_5";
        removed.id =  inputTiles.data[inputTiles.currIndex].obj.id;
        removed.voiceStr = inputTiles.data[inputTiles.currIndex].nameTxt;
        if(launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH && removed.obj.locked){
        removed.lockImg = "launcher/mask_luancher_input_children_lock.png";
        }
        else{
            removed.lockImg = "launcher/mask_luancher_input_children_lock2.png";
        }
        inputTiles.posCount = inputTiles.initSequence.indexOf(focus);
        if (inputTiles.initSequence.length == 1) {
            inputTiles.viewRect = null;
            inputTiles.addItemAt({
                template : "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/title/inputs.png",
                noneTxt : "[SE3160]",
                name : "msg",
                flag : true
            }, 0, true);
            inputTiles.data.splice(1, 1);
            inputTiles.removeChild(this.initSequence[0]);
            inputTiles.initSequence.splice(0, 1);
        }
        inputTiles.removeItemAt(inputTiles.currIndex, true);
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        if (!inputTiles.data[0].obj) {
            inputTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
            inputTiles.initSequence[0].x -= 400;
            //channelTiles.viewRect = channelTiles.1initViewRect;
        }
        if (inputTiles.currIndex >= inputTiles.data.length - 4 && inputTiles.data.length >= 9) {
            inputTiles.posCount++;
            if (inputTiles.posCount > inputTiles.initSequence.length - 1) {
                inputTiles.posCount = inputTiles.initSequence.length - 1;
            }
        }
        navTo(inputTiles.currIndex, inputTiles.posCount, inputTiles);
        inputTiles.refreshNav();
        launcherTiles.addItemAt(removed, addIndex);
        var tileArray = getCurrTileArray();
        removed.data = removed.obj;
        var frontIndex,lastIndex;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            if(launcherTiles.initSequence[i].data.cmd == LauncherCMD.SETTINGS){
                frontIndex = addIndex - i;
                break;
            }
        }
        for (var i = 0; i < launcher.currentData.length; i++) {
            if(launcher.currentData[i].cmd == LauncherCMD.SETTINGS){
                if(frontIndex < 0){
                    lastIndex = frontIndex + i + 1;
                }else{
                    lastIndex = frontIndex + i;
                }
                break;
            }
        }
        if(lastIndex < 0){
            lastIndex = 0
        }else if(lastIndex > launcher.currentData.length){
            lastIndex = launcher.currentData.length;
        }
        launcher.currentData.splice(lastIndex, 0, removed);
        setRememberEditAppToNativeFile(tileArray);
        UI.getTween(mainTiles).to({y:mainTiles.initPos.y}, 600, UI.ease.quartOut).to({x:mainTiles.initPos.x}, 400, UI.ease.quartOut);
        initVisible(launcherTiles.initSequence[addIndex], launcherTiles, 3, 6);
        mainTiles.toLaunchMode();
    };

    appTiles.onkey_ENTER = function(focus) {

        if (launcherTiles.initSequence.length - 1 >= CONST.LAUNCHER_MAXTILES) {
            launcherTiles.alpha = 1;
            appTiles.lastFocus = focus;
            UI.getTween(mainTiles).to({y:mainTiles.editModePos.y}, 400);
            UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 400)
                .call(function(){
                    showOnlyLauncherTiles();
                   // var helpInfo = UI.getSubModule("helpInfo");
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    UI.setText(msgTxt, "[SE3162]");
                    UI.callTTS("[SE3162]");
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                });
            UI.focusTo(launcherTiles.lastFocus);
            launcher.onNormal(focus);
            return;
        }

        launcherTiles.alpha = 1;
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 200)
            .call(function(){
                showOnlyLauncherTiles();
            });
        LogReportData.GTLauncherTitleActionAddFlag=true;

        var removed = appTiles.data[appTiles.currIndex];
        removed.name = appTiles.data[appTiles.currIndex].name;
        removed.template = "launcher_tile_1";
        removed.url = appTiles.data[appTiles.currIndex].obj.url;
        removed.voiceStr = appTiles.data[appTiles.currIndex].name;
        if( GLOBAL.PARENTAL_LOCK_SWITCH && removed.obj.locked){
         removed.lockImg = "launcher/mask_luancher_input_children_lock.png";
        }
        else{
            removed.lockImg = "launcher/mask_luancher_input_children_lock2.png";
        }
        appTiles.posCount = appTiles.initSequence.indexOf(focus);
        if (appTiles.initSequence.length == 1) {
            appTiles.viewRect = null;
            appTiles.addItemAt({
                template : "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/title/apps.png",
                noneTxt : "[SE3159]",
                name : "msg",
                flag : true
            }, 0, true);
            appTiles.data.splice(1, 1);
            appTiles.removeChild(this.initSequence[0]);
            appTiles.initSequence.splice(0, 1);
        }
        appTiles.removeItemAt(appTiles.currIndex, true);
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        if (!appTiles.data[0].obj) {
            appTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
            appTiles.initSequence[0].x -= 400;
        }
        if (appTiles.currIndex >= appTiles.data.length - 4 && appTiles.data.length >= 9) {
            appTiles.posCount++;
            if (appTiles.posCount > appTiles.initSequence.length - 1) {
                appTiles.posCount = appTiles.initSequence.length - 1;
            }
        }
        navTo(appTiles.currIndex, appTiles.posCount, appTiles);
        appTiles.refreshNav();
        launcherTiles.addItemAt(removed, addIndex);
        var tileArray = getCurrTileArray();
        setRememberEditAppToNativeFile(tileArray);
        removed.data = removed.obj;
        var frontIndex,lastIndex;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            if(launcherTiles.initSequence[i].data.cmd == LauncherCMD.SETTINGS){
                frontIndex = addIndex - i;
                break;
            }
        }
        for (var i = 0; i < launcher.currentData.length; i++) {
            if(launcher.currentData[i].cmd == LauncherCMD.SETTINGS){
                if(frontIndex < 0){
                    lastIndex = frontIndex + i + 1;
                }else{
                    lastIndex = frontIndex + i;
                }
                break;
            }
        }
        if(lastIndex < 0){
            lastIndex = 0
        }else if(lastIndex > launcher.currentData.length){
            lastIndex = launcher.currentData.length;
        }
        launcher.currentData.splice(lastIndex, 0, removed);
        initVisible(launcherTiles.initSequence[addIndex], launcherTiles, 3, 6);
        UI.getTween(mainTiles).to({y:mainTiles.initPos.y}, 600, UI.ease.quartOut).to({x:mainTiles.initPos.x}, 400, UI.ease.quartOut);
        mainTiles.toLaunchMode();
    };

    channelTiles.onkey_ENTER = function(focus) {

        if (launcherTiles.initSequence.length >= CONST.LAUNCHER_MAXTILES) {
            launcherTiles.alpha = 1;
            channelTiles.lastFocus = focus;
            UI.getTween(mainTiles).to({y:mainTiles.editModePos.y}, 400);
            UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 400)
                .call(function(){
                    showOnlyLauncherTiles();
                   // var helpInfo = UI.getSubModule("helpInfo");
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    UI.setText(msgTxt, "[SE3162]");
                    UI.callTTS("[SE3162]");
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                });
            UI.focusTo(launcherTiles.lastFocus);
            launcher.onNormal(focus);
            return;
        }

        inputTiles.alpha = 1;
        launcherTiles.alpha = 1;
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 200)
            .call(function(){
                showOnlyLauncherTiles();
            });
        LogReportData.GTLauncherTitleActionAddFlag=true;

        //if (channelTiles.initSequence.length == 1) {
        //    channelTiles.viewRect = null;
        //    channelTiles.addItemAt({
        //        template : "launcher_tile_msg",
        //        bgImg : "setting/blank.png",
        //        noneTxt : "[SE3161]",
        //        flag : true
        //    }, 0, true);
        //    channelTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
        //}

        var removed = channelTiles.data[channelTiles.currIndex];
        removed.name = channelTiles.data[channelTiles.currIndex].name;
        removed.template = "launcher_tile_2";
        removed.voiceStr = channelTiles.data[channelTiles.currIndex].nameTxt1;
        if(launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH && removed.obj.isLock){
           removed.lockImg = "launcher/mask_luancher_input_children_lock.png";
        }
        else{
            removed.lockImg = "launcher/mask_luancher_input_children_lock2.png";
        }
        channelTiles.posCount = channelTiles.initSequence.indexOf(focus);
        if (channelTiles.initSequence.length == 1) {
            channelTiles.viewRect = null;
            channelTiles.addItemAt({
                template : "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/la_ic_tuner_active.png",
                noneTxt : "[SE3161]",
                name : "msg",
                flag : true
            }, 0, true);
            channelTiles.data.splice(1, 1);
            channelTiles.removeChild(this.initSequence[0]);
            channelTiles.initSequence.splice(0, 1);
        }
        channelTiles.removeItemAt(channelTiles.currIndex, true);
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        if (!channelTiles.data[0].obj) {
            channelTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
            channelTiles.initSequence[0].x -= 400;
            //channelTiles.viewRect = channelTiles.1initViewRect;
        }
        if (channelTiles.currIndex >= channelTiles.data.length - 4 && channelTiles.data.length >= 9) {
            channelTiles.posCount++;
            if (channelTiles.posCount > channelTiles.initSequence.length - 1) {
                channelTiles.posCount = channelTiles.initSequence.length - 1;
            }
        }
        navTo(channelTiles.currIndex,channelTiles.posCount, channelTiles);
        channelTiles.refreshNav();
        launcherTiles.addItemAt(removed, addIndex);
        var tileArray = getCurrTileArray();
        setRememberEditAppToNativeFile(tileArray);
        removed.data = removed.obj;
        var frontIndex,lastIndex;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            if(launcherTiles.initSequence[i].data.cmd == LauncherCMD.SETTINGS){
                frontIndex = addIndex - i;
                break;
            }
        }
        for (var i = 0; i < launcher.currentData.length; i++) {
            if(launcher.currentData[i].cmd == LauncherCMD.SETTINGS){
                if(frontIndex < 0){
                    lastIndex = frontIndex + i + 1;
                }else{
                    lastIndex = frontIndex + i;
                }
                break;
            }
        }
        if(lastIndex < 0){
            lastIndex = 0
        }else if(lastIndex > launcher.currentData.length){
            lastIndex = launcher.currentData.length;
        }
        launcher.currentData.splice(lastIndex, 0, removed);
        initVisible(launcherTiles.initSequence[addIndex], launcherTiles, 3, 6);
        UI.getTween(mainTiles).to({y:mainTiles.initPos.y}, 600, UI.ease.quartOut).to({x:mainTiles.initPos.x}, 400, UI.ease.quartOut);
        mainTiles.DestinationFlag = true;
        mainTiles.DestinationFlag2 = true;
        mainTiles.toLaunchMode();
    };

    JumpTiles.onkey_BACKSPACE = function(focus) {
        launcherTiles.alpha = 1;
        JumpTiles.lastFocus = focus;
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        mainTiles.prepareLaunchMode(focus);
        mainTiles.toLaunchMode();
        UI.focusTo(launcherTiles.initSequence[addIndex - 1]);
    };

    inputTiles.onkey_BACKSPACE = function(focus) {
        launcherTiles.alpha = 1;
        inputTiles.lastFocus = focus;
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        mainTiles.prepareLaunchMode(focus);
        mainTiles.toLaunchMode();
        UI.focusTo(launcherTiles.initSequence[addIndex - 1]);
    };

    appTiles.onkey_BACKSPACE = function(focus) {
        launcherTiles.alpha = 1;
        appTiles.lastFocus = focus;
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        mainTiles.prepareLaunchMode(focus);
        mainTiles.toLaunchMode();
        UI.focusTo(launcherTiles.initSequence[addIndex - 1]);
    };

    channelTiles.onkey_BACKSPACE = function(focus) {
        inputTiles.alpha = 1;
        launcherTiles.alpha = 1;
        channelTiles.lastFocus = focus;
        if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
            launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
        }
        mainTiles.prepareLaunchMode(focus);
        mainTiles.toLaunchMode();
        UI.focusTo(launcherTiles.initSequence[addIndex - 1]);

    };

    inputTiles.onkey_LEFT = function(focus) {
        if (this.data.length <= this.info.pageCount + 2
            || this.currIndex <= 4
            || this.currIndex >= this.data.length - 4) {
            this.posCount--;
            if (this.posCount < 0) {
                this.posCount = 0;
            }
        } else {
            var item  = this.initSequence.pop();
            item.x = this.initSequence[0].x - this.info.distance - item.pivot.x * 2;
            this.initSequence.unshift(item);
            this.refreshData(item, this.data[this.currIndex - 5]);
            item.data = this.data[this.currIndex - 5];
            this.posCount = 4;
            this.refreshNav();
        }

        this.currIndex--;
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }
        return true;
    };

    inputTiles.onkey_RIGHT = function(focus) {
        if (this.data.length <= this.info.pageCount + 2
            || this.currIndex <= 3
            || this.currIndex >= this.data.length - 5) {
            this.posCount++;
            if (this.posCount > this.initSequence.length - 1) {
                this.posCount = this.initSequence.length - 1;
            }
        } else {
            var item = this.initSequence.shift();
            item.x = this.initSequence[this.initSequence.length - 1].x + this.info.distance + item.pivot.x * 2;
            this.initSequence.push(item);
            this.refreshData(item, this.data[this.currIndex + 5]);
            item.data = this.data[this.currIndex + 5];
            this.posCount = 4;
            this.refreshNav();
        }
        this.currIndex++;
        if (this.currIndex > this.data.length - 1) {
            this.currIndex = this.data.length - 1;
        }
        return true;
    };

    appTiles.onkey_LEFT = function(focus) {
        if (this.data.length <= this.info.pageCount + 2
            || this.currIndex <= 4
            || this.currIndex >= this.data.length - 4) {
            this.posCount--;
            if (this.posCount < 0) {
                this.posCount = 0;
            }
        } else {
            var item  = this.initSequence.pop();
            item.x = this.initSequence[0].x - this.info.distance - item.pivot.x * 2;
            this.initSequence.unshift(item);
            this.refreshData(item, this.data[this.currIndex - 5]);
	    item.data = this.data[this.currIndex - 5];
            this.posCount = 4;
            this.refreshNav();
        }

        this.currIndex--;
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }
        return true;
    };

    appTiles.onkey_RIGHT = function(focus) {
        if (this.data.length <= this.info.pageCount + 2
            || this.currIndex <= 3
            || this.currIndex >= this.data.length - 5) {
            this.posCount++;
            if (this.posCount > this.initSequence.length - 1) {
                this.posCount = this.initSequence.length - 1;
            }
        } else {
            var item = this.initSequence.shift();
            item.x = this.initSequence[this.initSequence.length - 1].x + this.info.distance + item.pivot.x * 2;
            this.initSequence.push(item);
            this.refreshData(item, this.data[this.currIndex + 5]);
	     item.data = this.data[this.currIndex + 5];
            this.posCount = 4;
            this.refreshNav();
        }
        this.currIndex++;
        if (this.currIndex > this.data.length - 1) {
            this.currIndex = this.data.length - 1;
        }
        return true;
    };

    channelTiles.onkey_LEFT = function(focus) {

            if (this.data.length <= this.info.pageCount + 2
                || this.currIndex <= 4
                || this.currIndex >= this.data.length - 4) {
                    this.posCount--;
                    if (this.posCount < 0) {
                        this.posCount = 0;
                    }
            } else {
                var item  = this.initSequence.pop();
                item.x = this.initSequence[0].x - this.info.distance - item.pivot.x * 2;
                this.initSequence.unshift(item);
                this.refreshData(item, this.data[this.currIndex - 5]);
                item.data = this.data[this.currIndex - 5];
                this.posCount = 4;
                this.refreshNav();
            }

        this.currIndex--;
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }
        return true;
    };

    channelTiles.onkey_RIGHT = function(focus) {
        if (this.data.length <= this.info.pageCount + 2
            || this.currIndex <= 3
            || this.currIndex >= this.data.length - 5) {
            this.posCount++;
            if (this.posCount > this.initSequence.length - 1) {
                this.posCount = this.initSequence.length - 1;
            }
        } else {
            var item = this.initSequence.shift();
            item.x = this.initSequence[this.initSequence.length - 1].x + this.info.distance + item.pivot.x * 2;
            this.initSequence.push(item);
            this.refreshData(item, this.data[this.currIndex + 5]);
            item.data = this.data[this.currIndex + 5];
            this.posCount = 4;
            this.refreshNav();
        }
        this.currIndex++;
        if (this.currIndex > this.data.length - 1) {
            this.currIndex = this.data.length - 1;
        }
        return true;
    };

    JumpTiles.onFocus = function(focus) {
        if (focus.children[0].name == "shadow") {
            focus.children[0].alpha = 0;
        }
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.NETFLIX) {
                UI.callTTS(APPNAME.NETFLIX);
            } else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZONRUBY) {
                UI.callTTS(APPNAME.AMAZONRUBY);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.AMAZON) {
                UI.callTTS(APPNAME.AMAZON);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.YOUTUBE) {
                UI.callTTS(APPNAME.YOUTUBE);
            }else if (focus.data && focus.data.obj && focus.data.obj.url == APPNAME.VUDU) {
                UI.callTTS(APPNAME.VUDU);
            }
            else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        jumpTxt1.alpha = 1;
        jumpTxt2.alpha = 1;
        if(focus.name != "filter"){
            moveCursor(UI.adjustView(),true);
        }else{
            moveCursor(UI.adjustView(),false);
        }
        UI.getTween(focus.scale).to({x:1.15, y:1.15}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor, false).wait(200).to({alpha:1}, 300, UI.ease.quartOut);
        UI.moveTop(focus);

        UI.base.runText(focus);
        return false;
    };
    function moveCursor(noUse, flg,retfocus) {

        // ÕÒµ½focus¶ÔÏó
        var focus = !!retfocus? retfocus: UI.getCurrFocus();
        if ((!focus) || (UI.base.cursor.parent == focus)) {
            return;
        }
        // Í£Ö¹ÅÜÂíµÆ
        if (UI.isTextRunning) {
            UI.base.stopText();
        }
        // »ñµÃfocusµÄ´óÐ¡£¬ÓÃÀ´¸Ä±ä½¹µã¿òµÄ´óÐ¡
        var focusBounds = focus.getBounds();
        // ½¹µã¿òÊÇÒ»¸öµã9À­ÉìÍ¼£¬Ö±½ÓÎªÆä¸³Öµ¿í¸ßºÍÔ­µãºÍÎ»ÖÃ¼´¿É
        UI.base.cursor.width = focusBounds.width + UI.base.cursor.r * 2;
        UI.base.cursor.height = focusBounds.height + UI.base.cursor.r * 2;
        if(!!flg){
            if(launcher.currFileterSelect == "ABC"){
                UI.base.cursor.position.x = focusBounds.width / 2 - UI.base.cursor.r + focusBounds.width * 1.4;
            }else{
                UI.base.cursor.position.x = focusBounds.width / 2 - UI.base.cursor.r + focusBounds.width * 0.4;
            }
        }else{
            UI.base.cursor.position.x = focusBounds.width / 2 - UI.base.cursor.r;
        }
        UI.base.cursor.position.y = focusBounds.height / 2 - UI.base.cursor.r;
        UI.base.cursor.pivot.x = focusBounds.width / 2;
        UI.base.cursor.pivot.y = focusBounds.height / 2;
        // ½«½¹µãÌí¼Óµ½focusÉÏ
        focus.addChild(UI.base.cursor);
        // ½«½¹µã¿ò»Ö¸´³õÊ¼×´Ì¬£¬µÈ´ýonFocus·½·¨´¦Àí
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
        UI.base.cursor.getBounds();
    }
    JumpTiles.onkey_LEFT = function(focus) {
        var next = null;
        if (UI.getCurrFocus().leftTo) {
            next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().leftTo);
        }
        UI.base.navToNext(next, "leftTo");
        var index = JumpTiles.initSequence.indexOf(mainTiles.currFocus);
        navTo(index,index, JumpTiles, true);
        if(!!mainTiles.currFocus.data.filterflag){
            activeTimer =timerFunction(activeTimer,function(){
                channelTiles.currIndex = mainTiles.currFocus.data.filterflag - 1;
                channelTiles.posCount = 4;
                navTo2(channelTiles,mainTiles.currFocus.data.filterflag - 1,4,true);
                adjustChannel(channelTiles.initSequence[channelTiles.posCount]);
            },2000);
        }
        return false;
    };

    JumpTiles.onkey_RIGHT = function(focus) {
        var next = null;
        if (UI.getCurrFocus().rightTo) {
            next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().rightTo);
        }
        UI.base.navToNext(next, "rightTo");
        var index = JumpTiles.initSequence.indexOf(mainTiles.currFocus);
        navTo(index,index, JumpTiles, true);
        if(!!mainTiles.currFocus.data.filterflag){
            activeTimer =timerFunction(activeTimer,function(){
                channelTiles.currIndex = mainTiles.currFocus.data.filterflag - 1;
                channelTiles.posCount = 4;
                navTo2(channelTiles,mainTiles.currFocus.data.filterflag - 1,4,true);
                adjustChannel(channelTiles.initSequence[channelTiles.posCount]);
            },2000);
        }
        return false;
    };

    function adjustChannel(filterindex){
        if (!!filterindex.children[0] && filterindex.children[0].name == "shadow") {
            filterindex.children[0].alpha = 0;
        }
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(filterindex);
        }
        UI.moveCursor(adjustView(filterindex));
        UI.moveTop(filterindex);
        UI.base.runText(filterindex);
    }
   function navTo2(Tiles,index, posCount, notFocus) {
       Tiles.posCount = posCount;
       Tiles.currIndex = index;

       if (Tiles.currIndex >= Tiles.data.length - 1) {
           Tiles.currIndex = Tiles.data.length - 1;
           Tiles.posCount = Tiles.initSequence.length - 1;
       }
       if (Tiles.currIndex < 0) {
           Tiles.currIndex = 0;
       }

       if (Tiles.data.length <= Tiles.info.pageCount) {
           UI.refreshView(Tiles, Tiles.initSequence[0]);
           Tiles.posCount = Tiles.currIndex;
       } else if (Tiles.data.length - Tiles.currIndex <= 5) {
           Tiles.posCount = Tiles.initSequence.length - (Tiles.data.length - Tiles.currIndex);
           UI.refreshView(Tiles, Tiles.initSequence[Tiles.posCount]);
       }  else if (Tiles.currIndex <= 4) {
           Tiles.posCount = Tiles.currIndex;
           UI.refreshView(Tiles, Tiles.initSequence[Tiles.posCount]);
       }else {
           Tiles.posCount = 4;
           UI.refreshView(Tiles, Tiles.initSequence[Tiles.posCount]);
       }

       for (var i = 0; i < Tiles.initSequence.length; i++) {
           Tiles.refreshData(Tiles.initSequence[i], Tiles.data[Tiles.currIndex - Tiles.posCount + i]);
       }
       if(!notFocus){
           UI.focusTo(channelTiles.initSequence[Tiles.posCount]);
       }
       Tiles.moveScroll();
    }
    function adjustView(focus) {
        var target = focus.parent;
        var retPoint = new PIXI.Point();
        if (!target)  {
            return retPoint;
        }
        var viewRect = target.viewRect;
        if (!viewRect) {
            target = target.parent;
            viewRect = target.viewRect;
        }
        if (!viewRect) {
            return retPoint;
        }

        var viewRectPos = target.parent.toGlobal(viewRect.position);
        var focusPos = focus.parent.toGlobal(focus.position);
        var desPoint = new PIXI.Point();

        var distRight = focusPos.x + focus.pivot.x - viewRectPos.x - viewRect.rectWidth;
        var distLeft  = focusPos.x - focus.pivot.x - viewRectPos.x;
        var distDown  = focusPos.y + focus.pivot.y - viewRectPos.y - viewRect.rectHeight;
        var distUp    = focusPos.y - focus.pivot.y - viewRectPos.y;

        if (distRight > 0) {
            desPoint.x = target.x - distRight;
        } else if (distLeft < 0) {
            desPoint.x = target.x - distLeft;
        } else {
            desPoint.x = target.x;
        }
        if (distDown > 0) {
            desPoint.y = target.y - distDown;
        } else if (distUp < 0) {
            desPoint.y = target.y - distUp;
        } else {
            desPoint.y = target.y;
        }

        // ÕâÀïtargetµÄÎ»ÖÃÊÇÒÔ¶¯»­ÐÎÊ½ÒÆ¶¯µ½Ä¿±êÎ»ÖÃ
        UI.getTween(target).to({x:desPoint.x, y:desPoint.y}, 800, createjs.Ease.quartOut);

        // ¹ö¶¯ÌõÒ²ÏàÓ¦ÒÔ¶¯»­ÐÎÊ½ÒÆ¶¯µ½ÕýÈ·µÄÎ»ÖÃ£¨BigListµÄ¹ö¶¯Ìõ×Ô¼º¹ÜÀí£¬´Ë´¦ÅÐ¶Ï²¢ºöÂÔ£©
        if (target.scroll && !target.navTo) {
            UI.getTween(target.scroll, true)
                .to({
                    y : target.viewRect.y +
                    focus.position.y / target.height
                    * (viewRect.rectHeight - target.scroll.height)
                }, 500);
        }

        if (target.ArrowCallBack) {
            target.ArrowCallBack(distLeft, distRight);
        }

        return desPoint;
    }

    function showOnlyLauncherTiles(){
        launcherTiles.alpha = 1;
        inputTiles.alpha = 0;
        appTiles.alpha = 0;
        channelTiles.alpha = 0;
    }

    mainTiles.toLaunchMode = function() {
        //if (checkIsAppOn("netflix")) {
        //    launcher.overlayMain.alpha = 0;
        //    launcher.netflixOverlayMain.alpha = 1;
        //} else {
        //    launcher.overlayMain.alpha = 1;
        //    launcher.netflixOverlayMain.alpha = 0;
        //}

        launcher.isEditMode = false;
        launcher.isMoveMode = false;
        launcher.isDeleteMode = false;
        setImgAlpha(false);

        // function logReportTitleActionOrder(){
        //     try{
        //         DBG_INFO("log report order TitleAction");
        //         var tempobj={
        //             type:2
        //         };
        //         var param=logReportADO(tempobj,tempArray,UI.getCurrFocus());
        //         LGReport.GTLauncherTitleAction(param.ActionType,param.ChangeSource,param.TitleType,param.AddOrRemoveTitleName,param.TitlesNum,param.Titles);
        //     }catch(ex){DBG_ERROR(ex.message)}
        //
        //     try{
        //         if(LogReportData.GTLauncherTitleActionAddFlag==true){
        //             var temparrary=getCurrTileArray();
        //             //DBG_ERROR("jison:")
        //             //DBG_ERROR(JSON.stringify(temparrary));
        //             var tempobj={
        //                 type:1
        //             };
        //             DBG_INFO("log report TitleAction add");
        //             var param=logReportADO(tempobj,temparrary,UI.getCurrFocus());
        //             LGReport.GTLauncherTitleAction(param.ActionType,param.ChangeSource,param.TitleType,param.AddOrRemoveTitleName,param.TitlesNum,param.Titles);
        //             LogReportData.GTLauncherTitleActionAddFlag=false;
        //         }
        //     }catch(ex){DBG_ERROR(ex.message)}
        // }
        try{
            var forEach_break=null;
            var tempArray=getCurrTileArray();
            if (tempArray.length!=launcher.rememberLaunchArray.length){
                logReportTitleActionOrder();
            }else{
                try{
                    tempArray.forEach(function(v,index) {
                        if(v.Name!=launcher.rememberLaunchArray[index].Name){
                            throw (forEach_break=new Error("StopIteration"));
                        }
                    })
                }catch(ex){
                    if(ex==forEach_break){
                        logReportTitleActionOrder();
                    }
                }
            }
            launcher.rememberLaunchArray=tempArray;
        }catch(ex){DBG_ERROR(ex.message);}
        createjs.Tween.removeTweens(UI);

        launcherTiles.onkey_BACKSPACE = null;

        mainTiles.onkey_BACKSPACE = function(focus) {
            try{
                LogReportData.LauncherRunCloseReason=1;
            }catch(ex){DBG_ERROR('launcher onkey_BACKSPACE logreport is error')}
            launcher.popSelf(true);
        };
        mainTiles.onkey_ESCAPE = function(focus) {
            launcher.mainendfocus = focus;
            return true;
        };
        launcherTiles.onkey_LEFT = function(focus) {
            clearTimeout(showHintTimer);
            clearTimeout(hideHintTimer);
            var o = focus.leftTo;
            showHintTimer = timerFunction(showHintTimer,function(){
                setImgAlpha(true,o);
                hideHintTimer = timerFunction(hideHintTimer,function(){ setImgAlpha(false);},2000);
            },1500);
            adjustVisibleLeft(focus, launcherTiles);
            return true;
        };

        launcherTiles.onkey_RIGHT = function(focus) {
            clearTimeout(showHintTimer);
            clearTimeout(hideHintTimer);
            var o = focus.rightTo;
            showHintTimer = timerFunction(showHintTimer,function(){
                setImgAlpha(true,o);
                hideHintTimer =timerFunction(hideHintTimer,function(){ setImgAlpha(false);},2000);
            },1500);
            adjustVisibleRight(focus, launcherTiles);
            return true;
        };

        launcherTiles.onkey_ENTER = function(focus) {
          //  launcher.mainendfocus = focus;
            launcher.lastfocus = focus;
            if (focus.data.cmd == LauncherCMD.APP) {
                if(focus.data.obj.from == "store" && parseInt(focus.data.obj.appId)!=-1){
                    http_adapter.checkAppOnlineStatus(focus.data.obj.appId,function (result,v) {
                        DBG_INFO("wxj checkAppOnlineStatus:"+objToString(v));
                        if(v != null && result == 0 && v.appStatusLi[0].status == 0){
                            setLauncherDeleteAppByUser(focus.data.obj.url);
                            launcherTiles.removeItem(focus);
                            UI.pushSubModule("launcher", "appStoreDialog",true, {caller: "allApps"});

                        }else{
                            if (!getNetworkSatus() && focus.data.obj.url != "netflix") {
                                UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "mainTiles"});
                            }
                            else {
                                GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                                if(!!focus.data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                                    UI.pushSubModule("launcher", "launcherPassword",true,  {caller: "mainTiles"});
                                }
                                else{
                                    UI.popAllModule();
                                    launcher.firstRefresh = true;
                                    startThirdPartyApp(null, focus.data.obj.url, focus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF, focus.data.obj.txt, focus.data.obj.storeType);
                                }
                            }
                        }
                    });

                    return;
                }
                if(!GLOBAL.APP_ENABLE_START_FLAG){
                    DBG_ERROR("launcherTiles.onkey_ENTER:not enable netflix");
                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.APP_START_SYSLOADING_TIP;
                    UI.pushGhostModule("setting", "SettingSysToast");
                    return;
                }
                if (!getNetworkSatus() && focus.data.obj.url != "netflix") {
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "mainTiles"});
                }else{
                    GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                    if(!!focus.data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                        UI.pushSubModule("launcher", "launcherPassword",true,  {caller: "mainTiles"});
                    }
                    else{

                        var appName = null;
                        if(focus.data.obj.url == "search-hisense"){
                            var search = UI.getSubModuleById("searchUSO", "search");
                            if (!!search && search.alpha == 1){
                                UI.clearAllSubModule("launcher", true, true);
                                return;
                            }
                            appName = APPNAME.SEARCH;
                        }else if(focus.data.obj.url == "4know-hisense"){
                            var forknowMain = UI.getSubModuleById("fourknow", "fourknowMain");
                            if (!!forknowMain && forknowMain.alpha == 1){
                                UI.clearAllSubModule("launcher", true, true);
                                return;
                            }
                            appName = APPNAME.NEW4KNOW;
                        }else if(focus.data.obj.url == "appstore-hisense"){
                            var appStore = UI.getSubModuleById("AppStore", "appStore");
                            if (!!appStore && appStore.alpha == 1){
                                UI.clearAllSubModule("launcher", true, true);
                                return;
                            }
                            appName = APPNAME.HISENSESTORE;
                        }
                        if(appName == APPNAME.SEARCH){
                            UI.popAllModule(true);
                        }else{
                            UI.popModule(true);
                        }
                        launcher.firstRefresh = true;
                        startThirdPartyApp(appName, focus.data.obj.url, focus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF, focus.data.name, focus.data.obj.storeType);
                    }

                }

                            //startThirdPartyApp(null, focus.data.obj.url, focus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF);
                        }
            else if(focus.data.cmd == LauncherCMD.BROWSER || focus.data.cmd == LauncherCMD.YOUTUBE_VIDEO){
                if (!getNetworkSatus()) {
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "mainTiles"});
                }else{
                    UI.popAllModule();
                    launcher.firstRefresh = true;
                    startThirdPartyApp(null, focus.data.obj.url, focus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF, focus.data.obj.txt, focus.data.obj.storeType);

                }

            }

                        else if (focus.data.cmd == LauncherCMD.INPUT) {
                             LogReportData.LauncherRunCloseReason=3;
                             launcher.inputChanged = true;
                            var mode = tv?model.system.getUserMode():0;
                            if (focus.data.obj.id == "100") {
                                UI.popAllModule();
                                //UI.getItem(UI.getSubModule("mainTiles"), "launcherTiles").alpha = 1;
                                //launcher.popSelf(false);
                                StartAnyViewCast();


                                //UI.popAllModule();
                                //UI.pushSubModule("miracast", "miracastMain", true);
                                UI.base.cursor.alpha = 0;
                            }else if(focus.data.obj.id == "300" && mode == 0){
                                if (!getNetworkSatus()) {
//                                    UI.setText(msgTxt, "[SE1881]");
//                                    UI.callTTS("[SE1881]");
                                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "mainTiles"});
//                                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);

                                }else{
                                    UI.popAllModule();
                                    if (checkIsAppOn() && appControl.getCurrentStartMethod() == CMDMethod.BYAPP) appControl.setCurrentStartMethod(CMDMethod.MENU);
                                    var obj = {
                                        "name":focus.data.obj.name,
                                        "url":focus.data.obj.uid
                                    };
                                    writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                                    startThirdPartyApp(APPNAME.OTT, focus.data.obj.uid,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",focus.data.obj.name,98);
                                }
                            }
                            else {
                                UI.popAllModule();
                                if (checkIsAppOn()) {
                                    DBG_ERROR("launcherTiles.onkey_ENTER:app is not stop,stop it then change source");
                                    appControl.stopCurrentApp();
                                    appStoppedFunc = function () {
                                        changeSourceTo(focus.data.obj.id);
                                        openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                                        resumeDTV();
                                    };
                                }else{
                                    changeSourceTo(focus.data.obj.id);
                                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                                }

                            }
                        }
                        else if (focus.data.cmd == LauncherCMD.CHANNEL) {
                             LogReportData.LauncherRunCloseReason=0;
                             launcher.firstRefresh = true;
                            DBG_INFO("change channel from launcher");
                            //GLOBAL.CURRENT_SOURCE = SourceList.TV;

                            var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
                            if (null != appGhost) {
                                UI.popAllModule();
                                appStoppedFunc = function () {
                                    checkAndPlayChannel(focus.data.obj);
                                    openLiveTVModule([Msg.INFO, 0]);
                                    resumeDTV();
                                };
                                appControl.stopCurrentApp();
                            }
                            else {
                                UI.popAllModule();
                                checkAndPlayChannel(focus.data.obj);
                                openLiveTVModule([Msg.INFO, 0]);
                            }


                        }else if(focus.data.cmd == LauncherCMD.FVP){
                            launcher.firstRefresh = true;
                            UI.pushSubModule("FVP", "fvpMain", true);
                            //UI.pushSubModule("launcher", "fvpApps", true);
                        }
            //        }, [focus])
            //        .wait(300)
            //        .set({alpha:0})
            //}
        };
        launcherTiles.onkey_UP = function(focus) {
            setImgAlpha(false);
            DBG_ERROR(mainTiles.initPos.y);
            prepareMoveMode(focus);
            toMoveMode(focus);
        };
        launcherTiles.onkey_DOWN = function (focus) {
            clearTimeout(activeTimer);
            clearTimeout(showHintTimer);
            clearTimeout(hideHintTimer);
            UI.getTween(arrangeImg1).to({alpha: 0}, 100);
            UI.getTween(arrangeImg2).to({alpha: 0}, 100);
            UI.getTween(secondaryImg).to({alpha: 0.5}, 100);
            UI.getTween(secondaryImg2).to({alpha: 1}, 100);
            UI.getTween(secondaryTxt).to({alpha: 0.9}, 100);
            prepareEditMode(focus);
            toEditMode(focus);
            UI.activeKey();
        };
        notification.onkey_ENTER = function() {
            launcher.firstRefresh = true;
            setImgAlpha(false);
            UI.pushSubModule("launcher", "notifications", true);
        };

        if (livetv) {
            livetv.onkey_ENTER = function() {

                    if(!g_fteNoneSource.none){
                        var ott = readFileFromNative("launcher/DefaultSource.txt", 1);
                        DBG_ERROR("getOttToDefaultSource "+ JSON.stringify(ott));
                        var mode = tv?model.system.getUserMode():0;
                        if(ott!=null && ott.id != 0 && mode==0){
                            UI.popAllModule();
                            if(checkIsAppOn() &&(appControl.getCurrentAPPCMD() == "https://hisense-lite-app.xumo.com/latest/index.html"
                                || appControl.getCurrentAPPName() == APPNAME.OTT)){
                                appControl.focusCurrentApp();
                            }else{
                                var obj = {
                                    "name":APPNAME.OTT,
                                    "url":ott.url
                                };
                                writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                                startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",APPNAME.OTT,98);

                            }
                        }else{
                            var defaultId = mapInputsDataByPlayId(model.source.getSystemDefaultInput());
                            var currentId = mapInputsDataByPlayId(model.source.getCurrentSource());
                            if(defaultId != currentId){
                                changeSourceTo(defaultId);// model.system.getSystemDefaultInput()
                                UI.popAllModule();
                                openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                            }
                            else {
                                var isAppOn = checkIsAppOn();
                                if (isAppOn) {
                                    appControl.stopCurrentApp();
                                }
                                UI.popAllModule();
                                isAppOn ? openLiveTVModule([Msg.INFO, 0]): openLiveTVModule();
                            }
                        }

                    } else {
                        var isAppOn = checkIsAppOn();
                        if (isAppOn) {
                            appControl.stopCurrentApp();
                        }
                        UI.popAllModule();
                        isAppOn ? openLiveTVModule([Msg.INFO, 0]): openLiveTVModule();
                    }
                //}
                //UI.pushModule(LIVETV.MAIN);
            };
        }

        media.onkey_ENTER = function() {
            launcher.firstRefresh = true;
            setImgAlpha(false);
            if (launcher.caller == "hiMedia") {
                UI.popModule(true);
                hiMedia.changeByLauncher("resume");
            } else {
                UI.popAllModule();
                GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                startThirdPartyApp(null, APPNAME.HIMEDIA, CMDType.HISENSEPAGE, CMDMethod.MENU, false, 0xFFFFFF);
            }
        };

        apps.onkey_ENTER = function() {
            launcher.firstRefresh = true;
            setImgAlpha(false);
            mainTiles.allAppsIndex = launcherTiles.initSequence.indexOf(apps);
                UI.pushSubModule("launcher", "allApps", true);
        };

        inputs.onkey_ENTER = function() {
            launcher.firstRefresh = true;
            setImgAlpha(false);
            UI.pushSubModule("launcher", "allInputs", true);
        };

        setting.onkey_ENTER = function() {
           // launcher.mainendfocus = setting;
            setImgAlpha(false);
            launcher.firstRefresh = true;
            launcher.setting  = true;
            UI.pushSubModule("setting", "mainPanel", true);
        };
    };

    function toEditMode(focus) {

        //if (checkIsAppOn("netflix")) {
        //    launcher.overlayMain.alpha = 1;
        //    launcher.netflixOverlayMain.alpha = 0;
        //} else {
        //    launcher.overlayMain.alpha = 0;
        //    launcher.netflixOverlayMain.alpha = 1;
        //}

        //UI.setText(UI.getItem(edit, "nameTxt"), "[GE0013]");
        //if(!!focus){
        //    if(focus.name == "edit"){
        //        UI.callTTS("[SE3154]" + "[SE3219]" + UI.base.getVoiceStr(edit));
        //    }
        //    else{
        //        if (!!focus.data && focus.data.voiceStr) {
        //            UI.callTTS(focus.data.voiceStr);
        //        }else{
        //            UI.callTTS(UI.base.getVoiceStr(focus));
        //        }
        //    }
        //}

       // UI.setText(primaryTxt1, "[SE3154]");
       // primaryTxt2.alpha = 0;

        doForNetflix("editMode");
        //var helpInfo = UI.getSubModule("helpInfo");
        var msgPanel = UI.getItem(statusBar, "msgPanel");
        msgPanel.alpha = 0;
        launcher.isEditMode = true;
        launcher.isMoveMode = false;
        launcher.isDeleteMode = false;

        notification.onkey_ENTER = null;
        media.onkey_ENTER = null;
        apps.onkey_ENTER = null;
        inputs.onkey_ENTER = null;
        setting.onkey_ENTER = null;
        if (livetv) {
            livetv.onkey_ENTER = null;
        }
        filter = UI.getItem(JumpTiles,"filter");
        if(!!filter){
            filter.onkey_ENTER = function() {
                UI.pushSubModule("launcher", "selectFilter", true);
            };

        }
        mainTiles.onkey_UP = UI.blankFunc;

        launcherTiles.onkey_LEFT = UI.blankFunc;

        launcherTiles.onkey_RIGHT = UI.blankFunc;

        launcherTiles.onkey_ENTER = UI.blankFunc;
        launcherTiles.onkey_UP = UI.blankFunc;
        launcherTiles.onkey_DOWN = function(focus) {
        UI.inactiveKey();
        inputTiles.alpha = 1;
        appTiles.alpha = 1;
        UI.getTween(UI.base.cursor).set({alpha:0});
        launcherTiles.lastFocus = focus;
        UI.getTween(mainTiles).to({y:mainTiles.editModePos.y - 710}, 400)
            .call(UI.focusTo, [inputTiles.initSequence[inputTiles.posCount]])
            .wait(400)
            .call(UI.activeKey);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 2380}, 400).call(
            function(){
                //launcherTiles.alpha = 0;
                //UI.getTween(launcher.overlayAdd).to({alpha:1}, 0);
                //UI.getTween(launcher.overlayEdit).to({alpha:0}, 400);
            });
        };

        //edit.onkey_ENTER = function(focus) {
        //    UI.refreshView(launcherTiles, focus);
        //    resetVisible(launcherTiles);
        //
        //    createjs.Tween.removeTweens(launcherTiles);
        //    mainTiles.prepareLaunchMode(focus);
        //    mainTiles.toLaunchMode();
        //    UI.focusTo(focus);
        //};

        launcherTiles.onkey_BACKSPACE = function(focus) {
            if(!!launcherTiles.initSequence[addIndex] && launcherTiles.initSequence[addIndex].name == "addicon"){
                launcherTiles.removeItem(launcherTiles.initSequence[addIndex], true);
            }
            mainTiles.prepareLaunchMode(focus);
            mainTiles.toLaunchMode();
            UI.focusTo(launcherTiles.initSequence[addIndex - 1]);
        };

        //reset.onkey_ENTER = function(focus) {
        //    UI.pushSubModule("launcher", "resetConfirm", true);
        //}
    }

    function toMoveMode(focus) {

        //UI.setText(primaryTxt1, "[SE3155]");
        //UI.setText(primaryTxt2, "[SE3156]");
        //primaryTxt2.alpha = 1;


        doForNetflix("moveMode", focus);

        launcher.isEditMode = false;
        launcher.isMoveMode = true;
        launcher.isDeleteMode = false;

        focus.onkey_LEFT = function(focus) {
            UI.inactiveKey();
            if (launcherTiles.lastDirection != "right") {
                launcherTiles.focusIndex--;
            }
            launcherTiles.xNum--;
            launcherTiles.lastDirection = "left";
            var movable = launcherTiles.initSequence[launcherTiles.focusIndex];

            if (launcherTiles.focusIndex < 1) {
                UI.inactiveKey();
                if (launcherTiles.lastDirection != "right") {
                    launcherTiles.focusIndex++;
                }
                launcherTiles.xNum++;
              //  focus.onkey_DOWN = onKeyDownForMoveMode;
                shakeFocus(focus);
                return;
            }
            if (launcherTiles.focusIndex <= 1) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100}, 400, UI.ease.quartOut);
            }
            if (launcherTiles.focusIndex >= 2) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x}, 400, UI.ease.quartOut);
            }
            if (launcherTiles.focusIndex == launcherTiles.initSequence.length - 1) {
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x}, 400, UI.ease.quartOut);
            }

            if(launcherTiles.initSequence[launcherTiles.focusIndex - 6]) {
                launcherTiles.initSequence[launcherTiles.focusIndex - 6].alpha = 1;
            }
            if(launcherTiles.initSequence[launcherTiles.focusIndex + 6]) {
                launcherTiles.initSequence[launcherTiles.focusIndex + 6].alpha = 0;
            }
            if (movable) {
                UI.getTween(launcherTiles).to({x:launcherTiles.movePosX - (movable.getBounds().width + 50) * launcherTiles.xNum}, 400);
                if (movable.directionFlg) {
                    UI.getTween(movable).to({x:movable.initX}, 400);
                    movable.directionFlg = false;
                } else {
                    UI.getTween(movable).to({x:movable.leftX}, 400);
                    movable.directionFlg = true;
                }
            }
            activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},400);
            //UI.getTween(UI).wait(400).call(function(){
            //    UI.activeKey();
            //})
        };

        focus.onkey_RIGHT = function(focus) {
            UI.inactiveKey();
            if(launcherTiles.focusIndex < 1){
                shakeFocus(focus);
                return;
            }
            if (launcherTiles.lastDirection == "right") {
                launcherTiles.focusIndex++;
            }
            launcherTiles.lastDirection = "right";
            launcherTiles.xNum++;
            var movable = launcherTiles.initSequence[launcherTiles.focusIndex];

            if (launcherTiles.focusIndex == launcherTiles.initSequence.length) {
                UI.inactiveKey();
                if (launcherTiles.lastDirection == "right") {
                    launcherTiles.focusIndex--;
                }
                launcherTiles.xNum--;
                //focus.onkey_DOWN = onKeyDownForMoveMode;
                shakeFocus(focus);
                return;
            }
            if (launcherTiles.focusIndex == launcherTiles.initSequence.length - 1) {
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 100}, 400, UI.ease.quartOut);
            }
            if (launcherTiles.focusIndex < launcherTiles.initSequence.length - 1) {
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x}, 400, UI.ease.quartOut);
            }
            if (launcherTiles.focusIndex == 1) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x}, 400, UI.ease.quartOut);
            }

            if(launcherTiles.initSequence[launcherTiles.focusIndex + 6]) {
                launcherTiles.initSequence[launcherTiles.focusIndex + 6].alpha = 1;
            }
            if(launcherTiles.initSequence[launcherTiles.focusIndex - 6]) {
                launcherTiles.initSequence[launcherTiles.focusIndex - 6].alpha = 0;
            }
            if (movable) {
                UI.getTween(launcherTiles).to({x:launcherTiles.movePosX - (movable.getBounds().width + 50) * launcherTiles.xNum}, 400);
                if (movable.directionFlg) {
                    UI.getTween(movable).to({x:movable.initX}, 400);
                    movable.directionFlg = false;
                } else {
                    UI.getTween(movable).to({x:movable.rightX}, 400);
                    movable.directionFlg = true;
                }
            }
            //focus.onkey_DOWN = onKeyDownForMoveMode;
            //focus.onkey_UP = onkeyUpForMoveMode;
            activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},400);
            //UI.getTween(UI).wait(400).call(function(){
            //    UI.activeKey();
            //})
        };

        focus.onkey_ENTER = focus.onkey_BACKSPACE = focus.onkey_DOWN = function(focus) {
            DBG_ERROR(mainTiles.initPos.y);
            onKeyDownForMoveMode(focus);
            UI.refreshView(launcherTiles, focus);
            resetVisible(launcherTiles);
            focus.onkey_BACKSPACE = null;
            focus.onkey_DOWN = null;
            focus.onkey_ENTER = null;
            createjs.Tween.removeTweens(launcherTiles);
           // mainTiles.prepareLaunchMode(focus);
            mainTiles.toLaunchMode();
            UI.activeKey();
            UI.focusTo(focus);

        };

        focus.onkey_UP = onkeyUpForMoveMode;
    }
    function logReportTitleType(cmd){
        var TitleType=null;
        switch (cmd){
            case LauncherCMD.INPUT:
                return TitleType=1;
            case LauncherCMD.APP:
                return TitleType=2;
            default :
                return TitleType=3;
        }
    }
    function getCurrTileArraySelected(id,arr){
        try{var i=0;
            while(i<arr.length){
                if(id.data.name==arr[i].Name||id.data.name==undefined?0:id.data.name.split('-')[1]==arr[i].Name){
                    return arr[i];
                }
                if(id.data.Name==arr[i].Name||id.data.Name==undefined?0:id.data.Name.split('-')[1]==arr[i].Name){
                    return arr[i];
                }

                i++;
            }
            if(i=arr.length){
                return arr[arr.length-1];
            }
        }catch (ex){
            DBG_ERROR(ex.message)
        }
    }
    function logReportADO(datatypeobj,tileArrary,focus){
        try{
            var param={};
            param.ActionType=datatypeobj.type;
            //var Arrlen=tileArrary.length;
            switch (datatypeobj.type)
            {
                case 3:
                    param.TitleType=logReportTitleType(datatypeobj.cmd);
                    break;
                case 2:
                    param.TitleType='';
                    break;
                case 1:
                    param.TitleType=logReportTitleType(focus.data.cmd);
                    break;
                default :
                    break;

            }
            param.ChangeSource=2;
            var TileLength=tileArrary.length + 1;
            switch (param.TitleType){
                case 1:
                    param.Titles=param.AddOrRemoveTitleName=!!focus.data.nameTxt ? focus.data.nameTxt:focus.data.obj.txt;
                    param.TitlesNum=TileLength;
                    break;
                case 2:param.AddOrRemoveTitleName='';
                    param.Titles=param.AddOrRemoveTitleName=focus.data.obj.txt;
                    param.TitlesNum=TileLength;
                    break;
                case 3:
                    param.Titles=param.AddOrRemoveTitleName=focus.data.obj.number;
                    param.TitlesNum=TileLength;
                    break;
                default :
                    param.Titles=param.AddOrRemoveTitleName=focus.data.name;
                    param.TitlesNum=TileLength;
                    break;
            }
            if(param.ActionType==2){
                param.Titles = param.AddOrRemoveTitleName='';
            }
        }catch(ex){DBG_ERROR("logReportADO"+ex.message)}
        return param;
    }

    function toDeleteMode(focus) {
        UI.callTTS("[SE3157]");
        //UI.setText(primaryTxt1, "[SE3157]");
        //primaryTxt2.alpha = 0;

        launcher.isEditMode = false;
        launcher.isMoveMode = false;
        launcher.isDeleteMode = true;

        focus.onkey_LEFT = UI.blankFunc;
        focus.onkey_RIGHT = UI.blankFunc;

        focus.onkey_UP = function(focus) {
            UI.inactiveKey();
            var tileArray = getCurrTileArray();
            setRememberEditAppToNativeFile(tileArray);
            var Index = launcherTiles.initSequence.indexOf(focus);
            launcher.currentData.splice(Index, 1);
            if(focus.data.cmd == LauncherCMD.BROWSER && focus.data.obj.storeType == StoreType.BROWSER &&
                focus.data.obj.url != "browser"){
                DBG_ERROR("del a app from foxxum:");
                setLauncherDeleteFoxxumAppByUser(focus.data.obj.url);
            }
            launcher.editRefresh = true;
           // launcher.editflg = true;
            launcher.isEditMode = true;
            launcher.isMoveMode = false;
            launcher.isDeleteMode = false;
            UI.getTween(moveIcons).to({alpha:0}, 400, UI.ease.quartOut);
            UI.getTween(focus.scale).to({x:0, y:0}, 400, UI.ease.quartOut).call(function(){
                leftIcon.y = leftIcon.y - 50;
                rightIcon.y = rightIcon.y - 50;
                deleteIcon.scale.x = deleteIcon.scale.y = 1;
                upIcon.alpha = 0;


                for (i = 0; i < launcherTiles.children.length; i++) {
                    launcherTiles.children[i].alpha = 1;
                }
                Gird.resetNavigation(launcherTiles, launcherTiles.info);
                try{
                    var tempobj={
                        name:focus.data.name==undefined?focus.data.Name:focus.data.name,
                        type:3,
                        cmd:focus.data.cmd
                    };
                    DBG_INFO("Log report TitleAction Delete");
                    var param=logReportADO(tempobj,tileArray,focus);
                    LGReport.GTLauncherTitleAction(param.ActionType,param.ChangeSource,param.TitleType,param.AddOrRemoveTitleName,param.TitlesNum,param.Titles);
                }catch(ex){DBG_ERROR(ex.message)}
                //focus.parent.removeChild(focus);
                focus.scale.x = 1;
                focus.scale.y = 1;
                if(inputTiles.children.length == 0 || appTiles.children.length == 0 || channelTiles.children.length == 0){
                    refreshInputTiles();
                    refreshAppTiles();
                    refreshChannelTiles();
                    refreshJumpTiles();
                    JumpTiles.alpha = 0;
                }
                if (focus.data.cmd == LauncherCMD.INPUT) {
                    var data = null;
                    data = focus.data;
                    data.voiceStr = "[SE3151]" + data.voiceStr;
                    inputTiles.addItemAt(data ,inputTiles.currIndex ,true);
                    if (!inputTiles.data[1].obj) {
                        inputTiles.data.splice(1, 1);
                        inputTiles.removeChild(inputTiles.initSequence[0]);
                        inputTiles.initSequence.splice(0, 1);
                        inputTiles.viewRect = inputTiles.initViewRect;
                    }
                    if (inputTiles.currIndex >= inputTiles.data.length - 5 && inputTiles.data.length >= 9) {
                        inputTiles.posCount--;
                        if (inputTiles.posCount > inputTiles.initSequence.length - 1) {
                            inputTiles.posCount = inputTiles.initSequence.length - 1;
                        }
                    }
                    navTo(inputTiles.currIndex, inputTiles.posCount, inputTiles);
                    inputTiles.refreshNav();
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    if(!!focus.data.nameTxt){
                        UI.setText(msgTxt,focus.data.nameTxt + " " + "[SE3665]");
                    }else{
                        UI.setText(msgTxt,focus.data.obj.name + " " + "[SE3665]");
                    }
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                    focus.parent.removeChild(focus);
                } else if (focus.data.cmd == LauncherCMD.APP || focus.data.cmd == LauncherCMD.BROWSER) {
                    var data = null;
                    data = focus.data;
                    data.voiceStr = "[SE3150]" + data.name ;
                    appTiles.addItemAt(data ,appTiles.currIndex ,true);
                    if (!appTiles.data[1].obj) {
                        appTiles.data.splice(1, 1);
                        appTiles.removeChild(appTiles.initSequence[0]);
                        appTiles.initSequence.splice(0, 1);
                        // channelTiles.initSequence[0].x += 132;
                        appTiles.viewRect = appTiles.initViewRect;
                    }
                    if (appTiles.currIndex >= appTiles.data.length - 5 && appTiles.data.length >= 9) {
                        appTiles.posCount--;
                        if (appTiles.posCount > appTiles.initSequence.length - 1) {
                            appTiles.posCount = appTiles.initSequence.length - 1;
                        }
                    }
                    navTo(appTiles.currIndex, appTiles.posCount, appTiles);
                    appTiles.refreshNav();
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    UI.setText(msgTxt,focus.data.name + " " + "[SE3665]");
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                    focus.parent.removeChild(focus);
                } else {
                    var data = null;
                    var destination = 0 ;
                    data = focus.data;
                    data.voiceStr = "[SE3149]" + data.voiceStr ;
                    if(focus.data.number < channelTiles.data[0].number){
                        channelTiles.addItemAt(data ,0 ,true);
                    }
                    else if(focus.data.number > channelTiles.data[channelTiles.data.length - 1].number){
                        channelTiles.addItemAt(data ,channelTiles.data.length ,true);
                    }
                    else{
                        for(i = 0;i < channelTiles.data.length;i++){
                            if(channelTiles.data[i].number < focus.data.number){
                                if(channelTiles.data[i + 1].number > focus.data.number){
                                    destination = i + 1;
                                }
                            }
                        }
                        channelTiles.addItemAt(data ,destination ,true);
                    }
                    if (!channelTiles.data[1].obj) {
                        channelTiles.data.splice(1, 1);
                        channelTiles.removeChild(channelTiles.initSequence[0]);
                        channelTiles.initSequence.splice(0, 1);
                       // channelTiles.initSequence[0].x += 132;
                        channelTiles.viewRect = channelTiles.initViewRect;
                    }
                    if (channelTiles.currIndex >= channelTiles.data.length - 5 && channelTiles.data.length >= 9) {
                        channelTiles.posCount--;
                        if (channelTiles.posCount > channelTiles.initSequence.length - 1) {
                            channelTiles.posCount = channelTiles.initSequence.length - 1;
                        }
                    }
                    navTo(channelTiles.currIndex, channelTiles.posCount,channelTiles);
                   channelTiles.refreshNav();
                    var msgPanel = UI.getItem(statusBar, "msgPanel");
                    var msgTxt = UI.getItem(msgPanel, "msgTxt");
                    var bgImg = UI.getItem(msgPanel, "bgImg");
                    bgImg.doFlip = true;
                    UI.setText(msgTxt,focus.data.nameTxt1 + " " + "[SE3665]");
                    UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
                    focus.parent.removeChild(focus);
                }

                focus.onkey_BACKSPACE = null;
                focus.onkey_LEFT = null;
                focus.onkey_RIGHT = null;
                focus.onkey_ENTER = null;
                for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                    var target = launcherTiles.initSequence[i];
                    target.x = target.x - 50 * i;
                    if (i >= launcherTiles.focusIndex) {
                        target.x = target.x - 362;
                    }
                }
                //launcherTiles.x = launcherTiles.x - 312 * launcherTiles.focusIndex;
                if(launcherTiles.focusIndex >= launcherTiles.initSequence.length){
                    launcherTiles.focusIndex = launcherTiles.initSequence.length - 1;
                }else if(launcherTiles.focusIndex < 1){
                    launcherTiles.focusIndex = 1;
                }

                UI.getTween(mainTiles).to({x:mainTiles.initPos.x,y:mainTiles.initPos.y}, 800, UI.ease.quartOut)
                mainTiles.toLaunchMode();
                UI.focusTo(launcherTiles.initSequence[launcherTiles.focusIndex - 1]);
                initVisible(launcherTiles.initSequence[launcherTiles.focusIndex - 1],launcherTiles, 3, 6)
                activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},700);
            }, [focus]);
        };

        focus.onkey_ENTER = focus.onkey_BACKSPACE = focus.onkey_DOWN = function(focus) {
            UI.getTween(deleteIcon.scale).to({x:1, y:1}, 400);
            UI.getTween(focus.scale).to({x:1.15, y:1.15}, 400);
            if (launcherTiles.focusIndex == 1) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }  else if (launcherTiles.focusIndex == launcherTiles.initSequence.length - 2) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 100, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }
           else if (launcherTiles.focusIndex > 1 &&launcherTiles.focusIndex < launcherTiles.initSequence.length - 2 ) {
                UI.getTween(leftIcon).to({x:leftIcon.initPos.x, y:leftIcon.y - 50}, 400, UI.ease.quartOut);
                UI.getTween(rightIcon).to({x:rightIcon.initPos.x, y:rightIcon.y - 50}, 400, UI.ease.quartOut);
            }

            UI.getTween(upIcon).to({alpha:0}, 400, UI.ease.quartOut);
            toMoveMode(focus);
        };

    }

    mainTiles.prepareLaunchMode = function() {
        launcherTiles.x = launcherTiles.x + 624;
        launcherTiles.info.distanceX = 0;
        launcher.isEditMode = false;
        mainTiles.x = mainTiles.initPos.x;
        UI.getTween(mainTiles).to({y:mainTiles.initPos.y}, 600, UI.ease.quartOut);
        UI.getTween(statusBar).to({y:statusBar.initPos.y - 1325}, 300)
            .call(function(){
                showOnlyLauncherTiles();
            });
    };

    function prepareEditMode(focus) {
        UI.inactiveKey();
        launcherTiles.info.distanceX = 0;
        if(!!launcher.inputRenamed){
            launcher.refreshLauncherData();
            launcher.inputRenamed = false;
        }

        refreshInputTiles();
        refreshAppTiles();
        refreshChannelTiles();
        refreshJumpTiles();
        setLastFocus();
        filter = UI.getItem(JumpTiles,"filter");
        JumpTiles.alpha = 0;
        launcher.isEditMode = true;
        addIndex = launcherTiles.initSequence.indexOf(focus) + 1;
        var data = {
            template : "launcher_tile_1_big",
            bgImg : "launcher/la_ic_hint_placeholder.png",
            name : "addicon"
        };
        launcherTiles.addItemAt(data, addIndex);
        //initVisible(focus, launcherTiles, 3, 6);
        launcher.onNormal(focus);
            var point = mainTiles.parent.toGlobal(mainTiles.position);
            mainTiles.editModePos = new PIXI.Point(mainTiles.x + (1000- point.x), mainTiles.y);
            UI.getTween(mainTiles).to({x:mainTiles.editModePos.x,y:mainTiles.editModePos.y}, 600, UI.ease.quartOut);
    }

    function prepareMoveMode(focus) {
        UI.inactiveKey();
        var index = launcherTiles.initSequence.indexOf(focus);
        //if (index == 0 || index > launcherTiles.initSequence.length - 3) {
        //    shakeFocus(focus);
        //    return false;
        //}
        focus.initY = focus.y;
        launcher.editRefresh = true;
        var j = 0;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            var target = launcherTiles.initSequence[i];
            target.x = target.x + 50 * i;
            if (target == focus) {
                j = i;
            }
        }
        launcherTiles.x = launcherTiles.x - 50 * j - 312;
        var point = mainTiles.parent.toGlobal(mainTiles.position);
        mainTiles.editModePos = new PIXI.Point(mainTiles.x + (1300- point.x), mainTiles.y);
        UI.getTween(mainTiles).to({x:mainTiles.editModePos.x,y:mainTiles.editModePos.y}, 400, UI.ease.quartOut);


        launcherTiles.info.distanceX = 50;
        initVisible(focus, launcherTiles, 3, 6);
       // UI.getTween(statusBar).to({alpha:0}, 400);
        var point1 = focus.parent.toGlobal(focus.position);
        var point2 = mainTiles.parent.toGlobal(mainTiles.position);
        focus.x = point1.x - point2.x;
        focus.y = point1.y - point2.y;
        //if(!!launcher.addto){
        //    leftIcon.initPos.x = leftIcon.initPos.x + 20;
        //    rightIcon.initPos.x = rightIcon.initPos.x - 20;
        //    leftIcon.y = leftIcon.initPos.y + 40;
        //    rightIcon.y = rightIcon.initPos.y + 40;
        //    moveIcons.y = focus.y - 200;
        //}else{
            leftIcon.x = leftIcon.initPos.x + 100;
            rightIcon.x = rightIcon.initPos.x - 100;
            moveIcons.y = focus.y - 200;
       // }
        moveIcons.x = focus.x;
        if (index == 0) {
            UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100}, 400, UI.ease.quartOut);
            UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 100}, 400, UI.ease.quartOut);
        }else if (index == 1) {
            UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100}, 400, UI.ease.quartOut);
            UI.getTween(rightIcon).to({x:rightIcon.initPos.x}, 400, UI.ease.quartOut);
        } else if (index == launcherTiles.initSequence.length - 1) {
            UI.getTween(leftIcon).to({x:leftIcon.initPos.x}, 400, UI.ease.quartOut);
        } else {
            UI.getTween(leftIcon).to({x:leftIcon.initPos.x}, 400, UI.ease.quartOut);
            UI.getTween(rightIcon).to({x:rightIcon.initPos.x}, 400, UI.ease.quartOut);
        }

        deleteIcon.visible = !focus.data.noRemove;
        UI.getTween(moveIcons).to({alpha:1}, 400).call(UI.activeKey);

        mainTiles.lastMoveFocus = focus;
        mainTiles.addChild(focus);
      //  mainTiles.addChild(UI.base.cursor);

        for (var i = 0; i < launcherTiles.children.length; i++) {
            launcherTiles.children[i].alpha = 0.7;
        }
        UI.getTween(launcherTiles).to({y:launcherTiles.y + 150}, 400, UI.ease.quartOut);

        launcherTiles.focusIndex = launcherTiles.initSequence.indexOf(focus);
        launcherTiles.initSequence.splice(launcherTiles.focusIndex, 1);

        launcherTiles.xNum = 0;
        launcherTiles.movePosX = launcherTiles.x;
        launcherTiles.lastDirection = "none";

        for (i = 0; i < launcherTiles.initSequence.length; i++) {
            launcherTiles.initSequence[i].initX = launcherTiles.initSequence[i].x;
            launcherTiles.initSequence[i].leftX = launcherTiles.initSequence[i].x + launcherTiles.initSequence[i].getBounds().width + 50;
            launcherTiles.initSequence[i].rightX = launcherTiles.initSequence[i].x - launcherTiles.initSequence[i].getBounds().width - 50;
            launcherTiles.initSequence[i].directionFlg = false;
        }
        return true;
    }

    function refreshTiles() {
        refreshLauncherTiles(launcher.currentData);
        getAllObjects();
        setLastFocus();

        launcherTiles.lastFocus = mainTiles.currFocus = apps;
    }

    function refreshLauncherTiles(launcherData) {
        launcherTiles.removeAllChildren();
        var array = [];
        var notificationdata = {
            bgImg : new PIXI.Graphics()
                .beginFill(0x7BBB36)
                .drawRect(0, 0, 312, 312)
                .endFill(),
            iconImg : mainTiles.newNotification ? "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_yes.png" : "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_no.png",
            nameTxt : "[SE2970]",
            name : "notification",
            noMove : true,
            noRemove : true
        };

        if(GLOBAL.LAUNCHER_BRAND == "shp"){
            notificationdata.bgImg =  new PIXI.Graphics()
                .beginFill(0x403F41)
                .drawRect(0, 0, 312, 312)
                .endFill()
        }
        else{
            if(GLOBAL.UI_BRAND == "tos"){
                notificationdata.bgImg =  new PIXI.Graphics()
                    .beginFill(0x0F1839)
                    .drawRect(0, 0, 312, 312)
                    .endFill()
            }else{
                notificationdata.bgImg = new PIXI.Graphics()
                    .beginFill(0x7BBB36)
                    .drawRect(0, 0, 312, 312)
                    .endFill()
            }

        }
        array.push(notificationdata);
        var j = 0;
        for (var i = 0; i < launcherData.length; i++) {
            var data = { };

            if (launcherData[i].cmd == null || launcherData[i].cmd == undefined) {
                continue;
            }

            if (launcherData[i].cmd == LauncherCMD.APP) {
                var noneFlg = true;
                    for (j = 0; j < launcher.allAppsData.urls.length; j++) {
                        if (launcher.allAppsData.urls[j] == launcherData[i].url) {
                            if (!launcher.allAppsData.Installer[j]) {
                                continue;
                            }
                            noneFlg = false;
                            break;
                        }
                    }

                if (!noneFlg) {
                        if (launcherData[i].url == "netflix") {
                            data = {
                                bgImg: new PIXI.Graphics()
                                    .beginFill(0xEEEEEE)
                                    .drawRect(0, 0, 312, 312)
                                    .endFill(),
                                bgImg2: launcher.allAppsData.appimgs[j],
                                lockImg: "launcher/mask_luancher_input_children_lock.png",
                                voiceStr : launcher.allAppsData.txts[j],
                                name: launcher.allAppsData.txts[j]
                            };
                        } else if (launcherData[i].url == "youtube") {
                            data = {
                                bgImg: new PIXI.Graphics()
                                    .beginFill(0xCD201F)
                                    .drawRect(0, 0, 312, 312)
                                    .endFill(),
                                bgImg2: launcher.allAppsData.appimgs[j],
                                lockImg: "launcher/mask_luancher_input_children_lock.png",
                                voiceStr : launcher.allAppsData.txts[j],
                                name: launcher.allAppsData.txts[j]
                            };
                        } else if (launcherData[i].url == "amazonruby") {
                            data = {
                                bgImg: new PIXI.Graphics()
                                    .beginFill(0xCCCCCC)
                                    .drawRect(0, 0, 312, 312)
                                    .endFill(),
                                bgImg2: launcher.allAppsData.appimgs[j],
                                lockImg: "launcher/mask_luancher_input_children_lock.png",
                                voiceStr : launcher.allAppsData.txts[j],
                                name: launcher.allAppsData.txts[j]
                            };
                        } else if (launcherData[i].url == "vudu") {
                            data = {
                                bgImg: new PIXI.Graphics()
                                    .beginFill(0x007DC2)
                                    .drawRect(0, 0, 312, 312)
                                    .endFill(),
                                bgImg2: launcher.allAppsData.appimgs[j],
                                lockImg: "launcher/mask_luancher_input_children_lock.png",
                                voiceStr : launcher.allAppsData.txts[j],
                                name: launcher.allAppsData.txts[j]
                            };
                        } else {
                            if (!!launcher.allAppsData.Installer[j]) {
                                data = {
                                    bgImg : new PIXI.Graphics()
                                    .beginFill(0x222222)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                bgImg2: launcher.allAppsData.appimgs[j],
                                lockImg: "launcher/mask_luancher_input_children_lock.png",
                                voiceStr : launcher.allAppsData.txts[j],
                                name: launcher.allAppsData.txts[j]
                                };
                            }
                            else{
                                continue;
                            }
                        }
                        data.template = "launcher_tile_1";
                        data.obj = {
                            appimg: launcher.allAppsData.appimgs[j],
                            canMove: launcher.allAppsData.canMoves[j],
                            canRemove: launcher.allAppsData.canRemoves[j],
                            img: launcher.allAppsData.imgs[j],
                            storeType: launcher.allAppsData.storeTypes[j],
                            txt: launcher.allAppsData.txts[j],
                            urlType: launcher.allAppsData.urlTypes[j],
                            url: launcher.allAppsData.urls[j],
                            locked: launcher.allAppsData.Locked[j],
                            appId:launcher.allAppsData.appId[j],
                            from :launcher.allAppsData.from[j]
                            //width : launcher.allAppsData.widths[j]
                        };
                        if (data.obj && data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                            data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                        }
                        else{
                            data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                        }
                }else {
                    continue;
                }
            } else if (launcherData[i].cmd == LauncherCMD.INPUT) {
                var noneFlg = true;
                for (j = 0; j < launcher.allInputsData.length; j++) {
                    if (launcher.allInputsData[j].id && launcherData[i].id && launcher.allInputsData[j].id == launcherData[i].id) {
                        noneFlg = false;
                        break;
                    }
                }

                if (!noneFlg) {

                    data = {
                        template : "launcher_tile_5",
                        bgImg : getInputColorData(launcher.allInputsData[j].id),
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
                        iconImg : launcher.allInputsData[j].img,
                        nameTxt : launcher.allInputsData[j].name,
                        name : launcher.allInputsData[j].name,
                        obj :launcher.allInputsData[j]
                        //{
                        //    id : launcher.allInputsData[j].id,
                        //    img : launcher.allInputsData[j].img,
                        //    //lock : launcher.allInputsData[j].lock,
                        //    locked : launcher.allInputsData[j].locked,
                        //    name : launcher.allInputsData[j].name,
                        //    rename : launcher.allInputsData[j].rename,
                        //    signal : launcher.allInputsData[j].signal,
                        //    uid : launcher.allInputsData[j].uid
                        //}
                    };
                    if (launcher.allInputsData[j].rename && launcher.allInputsData[j].rename != "") {
                        data.nameTxt = launcher.allInputsData[j].rename;
                        data.voiceStr = launcher.allInputsData[j].rename;
                    }
                    if(GLOBAL.LAUNCHER_BRAND == "shp"){
                        data.template = "launcher_tile_5_shp";
                        data.activeImg = "launcher/inputs/shp/la_ic_input_active.png";
                        data.bgImg = {color : "0x282425"};
                    }
                    else{
                        data.template = "launcher_tile_5";
                        if(GLOBAL.UI_BRAND == "tos"){
                            data.bgImg = {color : "0x0F1839"};
                        }else{
                            data.bgImg = getInputColorData(launcher.allInputsData[j].id);
                        }

                    }
                    if (data.obj && data.obj.locked && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH){
                        data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                    }
                    else{
                        data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                    }
                } else {
                    continue;
                }

            } else if (launcherData[i].cmd == LauncherCMD.CHANNEL) {

                var noneFlg = true;
                for (j = 0; j < launcher.allChannelData.length; j++) {
                    if (launcherData[i].data.uid == launcher.allChannelData[j].uid
                     && launcherData[i].data.number == launcher.allChannelData[j].number) {
                        noneFlg = false;
                        break;
                    }
                }
                if (!noneFlg) {
                    data = {
                        template : "launcher_tile_2",
                        bgImg : getUserTileGraphic(CONST.USERTILE[launcherData[i].color]),
                        iconImg : "launcher/la_ic_tuner_active.png",
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
                        nameTxt1 : launcher.allChannelData[j].number,
                        nameTxt2 : launcher.allChannelData[j].name,
                        name : launcher.allChannelData[j].number + launcher.allChannelData[j].uid,
                        voiceStr : launcher.allChannelData[j].number,
                        obj : launcher.allChannelData[j],
                        number : j,
                        color : launcherData[i].color

                        //{
                        //    //attr: launcher.allChannelData[prop][j].attr,
                        //    //favType: launcher.allChannelData[prop][j].favType,
                        //    //isEncrypt: launcher.allChannelData[prop][j].isEncrypt,
                        //    //isHidden: launcher.allChannelData[prop][j].isHidden,
                        //    isLock: launcher.allChannelData[prop][j].isLock,
                        //    isSkip: launcher.allChannelData[prop][j].isSkip,
                        //    //isVisible: launcher.allChannelData[prop][j].isVisible,
                        //    //listUid: launcher.allChannelData[prop][j].listUid,
                        //    name: launcher.allChannelData[prop][j].name,
                        //    number: launcher.allChannelData[prop][j].number,
                        //    //oriIndex: launcher.allChannelData[prop][j].oriIndex,
                        //    //playId: launcher.allChannelData[prop][j].playId,
                        //    //program: launcher.allChannelData[prop][j].program,
                        //    //satId: launcher.allChannelData[prop][j].satId,
                        //    //serviceType:launcher.allChannelData[prop][j].serviceType,
                        //    type: launcher.allChannelData[prop][j].type,
                        //    uid: launcher.allChannelData[prop][j].uid
                        //    //updateTime: launcher.allChannelData[prop][j].updateTime
                        //}
                    };
                    if(GLOBAL.LAUNCHER_BRAND == "shp"){
                        data.bgImg = {color : "0x282425"};
                    }
                    else{
                        if(GLOBAL.UI_BRAND == "tos"){
                            data.bgImg = {color : "0x0F1839"};
                        }else{
                            data.bgImg = getUserTileGraphic(CONST.USERTILE[launcherData[i].color]);
                        }
                    }
                    if (data.obj && data.obj.isLock && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH){
                        data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                    }
                    else{
                        data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                    }
                } else {
                    continue;
                }
            } else if (launcherData[i].cmd == LauncherCMD.LIVETV) {
                data = {
                    bgImg : {color : 0x23A1DB},
                    iconImg : launcherData[i].Icon,
                    nameTxt : launcherData[i].Name,
                    name : "livetv",
                    noRemove : true
                };
                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg = new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = {color : "0x23A1DB"};
                    }
                }
            } else if (launcherData[i].cmd == LauncherCMD.ALLAPP) {
                data = {
                    bgImg : {color : 0x0DAF56},
                    iconImg : launcherData[i].Icon,
                    nameTxt : launcherData[i].Name,
                    name : "allapps",
                    noRemove : true
                };
                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg = new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = {color : "0x0DAF56"};
                    }
                }
            } else if (launcherData[i].cmd == LauncherCMD.ALLINPUTS) {
                data = {
                    bgImg : {color : 0x117DE4},
                    iconImg : launcherData[i].Icon,
                    nameTxt : launcherData[i].Name,
                    name : "allinputs",
                    noRemove : true
                };
                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg =  new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = {color : "0x117DE4"};
                    }
                }
            } else if (launcherData[i].cmd == LauncherCMD.HIMEDIA) {
                data = {
                    bgImg : {color : 0x3D51C3},
                    iconImg : launcherData[i].Icon,
                    nameTxt : launcherData[i].Name,
                    name : "hiMedia",
                    noRemove : true
                };
                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg =  new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = {color : "0x3D51C3"};
                    }
                }
            } else if (launcherData[i].cmd == LauncherCMD.SETTINGS) {
                data = {
                    bgImg : {color : 0x7E20D5},
                    iconImg : launcherData[i].Icon,
                    nameTxt : launcherData[i].Name,
                    name : "setting",
                    noRemove : true
                };
		  if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg =  new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = {color : "0x7E20D5"};
                    }
                }
            } else if (launcherData[i].cmd == LauncherCMD.FVP) {
                data = {
                    template : "launcher_tile_3",
                    img1 : {color : 0xFFFFFF},
                    img2 : launcherData[i].Icon,
                    noRemove : true
                };
            }
            else if (launcherData[i].cmd == LauncherCMD.BROWSER) {
                data = {
                    template : "launcher_tile_3",
                    img1 : {color : "#EEEEEE"},
                    name : launcherData[i].Name + i,
                    img2 : launcherData[i].Icon,
                    obj:launcherData[i].data
                };
            }else if (launcherData[i].cmd == LauncherCMD.YOUTUBE_VIDEO){
                data = {
                    template : "launcher_tile_3",
                    img1 : {color : "#EEEEEE"},
                    name : launcherData[i].Name + i,
                    img2 : launcherData[i].Icon,
                    obj:launcherData[i].data,
                    noRemove : true
                };
            }
	      else{
                continue;
            }
             data.cmd = launcherData[i].cmd;
             data.Icon = launcherData[i].Icon;
             data.Name = launcherData[i].Name;

            array.push(data);
        }
        //data = {
        //    template : "launcher_tile_4",
        //    bgImg : {color : "0x161e4a"},
        //    iconImg : "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_edit.png",
        //    nameTxt : "[SE2727]",
        //    name : "edit",
        //    noMove : true,
        //    noRemove : true
        //};
        //if(GLOBAL.LAUNCHER_BRAND == "shp"){
        //    data.bgImg =  new PIXI.Graphics()
        //        .beginFill(0x403F41)
        //        .drawRect(0, 0, 312, 312)
        //        .endFill()
        //}
        //else{
        //    data.bgImg = {color : "0x161e4a"};
        //}
        //array.push(data);
        //data = {
        //    template : "launcher_tile_4",
        //    bgImg : {color : "0x161e4a"},
        //    iconImg : "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_reset.png",
        //    nameTxt : "[SE1884]",
        //    name : "reset",
        //    noMove : true,
        //    noRemove : true
        //};
        //if(GLOBAL.LAUNCHER_BRAND == "shp"){
        //    data.bgImg =  new PIXI.Graphics()
        //        .beginFill(0x403F41)
        //        .drawRect(0, 0, 312, 312)
        //        .endFill()
        //}
        //else{
        //    data.bgImg = {color : "0x161e4a"};
        //}
        //array.push(data);

        var info = {
            template : "launcher_tile_4",
            direction : CONST.GIRD_DIRECTION.V,
            breakNum : 1,
            distanceX : 0,
            distanceY : 0,
            container : launcherTiles
        };
        Gird.create(array, info);
	  //for (var i = 0; i < launcherTiles.initSequence.length; i++) {
       //     if (launcherTiles.initSequence[i].data.cmd != LauncherCMD.APP ) {
       //         continue;
       //     }
       //   if(launcherTiles.initSequence[i].data.obj.url == "netflix" || launcherTiles.initSequence[i].data.obj.url == "youtube" || launcherTiles.initSequence[i].data.obj.url == "amazonruby" || launcherTiles.initSequence[i].data.obj.url == "vudu"){
       //       var nameTxt = UI.getItem(launcherTiles.initSequence[i],"nameTxt");
       //       if(!!nameTxt){
       //           nameTxt.alpha = 0;
       //       }
       //   }
       // }
        if(GLOBAL.LAUNCHER_BRAND == "shp"){
            for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                if (launcherTiles.initSequence[i].data.cmd != LauncherCMD.INPUT ) {
                    continue;
                }
                var activeImg = UI.getItem(launcherTiles.initSequence[i], "activeImg");
                if (activeImg) {
                    activeImg.alpha = 0;
                }
            }
        }
        var tileArray = getCurrTileArray();
        setRememberEditAppToNativeFile(tileArray);
    }

    function refreshInputTiles() {
        inputTiles.removeAllChildren();
        var array = [];
        flg = false;
        var i = 0;
        outerLoop:
            for (i = 0; i < launcher.allInputsData.length; i++) {
                if(launcher.allInputsData[i].id == 200){
                    continue;
                }
                for (var j = 0; j < launcherTiles.initSequence.length; j++) {
                    if (launcherTiles.initSequence[j].data.cmd != LauncherCMD.INPUT) {
                        continue;
                    }
                    if (launcherTiles.initSequence[j].data.obj.id == launcher.allInputsData[i].id) {
                        flg = true;
                        continue outerLoop;
                    }
                }

                //var tileArray = getCurrTileArray();
                //setRememberEditAppToNativeFile(tileArray);

                var data = {
                    iconImg : launcher.allInputsData[i].img,
                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                    name : "input" + launcher.allInputsData[i].name,
                    obj : launcher.allInputsData[i],
                    voiceStr :"[SE3151]" + launcher.allInputsData[i].name,
                    cmd : LauncherCMD.INPUT
                };

                if (data.obj && data.obj.locked && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH){
                    data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                }
                else{
                    data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                }
                    if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.activeImg = "launcher/inputs/shp/la_ic_input_active.png";
                    data.bgImg = new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = getInputColorData(launcher.allInputsData[i].id);
                    }
                }
                if (launcher.allInputsData[i].rename && launcher.allInputsData[i].rename != "") {
                    data.nameTxt = launcher.allInputsData[i].rename;
                    data.voiceStr = "[SE3151]" + launcher.allInputsData[i].rename;
                } else {
                    data.nameTxt = launcher.allInputsData[i].name;
                }

                array.push(data);
            }

        if (array.length == 0) {
            array.push({
                template : "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/title/inputs.png",
                name : "msg",
                noneTxt : "[SE3160]",
                flag : true
            });
            inputTiles.viewRect = null;
        } else {
            inputTiles.viewRect  = inputTiles.initViewRect;
        }

        info = {
            template : "launcher_tile_5",
            direction : CONST.GIRD_DIRECTION.H,
            distance : 0,
            pageCount : 7,
            container : inputTiles
        };
        if(GLOBAL.LAUNCHER_BRAND == "shp"){
            info.template = "launcher_tile_5_shp";
        }
        else{
            info.template = "launcher_tile_5";
        }
        BigList.create(array, info);
        
        if(GLOBAL.LAUNCHER_BRAND == "shp"){
            for (var i = 0; i < inputTiles.initSequence.length; i++) {
                  var activeImg = UI.getItem(inputTiles.initSequence[i], "activeImg");
                    if (activeImg) {
                        activeImg.alpha = 0;
                    }
            }
        }
        if (!inputTiles.data[0].obj) {
            inputTiles.x = inputTiles.x - 200;
            inputTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
        }
    }

    function refreshAppTiles(launcherData) {

        appTiles.removeAllChildren();
        var array = [];
        flg = false;
        outerLoop:
            for (var i = 0; i < launcher.allAppsData.appimgs.length; i++) {
                if (!launcher.allAppsData.Installer[i]) {
                    continue outerLoop;
                }
                for (var j = 0; j < launcherTiles.initSequence.length; j++) {
                    if (launcherTiles.initSequence[j].data.cmd != LauncherCMD.APP) {
                        continue;
                    }
                    if (launcherTiles.initSequence[j].data.obj.url == launcher.allAppsData.urls[i]) {
                        flg = true;
                        continue outerLoop;
                    }
                }

                var data = null;
                if (launcher.allAppsData.urls[i] == "netflix") {
                    data = {
                        bgImg : new PIXI.Graphics()
                            .beginFill(0xEEEEEE)
                            .drawRect(0, 0, 312, 312)
                            .endFill(),
                        bgImg2 : launcher.allAppsData.appimgs[i],
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
			            voiceStr :"[SE3150]" + launcher.allAppsData.txts[i],
                        name : launcher.allAppsData.txts[i]
                    };
                } else if (launcher.allAppsData.urls[i] == "youtube") {
                    data = {
                        bgImg : new PIXI.Graphics()
                            .beginFill(0xCD201F)
                            .drawRect(0, 0, 312, 312)
                            .endFill(),
                        bgImg2 : launcher.allAppsData.appimgs[i],
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
			            voiceStr :"[SE3150]" + launcher.allAppsData.txts[i],
                        name : launcher.allAppsData.txts[i]
                    };
                } else if (launcher.allAppsData.urls[i] == "amazon") {
                    data = {
                        bgImg : new PIXI.Graphics()
                            .beginFill(0xCCCCCC)
                            .drawRect(0, 0, 312, 312)
                            .endFill(),
                        bgImg2 : launcher.allAppsData.appimgs[i],
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
			            voiceStr :"[SE3150]" + launcher.allAppsData.txts[i],
                        name : launcher.allAppsData.txts[i]
                    };
                } else if (launcher.allAppsData.urls[i] == "vudu") {
                    data = {
                        bgImg : new PIXI.Graphics()
                            .beginFill(0x007DC2)
                            .drawRect(0, 0, 312, 312)
                            .endFill(),
                        bgImg2 : launcher.allAppsData.appimgs[i],
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
			            voiceStr :"[SE3150]" + launcher.allAppsData.txts[i],
                        name : launcher.allAppsData.txts[i]
                    };
                } else {
                    data = {
                        bgImg : new PIXI.Graphics()
                            .beginFill(0x222222)
                            .drawRect(0, 0, 312, 312)
                            .endFill(),
                        bgImg2 : launcher.allAppsData.appimgs[i],
                        lockImg : "launcher/mask_luancher_input_children_lock.png",
                        voiceStr :"[SE3150]" + launcher.allAppsData.txts[i],
                        name : launcher.allAppsData.txts[i]
                    };
                }

                data.obj = {
                    appimg : launcher.allAppsData.appimgs[i],
                    locked : launcher.allAppsData.Locked[i],
                    canMove : launcher.allAppsData.canMoves[i],
                    canRemove : launcher.allAppsData.canRemoves[i],
                    img : launcher.allAppsData.imgs[i],
                    storeType : launcher.allAppsData.storeTypes[i],
                    txt : launcher.allAppsData.txts[i],
                    urlType : launcher.allAppsData.urlTypes[i],
                    url : launcher.allAppsData.urls[i],
                    appId:launcher.allAppsData.appId[i],
                    from :launcher.allAppsData.from[i]
                    //width : launcher.allAppsData.widths[i]
                };
                if (data.obj && data.obj.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                    data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                }
                else{
                    data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                }
                data.cmd = LauncherCMD.APP;
                array.push(data);
            }

        if (array.length == 0) {
            array.push({
                template: "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/title/apps.png",
                noneTxt: "[SE3159]",
                name: "msg",
                flag: true
            });
            appTiles.viewRect = null;
        } else {
            appTiles.viewRect  = appTiles.initViewRect;
        }
        var info = {
            template : "launcher_tile_1",
            direction : CONST.GIRD_DIRECTION.H,
            distance : 0,
            pageCount : 7,
            container : appTiles
        };

        BigList.create(array, info);
        //for (var l = 0; l < appTiles.initSequence.length; l++) {
        //    if(appTiles.initSequence[l].data.obj.url == "netflix" || appTiles.initSequence[l].data.obj.url == "youtube" || appTiles.initSequence[l].data.obj.url == "amazonruby" || appTiles.initSequence[l].data.obj.url == "vudu"){
        //        var nameTxt = UI.getItem(appTiles.initSequence[l],"nameTxt");
        //        if(!!nameTxt){
        //            nameTxt.alpha = 0;
        //        }
        //    }
        //}
        if (!appTiles.data[0].obj) {
            appTiles.x = appTiles.x - 200;
            appTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
        }
    }

    var flg = false;
    function refreshChannelTiles(launcherData) {

        channelTiles.removeAllChildren();
        var array = [];
        var k = 0;
        flg = false;
        outerLoop:
            for (i = 0; i < launcher.allChannelData.length; i++) {
                for (j = 0; j < launcherTiles.initSequence.length; j++) {
                    if (launcherTiles.initSequence[j].data.cmd != LauncherCMD.CHANNEL) {
                        continue;
                    }
                    if (launcherTiles.initSequence[j].data.obj.uid == launcher.allChannelData[i].uid
                        && launcherTiles.initSequence[j].data.obj.listUid == launcher.allChannelData[i].listUid) {
                        flg = true;
                        continue outerLoop;
                    }
                    //s.initSequence[j].data.obj = launcher.allChannelData[i];
                }
                data = {
                    bgImg : getUserTileGraphic(CONST.USERTILE[launcher.getUserTileNum()]),
                    iconImg : "launcher/la_ic_tuner_active.png",
                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                    nameTxt1 : launcher.allChannelData[i].number,
                    nameTxt2 : launcher.allChannelData[i].name,
                    voiceStr :"[SE3149]" + launcher.allChannelData[i].number,
                    name : launcher.allChannelData[i].number + launcher.allChannelData[i].uid,
                    cmd : LauncherCMD.CHANNEL
                };
                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                    data.bgImg = new PIXI.Graphics()
                        .beginFill(0x403F41)
                        .drawRect(0, 0, 312, 312)
                        .endFill()
                }
                else{
                    if(GLOBAL.UI_BRAND == "tos"){
                        data.bgImg = {color : "0x0F1839"};
                    }else{
                        data.bgImg = getUserTileGraphic(CONST.USERTILE[launcher.getUserTileNum()]);
                    }
                }
                data.obj = launcher.allChannelData[i];
                data.cmd = LauncherCMD.CHANNEL;
                data.number = i;
                data.color = launcher.getUserTileNum();
                if (data.obj && data.obj.isLock && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH){
                    data.lockImg = "launcher/mask_luancher_input_children_lock.png";
                }
                else{
                    data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                }
                array.push(data);
                k++;
            }

        if (array.length == 0) {
            var data = {
                template : "launcher_tile_msg",
                bgImg: {color:0xffffff},
                noneImg:"launcher/la_ic_tuner_active.png",
                name : "msg",
                noneTxt : "[SE3161]",
                voiceStr :"[SE3149]" + "[SE3161]",
                flag : true,
                cmd : LauncherCMD.CHANNEL
            };
            array.push(data);
            channelTiles.viewRect = null;
        } else {
            channelTiles.viewRect  = channelTiles.initViewRect;
        }

        var info = {
            template : "launcher_tile_2",
            direction : CONST.GIRD_DIRECTION.H,
            distance : 0,
            pageCount : 7,
            container : channelTiles
        };
        BigList.create(array, info);
   /*     if (!channelTiles.initSequence[0].data.obj) {
            var noneTxt = UI.getItem(channelTiles.initSequence[0], "noneTxt");
            if (flg) {
                UI.setText(noneTxt, "[SE3161]");
            } else {
                UI.setText(noneTxt, "[OT0031]");
            }
        }*/

        if (!channelTiles.data[0].obj) {
            var noneTxt = UI.getItem(channelTiles.initSequence[0], "noneTxt");
            if (flg) {
                UI.setText(noneTxt, "[SE3161]");
                channelTiles.data[0].voiceStr ="[SE3149]" + "[SE3161]";
                channelTiles.children[0].data.voiceStr ="[SE3149]" + "[SE3161]";
            } else {
                UI.setText(noneTxt, "[OT0031]");
                channelTiles.data[0].voiceStr ="[SE3149]" + "[OT0031]";
                channelTiles.children[0].data.voiceStr ="[SE3149]" + "[OT0031]";
            }
            channelTiles.x = channelTiles.x - 200;
            bansearchchannel();
        }
    }

    function refreshJumpTiles(launcherData) {
        JumpTiles.removeAllChildren();
        if(channelTiles.initSequence.length <= 1){
            return;
        }
        var array = [];
        var data = null;
        var filterList = [];
        var filterflag = null;
        var nameTxt;
        flg = false;
        var storage=window.localStorage;
        launcher.currFileterSelect = storage.currFileterSelect;
        if(!launcher.currFileterSelect){
            launcher.currFileterSelect = "ABC";
        }
        if(launcher.currFileterSelect != "ABC"){
            arraySymbol = [];
            if(channelTiles.data.length <= 500 && channelTiles.data.length > 0){
                for (var i = 0; i < channelTiles.data.length/50; i++) {
                    arraySymbol[i] = 50*i + "";
                    arraySymbol[i + 1] = 50*(i + 1) + "";
                }
            }else if(channelTiles.data.length <= 2500 && channelTiles.data.length > 500){
                for (var i = 0; i < channelTiles.data.length/100; i++) {
                    arraySymbol[i] = 100*i;
                    arraySymbol[i + 1] = 100*(i + 1) + "";
                }
            }else{
                for (var i = 0; i < channelTiles.data.length/200; i++) {
                    arraySymbol[i] = 200*i;
                    arraySymbol[i + 1] = 200*(i + 1) + "";
                }
            }
        }else{
            arraySymbol = [
                "A", "B", "C", "D", "E", "F",
                "G", "H", "I", "J", "K", "L",
                "M", "N", "O", "P", "Q", "R",
                "S", "T", "U", "V", "W", "X",
                "Y", "Z"
            ];
        }
        array.push({
            template : "launcher_filter_select",
            bgImg : getUserTileGraphic(0x2F344D),
            iconImg : "launcher/la_ic_button_dialog.png",
            nameTxt : launcher.currFileterSelect,
            name : "filter"
        });
            for (var i = 0; i < arraySymbol.length; i++) {
                if(launcher.currFileterSelect != "ABC"){
                    filterList = filtListByName(arraySymbol[i],false);
                    if(!!arraySymbol[i + 1]){
                     nameTxt = arraySymbol[i] + "-" + (parseInt(arraySymbol[i+1]) - 1 + "");
                    }else{
                        break;
                    }
                }else{
                    filterList = filtListByName(arraySymbol[i],true);
                    nameTxt = arraySymbol[i];
                }
                if(filterList.length == 0){
                    filterflag = false;
                }else{
                    filterflag = channelTiles.data.indexOf(filterList[0]) + 1;
                }
                data = {
                    bgImg : getUserTileGraphic(0x000000),
                    nameTxt : nameTxt,
                    name : "jump" + i,
                    filterflag : filterflag
                };
                array.push(data);
            }


        var info = {
            template : "launcher_filter",
            direction : CONST.GIRD_DIRECTION.H,
            distance : 0,
            pageCount : 26,
            container : JumpTiles
        };
        BigList.create(array, info,true);
        var originwidth;
        if(launcher.currFileterSelect == "ABC"){
            originwidth = UI.getItem(JumpTiles.initSequence[1],"nameTxt").width + 48;
        }else{
            originwidth = UI.getItem(JumpTiles.initSequence[1],"nameTxt").width * 2.5;
        }
        for (i = 1; i < JumpTiles.initSequence.length; i++) {
            var bgImg = UI.getItem(JumpTiles.initSequence[i],"bgImg");
            bgImg.alpha = 0.05;
            var width = bgImg.width;
            bgImg.width = originwidth;
            JumpTiles.initSequence[i].x = JumpTiles.initSequence[i].x - (width - bgImg.width)*(i-1) - (width - bgImg.width)/2;
            if(!JumpTiles.initSequence[i].data.filterflag){
                JumpTiles.initSequence[i].disable = true;
                JumpTiles.initSequence[i].alpha = 0.3;
            }
        }

    }

    function filtListByName(str,name) {
        if (str === "") return channelTiles.initSequence;
        var strLowerCase = str.toLocaleLowerCase();
        if(!!name){
            return channelTiles.data.filter(function (v) {
                return (v.nameTxt2.toLocaleLowerCase().indexOf(strLowerCase) == 0);
            });
        }else{
            return channelTiles.data.filter(function (v) {
                return (v.nameTxt1.toLocaleLowerCase().indexOf(strLowerCase) == 0);
            });
        }
    }

    function onNoneChannelEnter() {
        var currSource = tv?getCurrentSourceId():0;
        if((currSource !=0) || (appControl.getCurrentAPPName() != APPNAME.EPOS && checkIsAppOn())||GLOBAL.MEDIA_STARTUP_FLAG){
            UI.showSimpleTip("[SE3262]");
        }else {
            launcher.popSelf(false);
            launcher.searched = true;
            openChAutoScanPage();
        }
    }

    function getCurrTileArray() {
        var tileArray = [];
        for (var i = 1; i < launcherTiles.initSequence.length; i++) {
            var tile = launcherTiles.initSequence[i];
            var data;
            if (tile.data.cmd == LauncherCMD.INPUT) {
                data = {
                    Name : tile.data.obj.name,
                    Icon : tile.data.obj.img,
                    id : tile.data.obj.id
                };
            } else if (tile.data.cmd == LauncherCMD.APP) {
                data = {
                    Name : tile.data.obj.txt,
                    Icon : tile.data.obj.appimg,
                    url : tile.data.obj.url
                };
            } else if (tile.data.cmd == LauncherCMD.CHANNEL){
                data = {
                    Name : tile.data.obj.name,
                    Icon : "la_ic_tv_active",
                    uid : tile.data.obj.uid,
                    listUid : tile.data.obj.listUid,
                    SvlRecID : tile.data.obj.SvlRecID,
                    color : tile.data.color
                };
            } else {
                data = {
                    Icon : tile.data.Icon,
                    Name : tile.data.Name
                };
            }
            data.cmd = tile.data.cmd;
            if (tile.data.cmd == LauncherCMD.ALLAPP) {
                data.data = {};
            } else {
                data.data = tile.data.obj;
            }
            tileArray.push(data);
        }
        return tileArray;
    }

    mainTiles.getCurrTileArray = function() {
        var tileArray = [];
        for (var i = 1; i < launcherTiles.initSequence.length - 2; i++) {
            var tile = launcherTiles.initSequence[i];
            var data;
            if (tile.data.cmd == LauncherCMD.INPUT) {
                data = {
                    Name : tile.data.obj.name,
                    Icon : tile.data.obj.img,
                    id : tile.data.obj.id
                };
            } else if (tile.data.cmd == LauncherCMD.APP) {
                data = {
                    Name : tile.data.obj.txt,
                    Icon : tile.data.obj.appimg,
                    url : tile.data.obj.url
                };
            } else if (tile.data.cmd == LauncherCMD.CHANNEL){
                data = {
                    Name : tile.data.obj.name,
                    Icon : "la_ic_tv_active",
                    uid : tile.data.obj.uid,
                    SvlRecID : tile.data.obj.SvlRecID
                };
            } else {
                data = {
                    Icon : tile.data.Icon,
                    Name : tile.data.Name
                };
            }
            data.cmd = tile.data.cmd;
            if (tile.data.cmd == LauncherCMD.ALLAPP) {
                data.data = {};
            } else {
                data.data = tile.data.obj;
            }
            tileArray.push(data);
        }
        return tileArray;
    };

    function getAllObjects() {
       // edit = UI.getItem(launcherTiles, "edit");
        apps = UI.getItem(launcherTiles, "allapps");
        setting = UI.getItem(launcherTiles, "setting");
        inputs = UI.getItem(launcherTiles, "allinputs");
        media = UI.getItem(launcherTiles, "hiMedia");
        notification = UI.getItem(launcherTiles, "notification");
       // reset = UI.getItem(launcherTiles, "reset");
        livetv = UI.getItem(launcherTiles, "livetv");
    }

    function doForNetflix(mode, focus) {
        //if (checkIsAppOn("netflix")) {
        //    switch(mode) {
        //        case "launchMode" :
        //            launcher.addSpecificShadow(launcherTiles.initSequence);
        //            launcher.addSpecificShadow(inputTiles.initSequence);
        //            launcher.addSpecificShadow(appTiles.initSequence);
        //            launcher.addSpecificShadow(channelTiles.initSequence);
        //            break;
        //        case "editMode" :
        //            launcher.addRoundShadow(launcherTiles.initSequence);
        //            break;
        //        case "moveMode" :
        //            launcher.addShadow(focus, "assets/ThemeDefault/launcher/shadow_round.png");
        //            break;
        //        case "removeMode" :
        //            launcher.addSpecificShadow(inputTiles.initSequence);
        //            launcher.addSpecificShadow(appTiles.initSequence);
        //            launcher.addSpecificShadow(channelTiles.initSequence);
        //            break;
        //    }
        //} else {
        //    if (launcherTiles.initSequence[0].children[0].name == "shadow") {
        //        launcher.removeShadow(launcherTiles.initSequence);
        //        launcher.removeShadow(inputTiles.initSequence);
        //        launcher.removeShadow(appTiles.initSequence);
        //        launcher.removeShadow(channelTiles.initSequence);
        //    }
        //}
    }

    function addToLauncher(from, destTile) {
        //helpInfo = UI.getSubModule("helpInfo");
        //if(!helpInfo){
        //    UI.pushSubModule("launcher", "helpInfo");
        //    launcher.removeChild(mainTiles);
        //    launcher.addChild(mainTiles);
        //    helpInfo = UI.getSubModule("helpInfo");
        //}
        if (launcher.Adtarget && launcherTiles.initSequence.length >= CONST.LAUNCHER_MAXTILES) {
           // var statusBar1 = UI.getSubModule("statusBar");
            var msgPanel = UI.getItem(statusBar, "msgPanel");
            var msgTxt = UI.getItem(msgPanel, "msgTxt");
            var bgImg = UI.getItem(msgPanel, "bgImg");
            bgImg.doFlip = true;
            UI.setText(msgTxt, "[SE3162]");
            UI.callTTS("[SE3162]");
            UI.getTween(msgPanel).to({alpha:1}, 400).wait(3000).to({alpha:0}, 400);
            mainTiles.toLaunchMode();
            UI.focusTo(launcherTiles.lastFocus);
            initVisible(UI.getCurrFocus() , launcherTiles, 3, 6);
            return;
        }
       // var statusBar1 = UI.getSubModule("statusBar");
      //  UI.getTween(statusBar).to({alpha:0}, 400)
      ////  UI.getTween(helpInfo).to({alpha:1}, 400)
      //      .call(UI.activeKey);

        if (launcher.Adtarget) {
            var data = null;
            var index = 0;
                for (i = 0; i < launcherTiles.initSequence.length; i++) {
                    if (launcherTiles.initSequence[i].name == destTile.name) {
                        index = i + 1;
                        break;
                    }
                }

                if (from == "allApps" ||((from == "statusBar") && GLOBAL.LAUNCHER_INFO_EVENT == "ADDAPP")) {
                    for (var i = 0; i < launcher.allAppsData.appimgs.length; i++) {
                        if (launcher.Adtarget.data.url ==  launcher.allAppsData.urls[i]) {
                            if (launcher.allAppsData.urls[i] == "netflix") {
                                data = {
                                    template : "launcher_tile_1",
                                    bgImg : new PIXI.Graphics()
                                        .beginFill(0xEEEEEE)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                    bgImg2 : launcher.allAppsData.appimgs[i],
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    name : launcher.allAppsData.txts[i],
                                    voiceStr : launcher.allAppsData.txts[i],
                                    url : launcher.allAppsData.urls[i],
                                    cmd : LauncherCMD.APP
                                };
                            } else if (launcher.allAppsData.urls[i] == "youtube") {
                                data = {
                                    template : "launcher_tile_1",
                                    bgImg : new PIXI.Graphics()
                                        .beginFill(0xCD201F)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                    bgImg2 : launcher.allAppsData.appimgs[i],
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    name : launcher.allAppsData.txts[i],
                                    voiceStr : launcher.allAppsData.txts[i],
                                    url : launcher.allAppsData.urls[i],
                                    cmd : LauncherCMD.APP
                                };
                            } else if (launcher.allAppsData.urls[i] == "amazonruby") {
                                data = {
                                    template : "launcher_tile_1",
                                    bgImg : new PIXI.Graphics()
                                        .beginFill(0xCCCCCC)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                    bgImg2 : launcher.allAppsData.appimgs[i],
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    name : launcher.allAppsData.txts[i],
                                    voiceStr : launcher.allAppsData.txts[i],
                                    url : launcher.allAppsData.urls[i],
                                    cmd : LauncherCMD.APP
                                };
                            } else if (launcher.allAppsData.urls[i] == "vudu") {
                                data = {
                                    template : "launcher_tile_1",
                                    bgImg : new PIXI.Graphics()
                                        .beginFill(0x007DC2)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                    bgImg2 : launcher.allAppsData.appimgs[i],
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    name : launcher.allAppsData.txts[i],
                                    voiceStr : launcher.allAppsData.txts[i],
                                    url : launcher.allAppsData.urls[i],
                                    cmd : LauncherCMD.APP
                                };
                            } else {
                                data = {
                                    template : "launcher_tile_1",
                                    bgImg : new PIXI.Graphics()
                                        .beginFill(0x222222)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill(),
                                    bgImg2 : launcher.allAppsData.appimgs[i],
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    name : launcher.allAppsData.txts[i],
                                    voiceStr : launcher.allAppsData.txts[i],
                                    url : launcher.allAppsData.urls[i],
                                    cmd : LauncherCMD.APP
                                };
                            }
                            if(!launcher.allAppsData.Locked[i]){
                                data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                            }
                            data.obj = {
                                appimg : launcher.allAppsData.appimgs[i],
                                canMove : launcher.allAppsData.canMoves[i],
                                canRemove : launcher.allAppsData.canRemoves[i],
                                img : launcher.allAppsData.imgs[i],
                                locked : launcher.allAppsData.Locked[i],
                                storeType : launcher.allAppsData.storeTypes[i],
                                txt : launcher.allAppsData.txts[i],
                                urlType : launcher.allAppsData.urlTypes[i],
                                url : launcher.allAppsData.urls[i],
                                appId:launcher.allAppsData.appId[i],
                                from :launcher.allAppsData.from[i]
                                //width : launcher.allAppsData.widths[i]
                            };
                            break;
                        }

                    }
                    var removed = data;
                } else if (from == "allInputs" || (from == "statusBar") && GLOBAL.LAUNCHER_INFO_EVENT == "ADDINPUT") {
                    for (var i = 0; i < launcher.allInputsData.length; i++) {
                        if (launcher.Adtarget.data.obj.uid ==  launcher.allInputsData[i].uid) {
                            if(launcher.allInputsData[i].id == 200){
                                continue;
                            } else {
                                data = {
                                    template : "launcher_tile_5",
                                    iconImg : launcher.allInputsData[i].img,
                                    lockImg : "launcher/mask_luancher_input_children_lock.png",
                                    id : launcher.allInputsData[i].id,
                                    name : "input" + launcher.allInputsData[i].name,
                                    voiceStr :launcher.allInputsData[i].name,
                                    obj : launcher.allInputsData[i],
                                    cmd : LauncherCMD.INPUT
                                };
                                if (launcher.allInputsData[i].rename && launcher.allInputsData[i].rename != "") {
                                    data.nameTxt = launcher.allInputsData[i].rename;
                                    data.voiceStr = launcher.allInputsData[i].rename;
                                } else {
                                    data.nameTxt = launcher.allInputsData[i].name;
                                    data.voiceStr = launcher.allInputsData[i].name;
                                }
                                if(!launcher.allInputsData[i].locked){
                                    data.lockImg = "launcher/mask_luancher_input_children_lock2.png";
                                }
                                if(GLOBAL.LAUNCHER_BRAND == "shp"){
                                    data.activeImg = "launcher/inputs/shp/la_ic_input_active.png";
                                    data.bgImg = new PIXI.Graphics()
                                        .beginFill(0x403F41)
                                        .drawRect(0, 0, 312, 312)
                                        .endFill()
                                }else{
                                    if(GLOBAL.UI_BRAND == "tos"){
                                        data.bgImg = {color : "0x0F1839"};
                                    }else{
                                        data.bgImg = getInputColorData(launcher.allInputsData[i].id);
                                    }
                                }
                            }
                            break;
                        }

                    }
                    var removed = data;
                }
            GLOBAL.LAUNCHER_INFO_EVENT = null;
            launcher.currentData.splice(index,0,removed);
            launcherTiles.addItemAt(removed, index);
            var tileArray = getCurrTileArray();
            setRememberEditAppToNativeFile(tileArray);
            try{
                if(LogReportData.GTLauncherTitleActionAddFlag==true){
                    var tempobj={
                        type:1
                    };
                    DBG_INFO("log report TitleAction add");
                    var param=logReportADO(tempobj,tileArray,UI.getCurrFocus());
                    LGReport.GTLauncherTitleAction(param.ActionType,param.ChangeSource,param.TitleType,param.AddOrRemoveTitleName,param.TitlesNum,param.Titles);
                    LogReportData.GTLauncherTitleActionAddFlag=false;
                }
            }catch(ex){DBG_ERROR(ex.message)}
            var focus = launcherTiles.initSequence[index];
            UI.refreshView(launcherTiles, focus);
            setImgAlpha(false);
            prepareMoveMode(focus);
            toMoveMode(focus);
            UI.focusTo(focus);
        }
        setAlpha();
    }

    function shakeFocus(focus) {
        UI.inactiveKey();
        UI.getTween(focus)
            .to({x:focus.x - 10}, 133)
            .to({x:focus.x + 10}, 133)
            .to({x:focus.x}, 133)
        UI.getTween(UI.base.cursor)
            .to({x:UI.base.cursor.x - 10}, 133)
            .to({x:UI.base.cursor.x + 10}, 133)
            .to({x:UI.base.cursor.x}, 133)
        activeTimer =timerFunction(activeTimer,function(){ UI.activeKey();},700);
        //setTimeout(function() {
        //    UI.activeKey();
        //}, 700);
    }

    function onKeyUpForEditMode(focus) {
        if (prepareMoveMode(focus)) {
            toMoveMode(focus);
        }
    }

    function onkeyUpForMoveMode(focus) {
        UI.inactiveKey();
        if (focus.data.noRemove) {
            UI.inactiveKey();
            shakeFocus(focus);
            //UI.activeKey();
            return;
        }

        //UI.switchTo(focus, launcherTiles);
        if (launcherTiles.lastDirection == "right") {
            launcherTiles.initSequence.splice(launcherTiles.focusIndex + 1, 0, focus);
        } else {
            launcherTiles.initSequence.splice(launcherTiles.focusIndex, 0, focus);
        }
        Gird.resetNavigation(launcherTiles, launcherTiles.info);
        mainTiles.refreshBounds(launcherTiles);
        //var tileArray = getCurrTileArray();
        //setRememberEditAppToNativeFile(tileArray);
        launcherTiles.focusIndex = launcherTiles.initSequence.indexOf(focus);
        launcherTiles.initSequence.splice(launcherTiles.focusIndex, 1);
        var point1 = focus.parent.toGlobal(focus.position);
        var point2 = mainTiles.parent.toGlobal(mainTiles.position);
        focus.x = point1.x - point2.x;
        focus.y = point1.y - point2.y;
        mainTiles.addChild(focus);
       // mainTiles.addChild(UI.base.cursor);
        launcherTiles.xNum = 0;
        launcherTiles.movePosX = launcherTiles.x;
        launcherTiles.lastDirection = "none";
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            launcherTiles.initSequence[i].initX = launcherTiles.initSequence[i].x;
            launcherTiles.initSequence[i].leftX = launcherTiles.initSequence[i].x + launcherTiles.initSequence[i].getBounds().width + 50;
            launcherTiles.initSequence[i].rightX = launcherTiles.initSequence[i].x - launcherTiles.initSequence[i].getBounds().width - 50;
            launcherTiles.initSequence[i].directionFlg = false;
        }

        UI.getTween(deleteIcon.scale).to({x:1.2, y:1.2}, 400, UI.ease.quartOut);
        UI.getTween(upIcon).to({alpha:1}, 400);
        UI.getTween(focus.scale).to({x:1, y:1}, 400);
        UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 120, y:leftIcon.y + 50}, 400, UI.ease.quartOut);
        UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 120, y:rightIcon.y + 50}, 400, UI.ease.quartOut);
        UI.getTween(upIcon).to({alpha:1}, 400, UI.ease.quartOut)
            .call(function(focus) {
                toDeleteMode(focus);
                UI.activeKey();
            }, [focus]);
    }

    function onKeyDownForMoveMode(focus) {
        //if(!!launcher.addto) {
        //    leftIcon.initPos.x = leftIcon.initPos.x - 20;
        //    rightIcon.initPos.x = rightIcon.initPos.x + 20;
        //    launcher.addto = false;
        //}
        launcherTiles.info.distanceX = 0;
        moveIcons.alpha = 0;
        //UI.getTween(moveIcons).to({alpha:0}, 400);
        //UI.getTween(leftIcon).to({x:leftIcon.initPos.x + 100}, 400, UI.ease.quartOut);
        //UI.getTween(rightIcon).to({x:rightIcon.initPos.x - 100}, 400, UI.ease.quartOut);
        UI.inactiveKey();
        var point1 = focus.parent.toGlobal(focus.position);
        var point2 = launcherTiles.parent.toGlobal(launcherTiles.position);
        focus.x = point1.x - point2.x;
        focus.y = point1.y - point2.y;
        launcherTiles.addChild(focus);
        if (launcherTiles.lastDirection == "right") {
            launcherTiles.initSequence.splice(launcherTiles.focusIndex + 1, 0, focus);
        } else {
            launcherTiles.initSequence.splice(launcherTiles.focusIndex, 0, focus);
        }
        Gird.resetNavigation(launcherTiles, launcherTiles.info);
        //mainTiles.refreshBounds(launcherTiles);

        try{
            DBG_INFO("log report order TitleAction");
            var temparrary=getCurrTileArray();
            var tempobj={
                type:2
            };
            var param=logReportADO(tempobj,temparrary,UI.getCurrFocus());
            LGReport.GTLauncherTitleAction(param.ActionType,param.ChangeSource,param.TitleType,param.AddOrRemoveTitleName,param.TitlesNum,param.Titles);
        }catch(ex){DBG_ERROR(ex.message)}
        launcher.editRefresh = true;
        focus.y = focus.initY;
        launcherTiles.y = launcherTiles.y- 150;
        for (var i = 0; i < launcherTiles.children.length; i++) {
            launcherTiles.children[i].alpha = 1;
        }
        var j = 0;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            var target = launcherTiles.initSequence[i];
            target.x = target.x - 50 * i;
            if (target == focus) {
                j = i;
            }
        }
       // launcherTiles.x = launcherTiles.x + 50 * j;
        launcher.isEditMode = false;
        focus.onkey_LEFT = null;
        focus.onkey_RIGHT = null;
        focus.onkey_UP = null;
        focus.onkey_DOWN = null;
        focus.onkey_ENTER = null;
        var tileArray = getCurrTileArray();
        setRememberEditAppToNativeFile(tileArray);
        initVisible(focus, launcherTiles, 3, 6);
        UI.getTween(mainTiles).to({x:mainTiles.initPos.x, y:mainTiles.initPos.y}, 400, UI.ease.quartOut);
    }

    mainTiles.refreshBounds = function(target) {
        //return target.getBounds();
    };

    function initVisible(focus, gird, leftNum, rightNum) {
        if (!focus) {
            focus = gird.lastFocus;
        }
        if (!gird.initSequence) {
            return;
        }
        var index = gird.initSequence.indexOf(focus);
        for (var i = 0; i < gird.initSequence.length; i++) {
            if (i >= index - leftNum && i <= index + rightNum) {
                gird.initSequence[i].alpha = 1;
            } else {
                gird.initSequence[i].alpha = 0;
            }
        }
        gird.visibleNumLeft = leftNum;
        gird.visibleNumRight = rightNum;
    }

    function resetVisible(gird) {
        if (!gird.initSequence) {
            return;
        }
        for (var i = 0; i < gird.initSequence.length; i++) {
                gird.initSequence[i].alpha = 1;
        }
    }

    function adjustVisibleRight(target, gird) {
        if (!gird.initSequence) {
            return;
        }
        var index = gird.initSequence.indexOf(target);
        if (gird.initSequence[index + gird.visibleNumRight]) {
            gird.initSequence[index + gird.visibleNumRight].alpha = 1;
        }
        if (gird.initSequence[index - gird.visibleNumLeft]) {
            gird.initSequence[index - gird.visibleNumLeft].alpha = 0;
        }
    }

    function adjustVisibleLeft(target, gird) {
        if (!gird.initSequence) {
            return;
        }
        var index = gird.initSequence.indexOf(target);
        if (gird.initSequence[index + gird.visibleNumRight]) {
            gird.initSequence[index + gird.visibleNumRight].alpha = 0;
        }
        if (gird.initSequence[index - gird.visibleNumLeft]) {
            gird.initSequence[index - gird.visibleNumLeft].alpha = 1;
        }
    }

    function setLastFocus() {
        if (channelTiles.children[3]) {
            channelTiles.lastFocus = channelTiles.children[3];
            channelTiles.currIndex = 3;
            channelTiles.posCount = 3;
        } else {
            channelTiles.lastFocus = channelTiles.children[0];
            channelTiles.currIndex = 0;
            channelTiles.posCount = 0;
        }
        UI.refreshView(channelTiles, channelTiles.lastFocus);

        if (inputTiles.children[3]) {
            inputTiles.lastFocus = inputTiles.children[3];
            inputTiles.currIndex = 3;
            inputTiles.posCount = 3;
        } else {
            inputTiles.lastFocus = inputTiles.children[0];
            inputTiles.currIndex = 0;
            inputTiles.posCount = 0;
        }
        UI.refreshView(inputTiles, inputTiles.lastFocus);

        if (appTiles.children[3]) {
            appTiles.lastFocus = appTiles.children[3];
            appTiles.currIndex = 3;
            appTiles.posCount = 3;
        } else {
            appTiles.lastFocus = appTiles.children[0];
            appTiles.currIndex = 0;
            appTiles.posCount = 0;
        }
        UI.refreshView(appTiles, appTiles.lastFocus);
    }

    function getUserTileGraphic(color) {
        return new PIXI.Graphics()
            .beginFill(color)
            .drawRect(0, 0, 312, 312)
            .endFill()
    }

    function getInputColorData(id) {
        switch (id) {
            case "0" :
                return getUserTileGraphic(CONST.USERTILE[6]);//0x333788,
                break;
            case "1" :
                return getUserTileGraphic(CONST.USERTILE[5]);//0x3c2e70
                break;
            case "2" :
                return getUserTileGraphic(CONST.USERTILE[4]);
                break;
            case "3" :
                return getUserTileGraphic(CONST.USERTILE[0]);
                break;
            case "4" :
                return getUserTileGraphic(CONST.USERTILE[1]);
                break;
            case "5" :
                return getUserTileGraphic(CONST.USERTILE[2]);
                break;
            case "6" :
                return getUserTileGraphic(CONST.USERTILE[3]);
                break;
            case "100" :
                return getUserTileGraphic(CONST.USERTILE[7]);
                break;
            case "300" :
                return getUserTileGraphic(CONST.USERTILE[8]);
                break;
            default :
                return getUserTileGraphic(CONST.USERTILE[7]);
                break;
        }
    }

    //UI.preloadSubModule("launcher", "allApps");
    //UI.preloadSubModule("launcher", "allInputs");
    //UI.preloadSubModule("launcher", "notifications");
    function mainTitleOnSourceChanged(val){
        DBG_ERROR("mainTitleOnSourceChanged!!!!!!!!!!!!"+val);
        var array = val.split("-");
        launcher.allInputNeedUpdate = true;
        if (array.length > 1) {
            if (array[1] == 2) {
                if (notification) {
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_yes.png");
                }
            }
            else{
                if (notification) {
                    var iconImg = UI.getItem(notification, "iconImg");
                    UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_no.png");
                }
            }
        }
        else{
            if (notification) {
                var iconImg = UI.getItem(notification, "iconImg");
                UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_no.png");
            }
        }
        launcher.refreshLauncherData();
        for (var j = 0; j < launcher.allInputsData.length; j++) {
            if (array[0] == launcher.allInputsData[j].id) {
                for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                    if (launcherTiles.initSequence[i].data.cmd != LauncherCMD.INPUT) {
                        continue;
                    }
                    if (array[0] == launcherTiles.initSequence[i].data.obj.id) {
                        var iconImgInput = UI.getItem(launcherTiles.initSequence[i], 'iconImg');
                        UI.setImage(iconImgInput, launcher.allInputsData[j].img);
                        break;
                    }
                }
            }
        }
        UI.updateStage();
    }

    function mainTitleOnNotifyPullChanged(){
        DBG_ERROR("mainTitleOnNotifyPullChanged!!!!!!!!!!!!");
        if (notification) {
            var iconImg = UI.getItem(notification, "iconImg");
            UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_yes.png");
        }
    }
    function mainTitleOnUsbChanged(val){
        DBG_ERROR("mainTitleOnUsbChanged!!!!!!!!!!!!"+val);
        try{
            if (val[1].indexOf("FSL2") != -1 ) {
        if(val[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_ADDED){
            if (notification) {
                var iconImg = UI.getItem(notification, "iconImg");
                UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_yes.png");
                UI.focusTo(launcherTiles.currFocus);
            }
        }
        else if(val[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED){
            if (notification) {
                var iconImg = UI.getItem(notification, "iconImg");
                UI.setImage(iconImg, "launcher/inputs/" + GLOBAL.LAUNCHER_BRAND +"/la_ic_notifications_no.png");
                UI.focusTo(launcherTiles.currFocus);
            }
        }
        }
        }catch(ex){DBG_ERROR(ex.message)}
    }
    function bansearchchannel() {
        if (!channelTiles.data[0].obj) {
            if (flg) {
                channelTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
            } else {
                if(checkIsAppOn()){
                    channelTiles.initSequence[0].onkey_ENTER = UI.blankFunc;
                }
                else{
                    channelTiles.initSequence[0].onkey_ENTER = onNoneChannelEnter;
                }
            }
        }
    }
    function setAllText(){
        //helpInfo = UI.getSubModule("helpInfo");
        //helpInfo.alpha = 0;
        //tertiaryTxt2 = UI.getItem(helpInfo, "tertiaryTxt2");
        //tertiaryTxt1 = UI.getItem(helpInfo, "tertiaryTxt1");
        //secondaryTxt = UI.getItem(helpInfo, "secondaryTxt");
        //primaryTxt2 = UI.getItem(helpInfo, "primaryTxt2");
        //primaryTxt1 = UI.getItem(helpInfo, "primaryTxt1");
        //channelTxt = UI.getItem(helpInfo, "channelTxt");
        //appTxt = UI.getItem(helpInfo, "appTxt");
        //inputTxt = UI.getItem(helpInfo, "inputTxt");
        //UI.setText(channelTxt, "[SE3149]");
        //UI.setText(appTxt, "[SE3150]");
        //UI.setText(inputTxt, "[SE3151]");
        //UI.setText(tertiaryTxt2, "[SE3158]");
        //UI.setText(tertiaryTxt1, "[BR0010]");
        //UI.setText(secondaryTxt, "[SE3219]");
    }
    function setAlpha(){
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        UI.updateStage();
    }
    function setActiveInput(){
        var nowId = tv?model.source.getCurrentSource():0;
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            if (launcherTiles.initSequence[i].data.cmd != LauncherCMD.INPUT ) {
                continue;
            }
            if(launcherTiles.initSequence[i].data.obj.id == nowId){
                var activeImg = UI.getItem(launcherTiles.initSequence[i], "activeImg");
                if (activeImg) {
                    activeImg.alpha = 1;
                }
            }
            else{
                var activeImg = UI.getItem(launcherTiles.initSequence[i], "activeImg");
                if (activeImg) {
                    activeImg.alpha = 0;
                }
            }
        }
            for (var i = 0; i < inputTiles.initSequence.length; i++) {
                if(inputTiles.initSequence[i].data.obj.id == nowId){
                var activeImg = UI.getItem(inputTiles.initSequence[i], "activeImg");
                if (activeImg) {
                    activeImg.alpha = 1;
                }
            }
                else{
                    var activeImg = UI.getItem(inputTiles.initSequence[i], "activeImg");
                    if (activeImg) {
                        activeImg.alpha = 0;
                    }
                }
            }
    }

    function mainTitleOnLockChanged(val){
        DBG_INFO("mainTitleOnLockChanged! val["+val+"]");
        launcher.lockTime =  getIsInlockTime();
        DBG_INFO("mainiles isInLock is " + launcher.lockTime);
        launcher.currentData = getLauncherData();
        launcher.allInputsData = getInputsDataForLauncher();
        var liveChannelData = liveTV.getChannelListOprtData();
        launcher.allChannelData = liveChannelData.allChannels[liveChannelData.crntList.name];
        if (!launcher.allChannelData) {
            launcher.allChannelData = [];
        }
        for (var i = 0; i < launcherTiles.initSequence.length; i++) {
            if (launcherTiles.initSequence[i].data.cmd != LauncherCMD.INPUT ) {
                continue;
            }
            for (var j = 0; j < launcher.allInputsData.length; j++) {
                if (launcher.allInputsData[j].id == launcherTiles.initSequence[i].data.obj.id) {
                    if (!!launcher.allInputsData[j].locked  && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH) {
                        var lockImg = UI.getItem(launcherTiles.initSequence[i], "lockImg");
                       UI.setImage(lockImg,"launcher/mask_luancher_input_children_lock.png");
                    }
                    else{
                        var lockImg = UI.getItem(launcherTiles.initSequence[i], "lockImg");
                        UI.setImage(lockImg,"launcher/mask_luancher_input_children_lock2.png");
                    }
                }
            }
        }
        for (i = 0; i < launcherTiles.initSequence.length; i++) {
            if ( launcherTiles.initSequence[i].data.cmd != LauncherCMD.CHANNEL ) {
                continue;
            }
            if (launcherTiles.initSequence[i].data.obj.isLock  && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH) {
                var lockImg = UI.getItem(launcherTiles.initSequence[i], "lockImg");
                UI.setImage(lockImg,"launcher/mask_luancher_input_children_lock.png");
            }
            else{
                var lockImg = UI.getItem(launcherTiles.initSequence[i], "lockImg");
                UI.setImage(lockImg,"launcher/mask_luancher_input_children_lock2.png");
            }
        }
        if( launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode){
            if(!!inputTiles.data[0].obj){
                for(i = 0;i<inputTiles.data.length;i++) {
                    if (!!inputTiles.initSequence[i].data.obj.isLock  && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH) {
                        inputTiles.data[i].lockImg = "launcher/mask_luancher_input_children_lock.png";
                    }
                    else {
                        inputTiles.data[i].lockImg = "launcher/mask_luancher_input_children_lock2.png";
                    }
                }
                inputTiles.refreshPageData();
            }
        if(!!channelTiles.data[0].obj){
            for(i = 0;i<channelTiles.data.length;i++) {

                if (!!channelTiles.initSequence[i].data.obj.isLock  && launcher.lockTime && GLOBAL.PARENTAL_LOCK_SWITCH) {
                    channelTiles.data[i].lockImg = "launcher/mask_luancher_input_children_lock.png";
                }
                else {
                    channelTiles.data[i].lockImg = "launcher/mask_luancher_input_children_lock2.png";
                }
            }
            channelTiles.refreshPageData();
        }
    }
}

    function navTo(index, posCount,Tiles,notFocus){
        if (posCount == null){
            Tiles.posCount = Tiles.initSequence.indexOf(UI.getCurrFocus());
            if (Tiles.posCount < 0) {
                Tiles.posCount = 0;
            }
        }else{
            Tiles.posCount = posCount;
        }
        Tiles.currIndex = index;


        if (Tiles.currIndex >= Tiles.data.length - 1) {
            Tiles.currIndex = Tiles.data.length - 1;
            Tiles.posCount = Tiles.initSequence.length - 1;
        }
        if (Tiles.currIndex < 0) {
            Tiles.currIndex = 0;
        }
        if (index <=4) {
            Tiles.posType = 0;
        }else if(index > 4 && Tiles.data.length - index > Tiles.info.pageCount - 3){
            Tiles.posType = 1;
        }else if (Tiles.data.length - index <= Tiles.info.pageCount - 3) {
            Tiles.posType = 2;
        }

        var realPos = Tiles.posCount - Tiles.posType;

        if (Tiles.data.length <= Tiles.info.pageCount + 2) {
            UI.refreshView(Tiles, Tiles.initSequence[0]);
            Tiles.posType = 0;
            Tiles.posCount = Tiles.currIndex;
        } else if (Tiles.data.length - Tiles.currIndex <= Tiles.info.pageCount - 3) {
            Tiles.posType = 2;
            Tiles.posCount = Tiles.initSequence.length - (Tiles.data.length - Tiles.currIndex);
            UI.refreshView(Tiles, Tiles.initSequence[0]);
            UI.refreshView(Tiles, Tiles.initSequence[Tiles.initSequence.length - 1]);
        } else {
            if (Tiles.currIndex - realPos <= 0) {
                UI.refreshView(Tiles, Tiles.initSequence[0]);
                Tiles.posType = 0;
                Tiles.posCount = Tiles.currIndex;
            }
            else if (Tiles.currIndex - realPos + Tiles.info.pageCount >= Tiles.data.length) {
                UI.refreshView(Tiles, Tiles.initSequence[0]);
                UI.refreshView(Tiles, Tiles.initSequence[Tiles.initSequence.length - 1]);
                Tiles.posType = 2;
                Tiles.posCount = realPos + Tiles.posType;
            }
            else {
                UI.refreshView(Tiles, Tiles.initSequence[0]);
                UI.refreshView(Tiles, Tiles.initSequence[Tiles.initSequence.length - 2]);
                Tiles.posType = 1;
                Tiles.posCount = realPos + Tiles.posType;
            }
        }
        if (!!Tiles.data[0].obj) {
        for (var i = 0; i < Tiles.initSequence.length; i++) {
            Tiles.refreshData(Tiles.initSequence[i], Tiles.data[Tiles.currIndex - Tiles.posCount + i]);
            Tiles.initSequence[i].name = Tiles.data[Tiles.currIndex - Tiles.posCount + i].name;
            Tiles.initSequence[i].obj = Tiles.data[Tiles.currIndex - Tiles.posCount + i].obj;
            Tiles.initSequence[i].data = Tiles.data[Tiles.currIndex - Tiles.posCount + i];
        }
        }
        if(!notFocus){
            UI.focusTo(Tiles.initSequence[Tiles.posCount]);
        }
        Tiles.moveScroll();
    }
    function timerFunction(timerName,func,timeOut){
        if(!!timerName){
            clearTimeout(timerName);
        }
        var time = timeOut;
        if(time == null){
            time =0;
        }
        timerName =setTimeout(func,time);
        return timerName;
    }
     function setlastFocus(){
        var storage=window.localStorage;
        var endfocus = UI.getCurrFocus();
        storage.setItem("endfocus",endfocus.name);
    }
    function setImgAlpha(flg,o){
        if(!!o && o!=UI.getCurrFocus().name){
            return;
        }
       if(!!flg){
           UI.getTween(arrangeImg1).to({alpha:0.5}, 100);
           UI.getTween(arrangeImg2).to({alpha:1}, 100);
           UI.getTween(secondaryImg).to({alpha:0.5}, 100);
           UI.getTween(secondaryImg2).to({alpha:1}, 100);
           UI.getTween(secondaryTxt).to({alpha:0.9}, 100);
       }else{
           UI.getTween(arrangeImg1).to({alpha:0}, 100);
           UI.getTween(arrangeImg2).to({alpha:0}, 100);
           UI.getTween(secondaryImg).to({alpha:0}, 100);
           UI.getTween(secondaryImg2).to({alpha:0}, 100);
           UI.getTween(secondaryTxt).to({alpha:0}, 100);
       }
    }
};