// Init
UI.moduleBuilder['launcher']['appInstaller'] = function(){

    var appInstallerData = {
        bgImg : new PIXI.Graphics()
            .beginFill(0x282C40)
            .drawRect(0, 0, 1920, 1080)
            .endFill(),
        iconImg : "launcher/ic_instl_hs_s.png",
        toastBgImg : "toast/Toast_bg2.png",
        toastImg:"launcher/ic_warn.png"
    };
    if(GLOBAL.LAUNCHER_BRAND == "shp"){
        appInstallerData.bgImg = {color : "0x282425"};
        appInstallerData.iconImg = "launcher/ic_instl_sp_s.png";
    }
    else{
        appInstallerData.bgImg ={color : "0x282C40"};
        appInstallerData.iconImg ="launcher/ic_instl_hs_s.png";
    }
    var template = Util.readJson("module/launcher/appInstaller.json");
    var appInstaller = SubModule.create(appInstallerData, template, "launcher");
    var InstallTxt = UI.getItem(appInstaller, "InstallTxt");
    var InstallAnchor = UI.getItem(appInstaller, "InstallAnchor");
    var msgPanel = UI.getItem(appInstaller, "msgPanel");
    var msgTxt = UI.getItem(appInstaller, "msgTxt");
    msgPanel.alpha = 0;
   appInstaller.pushlag = false;
    UI.addMask(InstallAnchor, 1800, 750, 48, 30);
    UI.setView(InstallAnchor, 1800, 750);
    try {
        refreshInstall();
        appInstaller.currFocus = InstallAnchor.initSequence[0];
        launcher.currFocus = appInstaller.currFocus;
        UI.focusTo(InstallAnchor.initSequence[0]);
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
    }catch(e){
        DBG_ERROR("refreshTiles:"+ e.message);
    }

    appInstaller.onShow = function() {
        if(!!launcher.AppInstallNeedUpdate) {
            refreshInstall();
            if(!!appInstaller.index){
                UI.focusTo(InstallAnchor.initSequence[appInstaller.index]);
            }else{
                appInstaller.currFocus = InstallAnchor.initSequence[0];
                launcher.currFocus = appInstaller.currFocus;
                UI.focusTo(launcher.currFocus);
            }
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.base.cursor.alpha = 1;
            UI.base.cursor.visible = true;
            launcher.AppInstallNeedUpdate = false;
            launcher.deleteInsresult = false;
        }else if(!!launcher.deleteInsresult) {
            refreshInstall();
            appInstaller.currFocus = InstallAnchor.initSequence[0];
            launcher.currFocus = appInstaller.currFocus;
            UI.focusTo(launcher.currFocus);
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.base.cursor.alpha = 1;
            UI.base.cursor.visible = true;
            launcher.AppInstallNeedUpdate = false;
            launcher.deleteInsresult = false;
        }

    };

    appInstaller.onFocus = function(focus) {
        UI.getItem(focus, "txtBg").alpha = 1;
        UI.getItem(focus, "nameTxt").alpha = 1;
		
        //if(!!focus.data.flg){
	   //UI.setText(UI.getItem(focus, "nameTxt"), "[OT0133]");
       //UI.callTTS(focus.name+" "+ "[OT0133]");
	   //}
	   //else{
	   //UI.setText(UI.getItem(focus, "nameTxt"), "[OT0131]");
       //UI.callTTS(focus.name +" "+  "[OT0131]");
	   //}
        return true;
    };

    appInstaller.onNormal = function(focus) {
        UI.getItem(focus, "txtBg").alpha = 0;
        UI.getItem(focus, "nameTxt").alpha = 0;
        return true;
    };

    appInstaller.onkey_BACKSPACE =function(){
        var param={
            CloseReason:4
        };
        exitModule(param);
    };
    function exitModule(para) {
        launcherPanelCloseReport(para);
        UI.getTween(UI.base.cursor).set({alpha:0});
        UI.inactiveKey();
        if (launcher.info && launcher.info.event == "APP") {
            launcher.popSelf(true);
        } else {
            UI.popSubModule();
        }
    }

    InstallAnchor.onkey_ENTER = function(focus) {
        launcher.refreshAppInstall = true;
        if(!!focus.data.flg){
			if(!!focus.data.locked && GLOBAL.PARENTAL_LOCK_SWITCH){
            appInstaller.index = InstallAnchor.initSequence.indexOf(focus);
                launcher.lastfocus = focus;
            UI.pushSubModule("launcher", "launcherPassword",true, {caller: "appInstaller"});
        }
		else{
                //var mainTiles = UI.getItem(launcher, "mainTiles");
                //var appTiles = UI.getItem(mainTiles, "appTiles");
                //var launcherTiles = UI.getItem(mainTiles, "launcherTiles");
                //for (var i = 0; i < launcherTiles.initSequence.length; i++) {
                //    var tile = launcherTiles.initSequence[i];
                //    if (tile.data.obj && (tile.data.obj.url == focus.data.url)) {
                //        launcherTiles.removeItem(tile, true);
                //        var apps = UI.getItem(launcherTiles, "apps");
                //        if (i < launcherTiles.initSequence.indexOf(apps)) {
                //            UI.refreshView(launcherTiles, apps);
                //        }
                //        var tileArray = mainTiles.getCurrTileArray();
                //        setRememberEditAppToNativeFile(tileArray);
                //        break;
                //    }
                //}

                //for (var i = 0; i < appTiles.initSequence.length; i++) {
                //    var tile = appTiles.initSequence[i];
                //    if (tile.data.obj && tile.data.obj.url == focus.data.url) {
                //        appTiles.removeItem(tile);
                //    }
                //}
                UI.setText(UI.getItem(focus, "nameTxt"), "[OT0131]");
                focus.data.voiceStr = "[OT0131]" + focus.data.name;
                setLauncherInstallerAppByUser(focus.data.url ,false);
                focus.data.flg = false;
                UI.setText(msgTxt, "[OT0134]");
                UI.getTween(msgPanel).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);
                UI.focusTo(focus);
            }
			}
            else{
            launcher.deleteMainresult = true;
                UI.setText(UI.getItem(focus, "nameTxt"), "[OT0133]");
            focus.data.voiceStr = "[OT0133]" + focus.data.name;
                setLauncherInstallerAppByUser(focus.data.url ,true);
                launcher.appChanged = true;
                focus.data.flg = true;
                UI.setText(msgTxt, "[OT0132]");
                UI.getTween(msgPanel).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);
            UI.focusTo(focus);
            }

        
    };

    function refreshInstall() {
        InstallAnchor.removeAllChildren();
        launcher.currentData = getLauncherData();
        for (var i = 0; i < launcher.currentData.length; i++) {
            if (launcher.currentData[i].cmd == LauncherCMD.ALLAPP) {
                launcher.allAppsData = launcher.currentData[i].data;
            }
        }
        var array = [];

        for (var i = 0; i < launcher.allAppsData.imgs.length; i++) {
            if(launcher.allAppsData.urls[i] == "netflix"){
                continue;
            }
            if(launcher.allAppsData.urls[i] == "amazon"){
                continue;
            }
            if(launcher.allAppsData.urls[i] == "youtube"){
                continue;
            }
            if(launcher.allAppsData.urls[i] == "vudu"){
                continue;
            }
                var idx = $.inArray(launcher.allAppsData.urls[i], cannotInstallApps);
                if (idx > -1) {
                    continue;
                }
                if (launcher.allAppsData.from[i] == "store") {
                    continue;
                }
            if(launcher.allAppsData.storeTypes[i]== 95 && launcher.allAppsData.urls[i]!="appstore"){
                continue;
            }

            if (!launcher.allAppsData.Installer[i]) {
                var data = {
                    bgImg : launcher.allAppsData.imgs[i],
                    txtBg : UI.btn_normal_bg,
                    nameTxt : "[OT0131]",
                    name : launcher.allAppsData.txts[i],
                    voiceStr : "[OT0131]" +launcher.allAppsData.txts[i],
                    storeType : launcher.allAppsData.storeTypes[i],
                    url : launcher.allAppsData.urls[i],
                    urlType : launcher.allAppsData.urlTypes[i],
                    locked : launcher.allAppsData.Locked[i],
                    lockImg : "launcher/mask_input_children_lock.png",
                    noRemove : !launcher.allAppsData.canRemoves[i],
                    flg : launcher.allAppsData.Installer[i]
                };
            }
            else{
                var data = {
                    bgImg : launcher.allAppsData.imgs[i],
                    txtBg : UI.btn_normal_bg,
                    nameTxt : "[OT0133]",
                    name : launcher.allAppsData.txts[i],
                    voiceStr : "[OT0133]" +launcher.allAppsData.txts[i],
                    storeType : launcher.allAppsData.storeTypes[i],
                    url : launcher.allAppsData.urls[i],
                    urlType : launcher.allAppsData.urlTypes[i],
                    locked : launcher.allAppsData.Locked[i],
                    lockImg : "launcher/mask_input_children_lock.png",
                    noRemove : !launcher.allAppsData.canRemoves[i],
                    flg : launcher.allAppsData.Installer[i]
                };
            }
            array.push(data);
        }
        var info = {
            template : "launcher_tile_panel_1",
            direction : CONST.GIRD_DIRECTION.H,
            breakNum : 4,
            distanceX : 48,
            distanceY : -2,
            container : InstallAnchor
        };
        if (array.length == 0) {
            array.push({
                template : "launcher_tile_msg",
                bgImg : "setting/blank.png",
                noneTxt : "[SE3160]",
                flag : true
            });
        }
        Gird.create(array, info);
       if(InstallAnchor.initSequence.length == 0){
           UI.setText("InstallTxt","[SE3159]");
       }
        for (var i = 0; i < InstallAnchor.initSequence.length; i++) {
            var item = InstallAnchor.initSequence[i];
            UI.getItem(item, "txtBg").alpha = 0;
            UI.getItem(item, "nameTxt").alpha = 0;
            if(!!InstallAnchor.initSequence[i].data.locked && InstallAnchor.initSequence[i].data.flg  && GLOBAL.PARENTAL_LOCK_SWITCH){
                var lockImg = UI.getItem(InstallAnchor.initSequence[i], "lockImg");
                if (lockImg) {
                    lockImg.alpha = 1;
                }
            }
            else{
                var lockImg = UI.getItem(InstallAnchor.initSequence[i], "lockImg");
                if (lockImg) {
                    lockImg.alpha = 0;
                }
            }
        }
       InstallAnchor.currFocus = InstallAnchor.initSequence[0];
    }
    InstallAnchor.onkey_DOWN = function(focus) {
        if (!focus.downTo) {
            var index = InstallAnchor.initSequence.indexOf(focus);
            var index2 = Math.floor(index / InstallAnchor.info.breakNum);
            var index3 = Math.floor((InstallAnchor.initSequence.length - 1) / InstallAnchor.info.breakNum);
            if (index2 == index3 -1) {
                UI.focusTo(InstallAnchor.initSequence[InstallAnchor.initSequence.length - 1]);
            }
        } else {
            return true;
        }
    }
};