/**
 * Created by Administrator on 16-1-29.
 */
// Init
UI.moduleBuilder['hiMedia']['videoPlayer'] = function () {

    var initData = {
        videoStatus: "hiMedia/play_status.png",
        videoMenuBak: "hiMedia/menu_chip_bg.png",
        videoMenuBak2: "hiMedia/menu_chip_bg.png",
        dolbyPic: "hiMedia/dolby.png",
        hdrPic: "hiMedia/hdr.png",
        controlBtn0: "hiMedia/btn/icn_previous_normal.png",
        controlBtn1: "hiMedia/btn/icn_backward_normal.png",
        controlBtn2: "hiMedia/btn/icn_pause_focus.png",
        controlBtn3: "hiMedia/btn/icn_forward_normal.png",
        controlBtn4: "hiMedia/btn/icn_next_normal.png",
        videoPBFocus: "hiMedia/btn/dot_progress_normal.png",
        videoPlayerHeaderBg: "hiMedia/backgroundheader.png",
        videoPlayerFooterBg: "hiMedia/backgroundfooter.png"
    };
    var template = Util.readJson("module/hiMedia/videoPlayer.json");
    var videoPlayer = SubModule.create(initData, template);
    videoPlayer.noAutoMemcControl = true;
    var videoPlayerMenu = UI.getItem(videoPlayer, "videoPlayerMenu");
    var videoPlayerMenu2 = UI.getItem(videoPlayer, "videoPlayerMenu2");
    var videoPlayerMenuList = UI.getItem(videoPlayerMenu, "videoPlayerMenuList");
    var videoPlayerMenuList2 = UI.getItem(videoPlayer, "videoPlayerMenuList2");
    var dolbyPic = UI.getItem(videoPlayer, "dolbyPic");
    var hdrPic = UI.getItem(videoPlayer, "hdrPic");
    var videoPlayerTop = UI.getItem(videoPlayer, "videoPlayerTop");
    var controlBtn0 = UI.getItem(videoPlayer, "controlBtn0");
    var controlBtn1 = UI.getItem(videoPlayer, "controlBtn1");
    var controlBtn2 = UI.getItem(videoPlayer, "controlBtn2");
    var controlBtn3 = UI.getItem(videoPlayer, "controlBtn3");
    var controlBtn4 = UI.getItem(videoPlayer, "controlBtn4");
    var videoPBFocus = UI.getItem(videoPlayer, "videoPBFocus");
    var fLongPressCnt = 0;
    controlBtn0.voiceStr = "[GE0011]";
    controlBtn1.voiceStr = "[SE1040]";
    controlBtn2.voiceStr = "[DMP0027]";
    controlBtn3.voiceStr = "[SE1039]";
    controlBtn4.voiceStr = "[GE0010]";


    videoPlayerMenu.visible = false;
    videoPlayerMenu.alpha = 0;
    dolbyPic.alpha = 0;
    hdrPic.alpha = 0;
    //videoPlayer.currFocus = UI.getItem(videoPlayer, "videoPlayerMenu");
    videoPlayer.videoList = [];
    videoPlayer.videoIndex = 0;
    videoPlayer.playerStatus = 1;
    videoPlayer.videoTotalTime = 0;
    videoPlayer.chapterTotalCount = 0;
    videoPlayer.videoCurrentTime = 0;
    videoPlayer.subIndex = 0;
    videoPlayer.subAIndex = 0;//用于记录sublist的四个分类的焦点位置
    videoPlayer.audioTrackIndex = 0;
    videoPlayer.picModeIndex = 0;
    videoPlayer.screenIndex = 0;
    videoPlayer.currentMenuIndex = 0;
    videoPlayer.currentMenuFocus = "";
    videoPlayer.isPBarShow = 1;
    videoPlayer.subtitleList = [];
    videoPlayer.nowIsSeeking = false;
    videoPlayer.initIndex = 0;
    videoPlayer.needUnlockKey = false;
    videoPlayer.audioTrackList = [];
    videoPlayer.chapterTimeList = [];
    videoPlayer.chapterIndex = 0;
    videoPlayer.openMenuByHotkey = false;
    videoPlayer.needSetPosition = true;
    videoPlayer.hasPrepared = false;
    videoPlayer.stopState = false;

    videoPlayer.ffSpeed = [100, 200, 400, 800, 1600];
    videoPlayer.frSpeed = [100100, 100200, 100400, 100800, 101600];
    videoPlayer.ffIndex = 0;
    videoPlayer.frIndex = 0;

    videoPlayer.videoList = hiMedia.initVideoList;
    videoPlayer.videoIndex = hiMedia.initVideoIndex;
    if (!Config.tv) {
        videoPlayer.videoList = [
            {videoUrl: "a", videoName: "a"}
        ];
        videoPlayer.videoIndex = 0;
    }
    if (!localStorage.VrepeatIndex) {
        localStorage.VrepeatIndex = 0;
    }
    videoPlayer.chapterData = [];
    //初始化MENU菜单内容
    videoPlayerMenu.menuData = {
        menuVideoInit: [
            {"icon": "hiMedia/menu/ic_audioTrack.png", "text": "[SE0380]"},//audio track
            {"icon": "hiMedia/menu/ic_subtitle.png", "text": "[SE0381]"},//subtitle
            {"icon": "hiMedia/menu/ic_PictureMode.png", "text": "[SE0003]"},//pic mode
            {"icon": "hiMedia/menu/ic_SoundMode.png", "text": "[SE0059]"},//sound mode
            {"icon": "hiMedia/menu/ic_aspect.png", "text": "[SE0461]"},//picture size
            {"icon": "hiMedia/menu/ic_Audio_only.png", "text": "[SE0834]"},//audio only
            {"icon": "hiMedia/menu/ic_repeatMode.png", "text": "[DMP0120]"},//repeat mode
            {"icon": "hiMedia/menu/time_select_play.png", "text": "[DMP0119]"},//Time select play
            {"icon": "hiMedia/menu/ic_information.png", "text": "[SE0628]"},//info
            {"icon": "hiMedia/menu/ic_videoList.png", "text": "[DMP0095]"},//list
            {"icon": "hiMedia/menu/ic_SystemSetting.png", "text": "[DMP0123]"}//setting
        ],
        menuVideoList: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "no video"}
        ],
        menuVideoRepeatMode: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0165]"},//No Repeat
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0166]"},//Repeat Current
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0057]"}//Repeat All
        ],
        menuVideoPictureMode: [
            //(Vivid / Standard / Energy Saving / Movie / Game / Sport / Calibrated)
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0456]"},//vivid
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0004]"},//Standard
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0457]"},//Energy Saving
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0144]"},//Movie
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0008]"},//Game
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[LA0013]"},//Sports
            {"icon": "setting/ic_radiobutton_normal.png", "text": "Calibrated"}//Calibrated
        ],
        menuVideoAspectRatio: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0153]"},//Fit
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0050]"},//Full
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE2523]"}//Original

        ],
        menuSubtitle: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0275]"}//None
        ],
        menuAudioTrack: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE0275]"}//None
        ],
        menuVideoInfo: [
            {"icon": "hiMedia/normal.png", "text": "[DMP0051]"},//file name
            {"icon": "hiMedia/normal.png", "text": "[DMP0028]"},//duration
            {"icon": "hiMedia/normal.png", "text": "[SE3909]"},//video resolution
            {"icon": "hiMedia/normal.png", "text": "[SE3910]"},//Create Date
            {"icon": "hiMedia/normal.png", "text": "[SE3911]"},//Video Codec
            {"icon": "hiMedia/normal.png", "text": "[OT0121]"},//Audio Format
            {"icon": "hiMedia/normal.png", "text": "[SE3905]"},//Audio Codec
            {"icon": "hiMedia/normal.png", "text": "[SE3912]"},//Number of Audio Tracks
            {"icon": "hiMedia/normal.png", "text": "[SE3913]"},//Number of Subtitle Tracks
            {"icon": "hiMedia/normal.png", "text": "[DMP0004]"}//File Size

        ]
    }
    if (!tv) {
        videoPlayerMenu.menuData.menuSubtitle = videoPlayer.subtitleList = ["off", "chi", "eng"];
    }
    videoPlayer.menuArray = [videoPlayerMenu.menuData.menuVideoInit, videoPlayerMenu.menuData.menuAudioTrack,
        videoPlayerMenu.menuData.menuSubtitle, videoPlayerMenu.menuData.menuVideoPictureMode, ["sound mode"],
        videoPlayerMenu.menuData.menuVideoAspectRatio, ["audio only"], videoPlayerMenu.menuData.menuVideoRepeatMode, ["Time select play"],
        videoPlayerMenu.menuData.menuVideoInfo, videoPlayerMenu.menuData.menuVideoList, ["setting"]];
    videoPlayer.hpFlag = 0;

    videoPlayer.Percent = {};
    videoPlayer.currFocus = videoPlayerMenu;

    videoPlayer.Percent.create = function (target, txt, percent, min, max) {
        target.percent = percent;
        target.max = max;
        //target.lineColor = 0xA10764;
        target.lineColor = 0xbb2071;
        if (GLOBAL.UI_BRAND == "his") {
            target.lineColor = 0x00a9c2
        }
        var bound = target.getBounds();

        target.removeAllChildren(true);

        var back = new PIXI.Graphics();
        back.clear()
            .beginFill(0xffffff, 0.25)
            .drawRect(0, 0, bound.width, bound.height, 4)
            .endFill();
        var shape = new PIXI.Graphics();
        shape.clear()
            .beginFill(target.lineColor, 1)
            .drawRect(0, 0, bound.width, bound.height, 4)
            .endFill();
        var mask = new PIXI.Graphics();
        mask.clear()
            .beginFill(0x000000, 0.25)
            .drawRect(0, 0, bound.width, bound.height)
            .endFill();
        shape.mask = mask;
        mask.x = bound.width * ((target.percent - min) / (target.max - min)) - bound.width;

        target.addChild(back);
        target.addChild(shape);
        target.addChild(mask);

        txt.children[0].text = target.percent;
        UI.updateStage();


        target.setPercent = function (percent) {
            target.percent = percent;
            //DBG_INFO("setPercent : " + percent + "  max :　" + target.max);
            if (percent <= target.max && percent >= 0) {
                mask.x = bound.width * ((target.percent - min) / (target.max - min)) - bound.width;
                videoPBFocus.x = 128 + bound.width * ((target.percent - min) / (target.max - min));
                txt.children[0].text = hiMedia.getTimeText(target.percent, "HMS");
                UI.updateStage();
            }
        };

        target.setMax = function (max) {
            target.max = max;
            mask.x = bound.width * ((target.percent - min) / (target.max - min)) - bound.width;
            UI.updateStage();
        }
    };
    //init(只初始化不会变的内容，需要根据内容变化的在onshow里初始化)
    //videoPlayer.createMenuList(videoPlayerMenu.menuData.menuVideoInit, videoPlayerMenuList);


    var videoStatus = UI.getItem(videoPlayer, "videoStatus");
    var endTime = UI.getItem(videoPlayer, "endTime");
    var startTime = UI.getItem(videoPlayer, "startTime");
    var videoPB = UI.getItem(videoPlayer, "videoPB");
    var videoPlayerPB = UI.getItem(videoPlayer, "videoPlayerPB");
    var videoNameTitle = UI.getItem(videoPlayer, "videoName");
    var vMenuListContainer = UI.getItem(videoPlayerMenu, "vMenuListContainer");
    var vChapterContainer = UI.getItem(videoPlayer, "vChapterContainer");
    var vMenuListContainer_2 = UI.getItem(videoPlayer, "vMenuListContainer_2");
    var videoPlayerMenuName = UI.getItem(videoPlayer, "videoPlayerMenuName");
    var videoPlayerMenuName2 = UI.getItem(videoPlayer, "videoPlayerMenuName2");
    var ffTime = UI.getItem(videoPlayer, "ffTime");
    var videoPlayerEndTime = UI.getItem(videoPlayer, "endTime");

    var menuNameArray = ["[DMP0056]", "[SE0380]", "[SE0381]", "[SE0003]", "[SE0059]",
        "[SE0461]", "[SE0834]", "[DMP0120]", "[DMP0119]", "[SE0628]", "[DMP0095]", "[DMP0123]"];
    var subtitleArray = ["[SE0381]", "[SE0391]", "[SE0753]", "[BR0036]"];
    //var subtitlePosition = ["[SE0052]", "[GE0001]", "[GE0003]"];   //MIDDLE HIGH LOW
    //var subtitleLan = ["[DMP0100]", "[SE2793]", "[SE2794]", "[SE0231]", "[SE2795]", "[SE2796]"];
    //"Default",  "Western", "Central European", "Arabic", "Chinese Simplified", "Cyrillic"]
    //var subtitleSize = ["[SE0080]", "[SE0755]", "[SE0754]"];//Normal", "Big", "Small"
    //var subIndexArray = [0, 0, 0, 0];
    videoPlayerPB.noRTL = true;
    videoPlayer.createMenuList = function (menuData, menuList) {

        DBG_INFO(menuData[0].text);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {
                    chip_bg: UI.item_bg,
                    chipIcon: menuData[i].icon,
                    chipText: menuData[i].text,
                    name: menuList.name + i


                };
                array.push(data);
            }
            var info = {
                template: "chipTile",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 6,
                container: menuList
            };
            Gird.create(array, info);
            //sound mode 删除 判断ARC注掉
//            if(!!getARCStateInit()){
//                menuList.initSequence[4].disable = true;
//                menuList.initSequence[4].children[2].alpha = 0.3;
//            }else{
//                menuList.initSequence[4].disable = false;
//                menuList.initSequence[4].children[2].alpha = 1;
//            }
//            for (var i = 0; i < menuData.length; i++) {
//                if (menuData[i].icon == "setting/ic_radiobutton_normal.png") {
//                    // if(menuData[i].icon);
//                    menuList.children[i].children[2].x = menuList.children[i].children[2].x - 40;
//                }
//            }
            //leftover : 这里需要计算一次焦点位置
            if (videoPlayer.audioTrackList.length < 1) {
                menuList.initSequence[videoPlayer.hpFlag].disable = true;
                menuList.initSequence[videoPlayer.hpFlag].children[1].alpha = 0.3;
                menuList.initSequence[videoPlayer.hpFlag].children[2].alpha = 0.3;
            } else {
                menuList.initSequence[videoPlayer.hpFlag].disable = false;
                menuList.initSequence[videoPlayer.hpFlag].children[1].alpha = 1;
                menuList.initSequence[videoPlayer.hpFlag].children[2].alpha = 1;
            }
            if (videoPlayer.subtitleList.length < 1) {
                menuList.initSequence[videoPlayer.hpFlag + 1].disable = true;
                menuList.initSequence[videoPlayer.hpFlag + 1].children[1].alpha = 0.3;
                menuList.initSequence[videoPlayer.hpFlag + 1].children[2].alpha = 0.3;
            } else {
                menuList.initSequence[videoPlayer.hpFlag + 1].disable = false;
                menuList.initSequence[videoPlayer.hpFlag + 1].children[1].alpha = 1;
                menuList.initSequence[videoPlayer.hpFlag + 1].children[2].alpha = 1;
            }
            try {
                var isSndModeEnable = !((tv ? model.sound.getSpeakerArc() : 1) != 1);//check whether ARC is open
                if (!isSndModeEnable) {
                    menuList.initSequence[videoPlayer.hpFlag + 3].disable = true;
                    menuList.initSequence[videoPlayer.hpFlag + 3].children[1].alpha = 0.3;
                    menuList.initSequence[videoPlayer.hpFlag + 3].children[2].alpha = 0.3;
                } else {
                    menuList.initSequence[videoPlayer.hpFlag + 3].disable = false;
                    menuList.initSequence[videoPlayer.hpFlag + 3].children[1].alpha = 1;
                    menuList.initSequence[videoPlayer.hpFlag + 3].children[2].alpha = 1;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }


    videoPlayer.createMenu2List = function (menuData, menuList) {

        DBG_INFO(menuData[0].text);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {
                    chip_bg: UI.item_bg,
                    chipIcon: menuData[i].icon,
                    chipText: menuData[i].text,
                    name: menuList.name + i


                };
                array.push(data);
            }
            var info = {
                template: "chipTileMedia2",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 10,
                container: menuList
            };
            Gird.create(array, info);
        }
    };
    videoPlayer.createChapterList = function (menuData, menuList) {

        //DBG_INFO(menuData[0].text);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {
                    chip_bg: UI.item_bg,
                    chipIcon: menuData[i].icon,
                    chipText: menuData[i].text,
                    name: menuList.name + i


                };
                array.push(data);
            }
            var info = {
                template: "chipTile",
                direction: CONST.GIRD_DIRECTION.V,
                breakNum: 1,
                distanceX: 8,
                distanceY: 0,
                container: menuList
            };
            Gird.create(array, info);
            hiMedia.hideListData(vChapterContainer, 0, 6);
        }
    };
    videoPlayer.onShow = function () {
        if (!videoPlayerMenu.visible) {
            UI.base.cursor.alpha = 0;
        } else {
            UI.base.cursor.alpha = 1;
        }
        //处理MEMC从别的页面回到VIDEOPlayer的情况
        setMemcForVideo(0);

    }
    videoPlayer.afterPush = function () {
        try {
            DBG_INFO("videoPlayer afterPush.");
            UI.clearMediaTimeout();
            videoPlayer.currFocus = videoPlayerMenu;
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, videoPlayer.onVStateChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, videoPlayer.onVPlaytimeChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, keyReleaseForFF);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
        videoPlayer.Percent.create(videoPB, startTime, 0, 0, 100);
        //初始化公共参数
        videoPlayerMenu.visible = false;
        videoPlayerMenu.alpha = 0;
        videoPlayerMenu2.alpha = 0;
        ffTime.alpha = 0;
        videoPlayer.videoList = [];
        videoPlayer.videoIndex = 0;
        UI.setImage(videoStatus, "hiMedia/play_status.png");
        UI.setImage(videoPBFocus, "hiMedia/btn/dot_progress_normal.png");
        videoPlayer.playerStatus = 1;
        videoPlayer.videoTotalTime = 0;
        videoPlayer.videoCurrentTime = 0;
        videoPlayer.subIndex = 0;
        videoPlayer.subAIndex = 0;
        videoPlayer.audioTrackIndex = 0;
        videoPlayer.picModeIndex = 0;
        videoPlayer.screenIndex = 0;
        videoPlayer.currentMenuIndex = 0;
        videoPlayer.currentMenuFocus = "";
        videoPlayer.videoList = hiMedia.initVideoList;
        videoPlayer.videoIndex = hiMedia.initVideoIndex;
        videoPlayer.resolution = "";
        videoPlayer.Vwidth = 0;
        videoPlayer.Vheight = 0;
        hiMedia.playerstatus = 0;
        videoPlayer.chapterTotalCount = 0;
        videoPlayer.chapterFlag = true;
        vChapterContainer.alpha = 0;
        videoPlayer.ControlTimer = null;
        videoPlayer.initIndex = 0;
        videoPlayer.stopState = false;
        videoPlayer.isPBarShow = 1;
        videoPlayer.ffIndex = 0;
        videoPlayer.frIndex = 0;
        UI.setImage(controlBtn3, "hiMedia/btn/icn_forward_normal.png");
        UI.setImage(controlBtn1, "hiMedia/btn/icn_backward_normal.png");
        //强制重新打开BAR
        videoPlayer.reopenBar();
        videoPlayer.subtitleList = [];
        videoPlayer.audioTrackList = [];
        videoPlayer.chapterTimeList = [];
        videoPlayer.chapterIndex = 0;
        videoPlayer.repeatTime = 0;
        videoPlayer.presetCurTime = 0;
        videoPlayer.stopPBrefresh = false;
        videoPlayer.nowIsSeeking = false;
        videoPlayer.needUnlockKey = true;
        videoPlayer.openMenuByHotkey = false;
        videoPlayer.needSetPosition = true;
        //重置menu
        //UI.unlockAllKeys("playVideo");

        if (!Config.tv) {
            videoPlayer.playVideoByUrl("url", "Test Video Name");
            hiMedia.endLoading("NOT TV");
        } else {
            try {

                videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl,
                    videoPlayer.videoList[videoPlayer.videoIndex].videoName);
            }
            catch (ex) {
                DBG_ERROR("[playVideoByUrl]" + ex.message);
            }
        }
        if (Config.tv) {
            videoPlayerMenu.menuData.menuVideoList = [];
            for (var i = 0; i < videoPlayer.videoList.length; i++) {
                videoPlayerMenu.menuData.menuVideoList.push({
                    "icon": "setting/ic_radiobutton_normal.png",
                    "text": videoPlayer.videoList[i].videoName
                });
            }
        }
        else {
            videoPlayer.videoList = videoPlayerMenu.menuData.menuVideoList;
        }
        vMenuListContainer.removeAllChildren(true);
        videoPlayer.refreshMenuArray();
        videoPlayer.createMenuList(videoPlayerMenu.menuData.menuVideoInit, vMenuListContainer);
        videoPlayer.reFocusMenu();
        UI.addMask(videoPlayerMenuList, 440, 504, 20, 10);
        UI.setView(videoPlayerMenuList, 440, 504);
        UI.resetViewPos(vMenuListContainer);
        UI.setView(vMenuListContainer, 440, 504);
        UI.addScrollbar(vMenuListContainer, 0);

        hiMedia.hideListData(vMenuListContainer, 0, 6);

        //CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER] = true;
    };

    controlBtn1.onFocus = function () {
        CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER] = true;
        return true;
    };
    controlBtn1.onNormal = function () {
        delete CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER];
        return true;
    };
    controlBtn3.onFocus = function () {
        CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER] = true;
        return true;
    };
    controlBtn3.onNormal = function () {
        delete CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER];
        return true;
    };
    videoPlayer.playVideoByUrl = function (vUrl, vName) {

        if (vUrl != null) {
            DBG_INFO("video Url is :" + vUrl);
            //重置播放图标
            if (videoPlayer.playerStatus == 0) {

                UI.setImage(videoStatus, "hiMedia/play_status.png");
                videoPlayer.playerStatus = 1;
            }
            //重置PLAY_DONE标志
            hasSetPlayDone = false;
            hasBuffered = false;
            hiMedia.startLoading("playVideoByUrl", 30);

            //重置进度条
            videoPB.setPercent(0);
            UI.setText(videoPlayerEndTime, "00:00:00");
            //重置快进快退标志
            videoPlayer.nowIsSeeking = false;
            videoPlayer.stopPBrefresh = false;
            //重置倍速播放标志
            videoPlayer.initSpeedIndex();
            //重置setting leftover
            //重置字幕位置
            videoPlayer.subIndex = 0;
            videoPlayer.subAIndex = 0;
            //重置缩放模式位置
            videoPlayer.screenIndex = 0;
            //重置当前播放时间
            videoPlayer.videoCurrentTime = 0;
            //先隐藏DOLBY
            dolbyPic.alpha = 0;
            videoPlayer.audioTrackIndex = 0;
            videoPlayer.chapterTotalCount = 0;
            videoPlayer.chapterFlag = true;
            vChapterContainer.alpha = 0;
            videoPlayer.videoTotalTime = 0;
            videoPlayer.videoCurrentTime = 0;
            //重置字幕数组
            //subIndexArray = [0, 0, 0, 0];
            //重置字幕位置标志
            videoPlayer.needSetPosition = true;
            videoPlayer.hasPrepared = false;
            videoPlayer.stopState = false;
            if (!!vSeekToTimer) {
                clearTimeout(vSeekToTimer);
                vSeekToTimer = null;
            }
            vSeekTime = 0;
            if (!Config.tv) {
                //模拟进度条

            } else {
                //调用播放接口
                model.mpctrl.PlayMedia(vUrl, null, null, null, null, null, 4, null, null, null);

            }
            UI.setText(videoNameTitle, vName, null, null, null, true);
            UI.updateStage();
            //初始化一些参数
            videoPlayer.playerStatus = 1;
            //字幕？leftover
            //隐藏与显示进度条
            if (videoPlayer.isPBarShow == 0) {
                videoPlayer.reopenBar(false, true);
            }
            clearTimeout(videoPlayer.ControlTimer);
            videoPlayer.ControlTimer = setTimeout(function () {
                videoPlayer.hideBar();
            }, 5000);


        }
    };
    var hasSetPlayDone = false;
    var playNextTimer = null;
    var hasBuffered = false;
    videoPlayer.onVStateChanged = function (value) {
        DBG_INFO("onVStateChanged value = " + value);
        var nState = parseInt(value[2]);
        if (value[1] != videoPlayer.videoList[videoPlayer.videoIndex].videoUrl) {
            DBG_ERROR("not current url,return!!!");
            return;
        }
        if (parseInt(value[5]) & 16 && !hasSetPlayDone) {
            //关字幕
            try {
                model.mpctrl.setMpCtrlSubtitleNo(-1);
                // model.mpctrl.setMusicSubtitlePosition([10, 630, 1900, 400, 0, 0]);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
            try {
                var hasSubtitle = model.mpctrl.getHasSubtitle();
                DBG_INFO("[videoPlayer] hasSubtitle is : " + hasSubtitle);

                if (hasSubtitle == 1) {
                    videoPlayer.TitleTotalCount = 0;//如果这里不清除一次这个值，下一次无法获取到正确的字幕数MSD6586EU-464
                    videoPlayer.readSubTitleList();
                } else {
                    videoPlayer.subtitleList = [];
                    videoPlayer.setSubtitleMenu();
                }

                //dbtag:20161024
                var hasAudioStreams = model.mpctrl.getHasAudioStreams();
                DBG_INFO("[videoPlayer] AudioStreams is : " + hasAudioStreams);
                if (hasAudioStreams == 1) {
                    videoPlayer.audioTotalCount = 0;//如果这里不清除一次这个值，下一次无法获取到正确的音轨数MSD6586EU-464
                    videoPlayer.readAudioTrackList();
                } else {
                    videoPlayer.audioTrackList = [];
                    videoPlayer.setAudioTrackMenu();
                }
                try {
                    var hasChapter = model.mpctrl.getHasChapter();
                    DBG_INFO("hasChapter : " + hasChapter);
                    if (hasChapter == 1) {
                        videoPlayer.chapterTotalCount = 0;
                        videoPlayer.readChapterList();
                    } else {
                        videoPlayer.chapterData = [];
                    }
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
            hasSetPlayDone = true;
            hiMedia.endLoading("videoPlayer");
            //if (videoPlayer.isPBarShow == 0) {
            videoPlayer.reopenBar(false, false);
            //}
            clearBarTimer();
        }
        if (parseInt(value[5]) & 8) {
            DBG_INFO("SEEK DONE");
            videoPlayer.nowIsSeeking = false;
            videoPlayer.stopPBrefresh = false;
            //主动刷新一次进度条
//            if (videoPlayer.playerStatus == 0) {
            videoPlayer.videoCurrentTime = model.mpctrl.getMpCtrlPlaytimeCurrent();
            videoPB.setPercent(videoPlayer.videoCurrentTime);
            DBG_INFO("real ct = " + videoPlayer.videoCurrentTime);
//            }
        }

        if (parseInt(value[5]) & 1) {
            if (!hasBuffered) {
                hiMedia.startLoading("BUFFUR_UNDERFLOW", 10);
                hasBuffered = true;
            }
        } else {
            if (!!hasBuffered) {
                hiMedia.endLoading("BUFFUR_UNDERFLOW");
                hasBuffered = false;
            }
        }
        if (nState == hiMedia.playerstatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_INFO("drop duplicated state event" + nState);
            return;
        }
        DBG_INFO("hiMedia.playerstatus = " + hiMedia.playerstatus + " nState = " + nState);
        hiMedia.playerstatus = nState;
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        //if (currentSubModel == "videoPlayer" || isSettingPageShown()) {
        switch (parseInt(value[2])) {

            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                //同步一次UI的播放标志位
                videoPlayer.playerStatus = 1;
                controlBtn2.voiceStr = "[DMP0027]";
                UI.setImage(controlBtn2, "hiMedia/btn/icn_pause_focus.png");

                try {
                    if (APPMODULE.LayoutToast == "LayoutToast") {
                        var LayoutToast = UI.getGhostModule("LayoutToast");
                        LayoutToast.changePlayStatusForMedia(true);
                    }
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                videoPlayer.playerStatus = 0;
                controlBtn2.voiceStr = "[PI0010]";
                UI.setImage(controlBtn2, "hiMedia/btn/icn_play_focus.png");
                try {
                    pubStateMediaDmp(videoPlayer.videoList[videoPlayer.videoIndex].videoName, videoPlayer.videoTotalTime, videoPlayer.videoCurrentTime, 0, "pause", "video", "");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;

            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:


                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
                if (!videoPlayerMenu.visible && currentSubModel == "videoPlayer") {
                    UI.focusTo(controlBtn2);
                    UI.moveCursor(UI.getCurrFocus());
                }
                try {
                    videoPlayer.hasPrepared = true;
                    var mpInfo = model.mpctrl.getMetadata();
                    DBG_INFO("mpInfo:" + mpInfo.getstrings);
                    try {

                        videoPlayer.Vwidth = tv ? parseInt(mpInfo[26]) : 400;
                        videoPlayer.Vheight = tv ? parseInt(mpInfo[27]) : 400;
                        videoPlayer.resolution = videoPlayer.Vwidth + "*" + videoPlayer.Vheight;
                        videoPlayer.setScreenSize(0);
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }

                    try {
                        videoPlayer.videoTotalTime = model.mpctrl.getMpCtrlPlaytimeTotal();
                    }
                    catch (ex) {
                        DBG_ERROR("[getMpCtrlPlaytimeTotal]" + ex.message);
                    }
                    DBG_INFO("[getMpCtrlPlaytimeTotal]" + videoPlayer.videoTotalTime);
                    UI.setText(endTime, hiMedia.getTimeText(videoPlayer.videoTotalTime, "HMS"));
                    if (videoPlayer.videoTotalTime > 0) {
                        videoPB.setMax(videoPlayer.videoTotalTime);
                        //计算出长按快进的秒数
                        videoPlayer.repeatTime = videoPlayer.videoTotalTime / 40;//六秒走完全场，120毫秒一发(50=6000/120)
                    } else {
                        videoPB.setMax(videoPlayer.videoTotalTime);
                        videoPB.setPercent(0);
                    }
                    //杜比处理
                    var dolbyImg = mpInfo[31];
                    DBG_INFO("dolbyImg  : " + dolbyImg);
                    if (!!dolbyImg) {
                        if (dolbyImg.indexOf("Dolby") != -1) {
                            dolbyPic.alpha = 1;
                        }
                        else {
                            dolbyPic.alpha = 0;
                        }
                    }
                    else {
                        dolbyPic.alpha = 0;
                    }
                    //set info
                    var size = Config.language.SE1521;
                    var infoDate = Config.language.SE1521;
                    try {
                        if (!!mpInfo[24]) {
                            size = parseInt(mpInfo[24] / 1024 / 1024) + " MB";
                            //rel = model.mpctrl.getFormatInfo();
                        }
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    var infoVF = mpInfo[30] ? mpInfo[30] : Config.language.SE1521;
                    var infoAF = mpInfo[31] ? mpInfo[31] : Config.language.SE1521;
                    if (mpInfo[32] && mpInfo[33] && mpInfo[34] && mpInfo[35] && mpInfo[36] && mpInfo[37]) {
                        infoDate = mpInfo[32] + "/" + mpInfo[33] + "/" + mpInfo[34] + "," + mpInfo[35] + ":" + mpInfo[36] + ":" + mpInfo[37];
                    }
                    //infoName, infoDur, infoRel, infoDate, infoVF, infoFormat, infoAF, infoAT, infoST, infoSize
                    videoPlayer.setInfoMenu(
                        videoPlayer.videoList[videoPlayer.videoIndex].videoName,
                        videoPlayer.videoTotalTime,
                        videoPlayer.resolution,
                        infoDate,
                        infoVF,
                        "",
                        infoAF,
                        0,
                        0,
                        size);
                    if (!!videoPlayer.needUnlockKey) {
                        videoPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playVideo");
                    }

                    //设置字幕路径
                    try {
                        //model.mpctrl.setFontPathUrl(["/opt/hisenseUI/html/hisenseUI/keyboard/fonts/"]);
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
//                    model.mpctrl.MpCtrl(1);
                    //断点续播(待合入时放开)
                    if (hiMedia.currentDevice == hiMedia.device.usb) {
                        var videoId = assembleVideoId(videoPlayer.videoList[videoPlayer.videoIndex].deviceId, videoPlayer.videoList[videoPlayer.videoIndex].videoUrl)
                        var StorageTime = hiMedia.storage.getItem(videoId);
                        DBG_INFO("StorageTime:  " + StorageTime + "total time = " + videoPlayer.videoTotalTime);
                        if (!!StorageTime && StorageTime >= 180 && StorageTime < videoPlayer.videoTotalTime) {
                            try {
                                UI.pushSubModule("hiMedia", "hiMediaDialog", true, {"StorageTime": StorageTime});
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                        } else {
                            model.mpctrl.MpCtrl(1);
                        }
                    } else {
                        model.mpctrl.MpCtrl(1);
                    }


                } catch (ex) {
                    DBG_ERROR(ex.message);
                }


                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:

                //重置SETTING菜单内容。启动锁键LOADING圈 leftover
                //手动强制满进度
                if (!videoPlayer.hasPrepared) {
                    DBG_ERROR("Not Prepared!!!!");
                    break;
                }
                if (!!videoPlayer.stopPBrefresh) {
                    videoPlayer.stopState = true;
                }
                if (currentSubModel == "videoPlayer" || isSettingPageShown()) {
                    try {
                        if (!!hiMedia.resumeTimer) {
                            clearTimeout(hiMedia.resumeTimer);
                            hiMedia.resumeTimer = null;
                        }
                        videoPB.setPercent(videoPlayer.videoTotalTime);
                        //清空掉当前视频的断点记录
                        var videoId = assembleVideoId(videoPlayer.videoList[videoPlayer.videoIndex].deviceId, videoPlayer.videoList[videoPlayer.videoIndex].videoUrl)
                        if (!!videoId) {
                            hiMedia.storage.removeItem(videoId);
                        }
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }

                    playNextTimer = setTimeout(function () {
                        clearTimeout(playNextTimer);
                        playNextTimer = null;

                        if (isSettingPageShown()) {
                            UI.popSubModule();
                        }
                        if (!!videoPlayerMenu.visible) {
                            videoPlayer.closeMenu("playNextWhenStop");
                        }
                        videoPlayer.playNextWhenStop();
                    }, 500);
                } else {
                    DBG_ERROR("current subModel is " + currentSubModel + ",not videoPlayer!!");
                }
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_OPEN_FILE_FAIL:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                if (currentSubModel == "videoPlayer" || isSettingPageShown()) {
                    DBG_ERROR("real error code is : " + value[8]);
                    if (value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_PROBING_FAILED ||
                        value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_FORMAT ||
                        value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_VIDEO_FORMAT ||
                        value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_AUDIO_FORMAT ||
                        value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_VIDEO_DECODING ||
                        value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_MAIN_AUDIO_DECODING) {
                        hiMedia.toastMsg("[DMP0031]");
                    } else {
                        hiMedia.toastMsg("[BR0091]");
                    }//fileNotSupported
                    if (!!videoPlayer.needUnlockKey) {
                        videoPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playVideo");
                    }
                    //"File not supported"  leftover
                    hiMedia.endLoading("videoPlayer");
                    if (currentSubModel == "ChParLockInputDialog") {
                        UI.popSubModule();
                    }
                    videoPlayer.closeVideoPlayer();
                } else {
                    DBG_ERROR("current subModel is " + currentSubModel + ",not videoPlayer!!");
                }
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_FILE_EXPIRED:
                //"The file has expired and can not be played."   leftover
                if (currentSubModel == "videoPlayer" || isSettingPageShown()) {
                    if (!!videoPlayer.needUnlockKey) {
                        videoPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playVideo");
                    }
                    hiMedia.endLoading("videoPlayer");
                    hiMedia.toastMsg("[DMP0132]");//fileNotSupported
                    if (currentSubModel == "ChParLockInputDialog") {
                        UI.popSubModule();
                    }
                    videoPlayer.closeVideoPlayer();
                } else {
                    DBG_ERROR("current subModel is " + currentSubModel + ",not videoPlayer!!");
                }
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
                //endLoading  leftover
                if (currentSubModel == "videoPlayer" || isSettingPageShown()) {
                    if (!!videoPlayer.needUnlockKey) {
                        videoPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playVideo");
                    }
                    hiMedia.endLoading("videoPlayer");
                    if (currentSubModel == "ChParLockInputDialog") {
                        UI.popSubModule();
                    }
                    videoPlayer.closeVideoPlayer();
                } else {
                    DBG_ERROR("current subModel is " + currentSubModel + ",not videoPlayer!!");
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PVR_CHANNEL_LOCK:
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PVR_RATING_LOCK:
                //PVR password .leftover
                if (!!videoPlayer.needUnlockKey) {
                    videoPlayer.needUnlockKey = false;
                    UI.unlockAllKeys("playVideo");
                }
                hiMedia.endLoading("PVR INPUT!");
                GLOBAL.LockParentIndex = LockParent.PVRPASSWD;
                UI.pushSubModule("setting", "ChParLockInputDialog", true);

                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_BUFFUR_UNDERFLOW:
                hiMedia.startLoading("BUFFUR_UNDERFLOW", 10);
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_BUFFUR_READY:
                hiMedia.endLoading("BUFFUR_READY");
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_SEEK_DONE:
                videoPlayer.nowIsSeeking = false;
//                if (ffTime.alpha == 0) {//主要是因为短按快进时也能收到这个SEEK_DONE，与TIMER冲突了，这里主要用于长按的情况
//                    if (videoPlayer.playerStatus == 1) {
//                        UI.setImage(videoStatus, "hiMedia/play_status.png");
//                    }
//                    else {
//                        UI.setImage(videoStatus, "hiMedia/pause_status.png");
//                    }
//                }
                //               if (videoPlayer.playerStatus == 0) {
                videoPlayer.videoCurrentTime = model.mpctrl.getMpCtrlPlaytimeCurrent();
                videoPB.setPercent(videoPlayer.videoCurrentTime);
                DBG_INFO("real ct = " + videoPlayer.videoCurrentTime);
                break;
            default :
                break;
        }
        //}

    }
    videoPlayer.onVPlaytimeChanged = function (value) {
        if (!videoPlayer.stopPBrefresh) {
            try {
                //DBG_INFO("onVPlaytimeChanged   :  " + value);
                videoPlayer.videoCurrentTime = value;
                videoPB.setPercent(value);
                //快退时间至0时刷新快退按钮
                if (value == 0) {
                    videoPlayer.initSpeedIndex();
                }
                //提示下一个视频
                if (videoPlayer.videoCurrentTime == videoPlayer.videoTotalTime - 5) {

                    var str = Config.language.DMP0160;
                    switch (parseInt(localStorage.VrepeatIndex)) {
                        case 0:
                            if (videoPlayer.videoIndex < videoPlayer.videoList.length - 1) {
                                str = str.replace(/\[.*?\]/g, videoPlayer.videoList[videoPlayer.videoIndex + 1].videoName);
                                hiMedia.toastMsg(str, 4000);
                            }
                            break;
                        case 2:
                            if (videoPlayer.videoIndex < videoPlayer.videoList.length - 1) {
                                str = str.replace(/\[.*?\]/g, videoPlayer.videoList[videoPlayer.videoIndex + 1].videoName);
                                hiMedia.toastMsg(str, 4000);
                            }
                            else if (videoPlayer.videoIndex >= videoPlayer.videoList.length - 1) {
                                str = str.replace(/\[.*?\]/g, videoPlayer.videoList[0].videoName);
                                hiMedia.toastMsg(str, 4000);
                            }
                            break;
                        case 1:
                            str = str.replace(/\[.*?\]/g, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
                            hiMedia.toastMsg(str, 4000);
                            break;
                    }
                }
                pubStateMediaDmp(videoPlayer.videoList[videoPlayer.videoIndex].videoName, videoPlayer.videoTotalTime, value, 0, "play", "video", "");
            } catch (ex) {
                DBG_ERROR("[onVPlaytimeChanged]" + ex.message);
            }
        } else {
            DBG_ALWAYS("FF now!!!!");
        }

    }
    videoPlayer.resetInfoMenu = function (index, content) {
        if (videoPlayerMenu.menuData.menuVideoInfo.length <= 10) {
            DBG_INFO("menuData length" + videoPlayerMenu.menuData.menuVideoInfo.length);
            videoPlayerMenu.menuData.menuVideoInfo[index].text = content;
        }
    }
    //infoName, infoDur, infoRel, infoDate, infoVF, infoFormat, infoAF, infoAT, infoST, infoSize
    videoPlayer.setInfoMenu = function (infoName, infoDur, infoRel, infoDate, infoVF, infoFormat, infoAF, infoAT, infoST, infoSize) {
        videoPlayerMenu.menuData.menuVideoInfo = [];
        if (infoRel == "error") {
            infoRel = " ";
        }
        if (infoVF == "UNKNOWN") {
            infoVF = " ";
        }
        if (infoAF == "UNKNOWN") {
            infoAF = " ";
        }
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0051]" + ":" + infoName});//File Name
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0028]" + ":" + hiMedia.getTimeText(infoDur, "HMS")});//Duration
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3909]" + ":" + infoRel});//Video Resolution
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3910]" + ":" + infoDate});//Creation Date
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3911]" + ":" + infoVF});//Video decode
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[OT0205]" + ":" + infoFormat});//Audio Format
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3905]" + ":" + infoAF});//Audio decode
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3912]" + ":" + infoAT});//Numbers of Audio Tracks
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3913]" + ":" + infoST});//Numbers of Subtitle Tracks
        videoPlayerMenu.menuData.menuVideoInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0004]" + infoSize});//File Size
//        UI.setText(vInfoList.initSequence[0].children[2], "[DMP0051]" + ":" + infoName);
//        UI.setText(vInfoList.initSequence[1].children[2], "[SE0753]" + ":" + infoSize);
//        UI.setText(vInfoList.initSequence[2].children[2], "[DMP0005]" + infoRel);
//        UI.setText(vInfoList.initSequence[3].children[2], "[DMP0028]" + ":" + infoDur);

    }
    videoPlayer.setSubtitleMenu = function () {
        videoPlayerMenu.menuData.menuSubtitle = [];
        if (videoPlayer.subtitleList.length > 0) {
            for (var i = 0; i < videoPlayer.subtitleList.length; i++) {
                videoPlayerMenu.menuData.menuSubtitle.push({
                    "icon": "setting/ic_radiobutton_normal.png",
                    "text": videoPlayer.subtitleList[i]
                });
            }

        } else {
            videoPlayerMenu.menuData.menuSubtitle.push({
                "icon": "setting/ic_radiobutton_normal.png",
                "text": "[SE0275]"
            });
            videoPlayer.subIndex = 0;

        }
    }
    videoPlayer.setAudioTrackMenu = function () {
        videoPlayerMenu.menuData.menuAudioTrack = [];
        if (videoPlayer.audioTrackList.length > 0) {
            for (var i = 0; i < videoPlayer.audioTrackList.length; i++) {
                videoPlayerMenu.menuData.menuAudioTrack.push({
                    "icon": "setting/ic_radiobutton_normal.png",
                    "text": videoPlayer.audioTrackList[i]
                });
            }
        } else {
            videoPlayerMenu.menuData.menuAudioTrack.push({
                "icon": "setting/ic_radiobutton_normal.png",
                "text": "[SE0275]"
            });
            videoPlayer.audioTrackIndex = 0;

        }
    }
    videoPlayer.onkey_BACKSPACE = function () {
        if (!videoPlayerMenu.visible) {
            if (videoPlayer.isPBarShow == 0) {
                videoPlayer.closeVideoPlayer();
            }
            else {
                videoPlayer.hideBar();
            }
        }
        else {
            if (videoPlayer.currentMenuIndex == 0) {
                videoPlayer.closeMenu("key_back");
            }
            //else if (videoPlayer.currentMenuIndex >= 30) {
            //    videoPlayer.currentMenuIndex = 2 + videoPlayer.hpFlag;
            //    if (videoPlayer.menuArray[videoPlayer.currentMenuIndex].length > 1) {
            //        //特殊处理EM上的subtitle需求，如果EU需要可以直接去掉对EM判断即可。
            //        vMenuListContainer_2.removeAllChildren(true);
            //        UI.removeScrollbar(vMenuListContainer_2);
            //        UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
            //        videoPlayer.createSubtitleMenu(subtitleArray, vMenuListContainer_2);
            //        videoPlayer.reFocusMenu();
            //        UI.resetViewPos(vMenuListContainer_2);
            //        videoPlayerMenu.alpha = 0;
            //        videoPlayerMenu2.alpha = 1;
            //        UI.setView(vMenuListContainer_2, 780, 520);
            //        UI.focusTo(UI.getCurrFocus());
            //    }
            //}
            else {
                if (videoPlayer.openMenuByHotkey) {
                    videoPlayer.closeMenu("key_back");
                }
                videoPlayerMenu2.alpha = 0;
                videoPlayerMenu.alpha = 1;
                videoPlayer.currentMenuIndex = 0;
                vMenuListContainer.removeAllChildren(true);
                UI.removeScrollbar(vMenuListContainer);
                videoPlayer.createMenuList(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer);
                UI.setText(videoPlayerMenuName, menuNameArray[videoPlayer.currentMenuIndex]);
                videoPlayer.reFocusMenu();
                UI.resetViewPos(vMenuListContainer);
                UI.setView(vMenuListContainer, 440, 504);
                UI.addScrollbar(vMenuListContainer, 0);
                UI.focusTo(UI.getCurrFocus());
            }
            // UI.getTween(videoPlayerMenu, true).to({alpha: 0, visible: false}, 500);
        }
    };
    videoPlayer.onkey_UP = function () {
        if (!videoPlayerMenu.visible && videoPlayerPB.y != 879) {
            videoPlayer.reopenBar(true, true);
        } else {
            return true;
        }
    }
    videoPlayer.onkey_DOWN = function () {
        DBG_INFO("onkey_DOWN");
        if (!videoPlayerMenu.visible && videoPlayerPB.y != 879) {
            videoPlayer.reopenBar(false, true);
        } else {
            return true;
        }
    }
    videoPlayer.onkey_ENTER = function () {
        DBG_ALWAYS("videoPlayer.onkey_ENTER");
        if (!videoPlayerMenu.visible){
            videoPlayer.reopenBar(false, false);
            //videoPlayer.playOrPause();
        } else {
            videoPlayer.menuOKEvent();
//            if (videoPlayer.currentMenuIndex != 0) {
//                videoPlayer.closeMenu("key_enter");
//            }
        }
    };
    //MENU上的OK处理函数
    videoPlayer.menuOKEvent = function () {
        videoPlayer.refreshMenuArray();
        DBG_ALWAYS("menuOKEvent index: " + videoPlayer.currentMenuIndex);
        switch (videoPlayer.currentMenuIndex) {
            //audio track
            case (1 + videoPlayer.hpFlag):
                try {
                    var currentIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                    videoPlayer.audioTrackIndex = currentIndex;
                    if (videoPlayer.audioTrackList.length > 0) {
                        model.mpctrl.setAudioTrack(videoPlayer.audioTrackIndex);
                    }
                    var tmpStr = videoPlayer.audioTrackList[videoPlayer.audioTrackIndex];
                    DBG_ALWAYS("AUDIO_LAN : " + tmpStr);
                    if (!!tmpStr && tmpStr.indexOf("Dolby") != -1) {
                        DBG_ALWAYS("Change Dolby 1 !!");
                        dolbyPic.alpha = 1;
                    }
                    else {
                        DBG_ALWAYS("Change Dolby 0 !!");
                        dolbyPic.alpha = 0;
                    }
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                videoPlayer.changeMenuFocus();
                //videoPlayer.closeMenu("key_enter");
                break;
            //subtitle
            case (2 + videoPlayer.hpFlag):
                videoPlayer.subAIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                try {
                    if (videoPlayer.subAIndex == 0) {
                        model.mpctrl.setMpCtrlSubtitleNo(-1);
                        //model.mpctrl.setMpCtrlPvrSubtitleNo(65535);
                    } else {
                        var subtitleTotalNo = videoPlayer.subtitleList.length;
                        if (videoPlayer.subAIndex - 1 < subtitleTotalNo) {
                            DBG_INFO("set subtitle no:" + videoPlayer.subAIndex);
                            model.mpctrl.setMpCtrlSubtitleNo(videoPlayer.subAIndex - 1);
                        }
                        else {
                            model.mpctrl.setMpCtrlPvrSubtitleNo(videoPlayer.subAIndex - 1);
                        }
                    }
                    videoPlayer.closeMenu("key_enter");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                DBG_INFO("subtitle idx:" + videoPlayer.subAIndex);
                break;
            //picture size
            case (5 + videoPlayer.hpFlag):
                videoPlayer.screenIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                videoPlayer.setScreenSize(videoPlayer.screenIndex);
                videoPlayer.closeMenu("key_enter");
                break;
            //repeat mode
            case (7 + videoPlayer.hpFlag):
                var crIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                if (crIndex >= 0 && crIndex < 3) {
                    localStorage.VrepeatIndex = crIndex;
                }
                else {
                    DBG_ERROR("repeat index error!!" + crIndex);
                }
                videoPlayer.changeMenuFocus();
                //videoPlayer.closeMenu("key_enter");
                break;
            //playlist
            case (10 + videoPlayer.hpFlag):
                var cvIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                if (cvIndex >= 0) {
                    storeVCP();
                    videoPlayer.playVideoByUrl(
                        videoPlayer.videoList[cvIndex].videoUrl,
                        videoPlayer.videoList[cvIndex].videoName);
                    videoPlayer.videoIndex = cvIndex;
                } else {
                    DBG_ERROR("menuIndex error!!" + cvIndex + "cfocus is : " + UI.getCurrFocus().name);
                }
                videoPlayer.closeMenu("key_enter");
                break;
            //case (9 + videoPlayer.hpFlag):
            //    try {
            //        var crIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
            //        videoPlayer.chapterIndex = crIndex;
            //        if (crIndex >= 0) {
            //            vSeekTo(videoPlayer.chapterTimeList[crIndex],750);
            //            DBG_INFO("chapter time:" + videoPlayer.chapterTimeList[crIndex]);
            //        }else{
            //            DBG_ERROR("menuIndex error!!" + crIndex + "cfocus is : " + UI.getCurrFocus().name);
            //        }
            //    }catch (ex) {
            //        DBG_ERROR(ex.message);
            //    }
            //    videoPlayer.closeMenu("key_enter");
            //    break;
            //subtitle position size character
            //case 30:
            //case 31:
            //case 32:
            //case 33:
            //    var menuIndex = videoPlayer.currentMenuIndex - 30;
            //    var index = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
            //    if (menuIndex == 0 && (index != 0)) {
            //        changeSubMenuContent(menuIndex, index);
            //        changeSubMenuContent(1, subIndexArray[1]);
            //        changeSubMenuContent(2, subIndexArray[2]);
            //        changeSubMenuContent(3, subIndexArray[3]);
            //    } else {
            //        changeSubMenuContent(menuIndex, index);
            //    }
            //    videoPlayer.closeMenu("key_enter");
            //    break;
            case 0://init List
                videoPlayer.initIndex = vMenuListContainer.initSequence.indexOf(UI.getCurrFocus());
                videoPlayer.currentMenuIndex = videoPlayer.initIndex + 1;
                DBG_INFO("videoPlayer.currentMenuIndex     " + videoPlayer.currentMenuIndex +
                    " length : " + videoPlayer.menuArray[videoPlayer.currentMenuIndex].length);
                switch (videoPlayer.initIndex) {
                    //head phone
                    //case (videoPlayer.hpFlag - 1):
                    //    videoPlayer.currentMenuIndex = 0;
                    //    UI.pushSubModule("setting", "AudioHeadphoneVolume", true, {caller: "hiMedia"});
                    //    videoPlayer.closeMenu("key_menu_head_phone");
                    //    //特殊处理PIC MODE 跳转
                    //    break;
                    //subtitle
                    //case (1 + videoPlayer.hpFlag):
                    //    if (videoPlayer.menuArray[videoPlayer.currentMenuIndex].length > 1) {
                    //        //特殊处理EM上的subtitle需求，如果EU需要可以直接去掉对EM判断即可。
                    //        vMenuListContainer_2.removeAllChildren(true);
                    //        UI.removeScrollbar(vMenuListContainer_2);
                    //        UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                    //        videoPlayer.createSubtitleMenu(subtitleArray, vMenuListContainer_2);
                    //        videoPlayer.reFocusMenu();
                    //        UI.resetViewPos(vMenuListContainer_2);
                    //        videoPlayerMenu.alpha = 0;
                    //        videoPlayerMenu2.alpha = 1;
                    //        UI.setView(vMenuListContainer_2, 760, 520);
                    //        UI.focusTo(UI.getCurrFocus());
                    //    }
                    //    break;
                    //picture mode
                    case (2 + videoPlayer.hpFlag):
                        videoPlayer.currentMenuIndex = 0;
                        PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_MODE;
                        UI.pushSubModule("setting", "picMode", true, {caller: "hiMedia"});
                        videoPlayer.closeMenu("pic mode");
                        //特殊处理PIC MODE 跳转
                        break;
                    //sound mode
                    case (3 + videoPlayer.hpFlag):
                        videoPlayer.currentMenuIndex = 0;
                        UI.pushSubModule("setting", "AudioMode", true, {caller: "hiMedia"});
                        videoPlayer.closeMenu("snd mode");
                        break;
                    //audio only
                    case (5 + videoPlayer.hpFlag):
                        try {
                            videoPlayer.currentMenuIndex = 0;
                            model.system.setEnumScreenState(0);
                            DBG_INFO("Off the screen");
                        } catch (e) {
                            DBG_ERROR(e.message)
                        }
                        g_SystemAudioOnlyFlag = 1;
                        break;
                    //time select play
                    case (7 + videoPlayer.hpFlag):
                        videoPlayer.closeMenu("key_enter");
                        var para = {
                            curTime: videoPlayer.videoCurrentTime,
                            totalTime: videoPlayer.videoTotalTime,
                            inputIndex: 0
                        };
                        UI.pushSubModule("hiMedia", "hiMediaTimeInputPanel", true, para);
                        break;
                    //setting
                    case (10 + videoPlayer.hpFlag):
                        videoPlayer.currentMenuIndex = 0;
                        UI.pushSubModule("setting", "mainPanel", true, {caller: "hiMedia"});
                        videoPlayer.closeMenu("key_menu_setting");
                        break;
                    //else -> default
                    default :
                        vMenuListContainer_2.removeAllChildren(true);
                        UI.removeScrollbar(vMenuListContainer_2);
                        //特殊处理PVR下的audio track显示标题
                        UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                        videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
                        videoPlayer.reFocusMenu();
                        UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
                        UI.resetViewPos(vMenuListContainer_2);
                        UI.setView(vMenuListContainer_2, 760, 520);
                        UI.addScrollbar(vMenuListContainer_2, 5);
                        videoPlayerMenu.alpha = 0;
                        videoPlayerMenu2.alpha = 1;
                        if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
                            UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                        }
                        UI.focusTo(UI.getCurrFocus());
                        break;
                }
                break;
            default :

                break;
        }
    };
    videoPlayer.changeMenuFocus = function (){
        if(videoPlayer.currentMenuFocus != UI.getCurrFocus()) {
            UI.setImage(videoPlayer.currentMenuFocus.children[1], "setting/ic_radiobutton_normal.png");
            videoPlayer.currentMenuFocus = UI.getCurrFocus();
            UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
        }
    }
    videoPlayer.setScreenSize = function (index) {
        var screenWidth = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_WIDTH;
        var screenHeight = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_HEIGHT;
        var screenMode = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_MODE_NORMAL;
        videoPlayer.Vwidth = tv ? parseInt(model.mpctrl.getMetadata()[26]) : 400;
        videoPlayer.Vheight = tv ? parseInt(model.mpctrl.getMetadata()[27]) : 400;
        videoPlayer.resolution = videoPlayer.Vwidth + "*" + videoPlayer.Vheight;
        if (!tv) {
            return;
        }
        switch (index) {
            case 1:
                model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                break;
            case 0:
                //if (videoPlayer.Vheight <= screenHeight && videoPlayer.Vwidth <= screenWidth) {
                var wh = videoPlayer.Vwidth / videoPlayer.Vheight;
                if (wh < screenWidth / screenHeight) {
                    var w1 = screenHeight * wh;
                    var x1 = (screenWidth - w1) / 2;
                    model.mpctrl.setScreenPosition(createIntergerVector([x1, 0, w1, screenHeight, screenMode, 0]));
                } else if (wh > screenWidth / screenHeight) {
                    var h1 = screenWidth / wh;
                    var y1 = (screenHeight - h1) / 2;
                    model.mpctrl.setScreenPosition(createIntergerVector([0, y1, screenWidth, h1, screenMode, 0]));
                } else {
                    model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                }
                //}
                break;
            case 2:
                if (videoPlayer.Vheight <= screenHeight && videoPlayer.Vwidth <= screenWidth) {
                    var x2 = (screenWidth - videoPlayer.Vwidth) / 2;
                    var y2 = (screenHeight - videoPlayer.Vheight) / 2;
                    model.mpctrl.setScreenPosition(createIntergerVector([x2, y2, videoPlayer.Vwidth, videoPlayer.Vheight, screenMode, 0]));
                } else {
                    //超出做NORMAL处理
                    var wh = videoPlayer.Vwidth / videoPlayer.Vheight;
                    if (wh < screenWidth / screenHeight) {
                        var w1 = screenHeight * wh;
                        var x1 = (screenWidth - w1) / 2;
                        model.mpctrl.setScreenPosition(createIntergerVector([x1, 0, w1, screenHeight, screenMode, 0]));
                    } else if (wh > screenWidth / screenHeight) {
                        var h1 = screenWidth / wh;
                        var y1 = (screenHeight - h1) / 2;
                        model.mpctrl.setScreenPosition(createIntergerVector([0, y1, screenWidth, h1, screenMode, 0]));
                    } else {
                        model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                    }
                }

                break;
            default:
                DBG_ERROR("screenIndex error!!" + videoPlayer.screenIndex);
                break;

        }
    }
    videoPlayer.closeMenu = function (desc) {
        DBG_ALWAYS(desc);

        UI.clearMediaMenuTimeout();
        videoPlayerMenu2.alpha = 0;
        hiMedia.startLoading("animation", 3, true);
        //UI.getTween(videoPlayerMenu, true).to({alpha: 0, visible: false}, 120).call(function () {
        videoPlayerMenu.alpha = 0;
        videoPlayerMenu.visible = false;
        //createjs.Tween.removeTweens(UI.getCurrFocus().scale);
        try{
            UI.getCurrFocus().scale.x = UI.getCurrFocus().scale.y = 1;
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        setMemcForVideo(0);
        //重置标志位
        videoPlayer.openMenuByHotkey = false;
        if (videoPlayer.currentMenuIndex != 0) {
            videoPlayer.currentMenuIndex = 0;
            vMenuListContainer.removeAllChildren(true);
            UI.removeScrollbar(vMenuListContainer);
            videoPlayer.createMenuList(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer);
            UI.setText(videoPlayerMenuName, menuNameArray[videoPlayer.currentMenuIndex]);
            videoPlayer.reFocusMenu();
            UI.resetViewPos(vMenuListContainer);
            UI.setView(vMenuListContainer, 440, 504);
            UI.addScrollbar(vMenuListContainer, 0);
            UI.focusTo(UI.getCurrFocus());

        }
        hiMedia.endLoading("animation");
        //})
    }
    //MENU处理

    videoPlayer.onkey_MENU = function (focus, event) {

        if (!Config.tv) {
            event.keyState = 1;
        }
        if (event.keyState == 1) {
            if (!videoPlayerMenu.visible) {
                videoPlayer.refreshMenuArray();
                if (videoPlayer.currentMenuIndex == 0) {

                    vMenuListContainer.removeAllChildren(true);
                    UI.removeScrollbar(vMenuListContainer);
                    videoPlayer.createMenuList(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer);
                    UI.setText(videoPlayerMenuName, menuNameArray[videoPlayer.currentMenuIndex]);
                    videoPlayer.reFocusMenu();
                    UI.resetViewPos(vMenuListContainer);
                    UI.setView(vMenuListContainer, 440, 504);
                    UI.addScrollbar(vMenuListContainer, 0);
                    //UI.focusTo(UI.getCurrFocus());
                    //musicPlayer.createMenuList(musicPlayerMenu.menuData.menuMusicInit, mMenuListContainer);
                }

                UI.setText(videoPlayerMenuName, menuNameArray[videoPlayer.currentMenuIndex]);
                hiMedia.startLoading("animation", 3, true);
                videoPlayer.hideBar();
                //UI.getTween(videoPlayerMenu, true).to({alpha: 1, visible: true}, 120).call(function () {
                videoPlayerMenu.alpha = 1;
                videoPlayerMenu.visible = true;
                setMemcForVideo(1);
                videoPlayer.reFocusMenu();
                if (!!videoPlayer.currentMenuFocus) {
                    UI.focusTo(videoPlayer.currentMenuFocus);
                } else {
                    DBG_ERROR("Missing menu focus!!");
                }
                if (GLOBAL.SETTING_TIMEOUT_DELAY != 0) {
                    UI.setMediaMenuTimeout(function () {
                        videoPlayer.closeMenu("timeout");
                    }, GLOBAL.SETTING_TIMEOUT_DELAY);
                }
                UI.updateStage();
                hiMedia.endLoading("animation");
                //});
            }
            else {
                videoPlayer.closeMenu("key_menu");

            }
        }
        else {
            DBG_INFO("videoPlayer.onkey_MENU" + event.keyState);
        }
    }
    videoPlayer.onkey_LEFT = function () {

        if (!!videoPlayerMenu.visible) {
            return true;

        } else if (videoPlayerPB.y == 879) {
            clearBarTimer();
            return true;
        }
        else {
            if (GLOBAL.RTL) {
                videoPlayer.ff();
            }
            else {
                videoPlayer.fr();
            }

        }

    }
    videoPlayer.onkey_RIGHT = function () {
        if (!!videoPlayerMenu.visible) {
            return true;

        } else if (videoPlayerPB.y == 879) {
            clearBarTimer();
            return true;
        }
        else {
            //快进
            if (GLOBAL.RTL) {
                videoPlayer.fr();
            }
            else {
                videoPlayer.ff();
            }

        }
    }
    //subtitle和info键行为：1.在未存在menu时呼出menu并跳转到对应页面，2，在MENU存在时跳转到对应页面 3，在对应页面时隐藏MENU
    videoPlayer.onkey_INFO = function (focus, event) {
        if (!Config.tv) {
            event.keyState = 1;
        }
        if (event.keyState == 1) {
            if (!videoPlayerMenu.visible) {
                videoPlayer.refreshMenuArray();
                //videoPlayer.onkey_MENU(focus, event);
                videoPlayer.currentMenuIndex = 9 + videoPlayer.hpFlag;
                videoPlayer.openMenuByHotkey = true;
                vMenuListContainer_2.removeAllChildren(true);
                UI.removeScrollbar(vMenuListContainer_2);
                //特殊处理PVR下的audio track显示标题
                UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
                videoPlayer.reFocusMenu();
                UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
                UI.resetViewPos(vMenuListContainer_2);
                UI.setView(vMenuListContainer_2, 760, 520);
                UI.addScrollbar(vMenuListContainer_2, 5);
                videoPlayerMenu.visible = true;
                videoPlayerMenu.alpha = 0;
                videoPlayerMenu2.alpha = 1;
                UI.focusTo(UI.getCurrFocus());
            }
            else {
                if (videoPlayer.currentMenuIndex == 9 + videoPlayer.hpFlag) {
                    videoPlayer.closeMenu("key_menu");
                } else {
                    videoPlayer.currentMenuIndex = 9 + videoPlayer.hpFlag;
                    //videoPlayer.openMenuByHotkey = true;
                    vMenuListContainer_2.removeAllChildren(true);
                    UI.removeScrollbar(vMenuListContainer_2);
                    //特殊处理PVR下的audio track显示标题
                    UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                    videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
                    videoPlayer.reFocusMenu();
                    UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
                    UI.resetViewPos(vMenuListContainer_2);
                    UI.setView(vMenuListContainer_2, 760, 520);
                    UI.addScrollbar(vMenuListContainer_2, 5);
                    videoPlayerMenu.alpha = 0;
                    videoPlayerMenu2.alpha = 1;
                    UI.focusTo(UI.getCurrFocus());
                }

            }
        }
        else {
            DBG_INFO("videoPlayer.onkey_MENU" + event.keyState);
        }
    }
    //videoPlayer.onkey_SUBTITLE = function (focus, event) {
    //    if (!Config.tv) {
    //        event.keyState = 1;
    //    }
    //    if (event.keyState == 1) {
    //        if (!videoPlayerMenu.visible) {
    //            videoPlayer.refreshMenuArray();
    //
    //            videoPlayer.currentMenuIndex = 2 + videoPlayer.hpFlag;
    //            videoPlayer.openMenuByHotkey = true;
    //            if (videoPlayer.menuArray[videoPlayer.currentMenuIndex].length > 1) {
    //                //特殊处理EM上的subtitle需求，如果EU需要可以直接去掉对EM判断即可。
    //                vMenuListContainer_2.removeAllChildren(true);
    //                UI.removeScrollbar(vMenuListContainer_2);
    //                UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
    //                videoPlayer.createSubtitleMenu(subtitleArray, vMenuListContainer_2);
    //                videoPlayer.reFocusMenu();
    //                UI.resetViewPos(vMenuListContainer_2);
    //                videoPlayerMenu.visible = true;
    //                videoPlayerMenu.alpha = 0;
    //                videoPlayerMenu2.alpha = 1;
    //                UI.setView(vMenuListContainer_2, 760, 520);
    //                UI.focusTo(UI.getCurrFocus());
    //                videoPlayer.hideBar();
    //            }
    //            else {
    //                vMenuListContainer_2.removeAllChildren(true);
    //                UI.removeScrollbar(vMenuListContainer_2);
    //                //特殊处理PVR下的audio track显示标题
    //                UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
    //                videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
    //                videoPlayer.reFocusMenu();
    //                UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
    //                UI.resetViewPos(vMenuListContainer_2);
    //                UI.setView(vMenuListContainer_2, 760, 520);
    //                UI.addScrollbar(vMenuListContainer_2, 5);
    //                videoPlayerMenu.visible = true;
    //                videoPlayerMenu.alpha = 0;
    //                videoPlayerMenu2.alpha = 1;
    //                videoPlayer.hideBar();
    //                if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
    //                    UI.setImage(UI.getCurrFocus().children[1], "setting/his/ic_radiobutton_focused.png");
    //                }
    //                UI.focusTo(UI.getCurrFocus());
    //            }
    //        }
    //        else {
    //            if (videoPlayer.currentMenuIndex == 2 + videoPlayer.hpFlag) {
    //                videoPlayer.closeMenu("key_menu");
    //            } else {
    //                videoPlayer.currentMenuIndex = 2 + videoPlayer.hpFlag;
    //                if (videoPlayer.menuArray[videoPlayer.currentMenuIndex].length > 1) {
    //                    //特殊处理EM上的subtitle需求，如果EU需要可以直接去掉对EM判断即可。
    //                    vMenuListContainer_2.removeAllChildren(true);
    //                    UI.removeScrollbar(vMenuListContainer_2);
    //                    UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
    //                    videoPlayer.createSubtitleMenu(subtitleArray, vMenuListContainer_2);
    //                    videoPlayer.reFocusMenu();
    //                    UI.resetViewPos(vMenuListContainer_2);
    //                    videoPlayerMenu.alpha = 0;
    //                    videoPlayerMenu2.alpha = 1;
    //                    UI.setView(vMenuListContainer_2, 760, 520);
    //                    UI.focusTo(UI.getCurrFocus());
    //                }
    //                else {
    //                    vMenuListContainer_2.removeAllChildren(true);
    //                    UI.removeScrollbar(vMenuListContainer_2);
    //                    //特殊处理PVR下的audio track显示标题
    //                    UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
    //                    videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
    //                    videoPlayer.reFocusMenu();
    //                    UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
    //                    UI.resetViewPos(vMenuListContainer_2);
    //                    UI.setView(vMenuListContainer_2, 760, 520);
    //                    UI.addScrollbar(vMenuListContainer_2, 5);
    //                    videoPlayerMenu.alpha = 0;
    //                    videoPlayerMenu2.alpha = 1;
    //                    if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
    //                        UI.setImage(UI.getCurrFocus().children[1], "setting/his/ic_radiobutton_focused.png");
    //                    }
    //                    UI.focusTo(UI.getCurrFocus());
    //                }
    //            }
    //
    //        }
    //    }
    //    else {
    //        DBG_INFO("videoPlayer.onkey_MENU" + event.keyState);
    //    }
    //}

    videoPlayer.onkey_SUBTITLE = function (focus, event) {
        if(videoPlayer.isPBarShow == 1){
            videoPlayer.hideBar();
        }
        if (!Config.tv) {
            event.keyState = 1;
        }
        if (event.keyState == 1) {
            if (!videoPlayerMenu.visible) {
                videoPlayer.refreshMenuArray();
                //videoPlayer.onkey_MENU(focus, event);
                videoPlayer.currentMenuIndex = 2 + videoPlayer.hpFlag;
                videoPlayer.openMenuByHotkey = true;
                vMenuListContainer_2.removeAllChildren(true);
                UI.removeScrollbar(vMenuListContainer_2);
                //特殊处理PVR下的audio track显示标题
                UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
                videoPlayer.reFocusMenu();
                UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
                UI.resetViewPos(vMenuListContainer_2);
                UI.setView(vMenuListContainer_2, 760, 520);
                UI.addScrollbar(vMenuListContainer_2, 5);
                videoPlayerMenu.visible = true;
                videoPlayerMenu.alpha = 0;
                videoPlayerMenu2.alpha = 1;
                if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
                    UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                }
                UI.focusTo(UI.getCurrFocus());
            }
            else {
                if (videoPlayer.currentMenuIndex == 2 + videoPlayer.hpFlag) {
                    videoPlayer.closeMenu("key_menu");
                } else {
                    videoPlayer.currentMenuIndex = 2 + videoPlayer.hpFlag;
                    //videoPlayer.openMenuByHotkey = true;
                    vMenuListContainer_2.removeAllChildren(true);
                    UI.removeScrollbar(vMenuListContainer_2);
                    //特殊处理PVR下的audio track显示标题
                    UI.setText(videoPlayerMenuName2, menuNameArray[videoPlayer.currentMenuIndex]);
                    videoPlayer.createMenu2List(videoPlayer.menuArray[videoPlayer.currentMenuIndex], vMenuListContainer_2);
                    videoPlayer.reFocusMenu();
                    UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
                    UI.resetViewPos(vMenuListContainer_2);
                    UI.setView(vMenuListContainer_2, 760, 520);
                    UI.addScrollbar(vMenuListContainer_2, 5);
                    videoPlayerMenu.alpha = 0;
                    videoPlayerMenu2.alpha = 1;
                    if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
                        UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                    }
                    UI.focusTo(UI.getCurrFocus());
                }

            }
        }
        else {
            DBG_INFO("videoPlayer.onkey_MENU" + event.keyState);
        }
    }
    videoPlayer.closeVideoPlayerInterval = null;
    videoPlayer.playNextWhenStop = function () {
        switch (parseInt(localStorage.VrepeatIndex)) {
            case 0:
                if (videoPlayer.videoIndex < videoPlayer.videoList.length - 1) {
                    videoPlayer.videoIndex++;
                    videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);

                }
                else if (videoPlayer.videoIndex >= videoPlayer.videoList.length - 1) {
                    //处理问题MT5658SHARPU2-366
                    if ("hiMedia" == UI.getCurrModule().name) {
                        videoPlayer.closeVideoPlayer();
                    }
                    else {
                        //暂时注释掉，提交代码后添加。leftover
//                        videoPlayer.closeVideoPlayerInterval = setInterval(function () {
//                            DBG_INFO("Wait for close HOME on DMP.");
//                            if ("hiMedia" == UI.getCurrModule().name) {
//
//                                videoPlayer.closeVideoPlayer();
//                            }
//                        }, 1000);
                    }

                }
                break;
            case 2:
                if (videoPlayer.videoIndex < videoPlayer.videoList.length - 1) {
                    videoPlayer.videoIndex++;
                    videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
                }
                else if (videoPlayer.videoIndex >= videoPlayer.videoList.length - 1) {
                    videoPlayer.videoIndex = 0;
                    videoPlayer.playVideoByUrl(videoPlayer.videoList[0].videoUrl, videoPlayer.videoList[0].videoName);
                }

                break;
            case 1:

                videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl,
                    videoPlayer.videoList[videoPlayer.videoIndex].videoName);

                break;
        }

    }

    videoPlayer.closeVideoPlayer = function () {
        //leftover  3D&MEMC处理
        try {
            if (!!videoPlayer.closeVideoPlayerInterval) {
                clearInterval(videoPlayer.closeVideoPlayerInterval);
            }
            UI.popSubModule();
            hiMedia.needRefreshFB = false;
            UI.pushSubModule("hiMedia", "fileBrowser", true);

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    videoPlayer.onPop = function (to) {
        DBG_ALWAYS("[onExit]videoPlayer");
        try {
            delete CONST.KEYSET_REPEAT[CONST.KEY.VK_ENTER];
            hiMedia.setNoSignalTimeout();
            videoPlayer.resetMenu();
            videoPlayer.closeMenu("onPop");
            if (!!playNextTimer) {
                clearTimeout(playNextTimer);
                playNextTimer = null;
            }

            //退出时复位焦点缩放
            UI.getCurrFocus().scale.x = UI.getCurrFocus().scale.x = 1.0;
            clearTimeout(videoPlayer.ControlTimer);
            UI.removeMask(videoPlayerMenuList);
            UI.removeView(videoPlayerMenuList);
            UI.removeView(vMenuListContainer);
            UI.removeScrollbar(vMenuListContainer);
            //关闭所有动画：
//            createjs.Tween.removeTweens(videoPlayerTop);
//            createjs.Tween.removeTweens(videoPlayerPB);
//            createjs.Tween.removeTweens(videoPlayerMenu);

            //if (!UI.DOINGSTR) {
            model.mpctrl.MpCtrl(3);
            //}
            //断点续播
            storeVCP();
            videoPlayer.hasPrepared = false;
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, videoPlayer.onVStateChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, videoPlayer.onVPlaytimeChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, keyReleaseForFF);
            hiMedia.endLoading("onPopVideoPlayer");
            try {
                pubStateMediaDmp(videoPlayer.videoList[videoPlayer.videoIndex].videoName, videoPlayer.videoTotalTime, videoPlayer.videoCurrentTime, 0, "stop", "video", "");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
            if (APPMODULE.LayoutToast == "LayoutToast") {
                UI.popGhostModule("LayoutToast");
                APPMODULE.LayoutToast = null;
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    videoPlayer.playOrPause = function () {
        if (videoPlayer.playerStatus == 0) {
            try {
                model.mpctrl.MpCtrl(1);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            //UI.setImage(videoStatus, "hiMedia/play_status.png");
            videoPlayer.playerStatus = 1;
            DBG_INFO("change to play");
        }
        else if (videoPlayer.playerStatus == 1) {
            try {
                model.mpctrl.MpCtrl(2);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            //UI.setImage(videoStatus, "hiMedia/pause_status.png");
            videoPlayer.initSpeedIndex();
            videoPlayer.playerStatus = 0;
            DBG_INFO("change to pause");
        }
    }
    //新增四个函数快进快退，隐藏显示
    videoPlayer.reopenBar = function (focusBar, focusChapter) {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel != "videoPlayer") {
            DBG_INFO("currentSubModel is " + currentSubModel + ",can not reopenBar.");
            return;
        }
        videoPlayer.isPBarShow = 1;
        if (!!videoPlayerMenu.visible) {
            videoPlayer.closeMenu("reopenBar");
        }
        //$("#videoPlayerPanel").css("visibility", "visible");
        //UI.getTween(videoPlayerMenu, true).to({alpha: 0, visible: false}, 500);
        DBG_INFO("clear Timer");
        hiMedia.startLoading("animation", 3, true);
        if (videoPlayer.chapterTotalCount > 0) {
            vChapterContainer.alpha = 1;
        }
        videoPlayerTop.y = 32;
        videoPlayerPB.y = 879;
        DBG_ALWAYS("focusBar: " + focusBar + "focusChapter: " + focusChapter);
        if (videoPlayer.chapterTotalCount > 0 && (!!focusChapter)) {
            videoPlayer.refocusChapter();
        } else if (!!focusBar) {
            UI.focusTo(videoPBFocus);
        } else {
            UI.focusTo(controlBtn2);
        }
        hiMedia.endLoading("animation");
        try {
            setMemcForVideo(1);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        clearBarTimer();
        UI.updateStage();
    }
    videoPlayer.reopenBarNofocus = function () {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel != "videoPlayer") {
            DBG_INFO("currentSubModel is " + currentSubModel + ",can not reopenBar.");
            return;
        }
        videoPlayer.isPBarShow = 1;
        if (!!videoPlayerMenu.visible) {
            videoPlayer.closeMenu("reopenBar");
        }
        //$("#videoPlayerPanel").css("visibility", "visible");
        //UI.getTween(videoPlayerMenu, true).to({alpha: 0, visible: false}, 500);
        DBG_INFO("clear Timer");
        hiMedia.startLoading("animation", 3, true);
        if (videoPlayer.chapterTotalCount > 0) {
            vChapterContainer.alpha = 1;
        }
        videoPlayerTop.y = 32;
        videoPlayerPB.y = 879;
        hiMedia.endLoading("animation");
        try {
            setMemcForVideo(1);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        clearBarTimer();
        UI.updateStage();
    }
    videoPlayer.hideBar = function () {
        videoPlayer.isPBarShow = 0;
        vChapterContainer.alpha = 0;
        hiMedia.startLoading("animation", 3, true);
        videoPlayerPB.y = 1250;
        videoPlayerTop.y = -250;
        setMemcForVideo(0);
        UI.updateStage();
        hiMedia.endLoading("animation");
    }
    videoPlayer.refocusChapter = function () {
        for (var i = 0; i < videoPlayer.chapterTotalCount; i++) {
            vChapterContainer.initSequence[i].children[1].alpha = 0;
        }
        DBG_INFO("refocuschapter current time:" + videoPlayer.videoCurrentTime + " chaptertimelist: " + videoPlayer.chapterTimeList);
        for (var i = 0; i < videoPlayer.chapterTimeList.length; i++) {
            if (videoPlayer.videoCurrentTime <= videoPlayer.chapterTimeList[i + 1] && videoPlayer.videoCurrentTime >= videoPlayer.chapterTimeList[i]) {
                UI.focusTo(vChapterContainer.initSequence[i]);
            } else if (videoPlayer.videoCurrentTime >= videoPlayer.chapterTimeList[i + 1]) {
                UI.focusTo(vChapterContainer.initSequence[i + 1]);
            }
        }
        UI.getCurrFocus().children[1].alpha = 1;
    }
    videoPlayer.resetChapter = function () {
        if (videoPlayer.chapterTotalCount > 0) {
            vChapterContainer.removeAllChildren(true);
            videoPlayer.createChapterList(videoPlayer.chapterData, vChapterContainer);
            UI.addMask(vChapterContainer, 1840, 120, 20, 10);
            UI.setView(vChapterContainer, 1840, 120);
            UI.resetViewPos(vChapterContainer);
            for (var i = 0; i < videoPlayer.chapterTotalCount; i++) {
                vChapterContainer.initSequence[i].children[1].alpha = 0;
            }
        }
    }
    videoPlayer.onkey_PLAY = function () {
        videoPlayer.reopenBar(false, false);
        UI.callTTS("[PI0010]");
        try {
            if (videoPlayer.ffIndex != 0 || videoPlayer.frIndex != 0) {
                model.mpctrl.setMpctrlFlag(videoPlayer.ffSpeed[0]);
            } else {
                model.mpctrl.MpCtrl(1);
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
        //UI.setImage(videoStatus, "hiMedia/play_status.png");
        videoPlayer.initSpeedIndex();
        videoPlayer.playerStatus = 1;
    }
    videoPlayer.onkey_PAUSE = function () {
        videoPlayer.reopenBar(false, false);
        UI.callTTS("[DMP0027]");
        try {
            model.mpctrl.MpCtrl(2);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
//        UI.setImage(videoStatus, "hiMedia/pause_status.png");
//        videoPlayer.playerStatus = 0;
        videoPlayer.initSpeedIndex();
    }

    videoPlayer.onkey_PLAYPAUSE = function () {
        videoPlayer.reopenBar(false, false);
        if(videoPlayer.playerStatus == 0){
            UI.callTTS("[PI0010]");
        }else{
            UI.callTTS("[DMP0027]");
        }
        videoPlayer.playOrPause();
    }

    videoPlayer.onkey_FAST_FWD = function () {
        UI.callTTS("[SE1039]");
        videoPlayer.speedff();
        videoPlayer.reopenBarNofocus();
        UI.focusTo(controlBtn3);
    }
    videoPlayer.onkey_FAST_BKW = function () {
        UI.callTTS("[SE1040]");
        videoPlayer.speedfr();
        videoPlayer.reopenBarNofocus();
        UI.focusTo(controlBtn1);
        if (videoPlayer.videoCurrentTime == 0) {
            videoPlayer.initSpeedIndex();
        }
    }
    videoPlayer.onkey_STOP = function () {
        UI.callTTS("[SE0100]");
        videoPlayer.closeVideoPlayer();
    }
    videoPlayer.stopPBrefresh = false;
    function keyReleaseForFF() {
        DBG_INFO("keyReleaseForFF");
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel == "videoPlayer") {
            fLongPressCnt--;
            DBG_INFO("fLongPressCnt = " + fLongPressCnt);
            if (!!videoPlayer.stopPBrefresh && (fLongPressCnt >= 0)) {
                try {
                    if (videoPlayer.videoCurrentTime < 0) {
                        vSeekTo(0);

                    } else if (videoPlayer.videoCurrentTime >= videoPlayer.videoTotalTime) {
                        vSeekTo(videoPlayer.videoTotalTime - 1);
                        DBG_INFO("Seek to(keyRelease) " + (videoPlayer.videoTotalTime - 1));
                    } else {
                        vSeekTo(parseInt(videoPlayer.videoCurrentTime));
                        DBG_INFO("Seek to(keyRelease) " + parseInt((videoPlayer.videoCurrentTime)));
                    }

                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                if (!!vSeekToTimer) {
                    vSeekTo(vSeekTime);
                }
            }
        }
    }


    videoPlayer.ff = function () {
        if (videoPlayerPB.y != 879) {
            videoPlayer.reopenBar(true, false);
        }
        try {
            var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
            videoPlayer.videoTotalTime = model.mpctrl.getMpCtrlPlaytimeTotal();

            DBG_INFO("canSpeed___:" + canSpeed + "  CT   " + videoPlayer.videoCurrentTime + " TT " + videoPlayer.videoTotalTime);

            if (!!canSpeed && (videoPlayer.ffIndex == 0) && (videoPlayer.frIndex == 0)) {
                if (!Config.keyRep) {
                    if (!videoPlayer.nowIsSeeking) {
                        //showffTime();
                        //UI.setImage(videoStatus, "hiMedia/icon_ff.png");
                        videoPlayer.videoCurrentTime = model.mpctrl.getMpCtrlPlaytimeCurrent();
                        if (videoPlayer.videoCurrentTime + 10 > videoPlayer.videoTotalTime - 1) {
                            vSeekTo(videoPlayer.videoTotalTime - 1, 750);
                        } else {
                            DBG_INFO("seek to  :   " + (videoPlayer.videoCurrentTime + 10));
                            vSeekTo(parseInt(videoPlayer.videoCurrentTime) + 10, 750);
                        }
                    } else {
                        DBG_ERROR("Now is seeking!");
                    }
                } else {
                    if (!!ffTimeTimer) {
                        clearTimeout(ffTimeTimer);
                    }
//                    ffTime.alpha = 0;
//                    UI.setImage(videoStatus, "hiMedia/icon_ff.png");
                    if (!videoPlayer.nowIsSeeking && !videoPlayer.stopState) {
                        videoPlayer.stopPBrefresh = true;
                        fLongPressCnt = 1;
                        if (!!vSeekToTimer) {
                            clearTimeout(vSeekToTimer);
                            vSeekToTimer = null;
                        }
                        videoPlayer.videoCurrentTime = videoPlayer.videoCurrentTime + videoPlayer.repeatTime;
                        if (videoPlayer.videoCurrentTime >= videoPlayer.videoTotalTime) {
                            videoPlayer.videoCurrentTime = videoPlayer.videoTotalTime;
                        }
                        videoPB.setPercent(parseInt(videoPlayer.videoCurrentTime));

                    } else {
                        DBG_ERROR("nowIsSeeking=" + videoPlayer.nowIsSeeking + "  stopState=" + videoPlayer.stopState);
                    }
                    //videoPlayer.currentTime videoPlayer.repeatTime
                }
            } else {
                videoPlayer.nowIsSeeking = false;
                hiMedia.toastMsg("[DMP0069]");//Time seek function is not supported!
            }
            if (videoPlayerPB.y == 879) {
                clearBarTimer();
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    videoPlayer.fr = function () {
        if (videoPlayerPB.y != 879) {
            videoPlayer.reopenBar(true, false);
        }
        try {
            var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
            DBG_INFO("canSpeed___:" + canSpeed + "  CT   " + videoPlayer.videoCurrentTime + " TT " + videoPlayer.videoTotalTime);
            videoPlayer.videoTotalTime = model.mpctrl.getMpCtrlPlaytimeTotal();

            if (!!canSpeed && (videoPlayer.ffIndex == 0) && (videoPlayer.frIndex == 0)) {
                if (!Config.keyRep) {
                    if (!videoPlayer.nowIsSeeking) {

//                        showffTime();
//                        UI.setImage(videoStatus, "hiMedia/icon_fr.png");
                        videoPlayer.videoCurrentTime = model.mpctrl.getMpCtrlPlaytimeCurrent();
                        if (videoPlayer.videoCurrentTime - 10 < 0) {
                            vSeekTo(0, 750);
                        } else {
                            vSeekTo(parseInt(videoPlayer.videoCurrentTime) - 10, 750);
                        }
                    } else {
                        DBG_ERROR("Now is seeking!");
                    }
                } else {
                    if (!!ffTimeTimer) {
                        clearTimeout(ffTimeTimer);
                    }
//                    ffTime.alpha = 0;
//                    UI.setImage(videoStatus, "hiMedia/icon_fr.png");
                    if (!videoPlayer.nowIsSeeking) {
                        videoPlayer.stopPBrefresh = true;
                        fLongPressCnt = 1;
                        if (!!vSeekToTimer) {
                            clearTimeout(vSeekToTimer);
                            vSeekToTimer = null;
                        }
                        videoPlayer.videoCurrentTime = videoPlayer.videoCurrentTime - videoPlayer.repeatTime;
                        if (videoPlayer.videoCurrentTime < 0) {
                            videoPlayer.videoCurrentTime = 0;
                        }
                        videoPB.setPercent(parseInt(videoPlayer.videoCurrentTime));
                        clearBarTimer();
                    } else {
                        DBG_ERROR("Now is seeking!");
                    }
                }
            } else {
                videoPlayer.nowIsSeeking = false;
                hiMedia.toastMsg("[DMP0069]");//Time seek function is not supported!

            }
            if (videoPlayerPB.y == 879) {
                clearBarTimer();
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    videoPlayer.resetMenu = function () {
        //hiMedia.showMenuChipByIndex(circleName, videoPlayerMenuList, 0, videoPlayer.currentMenuIndex, 1223);
        videoPlayer.currentMenuIndex = 0;
        UI.setText(videoPlayerMenuName, menuNameArray[videoPlayer.currentMenuIndex]);

    }
    videoPlayer.onNormal = function (focus) {
        if (!!videoPlayerMenu.visible) {
            //createjs.Tween.removeTweens(focus.scale);
            focus.scale.x = 1;
            focus.scale.y = 1;
            UI.base.stopText(focus.children[2]);
            return true;
        } else if (videoPlayerPB.y == 879) {
            UI.updateStage();
            return true;
        }
        else {
            return false;
        }
    };
    videoPBFocus.onkey_DOWN = function () {
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            UI.focusTo(controlBtn2);
        } else {
            return true;
        }
    }
    videoPBFocus.onkey_LEFT = function () {
        if (GLOBAL.RTL) {
            videoPlayer.ff();
        }
        else {
            videoPlayer.fr();
        }
    }
    videoPBFocus.onkey_RIGHT = function () {
        if (GLOBAL.RTL) {
            videoPlayer.fr();
        }
        else {
            videoPlayer.ff();
        }
    };
    videoPBFocus.onkey_UP = function () {
        if (vChapterContainer.alpha == 1) {
            videoPlayer.refocusChapter();
        }
        return true;
    };
    vChapterContainer.onkey_DOWN = function () {
        UI.focusTo(videoPBFocus);
        return true;
    };
    vChapterContainer.onkey_ENTER = function () {
        if(videoPlayer.isPBarShow == 0){
            videoPlayer.reopenBar();
        } else{
            var ccIndex = vChapterContainer.initSequence.indexOf(UI.getCurrFocus()) + "";
            DBG_INFO("ccIndex   :  " + ccIndex);
            try {
                vSeekTo(videoPlayer.chapterTimeList[ccIndex], 750);
                for (var i = 0; i < videoPlayer.chapterTotalCount; i++) {
                    vChapterContainer.initSequence[i].children[1].alpha = 0;
                }
                UI.getCurrFocus().children[1].alpha = 1;
                DBG_INFO("chapter time:" + videoPlayer.chapterTimeList[ccIndex]);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        return false;
    };
    vChapterContainer.onFocus = function (focus) {
        UI.base.cursor.alpha = 1;
        UI.base.runText(focus.children[2]);
        hiMedia.hideListData(vChapterContainer, vChapterContainer.initSequence.indexOf(focus), 6);
        return true;
    }
    vChapterContainer.onNormal = function (focus) {
        UI.base.cursor.alpha = 0;
        UI.base.stopText(focus.children[2]);
        return true;
    }
    videoPBFocus.onFocus = function (focus) {
        UI.base.cursor.alpha = 0;
        UI.setImage(videoPBFocus, "setting/" + GLOBAL.LAUNCHER_BRAND + "/dot_progress_focus.png");
        UI.updateStage();
        //需要添加圆形焦点逻辑
        return false;
    }
    videoPBFocus.onNormal = function (focus) {

        UI.setImage(videoPBFocus, "hiMedia/btn/dot_progress_normal.png");
        UI.updateStage();
        //需要添加圆形焦点逻辑
        return false;
    }
    videoPlayer.onFocus = function (focus) {
        if (!!videoPlayerMenu.visible) {
//            UI.getTween(focus.scale).to({x: 1.05, y: 1.05}, 120, UI.ease.quartOut);
//            UI.moveCursor(UI.adjustView());
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.moveCursor(UI.adjustView());
            focus.scale.x = 1.05;
            focus.scale.y = 1.05;
            UI.base.cursor.alpha = 1;
            UI.base.cursor.visible = true;
            try {
                if (videoPlayerMenu.alpha == 1) {
                    var currentIndex = vMenuListContainer.initSequence.indexOf(UI.getCurrFocus());
                    hiMedia.hideListData(vMenuListContainer, currentIndex, 6);
                }
                else if (videoPlayerMenu2.alpha == 1) {
                    var currentIndex = vMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                    hiMedia.hideListData(vMenuListContainer_2, currentIndex, 6);
                }
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            //UI.base.cursor.scale.x = UI.base.cursor.scale.y = 1.05;

            UI.base.runText(focus.children[2]);
            return true;
//            UI.getTween(UI.base.cursor).to({scaleX: 1.05, scaleY: 1.05}, 500, UI.ease.quartOut);
        } else if (videoPlayerPB.y == 879) {
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.alpha = 1;
            UI.base.cursor.visible = true;
            UI.updateStage();
            return true;
        }
        else {
            return false;
        }

    };
    //该函数用于恢复Menu菜单中某些需要记忆的焦点位置
    videoPlayer.reFocusMenu = function () {
        switch (videoPlayer.currentMenuIndex) {
            case 0:
                //更新主菜单
                if (videoPlayer.initIndex == 0) {
                    if (videoPlayer.audioTrackList.length > 0) {
                        videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                            vMenuListContainer.initSequence[videoPlayer.initIndex];
                    } else if (videoPlayer.subtitleList.length > 0) {
                        videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                            vMenuListContainer.initSequence[videoPlayer.initIndex + 1];
                    } else {
                        videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                            vMenuListContainer.initSequence[videoPlayer.initIndex + 2];
                    }
                } else {
                    videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                        vMenuListContainer.initSequence[videoPlayer.initIndex];
                }
                break;
            case (1 + videoPlayer.hpFlag):
                //audio track
                videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                    vMenuListContainer_2.initSequence[videoPlayer.audioTrackIndex];
                break;
            case (2 + videoPlayer.hpFlag):
                //subtitle
                if (videoPlayer.subtitleList.length > 0) {
                    videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                        vMenuListContainer_2.initSequence[videoPlayer.subAIndex];
                } else {
                    videoPlayer.currFocus = vMenuListContainer_2.initSequence[0];
                }
                break;
            case (5 + videoPlayer.hpFlag):
                //picture size
                videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                    vMenuListContainer_2.initSequence[videoPlayer.screenIndex];
                break;
            case (7 + videoPlayer.hpFlag):
                //repeat mode
                videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                    vMenuListContainer_2.initSequence[parseInt(localStorage.VrepeatIndex)];
                break;
            case (10 + videoPlayer.hpFlag):
                //play list
                videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                    vMenuListContainer_2.initSequence[videoPlayer.videoIndex];
                break;
            //case 30:
            //case 31:
            //case 32:
            //case 33:
            //    try {
            //        var tmpIndex = videoPlayer.currentMenuIndex - 30;
            //        videoPlayer.currFocus = videoPlayer.currentMenuFocus =
            //            vMenuListContainer_2.initSequence[subIndexArray[tmpIndex]];
            //    }
            //    catch (ex) {
            //        DBG_ERROR(ex.message);
            //    }
            //    break;
            default :
                videoPlayer.currFocus = videoPlayer.currentMenuFocus =
                    vMenuListContainer_2.initSequence[0];
                break;
        }
    };
    //刷新MENU数组
    videoPlayer.refreshMenuArray = function () {
        videoPlayer.hpFlag = getHPState();
        if (videoPlayer.hpFlag == 0) {
            videoPlayerMenu.menuData.menuVideoInit = [
                {"icon": "hiMedia/menu/ic_audioTrack.png", "text": "[SE0380]"},//audio track
                {"icon": "hiMedia/menu/ic_subtitle.png", "text": "[SE0381]"},//subtitle
                {"icon": "hiMedia/menu/ic_PictureMode.png", "text": "[SE0003]"},//pic mode
                {"icon": "hiMedia/menu/ic_SoundMode.png", "text": "[SE0059]"},//sound mode
                {"icon": "hiMedia/menu/ic_aspect.png", "text": "[SE0461]"},//Picture size
                {"icon": "hiMedia/menu/ic_Audio_only.png", "text": "[SE0834]"},//audio only
                {"icon": "hiMedia/menu/ic_repeatMode.png", "text": "[DMP0120]"},//repeat mode
                {"icon": "hiMedia/menu/time_select_play.png", "text": "[DMP0119]"},//Time select play
                {"icon": "hiMedia/menu/ic_information.png", "text": "[SE0628]"},//info
                {"icon": "hiMedia/menu/ic_videoList.png", "text": "[DMP0095]"},//list
                {"icon": "hiMedia/menu/ic_SystemSetting.png", "text": "[DMP0123]"}//setting
            ];
            videoPlayer.menuArray = [videoPlayerMenu.menuData.menuVideoInit, videoPlayerMenu.menuData.menuAudioTrack,
                videoPlayerMenu.menuData.menuSubtitle, videoPlayerMenu.menuData.menuVideoPictureMode, ["sound mode"],
                videoPlayerMenu.menuData.menuVideoAspectRatio, ["audio only"], videoPlayerMenu.menuData.menuVideoRepeatMode, ["Time select play"],
                videoPlayerMenu.menuData.menuVideoInfo, videoPlayerMenu.menuData.menuVideoList, ["setting"]];
            menuNameArray = ["[DMP0056]", "[SE0380]", "[SE0381]", "[SE0003]", "[SE0059]",
                "[SE0461]", "[SE0834]", "[DMP0120]", "[DMP0119]", "[SE0628]", "[DMP0095]", "[DMP0123]"];
            if (hiMedia.currentDevice == hiMedia.device.pvr) {
                videoPlayerMenu.menuData.menuVideoInit[0] = {
                    "icon": "hiMedia/menu/ic_audioTrack.png",
                    "text": "[SE0380]"
                };
                menuNameArray[1] = "[SE0380]";
            } else {
                videoPlayerMenu.menuData.menuVideoInit[0] = {
                    "icon": "hiMedia/menu/ic_audioTrack.png",
                    "text": "[SE0380]"
                };
                menuNameArray[1] = "[SE0380]";
            }
        } else {
            videoPlayerMenu.menuData.menuVideoInit = [
                {"icon": "hiMedia/menu/ic_headphone_volume.png", "text": "[SE0064]"},//headphone
                {"icon": "hiMedia/menu/ic_audioTrack.png", "text": "[SE0380]"},//audio track
                {"icon": "hiMedia/menu/ic_subtitle.png", "text": "[SE0381]"},//subtitle
                {"icon": "hiMedia/menu/ic_PictureMode.png", "text": "[SE0003]"},//pic mode
                {"icon": "hiMedia/menu/ic_SoundMode.png", "text": "[SE0059]"},//sound mode
                {"icon": "hiMedia/menu/ic_aspect.png", "text": "[SE0461]"},//Picture Size
                {"icon": "hiMedia/menu/ic_Audio_only.png", "text": "[SE0834]"},//audio only
                {"icon": "hiMedia/menu/ic_repeatMode.png", "text": "[DMP0120]"},//repeat mode
                {"icon": "hiMedia/menu/time_select_play.png", "text": "[DMP0119]"},//Time select play
                {"icon": "hiMedia/menu/ic_information.png", "text": "[SE0628]"},//info
                {"icon": "hiMedia/menu/ic_videoList.png", "text": "[DMP0095]"},//list
                {"icon": "hiMedia/menu/ic_SystemSetting.png", "text": "[DMP0123]"}//setting
            ];
            videoPlayer.menuArray = [videoPlayerMenu.menuData.menuVideoInit, videoPlayerMenu.menuData.menuAudioTrack,
                videoPlayerMenu.menuData.menuSubtitle, videoPlayerMenu.menuData.menuVideoPictureMode, ["sound mode"],
                videoPlayerMenu.menuData.menuVideoAspectRatio, ["audio only"], videoPlayerMenu.menuData.menuVideoRepeatMode, ["Time select play"],
                videoPlayerMenu.menuData.menuVideoInfo, videoPlayerMenu.menuData.menuVideoList, ["setting"]];
            menuNameArray = ["[DMP0056]", "[SE0380]", "[SE0381]", "[SE0003]", "[SE0059]",
                "[SE0461]", "[SE0834]", "[DMP0120]", "[DMP0119]", "[SE0628]", "[DMP0095]", "[DMP0123]"];
            if (hiMedia.currentDevice == hiMedia.device.pvr) {
                videoPlayerMenu.menuData.menuVideoInit[1] = {
                    "icon": "hiMedia/menu/ic_audioTrack.png",
                    "text": "[SE0380]"
                };
                menuNameArray[2] = "[SE0380]";
            } else {
                videoPlayerMenu.menuData.menuVideoInit[1] = {
                    "icon": "hiMedia/menu/ic_audioTrack.png",
                    "text": "[SE0380]"
                };
                menuNameArray[2] = "[SE0380]";
            }
        }
        //if (GLOBAL.CURRENT_COUNTRY == "ISR") {
        //    subtitleLan = ["[DMP0100]", "[SE2793]", "[SE2794]", "[SE0231]", "[SE2795]", "[SE2796]", "[DMP0101]"];
        //}
        //else {
        //    subtitleLan = ["[DMP0100]", "[SE2793]", "[SE2794]", "[SE0231]", "[SE2795]", "[SE2796]"];
        //}

    }

    function getHPState() {
        return 0;//北美默认是无耳机选项
        var headphoneInsertState = tv ? model.sound.getHeadphoneInsert() : 0;
        DBG_ALWAYS("getHPState : " + headphoneInsertState);
        var tempFlag = (headphoneInsertState == 0) ? 0 : 1;
    }

    //用于区分MEDIA跳转SETTING部分页面的判断
    function isSettingPageShown() {
        DBG_INFO("[isSettingPageShown] subM= " + UI.getCurrSubModule().name);
        var result = false;
        if (!!UI.getCurrSubModule()) {
            switch (UI.getCurrSubModule().name) {
                case "picMode":
                    if (!!UI.getCurrSubModule().param && UI.getCurrSubModule().param.caller == "hiMedia") {
                        result = true;
                    }
                    else {
                        result = false;
                    }
                    break;
                case "hiMediaTimeInputPanel":
                    result = true;
                    break;
                case "SettingSysTimeSleep":
                    result = true;
                    break;
                case "ChParLockInputDialog":
                    result = true;
                    break;
                default:
                    result = false;
                    break;

            }

        } else {
            result = false;
        }
        DBG_INFO("[isSettingPageShown] result = " + result);
        return result;
    }

    //用于处理播放视频的MEMC问题
    function setMemcForVideo(status) {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel == "videoPlayer") {
            DBG_INFO("[setMemcForVideo] status = " + status);
//            因为要同时处理两种情况，一个是进度条一个是MENU菜单的隐藏消失。设置1没问题，但是在设置0时要判断下另外一个是否在显示
            if (status == 0) {
                if (videoPlayerMenu.visible || videoPlayer.isPBarShow) {
                    DBG_ERROR("no need to close memc.");
                    return;

                }
            }
            //暂时注释掉MEMC的接口调用，因为暂时没有这个处理。
            UI.setOsdShowType(status);
        }

    }

    videoPlayer.isMediaOsdShow = function () {
        return (videoPlayerMenu.visible || videoPlayer.isPBarShow);
    }
    //videoPlayer.createSubtitleMenu = function (menuData, menuList) {
    //
    //    DBG_INFO(menuList.name);
    //    var array = [];
    //    if (menuData.length > 0) {
    //        for (var i = 0; i < menuData.length; i++) {
    //            var data = {
    //                sub_bg: UI.item_bg,
    //                sub_label: menuData[i],
    //                sub_select_cmp: " "
    //            };
    //            array.push(data);
    //
    //        }
    //        var info = {
    //            template: "hiMedia_subtitle_tile",
    //            direction: CONST.GIRD_DIRECTION.H,
    //            breakNum: 1,
    //            distanceX: 0,
    //            distanceY: 10,
    //            container: menuList
    //        };
    //        Gird.create(array, info);
    //        if (!tv) {
    //            videoPlayer.subtitleList = ["off", "eng", "chi"];
    //        }
    //        var subtitleContent = [videoPlayer.subtitleList, subtitlePosition, subtitleSize, subtitleLan];
    //        for (var i = 0; i < menuData.length; i++) {
    //            //DBG_INFO(menuList.children[i].children[2].name);
    //            setSubMenu(menuList.children[i], menuList.children[i].children[2], subtitleContent[i], i, subIndexArray[i]);
    //
    //
    //        }
    //        //leftover : 这里需要计算一次焦点位置
    //
    //
    //    }
    //}

    //function setSubMenu(label, labelCmp, content, menuIndex, cIndex) {
    //    try {
    //        Select.create(labelCmp, content, undefined, true);
    //        labelCmp.selectCurrent(cIndex);
    //        label.onkey_RIGHT = function () {
    //            if (!!videoPlayerMenu.visible) {
    //                labelCmp.selectNext();
    //                var index = labelCmp.values.indexOf(labelCmp.selected);
    //                DBG_INFO("index = " + index + "menuIndex = " + menuIndex);
    //                if (menuIndex == 0 && (index != 0)) {
    //                    changeSubMenuContent(menuIndex, index);
    //                    changeSubMenuContent(1, subIndexArray[1]);
    //                    changeSubMenuContent(2, subIndexArray[2]);
    //                    changeSubMenuContent(3, subIndexArray[3]);
    //                } else {
    //                    changeSubMenuContent(menuIndex, index);
    //                }
    //                UI.updateStage();
    //            } else {
    //                return true;
    //            }
    //        };
    //        label.onkey_LEFT = function () {
    //            if (!!videoPlayerMenu.visible) {
    //                labelCmp.selectPrev();
    //                var index = labelCmp.values.indexOf(labelCmp.selected);
    //                DBG_INFO("index = " + index + "menuIndex = " + menuIndex);
    //                if (menuIndex == 0 && (index != 0)) {
    //                    changeSubMenuContent(menuIndex, index);
    //                    changeSubMenuContent(1, subIndexArray[1]);
    //                    changeSubMenuContent(2, subIndexArray[2]);
    //                    changeSubMenuContent(3, subIndexArray[3]);
    //                } else {
    //                    changeSubMenuContent(menuIndex, index);
    //                }
    //                UI.updateStage();
    //            } else {
    //                return true;
    //            }
    //        };
    //        label.onkey_ENTER = function () {
    //            if (!!videoPlayerMenu.visible) {
    //                vMenuListContainer_2.removeAllChildren(true);
    //                UI.removeScrollbar(vMenuListContainer_2);
    //                //特殊处理PVR下的audio track显示标题
    //                UI.setText(videoPlayerMenuName2, subtitleArray[menuIndex]);
    //                videoPlayer.createMenu2List(getSubMenuData(content), vMenuListContainer_2);
    //
    //                UI.addMask(videoPlayerMenuList2, 760, 520, 40, 10);
    //                UI.resetViewPos(vMenuListContainer_2);
    //                UI.setView(vMenuListContainer_2, 760, 520);
    //                UI.addScrollbar(vMenuListContainer_2, 5);
    //                videoPlayerMenu.alpha = 0;
    //                videoPlayerMenu2.alpha = 1;
    //                videoPlayer.currentMenuIndex = 30 + menuIndex;
    //                videoPlayer.reFocusMenu();
    //                if (videoPlayer.currentMenuIndex != (9 + videoPlayer.hpFlag)) {
    //                    UI.setImage(UI.getCurrFocus().children[1], "setting/his/ic_radiobutton_focused.png");
    //                }
    //                UI.focusTo(UI.getCurrFocus());
    //
    //            } else {
    //                return true;
    //            }
    //        }
    //    } catch (ex) {
    //        DBG_ERROR(ex.message);
    //    }
    //}

//    function changeSubMenuContent(menuIndex, index) {
//        subIndexArray[menuIndex] = index;
//        switch (menuIndex) {
//            case 0:
//
//                if (tv) {
//                    if (index == 0) {
//                        model.mpctrl.setMpCtrlSubtitleNo(-1);
//                        //model.mpctrl.setMpCtrlPvrSubtitleNo(65535);
//                    }
//                    else {
//                        //model.mpctrl.setMpCtrlSubtitleNo(index - 1);
//                        var subtitleTotalNo = videoPlayer.subtitleList.length;
//                        if (index - 1 < subtitleTotalNo) {
//                            DBG_INFO("set subtitle no:" + index);
//                            model.mpctrl.setMpCtrlSubtitleNo(index - 1);
//                        }
//                        else {
//                            model.mpctrl.setMpCtrlPvrSubtitleNo(index - 1);
//
//                        }
//                    }
//                }
//
//                DBG_INFO("idx:" + index);
//                break;
//            case 1:
//                if (tv) {
//                    setSubPosition(index);
//                }
//                break;
//            case 2:
//                if (tv) {
//                    switch (index) {
//                        case 0:
//                            model.mpctrl.setMpCtrlSubtitleTextSize(48);
//                            break;
//                        case 1:
//                            model.mpctrl.setMpCtrlSubtitleTextSize(60);
//                            break;
//                        case 2:
//                            model.mpctrl.setMpCtrlSubtitleTextSize(44);
//                            break;
//                        default :
//                            break;
//                    }
//                }
//                break;
//            case 3:
//                if (tv) {
//                    switch (index) {
//                        case 0:
//                            model.mpctrl.setMpCtrlSubtitleEncode(100);
//                            break;
////                        case 1://希伯来语
////                            model.mpctrl.setMpCtrlSubtitleEncode(118);
////                            break;
//                        case 1:
//                            model.mpctrl.setMpCtrlSubtitleEncode(102);
//                            break;
//                        case 2:
//                            model.mpctrl.setMpCtrlSubtitleEncode(105);
//                            break;
//                        case 3:
//                            model.mpctrl.setMpCtrlSubtitleEncode(113);
//                            break;
//                        case 4:
//                            model.mpctrl.setMpCtrlSubtitleEncode(128);
//                            break;
//                        case 5:
//                            model.mpctrl.setMpCtrlSubtitleEncode(111);
//                            break;
//                        case 6://希伯来语
//                            model.mpctrl.setMpCtrlSubtitleEncode(118);
//                            break;
//                        default :
//                            break;
//                    }
//                }
//                DBG_INFO('setMpCtrlSubtitlePos(' + index + ')');
//                break;
//
//            default :
//                break;
//        }
//    }

    //用于短暂显示快进或者快退十秒的动作
    var ffTimeTimer = null;

    function showffTime() {
        if (ffTime.alpha == 0) {
            ffTime.alpha = 1;
            //UI.updateStage();
        }
        if (!!ffTimeTimer) {
            clearTimeout(ffTimeTimer);
        }
        ffTimeTimer = setTimeout(function () {
            ffTime.alpha = 0;
            if (videoPlayer.playerStatus == 1) {
                UI.setImage(videoStatus, "hiMedia/play_status.png");
            }
            else {
                UI.setImage(videoStatus, "hiMedia/pause_status.png");
            }
//            UI.updateStage();
        }, 2000);

    }

    videoPlayer.hideFfTime = function () {
        if (!!ffTimeTimer) {
            clearTimeout(ffTimeTimer);
        }
//        ffTime.alpha = 0;
//        if (videoPlayer.playerStatus == 1) {
//            UI.setImage(videoStatus, "hiMedia/play_status.png");
//        }
//        else {
//            UI.setImage(videoStatus, "hiMedia/pause_status.png");
//        }
    }
    //FORDB
    var SubTitleListIterator = null;
    videoPlayer.readSubTitleList = function () {

        try {

            SubTitleListIterator = new TableIterator(
                model.mpctrl.createSubtitleIterator,
                true,
                [
//            {
//                field:,
//                condition:,
//                value:
//            }
                ],
                [
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_PROGRAM_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_NAME,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_LANGUAGE_CODE,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_ATTRIBUTES
                ],
                [
                    {}
                ],
                onSubTitleListIteratorEvent.bind(this));
        }
        catch (ex) {
            DBG_ERROR("model.mpctrl.createSubtitleIterator Error" + ex.message);
        }
    }

    var onSubTitleListIteratorEvent = function (event) {
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_INFO("onSubTitleListIteratorEvent event.rows.length  : " + event.rows.length);
            if (event.rows.length > 0) {
                for (var i = 0; i < event.rows.length; i++) {
                    if (i == 0) {

                        videoPlayer.subtitleList.push("[GE0006]");//off
                    } else {
                        var tmpStr = event.rows[i][3];
                        if (!tmpStr || tmpStr == "Unknown") {
                            tmpStr = "[SE0381]";
                        }
                        if (videoPlayer.subtitleList.length > 0 &&
                            videoPlayer.subtitleList.indexOf(tmpStr) != -1) {
                            videoPlayer.subtitleList.push(tmpStr + i);
                        } else {
                            videoPlayer.subtitleList.push(tmpStr);
                        }
                    }
                }
                DBG_INFO("videoSubtitleList = " + videoPlayer.subtitleList);
                videoPlayer.setSubtitleMenu();
                var result = SubTitleListIterator.disconnect();
                DBG_INFO("Disconnect result = " + result);
            }
        }
        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            var subtitleTotalNo = event.totalCount;
            videoPlayer.resetInfoMenu(8, "[SE3913]" + ":" + subtitleTotalNo);
            DBG_INFO(" SubTitleCount " + subtitleTotalNo + " TotalCount: " + videoPlayer.TitleTotalCount);
            try {
                if (videoPlayer.TitleTotalCount != subtitleTotalNo) {
                    DBG_INFO("[videoPlayer] subtitleNo is : " + subtitleTotalNo);
                    videoPlayer.TitleTotalCount = subtitleTotalNo;
                    videoPlayer.subtitleList = [];
                    if (subtitleTotalNo > 0) {
                        //SubTitleListIterator.seekToRow(0, TableIterator.SEEK_SET);
                        SubTitleListIterator.readNextRows(subtitleTotalNo);
                    }
                }
                else {
                    DBG_INFO(" same no process");
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }
    //FORDB

    var AudioTrackListIterator = null;
    videoPlayer.readAudioTrackList = function () {
        try {

            AudioTrackListIterator = new TableIterator(
                model.mpctrl.createAudiotrackIterator,
                true,
                [
//            {
//                field:,
//                condition:,
//                value:
//            }
                ],
                [
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_PROGRAM_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_NAME,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_LANGUAGE_CODE,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_STREAMS_STREAM_ATTRIBUTES
                ],
                [
                    {}
                ],
                onAudioTrackIteratorEvent.bind(this));
        }
        catch (ex) {
            DBG_ERROR("model.mpctrl.createAudiotrackIterator Error" + ex.message);
        }
    }

    var onAudioTrackIteratorEvent = function (event) {
        DBG_INFO("onAudioTrackIteratorEvent event type: " + event.type);
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_INFO("onAudioTrackIteratorEvent event.rows.length  : " + objToString(event.rows));
            if (event.rows.length > 0) {
                for (var i = 0; i < event.rows.length; i++) {
                    var tmpStr = event.rows[i][3];
                    var tmpSnd = event.rows[i][4];
                    if (!tmpStr || tmpStr == "Unknown" || tmpStr == "und") {
                        tmpStr = "[SE0380]";
                    }
                    if (!tmpSnd || tmpSnd == "UNKNOWN") {
                        tmpSnd = " ";
                    }
                    if (videoPlayer.audioTrackList.length > 0 &&
                        videoPlayer.audioTrackList.indexOf(tmpStr + "," + tmpSnd) != -1) {
                        videoPlayer.audioTrackList.push(tmpStr + i + "," + tmpSnd);
                    } else {
                        videoPlayer.audioTrackList.push(tmpStr + "," + tmpSnd);
                    }
                    var audioformat = event.rows[0][4] ? event.rows[0][4] : Config.language.SE1521;
                    videoPlayer.resetInfoMenu(5, "[OT0121]" + ":" + audioformat);
                }
                videoPlayer.setAudioTrackMenu();
                AudioTrackListIterator.disconnect();
            }
        }
        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            var audioTrackTotalNo = event.totalCount;
            DBG_INFO(" AudioCount " + audioTrackTotalNo + " TotalCount: " + videoPlayer.audioTotalCount);
            videoPlayer.resetInfoMenu(7, "[SE3912]" + ":" + audioTrackTotalNo);
            try {
                if (videoPlayer.audioTotalCount != audioTrackTotalNo) {
                    DBG_INFO("[videoPlayer] audioTrackTotalNo is : " + audioTrackTotalNo);
                    videoPlayer.audioTotalCount = audioTrackTotalNo;
                    videoPlayer.audioTrackList = [];
                    if (audioTrackTotalNo > 0) {
                        //AudioTrackListIterator.seekToRow(0, TableIterator.SEEK_SET);
                        AudioTrackListIterator.readNextRows(audioTrackTotalNo);
                    } else {
                        videoPlayer.audioTrackList.push("[SE0275]");//None
                        videoPlayer.setAudioTrackMenu();
                    }
                }
                else {
                    DBG_INFO(" same no process");
                }
            }
            catch
                (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }
    //add chapter
    var ChapterListIterator = null;
    videoPlayer.readChapterList = function () {
        try {

            ChapterListIterator = new TableIterator(
                model.mpctrl.createChapterIterator,
                true,
                [
                    //{
                    //    field:,
                    //    condition:,
                    //    value:
                    //}
                ],
                [
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_PROGRAM_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_ID,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_START_TIME,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_END_TIME,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_TITLE,
                    MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_TABLE_CHAPTER_LANGUAGE
                ],
                [
                    {}
                ],
                onChapterIteratorEvent.bind(this));
        }
        catch (ex) {
            DBG_ERROR("model.mpctrl.createChapterIterator Error" + ex.message);
        }
        ChapterListIterator.fetchTotalCount();
    }
    var onChapterIteratorEvent = function (event) {
        DBG_INFO("onChapterIteratorEvent event type: " + event.type);
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        if (currentSubModel != "videoPlayer") {
            DBG_ERROR("CurrentModule: " + currentSubModel + "can not read chapter list");
            return;
        }
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            DBG_INFO("onChapterIteratorEvent event.rows.length  : " + objToString(event.rows));
            if (event.rows.length > 0) {
                for (var i = 0; i < event.rows.length; i++) {
                    var tmpStr = event.rows[i][2];
                    var tmpName = event.rows[i][4] ? event.rows[i][4] : "[DMP0159]" + (i + 1);
                    tmpStr = parseInt(tmpStr / 1000);
                    videoPlayer.chapterData.push({
                        "icon": "hiMedia/icon_play_video.png",
                        "text": tmpName
                    });
                    videoPlayer.chapterTimeList.push(tmpStr);
                }
                if (!!videoPlayer.chapterFlag) {
                    videoPlayer.resetChapter();
                    videoPlayer.chapterFlag = false;
                }
                ChapterListIterator.disconnect();
            }
        }
        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            var chapterTotalNo = event.totalCount;
            if (chapterTotalNo == 0) {
                ChapterListIterator.disconnect();
            } else {
                DBG_INFO(" ChapterCount " + chapterTotalNo + " TotalCount: " + videoPlayer.chapterTotalCount);
                try {
                    if (videoPlayer.chapterTotalCount != chapterTotalNo) {
                        DBG_INFO("[videoPlayer] chapterTotalCount is : " + chapterTotalNo);
                        videoPlayer.chapterTotalCount = chapterTotalNo;
                        videoPlayer.chapterData = [];
                        if (chapterTotalNo > 0) {
                            ChapterListIterator.seekToRow(0, TableIterator.SEEK_SET);
                            ChapterListIterator.readNextRows(chapterTotalNo);
                        }
                    }
                    else {
                        DBG_INFO(" same no process");
                    }
                }
                catch
                    (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        }
    }


    //拼装一个唯一的视频ID用来存储断点续播的URL
    var assembleVideoId = function (deviceId, url) {
        var tmpArray = url.split("/");
        if (tmpArray.length > 5) {
            tmpArray.splice(0, 5);
            var result = deviceId + tmpArray.toString();
            DBG_INFO("assembleVideoId:" + result);
            return result;
        }
        else {
            DBG_ERROR("assemble videoId error!");
            return null;
        }

    }
    //单独把设置字幕位置作为函数处理
    var setSubPosition = function (index) {
        DBG_INFO(" MIDDLE HIGH LOW " + index);
        switch (index) {
            case 0:
                model.mpctrl.setMusicSubtitlePosition(createIntergerVector([10, 630, 1900, 400, 0, 0]));//MIDDLE
                break;
            case 1:
                model.mpctrl.setMusicSubtitlePosition(createIntergerVector([10, 590, 1900, 400, 0, 0]));//HIGH
                break;
            case 2:
                model.mpctrl.setMusicSubtitlePosition(createIntergerVector([10, 650, 1900, 400, 0, 0]));//LOW
                break;
            default :
                model.mpctrl.setMusicSubtitlePosition(createIntergerVector([10, 630, 1900, 400, 0, 0]));//MIDDLE
                break;
        }
    }


    //0410新增功能：Bar条事件处理
    controlBtn0.onkey_ENTER = function () {   //pre
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            videoPlayer.pre();
        } else {
            return true;
        }
    }
    controlBtn1.onkey_ENTER = function () {   //fr
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            videoPlayer.speedfr();
            if (videoPlayer.videoCurrentTime == 0) {
                videoPlayer.initSpeedIndex();
            }
        } else {
            return true;
        }
    }
    controlBtn2.onkey_ENTER = function () {   //playorpause
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            videoPlayer.playOrPause();
        } else {
            return true;
        }
    }
    controlBtn3.onkey_ENTER = function () {   //fr
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            videoPlayer.speedff();
        } else {
            return true;
        }
    }
    controlBtn4.onkey_ENTER = function () {   //next
        if (videoPlayerPB.y == 879) {
            clearBarTimer();
            videoPlayer.next();
        } else {
            return true;
        }
    }
    controlBtn0.onkey_UP = controlBtn1.onkey_UP =
        controlBtn2.onkey_UP = controlBtn3.onkey_UP = controlBtn4.onkey_UP = function () {
            if (videoPlayerPB.y == 879) {
                clearBarTimer();
                UI.focusTo(videoPBFocus);
                return false;
            } else {
                return true;
            }
        }
    videoPlayer.next = function () {
        if (videoPlayer.videoIndex < videoPlayer.videoList.length - 1) {
            storeVCP();
            videoPlayer.videoIndex++;
            videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
        }
        else {
            //如果是最后一个的话则从头开始播放该视频，考虑到断点续播的问题，需要先清除断点续播记录。
            var videoId = assembleVideoId(videoPlayer.videoList[videoPlayer.videoIndex].deviceId, videoPlayer.videoList[videoPlayer.videoIndex].videoUrl);
            if (!!videoId) {
                hiMedia.storage.removeItem(videoId);
            }
            videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
        }
    }
    videoPlayer.pre = function () {
        if (videoPlayer.videoIndex > 0) {
            storeVCP();
            videoPlayer.videoIndex--;
            videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
        }
        else {
            //如果是第一个的话则从头开始播放该视频，考虑到断点续播的问题，需要先清除断点续播记录。
            var videoId = assembleVideoId(videoPlayer.videoList[videoPlayer.videoIndex].deviceId, videoPlayer.videoList[videoPlayer.videoIndex].videoUrl);
            if (!!videoId) {
                hiMedia.storage.removeItem(videoId);
            }
            videoPlayer.playVideoByUrl(videoPlayer.videoList[videoPlayer.videoIndex].videoUrl, videoPlayer.videoList[videoPlayer.videoIndex].videoName);
        }
    }
    var clearBarTimer = function () {
        clearTimeout(videoPlayer.ControlTimer);
        videoPlayer.ControlTimer = setTimeout(function () {
            videoPlayer.hideBar();
        }, 5000);
    }
    //单独封装断点续播函数,列表切换以及上一首下一首切换时也要断点续播记忆
    var storeVCP = function () {
        var canSpeed = null;
        try {
            canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        DBG_INFO("param =   " + hiMedia.currentDevice + "  / " +
            videoPlayer.videoCurrentTime + "  / " +
            videoPlayer.videoTotalTime + "  / " + canSpeed);
        if (hiMedia.currentDevice == hiMedia.device.usb && (!!canSpeed)) {
            //断点续播UXD要求改为3分钟以上但存储还是按照>0来存，否则会影响判断
            if (videoPlayer.videoCurrentTime > 0 && videoPlayer.videoCurrentTime < videoPlayer.videoTotalTime) {
                DBG_INFO(videoPlayer.videoList[videoPlayer.videoIndex].deviceId + " / " + videoPlayer.videoList[videoPlayer.videoIndex].videoUrl);
                var videoId = assembleVideoId(videoPlayer.videoList[videoPlayer.videoIndex].deviceId, videoPlayer.videoList[videoPlayer.videoIndex].videoUrl);
                if (!!videoId) {
                    hiMedia.limitStorage();
                    DBG_INFO("record id : " + videoId + "   record time :  " + videoPlayer.videoCurrentTime);
                    hiMedia.storage.setItem(videoId, videoPlayer.videoCurrentTime);
                }
            }
        }
        DBG_INFO("hiMedia.storage.length:  " + hiMedia.storage.length);
    }
    var getSubMenuData = function (array) {
        var result = [];
        // {"icon": "hiMedia/menu/ic_audioTrack.png", "text": "[SE0380]"},//audio track
        if (array.length > 0) {
            for (var i = 0; i < array.length; i++) {
                var tmpJson = {
                    "icon": "setting/ic_radiobutton_normal.png",
                    "text": ""
                }
                tmpJson.text = array[i];
                result.push(tmpJson);
            }

        }
        return result;
    }
    var vSeekToTimer = null;
    var vSeekTime = 0;
    var vSeekTo = function (pos, delayTime) {
        DBG_INFO("seek to : " + pos + "  delayTime : " + delayTime);
        vSeekTime = pos;
        if (!!vSeekToTimer) {
            clearTimeout(vSeekToTimer);
            vSeekToTimer = null;
        }
        if (!delayTime) {
            try {
                videoPlayer.nowIsSeeking = true;
                model.mpctrl.setMpCtrlPlaytimeCurrent(pos);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        } else {
            vSeekToTimer = setTimeout(function () {
                try {
                    videoPlayer.nowIsSeeking = true;
                    model.mpctrl.setMpCtrlPlaytimeCurrent(pos);
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }, delayTime);
        }

    };
    videoPlayer.speedff = function () {
        if (hiMedia.currentDevice == hiMedia.device.dms) {
            hiMedia.toastMsg("[SE1396]");
        } else {
            try {
                var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
                if (!!canSpeed) {
                    if (videoPlayer.playerStatus == 0) {
                        videoPlayer.playerStatus = 1;
                    }
                    if (videoPlayer.ffIndex < 4) {
                        videoPlayer.ffIndex++;
                    }
                    else {
                        videoPlayer.ffIndex = 0;
                    }
                    if (videoPlayer.frIndex != 0) {
                        videoPlayer.frIndex = 0;
                        changeSpeedClass(videoPlayer.frIndex, controlBtn1, "hiMedia/btn/icn_backward_normal.png");
                    }
                    model.mpctrl.setMpctrlFlag(videoPlayer.ffSpeed[videoPlayer.ffIndex]);
                    DBG_INFO("FFspeed is : " + videoPlayer.ffSpeed[videoPlayer.ffIndex]);
                    changeSpeedClass(videoPlayer.ffIndex, controlBtn3, "hiMedia/btn/icn_forward_normal.png");
                } else {
                    hiMedia.toastMsg("[DMP0069]");
                }
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }
    //倍速快退
    videoPlayer.speedfr = function () {
        if (hiMedia.currentDevice == hiMedia.device.dms) {
            hiMedia.toastMsg("[SE1396]");
        } else {
            try {
                var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
                if (!!canSpeed) {
                    if (videoPlayer.playerStatus == 0) {
                        videoPlayer.playerStatus = 1;
                    }
                    if (videoPlayer.frIndex < 4) {
                        videoPlayer.frIndex++;
                    } else {
                        videoPlayer.frIndex = 0;
                    }
                    if (videoPlayer.ffIndex != 0) {
                        videoPlayer.ffIndex = 0;
                        changeSpeedClass(videoPlayer.ffIndex, controlBtn3, "hiMedia/btn/icn_forward_normal.png");
                    }
                    model.mpctrl.setMpctrlFlag(videoPlayer.frSpeed[videoPlayer.frIndex]);
                    DBG_INFO("FRspeed is : " + videoPlayer.frSpeed[videoPlayer.frIndex]);
                    changeSpeedClass(videoPlayer.frIndex, controlBtn1, "hiMedia/btn/icn_backward_normal.png");
                } else {
                    hiMedia.toastMsg("[DMP0069]");
                }
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }
    //初始化倍速
    videoPlayer.initSpeedIndex = function () {
        this.ffIndex = 0;
        this.frIndex = 0;
        changeSpeedClass(videoPlayer.ffIndex, controlBtn3, "hiMedia/btn/icn_forward_normal.png");
        changeSpeedClass(videoPlayer.frIndex, controlBtn1, "hiMedia/btn/icn_backward_normal.png");
    }
    //刷新倍速图标
    function changeSpeedClass(index, bt, img) {
        switch (index) {
            case 0:
                UI.setImage(bt, img);
                break;
            case 1:
                UI.setImage(bt, "hiMedia/btn/icn_x2.png");
                break;
            case 2:
                UI.setImage(bt, "hiMedia/btn/icn_x4.png");
                break;
            case 3:
                UI.setImage(bt, "hiMedia/btn/icn_x8.png");
                break;
            case 4:
                UI.setImage(bt, "hiMedia/btn/icn_x16.png");
                break;
            default:
                break;
        }
    }

    //set time call back
    videoPlayer.setTimeCallBack = function (seekTime) {
        if (!!seekTime) {
            try {
                vSeekTo(seekTime);
            } catch (ex) {
                DEB_ERROR(ex.message);
            }
        }
    }

};

