// Init
UI.moduleBuilder['hiMedia']['hiMediaTimeInputPanel'] = function () {

    var initData = {
        ImgBg: UI.bg_overlay,
        InputDialogBg: UI.window_bg,
        numIpt0: "setting/input_password_focused.png",
        numIpt1: "setting/input_password_normal.png",
        numIpt2: "setting/input_password_normal.png",
        Bg: UI.window_bg,
        DeleteBg: UI.item_bg,
        NumDelete: "setting/key_delete.png",
        ZeroBg: UI.item_bg,
        PreBg: UI.item_bg,
        NextBg: UI.item_bg,
        DeleteText: "[GE0014]",//"Delete"
        PreText: "[GE0011]", // "Previous",
        NextText: "[GE0010]" //"Next"
    };
    var operateData = {
        "curtimeformat": 0,
        "clearflag": 0
    }
    var template = Util.readJson("module/hiMedia/hiMediaTimeInputPanel.json");
    var hiMediaTimeInputPanel = SubModule.create(initData, template);
    var InputDialog = UI.getItem(hiMediaTimeInputPanel, "InputDialog");
    var numberInput = UI.getItem(InputDialog, "numberInput");
    var NumPadPanel = UI.getItem(hiMediaTimeInputPanel, "NumPadPanel");
    var NumPadList = UI.getItem(NumPadPanel, "NumPadList");

    var info = {
        template: "NumPadTile",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 3,
        distanceX: 40,
        distanceY: 20,
        container: NumPadList
    };
    var totalTime = 0;
    var allArray = [];
    var NumData = ["1", "2", "3", "4", "5", "6", "7", "8", "9"];
    for (var i = 0; i < 9; i++) {
        allArray.push(
            {
                tileBg: UI.item_bg,
                Num: NumData[i],
                name: "NumData" + i
            }
        )
    }
    info.container = NumPadList;
    Gird.create(allArray, info);


    hiMediaTimeInputPanel.currFocus = UI.getItem(NumPadList, "NumData0");
    hiMediaTimeInputPanel.operateData = operateData;
    var NumData2 = UI.getItem(NumPadList, "NumData2");
    var NumData5 = UI.getItem(NumPadList, "NumData5");
    var NumData6 = UI.getItem(NumPadList, "NumData6");
    var NumData7 = UI.getItem(NumPadList, "NumData7");
    var NumData8 = UI.getItem(NumPadList, "NumData8");
    var NumPadDelete = UI.getItem(NumPadPanel, "NumPadDelete");
    var NumPadZero = UI.getItem(NumPadPanel, "NumPadZero");
    var NumPadPre = UI.getItem(NumPadPanel, "NumPadPre");
    var NumPadNext = UI.getItem(NumPadPanel, "NumPadNext");

    NumData2.rightTo = "NumPadDelete";
    NumData5.rightTo = "NumPadDelete";
    NumData8.rightTo = "NumPadZero";
    NumPadDelete.leftTo = "NumData2";
    //NumPadDelete.upTo = "numIpt1";
    NumPadZero.leftTo = "NumData8";
    //numberInput.downTo = "NumData0";
    //NumPadList.upTo = "numIpt1";
    NumData6.downTo = "NumPadPre";
    NumData7.downTo = "NumPadPre";
    NumData8.downTo = "NumPadNext";
    NumPadZero.downTo = "NumPadNext";
    NumPadPre.upTo = "NumData7";
    NumPadNext.upTo = "NumPadZero";
    NumPadPre.rightTo = "NumPadNext";
    NumPadNext.leftTo = "NumPadPre";

    var noIptBar = UI.getItem(hiMediaTimeInputPanel, "numberInput");
    var noIpt0 = UI.getItem(noIptBar, "numIpt0");
    var noIpt1 = UI.getItem(noIptBar, "numIpt1");
    var noIpt2 = UI.getItem(noIptBar, "numIpt2");
    var numIpt3Txt = UI.getItem(hiMediaTimeInputPanel, "numIpt3Txt");
    var NumInfoHour = {
        initVal: "",
        min: 0,
        max: 9999,
        fontSize: 40,
        align: "center",
        color: 0xFFFFFF
    };
    var NumInfoMin = {
        initVal: "",
        min: 0,
        max: 9999,
        fontSize: 40,
        align: "center",
        color: 0xFFFFFF
    };
    var NumInfoSec = {
        initVal: "",
        min: 0,
        max: 9999,
        fontSize: 40,
        align: "center",
        color: 0xFFFFFF
    };
    NumberInput.create(noIpt0, NumInfoHour);
    NumberInput.create(noIpt1, NumInfoMin);
    NumberInput.create(noIpt2, NumInfoSec);
    numberInput.noRTL = true;
    noIpt0.nokeyRTL = true;
    noIpt1.nokeyRTL = true;
    noIpt2.nokeyRTL = true;
    function SysTimeInputInit(operateData) {
        operateData.curtimeformat = 1;
    }

    var NextText = UI.getItem(NumPadNext, "NextText");


    hiMediaTimeInputPanel.onPush = function () {
        SysTimeInputInit(hiMediaTimeInputPanel.operateData);
        initPageData(hiMediaTimeInputPanel);
        hiMediaTimeInputPanel.currFocus = UI.getItem(NumPadList, "NumData0");
        hiMediaTimeInputPanel.operateData.clearflag = 1;
        UI.updateStage();

    };
    hiMediaTimeInputPanel.onFocus = function () {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.moveCursor(UI.adjustView());
        UI.base.cursor.alpha = 1;
        UI.base.cursor.visible = true;
        UI.updateStage();
        return true;
    }
    function initPageData(submodule) {
        var time = submodule.param.curTime;
        totalTime = parseInt(submodule.param.totalTime);
        //  noIpt0.children[1].text = time.hour;
        noIpt0.setText(assembleTime(time / 3600));
        // noIpt1.children[1].text = time.min;
        noIpt1.setText(assembleTime(time % 3600 / 60));
        noIpt2.setText(assembleTime(time % 60));
        UI.setText(numIpt3Txt, assembleTime(totalTime / 3600) + ":" + assembleTime(totalTime % 3600 / 60) + ":" + assembleTime(totalTime % 60));
        hiMediaTimeInputPanel.clearFlag = true;
        hiMediaTimeInputPanel.currInputIndex = submodule.param.inputIndex;
        if (hiMediaTimeInputPanel.currInputIndex == 0) {
            UI.setText(NextText, "[GE0010]");
            UI.setImage(noIpt0, "setting/input_password_focused.png");
            UI.setImage(noIpt1, "setting/input_password_normal.png");
            UI.setImage(noIpt2, "setting/input_password_normal.png");
        } else if (hiMediaTimeInputPanel.currInputIndex == 1) {
            UI.setText(NextText, "[GE0010]");
            UI.setImage(noIpt0, "setting/input_password_normal.png");
            UI.setImage(noIpt1, "setting/input_password_focused.png");
            UI.setImage(noIpt2, "setting/input_password_normal.png");
        }
        else {
            UI.setText(NextText, "[PI0010]");
            UI.setImage(noIpt0, "setting/input_password_normal.png");
            UI.setImage(noIpt1, "setting/input_password_normal.png");
            UI.setImage(noIpt2, "setting/input_password_focused.png");
        }
    }

    NumPadList.onkey_ENTER = function () {
        DBG_INFO("NumPadList.onkey_ENTER" + hiMediaTimeInputPanel.currFocus.children[1].children[0]);
        var text = hiMediaTimeInputPanel.currFocus.children[1].children[0].text;
        setInputTxtAndIndex(text);
    };
    NumPadDelete.onkey_ENTER = function () {
        DeleteInputTxtAndIndex();
    };
    NumPadZero.onkey_ENTER = function () {
        var text = hiMediaTimeInputPanel.currFocus.children[1].children[0].text;
        DBG_INFO("NumPadZero.onkey_ENTER" + text);
        setInputTxtAndIndex(text);
    };
    NumPadNext.onkey_ENTER = function () {
        DBG_INFO("NumPadNext.onkey_ENTER");
        switch (hiMediaTimeInputPanel.currInputIndex) {
            case 0:
                setCurrIndexAndImg(0, 1);
                break;
            case 1:
                setCurrIndexAndImg(1, 2);
                break;
            case 2:
                if (isInputValid()) {
                    settingUpdateInputTime();
                    UI.popSubModule();
                }
                else {
                    //todo to popup toast to tell the input is notvalid
                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.INPUTCHECK;
                    UI.pushGhostModule("setting", "SettingSysToast")

                }

                break;
            default :
                break;
        }
        hiMediaTimeInputPanel.clearFlag = true;
    };
    function isInputValid() {
        var input1 = noIpt0.children[1].text;
        var input2 = noIpt1.children[1].text;
        var input3 = noIpt2.children[1].text;
        var hour = parseInt(input1, 10);
        var min = parseInt(input2, 10);
        var sec = parseInt(input3, 10);
        var seekToTime = hour * 3600 + min * 60 + sec;
        if (isNaN(hour) || isNaN(min) || isNaN(sec)) {
            return false;
        }
        else if (hiMediaTimeInputPanel.operateData.curtimeformat == 1
            && (min >= 60 || sec >= 60)) {
            return false;
        }
        else if (seekToTime > totalTime) {
            return false;
        }
        return true;

    }

    function settingUpdateInputTime() {
        var input1 = noIpt0.children[1].text;
        var input2 = noIpt1.children[1].text;
        var input3 = noIpt2.children[1].text;
        var hour = parseInt(input1, 10);
        var min = parseInt(input2, 10);
        var sec = parseInt(input3, 10);
        var seekToTime = hour * 3600 + min * 60 + sec;
        DBG_INFO("result is : " + seekToTime);
        var videoPlayer = UI.getSubModule("videoPlayer");
        if (!!videoPlayer) {
            videoPlayer.setTimeCallBack.call(this, seekToTime);
        }

    }

    NumPadPre.onkey_ENTER = function () {
        DBG_INFO("NumPadPre.onkey_ENTER");
        switch (hiMediaTimeInputPanel.currInputIndex) {
            case 0:
                break;
            case 1:
                setCurrIndexAndImg(1, 0);
                break;
            case 2:
                setCurrIndexAndImg(2, 1);
                break;
            default :
                break;
        }
        hiMediaTimeInputPanel.clearFlag = true;
    };
    function setInputTxtAndIndex(text) {
        if (hiMediaTimeInputPanel.currInputIndex == 0) {
            var txt = noIpt0.children[1];
            var txtNext = noIpt1.children[1];
            var tempTxt = txt.text;
            tempTxt = tempTxt + text;
            var tempinput = parseInt(text, 10);
            var tempNum = parseInt(tempTxt, 10);
            if (hiMediaTimeInputPanel.clearFlag) {
                txt.text = ((tempinput + 100) + "").substring(1);
                hiMediaTimeInputPanel.clearFlag = false;
            }
            else {
                if (tempNum >= 0 && tempNum < 99) {
                    txt.text = ((tempNum + 100) + "").substring(1);
                }
                else if (tempNum >= 99) {
                    var nextValue = tempNum % 10;
                    txtNext.text = ((nextValue + 100) + "").substring(1);
                    setCurrIndexAndImg(0, 1);
                }


            }
            UI.updateStage();
        } else if (hiMediaTimeInputPanel.currInputIndex == 1) {
            var txt = noIpt1.children[1];
            var txtNext = noIpt2.children[1];
            var tempTxt = txt.text;
            tempTxt = tempTxt + text;
            var tempinput = parseInt(text, 10);
            if (hiMediaTimeInputPanel.clearFlag) {
                txt.text = ((tempinput + 100) + "").substring(1);
                hiMediaTimeInputPanel.clearFlag = false;
            }
            else {
                var tempNum = parseInt(tempTxt, 10);
                if (tempNum >= 0 && tempNum < 60) {
                    txt.text = ((tempNum + 100) + "").substring(1);

                }
                else {
                    var nextValue = tempNum % 10;
                    txtNext.text = ((nextValue + 100) + "").substring(1);
                    //txt.text = ((nextValue + 100) + "").substring(1);
                    setCurrIndexAndImg(1, 2);
                }

            }
            UI.updateStage();
        }
        else if (hiMediaTimeInputPanel.currInputIndex == 2) {
            var txt = noIpt2.children[1];
            var tempTxt = txt.text;
            tempTxt = tempTxt + text;
            var tempinput = parseInt(text, 10);
            if (hiMediaTimeInputPanel.clearFlag) {
                txt.text = ((tempinput + 100) + "").substring(1);
                hiMediaTimeInputPanel.clearFlag = false;
            }
            else {
                var tempNum = parseInt(tempTxt, 10);
                if (tempNum >= 0 && tempNum < 60) {
                    txt.text = ((tempNum + 100) + "").substring(1);

                }
                else {
                    var nextValue = tempNum % 10;
                    //txtNext.text = ((nextValue + 100) + "").substring(1);
                    txt.text = ((nextValue + 100) + "").substring(1);

                }

            }
            UI.updateStage();
        }

    }

    function setCurrIndexAndImg(curr, next) {
        var Currtarget = UI.getItem(noIptBar, "numIpt" + curr);
        var Nexttarget = UI.getItem(noIptBar, "numIpt" + next);
        UI.setImage(Currtarget, "setting/input_password_normal.png");
        UI.setImage(Nexttarget, "setting/input_password_focused.png");
        hiMediaTimeInputPanel.currInputIndex = next;
        if (next == 2) {
            UI.setText(NextText, "[PI0010]");//"OK",
        }
        else {
            UI.setText(NextText, "[GE0010]");//"Next"
        }
    }

    function DeleteInputTxtAndIndex() {
        if (hiMediaTimeInputPanel.currInputIndex == 0) {
            noIpt0.children[1].text = noIpt0.children[1].text.slice(0, -1);
            UI.updateStage();
        } else if (hiMediaTimeInputPanel.currInputIndex == 1) {
            if (noIpt1.children[1].text != "") {
                noIpt1.children[1].text = noIpt1.children[1].text.slice(0, -1);
                UI.updateStage();
            } else {
                noIpt0.children[1].text = noIpt0.children[1].text.slice(0, -1);
                UI.updateStage();
                setCurrIndexAndImg(1, 0);
            }
        } else if (hiMediaTimeInputPanel.currInputIndex == 2) {
            if (noIpt2.children[1].text != "") {
                noIpt2.children[1].text = noIpt1.children[1].text.slice(0, -1);
                UI.updateStage();
            }
            else if (noIpt1.children[1].text != "") {
                noIpt1.children[1].text = noIpt1.children[1].text.slice(0, -1);
                UI.updateStage();
                setCurrIndexAndImg(2, 1);
            } else {
                noIpt0.children[1].text = noIpt0.children[1].text.slice(0, -1);
                UI.updateStage();
                setCurrIndexAndImg(1, 0);
            }
        }
    }

    var proIpNumKey = function (foucs, event) {
        if (event.keyState == 1) {
            var keyValue = CONST.NUMIPT_VALUE[UI.currKeyValue];
            setInputTxtAndIndex(keyValue);
        }
    };
    NumPadPanel.onkey_ZERO = proIpNumKey;
    NumPadPanel.onkey_ONE = proIpNumKey;
    NumPadPanel.onkey_TWO = proIpNumKey;
    NumPadPanel.onkey_THREE = proIpNumKey;
    NumPadPanel.onkey_FOUR = proIpNumKey;
    NumPadPanel.onkey_FIVE = proIpNumKey;
    NumPadPanel.onkey_SIX = proIpNumKey;
    NumPadPanel.onkey_SEVEN = proIpNumKey;
    NumPadPanel.onkey_EIGHT = proIpNumKey;
    NumPadPanel.onkey_NINE = proIpNumKey;
    hiMediaTimeInputPanel.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }
    function assembleTime(time) {
        return ((parseInt(time) + 100) + "").substring(1);
    }
};