// Init
UI.moduleBuilder['hiMedia']['deviceBrowser'] = function () {

    var initData = {
        deviceBG: 'hiMedia/bg_all.png',
        device_focus: 'hiMedia/device_bak.png',
        device_bottom_line: {"color": "0xFFFFFF", "alpha": "0.2"}
    };
    var template = Util.readJson("module/hiMedia/deviceBrowser.json");
    var deviceBrowser = SubModule.create(initData, template);
    deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
    var device_list = UI.getItem(deviceBrowser, "device_list");
    var device_vol_info = UI.getItem(deviceBrowser, "device_vol");
    deviceBrowser.devicesData = [];
    deviceBrowser.usbDatas = [];
    //所有dlna设备
    deviceBrowser.dlnaDatas = [];
    //某一个dlna设备
    deviceBrowser.dmsDatas = [];
    //用于区分第一次初始化时收到的USB上限通知
    deviceBrowser.HiMedia_initPage = 0;
    //用于记录pvr的临时数组
    deviceBrowser.pvrArray = [];
    //用于记录Pvr的获取次数
    deviceBrowser.pvrCount = 0;

    /**
     *Functions for deviceBrowser
     * @returns {*}
     */
    deviceBrowser.getUsbList = function () {
        var testStr = "";
        try {
            testStr = Hisense.File.read("usbs", 0);
        }
        catch (e) {
            DBG_ALWAYS(e.message);

        }
        DBG_ALWAYS("get usb list:" + testStr);
        if (isNaN(testStr)) {
            if (testStr.split("\n").length > 0) {
                return uniqueList(testStr.split("\n"));

            }
            else {
                DBG_ALWAYS("NO USB DEVICE NOW!!!!");
                return null;
            }
        }
        else {
            DBG_ERROR("Can't read the file :  /tmp/usbs!");
            return null;
        }
    }
    function uniqueList(arr) {
        var arrTmp = [];
        for (var i = 0; i < arr.length; i++) {

            if (!!arr[i])
                if (arrTmp.indexOf(arr[i]) == -1) {
                    arrTmp.push(arr[i]);
                }
        }
        return arrTmp;
    }

    /**
     * init begin!
     */
    deviceBrowser.getInitDeviceData = function () {
        var tmpDeviceList = [];
        try {
            DBG_INFO("hiMedia.volumesList:" + objToString(hiMedia.volumesList));
            tmpDeviceList = tmpDeviceList.concat(hiMedia.volumesList);
//            //倒序排列U盘
//            try {
//                tmpDeviceList.reverse();
//            } catch (ex) {
//                DBG_ERROR(ex.message);
//            }
            if (!!hiMedia.M_PVR) {
                var pvrFolderEntr = {deviceId: "usbid", deviceName: "PVR", deviceType: "pvr"};
                tmpDeviceList.push(pvrFolderEntr);
            }
            var dlnaForderEntr = {deviceId: "usbid", deviceName: "[SE0182]", deviceType: "dlna"};
            tmpDeviceList.push(dlnaForderEntr);
//            var dropBoxEntr = {deviceId: "usbid", deviceName: "Dropbox", deviceType: "cloud"};
//            tmpDeviceList.push(dropBoxEntr);

            // tmpDeviceList;
            return tmpDeviceList;
        } catch (ex) {
            DBG_ERROR("init Error!! " + ex.message);
            return tmpDeviceList;
        }
    }

    deviceBrowser.createDeviceGrid = function (dDdata, needReresh) {
        DBG_INFO("deviceBrowser.createDeviceGrid" + objToString(dDdata));
        var array = [];
        for (var i = 0; i < dDdata.length; i++) {
            var data = { device_img: "hiMedia/" + dDdata[i].deviceType + ".png",
                device_name: dDdata[i].deviceName
//                device_bak: "hiMedia/device_bak.png"
            };
            array.push(data);
        }

        var info = {
            template: "hiMedia_device_tileItem",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 4,
            distanceX: 140,
            distanceY: 120,
            container: device_list
        };
        Gird.create(array, info);
        hiMedia.currFocus = deviceBrowser.currFocus = device_list.children[0];
        var device_focus = UI.getItem(deviceBrowser, "device_focus");
//        device_list.addChildAt(device_focus, 0);
//        UI.moveTop(deviceBrowser.currFocus);
        //device_list.children[0].addChild(device_focus);
        if (UI.getCurrModule().name == "hiMedia") {
            UI.focusTo(UI.getCurrFocus());
        }
        if (!needReresh) {
            UI.resetViewPos(device_list);
            UI.setView(device_list, 1670, 700);
            UI.addMask(device_list, 1670, 700, 55, 55);
            UI.addScrollbar(device_list, 55);
        } else {
            try {
                UI.removeView(device_list);
                UI.removeMask(device_list);
                UI.removeScrollbar(device_list);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            UI.resetViewPos(device_list);
            UI.setView(device_list, 1670, 700);
            UI.addMask(device_list, 1670, 700, 55, 55);
            UI.addScrollbar(device_list, 55);
        }
//        UI.setView(deviceBrowser, 1920, 1080);
        setTimeout(function () {
            UI.updateStage();
        }, 500);

//        for (var i = 0; i < device_list.children.length; i++) {
//            var bg = UI.getItem(device_list.children[i], "device_bak");
//            bg.alpha = 0;
//        }
    }

    deviceBrowser.getDeviceSize = function (callback) {
        try {
            var retArr = [];
            var judArr = [];
            var currentIdx = device_list.initSequence.indexOf(UI.getCurrFocus());
            var deviceId = deviceBrowser.devicesData[currentIdx].deviceId;
            //UUID
            var UUID = deviceId.split("//")[1];
            if(!!UUID) {
        model.volume.setFilesUUID(UUID.toString());
            }
            setTimeout(function () {
            var tempTotalsize = model.volume.getRecordMediumTotalSpace();
            var tempFreesize = model.volume.getRecordMediumFreeSpace();
                //格式转换
                judArr[0] = tempTotalsize;
                judArr[1] = tempFreesize;
                retArr[0] = generateParStr(tempTotalsize);
                retArr[1] = generateParStr(tempFreesize);
                callback(retArr,judArr);
            }, 100)
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    var setDeviceSize = function (retArr,judArr) {
        var currentIdx = device_list.initSequence.indexOf(UI.getCurrFocus());
        var TotalSize = retArr[0];
        var FreeSize = retArr[1];
        var deviceType = deviceBrowser.devicesData[currentIdx].deviceType;
        DBG_ALWAYS("deviceBrowser.setDeviceSize, type: " + deviceType
            + ", volume: " + TotalSize + ", leftVol:" + FreeSize);
        if (!!deviceType && deviceType == "usb") {
            if (!!TotalSize && judArr[0] != 0) {
                device_vol_info.visible = true;
                if (!!FreeSize && judArr[1] != 0) {
                    UI.setText(device_vol_info, "[TV0131]: " + TotalSize
                        + ",  [TV0130]: " + FreeSize);
                } else {
                    UI.setText(device_vol_info, "[TV0131]: " + TotalSize);
                }
            } else {
                device_vol_info.visible = false;
            }
        } else {
            device_vol_info.visible = false;
        }
    }
    var generateParStr = function (num) {
        var str;
        if (num > 100) {
            num /= 1024;
            if (num > 100) {
                str = (num / 1024).toFixed(1) + "TB";
            } else {
                str = num.toFixed(1) + "GB";
            }
        } else {
            str = num.toFixed(1) + "MB";
        }
        return str;
    };

    // appTiles.upTo = "mainTiles";

    var device_focus = UI.getItem(deviceBrowser, "device_focus");
    deviceBrowser.onkey_BACKSPACE = function () {
        DBG_ALWAYS("onkey_BACKSPACE deviceBrowser.currentState: " + deviceBrowser.currentState);
        switch (deviceBrowser.currentState) {
            case hiMedia.DEVICE_INIT_PAGE:
                UI.popAllModule();
                if (!!deviceBrowser.param && deviceBrowser.param.caller == "launcher") {
                    UI.pushModule("launcher");
                } else {
                    openLiveTVModule();
                }
                break;
            case hiMedia.DEVICE_DLNA_PAGE:
                try {
                    device_list.removeAllChildren();
                    deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                    deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                    deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                    hiMedia.currentDevice = hiMedia.device.usb;
                    var nIndex = device_list.children.length;
                    DBG_ALWAYS("index = " + nIndex);
                    if (nIndex > 1) {
                        deviceBrowser.currFocus = device_list.children[nIndex - 1];
                        deviceBrowser.lastFocus = device_list.children[nIndex - 1];

                        //DBG_ALWAYS(deviceBrowser.currFocus.name);
                    } else {
                        var cIndex = checkCurrentFilePath();
                        deviceBrowser.currFocus = device_list.children[cIndex];
                        deviceBrowser.lastFocus = device_list.children[cIndex];
                    }
                    DBG_ALWAYS("deviceBrowser.currFocus = " + deviceBrowser.currFocus.name);
                    UI.focusTo(deviceBrowser.currFocus);
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            case hiMedia.DEVICE_PVR_PAGE:
                try {
                    device_list.removeAllChildren();
                    deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                    deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                    deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                    var nIndex = device_list.children.length;
                    DBG_ALWAYS("index = " + nIndex);
                    if (nIndex > 2) {
                        deviceBrowser.currFocus = device_list.children[nIndex - 2];
                        deviceBrowser.lastFocus = device_list.children[nIndex - 2];

                        //DBG_ALWAYS(deviceBrowser.currFocus.name);
                    } else {
                        var cIndex = checkCurrentFilePath();
                        deviceBrowser.currFocus = device_list.children[cIndex];
                        deviceBrowser.lastFocus = device_list.children[cIndex];
                    }
                    UI.focusTo(deviceBrowser.currFocus);
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
                break;
            default :
                DBG_ERROR("Current state is error!" + deviceBrowser.currentState);
                break;
        }

    };
    deviceBrowser.onkey_ENTER = function () {
        DBG_INFO("[onkey_ENTER]");
//        if (!Config.tv) {
//            deviceBrowser.visible = false;
//            UI.pushSubModule("hiMedia", "fileBrowser", true);
//        } else {

        var currentIndex = device_list.initSequence.indexOf(UI.getCurrFocus());
        var currentType = deviceBrowser.devicesData[currentIndex].deviceType;
        var currentPath = deviceBrowser.devicesData[currentIndex].deviceId;
        hiMedia.searchMode = false;
        hiMedia.devicePath = currentPath;
        hiMedia.deviceName = deviceBrowser.devicesData[currentIndex].deviceName;
        DBG_INFO("[onkey_ENTER] currentType:" + currentType);
        switch (currentType) {
            case "usb":
                if (Config.tv) {
                    //deviceBrowser.visible = false;
                    try {
                        //在获取数据之后再打开FB

                        hiMedia.showUsbDetail(currentPath, "/", null);
                    } catch (ex) {
                        DBG_ERROR("Open Usb error:" + ex.message);
                    }
                } else {

                    hiMedia.needRefreshFB = true;
                    UI.pushSubModule("hiMedia", "fileBrowser", true);

                }

                break;
            case "dlna":
                if (!Config.tv) {
                    device_list.removeAllChildren();
                    deviceBrowser.devicesData = [
                        {deviceId: "id", deviceName: "Twonky", deviceType: "dms"}
                    ];
                    //{deviceId: event.rows[i][0], deviceName: event.rows[i][1], deviceType: "dms"}
                    DBG_INFO(deviceBrowser.devicesData.length);

                    device_list.removeAllChildren();
                    deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                    hiMedia.endLoading("getDmpDevices");
                    deviceBrowser.currentState = hiMedia.DEVICE_DLNA_PAGE;
                    //hiMedia.currentDevice = hiMedia.device.dms;


                }
                else {
                    try {
                        if (!!getNetworkSatus()) {
                            deviceBrowser.getDmpDevices(VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP);
                        }
                        else {
                            //hiMedia.toastMsg("[LA0006]");
                            UI.pushSubModule("hiMedia", "hiMediaTips", true);
                        }
                    } catch (ex) {
                        DBG_ERROR("Open DMP error:" + ex.message);
                    }
                }
                break;
            case "dms":
                if (!Config.tv) {
                    //deviceBrowser.visible = false;
                    hiMedia.needRefreshFB = true;
                    //这里不需要dms打开而是在获取完数据之后打开。
                    UI.pushSubModule("hiMedia", "fileBrowser", true);
                } else {
                    try {

                        hiMedia.showDmpDetail(currentPath, 0, 92, false);
                    } catch (ex) {
                        DBG_ERROR("Open Usb error:" + ex.message);
                    }
                }
                break;
            case "cloud":
                if (!!getNetworkSatus()) {
                    startDropbox();
                }
                else {
                    hiMedia.toastMsg("[LA0006]");
                }
                break;
            case "pvr":
                if (!Config.tv) {
                    deviceBrowser.devicesData = [
                        {deviceId: "id", deviceName: "Twonky", deviceType: "pvrFolder"}
                    ];
                    //{deviceId: event.rows[i][0], deviceName: event.rows[i][1], deviceType: "dms"}
                    DBG_INFO(deviceBrowser.devicesData.length);
                    device_list.removeAllChildren();
                    deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                    hiMedia.endLoading("getDmpDevices");
                    deviceBrowser.currentState = hiMedia.DEVICE_DLNA_PAGE;
                    //hiMedia.currentDevice = hiMedia.device.dms;
                }
                else {
                    try {
                        deviceBrowser.pvrArray = [];
                        deviceBrowser.pvrCount = 0;
                        hiMedia.startLoading("enterPvr", 5);
                        deviceBrowser.getPvrVolume(pvrCallBack);


                    } catch (ex) {
                        DBG_ERROR("Open DMP error:" + ex.message);
                    }
                }
                break;
            case "pvrFolder":
                if (!Config.tv) {
                    //deviceBrowser.visible = false;
                    hiMedia.needRefreshFB = true;
                    //这里不需要dms打开而是在获取完数据之后打开。
                    UI.pushSubModule("hiMedia", "fileBrowser", true);
                } else {
                    try {
                        hiMedia.showPvrDetail(currentPath);
                    } catch (ex) {
                        DBG_ERROR("Open Usb error:" + ex.message);
                    }
                }
                break;

            default :
                break;
        }
//        }
    };
    deviceBrowser.keyFlag = "up";
    deviceBrowser.onkey_UP = function (focus) {
        deviceBrowser.keyFlag = "up";
        return true;

    }
    deviceBrowser.ready = false;
    deviceBrowser.onkey_DOWN = function (focus) {
        deviceBrowser.keyFlag = "down";
        if (!focus.downTo) {
            var index = device_list.initSequence.indexOf(focus);
            if (index % device_list.breakNum != 0) {
                UI.focusTo(device_list.initSequence[device_list.initSequence.length - 1]);
            }
        } else {
            return true;
        }
    }
    var focusDis = 0;
    deviceBrowser.onFocus = function (target) {

        if ((!!hiMedia.devceBrowserEnable) && (!!deviceBrowser.ready)) {
            DBG_INFO("deviceBrowser.onFocus");
            DBG_ALWAYS("device_focus1 :  " + device_focus.x + "*" + device_focus.y);
            UI.refreshView(device_list, target);
            var retPoint = UI.adjustView();
            focusDis = focusDis + retPoint.y - 286;
            device_focus.x = target.x + 180;
            var tmpY = target.y - focusDis + 286;
            DBG_ALWAYS("device_focus.y = " + device_focus.y +
                ";tmpY = " + tmpY + " ;target.y:" + target.y +
                " ; focusDis:" + focusDis + " ;retPoint.y = " + retPoint.y + "device : " + deviceBrowser.visible);
            if (tmpY >= 825 || tmpY < 400) {
                if (deviceBrowser.keyFlag == "up") {
                    device_focus.y = 425;
                } else {
                    device_focus.y = 825;
                }
            }
            else {
                device_focus.y = tmpY;
            }
            DBG_ALWAYS("device_focus2 :  " + device_focus.x + "*" + device_focus.y);
            UI.updateStage();
            UI.base.runText(target);
            //对焦时刷新磁盘空间
            deviceBrowser.getDeviceSize(setDeviceSize);
            // UI.getTween(device_focus).to({x: target.x + 130, y: target.y + 256}, 500, UI.ease.quartOut);
            deviceBrowser.lastFocus = deviceBrowser.currFocus;
        }
        if (!!deviceBrowser.visible) {
            return true;
        } else {
            return false;
        }
    };

    deviceBrowser.onNormal = function (target) {
        UI.base.stopText(target);
        //    UI.getItem(deviceBrowser.currFocus, "device_bak").alpha = 0;
    };
    //获取DMP设备,FORDB,DB改为获取所有设备都通过该方法
    var m_volumeMainIterator = null;
    deviceBrowser.getDmpDevices = function (deviceType) {
        hiMedia.startLoading("getDmpDevices", 15, true);
        DBG_INFO("[getDmpDevices]");
        try {
            m_volumeMainIterator = new TableIterator(
                model.volume.createTableMainIterator,
                true,
                [
                    {
                        field: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_STATE,
                        condition: Model.FIELD_COND_EQUAL,
                        value: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_STATE_CONNECTED
                    }
                ],
                [
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_ID,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_NAME,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_TYPE,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_STATE,
                    VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_SUBSTATE

                ],
                [
                    { field: VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_TABLE_FIELD_NAME, direction: 1 }
                ],
                onVolumeMainIteratorEvent.bind(this, deviceType)
            );
        }
        catch (e) {
            DBG_ERROR(e.message);
        }
        //m_volumeMainIterator.fetchTotalCount();

    }

    var onVolumeMainIteratorEvent = function (deviceType, event) {
        //HiFileBrowser.InitDeviceDatas = [];
        DBG_INFO("[onVolumeMainIteratorEvent]Show all DEVICE:" + JSON.stringify(event));
        switch (event.type) {
            case TableIterator.EVENT_TYPE_ROWS_READ:
                if (deviceType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP) {
                    DBG_INFO("[onVolumeMainIteratorEvent]Show all the DLNA DEVICE:" + JSON.stringify(event.rows));
                    if (event.rows.length > 0) {
                        var tmpDeviceList = [];
                        for (var i = 0; i < event.rows.length; i++) {
                            var tempId = event.rows[i][0];
                            var tempType = event.rows[i][2];
                            var tempName = event.rows[i][1];
                            if (tempType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP) {
                                tmpDeviceList.push({deviceId: tempId, deviceName: tempName, deviceType: "dms"});
                            }
                        }
                    } else {
                        DBG_ERROR("length less than 0.");
                    }
                    //REFRESH GRID VIEW
                    if (tmpDeviceList.length > 0) {
                        deviceBrowser.devicesData = tmpDeviceList;
                        device_list.removeAllChildren();
                        deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                        hiMedia.endLoading("getDmpDevices");
                        deviceBrowser.currentState = hiMedia.DEVICE_DLNA_PAGE;
                        hiMedia.currentDevice = hiMedia.device.dms;
                    } else {
                        DBG_INFO("NO DLNA DEVICE NOW");
                        //hiMedia.toastMsg("[SE3237]", 5000);//Not available SS0019 leftover需要多语言
                        if (deviceBrowser.currentState == hiMedia.DEVICE_INIT_PAGE) {
                            hiMedia.endLoading("getDmpDevices");
                            //置灰入口图标
                        }
                        else if (deviceBrowser.currentState == hiMedia.DEVICE_DLNA_PAGE) {
                            try {
                                device_list.removeAllChildren();
                                deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                                deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                                hiMedia.endLoading("getDmpDevices");
                                deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                                deviceBrowser.currFocus = device_list.children[0];
                                deviceBrowser.lastFocus = device_list.children[0];
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }

                        }
                        UI.pushSubModule("hiMedia", "hiMediaTips", true);
                    }
                }
                else if (deviceType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD) {
                    if (event.rows.length > 0) {
                        hiMedia.volumesList = [];
                        for (var i = 0; i < event.rows.length; i++) {
                            var tempId = event.rows[i][0];
                            var tempType = event.rows[i][2];
                            var tempName = event.rows[i][1];
                            if (!tempName) {
                                tempName = "USB" + i;
                            }
                            if (tempType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD && tempId.indexOf("FSL2") != -1) {
                                hiMedia.volumesList.push({deviceId: tempId, deviceName: tempName, deviceType: "usb"});
                            }
                        }
                        deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                        if (deviceBrowser.currFocus) {
                            UI.base.stopText();
                        }
                        device_list.removeAllChildren();
                        deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                        var cIndex = checkCurrentFilePath();
                        deviceBrowser.currFocus = device_list.children[cIndex];
                        UI.focusTo(deviceBrowser.currFocus);
                        deviceBrowser.lastFocus = device_list.children[cIndex];
                        deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                        hiMedia.endLoading("getDmpDevices");
                    } else {
                        DBG_ERROR("length less than 0.");
                    }

                }
                m_volumeMainIterator.disconnect();
                break;
            case TableIterator.EVENT_TYPE_TOTAL_COUNT:
                DBG_INFO("Volume______event.totalCount" + event.totalCount);
                if (event.totalCount > 0) {
                    m_volumeMainIterator.readNextRows(event.totalCount);
                } else {
                    //没有设备时也需要初始化整个UI
                    if (deviceType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP) {
                        DBG_INFO("NO DLNA DEVICE NOW");
                        //hiMedia.toastMsg("[SE3237]", 5000);//Not available SS0019 leftover需要多语言
                        if (deviceBrowser.currentState == hiMedia.DEVICE_INIT_PAGE) {
                            hiMedia.endLoading("getDmpDevices");
                            //置灰入口图标
                        }
                        else if (deviceBrowser.currentState == hiMedia.DEVICE_DLNA_PAGE) {
                            try {
                                device_list.removeAllChildren();
                                deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                                deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                                hiMedia.endLoading("getDmpDevices");
                                deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                                deviceBrowser.currFocus = device_list.children[0];
                                deviceBrowser.lastFocus = device_list.children[0];
                            }
                            catch (ex) {
                                DBG_ERROR(ex.message);
                            }

                        }
                        UI.pushSubModule("hiMedia", "hiMediaTips", true);
                    }
                    else if (deviceType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD) {
                        hiMedia.volumesList = [];
                        deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                        if (deviceBrowser.currFocus) {
                            UI.base.stopText();
                        }
                        device_list.removeAllChildren();
                        deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                        var cIndex = checkCurrentFilePath();
                        deviceBrowser.currFocus = device_list.children[cIndex];
                        UI.focusTo(deviceBrowser.currFocus);
                        deviceBrowser.lastFocus = device_list.children[cIndex];
                        deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                        hiMedia.endLoading("getDmpDevices");
                    }
                    m_volumeMainIterator.disconnect();
                }

                break;
            default :
                DBG_ERROR("Come into Error Type When get DLNA device!!" + event.type);

                break;
        }
    };
    deviceBrowser.RefreshUSBData = function (usbType, usbID) {
        DBG_INFO("[RefreshUSBData]currentState is " + deviceBrowser.currentState +
            "  usbType is " + usbType + "  usbID  :  " + usbID);
        hiMedia.endLoading("RefreshUSBData");//应对问题MSD6586US-5879	
        if (deviceBrowser.currentState == hiMedia.DEVICE_INIT_PAGE) {
            device_list.removeAllChildren();
            deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
            deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
//            if (device_list.length > 1) {
//                deviceBrowser.currFocus = device_list.children[device_list.length - 2];
//                deviceBrowser.lastFocus = device_list.children[device_list.length - 2];
//            } else {
            var cIndex = checkCurrentFilePath();
            DBG_INFO("cIndex = " + cIndex);
            deviceBrowser.currFocus = device_list.children[cIndex];
            deviceBrowser.lastFocus = device_list.children[cIndex];
//            }
        } else {
            DBG_INFO("Current page is not USB page .");
        }
    }
    deviceBrowser.RefreshDMPData = function (dmpType, dmpID) {
        DBG_INFO("[RefreshUSBData]currentState is " + deviceBrowser.currentState +
            "  usbType is " + dmpType + "  usbID  :  " + dmpID);
        if (deviceBrowser.currentState == hiMedia.DEVICE_DLNA_PAGE) {
            try {

                deviceBrowser.getDmpDevices(VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD);
            } catch (ex) {
                DBG_ERROR("Open DMP error:" + ex.message);
            }
        } else {
            DBG_INFO("Current page is not DMP page .");
        }
    }
    deviceBrowser.onPush = function (from) {
        //用于处理PVR的焦点问题
        DBG_INFO("deviceBrowser.onPush");
        deviceBrowser.ready = false;
        hiMedia.devceBrowserEnable = true;
        if (!!hiMedia.info) {
            if (!!hiMedia.info.caller) {
                DBG_INFO(hiMedia.info.caller);
                if (hiMedia.info.caller == "pvr") {
                    deviceBrowser.currentState = hiMedia.DEVICE_PVR_PAGE;
                }
            }
        }
    }
    deviceBrowser.afterPush = function () {
        deviceBrowser.ready = true;
        DBG_INFO("after push!!!");
    }

    deviceBrowser.onShow = function (from) {

        DBG_ALWAYS("device browser onShow!and hiMedia.devceBrowserEnable =  " + hiMedia.devceBrowserEnable);
        //初始化数据
        if (!!hiMedia.devceBrowserEnable) {
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.base.cursor.alpha = 0;
            device_focus.alpha = 1;
            UI.updateStage();
//        deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;  调整到后面用来处理焦点判断问题
            deviceBrowser.devicesData = [];
            deviceBrowser.usbDatas = [];
            focusDis = 0;
            //所有dlna设备
            deviceBrowser.dlnaDatas = [];
            //某一个dlna设备
            deviceBrowser.dmsDatas = [];
            //用于区分第一次初始化时收到的USB上限通知
            deviceBrowser.HiMedia_initPage = 0;

            if (!Config.tv) {
                deviceBrowser.devicesData = [
                    {deviceId: "usbid", deviceName: "USB1", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "DMS", deviceType: "dms"},
                    {deviceId: "usbid", deviceName: "DLNA_DEVICES", deviceType: "dlna"},
                    {deviceId: "usbid", deviceName: "Dropbox", deviceType: "cloud"},
                    {deviceId: "usbid", deviceName: "USB2", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "USB3_long_title_test_USB3_long_title_test_USB3_long_title_test_USB3_long_title_test", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "USB1", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "DMS", deviceType: "dms"},
                    {deviceId: "usbid", deviceName: "DLNA_DEVICES", deviceType: "dlna"},
                    {deviceId: "usbid", deviceName: "Dropbox", deviceType: "cloud"},
                    {deviceId: "usbid", deviceName: "USB2", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "USB3", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "USB1", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "DMS", deviceType: "dms"},
                    {deviceId: "usbid", deviceName: "DLNA_DEVICES", deviceType: "dlna"},
                    {deviceId: "usbid", deviceName: "Dropbox", deviceType: "cloud"},
                    {deviceId: "usbid", deviceName: "USB2", deviceType: "usb"},
                    {deviceId: "usbid", deviceName: "USB3", deviceType: "usb"}
                ];
                if (deviceBrowser.currFocus) {
                    UI.base.stopText();
                }
                device_list.removeAllChildren();
                deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                var cIndex = checkCurrentFilePath();
                deviceBrowser.currFocus = device_list.children[cIndex];
                UI.focusTo(deviceBrowser.currFocus);
                deviceBrowser.lastFocus = device_list.children[cIndex];
                deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
            } else {
                //先显示现有设备
                deviceBrowser.devicesData = deviceBrowser.getInitDeviceData();
                if (deviceBrowser.currFocus) {
                    UI.base.stopText();
                }
                device_list.removeAllChildren();
                deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
                var cIndex = checkCurrentFilePath();
                deviceBrowser.currFocus = device_list.children[cIndex];
                UI.focusTo(deviceBrowser.currFocus);
                deviceBrowser.lastFocus = device_list.children[cIndex];
                deviceBrowser.currentState = hiMedia.DEVICE_INIT_PAGE;
                //调用搜索USB设备接口
                deviceBrowser.getDmpDevices(VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD);

            }
        }

    }
    function startDropbox() {
        try {
            UI.popAllModule();

            startThirdPartyApp(APPNAME.DROPBOX, null, CMDType.HISENSEPAGE, CMDMethod.COMMANDURL, false);
            ReadDropboxUserIni();
        } catch (e) {
            DBG_ERROR(e.message);
        }
    }

    function checkCurrentFilePath() {
        var tmp = deviceBrowser.getInitDeviceData();
        DBG_INFO("tmp:" + tmp.length);
        if (tmp.length > 1) {
            for (var i = 0; i < tmp.length - 1; i++) {
                DBG_INFO("tmp[i].deviceId : " + tmp[i].deviceId + "  hiMedia.curVolumeId:" + hiMedia.curVolumeId);
                if (tmp[i].deviceId == hiMedia.curVolumeId) {
                    return i;
                }
            }
            if (deviceBrowser.currentState == hiMedia.DEVICE_DLNA_PAGE) {
                return tmp.length - 1;
            }
            return 0;

        } else {
            return 0;
        }
    }


    //****************Add PVR function***begin**************/
    deviceBrowser.getPvrVolume = function (callBack) {
        DBG_INFO("getPvrVolume function begin");
        var usbList = deviceBrowser.getUsbList();
        //组装设备列表 顺序是先RETURN  再USB  再DROPBOX
        //这里组装完毕后把数组传给DLNA获取 DLNA获取完后再去取PVR
        // 最后在PVR处完成刷新UI.
        DBG_INFO("usbList now is :" + usbList);
        if (!!usbList) {
            DBG_INFO("usbList now is :" + usbList);
            //usbList.length-1是为了屏蔽最有一个/n后的undefine,去重后该问题不存在了
            for (var i = 0; i < usbList.length; i++) {
                //var tmplength = usbList[i].split("/").length;
                var tmpUsbPath = usbList[i].split(";")[0];
                //var tmpUsbName = usbList[i].split(";")[1];
                isPVRUSB(tmpUsbPath, callBack);

            }
        }
        else {
            //无U盘的情况
            hiMedia.endLoading("no usb.");
            hiMedia.toastMsg("[SE0452]");

        }
    }

    var m_isPvrIterator = null;

    function isPVRUSB(path, callBack) {
        var paramPvr = [path, callBack];
        DBG_INFO("Test PVR files from one USB,param is path,type");

        try {
            m_isPvrIterator = new TableIterator(
                model.usb.creatUSBTableMainIterator,
                true,
                [

                    {
                        field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH,
                        condition: Model.FIELD_COND_EQUAL,
                        value: path + "pvr/"
                    },
                    {
                        field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_TYPE,
                        condition: Model.FIELD_COND_EQUAL,
                        value: 4
                    }
                ],
                [
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH, /**< ancestor */
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_TYPE, /**< item name */
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_ISDIR
                ],
                [
                    { field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH, direction: 1 }
                ],
                onIsPvrIteratorEvent.bind(this, paramPvr));
        }
        catch (ex) {
            DBG_ERROR("model.usb.creatUSBTableMainIterator Error" + ex.message);
        }
        m_isPvrIterator.fetchTotalCount();


    }

    var onIsPvrIteratorEvent = function (paramPvr, event) {
        DBG_INFO("onIsPvrIteratorEvent begin and path is : " + paramPvr[0]);
        if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {

            var PvrCount = event.totalCount;
            DBG_INFO("FETCH TOTAL CONT " + PvrCount);
            if (PvrCount > 0) {
                DBG_INFO("there are PVR files in the  path : " + paramPvr[0], DebugLevel.ALWAYS);
                var demoPVRDevice = {deviceId: paramPvr[0] + "pvr/", deviceName: "PVR", deviceType: "pvrFolder"};
                deviceBrowser.pvrArray.push(demoPVRDevice);
                deviceBrowser.pvrCount++;
                if (deviceBrowser.pvrCount == deviceBrowser.getUsbList().length) {
                    paramPvr[1]();
                }
                // HiFileBrowser.InitDeviceDatas = paramPvr[1];
                // setHTML(HiFileBrowser.InitDeviceDatas);

            }
            else {
                DBG_INFO("there are not PVR flies in  path : " + paramPvr[0], DebugLevel.ALWAYS);
                deviceBrowser.pvrCount++;
                if (deviceBrowser.pvrCount == deviceBrowser.getUsbList().length) {
                    paramPvr[1]();
                }
                // HiFileBrowser.InitDeviceDatas = paramPvr[1];
                // setHTML(HiFileBrowser.InitDeviceDatas);
            }


        }
        else {
            DBG_INFO("[onIsPvrIteratorEvent]other Type_________" + event.type);
        }
    };

    var pvrCallBack = function () {
        hiMedia.endLoading("enterPvr");
        if (deviceBrowser.pvrArray.length > 0) {
            device_list.removeAllChildren();
            deviceBrowser.devicesData = deviceBrowser.pvrArray;
            deviceBrowser.createDeviceGrid(deviceBrowser.devicesData, true);
            deviceBrowser.currentState = hiMedia.DEVICE_PVR_PAGE;
        } else {
            hiMedia.toastMsg("[DMP0125]");
        }
    }
//****************Add PVR function***end****************/
};

