// Global Module Var
var example = window["example"];

// Init
(function(){

    UI.pushSubModule("example", "examplePanel", true);

})();

// Actions
(function(){

    example.onShow = function() {
        // 注意：此处在第一次pushModule时无法取得任何子模块
    };

    example.onFocus = function(focus) {
        if (focus.cacheCanvas){
            focus.updateCache();
        }
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus).wait(100).to({scaleX:1.05, scaleY:1.05}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).wait(100).to({scaleX:1.05, scaleY:1.05, alpha:1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
    };

    example.onNormal = function(focus) {
        if (focus.cacheCanvas){
            focus.updateCache();
        }
        UI.getTween(focus).to({scaleX:1, scaleY:1}, 200);
    };

    example.onkey_ENTER = function(target) {
        UI.getTween(UI.getCurrModule().currFocus).to({scaleX:0.9, scaleY:0.9}, 100).to({scaleX:1, scaleY:1}, 100);
    };

})();