/************
 **   Created by Xueyuan
 **       2016-1-26
 ************/

//init
UI.moduleBuilder['dlna']['dlnaMusicPlayer'] = function () {
    var dlnaMPageData = {
        musicPlayerBG: "hiMedia/bg_music_play_dlna.png",
        musicThumbnail: "hiMedia/music_play_dvd_default_dlna.png"
    };
    var template = Util.readJson("module/dlna/dlnaMusicPlayer.json");
    var dlnaMusicPlayer = SubModule.create(dlnaMPageData, template);
    dlnaMusicPlayer.currFocus = UI.getItem(dlnaMusicPlayer, "musicName");
    //隐藏musicPlayer中不需要显示的元素
    dlnaMusicPlayer.musicPlayerMenu = UI.getItem(dlnaMusicPlayer, "musicPlayerMenu");
    dlnaMusicPlayer.musicPlayerMenu.visible = false;
    dlnaMusicPlayer.musicPlayerMenu.alpha = 0;

    dlnaMusicPlayer.musicPlayerLoop = UI.getItem(dlnaMusicPlayer, "musicPlayerLoop");
    dlnaMusicPlayer.musicPlayerLoop.visibel = false;
    dlnaMusicPlayer.musicPlayerLoop.alpha = 0;

    dlnaMusicPlayer.musicArtist = UI.getItem(dlnaMusicPlayer, "musicArtist");
    dlnaMusicPlayer.musicName = UI.getItem(dlnaMusicPlayer, "musicName");
    dlnaMusicPlayer.musicTime = UI.getItem(dlnaMusicPlayer, "musicPlayerTime");
    dlnaMusicPlayer.thumbNail = UI.getItem(dlnaMusicPlayer, "musicThumbnail");
    dlnaMusicPlayer.musicPB = UI.getItem(dlnaMusicPlayer, "musicPB");
    dlnaMusicPlayer.musicPlayerBG = UI.getItem(dlnaMusicPlayer, "musicPlayerBG");
    dlnaMusicPlayer.musicPlayerBG.doFlip = true;

    var dlnaMusicTotalTime = 0;
    var dlnaMusicCurTime = 0;
    var dlnaMusicName = "";
    var dlnaMusicState = "play";
    dlnaMusicPlayer.playStatus = 1;

    dlnaMusicPlayer.onPush = function () {
        writeFileToNative("musicStopFlag", "running", 0);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaMusicStatchanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, dlnaMusicPlaytimechanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_TOTAL_TIME_CHANGED, dlnaMusicTotalPlaytimechanged);
        dlnaMusicPlayer.updateDlnaData(Dlna.dlnaMusicList);
        playstatus = 0;
        //播放状态监听

    };

    dlnaMusicPlayer.onShow = function () {
        dlnaMusicPlayer.createMusicPB(dlnaMusicPlayer.musicPB, 0);
        UI.setText(dlnaMusicPlayer.musicTime, "00:00/00:00");
    };

    dlnaMusicPlayer.updateDlnaData = function (musiclist) {
        DBG_ALWAYS("update dlnamusicplayer data");
        var url = musiclist[0].musicUrl;
        var name = musiclist[0].musicName;
        dlnaMusicName = name;
        var artist = musiclist[0].musicArtist;
        try {
            pubStateMediaDLNA(dlnaMusicName, 0, 0, 0, "start", "music");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        createjs.Tween.removeAllTweens();
        dlnaMusicPlayer.playMusicByUrl(url, name, artist);
    };

    dlnaMusicPlayer.playMusicByUrl = function (musicUrl, musicName, musicArtist) {
        if (!!musicUrl) {
            DBG_INFO("playMusicByUrl " + musicUrl);
            UI.setText(dlnaMusicPlayer.musicName, musicName);
            UI.setText(dlnaMusicPlayer.musicArtist, musicArtist);
            model.mpctrl.PlayMedia(musicUrl, null, null, null, null, null, 8, null, null, null);
            dlnaMusicPlayer.playStatus = 1;
        }
    };

    dlnaMusicPlayer.musicPlayOrPause = function () {
        if (dlnaMusicPlayer.playStatus == 0) {
            model.mpctrl.MpCtrl(1);
            dlnaMusicPlayer.playStatus = 1;
        }
        else if (dlnaMusicPlayer.playStatus == 1) {
            model.mpctrl.MpCtrl(2);
            dlnaMusicPlayer.playStatus = 0;
        }
    };

    dlnaMusicPlayer.closeMusicPlayer = function () {
        if (UI.getCurrSubModule().name == "dlnaMusicPlayer") {
            DBG_INFO("close MusicPlayer function begin");
            UI.popSubModule();
            //延时3S 预留连续推送时间
            clearTimeout(Dlna.closeDlnaTimer);
            Dlna.closeDlnaTimer = setTimeout(function () {
                UI.popAllModule();
                try {
                    openLiveTVModule([Msg.INFO, 0]);
                } catch (e) {
                    DBG_ERROR(e.message);
                }
            }, 3000);
        }
    };
    dlnaMusicPlayer.onkey_MENU = function () {
        if(!!GLOBAL.DLNADEVICE_MAC){
            var str = localStorage.getItem(GLOBAL.DLNADEVICE_MAC);
            if(str == 1){
                localStorage.removeItem(GLOBAL.DLNADEVICE_MAC);
                var mac = Config.language.SE0181 + ":" + GLOBAL.DLNADEVICE_MAC;
                UI.pushGhostModule("common", "dlnaToast2",{"titleStr" : "[SE4212]", "textStr": mac})
                dlnaMusicPlayer.onkey_BACKSPACE();
            }
        }
    };
    //back键和exit键单独处理，直接退出DLNA模块
    dlnaMusicPlayer.onkey_BACKSPACE = function () {
        DBG_INFO("close MusicPlayer function begin");
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    };

    dlnaMusicPlayer.onkey_ESCAPE = function () {
        DBG_INFO("close MusicPlayer function begin");
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    };

    dlnaMusicPlayer.onExit = function () {
        try {
            createjs.Tween.removeAllTweens();
        }
        catch (e) {
            DBG_ERROR(e.message);
        }
    };

    dlnaMusicPlayer.onPop = function () {
        try {
            // model.cec.setIsMiracastExist(0);
            model.mpctrl.MpCtrl(3);
            writeFileToNative("musicStopFlag", "stop", 0);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaMusicStatchanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, dlnaMusicPlaytimechanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_TOTAL_TIME_CHANGED, dlnaMusicTotalPlaytimechanged);
            try {
                pubStateMediaDLNA(dlnaMusicName, 0, 0, 0, "stop", "music");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        catch (e) {
            DBG_ERROR(e.message);
        }
    };

//MusicPlayer专用的圆形进度条
    dlnaMusicPlayer.createMusicPB = function (target, percent) {
        target.percent = percent;
        target.redraw = function (g) {
//            return;
            g.currentPath = false;
            g.clear();
            if (target.percent != 0) {
            //g.setStrokeStyle(6, 'round', 'round');
            g.lineStyle(9, 0x00a9c2, 1);
            if (!GLOBAL.RTL) {
                g.arc(261, 254, 253, Math.PI * 3 / 2, Math.PI * (2 * target.percent / 100 + 3 / 2), false);
                    //g.arc(261, 254, 253, Math.PI * 3 / 2, Math.PI * (2 * target.percent / 100 + 3 / 2), false);
            }
            else {
                g.arc(-261, 254, 253, Math.PI * 3 / 2, Math.PI * (3 / 2 - 2 * target.percent / 100 ), true);
            }
            }
        };
        target.removeAllChildren();
        var shape = new PIXI.Graphics();
        target.addChild(shape);
        target.redraw(shape);
        target.setPercent = function (percent) {
            target.percent = percent;
            this.redraw(shape);
            UI.updateStage();
        };
        UI.updateStage();
    };
    //thumbNail更改
    var star = new PIXI.Graphics();
    star.x = 456;
    star.y = 242;
    //star.graphics.setStrokeStyle(1).beginStroke("#FF0").a(0, 0, 470 / 2, 0, Math.PI * 2, false).closePath();
    dlnaMusicPlayer.thumbNail.x = 456;
    dlnaMusicPlayer.thumbNail.y = 242;
    dlnaMusicPlayer.thumbNail.pivot.x = 235;
    dlnaMusicPlayer.thumbNail.pivot.y = 235;
    //dlnaMusicPlayer.thumbNail.mask = star;

    dlnaMusicPlayer.getTimeText = function (c) {
        var d = Math.floor(c);
        var b = Math.floor(d / 3600);//hour
        var e = Math.floor((d % 3600) / 60);//minute
        var a = Math.floor(d % 60);//second
        if (b > 100)
            return dlnaMusicPlayer.formatTimeHMS(0, 0, 0);
        else if (b < 1)
            return dlnaMusicPlayer.checkTime(e) + ":" + dlnaMusicPlayer.checkTime(a);
        else
            return dlnaMusicPlayer.formatTimeHMS(b, e, a);
    };

    dlnaMusicPlayer.formatTimeHMS = function (c, a, b) {
        return dlnaMusicPlayer.checkTime(c) + ":" + dlnaMusicPlayer.checkTime(a) + ":" + dlnaMusicPlayer.checkTime(b);
    };

    dlnaMusicPlayer.checkTime = function (a) {
        return(a < 10 ? "0" : "") + a;
    };

    function dlnaMusicReqationchanged(value) {
        DBG_INFO("dlnaMusic action changed" + value);
        switch (value) {
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_PLAY:
                if (dlnaMusicPlayer.playStatus == 0) {
                    dlnaMusicPlayer.musicPlayOrPause();
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_PAUSE:
                if (dlnaMusicPlayer.playStatus == 1) {
                    dlnaMusicPlayer.musicPlayOrPause();
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_STOP:
                try {
                    var data = readFileFromNative("musicStopFlag", 0);
                } catch (e) {
                    DBG_ERROR(e.message);
                }
                DBG_INFO("musicStopFlag is " + data);
                if (data == "stop") {
                    return;
                } else {
                    dlnaMusicPlayer.closeMusicPlayer();
                }
//                UI.popModule();
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_SEEK_START:
                //清除musicplayer进度条
                break;
            default:
                break;
        }
    }
    var playstatus = 0;
    function dlnaMusicStatchanged(value) {
        var nState = parseInt(value[2]);
        DBG_INFO("dlnaMusic status changed " + nState);
        if (nState == playstatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_INFO("drop duplicated state event" + nState);
            return;
        }
        playstatus = nState;
        switch(nState){

            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                model.mpctrl.MpCtrl(1);
                //UI.getTween(dlnaMusicPlayer.thumbNail, false, true).to({rotation: dlnaMusicPlayer.thumbNail.rotation + 360}, 10000);
                UI.getTween(dlnaMusicPlayer.thumbNail, true, true).to({rotation: dlnaMusicPlayer.thumbNail.rotation + Math.PI * 2}, 15000);
                Dlna.endLoading("musicPlayer");
                Dlna.renderLock = false;
                UI.unlockAllKeys("musicDone");
                break;
	    case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                dlnaMusicState = "play";
                pubStateMediaDLNA(dlnaMusicName, dlnaMusicTotalTime, dlnaMusicCurTime, 0, dlnaMusicState, "music");

                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                dlnaMusicState = "pause";
                pubStateMediaDLNA(dlnaMusicName, dlnaMusicTotalTime, dlnaMusicCurTime, 0, dlnaMusicState, "music");

                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:
                dlnaMusicPlayer.closeMusicPlayer();
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
                Dlna.toastMsg("[DMP0031]");
                dlnaMusicPlayer.closeMusicPlayer();
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                Dlna.toastMsg("[SE3238]");
                dlnaMusicPlayer.closeMusicPlayer();
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_SEEK_DONE:
                break;
            default:
                break;
        }

    }

    //更新进度条
    var percent = 0;

    function dlnaMusicPlaytimechanged(value) {
        //DBG_ALWAYS("onMpCtrlMPlaytimeCurrentchanged : " + value);
        if (!!dlnaMusicTotalTime) {
            var currentTime = dlnaMusicPlayer.getTimeText(value);
            var totalTime = dlnaMusicPlayer.getTimeText(dlnaMusicTotalTime);
//            DBG_ALWAYS("onMpCtrlMPlaytimeCurrentchanged : " + currentTime);
//            DBG_ALWAYS("onMpCtrlMPlaytimeCurrentchanged : " + totalTime);
            try {
                var timeArray = [currentTime, totalTime];
            } catch (e) {
                DBG_ERROR(e.message);
            }
            var timeFormat = timeArray.join("/");
            //DBG_ALWAYS("onMpCtrlMPlaytimeCurrentchanged : " + timeFormat);
            UI.setText(dlnaMusicPlayer.musicTime, timeFormat);
            percent = 100 * value / dlnaMusicTotalTime;
            dlnaMusicPlayer.musicPB.setPercent(percent);
            dlnaMusicCurTime = value;
            try {
                pubStateMediaDLNA(dlnaMusicName, dlnaMusicTotalTime, value, 0, dlnaMusicState, "music");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }

    function dlnaMusicTotalPlaytimechanged(value) {
        DBG_INFO("Music total time" + value);
        dlnaMusicTotalTime = value;
    }


};
