
//var accuweatherCityList;
UI.moduleBuilder['accuweather']['accuweatherCityList'] = function(){
    var CityList_Data = {
        bg:UI.window_bg,
        pic_bar:"setting/Closed_Caption_Setting_breakline.png",
        BgSheet:UI['bg_overlay'],
        title:'[WE0004]'//City list
    };
    var template = Util.readJson("module/accuweather/accuweatherCityList.json");
    var CityList = SubModule.create(CityList_Data, template);
    var allList = UI.getItem(CityList,"anchor");
    var item_content=UI.getItem(CityList,"item_content");
    //accessibility_page.currFocus = UI.getItem(CityList, "Caption_Control_group");
    UI.addMask(item_content, 900, 680);
    UI.setView(item_content, 900, 680);
    var oprtData = {};
    var pageData = {
        accu_cl_title: {Data: 'City list'},
        accu_cl_list: {Data: [], SelectedIndex: 0}

    };
    var imgList = {
        homeImg: "accuweather/icon_home.png",
        noImg: "accuweather/transparent.png"
    }
    var info = {
        template : "accuweatherCityListItem",
        direction : CONST.GIRD_DIRECTION.H,
        breakNum : 1,
        distanceX : 40,
        distanceY: 20,
        container : allList
    };

    function rewritePageData() {
        if(!oprtData.cityList) return;
        pageData.accu_cl_list.Data = [];
        for(var i = 0; i < oprtData.cityList.length; i++) {
            pageData.accu_cl_list.Data.push({
                accu_cl_name: oprtData.cityList[i].locName + ", " + oprtData.cityList[i].locCountry,
                accu_cl_home: (i == oprtData.defInd ? imgList.homeImg : imgList.noImg),
                name:'item'+i,
                item_bg:UI.item_bg
            })
        }

        for(;info.container.children.length>0;){
            info.container.children.pop();
        }

        Gird.create(pageData.accu_cl_list.Data, info);
        CityList.currFocus = UI.getItem(allList,"item0");
        UI.updateStage();
    }

    CityList.onShow = function() {
        accuweather.ShowCursor(true);
        oprtData.cityList = accuweather.getCityList();
        oprtData.defInd = accuweather.getDefaultCityId();
        rewritePageData();
    }
    CityList.onExit=function(){

    }
    allList.onkey_ENTER=function openSelectedCity() {
        var ind = UI.getCurrSubModule().currFocus.name.split('item')[1];
        accuweather.setCurrentWeatherByLocId(oprtData.cityList[ind].locId);
        UI.popSubModule();
    }
};

