
var accuweatherAddCity={
    oprtData:{}
};

UI.moduleBuilder['accuweather']['accuweatherAddCity'] = function(){
    var accuweatherAddCityData = {
        bg:UI.window_bg,
        search_bg:UI.item_bg,
        pic:'accuweather/search_focus.png',
        searchbdr:'accuweather/searchbdrfocus.png',
        BgSheet:UI['bg_overlay'],
        title:'[WE0002]',//Add a City
        input_hint:'[SE2697]',//Show the virtual keyboard by pressing OK button
        input_city_hint:'[LA0083]',//Please enter the name of a city or ZIP code.
        text:'[SE0185]'//Search
        //inputbox:'accuweather/Transparent_sheet.png'
    };
    var template = Util.readJson("module/accuweather/accuweatherAddCity.json");
    var AddCity = SubModule.create(accuweatherAddCityData, template);
    AddCity.currFocus=UI.getItem(AddCity,"input");

    var textBar = UI.getItem(AddCity, "input");
    var inputBox = UI.getItem(textBar, "inputbox");
    var input_hint=UI.getItem(textBar,"input_hint");
    var input_city_hint=UI.getItem(textBar,"input_city_hint");
    var textInfo = {
        initVal : "",
        maxLength : 20,
        maxWidth: 810,
        fontSize : 40,
        isPwd : false,
        color : 0xFFFFFF
    };
    //AddCity.onFocus = function(focus) {
    //    UI.moveCursor(UI.adjustView());
    //    UI.getTween(focus).to({scaleX:1, scaleY:1}, 500, UI.ease.quartOut);
    //    UI.getTween(UI.base.cursor).to({scaleX:1, scaleY:1}, 500, UI.ease.quartOut);
    //    UI.getTween(UI.base.cursor, false).wait(200).to({alpha:1}, 500, UI.ease.quartOut);
    //    UI.moveTop(focus);
    //};
    //AddCity.onNormal = function(focus) {
    //    UI.getTween(focus).to({scaleX:1, scaleY:1}, 500, UI.ease.quartOut);
    //    UI.getTween(UI.base.cursor).set({alpha:0});
    //};
    AddCity.onPush=function(){
        AddCity.currFocus=UI.getItem(AddCity,"input");
        inputBox.setText("");//clear default data in inputBox
    };
    AddCity.onShow=function(){
        numberInputInit();
        showHintOrNot();
    };
    accuweatherAddCity.oprtData={cityList:""};
    TextBox.create(inputBox,textInfo, onTextChanged);
    inputBox.setText('');
    textBar.onFocus = function(){
        inputBox.active();
        //focus.uncache();
        accuweather.ShowCursor(false);
        //return true;
    };
    textBar.onNormal = function(){
        inputBox.inactive();
        //focus.cache(0, 0, focus.getBounds().width, focus.getBounds().height);
        accuweather.ShowCursor(true);
        return true;
    };
    AddCity.onExit=function(){

    };
    //textBar.onkey_RIGHT = function() {
    //    inputBox.cursorRight();
    //    return true;
    //};
    //textBar.onkey_LEFT = function() {
    //    inputBox.cursorLeft();
    //    return true;
    //};
    function numberInput(){
        var NumKey = function() {
            inputBox.children[0].realValue += CONST.NUMIPT_VALUE[UI.currKeyValue];
            inputBox.setText(inputBox.children[0].realValue);
            inputBox.cursorRight();
            showHintOrNot();
            DBG_INFO("value changed!");
            UI.updateStage();
        };
        textBar.onkey_ZERO = NumKey;
        textBar.onkey_ONE = NumKey;
        textBar.onkey_TWO = NumKey;
        textBar.onkey_THREE = NumKey;
        textBar.onkey_FOUR = NumKey;
        textBar.onkey_FIVE = NumKey;
        textBar.onkey_SIX = NumKey;
        textBar.onkey_SEVEN = NumKey;
        textBar.onkey_EIGHT = NumKey;
        textBar.onkey_NINE = NumKey;
    }
    AddCity.onkey_ENTER=function()
    {
        if(UI.getCurrFocus().name=="input"){
            inputBox.showKeyBoard();
        }
        if(UI.getCurrFocus().name=="search"){
            onTextChanged();
        }
    };
    function onTextChanged() {
        showHintOrNot();
        UI.updateStage();
        AddCity.doSearchWork(inputBox.children[0].text);
    }
    AddCity.doSearchWork = function(txt) {
        if("" == txt){
            try{
                accuweather.sendMsg( "[LA0083]");// accuweather.sendMsg( "Please enter the name of a city or ZIP code");
                if(GLOBAL.WAIT_POWERON == true) return;
                UI.pushSubModule("accuweather","Msgbox");
            }catch(ex){DBG_ERROR(ex.message)}
            return;
        }
        accuweatherAddCity.oprtData={cityList:""};
        if(!tv) {
            accuweatherAddCity.oprtData.cityList = [
                {
                    locId: '106573',
                    locName: 'Qingdao',
                    locCountry: 'China',
                    unit: 'Metric'
                }
            ];
            UI.pushSubModule('accuweather','accuweatherSearchList',true);
        }
        else {
            if(getNetworkSatus()){
                searchCity(txt);
            }
            else{
                try{
                    accuweather.sendMsg( "[SE2738]");//accuweather.sendMsg( "Network connection failed.");
                    if(GLOBAL.WAIT_POWERON == true) return;
                    UI.pushSubModule("accuweather","Msgbox");
                }catch(ex){DBG_ERROR(ex.message)}

            }
        }

    }
    function searchCity(city) {
        var url = accuweather.getSearchUrl(city);
        var path = accuweather.getSearchPath();

        if(downloadFileToNative(url, path, 1, 10)) {
            accuweatherAddCity.oprtData.cityList = null;
            var LoadingIcon = UI.getItem(AddCity, "LoadingIcon");
            accuweather.startLoading(LoadingIcon);
            checkDownloadState(path, 1, searchCityCallback, 'search');
        }
    }
    function searchCityCallback(obj, identify) {
        accuweather.endLoading();
        if(GLOBAL.WAIT_POWERON){
            openLiveTVModule();
            return;
        }
        if('search' != identify) return;
        if(null == obj || "string" == typeof(obj)) {
            accuweather.sendMsg("[LA0072]");//  accuweather.sendMsg("Request timed out");
            UI.pushSubModule("accuweather","Msgbox");
        }
        else if(!obj.length || 0 == obj.length) {
            accuweather.sendMsg("[LA0005]");//accuweather.sendMsg("Could not find any cities!");
            UI.pushSubModule("accuweather","Msgbox");
        }
        else {
            if(UI.getCurrSubModule().name=='accuweatherSearchList') {
                DBG_INFO("search box has already closed.");
            }
            else {
                accuweatherAddCity.oprtData.cityList = obj;
                UI.pushSubModule('accuweather','accuweatherSearchList',true);
            }
        }
    }
    function numberInputInit(){
        numberInput();
        if(inputBox.children[0].realValue=='#'){
            inputBox.setText("");//clear default data in inputBox
        }
    }
    function showHintOrNot(){
        if (inputBox.children[0].realValue!= "") {
            input_hint.alpha = 0;
            input_city_hint.alpha=0;
        }else{
            input_hint.alpha = 0.2;
            input_city_hint.alpha=0.2;
        }
    }
};

