
UI.moduleBuilder['FTE']['fte_remotePairing'] = function() {
     var remotePairingData = {
         titleImg:"FTE/fte_hd_bluetooth.png",
         title:"[SE3491]",//"Remote Pairing"
         helpText:"[SE3528]",//"Use Bluetooth to control your Laser TV."
         subHelpText:"[SE3532]",//"Press and hold the MENU button within 20 feet of the TV"
         pairingFailText:"[SE3492]",//"Unable to pair the remote."
         pairingFailSubText:"[SE3493]",//"Make sure the battery in your remote is sufficient and this TV is not paired with another remote."
         tryAgainBtnText:"[PI0019]",//Try again
         OKBtnImg:UI.item_bg,
         fte_bluetooth_1:"FTE/fte_bluetooth_1.png",
         fte_bluetooth_2:"FTE/fte_bluetooth_2.png",
         fte_bluetooth_3:"FTE/fte_bluetooth_3.png",
         fte_bluetooth_4:"FTE/fte_bluetooth_4.png",
         fte_bluetooth_pairing:"FTE/fte_bluetooth_pairing.png",
         fte_bluetooth_success:"FTE/fte_bluetooth_success.png"
     }
    var template = Util.readJson("module/FTE/fte_remotePairing.json");
    var remotePairing = SubModule.create(remotePairingData, template);
//    remotePairing.connectTimeOutTimer = null;
    var tvDebugTimer = null;

    var helpText = UI.getItem(remotePairing, "helpText");
    var subHelpText = UI.getItem(remotePairing, "subHelpText");
    var mainFrame = UI.getItem(remotePairing, "mainFrame");
    var pairingFailTiles = UI.getItem(remotePairing, "pairingFailTiles");
    var tryAgainBtn = UI.getItem(remotePairing, "tryAgainBtn");
    var background = UI.getSubModule("fte_background");
    var fte_bluetooth_1 = UI.getItem(remotePairing, "fte_bluetooth_1");
    var fte_bluetooth_2 = UI.getItem(remotePairing, "fte_bluetooth_2");
    var fte_bluetooth_3 = UI.getItem(remotePairing, "fte_bluetooth_3");
    var fte_bluetooth_4 = UI.getItem(remotePairing, "fte_bluetooth_4");
    var fte_bluetooth_pairing = UI.getItem(remotePairing, "fte_bluetooth_pairing");
    var fte_bluetooth_success = UI.getItem(remotePairing, "fte_bluetooth_success");

    var pairingAnimationItems = [fte_bluetooth_1,fte_bluetooth_2,fte_bluetooth_3,fte_bluetooth_4];

    remotePairing.onPush = function(){
        UI.setText(subHelpText,"[SE3532]");//"Press and hold the MENU button within 20 feet of the TV"
        var key = [CONST.KEY.VK_BT_PARING,CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,CONST.KEY.VK_ENTER, CONST.KEY.VK_BACKSPACE];
        UI.registerKeyCodes(key);
        remotePairing.currFocus  = helpText;
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_GATTC_CONNECT,onremotePairingChanged);
//        clearTimeout(remotePairing.connectTimeOutTimer);
//        remotePairing.connectTimeOutTimer = setTimeout(connectBtTimeout,15000);
//        model.bluetooth.RemoteControlScanResult = onremotePairingChanged;
    };


    function connectBtTimeout(){
        DBG_ERROR("FTE connect BT timeout ");
        createjs.Tween.removeAllTweens();
        mainFrame.alpha = 0;
        pairingFailTiles.alpha = 0;
        fte_bluetooth_pairing.alpha = 0;
        fte_bluetooth_success.alpha = 0;
        pairingFailTiles.alpha = 1;
        UI.focusTo(tryAgainBtn);
    }
    helpText.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha : 0});
    }
    tryAgainBtn.onFocus = function(){
       return true;
    }

    remotePairing.onShow = function(){
        pairingAnimation();
    };

    remotePairing.onkey_RIGHT = function(){
        fteUpdate(1);
    }


    remotePairing.onkey_BACKSPACE = remotePairing.onkey_LEFT= function(){
        fteUpdate(-1);
    }

    remotePairing.onPop = function(){
        UI.registerKeyCodes(FTE.enableKeyGroup);
        clearTimeout(tvDebugTimer);
//        clearTimeout(remotePairing.connectTimeOutTimer);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_GATTC_CONNECT,onremotePairingChanged);
    }
    function onremotePairingChanged(actionID,pairingState){
        // 100:scaning ; 0:connecting ; 1: connect success; -1 : connect failed; -100 : scan failed;
        //-101:2RC ,the first one is connected;-102:2RC,the first one is not connected ;-11:paired failed
        DBG_ERROR("onremotePairingChanged is " + pairingState);
        createjs.Tween.removeAllTweens();
        mainFrame.alpha = 0;
        pairingFailTiles.alpha = 0;
        if(pairingState == 0 || pairingState ==100){
            fte_bluetooth_success.alpha = 0;
            fte_bluetooth_pairing.alpha = 1;
            UI.setText(subHelpText,"[SE3494]" + "\n" +"[SE3527]");//"Pairing..."
            UI.updateStage();
        }else if(pairingState == 1){
            UI.focusTo(helpText);
            fte_bluetooth_pairing.alpha = 0;
            fte_bluetooth_success.alpha = 1;
            UI.setText(subHelpText,"[SE2560]");//Successfully Paired
            UI.updateStage();
            setTimeout(function(){
                fteUpdate(1);
            },4000);
        }else {
            fte_bluetooth_pairing.alpha = 0;
            fte_bluetooth_success.alpha = 0;
            subHelpText.alpha = 0;
            pairingFailTiles.alpha = 1;
            UI.focusTo(tryAgainBtn);
            UI.updateStage();
        }
    }

    remotePairing.onkey_ENTER = function(){
        if(UI.getCurrFocus().name == "tryAgainBtn"){
            subHelpText.alpha = 1;
            UI.setText(subHelpText,"[SE3532]");
            pairingAnimation();
            if(!tv){
             onremotePairingChanged(0,0);
             }
        }else{
            return;
        }
    }

    function pairingAnimation(){
        mainFrame.alpha = 1;
        pairingFailTiles.alpha = 0;
        fte_bluetooth_pairing.alpha = 0;
        fte_bluetooth_success.alpha = 0;
        doConnectingAnimation(0);

        function doConnectingAnimation(startIndex) {
            if(startIndex > pairingAnimationItems.length - 1) startIndex = 0;
            pairingAnimationItems[startIndex].alpha = 1;
            UI.getTween(pairingAnimationItems[startIndex], true).to({alpha: 1}, 1000, UI.ease.quartOut).call(function (nextIndex) {
                pairingAnimationItems[startIndex].alpha = 0;
                doConnectingAnimation(nextIndex);
            }, [startIndex + 1]);
        }
        if(!tv){
            tvDebugTimer = setTimeout(function(){
//                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_DEVICES_ENABLE_CHANGED,0);
                onremotePairingChanged(0,5);
            },4000);
        }
    }
}