UI.moduleBuilder['FTE']['fte_productRegister'] = function() {
    var registerData = {
        titleImg: "FTE/fte_hd_ic_registration.png",
        title: "[SE3865]",//Product Registration
        helpText: "[SE3870]",//Register to stay up-to-date with news and updates about your TV.
        mainIcon:"FTE/fte_hd_ic_registration.png",
        scanHelpText1:"[SE3875]",//Then follow the instruction on the screen
        OKBtnImg:UI.item_bg,
        continueBtnText:"[SE2642]"//Continue
    };
    var template = Util.readJson("module/FTE/fte_productRegister.json");
    var productRegister = SubModule.create(registerData, template);

    var modelNumLabel = UI.getItem(productRegister, "modelNumLabel");
    var serialNumLabel = UI.getItem(productRegister, "serialNumLabel");
    var continueBtn = UI.getItem(productRegister, "continueBtn");
    var scanHelpText = UI.getItem(productRegister, "scanHelpText");
    var mainIcon = UI.getItem(productRegister, "mainIcon");
    var background = UI.getSubModule("fte_background");


    LabelValue.create(modelNumLabel,"[SE3866]","36px SourceSansPro-Light","0xFFFFFF");//Model Number
    LabelValue.create(serialNumLabel,"[SE1564]","36px SourceSansPro-Light","0xFFFFFF");//Serial Number


    productRegister.onPush = function(){
        background.open();
         hideNavbarOrNot(0);
        productRegister.currFocus = continueBtn;
        try{
            var modelNum = "[SE4027]";//tv ? model.hisfactory.getProductType(): '0000';//See back of the TV
//            var serialNum = tv ? model.hisfactory.getServiceNo(): '0000';
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        try{
//            var modelNum = tv ? model.hisfactory.getProductType(): '0000';
            var serialNum = tv ? model.hisfactory.getServiceNo(): '0000';
        }catch(ex){
            DBG_ERROR(ex.message);
        }


        DBG_ERROR("modelNum is " + modelNum + "serialNum is " + serialNum);
        modelNumLabel.setValue(modelNum);
        serialNumLabel.setValue(serialNum);
    };

    productRegister.onShow = function(){
        var curCountry = getCountryCode(GLOBAL.CURRENT_AREA,GLOBAL.CURRENT_SUB_AREA);
        var curBrand = tv ? model.system.getCurBrand() : "shp";
        DBG_ERROR("curCountry is " + curCountry + "curBrand is " + curBrand);
        if(curBrand == "shp"){//sharp
            if(curCountry == "USA"){//www.hisense-usa.com/support/register
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["http://www.sharptvusa.com/support/product-registration"] );
                UI.setImage(mainIcon,"FTE/qr_sharpusa.png");
            }
            else if(curCountry == "CAN"){//http://www.hisense-canada.com/support/productReg.asp
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["http://www.sharp-canada.ca/en/support/product-registration"] );
                UI.setImage(mainIcon,"FTE/qr_sharpca.png");
            }
            else{//'MEX'  //http://www.hisense.com.mx/support/productReg.asp
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["http://www.sharptv.com.mx/registro-producto/"] );
                UI.setImage(mainIcon,"FTE/qr_sharpmx.png");
            }
        }else{
            if(curCountry == "USA"){//www.hisense-usa.com/support/register
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["www.hisense-usa.com/support/register"] );
                UI.setImage(mainIcon,"FTE/qr_husa.png");
            }
            else if(curCountry == "CAN"){//http://www.hisense-canada.com/support/productReg.asp
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["www.hisense-canada.com/support/productReg.asp"] );
                UI.setImage(mainIcon,"FTE/qr_hca.png");
            }
            else{//'MEX'  //http://www.hisense.com.mx/support/productReg.asp
                UI.setText(scanHelpText, "[SE3876]", null, null, null, null, ["www.hisense.com.mx/support/productReg.asp"] );
                UI.setImage(mainIcon,"FTE/qr_hmx.png");
            }
        }
        UI.updateStage();
    }



    continueBtn.onkey_ENTER = function (){
        fteUpdate(1);
    };

    productRegister.onkey_LEFT = function(){
        fteUpdate(-1);
    }

    productRegister.onkey_RIGHT = continueBtn.onkey_ENTER;

    productRegister.onPop = function(){

    };



}