// Init
UI.moduleBuilder['FTE']['fte_netWifiInput'] = function(){
    var netWifiInputData = {
        inputBgImg: "FTE/fte_txt_fld_mdm_std.png",
        inputBox: "",
        noTextHint: "[SE3014]",//Press OK button  open keyboard
        checkBox: "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_chckbx_active.png",
        connectText: "[SE0187]",    //"Connect",
        text1: "[OT0019]",//Show password
        connectImg: UI.item_bg,
        cancelText: "[SE3067]"//Press BACK button to cancel
    };
    var template = Util.readJson("module/FTE/fte_netWifiInput.json");
    var netWifiInput = SubModule.create(netWifiInputData, template);

    netWifiInput.pageData = {
//        "currPasswd": "",
        "SSID":"",
        "secType":0,
        "authType":0,
        "password":""

    };

    var netWifiResult = UI.getSubModule("fte_netWifiResult");

    var connectBtn = UI.getItem(netWifiInput, "connectBtn");
    var inputField = UI.getItem(netWifiInput, "inputField");
    var inputBox = UI.getItem(netWifiInput, "inputBox");
    var noTextHint = UI.getItem(netWifiInput, "noTextHint");//press OK show soft keyboard
    //创建文本输入框
    var textInfo = {
        initVal : "",
        maxLength : 63,
        maxWidth: 700,
        fontSize : 36,
        isPwd : true,
        showPwd: false,  //true 代表显示星号
        color : "#AAAAAA"
    };
    TextBox.create(inputBox, textInfo, onTextChanged);

    function onTextChanged() {
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
//            connectBtnDisableOrNot(1);
        }
        else {
            noTextHint.alpha = 0.5;
//            connectBtnDisableOrNot(0);
        }
        DBG_INFO("value changed!");
        netWifiInput.pageData.password = inputBox.children[0].realValue;
        inputBox.setText(netWifiInput.pageData.password);
        initWifiInputConnectBtn();
    }

    function netWifiInputDisplay(alphaValue) {
        inputField.alpha = alphaValue;
        connectBtn.alpha = alphaValue;
        disPlayPasswdItem.alpha = alphaValue;
    }

    inputField.onFocus = function (focus) {
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha: 0});
        inputBox.active();
        return false;
    };
    inputField.onNormal = function(focus){
        inputBox.inactive();
//        focus.cache(0, 0, focus.getBounds().width, focus.getBounds().height);
        return true;
    };
    var inputTxt = inputBox.children[0];
    var inputCursor = inputBox.children[1];
    inputField.onkey_RIGHT = function () {
        if (inputBox.inputCursor.index == inputTxt.text.length) {
            UI.focusTo(connectBtn);
        }
        else {
            inputBox.cursorRight();
        }
    };
    inputField.onkey_LEFT = function() {
        inputBox.cursorLeft();
    };
    inputField.onkey_ENTER = function() {
        inputBox.showKeyBoard();
    };

    var proIpNumKey = function() {
        /*inputBox.children[0].realValue += CONST.NUMIPT_VALUE[UI.currKeyValue];
        inputBox.setText(inputBox.children[0].realValue);*/
        var value = CONST.NUMIPT_VALUE[UI.currKeyValue];
        inputBox.children[0].realValue = inputBox.makeText(value);
        inputBox.setText(inputBox.children[0].realValue);

        inputBox.cursorRight();
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
//            connectBtnDisableOrNot(1);
        }
        else {
            noTextHint.alpha = 0.5;
//            connectBtnDisableOrNot(0);
        }
        DBG_INFO("value changed!");
        netWifiInput.pageData.password = inputBox.children[0].realValue;
        initWifiInputConnectBtn();

//        UI.updateStage();
    };
    inputField.onkey_ZERO = proIpNumKey;
    inputField.onkey_ONE = proIpNumKey;
    inputField.onkey_TWO = proIpNumKey;
    inputField.onkey_THREE = proIpNumKey;
    inputField.onkey_FOUR = proIpNumKey;
    inputField.onkey_FIVE = proIpNumKey;
    inputField.onkey_SIX = proIpNumKey;
    inputField.onkey_SEVEN = proIpNumKey;
    inputField.onkey_EIGHT = proIpNumKey;
    inputField.onkey_NINE = proIpNumKey;

    var checkBox = UI.getItem(netWifiInput, "checkBox");
    if (inputBox.children[0].showPwd == true) {
        UI.setImage(checkBox, "FTE/fte_chckbx_inactive.png");
    }
    else {
        UI.setImage(checkBox, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_chckbx_active.png");
    }

    netWifiInput.currFocus = UI.getItem(netWifiInput, "inputField");


    function fteConnectWifi() {
        var password = inputBox.children[0].realValue; //得到密码
        DBG_INFO("[zhangnaiyun] input password -------------> " + password);
        netWifiResult.fteSetNetSetWifiConnPara(getfteNetSetWifiPageConnPare());
        netWifiResult.connectData.operateData.password = password;
        DBG_INFO("wifiConnPara.password set new: " + password);

//        UI.popSubModule();
        //开始尝试连接wifi
        netWifiResult.fteNetSetWifiStartConnNetwork();
    }

    function getfteNetSetWifiPageConnPare(){
        try{
            var data = netWifiResult.pageData;

            netWifiInput.pageData.SSID = data.operateData.currSSIDName;
            netWifiInput.pageData.secType = data.operateData.currSecType;
            netWifiInput.pageData.authType = data.operateData.currAuthType;
            /*var wifiConnPare ={
                "SSID":"",
                "secType":0,
                "authType":0,
                "password":""
            };
            wifiConnPare.SSID = data.operateData.currSSIDName;
            wifiConnPare.secType = data.operateData.currSecType;
            wifiConnPare.authType = data.operateData.currAuthType;*/
            /*if(data.operateData.currState == 1 && data.operateData.connWifiPara.connSSID == data.operateData.currSSIDName){

             if((data.operateData.connWifiPara.connPassword == "") && (model.network.getEnumNetworkAvailable() == 1))
             {
             data.operateData.connWifiPara.connPassword = model.network.getEncryptionPassphrase();


             }
             wifiConnPare.password = data.operateData.connWifiPara.connPassword;
             }else{
             wifiConnPare.password = "";
             }*/
            netWifiInput.pageData.password = data.operateData.connWifiPara.connPassword;
            DBG_INFO("[zhangnaiyun] wifiConnPare.SSID is " + netWifiInput.pageData.SSID);
            DBG_INFO("[zhangnaiyun] wifiConnPare.secType is " + netWifiInput.pageData.secType);
            DBG_INFO("[zhangnaiyun] wifiConnPare.authType is " + netWifiInput.pageData.authType);
            DBG_INFO("[zhangnaiyun] wifiConnPare.password is " + netWifiInput.pageData.password);
            initWifiInputConnectBtn();
            return netWifiInput.pageData;

        }catch (ex){
            DBG_INFO("getSettingNetSetWifiPageConnPare:"+ex.message);
        }
    }

    function initWifiInputConnectBtn(){
        DBG_ERROR("netWifiInput.pageData.secType" + netWifiInput.pageData.secType);
        if(parseInt(netWifiInput.pageData.secType) == 1 || parseInt(netWifiInput.pageData.secType) == 4){
            if(netWifiInput.pageData.password.length > 4){
                setConnectBtnDisableOrNot(false);
            }else{
                setConnectBtnDisableOrNot(true);
            }
        }else{
            if(netWifiInput.pageData.password.length > 7){
                setConnectBtnDisableOrNot(false);
            }else{
                setConnectBtnDisableOrNot(true);
            }
        }
        if(netWifiInput.pageData.password.length>0){
            noTextHint.alpha = 0;
        }

    }

    function setConnectBtnDisableOrNot(disable){
        connectBtn.disable = disable;
        if(disable){
            connectBtn.alpha = 0.3;
        }else{
            connectBtn.alpha = 1;
        }
        UI.updateStage();
    }




//})();

/*-----------------------------------Actions-------------------------------------------*/
//(function(){
    var background = UI.getSubModule("fte_background");
    var network = UI.getSubModule("fte_network");
    var disPlayPasswdItem = UI.getItem(netWifiInput, "disPlayPasswdItem");


    netWifiInput.onPush = function() {
        showSkipEleOrNot(0);
        netWifiInput.currFocus = inputField;
        var data = netWifiResult.pageData;
        netWifiInput.pageData.SSID = data.operateData.currSSIDName;
        if(netWifiInput.caller == "fte_netWifiResult"){
            netWifiInput.pageData.secType = data.operateData.currSecType;
        }else if (netWifiInput.caller == "fte_netAddWifi"){
            netWifiInput.pageData.secType = UI.getSubModule("fte_netAddWifi").pageData.operateData.currSecTypeIdx;
        }
        netWifiInput.pageData.authType = data.operateData.currAuthType;
//        netWifiInput.pageData.password = data.operateData.connWifiPara.connPassword;
        if (netWifiResult.pageData.operateData.clearPassword) {
            netWifiInput.inputBoxClean();
        }
        else {
            try {
                netWifiInputDisplay(1);
                netWifiInput.alpha = 1;
                var connPassword = model.network.getEncryptionPassphrase();
                inputBox.children[0].realValue = connPassword;
                inputBox.setText(inputBox.children[0].realValue);
                inputBox.setCursor(inputBox.children[0].realValue.length);
            }
            catch (ex) {
                DBG_ERROR("netWifiInput.onPush: get current password error");
            }
        }
        netWifiInput.pageData.password = inputBox.children[0].realValue;

        initWifiInputConnectBtn();
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
//            connectBtnDisableOrNot(1);
        }
        else {
            noTextHint.alpha = 0.5;
//            connectBtnDisableOrNot(0);
        }
        disPlayPasswdItem.children[0].isBg = true;
    };

    netWifiInput.onkey_BACKSPACE = function() {
        UI.popSubModule();
//        elementShow(netWifiResult);
        elementShow(UI.getCurrSubModule());
    };

    netWifiInput.inputBoxClean = function() {
        DBG_INFO("netWifiInput clean inputBox");
        netWifiInputDisplay(1);
        netWifiInput.alpha = 1;
        inputBox.children[0].realValue = "";
        inputBox.setText(inputBox.children[0].realValue);
//        inputCursor.index = 0;
        inputBox.inputCursor.index = 0;
        inputBox.cursorLeft();
        UI.updateStage();
    };

    disPlayPasswdItem.onkey_ENTER = function() {
        if (inputBox.children[0].showPwd == true) {
            UI.setImage(checkBox, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_chckbx_active.png");
//            inputBox.children[0].text = inputBox.children[0].realValue;
            inputBox.children[0].showPwd = false;
            inputBox.setText(inputBox.children[0].realValue);
        }
        else {
            UI.setImage(checkBox, "FTE/fte_chckbx_inactive.png");
            inputBox.children[0].showPwd = true;
            inputBox.setText(inputBox.children[0].realValue);
            /*inputBox.children[0].text = "";
            for (var i = 0; i < inputBox.children[0].realValue.length; i++) {
                inputBox.children[0].text += "*";
            }*/
        }
        UI.updateStage();
    };

    connectBtn.onkey_ENTER = function () {
        if (inputBox.children[0].realValue.length > 0) {
            fteConnectWifi();
        }
    };
};
