/**
 * Created by genghailong on 2016/2/29.
 */

/**
 5658的应用启动方式需要修改
 1：opera4x为了保证不影响开机启动速度，不设置为开机启动，所以需要UI在自己成功启动之后将opera4x拉起来
 2：应用的启动命令已经修改，同5657SA是不一样的，具体的方式如下

 :am,opera4x,:resume=[-s,type,-u,url]
 红色的部分固定写死，不要做任何修改，
 -s用来指定是什么应用，可以设置为foxxum/netrange/opera/accedo/hisense/hbbtv/oipf/hibrowser/other，不区分大小写
 -u用来指定URL

 例如：
 TVBrowser启动命令                                   :am,opera4x,:resume=[-s,hibrowser]
 Opera TV Store启动命令                              :am,opera4x,:resume=[-s,opera]
 Opera TV Store下的应用启动命令                        :am,opera4x,:resume=[-s,opera,-u,url]
 Hisense开发的依赖于特定jsplugin的应用的启动命令         :am,opera4x,:resume=[-s,hisense,-u,url]

 启动第三方HTML应用： :am,opera4x,:resume=[-s,store,-u,url] // 如yupptv、aol、pandora等




 EPOS 应用依赖于OPENGL       启动命令            StartEPOS(url);

 StartEPOS("file:///3rd_rw/UI/module/EPOS/epos.html")

 */
UI.templateManager["module/APP/appControl.json"] = {
    appControl: {
        type: 0,
        position: {
            x: 0,
            y: 0
        },
        items: {
            app_bg: {
                type: 7,
                bound: {
                    w: 0,
                    h: 0
                },
                position: {
                    x: 0,
                    y: 0
                },
                navigation: {
                    leftTo: null,
                    rightTo: null,
                    upTo: null,
                    downTo: null
                }
            }
        }
    }
}
;

var appControl;
var NATIVEURL = {
    DAILYMOTION: "http://tvsam-02.ext.dc3.dailymotion.com/live/?manufacturer=hisense",
    CLAROVIDEO: "http://tv2hisense.clarovideo.net/FRONTEND/",
    FANDANGONOW: "https://www-hisense.mgo.com/",
//        PANDORA: "https://tv.pandora.com/?model=HUXXN3050UW&vendor=Hisense&type=HTML5&modelYear=2017&badge=zroiqj2xi2ccm4ffbrvxpijcnsavqthe2b4zn3zhvj5lkqcwa3rq&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8",
    PANDORA: "https://tv.pandora.com/?model=MSD6586&vendor=Hisense&type=HTML5&modelYear=2017&badge=rvfcmxk5dadaivh6yrbhiiodis5kfj2xpdzwoi46r2ph2nsb7x3a&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8",
//        PANDORA:"https://tv.pandora.com/?model=MTK5658&vendor=Sharp&type=HTML5&modelYear=2016&badge=7bsx3s6dur6tkbtu562mnhhgxoh6dwtsen5gh6ldsjlntolr5xua&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8",
    APP4KNOW: "https://4ka.husard.com/",
    DROPBOX: "file:///opt/hisenseUI/html/hisenseUI/module/dropbox/hisenseUI/dropbox.html?module=dropbox",
    PICASA: "file:///opt/hisenseUI/html/hisenseUI/module/picasa/picasaIndex.html",
    EPOS: "file:///opt/hisenseUI/html/hisenseUI/module/EPOS/epos.html",
    QVIEW: "file:///opt/hisenseUI/html/hisenseUI/module/qview/index.html",
    GAMECENTER: "http://appsol.accedo.tv/hisense/matrix.html",
    ALEXAMNUSIC:"file:///opt/hisenseUI/html/hisenseUI/module/Alexa/audioPlayer/audioPlayer.html"
};
var currAppInfo = {
    currentAppName:"",
    currentAppCMD:"",
    currentAMState:"",
    currentLocalAppName:"",
    startMethod:"",
    cmdType:"",
    stopMethod:"",
    storeType:""
}
var appCommondMap = {};

UI.moduleBuilder['APP']['appControl'] = function(){
    DBG_ERROR("UI.moduleBuilder['APP']['appControl'] = function()");
    var template = Util.readJson("module/APP/appControl.json");
    appControl = SubModule.create({
        app_bg: GLOBAL.IMAGE_LIST.NONE
    }, template);
    appControl.currFocus = UI.getItem(appControl, "app_bg");

    function setAppCommondMap(am_name,am_Type, keyset, url) {
        try {
            var obj = {};
            obj.amName = am_name;
            obj.amType = am_Type;
            // obj.amStart = ":am,am,start=" + am_name;
            if ("opera4x" == am_name) {
                obj.amType = "pause";
                obj.amStop = ":am,opera4x,:pause=";
            } else {
//                if ('netflix' == am_name) {
//                    obj.amType = "backgm";
//                    obj.amStop = ":am,am,:backgm=" + am_name;
//                } else {
//                    obj.amStop = ":am,am,:stop=" + am_name;
//                }
                obj.amStop = ":am,am,:stop=" + am_name;
            }
            //obj.amState = AMState.STOPPED;
            obj.disableKey = keyset ? keyset.disable : [];
            obj.enableKey = keyset ? keyset.enable : [];
            obj.URL = url ? url : "";
            return obj;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    appControl.initAppControl = function() {
        DBG_INFO("appControl.initAppControl start " + debugRunTime());
        appCommondMap = {};
        appCommondMap[APPNAME.FACTORY] = setAppCommondMap("factory_lite","stop", null, null);
        appCommondMap[APPNAME.YOUTUBE] = setAppCommondMap("opera4x","pause" , { enable: [], disable: [CONST.KEY.VK_YOUTUBE,CONST.KEY.VK_EXIT]}, APPNAME.YOUTUBE);
        appCommondMap[APPNAME.YOUTUBEKIDS] = setAppCommondMap("youtube_kids","pause" , { enable: [], disable: [CONST.KEY.VK_EXIT]}, null);
        appCommondMap[APPNAME.YOUTUBETV] = setAppCommondMap("youtube_tv","pause" , { enable: [], disable: [CONST.KEY.VK_EXIT,CONST.KEY.VK_CHANNEL_UP,CONST.KEY.VK_CHANNEL_DOWN]}, null);
        appCommondMap[APPNAME.VUDU] = setAppCommondMap("vudu","stop", { enable: [], disable: [CONST.KEY.VK_VUDU]}, null);
        appCommondMap[APPNAME.AMAZON] = setAppCommondMap("amazon","stop", { enable: [], disable: [CONST.KEY.VK_EXIT]}, null);
        appCommondMap[APPNAME.AMAZONRUBY] = setAppCommondMap("amazonruby", "stop", { enable: [], disable: [CONST.KEY.VK_EXIT]}, null);
        appCommondMap[APPNAME.TVSTORE] = setAppCommondMap("opera4x", "pause" ,null, null);
        appCommondMap[APPNAME.TVBROWSER] = setAppCommondMap("opera4x","pause" , null, null);
        appCommondMap[APPNAME.OTT] = setAppCommondMap("opera4x", "pause",{enable: [], disable: [CONST.KEY.VK_BACKSPACE,CONST.KEY.VK_EXIT,CONST.KEY.VK_KEYPAD_CHANNEL_DOWN, CONST.KEY.VK_KEYPAD_CHANNEL_UP]}, "https://hisense-lite-app.xumo.com/latest/index.html");
        appCommondMap[APPNAME.DAILYMOTION] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.DAILYMOTION);
        appCommondMap[APPNAME.CLAROVIDEO] = setAppCommondMap("opera4x", "pasue",null, NATIVEURL.CLAROVIDEO);
        appCommondMap[APPNAME.GAMECENTER] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.GAMECENTER);
        appCommondMap[APPNAME.APP4KNOW] = setAppCommondMap("opera4x", "pause" , null, NATIVEURL.APP4KNOW);
        appCommondMap[APPNAME.FANDANGONOW] = setAppCommondMap("opera4x","pause", null, NATIVEURL.FANDANGONOW);
        appCommondMap[APPNAME.PANDORA] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.PANDORA);
        appCommondMap[APPNAME.PICASA] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.PICASA);
        appCommondMap[APPNAME.EPOS] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.EPOS);
        appCommondMap[APPNAME.ALEXAMNUSIC] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.ALEXAMNUSIC);
        appCommondMap[APPNAME.QVIEW] = setAppCommondMap("opera4x","pause" , null, NATIVEURL.QVIEW);
        appCommondMap[APPNAME.THIRDPARTY] = setAppCommondMap("opera4x","pause" , null, null);
        appCommondMap[APPNAME.OPERA] = setAppCommondMap("opera4x","pause" , null, null);
        appCommondMap[APPNAME.STORE] = setAppCommondMap("opera4x","pause" , null, null);
        appCommondMap[APPNAME.DROPBOX] = setAppCommondMap("opera4x","pause" , {
            enable: [],
            disable: [CONST.KEY.VK_MENU]
        }, NATIVEURL.DROPBOX);
        appCommondMap[APPNAME.NETFLIX] = setAppCommondMap("netflix", "stop",{
            enable: [],
            disable: [CONST.KEY.VK_NETFLIX, CONST.KEY.VK_EXIT]
        }, null);
        DBG_INFO("appControl.initAppControl end " + debugRunTime());
    }

    function doStopCommand(stopMethod) {
        var obj = appCommondMap[currAppInfo.currentAppName];
        if (null == currAppInfo.currentAppName) return;
        if (APPNAME.FACTORY == currAppInfo.currentAppName) {
            //hiWebOsFrame.lockAllKeys("stop Fac");
        } else {
            //showLoadingOrLockKey(obj.amName, false);
        }

//        currAppInfo.currentAMState = AMState.STOPPING;
        appControl.setCurrentAMState(AMState.STOPPING);
        if (stopMethod == CMDMethod.DIALSERVER) {
            DBG_ERROR("doStopCommand:CMDMethod.DIALSERVER,"+ obj.amName +","+obj.amType);
            appStoppedFunc = function(){
                openLiveTVModule();
                resumeDTV();
                appStoppedFunc = null;
            };
            sendAM("",obj.amName,obj.amType,dialStopArg);
        } else {
            sendAM(obj.amStop,
                obj.amName,obj.amType,obj.URL);
        }

    }

    appControl.checkAppStateWhenPowerOn = function(){
        DBG_ERROR("appControl.checkAppStateWhenPowerOn:GLOBAL.FACTORY="+GLOBAL.FACTORY+",GLOBAL.APP_POWER_ON="+GLOBAL.APP_POWER_ON);
        if (1 == GLOBAL.FACTORY) {
            var currFactoryState = parseInt(model.hisfactory.getStateOpen());
            if(currFactoryState == 0){
                DBG_ERROR("appControl.checkAppStateWhenPowerOn:not in factory!");
                GLOBAL.FACTORY = currFactoryState;
                onAmStateChanged(APPNAME.FACTORY,AMState.STOPPED);
            }else{
                currAppInfo.currentAppName = APPNAME.FACTORY;
                currAppInfo.currentAMState = AMState.STARTED;
                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                startThirdPartyApp(APPNAME.FACTORY, null, CMDType.COMMON, CMDMethod.COMMON, true);
            }
        }
        else if (HOTEKEY_MAP.NONE != GLOBAL.APP_POWER_ON) {
            var cover = Config.tv ? (getWizardSetFlag() != 0) : false;
            if(!cover){
                DBG_ERROR("appControl.checkAppStateWhenPowerOn:startup preload App!");
                var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
                switch (HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON]) {
                    case APPNAME.NETFLIX:
                        if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.NETFLIX && AMState.STARTED == appControl.getCurrentAMState()){
                            DBG_ALWAYS("Netflix has been started by system.Do nothing.");
                            model.system.stopAnimation(0);
                        }
                        else{
                            setTimeout(function(){
                                model.system.stopAnimation(0);
                            },4000);
                            UI.callTTS("[SE0734]",0);
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                            openAppControl(HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON], null, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                        }
                        break;
                    case APPNAME.AMAZON:
                        model.system.stopAnimation(0);
                        if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.AMAZON && AMState.STARTED == appControl.getCurrentAMState()){
                            DBG_ERROR("AMAZON has been started by system.Do nothing.");
                        }
                        else {
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                            openAppControl(APPNAME.AMAZON, APPNAME.AMAZON, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                        }
                        break;
                    case APPNAME.AMAZONRUBY:
                        model.system.stopAnimation(0);
                        if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.AMAZONRUBY && AMState.STARTED == appControl.getCurrentAMState()){
                            DBG_ERROR("AMAZONRUBY has been started by system.Do nothing.");
                        }
//                        else if (!getNetworkSatus()) {
//                            try {
//
//                                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
//                            }
//                            catch (ex) {
//                                DBG_ERROR("startLoading error " + ex.message);
//                            }
//                            HOTKEY_TIMEOUT.AMAZONTIMEOUT = setTimeout(function () {
//                                clearTimeout(HOTKEY_TIMEOUT.AMAZONTIMEOUT);
//                                HOTKEY_TIMEOUT.AMAZONTIMEOUT = null;
//                                UI.popGhostModule(APPMODULE.CONTROL);
//                                UI.popGhostModule(APPMODULE.WAITING);
//                                try {
//                                    UI.registerKeyCodes(null);
//                                    UI.setKeyGroup(7);
//                                    UI.unlockAllKeys("init");
//                                } catch (ex) {
//                                    DBG_ERROR(ex.message);
//                                }
//                                DBG_ALWAYS("start AMAZON by hotkey fail,show network dialog!" + checkIsAppOn());
//                                //用于关闭USB弹出框
//                                if (isModuleOpened(COMMON.MAIN)) {
//                                    closeMsgBox();
//                                }
//                                openMsgBox(MsgBoxType.NETWORK_TIP,"AMAZON");
//
//                            }, 15000);
//                        }
                        else {
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                            openAppControl(APPNAME.AMAZONRUBY, APPNAME.AMAZONRUBY, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                        }
                        break;
                    case APPNAME.VUDU:
                        model.system.stopAnimation(0);
                        if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.VUDU && AMState.STARTED == appControl.getCurrentAMState()){
                            DBG_ERROR("VUDU has been started by system.Do nothing.");
                        }
                        else if (!getNetworkSatus()) {
                            try {
                                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                            }
                            catch (ex) {
                                DBG_ERROR("startLoading error " + ex.message);
                            }
                            HOTKEY_TIMEOUT.VUDUTIMEOUT = setTimeout(function () {
                                clearTimeout(HOTKEY_TIMEOUT.VUDUTIMEOUT);
                                HOTKEY_TIMEOUT.VUDUTIMEOUT = null;
                                UI.popGhostModule(APPMODULE.CONTROL);
                                UI.popGhostModule(APPMODULE.WAITING);
                                try {
                                    UI.registerKeyCodes(null);
                                    UI.setKeyGroup(7);
                                    UI.unlockAllKeys("init");
                                } catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                                DBG_ALWAYS("start VUDU by hotkey fail,show network dialog!");
                                //用于关闭USB弹出框
                                if (isModuleOpened(COMMON.MAIN)) {
                                    closeMsgBox();
                                }
                                if(!getNetworkSatus()){
                                    openMsgBox(MsgBoxType.NETWORK_TIP,"VUDU");
                                }else{
                                    UI.callTTS("[SE0739]",0);
                                    UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                                    openAppControl(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                                }
                            }, 15000);
                        }
                        else {
                            UI.callTTS("[SE0739]",0);
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                            openAppControl(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                        }
                        break;
                    case APPNAME.YOUTUBE:
                        model.system.stopAnimation(0);
                        if (null != appGhost && appControl.getCurrentAPPName()==APPNAME.YOUTUBE && AMState.STARTED == appControl.getCurrentAMState()){
                            DBG_ERROR("YOUTUBE has been started by system.Do nothing.");
                        }else if (!getNetworkSatus()) {
                            try {
                                UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                            }
                            catch (ex) {
                                DBG_ERROR("startLoading error " + ex.message);
                            }
                            HOTKEY_TIMEOUT.YOUTUBETIMEOUT = setTimeout(function () {
                                clearTimeout(HOTKEY_TIMEOUT.YOUTUBETIMEOUT);
                                HOTKEY_TIMEOUT.YOUTUBETIMEOUT = null;
                                UI.popGhostModule(APPMODULE.CONTROL);
                                UI.popGhostModule(APPMODULE.WAITING);
                                try {
                                    UI.registerKeyCodes(null);
                                    UI.setKeyGroup(7);
                                    UI.unlockAllKeys("init");
                                } catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                                DBG_ALWAYS("start YOUTUBE by hotkey fail,show network dialog!");
                                //用于关闭USB弹出框
                                if (isModuleOpened(COMMON.MAIN)) {
                                    closeMsgBox();
                                }
                                if(!getNetworkSatus()){
                                    openMsgBox(MsgBoxType.NETWORK_TIP,"YOUTUBE");
                                }else{
                                    UI.callTTS("[LA0015]",0);
                                    UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                                    openAppControl(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                                }
                            }, 15000);
                        }
                        else {
                            UI.callTTS("[LA0015]",0);
                            UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                            openAppControl(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null);
                        }
                        break;
                    default :
                        model.system.stopAnimation(0);
                        DBG_ERROR("Start hotkey app fail,the index is error:" + GLOBAL.APP_POWER_ON);
                        break;
                }
            }else{
                DBG_ERROR("FTE is open!!!");
                UI.popGhostModule(APPMODULE.CONTROL);
            }
        }
        else {
            var ott = readFileFromNative("launcher/ott.txt", 1);
            DBG_ERROR("curr  source  OTT  is "+ JSON.stringify(ott));
            if(ott!=null && ott.name != 0 ){
                GLOBAL.APP_POWER_ON = HOTEKEY_MAP.OTT;
                DBG_ERROR("start OTT !!!!!!!!!!!!!!!!!!!!!!!!!!!:"+ott.name);
                DBG_ERROR("start OTT !!!!!!!!!!!!!!!!!!!!!!!!!!!:"+ott.url);
                DBG_ERROR("start OTT !!!!!!!!!!!!!!!!!!!!!!!!!!!:"+!getNetworkSatus());
                if (!getNetworkSatus()) {
                    try {
                        UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.WAITING);
                    }
                    catch (ex) {
                        DBG_ERROR("startLoading error " + ex.message);
                    }
                    HOTKEY_TIMEOUT.OTT = setTimeout(function () {
                        clearTimeout(HOTKEY_TIMEOUT.OTT);
                        HOTKEY_TIMEOUT.OTT = null;
                        UI.popGhostModule(APPMODULE.CONTROL);
                        UI.popGhostModule(APPMODULE.WAITING);
                        try {
                            UI.registerKeyCodes(null);
                            UI.setKeyGroup(7);
                            UI.unlockAllKeys("init");
                        } catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                        DBG_ALWAYS("start OTT by hotkey fail,show network dialog!");
                        //用于关闭USB弹出框
                        if (isModuleOpened(COMMON.MAIN)) {
                            closeMsgBox();
                        }
                        openMsgBox(MsgBoxType.NETWORK_TIP,APPNAME.OTT);
                    }, 15000);
                } else {
                   // GLOBAL.APP_POWER_ON = HOTEKEY_MAP.NONE;
                   // var obj = {
                   //     "name":0,
                   //     "url":0
                  //  };
                  //  writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                    UI.pushGhostModule(APPMODULE.MAIN, APPMODULE.CONTROL);
                   GLOBAL.APP_POWER_ON = HOTEKEY_MAP.OTT;
                    try {
                        model.cec.setIsMiracastExist(1);
                  } catch (ex) {

                  }
                   openAppControl(HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON], null, CMDType.NATIVEAPP, CMDMethod.STARTUP, false, null, HOTEKEY_MAP.APPNAME[GLOBAL.APP_POWER_ON]);
                }
            }else{
                UI.popGhostModule(APPMODULE.CONTROL);
            }
        }

    }

    appControl.stopCurrentApp = function (stopMethod) {
        DBG_INFO('appControl.stopCurrentApp');
        // for log report @shixin6 not use
        UI.endLoading();
        if (AMState.STOPPED != currAppInfo.currentAMState) {
            UI.lockAllKeys("stopApp");
            doStopCommand(stopMethod);
        }
        else {
            if (currAppInfo.currentAppName == APPNAME.FACTORY) {
                GLOBAL.FACTORY = 0;
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.FACTORY_MODE_CHANGED, 0);
            }
            UI.popGhostModule(APPMODULE.CONTROL);
            UI.registerKeyCodes(null);
            UI.setKeyGroup(7);
        }

    };

    appControl.startCurrentApp = function () {
        try {
            UI.lockAllKeys("startApp");
            var obj = appCommondMap[currAppInfo.currentAppName];
            if (null == obj)
            {
                DBG_ERROR("appControl.startCurrentApp:obj is null");
                return;
            }

            currAppInfo.currentAMState = AMState.STARTING;
            if (APPNAME.FACTORY == currAppInfo.currentAppName || APPNAME.EPOS == currAppInfo.currentAppName) {
                //hiWebOsFrame.lockAllKeys("start Fac");
                //todo ghl 锁键 关掉静音符
                //vol.closeMutePage();
            }
            else {
                pauseDTV();
                //todo ghl loading 锁键
                //showLoadingOrLockKey(obj.amName, true);
            }
            switch (currAppInfo.currentAppName) {
                case APPNAME.NETFLIX:
                {
                    try{
                        //NETFLIX复用YOUTUBE机制提示WOW
                        var youtubeStatus = readFileFromNative("hisenseUI/youtubeStatus", 1);
                        DBG_INFO("youtubeStatus(NETFLIX):" + youtubeStatus);
                        if ("started" != youtubeStatus) {
                            writeFileToNative("hisenseUI/youtubeStatus", "started", 1);
                            var netStatus = readFileFromNative("hisenseUI/hasSetWakebyNet", 1);
                            DBG_INFO("netStatus:" + netStatus);
                            if ("started" != netStatus) {
                                try {
                                    model.network.setWowEnable(1);
                                    model.network.setWolEnable(1);
                                    writeFileToNative("hisenseUI/hasSetWakebyNet", "started", 1);
                                }
                                catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.WAKEBYLANTIP;
                                UI.pushGhostModule("setting", "SettingSysToast");
                            }
                        }
                    }catch (ex){
                        DBG_ERROR("start netflix wake up error,"+ex.message);
                    }
                    if (currAppInfo.startMethod == CMDMethod.REMOTECONTROL) {
                        //sendAM(":am,am,remote:start=netflix");
                        sendAM(":am,am,remote:start=[netflix,-Q,source_type=1&additionalDataUrl=http%3A%2F%2Flocalhost%3A56789%2Fapps%2FNetflix%2Fdial_data%3F]",
                        "netflix","start","source_type=1,--suspend=false");
                    }
                    else if (currAppInfo.startMethod == CMDMethod.DIALSERVER) {
                        sendAM("","netflix","start",dialStartArg);
                    }
                    else if (currAppInfo.startMethod == CMDMethod.STARTUP) {
                        sendAM(":dtv_app_mtk,am,:hotkey=0xef007",
                        "netflix","start","source_type=19,--suspend=false");
                    }
                    else {
                        sendAM(":am,am,menu:start=[netflix,-Q,source_type=2&additionalDataUrl=http%3A%2F%2Flocalhost%3A56789%2Fapps%2FNetflix%2Fdial_data%3F]",
                        "netflix","start","source_type=2,--suspend=false");
                    }
                    break;
                }
                case APPNAME.YOUTUBE:
                {
                    try{
                        //判断YOUTUBE的弹出机制
                        var youtubeStatus = readFileFromNative("hisenseUI/youtubeStatus", 1);
                        DBG_INFO("youtubeStatus:" + youtubeStatus);
                        if ("started" != youtubeStatus) {
                            writeFileToNative("hisenseUI/youtubeStatus", "started", 1);
                            var netStatus = readFileFromNative("hisenseUI/hasSetWakebyNet", 1);
                            DBG_INFO("netStatus:" + netStatus);
                            if ("started" != netStatus) {
                                try {
                                    model.network.setWowEnable(1);
                                    model.network.setWolEnable(1);
                                    writeFileToNative("hisenseUI/hasSetWakebyNet", "started", 1);
                                }
                                catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.WAKEBYLANTIP;
                                UI.pushGhostModule("setting", "SettingSysToast");
                            }
                        }
                    }catch (ex){
                        DBG_ERROR("start youtube wake up error,"+ex.message);
                    }
                    DBG_ERROR("UI.startLoading");
                    UI.startLoading();
                    if (currAppInfo.startMethod == CMDMethod.REMOTECONTROL) {
                        sendAM(":am,am,remote:start=youtube",
                        "opera4x","resume","source:youtube\r\nlaunch:remote\r\n");
                    }
                    else if (currAppInfo.startMethod == CMDMethod.DIALSERVER) {
                        sendAM("","opera4x","resume","source:youtube\r\n"+dialStartArg);
                    }
                    else if (currAppInfo.startMethod == CMDMethod.COMMANDURL) {
                        sendAM(":am,am,:start_ex=[youtube,-w,1280,-h,720,-x,youtube,-m,NO,-u," + currAppInfo.currentAppCMD + "]",
                            "opera4x","resume","source:youtube\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    }
                    else if (currAppInfo.startMethod == CMDMethod.STARTUP) {
                        if(GLOBAL.NEED_START_OPERA4X){
                            DBG_ERROR("NEED_START_OPERA4X");
                            sendAM(":dtv_app_mtk,am,:hotkey=0xef009",
                                "opera4x","start","source:youtube\r\nlaunch:remote\r\n");
                            GLOBAL.NEED_START_OPERA4X = false;
                        }else{
                            sendAM(":dtv_app_mtk,am,:hotkey=0xef009",
                                "opera4x","resume","source:youtube\r\nlaunch:remote\r\n");
                        }
                    }
                    else if (currAppInfo.startMethod == CMDMethod.BYAPP) {
                        if (!!currAppInfo.currentAppCMD && currAppInfo.currentAppCMD != "youtube") {
                            sendAM(':am,am,:start_ex=[browser_base,"-x youtube -u ' + currAppInfo.currentAppCMD + '"]',
                            "opera4x","resume","source:youtube\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                        }
                        else {
                            sendAM(":am,am,menu:start=youtube",
                                "opera4x","resume","source:youtube\r\nlaunch:menu\r\n");
                        }
                    }
                    else {
                        sendAM(":am,am,menu:start=youtube",
                        "opera4x","resume","source:youtube\r\nlaunch:menu\r\n");
                    }
                    break;
                }

                case APPNAME.YOUTUBEKIDS:
                {
                    try{
                        DBG_ERROR("start youtube kids!!!!!!!!!!");
                        sendAM(":am,am,menu:start=youtube_kids",
                            "youtube_kids","start","source:youtube_kids\r\nlaunch:menu\r\n");
                    }catch (ex){
                        DBG_ERROR("start youtube kids error,"+ex.message);
                    }
                    break;
                }
                case APPNAME.YOUTUBETV:
                {
                    try{
                        DBG_ERROR("start youtube tv!!!!!!!!!!");
                        sendAM(":am,am,menu:start=youtube_tv",
                            "youtube_tv","start","source:youtube_tv\r\nlaunch:menu\r\n");
                    }catch (ex){
                        DBG_ERROR("start youtube kids error,"+ex.message);
                    }
                    break;
                }
                case APPNAME.AMAZON:
                case APPNAME.AMAZONRUBY:
                {
                    if (currAppInfo.startMethod == CMDMethod.REMOTECONTROL) {
                        sendAM(":am,am,remote:start=" + obj.amName,
                        "amazon","start","");
                    }
                    else if (currAppInfo.startMethod == CMDMethod.STARTUP) {
                        sendAM(":dtv_app_mtk,am,:hotkey=0xef002",
                        "amazon","start","");
                    }else if(currAppInfo.startMethod == CMDMethod.DIALSERVER){
                        sendAM("","amazon","start",dialStartArg);
                    }
                    else if (currAppInfo.startMethod == CMDMethod.BYAPP) {
                        if (!!currAppInfo.currentAppCMD) {
                            sendAM(':am,am,:start_ex=[browser_base,"-x amazon -u ' + currAppInfo.currentAppCMD + '"]',
                                "amazon","start","url:"+currAppInfo.currentAppCMD+"\r\n");
                        }
                        else {
                            sendAM(':am,am,:start_ex=[browser_base, "-x amazon -l menu"]',
                                "amazon","start","url:"+currAppInfo.currentAppCMD+"\r\n");
                        }
                    }
                    else {
                        sendAM(":am,am,menu:start=" + obj.amName,
                        "amazon","start","");
                    }

                    break;
                }
                case APPNAME.VUDU:
                {
                    if (currAppInfo.startMethod == CMDMethod.REMOTECONTROL) {
                        sendAM(":am,am,remote:start=vudu",
                        "vudu","start","VuduButtonPressed=Yes");
                    }
                    else if (currAppInfo.startMethod == CMDMethod.STARTUP) {
                        sendAM(":dtv_app_mtk,am,:hotkey=0xef004",
                        "vudu","start","VuduButtonPressed=Yes");
                    }
                    else {
                        if (null != currAppInfo.currentAppCMD && currAppInfo.currentAppCMD.indexOf("http") > -1) {
//                            var movieId = currAppInfo.currentAppCMD.split("/").reverse()[0];
                            var movieId = 0;
                            var array = currAppInfo.currentAppCMD.split("/");
                            for(var i =0; i<array.length;i++){
                                if (!isNaN(array[i]) && !!array[i]) {
                                    movieId = array[i];
                                }
                            }
//                            sendAM(":am,am,menu:start=[vudu,-l," + movieId + "]",
//                            "vudu","start","");
                            sendAM(":am,am,menu:start=vudu",
                                "vudu","start","movieid="+movieId);
                        } else {
                            sendAM(":am,am,menu:start=vudu",
                            "vudu","start","");
                        }
                    }

                    break;
                }
                case APPNAME.DROPBOX:
                {
                    try {
                        sendAM(":am,opera4x,:resume=[-s,hisense,-u," + NATIVEURL.DROPBOX + "]",
                        "hisense","resume","source:hisense\r\nurl:"+NATIVEURL.DROPBOX+"\r\n");
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                }
                case APPNAME.TVSTORE:
                {
                    //sendAM(":am,opera4x,store:resume=[-s,opera]");
                    sendAM(":am,opera4x,:resume=[-s,opera]",
                    "opera4x","resume","source:opera\r\n");
//                    sendAM("webapp_histore");//dbtag:20161128
                    break;
                }
                case APPNAME.TVBROWSER:
                {
                    //sendAM(":am,opera4x,hibrowser:resume="); //old
                    sendAM(":am,opera4x,:resume=[-s,hibrowser]",
                    "opera4x","resume","source:browser\r\n");
//                    sendAM("webapp_hibrowser");//dbtag:20161128
                    break;
                }
                case APPNAME.DAILYMOTION:
                case APPNAME.GAMECENTER:
                case APPNAME.STORE:
                case APPNAME.PANDORA:
                case APPNAME.CLAROVIDEO:
                case APPNAME.APP4KNOW:
                {
                    sendAM(":am,opera4x,:resume=[-s,store,-u," + obj.URL + "]",
                    "opera4x","resume","source:store\r\nurl:"+obj.URL+"\r\n");
                    break;
                }
                case APPNAME.FANDANGONOW:
                {
                    var appUrl = getAppUrlByName(currAppInfo.currentAppName);
                    DBG_INFO("appUrl is :"+appUrl);
                    if (!!appUrl && appUrl.indexOf("http") > -1) {
                        currAppInfo.currentAppCMD = appUrl;
                    }//FIX 4KNOW STARTED BY HOTKEY.
                    else{
                        currAppInfo.currentAppCMD = obj.URL;
                    }
                    sendAM(":am,opera4x,:resume=[-s,store,-u," + currAppInfo.currentAppCMD + "]","opera4x","resume","source:store\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    break;
                }
                case APPNAME.OTT:
                {
                    if (currAppInfo.startMethod == CMDMethod.REMOTECONTROL || currAppInfo.startMethod == CMDMethod.MENU) {
                        try {
                            var ott = readFileFromNative("launcher/ott.txt", 1);
                            var appUrl = ott.url;
                            DBG_INFO("appUrl is :"+appUrl);
                            sendAM(":am,opera4x,:resume=[-s,store,-u," + appUrl + "]",
                                "opera4x","resume","source:store\r\nurl:"+appUrl+"\r\n"+"launch:menu\r\n");
                        }
                        catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                    } else if (currAppInfo.startMethod == CMDMethod.STARTUP) {
                        DBG_INFO("wch get the obj.url is "+obj.URL);
                        UI.startLoading();
                        try {
                            if(GLOBAL.OPERA_STARTED){
                                var ott = readFileFromNative("launcher/ott.txt", 1);
                                var appUrl = ott.url;
                                DBG_INFO("wch in appUrl is :"+appUrl);
                                sendAM(":am,opera4x,:resume=[-s,store,-u," + appUrl + "]",
                                    "opera4x","resume","source:store\r\nurl:"+appUrl+"\r\n"+"launch:remote\r\n");
                            }else{
                                GLOBAL.OTT_NEED_START_OPERA_STARTED = true;
                            }

                        }
                        catch (ex) {
                            DBG_ERROR(ex.message);
                        }
                    }
                    break;
                }
                case APPNAME.PICASA:
                case APPNAME.QVIEW:
                {
                    sendAM(":am,opera4x,:resume=[-s,hisense,-u," + obj.URL + "]",
                    "opera4x","resume","source:hisense\r\nurl:"+obj.URL+"\r\n");
                    break;
                }
                case APPNAME.EPOS:
                {
                    DBG_INFO("current signal is: " + GLOBAL.S_NO_SIGNAL);
                    if(GLOBAL.S_NO_SIGNAL){
                        UI.startLoading();
                    }
                    sendAM(":am,opera4x,:resume=[-s,hisense,-u," + NATIVEURL.EPOS + "]",
                        "opera4x","resume","source:hisense\r\nurl:"+NATIVEURL.EPOS+"\r\n");
                    break;
                }
                case APPNAME.ALEXAMNUSIC:
                {
                    sendAM(":am,opera4x,:resume=[-s,hisense,-u," + NATIVEURL.ALEXAMNUSIC + "]",
                        "opera4x","resume","source:hisense\r\nurl:"+NATIVEURL.ALEXAMNUSIC+"\r\n");
                    break;
                }
                case APPNAME.OPERA:
                {
                    sendAM(":am,opera4x,:resume=[-s,opera,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:opera\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    break;
                }
                case APPNAME.THIRDPARTY:
                {
                    //sendAM(":am,opera4x,store:resume=[-u," + currAppInfo.currentAppCMD + ",-s,opera]");

                    //@fanjie 此处36用于启动启动opera预制应用，37用于启动第三方html,CMDType.NATIVEAPP命名不一定合适
//                    if (currAppInfo.cmdType == CMDType.NATIVEAPP) {
//                        sendAM(":am,opera4x,:resume=[-s,store,-u," + currAppInfo.currentAppCMD + "]",
//                        "opera4x","resume","source:store\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
//                    } else {
//                        sendAM(":am,opera4x,:resume=[-s,opera,-u," + currAppInfo.currentAppCMD + "]",
//                        "opera4x","resume","source:opera\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
//                    }

                    if (currAppInfo.storeType == StoreType.STORE) {
                        sendAM(":am,opera4x,:resume=[-s,store,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:store\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    } else if (currAppInfo.storeType == StoreType.HISENSE) {
                        sendAM(":am,opera4x,:resume=[-s,hisense,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:hisense\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");

//                        sendAM(":am,opera4x,:resume=[-s,hisense,-u," + currAppInfo.currentAppCMD + "]");
                    } else if (currAppInfo.storeType == StoreType.FOXXUM) {
                        sendAM(":am,opera4x,:resume=[-s,foxxum,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:foxxum\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");

//                        sendAM(":am,opera4x,:resume=[-s,foxxum,-u," + currAppInfo.currentAppCMD + "]");
                    } else if (currAppInfo.storeType == StoreType.BROWSER) {
                        sendAM(":am,opera4x,:resume=[-s,hibrowser,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:browser\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
//                        sendAM(":am,opera4x,:resume=[-s,hibrowser,-u," + currAppInfo.currentAppCMD + "]");
                    }
                    else if (currAppInfo.storeType == StoreType.OPERA) {
                        sendAM(":am,opera4x,:resume=[-s,opera,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:opera\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    } else {
                        sendAM(":am,opera4x,:resume=[-s,store,-u," + currAppInfo.currentAppCMD + "]",
                        "opera4x","resume","source:store\r\nurl:"+currAppInfo.currentAppCMD+"\r\n");
                    }
                    break;
                }
                case APPNAME.FACTORY:
                {
//                    sendAM("HisFactory");
                    sendAM(":am,am,:start=factory_lite",
                    "factory_lite","start","");
                    break;
                }
                default:
                {
                    DBG_ERROR("comming soon");
                    //todo ghl  stop loading or keylock
                    //endLoadingOrLockKey(obj.amName, true);
                    //hiWebOsFrame[appControl.id].hiFocus();
                    break;
                }
            }
            if (window.gc) window.gc();
            if (GLOBAL.NEED_START_OPERA4X) {
                DBG_ERROR("NEED_START_OPERA4X");
                sendAM(":am,am,:start=opera4x","opera4x","start","");
                GLOBAL.NEED_START_OPERA4X = false;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    appControl.setAppParameters = function (appname, appcmd, cmdtype, startmethod,storetype,localAppName) {
        currAppInfo.currentAppName = appname;
        currAppInfo.currentAppCMD = appcmd;
        currAppInfo.cmdType = cmdtype;
        currAppInfo.startMethod = startmethod;
        currAppInfo.stopMethod = "";
        currAppInfo.storeType =storetype;
        currAppInfo.currentLocalAppName =localAppName;

    };

    appControl.getCurrentAPPCMD = function () {
        if (checkIsAppOn()) {
            return currAppInfo.currentAppCMD;
        } else {
            return null;
        }
    };

    appControl.getCurrentAPPName = function () {
        DBG_INFO("current app name: " + currAppInfo.currentAppName);
        return currAppInfo.currentAppName;
    };
    appControl.getCurrentLocalAPPName = function () {
        DBG_INFO("current Local app name: " + currAppInfo.currentLocalAppName);
        return currAppInfo.currentLocalAppName;
    };
    appControl.getCurrentStartMethod = function () {
        DBG_INFO('appControl.getCurrentStartMethod: ' + currAppInfo.startMethod);
        return currAppInfo.startMethod;
    };
    appControl.setCurrentStartMethod = function (startmethod) {
        currAppInfo.startMethod = startmethod;
        DBG_INFO('appControl.getCurrentStartMethod: ' + currAppInfo.startMethod);
    };

    appControl.getCurrentAMName = function () {
        var obj = appCommondMap[currAppInfo.currentAppName];
        if (null == obj) return null;
        DBG_INFO("current am name: " + obj.amName);
        return obj.amName;
    };

    appControl.setCurrentAMState = function (amstate) {
        DBG_INFO('currAppInfo.currentAMState = ' + amstate);
        currAppInfo.currentAMState = amstate;
    };

    appControl.getCurrentAMState = function () {
        return currAppInfo.currentAMState;
    };

    appControl.registerAppKeyCodes = function(disable, enable) {
        var baseKey = [
            CONST.KEY.VK_LAUNCHER, CONST.KEY.VK_EXIT, CONST.KEY.VK_LIVETV,CONST.KEY.VK_SERVICE_TUNER1,CONST.KEY.VK_SERVICE_TUNER2,
            CONST.KEY.VK_AV1,CONST.KEY.VK_AV2,CONST.KEY.VK_AV3,CONST.KEY.VK_COMPONENT1,CONST.KEY.VK_COMPONENT2,CONST.KEY.VK_COMPONENT3,
            CONST.KEY.VK_HDMI1,CONST.KEY.VK_HDMI2,CONST.KEY.VK_HDMI3,CONST.KEY.VK_HDMI4,CONST.KEY.VK_HDMI5,
            CONST.KEY.VK_VGA,CONST.KEY.VK_PICTURE,CONST.KEY.VK_S_MODE, CONST.KEY.VK_ASPECT,CONST.KEY.VK_PICMODE_WIDE,
            CONST.KEY.VK_PICMODE_NORMAL,CONST.KEY.VK_PICMODE_CINEMA,CONST.KEY.VK_PICMODE_PANORAMA,CONST.KEY.VK_PICMODE_ZOOM,CONST.KEY.VK_PICTURE_MOVIE,
            CONST.KEY.VK_SOUND_MOVIE,
            CONST.KEY.VK_MENU, CONST.KEY.VK_SETTINGS,CONST.KEY.VK_ALLAPP, CONST.KEY.VK_NETFLIX,
            CONST.KEY.VK_VUDU, CONST.KEY.VK_SOURCE, CONST.KEY.VK_MUTE,
            CONST.KEY.VK_YOUTUBE, CONST.KEY.VK_VOLUME_DOWN, CONST.KEY.VK_VOLUME_UP,
            CONST.KEY.VK_AMAZON, CONST.KEY.VK_FAC_M, CONST.KEY.VK_KEYPAD_VOLUME_DOWN,
            CONST.KEY.VK_KEYPAD_VOLUME_UP, CONST.KEY.VK_SLEEP, CONST.KEY.VK_ASPECT,CONST.KEY.VK_PLAYPAD,
            CONST.KEY.VK_KEYPAD_CHANNEL_DOWN, CONST.KEY.VK_KEYPAD_CHANNEL_UP, CONST.KEY.VK_KEYPAD_MENU,
            CONST.KEY.VK_EPG, CONST.KEY.VK_KPAD, CONST.KEY.VK_BT_CONNECT, CONST.KEY.VK_KEYPAD_MENU_BUTTON7,
            CONST.KEY.VK_KEYPAD_INPUT,CONST.KEY.VK_MEDIA,CONST.KEY.VK_FANDANGONOW,CONST.KEY.VK_OPERASTORE,
            CONST.KEY.VK_ACCUWEATHER,CONST.KEY.VK_FOURKNOW,CONST.KEY.VK_DAILYMOTION,CONST.KEY.VK_CLARO,
            CONST.KEY.VK_BROWSER,CONST.KEY.VK_SHORT_LINE,CONST.KEY.VK_VOICE,CONST.KEY.VK_VOICE_DOWN,CONST.KEY.VK_VOICE_UP,CONST.KEY.VK_TIKILIVE,
            CONST.KEY.VK_PICTURE_THEATER,CONST.KEY.VK_PICTURE_SPORTS,CONST.KEY.VK_FOURKNOW,CONST.KEY.VK_FANDANGONOW
        ];
        for (var i = 0; i < disable.length; i++) {
            var idx = baseKey.indexOf(disable[i]);
            idx >= 0 && baseKey.splice(idx, 1);
        }
        for (var i = 0; i < enable.length; i++) {
            baseKey.push(enable[i]);
        }
        DBG_INFO("currAppInfo.currentAppName is " + currAppInfo.currentAppName + " UI.registerKeyCodes(baseKey)");

        UI.registerKeyCodes(baseKey);
        UI.setKeyGroup(7);//dbtag:20161227-for the second to get launcher



    }

    appControl.focusCurrentApp = function (notShowPwd) {
        UI.hideCursor();
        DBG_INFO('appControl.focusCurrentApp: ' + currAppInfo.currentAppName);
        var obj = appCommondMap[currAppInfo.currentAppName];
        if (null == obj) return;
        if (APPNAME.FACTORY == currAppInfo.currentAppName) {
            GLOBAL.FACTORY = 1;
            UI.registerKeyCodes([CONST.KEY.VK_FAC_M])
            UI.setKeyGroup(0);
            UI.unlockAllKeys("fac");
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.FACTORY_MODE_CHANGED, 1);
        }
        else {
            appControl.registerAppKeyCodes(obj.disableKey, obj.enableKey);
        }
        if (HOTEKEY_MAP.NONE != GLOBAL.APP_POWER_ON) {
            try {
                DBG_ERROR("onkeyopen");
                LogReportData.currentHotKeyTime = 0;
                LGReport.GTAPPRunHotKey(true);
                UI.endLoading();
            } catch (ex) {
                DBG_ERROR(ex.message)
            }
            clearOpenFromStandbyFlag();
            if ("base" != UI.getCurrModule().name) UI.clearAllSubModule(LIVETV.MAIN);
            //UI.unlockAllKeys("init");
        }
        DBG_INFO('appControl.focusCurrentApp notShowPwd: ' + notShowPwd);
        DBG_INFO('appControl.focusCurrentApp notShowPwd: ' + !!notShowPwd);
        if(!!notShowPwd){

        }else{
            if(checkIsOTTLock()){
                onOttShowPwdDialogChanged(1);
            }
        }
        try {
            if (!!currAppInfo.currentLocalAppName) {

                pubStateApp(currAppInfo.currentLocalAppName, getNativeUrl(currAppInfo.currentAppCMD));

            }
            else {
                pubStateApp(currAppInfo.currentAppName, getNativeUrl(currAppInfo.currentAppCMD));
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        UI.base.cursor.alpha = 0;
    };

    appControl.onkey_MENU = function () {
        try {
            DBG_INFO("onkey_MENU");
            /*if (currAppInfo.currentAppName == APPNAME.EPOS) {
                appControl.onkey();
            }*/

            if (currAppInfo.currentAMState != AMState.STARTED) {
                DBG_INFO('currAppInfo.currentAMState != AMState.STARTED; return;');
                return;
            }
            if (currAppInfo.currentAppName == APPNAME.EPOS) {
                var hasSetLanguage = readFileFromNative('hisenseUI/hasSetLanguage.txt', 1);
                if(hasSetLanguage == null){
                    UI.pushSubModule("setting", "storeModeLanguageSelect", true);
                    return;
                }else{
                    resetPQAQ(true);
                }
            }
            DBG_ERROR(" UI.getCurrModule().name is " + UI.getCurrModule().name);
            if (UI.getCurrModule().name == "base") {
                //var curModeIndex = tv? model.system.getUserMode(): 0;
                //if(curModeIndex != 0){
                //    UI.pushSubModule("setting",  "storeModeSettingMenu", true, {origin:"APP"});
                //}
                //else{
                    UI.pushSubModule("setting", "menuChip", true, {origin: "APP"});
                //}
                if(currAppInfo.currentAppName == APPNAME.EPOS){
                    modeljs.sendAppMessage("opera4x",'{"type":"APPMessage","source":"launcher","status":"keydown"}');
                }
                registerKeyCodesForUI();
                UI.setKeyGroup(7);
            }
            else if(!!UI.getCurrSubModule()&&
                !!UI.getCurrSubModule().name&&
                UI.getCurrSubModule().name=="menuChip"){
                var menuChip=UI.getSubModule("menuChip");
                if(!!menuChip)
                {
                    menuChip["onkey_MENU"]();
                }
            }else if(UI.getCurrModule().name == "EposMessage"){
                UI.popSubModule();
                if(checkIsAppOn())
                {
                    registerKeyCodesForApp();
                }
            }

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    appControl.onkey = function () {
        if(UI.getCurrSubModule().name == "storeModeLanguageSelect"){
            DBG_ERROR("getCurrSubModule IS storeModeLanguageSelect");
            return true;
        }
        if (currAppInfo.currentAppName == APPNAME.EPOS) {
            var hasSetLanguage = readFileFromNative('hisenseUI/hasSetLanguage.txt', 1);
            if(hasSetLanguage == null){
                UI.pushSubModule("setting", "storeModeLanguageSelect", true);
                return;
            }else{
                modeljs.sendAppMessage("opera4x",'{"type":"APPMessage","source":"launcher","status":"keydown"}');
                resetPQAQ(true);
                if (UI.getCurrSubModule().name == "standbyControl") {
                    UI.getCurrSubModule().onkey();
                }
                return true;
            }
        }else{
            return true;
        }
    };

    /**
     *  xuzhipeng
     * @param id    无用；
     * @param result 1成功 0 失败
     */
        //function StartEPOSCallBack(id, result) {
        //    DBG_ALWAYS('StartEPOSCallBack: id:' + id + ', result: ' + result);
        //    if (appControl.getCurrentAPPName() != APPNAME.EPOS) {
        //        DBG_ALWAYS('appControl.getCurrentAMName() != APPNAME.EPOS, return;');
        //        return;
        //    }
        //
        //    var RESULT_ENUM = {FAIL: 0, SUCCESS: 1};
        //    if (RESULT_ENUM.SUCCESS == result) {
        //        appControl.setCurrentAMState(AMState.STARTED);
        //        appControl.focusCurrentApp();
        //        UI.unlockAllKeys("appStarted StartEPOSCallBack Success");
        //    } else {
        //
        //        //appControl.setCurrentAMState(AMState.STOPPED);
        //        appControl.stopCurrentApp();
        //        //
        //        ////todo 该用哪一个？
        //        //openLiveTVModule();
        //        ////resumeDTV();
        //        //appStoppedFunc = null;
        //        //UI.unlockAllKeys("appStopped");
        //        //StopEposCallBack();
        //    }
        //}
        //
        //function StopEposCallBack() {
        //    try {
        //        appControl.setCurrentAMState(AMState.STOPPED);
        //        appControl.stopCurrentApp();    //AMState.STOPPED 时，会有popGhostModule(AppControl)等操作
        //        //todo 该用哪一个？
        //        openLiveTVModule();
        //        //resumeDTV();
        //        appStoppedFunc = null;  // todo 是否执行？
        //        UI.unlockAllKeys("appStopped StopEposCallBack");
        //
        //
        //    } catch (ex) {
        //        DBG_ERROR(ex.message);
        //    }
        //}

};



