// Init
UI.moduleBuilder['setting']['storeModeLanguageSelect'] = function(){

    var initData = {
        storeModeLanguageListBg:UI.window_bg,
        storeModeLanguageTitle:"[SE3588]"
    };
    var template = Util.readJson("module/setting/storeModeLanguageSelect.json");
    var storeModeLanguageSelect = SubModule.create(initData, template);
    storeModeLanguageSelect.noAutoClose = true;
    var List = UI.getItem(storeModeLanguageSelect,"List");
    var storeModeLanguageSelectPageData = {
        "currLanguageIdx":0,
        "languageList":[]
    };
    // 初始化Grid控件
    // 取得目标锚点
    function resetGrid(){
        // Grid的配置信息JSON
        var info = {
            // 每个图标使用的模板名
            template : "HotelLanguageList",
            // V表示竖向排列，H表示横向排列
            direction : CONST.GIRD_DIRECTION.H,
            // 每隔几个图标就换行
            breakNum : 3,
            // 每隔图标之间的距离
            distanceX : 30,
            distanceY : 30,
            // 要将此Grid添加到哪个锚点位置上
            container : List
        };
        // 声明一个初始化用数组，将数据配置好
        var allArray =[];
        for (var i = 0; i < storeModeLanguageSelectPageData.languageList.length; i++) {
            allArray.push(
                {
                    ItemName : storeModeLanguageSelectPageData.languageList[i].name,
                    tileBg:UI.item_bg,
                    name : "item" + i,
                    isFlag: "setting/blank.png"
                }
            )
        }
        List.removeAllChildren();
        removeLiveTVShape(List);
        // 调用Grid.create方法生成Gird并添加到锚点位置上
        Gird.create(allArray, info);
        // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）
        UI.addMask(List, 1810, 756,30,10);
        UI.setView(List, 1810, 756);
        UI.addScrollbar(List,-50);
    }

    storeModeLanguageSelect.onPush = function(){
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED,onLanguageChanged);
        UI.registerKeyCodes([CONST.KEY.VK_VOLUME_UP,CONST.KEY.VK_VOLUME_DOWN,CONST.KEY.VK_MUTE,CONST.KEY.VK_UP,CONST.KEY.VK_DOWN, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT, CONST.KEY.VK_BACKSPACE, CONST.KEY.VK_ENTER]);
        UI.setKeyGroup(7);
        initPageData();
        resetGrid();
        storeModeLanguageSelect.currFocus = UI.getItem(List, "item"+storeModeLanguageSelectPageData.currLanguageIdx);
        UI.setImage(storeModeLanguageSelect.currFocus.children[2],"setting/language_selected.png");
    };

    function initPageData(){
        storeModeLanguageSelectPageData.languageList = GetSysOSDLanguageMapList(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);
        storeModeLanguageSelectPageData.currLanguageIdx = 0;
        var langCode = tv ? model.language.getOsd() : 1;
        DBG_INFO("initPageData:"+langCode);
        for(var i = 0; i < storeModeLanguageSelectPageData.languageList.length; i++){
            if(storeModeLanguageSelectPageData.languageList[i].number == langCode){
                storeModeLanguageSelectPageData.currLanguageIdx = i;
                break;
            }
        }
    }
    List.onkey_ENTER = function(focus) {
        var index = List.initSequence.indexOf(focus);
        if(index != storeModeLanguageSelectPageData.currLanguageIdx){
            UI.setImage(List.children[storeModeLanguageSelectPageData.currLanguageIdx].children[2],"setting/blank.png");
            UI.setImage(List.children[index].children[2],"setting/language_selected.png");
            if(tv){
                model.language.setOsd(storeModeLanguageSelectPageData.languageList[index].number);
                writeFileToNative('hisenseUI/hasSetLanguage.txt', "hasSetLanguage", 1);
            }
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED, storeModeLanguageSelectPageData.languageList[index].number);

        }else{
            writeFileToNative('hisenseUI/hasSetLanguage.txt', "hasSetLanguage", 1);
            UI.popSubModule();
        }
    };
    function onLanguageChanged(code){
        for(var i = 0; i < storeModeLanguageSelectPageData.languageList.length; i++){
            if(storeModeLanguageSelectPageData.languageList[i].number == code){
                if(storeModeLanguageSelectPageData.currLanguageIdx != i){
                    UI.setImage(List.children[storeModeLanguageSelectPageData.currLanguageIdx].children[2],"setting/blank.png");
                    UI.setImage(List.children[i].children[2],"setting/language_selected.png");
                    storeModeLanguageSelectPageData.currLanguageIdx = i;
                }
                break;
            }
        }
        UI.popSubModule();
    }
    storeModeLanguageSelect.onkey_BACKSPACE = function(){
        UI.popSubModule();
    }
    storeModeLanguageSelect.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED,onLanguageChanged);
        registerKeyCodesForApp();
        UI.setKeyGroup(7);
    };

};