// Init
UI.moduleBuilder['setting']['picPanelColorTuner'] = function(){
    try {

        var initImgData = {
            picColorTunerPointIcon:"setting/pic/linkage_point.png",
            picPanelColorTunerBg: UI.window_bg,
            PanelColorTunerColorBar: UI.item_bg,
            PanelColorTunerHueBar: UI.item_bg,
            PanelColorTunerSaturationBar: UI.item_bg,
            PanelColorTunerBrightnessBar: UI.item_bg,
            PanelColorTunerResetBar: UI.item_bg
        };
        var template = Util.readJsonObject("module/setting/picPanelColorTuner.json");
        var picPanelColorTuner = SubModule.create(initImgData, template);
        picPanelColorTuner.noAutoClose = true;

        var PicPanelColorTunerPageData = {
            colorTunerTextVec: ["[SE0517]", "[SE0519]", "[SE0521]", "[SE0536]", "[SE0537]", "[SE0538]", "[SE2532]"],
            PanelColorTunerColorVal: 0,
            PanelColorTunerHueVal: 0,
            PanelColorTunerSaturationVal: 0,
            PanelColorTunerBrightnessVal: 0
        };
        DBG_INFO("PicTunerStep.HueStep: "+getPicHueStep());

        picPanelColorTuner.onPush = function () {
            ModelNotifyInit();
            PicPanelColorTunerPageInit();
            UI.getCurrModule().currFocus = picPanelColorTuner.currFocus = UI.getItem(picPanelColorTuner, "PanelColorTunerColor");
            UI.updateStage();
        };

        picPanelColorTuner.onShow = function () {
            picPanelColorTuner.alpha = 1;
        };

        function PicPanelColorTunerPageInit() {
            try {
                var PanelColorTunerColorValTemp = tv ? model.video.getColor() : 2;
                PicPanelColorTunerPageData.PanelColorTunerColorVal = PicPanelColorTunerPageData.colorTunerTextVec[PanelColorTunerColorValTemp];
                DBG_INFO('model.video.getColor(): ' + PanelColorTunerColorValTemp);
                onColorChaged(PanelColorTunerColorValTemp);

                PicPanelColorTunerPageData.PanelColorTunerHueVal = tv ? model.video.getColorHue() : 2;
                DBG_INFO('model.video.getColorHue(): ' + PicPanelColorTunerPageData.PanelColorTunerHueVal);
//                PicPanelColorTunerPageData.PanelColorTunerHueVal=Math.round(PicPanelColorTunerPageData.PanelColorTunerHueVal/PicTunerStep.HueStep);
                onColorHueChaged(PicPanelColorTunerPageData.PanelColorTunerHueVal);

                PicPanelColorTunerPageData.PanelColorTunerSaturationVal = tv ? model.video.getColorSaturation() : 3;
                DBG_INFO('model.video.getColorSaturation(): ' + PicPanelColorTunerPageData.PanelColorTunerSaturationVal);
//                PicPanelColorTunerPageData.PanelColorTunerSaturationVal=Math.round(PicPanelColorTunerPageData.PanelColorTunerSaturationVal/PicTunerStep.HueStep);
                onColorSaturationChaged(PicPanelColorTunerPageData.PanelColorTunerSaturationVal);

                PicPanelColorTunerPageData.PanelColorTunerBrightnessVal = tv ? model.video.getColorBrightness() : 10;
                DBG_INFO('model.video.getColorBrightness(): ' + PicPanelColorTunerPageData.PanelColorTunerBrightnessVal);
//                PicPanelColorTunerPageData.PanelColorTunerBrightnessVal=Math.round(PicPanelColorTunerPageData.PanelColorTunerBrightnessVal/PicTunerStep.HueStep);
                onColorBrightnessChaged(PicPanelColorTunerPageData.PanelColorTunerBrightnessVal);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var PanelColorTunerColor = UI.getItem(picPanelColorTuner, "PanelColorTunerColor");
        var PanelColorTunerHue = UI.getItem(picPanelColorTuner, "PanelColorTunerHue");
        var PanelColorTunerSaturation = UI.getItem(picPanelColorTuner, "PanelColorTunerSaturation");
        var PanelColorTunerBrightness = UI.getItem(picPanelColorTuner, "PanelColorTunerBrightness");
        var PanelColorTunerReset = UI.getItem(picPanelColorTuner, "PanelColorTunerReset");

        function CreateLabelFunc(label, labelStr) {
            try {

                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize);
                cmpValue.setValue(eval('PicPanelColorTunerPageData.' + label.name + "Val").toString());
                UI.updateStage();

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateLabelFunc(PanelColorTunerColor, "[SE1833]");
        CreateLabelFunc(PanelColorTunerHue, "[SE0013]");
        CreateLabelFunc(PanelColorTunerSaturation, "[SE0488]");
        CreateLabelFunc(PanelColorTunerBrightness, "[SE0011]");

        PanelColorTunerColor.onkey_ENTER = function () {
            PictureConfig.PicColorTunerSign = PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_COLOR;
            HidePicPanelColorTuner();
            UI.pushSubModule("setting", "picColorTunerAdjust", true);
            DBG_INFO('PanelColorTunerColor.onkey_ENTER');
        };

        PanelColorTunerHue.onkey_ENTER = function () {
            PictureConfig.PicColorTunerSign = PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_HUE;
            HidePicPanelColorTuner();
            UI.pushSubModule("setting", "picColorTunerAdjust", true);
            DBG_INFO("PanelColorTunerHue.onkey_ENTER");
        };

        PanelColorTunerSaturation.onkey_ENTER = function () {
            PictureConfig.PicColorTunerSign = PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_SATURATION;
            HidePicPanelColorTuner();
            UI.pushSubModule("setting", "picColorTunerAdjust", true);
            DBG_INFO("PanelColorTunerSaturation.onkey_ENTER");
        };

        PanelColorTunerBrightness.onkey_ENTER = function () {
            PictureConfig.PicColorTunerSign = PicSignDefine.PicColorTunerSign.PIC_COLOR_TUNER_BRIGHTNESS;
            HidePicPanelColorTuner();
            UI.pushSubModule("setting", "picColorTunerAdjust", true);
            DBG_INFO("PanelColorTunerBrightness.onkey_ENTER");
        };

        PanelColorTunerReset.onkey_ENTER = function () {
            DBG_INFO('PanelColorTunerReset.onkey_ENTER');
            //UI.popSubModule();
            HidePicPanelColorTuner();
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_COLOR_TUNER_RESET;
            UI.pushSubModule("setting", "picReset", true);
        };

        function HidePicPanelColorTuner() {
            picPanelColorTuner.alpha = 0;
        }


        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_TUNER_COLOR, onColorChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_HUE, onColorHueChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SATURATION, onColorSaturationChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_BRIGHTNESS, onColorBrightnessChaged);

//                model.video.onColorChaged = onColorChaged;
//                model.video.onColorHueChaged = onColorHueChaged;
//                model.video.onColorSaturationChaged = onColorSaturationChaged;
//                model.video.onColorBrightnessChaged = onColorBrightnessChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var onColorChaged = function (val) {
            try {
                DBG_INFO("onColorChaged: " + val);
                val = ({0:5,1:0,2:3,3:1,4:4,5:2,6:6}[val]);
                PicPanelColorTunerPageData.PanelColorTunerColorVal = PicPanelColorTunerPageData.colorTunerTextVec[val];
                UILabelSetVal(PanelColorTunerColor);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var onColorHueChaged = function (val) {
            try {
                DBG_INFO("onColorHueChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelColorTunerPageData.PanelColorTunerHueVal = val;
                UILabelSetVal(PanelColorTunerHue);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onColorSaturationChaged = function (val) {
            try {
                DBG_INFO("onColorSaturationChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelColorTunerPageData.PanelColorTunerSaturationVal = val;
                UILabelSetVal(PanelColorTunerSaturation);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onColorBrightnessChaged = function (val) {
            try {
                DBG_INFO("onColorBrightnessChaged: " + val);
                val=Math.round(val/PicTunerStep.HueStep);
                PicPanelColorTunerPageData.PanelColorTunerBrightnessVal = val;
                UILabelSetVal(PanelColorTunerBrightness);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicPanelColorTunerPageData.' + label.name + "Val"));
                //label.updateCache();
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        picPanelColorTuner.onPop = function(){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_TUNER_COLOR, onColorChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_HUE, onColorHueChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SATURATION, onColorSaturationChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_BRIGHTNESS, onColorBrightnessChaged);
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
