// Init
UI.moduleBuilder['setting']['networkMainPanel'] = function(){

    var mainPanelData = {
        networkMainSheetImg:UI.setting_bg,
//        networkMainBgImg:"setting/bg.png",
        networkImg:"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_network_154x154.png",
        networkMainConImg:UI.btn_normal_bg,
        networkMainInfoImg:UI.btn_normal_bg,
        networkMainTestImg:UI.btn_normal_bg,
        networkWakeWifiImg:UI.btn_normal_bg,
        networkWakeLanImg:UI.btn_normal_bg,
        networkMainBTImg:UI.btn_normal_bg,
        networkTitle2:"[SE0119]",//"Network",
        networkMainConTitle:"[OT0011]", //"Network Configuration"
        networkMainTestText:"[SE0623]",
        networkMainInfoText:"[OT0012]", //"Network Information"
        networkWakeWifiText:"[SE2976]", //Wake on Wireless Network
        networkWakeLanText:"[SE3210]", //wake on LAN
        networkMainBTText:"[SE0183]" //"Network Information"
    };
    var template = Util.readJson("module/setting/networkMainPanel.json");
    var networkMainPanel = SubModule.create(mainPanelData, template);
    var networkMainGrp = UI.getItem(networkMainPanel,"networkMainGrp");
    var networkMainCon = UI.getItem(networkMainGrp, "networkMainCon");
    var networkMainBgGrp = UI.getItem(networkMainPanel, "networkMainBgGrp");
    var ChTitle3 = UI.getItem(networkMainBgGrp, "networkTitle3");
    var networkMainBTBtn = UI.getItem(networkMainGrp, "networkMainBTBtn");

    var networkMainInfo = UI.getItem(networkMainGrp, "networkMainInfo");
    var networkMainTestBtn = UI.getItem(networkMainGrp, "networkMainTestBtn");
    var networkWakeWifiBtn = UI.getItem(networkMainGrp, "networkWakeWifiBtn");
    var networkWakeLanBtn = UI.getItem(networkMainGrp, "networkWakeLanBtn");
    var networkMainConTitle = UI.getItem(networkMainCon,"networkMainConTitle");

    ChTitle3.children[0].lineHeight = 50;
    ChTitle3.children[0].lineWidth = 512;

    var NWSheetImg = UI.getItem(networkMainPanel,"networkMainSheetImg");
    NWSheetImg.doFlip = true;

    networkMainPanel.currFocus = UI.getItem(networkMainGrp, "networkMainCon");

    networkMainPanel.onPush =  function(){
        networkMainPanel.currFocus = UI.getItem(networkMainGrp, "networkMainCon");
        networkWakeWifiBtn.alpha = 0;
        networkWakeWifiBtn.disable = true;
        networkWakeLanBtn.alpha = 0;
        networkWakeLanBtn.disable = true;
        bluetoothSupport();
    }

    networkMainPanel.BluetoothSupport = 1;
    networkMainPanel.BluetoothNoSupport = 0;
    function bluetoothSupport() {
        try {
            try{
                var support = tv ? model.bluetooth.getBluetoothAvailability() : 1;
            }catch (ex){
                DBG_ERROR("bluetoothSupport:"+ex.message);
                var support = 0;
            }
            DBG_INFO("model.system.getBluetoothSupport()" + support);
            if (support == networkMainPanel.BluetoothSupport) {
                networkMainBTBtn.alpha = 1;
                networkMainBTBtn.disable = false;
            }
            else {
                networkMainBTBtn.alpha = 0;
                networkMainBTBtn.disable = true;
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }



    var ChTitle2 = UI.getItem(networkMainPanel, "networkTitle2");
    LabelValue.create(networkMainConTitle, "[OT0011]", FontDef.Arial_36, "0xFFFFFF");
    var networkWakeWifiText = UI.getItem(networkWakeWifiBtn, "networkWakeWifiText");
    var networkWakeWifiSwitchImg = UI.getItem(networkWakeWifiBtn, "networkWakeWifiSwitchImg");
    Switch.create(networkWakeWifiSwitchImg, true);

    var networkWakeLanText = UI.getItem(networkWakeLanBtn, "networkWakeLanText");
    var networkWakeLanSwitchImg = UI.getItem(networkWakeLanBtn, "networkWakeLanSwitchImg");
    Switch.create(networkWakeLanSwitchImg, true);

    var wifiSwitch = false;
    var lanSwitch = false;
    var LANGUAGE = {
        "Connected":"[SE0399]",
        "Disconnected":"[SE0400]"
    };
    var networkHelpList =[
        {
            "title": "[OT0011]",//"Network Configuration",
            "content":"[SE0595]"// "Set up the network to gain full access of Smart TV features."
        },
        {
            "title": "[SE0623]",//"Connection Test",
            "content": "[SE0624]"//"Start a network connection test."
        },
        {
            "title": "[OT0012]",//"Network Information",
            "content": "[SE0629]"//"View information about your network connection."
        },
        {
            "title": "[SE2976]",//Wake on Wireless Network
            "content": "[SE3209]"//"Using a wireless connection, turn on your TV with a screencast feature inside an app."
        },
        {
            "title": "[SE3210]",//Wake on wired LAN
            "content": "[SE3211]"//"Using an Ethernet connection, turn on your TV with a screencast feature inside an app. "
        },
        {
            "title": "[SE0183]",//Bluetooth
            "content":"[SE2945]"// "Connect to the network using Bluetooth technology."
        }
    ];
    var settingChGrouplist = ["networkMainCon","networkMainTestBtn","networkMainInfo","networkWakeWifiBtn","networkWakeLanBtn","networkMainBTBtn"];

    networkMainPanel.onShow =  function(){
        try{
            var NetStatus = tv ? model.network.getEnumNetworkAvailable() : 0; //1 success  0 fail
            var wifiWakeUp = tv?model.network.getWowEnable() : 0; //0 off  1 on
            var lanWakeUp = tv?model.network.getWolEnable() : 0; //0 off  1 on
            networkMainPanel.alpha = 1;
            var mainPanel =UI.getSubModule("mainPanel");
            if(!!mainPanel)
            {
                mainPanel.alpha=0;
            }
            DBG_INFO("model.network.getWifiWakeup():" + wifiWakeUp);
            DBG_INFO("getEnumNetworkAvailable():" + NetStatus);
            if(NetStatus == NetWorkConnect.CONNECT){
                networkMainConTitle.setValue(LANGUAGE.Connected); //Connected
            }else{
                networkMainConTitle.setValue(LANGUAGE.Disconnected); //Disconnected
            }
            if(wifiWakeUp == 0){
                wifiSwitch = false;
            }else{
                wifiSwitch = true;
            }
            networkWakeWifiSwitchImg.setSwitch(wifiSwitch);
            if(lanWakeUp == 0){
                lanSwitch = false;
            }else{
                lanSwitch = true;
            }
            networkWakeLanSwitchImg.setSwitch(lanSwitch);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, networkMainStatusChanged);
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };

    function networkMainStatusChanged(val){
        if(val == NetWorkConnect.CONNECT){
            networkMainConTitle.setValue(LANGUAGE.Connected);
        }else{
            networkMainConTitle.setValue(LANGUAGE.Disconnected);
        }
    }
    networkMainCon.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        networkMainConTitle.onFocus();
        return true;
    };
//    networkMainCon.onNormal = function(){
////        networkMainConTitle.onNormal();
//        return true;
//    };
    networkMainTestBtn.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    networkMainTestBtn.onNormal = function(){
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };


    networkMainInfo.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    networkMainInfo.onNormal = function(){
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };

    networkWakeWifiBtn.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        networkWakeWifiSwitchImg.onFocus();
        return true;
    };
    networkWakeWifiBtn.onNormal = function(){
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,0.6)");
        networkWakeWifiSwitchImg.onNormal();
        return true;
    };
    networkWakeLanBtn.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        networkWakeLanSwitchImg.onFocus();
        return true;
    };
    networkWakeLanBtn.onNormal = function(){
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,0.6)");
        networkWakeLanSwitchImg.onNormal();
        return true;
    };
    networkMainBTBtn.onFocus = function(){
        var index = settingChGrouplist.indexOf(networkMainPanel.currFocus.name);
        UI.setText(ChTitle3,networkHelpList[index].content);
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    networkMainBTBtn.onNormal = function(){
//        UI.setTextColor(networkMainPanel.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };

    networkMainCon.onkey_ENTER = function () {
//        networkMainPanel.alpha = 0;
        UI.pushSubModule("setting", "networkConfigPanel", true);
        SetRecentUse("[OT0011]","Network","configPanel");
        return false;
    };
    networkMainTestBtn.onkey_ENTER = function () {
//        networkMainPanel.alpha = 0;
        UI.pushSubModule("setting", "networkTest", true);
        SetRecentUse("[SE0623]","Network","networkTest");
        return false;
    };
    networkMainInfo.onkey_ENTER = function () {
//        networkMainPanel.alpha = 0;
        UI.pushSubModule("setting", "networkInformation", true);
        SetRecentUse("[OT0012]","Network","networkInfo");
        return false;
    };
    networkWakeWifiBtn.onkey_ENTER = function () {
        wifiSwitch = !wifiSwitch;
        setNetworkWakeOnWifi(wifiSwitch);
    };
    networkWakeWifiBtn.onkey_LEFT = function () {
        wifiSwitch = !wifiSwitch;
        setNetworkWakeOnWifi(wifiSwitch);
    };
    networkWakeWifiBtn.onkey_RIGHT = function () {
        wifiSwitch = !wifiSwitch;
        setNetworkWakeOnWifi(wifiSwitch);
    };

    function setNetworkWakeOnWifi(flag){
        networkWakeWifiSwitchImg.switch();
        DBG_ERROR("!!!!!!!!!!!!!!!!setNetworkWakeOnWifi"+flag);
        if(flag){
            if(tv) model.network.setWowEnable(1);
        }else{
            if(tv) model.network.setWowEnable(0);
        }
        try{//record the user first use the function
            var fileIsValid=false;
            fileIsValid= Hisense.File.exists("hisenseUI/hasSetWakebyNet", 1);
            DBG_INFO("hasSetWakebyNet "+ fileIsValid);
            if(!fileIsValid){
                Hisense.File.write("hisenseUI/hasSetWakebyNet","started" ,1)
            }
        }catch (e)
        {DBG_ERROR(e.message)}
        //add by jiaguili 20160803
    }

    networkWakeLanBtn.onkey_ENTER = function () {
        lanSwitch = !lanSwitch;
        setNetworkWakeOnLan(lanSwitch);
    };
    networkWakeLanBtn.onkey_LEFT = function () {
        lanSwitch = !lanSwitch;
        setNetworkWakeOnLan(lanSwitch);
    };
    networkWakeLanBtn.onkey_RIGHT = function () {
        lanSwitch = !lanSwitch;
        setNetworkWakeOnLan(lanSwitch);
    };

    function setNetworkWakeOnLan(flag){
        networkWakeLanSwitchImg.switch();
        DBG_ERROR("!!!!!!!!!!!!!!!!setNetworkWakeOnLan"+flag);
        if(flag){
            if(tv) model.network.setWolEnable(1);
        }else{
            if(tv) model.network.setWolEnable(0);
        }
        try{// record the user first use the function
            var fileIsValid=false;
            fileIsValid= Hisense.File.exists("hisenseUI/hasSetWakebyNet", 1);
            DBG_INFO("hasSetWakebyNet "+ fileIsValid);
            if(!fileIsValid){
                Hisense.File.write("hisenseUI/hasSetWakebyNet","started" ,1);
            }
        }catch (e)
        {DBG_ERROR(e.message)}
        //add by jiaguili 20160803
    }
    networkMainBTBtn.onkey_ENTER = function () {
        networkMainPanel.alpha = 0;
        UI.pushSubModule("setting", "BluetoothSetting", true);
        return false;
    };
    networkMainPanel.onPop = function(){
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if(!!networkMainPanel.param&&networkMainPanel.param.caller.toString()=="networkTip" && null == appGhost){
            resumeDTV();
        }
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED,networkMainStatusChanged);
    }
    networkMainPanel.onkey_BACKSPACE=function(){
        if(!!networkMainPanel.param&&networkMainPanel.param.caller.toString()=="networkTip"){
             UI.popAllModule();
            //resumeDTV();
            if(checkIsAppOn()){
                appControl.focusCurrentApp();
            }else{
                openLiveTVModule();
            }
        }
       else  if(!!networkMainPanel.param&&networkMainPanel.param.caller.toString()=="upgrade"){
            UI.popSubModule();
            UI.pushSubModule("setting","mainPanel",true,null,null,"networkBtn")
        }
        else
        {
            return true;
        }

    }

};

PIXI.loader.add(
    [
        themeDir + "setting/ic_loading1.png",
        themeDir + "setting/ic_success.png",
        themeDir + "setting/ic_failure.png",
        themeDir + "setting/wifi/ic_loading_01.png",
        themeDir + "setting/wifi/wifi_1_lock_normal.png",
        themeDir + "setting/wifi/wifi_2_lock_normal.png",
        themeDir + "setting/wifi/wifi_3_lock_normal.png",
        themeDir + "setting/wifi/wifi_4_lock_normal.png",
        themeDir + "setting/wifi/wifi_1_normal.png",
        themeDir + "setting/wifi/wifi_2_normal.png",
        themeDir + "setting/wifi/wifi_3_normal.png",
        themeDir + "setting/wifi/wifi_4_normal.png"
    ]
);
PIXI.loader.load();