/**
 * Created by jiaguili on 16-2-18.
 */
UI.moduleBuilder['setting']['SettingSysEditName'] = function(){


    var initData = {
        "SettingSysEdittitle": "[SE0639]",//"User Input",
        "SettingSysEditbtn1text": "[GE0008]",//"Cancel",
        "SettingSysEditbtn2text": "[GE0007]",//"Confirm",
        "SettingSysEditPlaceholder": "[SE3014]",//"Press OK open the keyboard",
        "sheetImg1": UI['bg_overlay'],
        "SettingSysEditbgImg1": UI.window_bg,
        "SettingSysEditbtn1bgImg": UI.item_bg,
        "SettingSysEditbtn2bgImg": UI.item_bg,
        "SettingSysEditinputimg": "setting/"+GLOBAL.LAUNCHER_BRAND+"/Manual_input_focused.png"

    };
    var operateData = {
        "curvalidleng": 0,
        "datalist": [
            {
                "title": "[SE0803]",//"Rename",
                "tipInfo": "[SE3014]",
                "info":"[SE0804]"//"Please enter a valid display name upto 18 characters."
            },
            {
                "title": "[SE0639]",//"User Input",
                "tipInfo":  "[SE3014]",//"Please Rename the TV Name",
                "info":"[OT0034]"//"You must restart the TV in order for the customized name to take effect."

            }
        ],
        "inputName": ""

    };
    var template = Util.readJson("module/setting/SettingSysEditName.json");
    var SettingSysEditName = SubModule.create(initData, template);
    SettingSysEditName.currFocus = UI.getItem(SettingSysEditName, "SettingSysEditinput");
    SettingSysEditName.operateData = operateData
    var SettingSysEditbtn1 = UI.getItem(SettingSysEditName, "SettingSysEditbtn1");
    var SettingSysEditbtn2 = UI.getItem(SettingSysEditName, "SettingSysEditbtn2");
    var SettingSysEditinput = UI.getItem(SettingSysEditName, "SettingSysEditinput");
    var SettingSysEditinputimg = UI.getItem(SettingSysEditName, "SettingSysEditinputimg");
    var SettingSysEditPlaceholder = UI.getItem(SettingSysEditName, "SettingSysEditPlaceholder");
    var SettingSysEdittitle = UI.getItem(SettingSysEditName, "SettingSysEdittitle");
    var SettingSysEditinfo = UI.getItem(SettingSysEditName, "SettingSysEditinfo");
    var textInfo = {
        initVal: "",
        maxLength: 18,
        maxWidth:744,
        fontSize: 36,
        isPwd: false,
        color: 0xFFFFFF,
        TextName: Config.language["SE0323"]
    };
//    SettingSysEditinfo.children[0].lineHeight=40;
    SettingSysEditinfo.children[0].lineWidth=804;

    TextBox.create(SettingSysEditinput, textInfo, onEditTextChanged);

    SettingSysEditName.onPush = function () {
        SettingSysEditPlaceholder.alpha = 1;
        SettingSysEditinput.setText("");
        SettingSysEditinput.cursorLeft();
        SettingSysEditName.operateData.inputName="";
        SettingSysEditNameRefresh();
        UI.callTTS("[SE3014]");
        SettingSysEditName.currFocus = UI.getItem(SettingSysEditName, "SettingSysEditinput");

    }
    function SettingSysEditNameRefresh() {

        UI.setText(SettingSysEdittitle,SettingSysEditName.operateData.datalist[setting.sysdata.curEditType].title);
        UI.setText(SettingSysEditPlaceholder,SettingSysEditName.operateData.datalist[setting.sysdata.curEditType].tipInfo);
        UI.setText(SettingSysEditinfo,SettingSysEditName.operateData.datalist[setting.sysdata.curEditType].info);
        if(setting.sysdata.curEditType==0)
        {
            SettingSysEditName.operateData.curvalidleng=18;
            SettingSysEditinput.changeMaxNum(18);
        }
        else if(setting.sysdata.curEditType==1)
        {
            SettingSysEditName.operateData.curvalidleng=30;
            SettingSysEditinput.changeMaxNum(30);
        }
    }

    SettingSysEditbtn1.onkey_ENTER = function () {
        UI.popSubModule();
    }
    function checkInputIsValid()
    {
        var str=SettingSysEditName.operateData.inputName;
        if(str.length==0)
        {
            return false
        }
        else if(str.length> SettingSysEditName.operateData.curvalidleng)
        {
            return false;
        }
        return true;
    }
    var proIpNumKey = function() {
        SettingSysEditinput.children[0].realValue += CONST.NUMIPT_VALUE[UI.currKeyValue];
        SettingSysEditinput.setText(SettingSysEditinput.children[0].realValue);
        SettingSysEditinput.cursorRight();
        if (SettingSysEditinput.children[0].realValue.length != 0) {
            SettingSysEditPlaceholder.alpha = 0;
        }
        else {
            SettingSysEditPlaceholder.alpha = 1;
        }
        SettingSysEditName.operateData.inputName = SettingSysEditinput.children[0].text;
        DBG_INFO("value changed!");
        UI.updateStage();
    };
    SettingSysEditinput.onkey_ZERO = proIpNumKey;
    SettingSysEditinput.onkey_ONE = proIpNumKey;
    SettingSysEditinput.onkey_TWO = proIpNumKey;
    SettingSysEditinput.onkey_THREE = proIpNumKey;
    SettingSysEditinput.onkey_FOUR = proIpNumKey;
    SettingSysEditinput.onkey_FIVE = proIpNumKey;
    SettingSysEditinput.onkey_SIX = proIpNumKey;
    SettingSysEditinput.onkey_SEVEN = proIpNumKey;
    SettingSysEditinput.onkey_EIGHT = proIpNumKey;
    SettingSysEditinput.onkey_NINE = proIpNumKey;


    SettingSysEditbtn2.onkey_ENTER = function () {
        if(!checkInputIsValid()){
            GLOBAL.CURRENT_TOAST_TYPE=1;
            UI.pushGhostModule("setting","SettingSysToast");
            SettingSysEditinput.setText("");
            SettingSysEditinput.cursorLeft();
            SettingSysEditName.operateData.inputName="";
        }
        else
        {
        if (setting.sysdata.curEditType == 0) {
            var SettingSysInputlabel = UI.getSubModule("SettingSysInputlabel");
            SettingSysInputlabel.operateData.freshInputLabelcallback.call(this, SettingSysEditName.operateData.inputName);


        }
        else if (setting.sysdata.curEditType == 1) {
            setTvName(SettingSysEditName.operateData.inputName);
            var SettingSysAdv = UI.getSubModule("SettingSysAdv");
            if (!!SettingSysAdv) {
                SettingSysAdv.operateData.freshTvNamecallback.call(this, SettingSysEditName.operateData.inputName);
            }

        }

        UI.popSubModule();
        }
    }
    function onEditTextChanged(txt) {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!" + txt);
        SettingSysEditName.operateData.inputName = txt.text;
        SettingSysEditPlaceholder.alpha = 0;
        UI.updateStage();
    }
    function settingSysSetTvName(name) {
        try {
            model.system.setMachinename(name);
        }
        catch (e) {
            DBG_ERROR(e.message)
        }
    }
    SettingSysEditinput.onkey_ENTER = function () {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!");
        SettingSysEditinput.showKeyBoard();
        SettingSysEditPlaceholder.alpha = 0;

    }

    SettingSysEditName.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }
    SettingSysEditName.afterPush = function() {
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
    }
    SettingSysEditName.onFocus = function (focus) {
        if (focus.name == "SettingSysEditinput") {
            UI.base.cursor.alpha = 0;
            UI.setImage(SettingSysEditinputimg, "setting/"+GLOBAL.LAUNCHER_BRAND+"/Manual_input_focused.png")
            SettingSysEditinput.active();
            //focus.uncache();
            return false;
        }
        else {
            return true;
        }
    }
    SettingSysEditName.onNormal = function (focus) {
        if (focus.name == "SettingSysEditinput") {
            UI.base.cursor.alpha = 0;
            UI.setImage(SettingSysEditinputimg, "setting/sys/Manual_input_normal.png")
            SettingSysEditinput.inactive();
            //focus.cache(0, 0, focus.getBounds().width, focus.getBounds().height);
            return false;
        }
        else {
            return true;
        }
    }
};