/**
 * Created by yangcheng3
 */
UI.moduleBuilder['setting']['SettingSysAlexa'] = function () {
    function SettingSysAlexainit(operateData){
        try
        {
            if(!tv)
            {
                return;
            }
            var temp =AVSClient.register.getLanguageList();//[{"languageDesc":"English(United States)",
            //     "locale":"en-US"},
            // {"languageDesc":"English(Canada)",
            //     "locale":"en-CA"}]
            //     if(temp) {
            for (i = 0; i < temp.length; i++) {
                operateData.languagelist[i] = temp[i].languageDesc;
                operateData.codelist[i] = temp[i].locale;
            }
        }
        catch (e)
        {
            DBG_ERROR(e.message)
        }
    }
    var initData = {
        "settingsyssheet": UI.setting_bg,
        "settingsysimg1": "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_system_154x154.png",
        "settingsysdistitle": "[SE0189]",
        "settingsysdisinfo": "description",
        "settingsysMuti1text1":"[SE3753]",// "Voice Service Control",
        "settingsysMuti2text1": "[SE3754]",//"Amazon Alexa Service Setup",
        "settingsysMuti3text1": "[ALX0014]",// "Alexa Language"
        "settingsysMuti4text1":"[SE3768]",//"Setup Checklist",
        "settingsysMuti5text1": "[SE3683]",//"Things to try",
        "settingsysMuti1bg": UI.btn_normal_bg,
        "settingsysMuti2bg": UI.btn_normal_bg,
        "settingsysMuti3bg": UI.btn_normal_bg,
        "settingsysMuti4bg": UI.btn_normal_bg,
        "settingsysMuti5bg": UI.btn_normal_bg
    };
    var template = Util.readJson("module/setting/SettingSysAlexa.json");
    var SettingSysAlexa = SubModule.create(initData, template);
    var newGroup2 = UI.getItem(SettingSysAlexa, "newGroup2");
    UI.addMask(newGroup2, 1148, 926, 50, 6);
    UI.setView(newGroup2, 1146, 930);
    SettingSysAlexa.currFocus = UI.getItem(SettingSysAlexa, "settingsysMuti1");
    var newGroup1 = UI.getItem(SettingSysAlexa, "newGroup1");
    var disinfo = UI.getItem(newGroup1, "settingsysdisinfo");
    disinfo.children[0].lineHeight = 50;
    disinfo.children[0].lineWidth = 512;
    disinfo.children[0].alpha = 0.6;
    SettingSysAlexa.operateData = {
        "languagelist":[],
        "codelist":[],
        "curselect":0,
        "hisenseAccout": "",
        "AmazonAccout": "",
        "timer1": null,
        "timer2": null,
        "freLanguagecallback": freAlexaLanguage,
        "freshstylecallback": settingMenustyle,
        "helplist": [
            {
                "title": "Voice Service Control",
                "content": "[SE3746]"//
            },
            {
                "title": "Voice Service Setup",
                "content": "[SE3747]"//"Set the Power Indicator to illuminate when the TV is turned off."
            },
            {
                "title": "Alexa Language",
                "content": ""
            },
            {
                "title": "Setup Checklist",
                "content": ""//Set the amount of time that you'd like for the menu to display."
            },
            {
                "title": "Things to try",
                "content": ""//"Edit the input labels."
            }
        ],
    }
    var settingsysMuti1 = UI.getItem(newGroup2, "settingsysMuti1");
    var alexa_switch = UI.getItem(newGroup2, "settingsysMuti1switch");

    var settingsysMuti2 = UI.getItem(newGroup2, "settingsysMuti2");
    var settingsysMuti3switch = UI.getItem(newGroup2, "settingsysMuti3switch");
    var settingsysMuti3 = UI.getItem(newGroup2, "settingsysMuti3");
    var settingsysMuti4 = UI.getItem(newGroup2, "settingsysMuti4");
    var settingsysMuti5 = UI.getItem(newGroup2, "settingsysMuti5");
    Switch.create(alexa_switch, AVSClient.setting.getEnabled());
    SettingSysAlexainit(SettingSysAlexa.operateData);
    Select.create(settingsysMuti3switch,SettingSysAlexa.operateData.languagelist);
    SettingSysAlexa.noAutoClose = true;
    UI.updateStage();

    function SettingSysAlexaRefresh() {
        // Select.create(settingsysMuti3switch,SettingSysAlexa.operateData.languagelist);
        settingsysMuti3switch.changeValue(SettingSysAlexa.operateData.languagelist, SettingSysAlexa.operateData.curselect);
        UI.updateStage();
    }
    function  getAlexaLanguage(result) {
        DBG_ERROR("first result is " + result);
       if(!!result.toLowerCase().replace(' ', '')) {
           DBG_ERROR("getAlexaLanguage codelist is:" + SettingSysAlexa.operateData.codelist);
           var index = _getIndex(SettingSysAlexa.operateData.codelist, result);
           DBG_ERROR("result is " + result + "index is " + index);
           if (index == -1) {
               DBG_ERROR("error ui reset");
               index = 0;
           }
           SettingSysAlexa.operateData.curselect = index;
           SettingSysAlexaRefresh();
       }
    }
    SettingSysAlexa.onPush = function () {
        // SettingSysAlexainit(SettingSysAlexa.operateData);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONCULANGUAGE,getAlexaLanguage);
        AVSClient.register.getAlexaLanguageCode();
        alexa_switch.setSwitch(AVSClient.setting.getEnabled());
        if (alexa_switch.flag == false) {
            settingsysMuti2.alpha = 0.3;
            settingsysMuti2.disable = true;
            settingsysMuti3.alpha = 0.3;
            settingsysMuti3.disable = true;
            settingsysMuti4.alpha = 0.3;
            settingsysMuti4.disable = true;
            settingsysMuti5.alpha = 0.3;
            settingsysMuti5.disable = true;
        }
        else {
            settingsysMuti2.alpha = 1;
            settingsysMuti2.disable = false;
            settingsysMuti3.alpha = 1;
            settingsysMuti3.disable = false;
            settingsysMuti4.alpha = 1;
            settingsysMuti4.disable = false;
            settingsysMuti5.alpha = 1;
            settingsysMuti5.disable = false;

        }
        AVSClient.register.updateRegisterStatus("hisense");
        AVSClient.register.updateRegisterStatus("amazon");
    };
    SettingSysAlexa.afterPush=function(){
        registerKeyCodesForUI();//MSD6586USU25-6004 the bluetooth lost the focus because the youtube focuscurapp
    }
    SettingSysAlexa.onPop = function () {
        clearTimeout(SettingSysAlexa.operateData.timer1);
        clearTimeout(SettingSysAlexa.operateData.timer2);
        SettingSysAlexa.operateData.timer1 = null;
        SettingSysAlexa.operateData.timer2 = null;
    }
    SettingSysAlexa.onkey_BACKSPACE = function () {
        if(!SettingSysAlexa.fromOther){
        UI.popSubModule();
            registerKeyCodesForUI();
            return false;
        }
        if (setting.caller == "base" ||
            setting.caller == "blank" )
        {
            UI.popSubModule();
            if (checkIsAppOn()) {
                DBG_ERROR("escape to app");
                registerKeyCodesForApp();
            }
            else {
                registerKeyCodesForUI();
                openLiveTVModule();
                return false;
            }
        }
        else if (setting.caller== "hiMedia") {
            UI.popSubModule();
            hiMedia.changeByLauncher("resume");
            registerKeyCodesForUI();
            return false;
        }
        else {
            UI.popSubModule();
        }
    }
    settingsysMuti1.onkey_LEFT = settingsysMuti1.onkey_RIGHT =
        settingsysMuti1.onkey_ENTER = function () {
            if( alexa_switch.flag){
                setting.sysdata.curAlexaDialogType=7;
                UI.pushSubModule("setting", "SettingSysAlexaDialog", true);
            }
            else{
                settingMenustyle(1);
                DBG_INFO("set enable flag = " + alexa_switch.flag);

            }

        };
    settingsysMuti2.onkey_ENTER = function () {
        clearTimeout(SettingSysAlexa.operateData.timer1);
        SettingSysAlexa.operateData.timer1 = null;
        if (AVSClient.register.getIsReplaced()) {
            DBG_ERROR("current device is replaced!");
            openMsgBoxByType(MsgBoxType.AVS_DEVICE_REPLACE);
            return;
        }
        if (AVSClient.register.getRegisterStatus("hisense") == 99) {
            openMsgBoxByType(MsgBoxType.AVS_HIS_EXPIRED);
            return;
        }
        if (checkIsHaveHisAccount()&&checkHasFinishRegistr()) {
            DBG_ERROR("Have His Account");
            UI.startLoading();
            AVSClient.register.getUserProfile("hisense", onhisenseAcountReceived);
            SettingSysAlexa.operateData.timer1 = setTimeout(function () {
                clearTimeout(SettingSysAlexa.operateData.timer1);
                SettingSysAlexa.operateData.timer1 = null;
                UI.endLoading();
                UI.popAllModule();
                UI.pushSubModule("Alexa", "register_bg", true);
            }, 25000)
            if (!tv) {
                onhisenseAcountReceived("jiaguili@hisense.com")
            }
        } else {
            //todo open the Voice Service Setup
            DBG_ERROR("NO His Account open the Voice Service Setup ");
            UI.popAllModule();
            UI.pushSubModule("Alexa", "register_bg", true);
        }
    };

    function onhisenseAcountReceived(info) {
        DBG_ERROR("onhisenseAcountReceived" + info)
         clearTimeout(SettingSysAlexa.operateData.timer1);
         SettingSysAlexa.operateData.timer1 = null;
        if (avs_support) {
        if (!!info && info.length > 0) {
            if(info.toLowerCase().replace(/\s/g,"")=="error"){
                UI.endLoading();
                GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_ACCOUNT_ERROR;
                UI.pushGhostModule("setting","SettingSysToastBig");
            }
            else {
            SettingSysAlexa.operateData.hisenseAccout = info;
            AVSClient.register.getUserProfile("amazon", onAmazonAcountReceived);
            if (!tv) {
                onAmazonAcountReceived("jiaguili@amazon.com")
                }
            }
        }
        else {
            UI.endLoading();
            UI.popAllModule();
            UI.pushSubModule("Alexa", "register_bg", true);
            }
        }
        else {
            if (!!info && info.length > 0) {
                if (info.toLowerCase().replace(/\s/g, "") == "error") {
                    UI.endLoading();
                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AVS_ACCOUNT_ERROR;
                    UI.pushGhostModule("setting", "SettingSysToastBig");
                }
                else {
                    SettingSysAlexa.operateData.hisenseAccout = info;
                    UI.endLoading();
                    SettingSysAlexa.operateData.AmazonAccout = "";
                    UI.endLoading();
                    UI.pushSubModule("setting", "SettingSysAccountlist", true);

                }
            }
            else {
                UI.endLoading();
                UI.popAllModule();
                UI.pushSubModule("Alexa", "register_bg", true);
            }
        }

    }
    function settingMenustyle(index) {
        if (index ==1)
        {   alexa_switch.setSwitch(true);
            AVSClient.setting.setEnabled(true);
            settingsysMuti2.alpha=1;
            settingsysMuti2.disable=false;
            settingsysMuti3.alpha=1;
            settingsysMuti3.disable=false;
            settingsysMuti4.alpha=1;
            settingsysMuti4.disable=false;
            settingsysMuti5.alpha=1;
            settingsysMuti5.disable=false;
        }
        else{
            alexa_switch.setSwitch(false);
            AVSClient.setting.setEnabled(false);
            settingsysMuti2.alpha=0.3;
            settingsysMuti2.disable=true;
            settingsysMuti3.alpha=0.3;
            settingsysMuti3.disable=true;
            settingsysMuti4.alpha=0.3;
            settingsysMuti4.disable=true;
            settingsysMuti5.alpha=0.3;
            settingsysMuti5.disable=true;
        }
    }
    function onAmazonAcountReceived(info) {
        DBG_ERROR("onAmazonAcountReceived" + info)
        if(info.toLowerCase().replace(/\s/g,"")=="error"){
            UI.endLoading();
            GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_ACCOUNT_ERROR;
            UI.pushGhostModule("setting","SettingSysToastBig");
        }
        else if(!!info&&info.length>0){
        SettingSysAlexa.operateData.AmazonAccout = info;
        UI.endLoading();
        UI.pushSubModule("setting", "SettingSysAccountlist", true);
        }
        else {
            UI.endLoading();
            GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_ACCOUNT_ERROR;
            UI.pushGhostModule("setting","SettingSysToastBig");
        }
    }

    settingsysMuti4.onkey_ENTER = function () {
        clearTimeout(SettingSysAlexa.operateData.timer2);
        SettingSysAlexa.operateData.timer2 = null;
        //TODO: start alexa setup
        var IsHaveHisAccount = checkIsHaveHisAccount();
        //var IsHaveAmazonAccount=checkIsHaveAmazonAccount();
        DBG_ERROR("IsHaveHisAccount" + IsHaveHisAccount);
        //DBG_ERROR("IsHaveAmazonAccount"+IsHaveAmazonAccount);
        if (checkHasFinishRegistr()) {
            if (IsHaveHisAccount) {
                UI.startLoading();
                AVSClient.register.getUserProfile("hisense", onchecklisthisenseAcountReceived);
                SettingSysAlexa.operateData.timer2 = setTimeout(function () {
                    UI.endLoading();
                    clearTimeout(SettingSysAlexa.operateData.timer2);
                    SettingSysAlexa.operateData.timer2 = null;
                    setting.sysdata.curAlexaDialogType = 3;
                    UI.pushSubModule("setting", "SettingSysAlexaDialog", true);
                    //  UI.pushSubModule("Alexa","register_bg",true);
                }, 25000)
                if (!tv) {
                    onchecklisthisenseAcountReceived("jiaguili@hisense.com")
                }

            }
            else {//You are signed out of Hisense account
                setting.sysdata.curAlexaDialogType = 4;
                UI.pushSubModule("setting", "SettingSysAlexaDialog", true);
            }
        }
        else {
            //You have not set up the voice control service.
            setting.sysdata.curAlexaDialogType = 3;
            UI.pushSubModule("setting", "SettingSysAlexaDialog", true);
        }


    };
    function onchecklisthisenseAcountReceived(info) {
        DBG_ERROR("onchecklisthisenseAcountReceived" + info);
        SettingSysAlexa.operateData.hisenseAccout = info;

        if (!!info && info.length > 0) {
            if(info.toLowerCase().replace(/\s/g,"")=="error"){
                UI.endLoading();
                clearTimeout(SettingSysAlexa.operateData.timer2);
                GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_ACCOUNT_ERROR;
                UI.pushGhostModule("setting","SettingSysToastBig");
            }
            else {
                clearTimeout(SettingSysAlexa.operateData.timer2);
                AVSClient.register.getResetPasswordUrl(onGetRestPasswordResult);
                SettingSysAlexa.operateData.timer2 = setTimeout(function () {
                    UI.endLoading();
                    clearTimeout(SettingSysAlexa.operateData.timer2);
                    GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_NETWORK_ERROR;
                    UI.pushGhostModule("setting","SettingSysToastBig");
                }, 10000)
                if (!tv) {
                    setTimeout(function(){
                        onGetRestPasswordResult("WWW.TEST.com")
                    },2000)
                }
            }
        }
        else {
            UI.endLoading();
            clearTimeout(SettingSysAlexa.operateData.timer2);
            setting.sysdata.curAlexaDialogType = 4;
            UI.pushSubModule("setting", "SettingSysAlexaDialog", true);
        }
    }
    function onGetRestPasswordResult(url){
        DBG_ERROR("onGetRestPasswordResult"+url);
        UI.endLoading();
        clearTimeout(SettingSysAlexa.operateData.timer2);
        if (!!url && url.length > 0&&url.toLowerCase().replace(/\s/g,"")!="error"){
            SettingSysAlexa.operateData.url = url;
            UI.pushSubModule("setting", "SettingSysAlexaChecklist", true);
        }
        else {
            GLOBAL.CURRENT_TOAST_TYPE=TOASTTYPE.AVS_NETWORK_ERROR;
            UI.pushGhostModule("setting","SettingSysToastBig");
        }

    }
    function freAlexaLanguage(code) {
        var index= _getIndex(SettingSysAlexa.operateData.codelist,code);
        SettingSysAlexa.operateData.curselect = index;
        if(index>-1){
            settingsysMuti3switch.changeValue(SettingSysAlexa.operateData.languagelist,index);

        }
        else {
            settingsysMuti3switch.changeValue(SettingSysAlexa.operateData.languagelist, 0);
        }
    }
    settingsysMuti3.onkey_ENTER = function () {
        if(SettingSysAlexa.operateData.languagelist.length>0) {
            UI.pushSubModule("setting", "SettingAlexaLanguage", true)
        }

    };
    settingsysMuti3.onkey_LEFT = function () {
        settingsysMuti3switch.selectPrev();
        UI.updateStage();
        var index = _getIndex(SettingSysAlexa.operateData.languagelist, settingsysMuti3switch.selected);
        SettingSysAlexa.operateData.curselect = index;
        AVSClient.register.setAlexaLanguageCode(SettingSysAlexa.operateData.codelist[index]);
    };
    settingsysMuti3.onkey_RIGHT = function () {
        settingsysMuti3switch.selectNext();
        UI.updateStage();
        var index = _getIndex(SettingSysAlexa.operateData.languagelist, settingsysMuti3switch.selected);
        SettingSysAlexa.operateData.curselect = index;
        AVSClient.register.setAlexaLanguageCode(SettingSysAlexa.operateData.codelist[index]);

    };
//function onchecklistAmazonAcountReceived(info){
//    DBG_ERROR("onAmazonAcountReceived"+info)
//    SettingSysAlexa.operateData.AmazonAccout=info;
//    UI.endLoading();
//    UI.pushSubModule("setting", "SettingSysAccountlist", true);
//}
    settingsysMuti5.onkey_ENTER = function () {
        UI.pushSubModule("setting", "SettingSysAlexaToTry", true);
    };
    function checkIsHaveHisAccount() {
        DBG_ERROR("checkIsHaveHisAccount");
        return AVSClient.register.getRegisterStatus("hisense") == 1;

    }
    function checkHasFinishRegistr(){
        var fileValid=Hisense.File.exists("hisenseUI/avsRegister", 1);
        DBG_INFO("fileValid "+ fileValid);
        if(fileValid){
            return true;
        }
        else {
            return false;
        }
    }
    function checkIsHaveAmazonAccount() {
        return AVSClient.register.getRegisterStatus("amazon");
    }

    function checkIsStartVoiceControlSetup() {
        return false
    }
    SettingSysAlexa.onFocus = function () {
        try {
            if (!!newGroup2) {
                var settingSysGrouplist = ["settingsysMuti1", "settingsysMuti2", "settingsysMuti3","settingsysMuti4", "settingsysMuti5"]
                var index = settingSysGrouplist.indexOf(UI.getCurrFocus().name);
                var disinfo = UI.getItem(newGroup1, "settingsysdisinfo");
                UI.setText(disinfo, SettingSysAlexa.operateData.helplist[index].content);
            }
        } catch (e) {
            DBG_ERROR(e.message)
        }
        return true;
    }
}
;