// Init
UI.moduleBuilder['setting']['ChSkipListPanel'] = function(){

    var channelListData = {
        ChSkipListBg: UI.bg_overlay,
        ChSkipListImg: UI.window_bg,
        ChSkipListTitle:"[SE0590]",//"Channel Skip",
        ChSkipListBtn:"[OT0390]" // Press CH +/- to go one page up or down
    };
    var template = Util.readJson("module/setting/ChSkipListPanel.json");
    var ChSkipListPanel = SubModule.create(channelListData, template);
    // 初始化Grid控件
    // 取得目标锚点
    var channelList = UI.getItem(ChSkipListPanel, "channelList");
    var channelTile = UI.getItem(channelList,"channelTile");
    UI.addMask(channelList, 900, 676,50,10);
    UI.setView(channelList, 900, 676);
    function refreshchannelList() {

        // Grid的配置信息JSON
        var info = {
            template : "ChTileItem",
            direction : CONST.GIRD_DIRECTION.V,
            distance : 20,
            container : channelList,
            pageCount : 6,
            scrollBar : true,
            scrollBarOffset : -50
        };

        // 声明一个初始化用数组，将数据配置好
        var allArray = [];
        ChSkipListPanel.channelData = [];
        if (tv) {
            ChSkipListPanel.channelData = liveTV.getCurrentListAllChannels();
        } else {
            for (var i = 0; i < 1000; i++) {
                var flag = false;
                if (i % 2 == 0) {
                    flag = false;
                } else {
                    flag = true;
                }
                ChSkipListPanel.channelData.push({
                    number: "" + i,
                    name: "Channel" + i,
                    isSkip: flag,
                    uid: i
                });
            }
        }
        //DBG_INFO(objToString(ChSkipListPanel.channelData));
        if (ChSkipListPanel.channelData.length == null) {
            allArray.push(
                {
                    tileBg: UI.item_bg,
                    chlNo: "",
                    chlName: "No Item",
                    name: "Chl0",
                    isFlag: "setting/blank.png",
                    isSkip:false
                }
            );
        } else {
            for (var i = 0; i < ChSkipListPanel.channelData.length; i++) {
                allArray.push(
                    {
                        tileBg: UI.item_bg,
                        chlNo: ChSkipListPanel.channelData[i].number,
                        chlName: ChSkipListPanel.channelData[i].name,
                        name: "Chl" + i,
                        isFlag: ChSkipListPanel.channelData[i].isSkip ? "setting/skip_sel.png" : "setting/blank.png",
                        isSkip:ChSkipListPanel.channelData[i].isSkip
                    }
                )
            }
        }
        channelList.removeChildren();
        info.container.parent.removeChild(info.container.scroll);
        BigList.create(allArray, info);
    }

    ChSkipListPanel.currFocus = UI.getItem(channelList, "Chl0");
    ChSkipListPanel.onShow=function(){
        var ChMainPanel=UI.getSubModule("ChMainPanel");
        if(!!ChMainPanel)
        {
            ChMainPanel.close();
        }
    };
    ChSkipListPanel.onPush= function(){
        DBG_INFO("ChSkipList.onPush");
        refreshchannelList();
        ChSkipListPanel.currFocus = UI.getItem(channelList, "Chl0");
    };
    ChSkipListPanel.onPop = function() {
        try {
            var liveTVData = liveTV.getChannelListOprtData();
            var chList = liveTVData.allChannels[liveTVData.crntList.name];
            liveTVData.channelNumberGrp[liveTVData.crntList.name] = [];
            for (var i = 0; i < chList.length; i++) {
                !!chList[i].number && (liveTVData.channelNumberGrp[liveTVData.crntList.name].push(chList[i].number));
            }
        }
        catch (ex) {
            DBG_ERROR("ChSkipListPanel.onPop: " + ex.message);
        }
    }

    channelList.onkey_ENTER = function(focus) {
        if(ChSkipListPanel.channelData.length == null) {
            return true;
        }
        var index = channelList.currIndex;
        var Chnl = ChSkipListPanel.channelData[index];
        if(Chnl.isSkip){
            Chnl.isSkip = false;
            channelList.data[index].isFlag = "setting/skip_unsel.png";
            tv && model.servicelist.SetServiceAttribute(ServicelistModel.SERVICE_ATTR_SKIPPED,0,Chnl.uid);
            Chnl.attr = Chnl.attr & (~ServicelistModel.SERVICE_BITMASK_IS_SKIPPED);
        }else{
            if(getNotSkipFlag()){
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.UNAVIALIBLETIP;
                UI.pushGhostModule("setting","SettingSysToast");
                return;
            }
            Chnl.isSkip = true;
            channelList.data[index].isFlag = "setting/skip_sel.png";
            tv && model.servicelist.SetServiceAttribute(ServicelistModel.SERVICE_ATTR_SKIPPED,1,Chnl.uid);
            Chnl.attr = Chnl.attr | ServicelistModel.SERVICE_BITMASK_IS_SKIPPED;
        }
        channelList.refreshSingleData();
        UI.updateStage();
        //UI.setVoiceStr(ChSkipListPanel.currFocus.children[3],Chnl.isSkip ? Chnl.name+" "+"skip":Chnl.name+" "+"unskip");
        DBG_INFO("channelId::"+Chnl.uid +"Chnl.isSkip::"+Chnl.isSkip,DebugLevel.ALWAYS);
        tv && liveTV.updateChannelAttribute(-1,Chnl.uid,Chnl.listUid,SPChannel.ATTRIBUTE,Chnl.attr);
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.CHANNEL_SKIP_SET, [Chnl.isSkip ? 1 : 0 , Chnl.uid]);
        return false;
    };
    function getNotSkipFlag(){
        var flag = false, SkipNum = 0;
        for(var i = 0; i< ChSkipListPanel.channelData.length;i++){
            if(ChSkipListPanel.channelData[i].isSkip){
                SkipNum ++;
            }
        }
        if(SkipNum < (ChSkipListPanel.channelData.length -1)){
            flag = false;
        }else{
            flag = true;
        }
        return flag;
    }
    channelList.onFocus = function(focus){
        var index = channelList.currIndex;
        var Chnl = ChSkipListPanel.channelData[index];
        channelList.data[index].isFlag = Chnl.isSkip ?"setting/skip_sel.png":"setting/skip_unsel.png";
        channelList.refreshSingleData();
        return true;
    };
    channelList.onNormal = function(){
        return true;
    };
    channelList.onkey_UP = function () {
        if (channelList.currIndex <= 0) {
            AllListCurrBlur();
            channelList.currIndex = channelList.data.length - 1;
            channelList.navTo(channelList.currIndex, 7);
            return false;
        }else{
            AllListCurrBlur();
        }
        channelList.navPrev();
        return true;
    }
    channelList.onkey_DOWN = function () {
        if (channelList.currIndex >= channelList.data.length - 1) {
            AllListCurrBlur();
            channelList.currIndex = 0;
            channelList.navTo(channelList.currIndex, 0);
            return false;
        }else{
            AllListCurrBlur();
        }
        channelList.navNext();
        return true;
    }
    channelList.onkey_CHUP = function () {
        if(channelList.currIndex > 0){
            AllListCurrBlur();
            channelList.prevPage();
        }else{
            AllListCurrBlur();
            channelList.currIndex = channelList.data.length - 1;
            channelList.navTo(channelList.currIndex, 7);
            return false;
        }
        return true;
    };
    channelList.onkey_CHDOWN = function () {
        if (channelList.initSequence.length <= 1) {
            return false;
        }
        if(channelList.currIndex < channelList.data.length - 1){
            AllListCurrBlur();
            channelList.nextPage();
        }else{
            AllListCurrBlur();
            channelList.currIndex = 0;
            channelList.navTo(channelList.currIndex, 0);
            return false;
        }
        return true;
    };
    function AllListCurrBlur(){
        var Chnl = ChSkipListPanel.channelData[channelList.currIndex];
        channelList.data[channelList.currIndex].isFlag = Chnl.isSkip?"setting/skip_sel.png":"setting/blank.png";
        channelList.refreshSingleData();
    }
}