/************
 **   Created by Xueyuan
 **       2016-1-22
 ************/


UI.moduleBuilder['dlna']['dlnaVideoPlayer'] = function () {
    var dlnaVPageData = {
        videoStatus: "hiMedia/play_status.png"
    };
    var template = Util.readJson("module/dlna/dlnaVideoPlayer.json");
    var dlnaVideoPlayer = SubModule.create(dlnaVPageData, template);

    var videoPlayerMenu = UI.getItem(dlnaVideoPlayer, "videoPlayerMenu");
    videoPlayerMenu.visible = false;
    videoPlayerMenu.alpha = 0;

    dlnaVideoPlayer.videoStatus = UI.getItem(dlnaVideoPlayer, "videoStatus");
    dlnaVideoPlayer.videoStatus.visible = false;
    dlnaVideoPlayer.videoStatus.alpha = 0;
    dlnaVideoPlayer.playStatus = 1;
    dlnaVideoPlayer.currFocus = UI.getItem(dlnaVideoPlayer, "videoName");

    dlnaVideoPlayer.VideoTitle = UI.getItem(dlnaVideoPlayer, "videoName");
    dlnaVideoPlayer.videoPB = UI.getItem(dlnaVideoPlayer, "videoPB");
    dlnaVideoPlayer.startTime = UI.getItem(dlnaVideoPlayer, "startTime");
    dlnaVideoPlayer.endTime = UI.getItem(dlnaVideoPlayer, "endTime");
    dlnaVideoPlayer.videoStatus = UI.getItem(dlnaVideoPlayer, "videoStatus");
    dlnaVideoPlayer.menuName = UI.getItem(dlnaVideoPlayer, "videoPlayerMenuName");
    dlnaVideoPlayer.progressBar = UI.getItem(dlnaVideoPlayer, "videoPlayerPB");

    var videoTitleY = dlnaVideoPlayer.VideoTitle.y;
    var progressBarY = dlnaVideoPlayer.progressBar.y;
    var hidePanelTimer = null;
    var dlnaVideoTotalTime = 0;
    var dlnaVideoName = "";
    var dlnaVideoState = "play";
    var dlnaVideoCurTime = 0;
    var progressPercent = 0;

    dlnaVideoPlayer.onPush = function () {
        writeFileToNative("videoStopFlag", "running", 0);//设置标志位避免底层连续多次发送play和stop命令时处理错误
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaVideoStatchanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, dlnaVideoPlaytimechanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_TOTAL_TIME_CHANGED, dlnaVideoTotalPlaytimechanged);
        Percent.create(dlnaVideoPlayer.videoPB, dlnaVideoPlayer.menuName, 0);
        dlnaVideoPlayer.updateProgress(0);
        dlnaVideoPlayer.updateDlnaData(Dlna.dlnaVideoList);
        playStatus = 0;
        hasBuffered = false;


    }

    dlnaVideoPlayer.onShow = function () {


        //初始页面隐藏UI
        UI.getTween(dlnaVideoPlayer.progressBar, false).set({y: progressBarY + 85});
        UI.getTween(dlnaVideoPlayer.VideoTitle, false).set({y: videoTitleY - 85});
    }

    dlnaVideoPlayer.updateDlnaData = function (videolist) {
        Dlna.startLoading("dlnaVideoPlayer", 30);
        DBG_ALWAYS("init dlnaVideoData");
        //model.cec.setIsMiracastExist(1);
        var url = videolist[0].videoUrl;
        var name = videolist[0].videoName;
        dlnaVideoName = name;
        try {
            pubStateMediaDLNA(dlnaVideoName, 0, 0, 0, "start", "video");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        dlnaVideoPlayer.playVideoByUrl(url, name);
    }

    dlnaVideoPlayer.playVideoByUrl = function (videoUrl, videoName) {
        if (!!videoUrl) {
            DBG_INFO("playVideoByUrl " + videoUrl);
            UI.setText(dlnaVideoPlayer.VideoTitle, videoName);
            model.mpctrl.PlayMedia(videoUrl, null, null, null, null, null, 4, null, null, null);
            dlnaVideoPlayer.playStatus = 1;
            try {
                dlnaVideoPlayer.videoPB.setPercentNoVoice(0);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
    }

    dlnaVideoPlayer.videoPlayOrPause = function () {
        if (dlnaVideoPlayer.playStatus == 0) {
            UI.setImage(dlnaVideoPlayer.videoStatus, "hiMedia/play_status.png");
            if (!!hidePanelTimer) {
                clearTimeout(hidePanelTimer);
                hidePanelTimer = null;
            }
            dlnaVideoPlayer.showUI(true);
            try {
                model.mpctrl.MpCtrl(1);
            } catch (e) {
                DBG_ERROR(e.message);
            }
            dlnaVideoPlayer.playStatus = 1;
            hidePanelTimer = setTimeout(function () {
                dlnaVideoPlayer.showUI(false);
                hidePanelTimer = null;
            }, 5000);
        }
        else if (dlnaVideoPlayer.playStatus == 1) {
            UI.setImage(dlnaVideoPlayer.videoStatus, "hiMedia/pause_status.png");
            if (!!hidePanelTimer) {
                clearTimeout(hidePanelTimer);
                hidePanelTimer = null;
            }
            dlnaVideoPlayer.showUI(true);
            model.mpctrl.MpCtrl(2);
            dlnaVideoPlayer.playStatus = 0;
            hidePanelTimer = setTimeout(function () {
                dlnaVideoPlayer.showUI(false);
                hidePanelTimer = null;
            }, 5000);
        }
    }

    dlnaVideoPlayer.onkey_ESCAPE = function () {
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    }
    dlnaVideoPlayer.onkey_MENU = function () {
        if(!!GLOBAL.DLNADEVICE_MAC){
            var str = localStorage.getItem(GLOBAL.DLNADEVICE_MAC);
            if(str == 1){
                localStorage.removeItem(GLOBAL.DLNADEVICE_MAC);
                var mac = Config.language.SE0181 + ":" + GLOBAL.DLNADEVICE_MAC;
                UI.pushGhostModule("common", "dlnaToast2",{"titleStr" : "[SE4212]", "textStr": mac})
                dlnaVideoPlayer.onkey_BACKSPACE();
            }
        }
    };
    dlnaVideoPlayer.onkey_BACKSPACE = function () {
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    }

    dlnaVideoPlayer.onExit = function () {
        Dlna.endLoading("dlnaVideoPlayer");
    }

    dlnaVideoPlayer.onPop = function () {
        try {
            //model.cec.setIsMiracastExist(0);
            model.mpctrl.MpCtrl(3);
            writeFileToNative("videoStopFlag", "stop", 0);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaVideoStatchanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, dlnaVideoPlaytimechanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_TOTAL_TIME_CHANGED, dlnaVideoTotalPlaytimechanged);
        } catch (e) {
            DBG_ERROR(e.message);
        }
        try {
            pubStateMediaDLNA(dlnaVideoName, 0, 0, 0, "stop", "video");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    dlnaVideoPlayer.closeVideoPlayer = function () {
        if (UI.getCurrSubModule().name != "dlnaVideoPlayer") return;//避免协议栈连续发送两次stop消息后处理异常
        DBG_INFO("closeVideoPlayer function begin");
        UI.popSubModule();
        clearTimeout(Dlna.closeDlnaTimer);
        Dlna.closeDlnaTimer = setTimeout(function () {
            UI.popAllModule();
            try {
                openLiveTVModule([Msg.INFO, 0]);
            } catch (e) {
                DBG_ERROR(e.message);
            }
        }, 3000);//连续推送3s延时
    }

    dlnaVideoPlayer.updateProgress = function (currentTime) {
        var progressPercent = 0;
        if (dlnaVideoTotalTime != 0) {
            UI.setText(dlnaVideoPlayer.startTime, Dlna.getTimeText(currentTime));
            progressPercent = currentTime * 100 / dlnaVideoTotalTime;
        }
        else {
            progressPercent = 0;
        }
        try {
            dlnaVideoPlayer.videoPB.setPercentNoVoice(progressPercent);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    dlnaVideoPlayer.showUI = function (value) {
        if (value) {
            dlnaVideoPlayer.videoStatus.visible = true;
            dlnaVideoPlayer.videoStatus.alpha = 1;
            UI.getTween(dlnaVideoPlayer.progressBar).to({y: progressBarY + 85}, 0).to({y: progressBarY}, 500, UI.ease.quartOut);
            UI.getTween(dlnaVideoPlayer.VideoTitle).to({y: videoTitleY - 85}, 0).to({y: videoTitleY}, 500, UI.ease.quartOut);
        }
        else {
            dlnaVideoPlayer.videoStatus.visible = false;
            dlnaVideoPlayer.videoStatus.alpha = 0;
            UI.getTween(dlnaVideoPlayer.progressBar).to({y: progressBarY}, 0).to({y: progressBarY + 85}, 500, UI.ease.quartOut);
            UI.getTween(dlnaVideoPlayer.VideoTitle).to({y: videoTitleY}, 0).to({y: videoTitleY - 85}, 500, UI.ease.quartOut);
        }
    }

    function dlnaVideoReqationchanged(value) {
        DBG_INFO("dlnavideo action changed" + value);
        switch (value) {
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_PLAY:
                if (dlnaVideoPlayer.playStatus == 0) {
                    dlnaVideoPlayer.videoPlayOrPause();
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_PAUSE:
                if (dlnaVideoPlayer.playStatus == 1) {
                    dlnaVideoPlayer.videoPlayOrPause();
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_CHANGE_STOP:
                try {
                    var data = readFileFromNative("videoStopFlag", 0);
                } catch (e) {
                    DBG_ERROR(e.message);
                }
                DBG_INFO("videoStopFlag is " + data);
                if (data == "stop") {
                    return;
                } else {
                    dlnaVideoPlayer.closeVideoPlayer();
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MEDIA_STATE_SEEK_START:
                Dlna.startLoading("dlnaVideo seek start", 10);
                //开启10s左右的loading圈
                break;
            default:
                break;
        }
    }

    var playStatus = 0;
    var hasBuffered = false;

    function dlnaVideoStatchanged(value) {
        var nState = parseInt(value[2]);
        DBG_INFO("dlnaVideo status changed " + nState);
        if (nState == playStatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_INFO("drop duplicated state event" + nState);
            return;
        }
        if (parseInt(value[5]) & 1) {
            if(!hasBuffered){
                Dlna.startLoading("BUFFUR_UNDERFLOW", 10);
                hasBuffered = true;
            }
        } else {
            if (!!hasBuffered) {
                Dlna.endLoading("BUFFUR_UNDERFLOW");
                hasBuffered = false;
            }
        }
        playStatus = nState;
        switch (nState) {
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_IDLE:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARING:
                break;

            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                dlnaVideoState = "play";
                pubStateMediaDLNA(dlnaVideoName, dlnaVideoTotalTime, dlnaVideoCurTime, 0, dlnaVideoState, "video");
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                dlnaVideoState = "pause";
                pubStateMediaDLNA(dlnaVideoName, dlnaVideoTotalTime, dlnaVideoCurTime, 0, dlnaVideoState, "video");
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_STOP:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_RELEASING:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                try {
                    //初始化全屏
                    model.mpctrl.MpCtrl(1);
                    dlnaVideoPlayer.showUI(true);
                    hidePanelTimer = setTimeout(function () {
                        dlnaVideoPlayer.showUI(false);
                        hidePanelTimer = null;
                    }, 5000);
                    Dlna.endLoading("videoPlayer");
                    Dlna.renderLock = false;
                    UI.unlockAllKeys("videoDone");
                }
                catch (e) {
                    DBG_INFO(e.message);
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:
                dlnaVideoPlayer.closeVideoPlayer();
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:
                //Dlna.endLoading("dlnaVideoPlayer");

                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                DBG_ERROR("real error code is : " + value[8]);
                if (value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_PROBING_FAILED ||
                    value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_FORMAT ||
                    value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_VIDEO_FORMAT ||
                    value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_UNSUPPORTED_AUDIO_FORMAT ||
                    value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_VIDEO_DECODING ||
                    value[8] == MpCtrlModelDefines.SL2_TVAPI_MPCTRL_I32_ENUM_PLAYER_ERROR_MAIN_AUDIO_DECODING) {
                    Dlna.toastMsg("[DMP0031]");
                } else {
                    Dlna.toastMsg("[BR0091]");
                }//fileNotSupported
                dlnaVideoPlayer.closeVideoPlayer();
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
                Dlna.toastMsg("[SE3238]");
                dlnaVideoPlayer.closeVideoPlayer();
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_SEEK_DONE:
                //关闭由SEEK开启的loading圈
                Dlna.endLoading("dlnaVideo seek done");
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_BUFFUR_UNDERFLOW:
                Dlna.startLoading("BUFFUR_UNDERFLOW", 10);
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_BUFFUR_READY:
                Dlna.endLoading("BUFFUR_READY");
                break;
            default:
                break;
        }

    }

    function dlnaVideoPlaytimechanged(value) {
        //DBG_INFO("onMpCtrlVPlaytimeCurrentchanged : " + value);
        dlnaVideoPlayer.updateProgress(value);
        dlnaVideoCurTime = value;
        try {
            pubStateMediaDLNA(dlnaVideoName, dlnaVideoTotalTime, value, 0, dlnaVideoState, "video");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    function dlnaVideoTotalPlaytimechanged(value) {
        DBG_INFO("video total time" + value);
        dlnaVideoTotalTime = value;
        UI.setText(dlnaVideoPlayer.endTime, Dlna.getTimeText(dlnaVideoTotalTime));
    }
};