/************
 **   Created by Xueyuan
 **       2016-1-21
 ************/




//dlna配置函数
function dlnaInit() {
    var self = this;
    self.dlnaPicList = [];
    self.dlnaVideoList = [];
    self.dlnaMusicList = [];
    //timer 定义
    self.dlnaTimeout = null;
    self.dlnaPicTimer = null;
    self.decodePicTimer = null;
    self.dlnaVideoTimer = null;
    self.dlnaMusicTimer = null;
    //close timer
    self.closeDlnaTimer = null;
    self.toastText = null;
    self.needReceive = false;
    self.deviceUuid = null;
    self.renderLock = false;
    self.deviceMac = null;
    var toastTimer = null;
    self.onPictureRunningchanged = function (value) {
        DBG_ERROR("Picture running changed_____" + value);
        //todo 判断是否保护页面，允许推送后执行流程
        if (checkIsAppOn(APPNAME.FACTORY) || UI.getCurrModule().name == "FTE" || UI.getCurrModule().name == "miracast" ||
            (UI.getCurrSubModule() && UI.getCurrSubModule().protected)) {
            DBG_ERROR("Current Page is ProtectPage,can't open DLNA PLAYER PAGE! ");
            //model.mpctrl.setMpCtrlPlayerError(0);
            return false;
        }
        if (!!Dlna.renderLock){
            DBG_ERROR("Now DMR is not ready!!!!");
            return false;
        }
        try {
            self.deviceMac = model.mpctrl.getMpCtrlDMRMac();
            GLOBAL.DLNADEVICE_MAC = self.deviceMac;
            DBG_INFO("[dlnaConfig] deviceMac: " + self.deviceMac);
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        if(parseInt(value) == 1){
            if (isTrusted() == null) {
                if (checkIsAppOn()) {
                    DBG_INFO("trust dialog checkIsAppOn");
                    appControl.stopCurrentApp();
                }
                openMsgBox(MsgBoxType.DLNA_DIALOG,{"Type": "Pic", "Value": value, "deviceMac": self.deviceMac})
                //UI.pushSubModule("common", "dlnaDialog", true, {"Type": "Pic", "Value": value, "deviceMac": deviceMac});
                return false;
            }
            if(isTrusted() == 0){
                if(!!GLOBAL.DLNADIALOG_AGREE){
                    GLOBAL.DLNADIALOG_AGREE = false;
                }else {
                    if (checkIsAppOn()) {
                        DBG_INFO("trust dialog checkIsAppOn");
                        appControl.stopCurrentApp();
                    }
                    openMsgBox(MsgBoxType.DLNA_DIALOG,{"Type": "Pic", "Value": value, "deviceMac": self.deviceMac})
                    //UI.pushSubModule("common", "dlnaDialog", true, {"Type": "Pic", "Value": value, "deviceMac": deviceMac});
                    return false;
                }
            }
            if(isTrusted() == 1){
                if(!!toastTimer){
                    toastTimer = null;
                    clearTimeout(toastTimer)
                }
                toastTimer = dlnaToastTimer = setTimeout(function () {
                    UI.pushGhostModule("common", "dlnaToast2",{"titleStr" : "[SE4189]", "textStr": "[SE4190]"});
                }, 5000);
            }
        }
        switch (parseInt(value)) {
            case 1://PictureModelDefines.SL2_TVAPI_PICTURE_DLNA_STATE_RUNNING :
                //Dlna.startLoading("dlnaRender",5);
                UI.lockAllKeys("dlnaPic", 5000);
                Dlna.renderLock = true;
                self.dlnaPicList = [];
                var imgString = model.picture.getVstrHTML5Play();
                DBG_INFO("imgString" + imgString.getstrings);
                if (!!imgString) {

                    self.dlnaPicList.push({"picUrl": imgString[0], "picName": imgString[1]});

                } else {
                    self.toastMsg("[DMP0061]");
                    setTimeout(function () {
                        UI.popModule();
                    }, 2000);
                }
                DBG_INFO("C_S_Module:" + UI.getCurrSubModule().name);
                if (UI.getCurrSubModule().name == "dlnaBlankPage" || UI.getCurrSubModule().name == "dlnaPicPlayer"
                    || UI.getCurrSubModule().name == "dlnaMusicPlayer" || UI.getCurrSubModule().name == "dlnaVideoPlayer") {//连续推送流程
                    clearTimeout(Dlna.closeDlnaTimer);
                    Dlna.closeDlnaTimer = null;
                    DBG_INFO("test_____dlna模块内部切换");
                    if (UI.getCurrSubModule().name == "dlnaPicPlayer"
                        || UI.getCurrSubModule().name == "dlnaMusicPlayer" || UI.getCurrSubModule().name == "dlnaVideoPlayer") {
                        UI.popSubModule();
                    }
                    setTimeout(function () {
                        UI.pushSubModule("dlna", "dlnaPicPlayer", true);
                    }, 1200);
                } else {
                    if (checkIsAppOn()) {//epos推送
                        DBG_INFO("checkIsAppOn");
                        appControl.stopCurrentApp();
                        setTimeout(function () {
                            UI.popAllModule();
                            UI.pushModule("dlna");
                            setTimeout(function () {
                                UI.pushSubModule("dlna", "dlnaPicPlayer", true);
                            }, 200);
                        }, 3000)
                    } else {
                        UI.popAllModule();
                        setTimeout(function () {
                            UI.pushModule("dlna");
                            setTimeout(function () {
                                UI.pushSubModule("dlna", "dlnaPicPlayer", true);
                            }, 200);
                        }, 1000);
                    }
                }
                break;
            case 0://PictureModelDefines.SL2_TVAPI_PICTURE_DLNA_STATE_STOP :
//                try {
//                    var data = readFileFromNative("picStopFlag", 0);//stop flag 避免连续协议栈发送连续stop引起的问题
//                } catch (e) {
//                    DBG_ERROR(e.message);
//                }
//                //DBG_INFO("musicStopFlag is " + data);
//                if (data == "stop") {
//                    return;
//                } else {
//                    var dlnaPicPlayer = UI.getSubModule("dlnaPicPlayer");
//                    dlnaPicPlayer.closePicPlayer();
//                }
                break;
            default:
                break;
        }
    }

    self.onVstrHTML5PlayChanged = function (value) {
        //DBG_INFO("onVstrHTM5PlayChanged " + value);
    }

    self.onMetadataChanged = function (value) {
        //DBG_INFO("onMetadataChanged" + value);
        var uuid = value[4];
        if (!!uuid) {
            if (!!Dlna) {
                Dlna.deviceUuid = uuid;
                DBG_ALWAYS("Now uuid is  " + Dlna.deviceUuid);
            }
        }
    }

    self.onMpCtrlRenderchanged = function (value) {
        DBG_ERROR("Dlna Render changed" + value);

        if (checkIsAppOn(APPNAME.FACTORY)) {
            DBG_ERROR("current app name is ::::" + appControl.getCurrentAPPName() + "  quit...");
            return false;
        }
        if (value == 1) {
            DBG_ERROR("Drop this state ,quit..... ");
            //dlnaLoadFlag="dlnaLoadFlag";
            return false;
        }
        if (UI.getCurrModule().name == "FTE" || UI.getCurrModule().name == "miracast" ||
            (UI.getCurrSubModule() && UI.getCurrSubModule().protected)) {
            DBG_INFO("Current Page is ProtectPage,can't open DLNA PLAYER PAGE! ");
            model.mpctrl.setMpCtrlPlayerError(0);
            return false;
        }
        if ((UI.base.loading.alpha == 1 || UI.keyActive == false) && (!Dlna.needReceive) && (!!Dlna.renderLock)) {
            DBG_ERROR("Now is loading,can't open DLNA PLAYER PAGE! ");
            //model.mpctrl.setMpCtrlPlayerError(0);
            return false;
        }
        try {
            self.deviceMac = model.mpctrl.getMpCtrlDMRMac();
            GLOBAL.DLNADEVICE_MAC = self.deviceMac;
            DBG_INFO("[dlnaConfig] deviceMac: " + self.deviceMac);
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        DBG_INFO("[dlnaConfig] DLNADIALOG_AGREE: " + GLOBAL.DLNADIALOG_AGREE);
        if (isTrusted() == null) {
            //UI.pushSubModule("common", "dlnaDialog", true, {"Type": "MpCtrl", "Value": value, "deviceMac": deviceMac});
            if (checkIsAppOn()) {
                DBG_INFO("trust dialog checkIsAppOn");
                appControl.stopCurrentApp();
            }
            openMsgBox(MsgBoxType.DLNA_DIALOG,{"Type": "MpCtrl", "Value": value, "deviceMac": self.deviceMac});
            return false;
        }
        if(isTrusted() == 0){
            if(!!GLOBAL.DLNADIALOG_AGREE){
                GLOBAL.DLNADIALOG_AGREE = false;
            }else {
                if (checkIsAppOn()) {
                    DBG_INFO("trust dialog checkIsAppOn");
                    appControl.stopCurrentApp();
                }
                openMsgBox(MsgBoxType.DLNA_DIALOG,{"Type": "MpCtrl", "Value": value, "deviceMac": self.deviceMac});
                // UI.pushSubModule("common", "dlnaDialog", true, {"Type": "MpCtrl", "Value": value, "deviceMac": deviceMac});
                return false;
            }
        }
        if(isTrusted() == 1){
            if(!!toastTimer){
                toastTimer = null;
                clearTimeout(toastTimer)
            }
            toastTimer = dlnaToastTimer = setTimeout(function () {
                UI.pushGhostModule("common", "dlnaToast2",{"titleStr" : "[SE4189]", "textStr": "[SE4190]"});
            }, 5000);
        }
        //Dlna.startLoading("dlnaRender", 5);
        UI.lockAllKeys("dlnaMV", 5000);
        Dlna.renderLock = true;
        self.dlnaVideoList = [];
        self.dlnaMusicList = [];
        var dlnaMetaData = model.mpctrl.getMetadata();
        DBG_ALWAYS("dlnaMetaData: " + objToString(dlnaMetaData));
        if (!!dlnaMetaData) {
            var dlnaType = dlnaMetaData[1];
            var dlnaName = dlnaMetaData[8];
            var dlnaArtist = dlnaMetaData[13];
            var dlnaAlbum = dlnaMetaData[14];
            var dlnaUrl = dlnaMetaData[3];
            //todo 在此处判断资源类型并创建list
        } else {
            self.toastMsg("[DMP0061]");
            setTimeout(function () {
                UI.popModule();
            }, 2000);
        }
        DBG_INFO("C_S_Module:" + UI.getCurrSubModule().name);
        if (UI.getCurrSubModule().name == "dlnaBlankPage" || UI.getCurrSubModule().name == "dlnaPicPlayer"
            || UI.getCurrSubModule().name == "dlnaMusicPlayer" || UI.getCurrSubModule().name == "dlnaVideoPlayer") {//连续推送流程
            clearTimeout(Dlna.closeDlnaTimer);
            Dlna.closeDlnaTimer = null;
            DBG_INFO("test_____dlna模块内部切换");
            if (UI.getCurrSubModule().name == "dlnaPicPlayer"
                || UI.getCurrSubModule().name == "dlnaMusicPlayer" || UI.getCurrSubModule().name == "dlnaVideoPlayer") {
                UI.popSubModule();
            }
            setTimeout(function () {
                if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                    self.dlnaMusicList.push({"musicUrl": dlnaUrl, "musicName": dlnaName, "musicArtist": dlnaArtist, "musicAlbum": dlnaAlbum});
                    DBG_INFO("music list" + self.dlnaMusicList);
                    UI.pushSubModule("dlna", "dlnaMusicPlayer", true);
                }
                else if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                    self.dlnaVideoList.push({"videoUrl": dlnaUrl, "videoName": dlnaName});
                    DBG_INFO("video list" + self.dlnaVideoList);
                    UI.pushSubModule("dlna", "dlnaVideoPlayer", true);
                }
            }, 1200);
        } else {
            if (checkIsAppOn()) {//epos推送
                DBG_INFO("checkIsAppOn");
                appControl.stopCurrentApp();
                setTimeout(function () {
                    UI.popAllModule();
                    /*try {
                     pauseDTV();
                     } catch (e) {
                     DBG_ERROR(e.message);
                     }*/
//                    setTimeout(function () {
                    UI.pushModule("dlna");
                    setTimeout(function () {
                        if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                            self.dlnaMusicList.push({"musicUrl": dlnaUrl, "musicName": dlnaName, "musicArtist": dlnaArtist, "musicAlbum": dlnaAlbum});
                            UI.pushSubModule("dlna", "dlnaMusicPlayer", true);
                        }
                        else if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                            self.dlnaVideoList.push({"videoUrl": dlnaUrl, "videoName": dlnaName});
                            UI.pushSubModule("dlna", "dlnaVideoPlayer", true);
                        }
                    }, 200);
//                    }, 1000);
                }, 3000);
            } else {
                UI.popAllModule();
                /*try {
                 pauseDTV();
                 } catch (e) {
                 DBG_ERROR(e.message);
                 }*/
                setTimeout(function () {
                    UI.pushModule("dlna");
                    setTimeout(function () {
                        if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                            self.dlnaMusicList.push({"musicUrl": dlnaUrl, "musicName": dlnaName, "musicArtist": dlnaArtist, "musicAlbum": dlnaAlbum});
                            UI.pushSubModule("dlna", "dlnaMusicPlayer", true);
                        }
                        else if (dlnaType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                            self.dlnaVideoList.push({"videoUrl": dlnaUrl, "videoName": dlnaName});
                            UI.pushSubModule("dlna", "dlnaVideoPlayer", true);
                        }
                    }, 200);
                }, 1000);
            }
        }
    }
    self.onMpCtrlDMRMutechanged = function (value){
        DBG_ALWAYS("[onMpCtrlDMRMutechanged] value: " + value);
        if (checkIsAppOn(APPNAME.FACTORY)) {
            DBG_ERROR("current app name is ::::" + appControl.getCurrentAPPName() + "  quit...");
            return false;
        }
        if (UI.getCurrModule().name == "FTE" || UI.getCurrModule().name == "miracast" ||
            (UI.getCurrSubModule() && UI.getCurrSubModule().protected)) {
            DBG_INFO("Current Page is ProtectPage,can't open DLNA PLAYER PAGE! ");
            return false;
        }
        if ((UI.base.loading.alpha == 1 || UI.keyActive == false) && (!!Dlna.renderLock)) {
            DBG_ERROR("Now is loading,can't open DLNA PLAYER PAGE! ");
            //model.mpctrl.setMpCtrlPlayerError(0);
            return false;
        }
        try {
            self.deviceMac = model.mpctrl.getMpCtrlDMRMac();
            GLOBAL.DLNADEVICE_MAC = self.deviceMac;
            DBG_INFO("[dlnaConfig] deviceMac: " + self.deviceMac);
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        if(isTrusted() == 1 || !!isVolueTrusted()){
            model.sound.setMainMute(value);
        }else{
            openMsgBox(MsgBoxType.DLNA_DIALOG2, {"Type": "Mute", "Value": value, "deviceMac": self.deviceMac});
        }
        Dlna.renderLock = true;
    }
    self.onMpCtrlDMRVolumechanged = function(value){
        DBG_ALWAYS("[onMpCtrlDMRVolumechanged] value: " + value);
        if (checkIsAppOn(APPNAME.FACTORY)) {
            DBG_ERROR("current app name is ::::" + appControl.getCurrentAPPName() + "  quit...");
            return false;
        }
        if (UI.getCurrModule().name == "FTE" || UI.getCurrModule().name == "miracast" ||
            (UI.getCurrSubModule() && UI.getCurrSubModule().protected)) {
            DBG_INFO("Current Page is ProtectPage,can't open DLNA PLAYER PAGE! ");
            return false;
        }
        if ((UI.base.loading.alpha == 1 || UI.keyActive == false) && (!!Dlna.renderLock)) {
            DBG_ERROR("Now is loading,can't open DLNA PLAYER PAGE! ");
            //model.mpctrl.setMpCtrlPlayerError(0);
            return false;
        }
        try {
            self.deviceMac = model.mpctrl.getMpCtrlDMRMac();
            GLOBAL.DLNADEVICE_MAC = self.deviceMac;
            DBG_INFO("[dlnaConfig] deviceMac: " + self.deviceMac);
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        if(isTrusted() == 1 || !!isVolueTrusted()){
            model.sound.setMainVolume(value);
        }else{
            openMsgBox(MsgBoxType.DLNA_DIALOG2, {"Type": "Volume", "Value": value, "deviceMac": self.deviceMac});
        }
        Dlna.renderLock = true;
    }
    self.onDlnaNetworkStatusChanged = function (value) {
        //断网后关闭DLNA页面
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");

        DBG_ALWAYS("[onDlnaNetworkStatusChanged] value: " + value + "  currentSubModel:" + currentSubModel);
        if (!value) {
            switch (currentSubModel) {
                case "dlnaVideoPlayer":
                case "dlnaMusicPlayer":
                case "dlnaPicPlayer":
                    UI.popAllModule();
                    try {
                        openLiveTVModule([Msg.INFO, 0]);
                    } catch (e) {
                        DBG_ERROR(e.message);
                    }
                    break;
                default :
                    break;
            }
        }
    }
    self.getTimeText = function (c) {
        var d = Math.floor(c);
        var b = Math.floor(d / 3600);//hour
        var e = Math.floor((d % 3600) / 60);//minute
        var a = Math.floor(d % 60);//second
        if (b > 100)
            return self.formatTimeHMS(0, 0, 0);
        else
            return self.formatTimeHMS(b, e, a);
    };

    self.formatTimeHMS = function (c, a, b) {
        return self.checkTime(c) + ":" + self.checkTime(a) + ":" + self.checkTime(b);
    };

    self.checkTime = function (a) {
        return(a < 10 ? "0" : "") + a;
    };


    self.loadingtimer = null;
    self.loadingIcon = null;
    self.startLoading = function (from, timeout) {
        DBG_INFO("[dlna.startLoading]" + from);
        if (!timeout) {
            timeout = 5;
        }
        UI.startLoading();
        if (!!self.loadingtimer) {
            clearTimeout(self.loadingtimer);
            self.loadingtimer = null;
        }
        self.loadingtimer = setTimeout(function () {
            Dlna.endLoading("timeout");
        }, timeout * 1000);
    };

    self.endLoading = function (from) {
        DBG_INFO("[dlna.endLoading]" + from);
        try {
            if (!!self.loadingtimer) {
                clearTimeout(self.loadingtimer);
                self.loadingtimer = null;
            }
            DBG_INFO("loading.number=" + UI.base.loading.number);
            UI.endLoading();
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    self.toastMsg = function (msg) {
        self.toastText = msg;
        UI.pushGhostModule("dlna", "dlnaToast");
    }

    function isTrusted(){
        var str = localStorage.getItem(self.deviceMac);
        return str;
    }
    function isVolueTrusted(){
        DBG_INFO("[isVolueTrusted]" + self.deviceMac);
        if(GLOBAL.DLNADEVICE_VOLUE.indexOf(self.deviceMac) != -1){
            return true;
        }
    }
}

var Dlna = new dlnaInit();