function Parental_lockModelDefines() {
}
{
    Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_PIN = "de.loewe.sl2.str.parental.lock.pin";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_IN_PERIOD = "de.loewe.sl2.i32.parental.lock.in.period";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_SWITCH_MODE = "de.loewe.sl2.i32.parental.lock.switch.mode";
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_RESET = "de.loewe.sl2.action.parental.lock.reset";
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_CHECK_REQUEST = "de.loewe.sl2.action.parental.lock.pin.check";
    Parental_lockModelDefines.SL2_TVAPI_VSTR_PARENTAL_LOCK_PIN_REQUEST = "de.loewe.sl2.vstr.parental.lock.pin.request";
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_REQUEST_CONFIRM = "de.loewe.sl2.action.parental.lock.pin.request.confirm";

    Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_FALLBACK_PIN = "de.loewe.sl2.str.parental.lock.fallback.pin";
    Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_INPUT_SOURCE = "de.loewe.sl2.str.parental.lock.inputSource";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_DAILY_START = "de.loewe.sl2.i32.parental.lock.daily.start";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_DAILY_END = "de.loewe.sl2.i32.parental.lock.daily.end";
    Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_WEEKLY = "de.loewe.sl2.str.parental.lock.weekly";

    //program lock
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_UNRATED = "de.loewe.sl2.i32.parental.lock.unrated";
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV = "de.loewe.sl2.vi32.parental.lock.us.tv";
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV = "de.loewe.sl2.action.parental.lock.us.tv";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_US_MOVIE_RATING = "de.loewe.sl2.i32.parental.lock.us.movie.rating";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_CA_ENGLISH_RATING = "de.loewe.sl2.i32.parental.lock.ca.english.rating";
    Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_CA_FRENCH_RATING = "de.loewe.sl2.i32.parental.lock.ca.french.rating";
    Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_OPEN_VCHIP = "de.loewe.sl2.str.parental.lock.open.vchip";

    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_LENGTH = 4;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_MODE_WEEKLY = 2;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_TIME_MIN = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_TIME_MAX = 86340;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_CHECK_REQUEST_PARAM_RESTRICTION_MESSAGE = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_INDEX_ID = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_INDEX_OPTIONS = 1;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_INDEX_HINT = 2;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_SIZE = 3;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_PIN_REQUEST_ID_NONE = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_PIN_REQUEST_ID_STANDARD = 1;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_PIN_REQUEST_ID_CIPLUS = 2;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_OPTION_UNDEF = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_OPTION_CONFIRM = 1;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_OPTION_CANCEL = 2;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_OPTION_ESCAPE = 4;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_PIN_REQUEST_OPTION_PROG_CHANGE = 8;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_REQUEST_PARAM_STATUS = 0;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_REQUEST_PARAM_PIN = 1;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_PIN_REQUEST_STATUS_CANCELLED = 0;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_PIN_REQUEST_STATUS_CONFIRMED = 1;

    //programLock
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_NONE = 0,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_Y = 1,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_Y7 = 2,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_G = 3,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_PG = 4,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_14 = 5,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_MA = 6,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_ITEM_SIZE = 7,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_ALL = 0x01,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_D = 0x02,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_L = 0x04,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_S = 0x08,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_V = 0x10,
    Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_RATING_MASK_FV = 0x20,
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_Y_ALL = 0;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_Y7_ALL = 1;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_Y7_FV = 2;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_G_ALL = 3;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_PG_ALL = 4;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_PG_D = 5;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_PG_L = 6;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_PG_S = 7;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_PG_V = 8;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_14_ALL = 9;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_14_D = 10;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_14_L = 11;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_14_S = 12;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_14_V = 13;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_MA_ALL = 14;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_MA_L = 15;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_MA_S = 16;
    Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_PARAMS_MA_V = 17;

    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_INPUT_SOURCE_LENGTH = 128;
    Parental_lockModelDefines.SL2_TVAPI_PARENTAL_LOCK_WEEKLY_LENGTH = 128;
}
function Parental_lockModel(_) {
    SubModel.call(this, _, Parental_lockModelDefines);
    this.registerSubObject = function () {
        this.registerStringObject(Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_PIN, "getPin", "setPin", "onPinChaged", null, null);
        this.registerStringObject(Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_FALLBACK_PIN, "getFallbackPin", null, null, null, null);
        this.registerStringVectorObject(Parental_lockModelDefines.SL2_TVAPI_VSTR_PARENTAL_LOCK_PIN_REQUEST, "getPinRequest", "setPinRequest", "onPinRequestChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_SWITCH_MODE, "getSModel", "setSModel", "onSModelChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_IN_PERIOD, "getInPeriod", "setInPeriod", "null", null, null);
        this.registerActionObject(Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_RESET, [{
            name: "Reset",
            method: function (_) {
                return _.invoke()
            }
        }], "Resethandler");
        this.registerActionObject(Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_CHECK_REQUEST, [{
            name: "PinCheck",
            method: function (_) {
                return _.invoke()
            }
        }], "null");
        this.registerActionObject(Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_PIN_REQUEST_CONFIRM, [{
            name: "PinRequestConfirm",
            method: function (_, e, l) {
                return _.invoke(e, l)
            }
        }], "null")

//        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_ALL, "getLockAll", "setLockAll", "onLockAll", null, null);
        this.registerStringObject(Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_INPUT_SOURCE, "getInputSourceLock", "setInputSourceLock", "onInputSourceLockChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_DAILY_START, "getStart", "setStart", "onStartChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_DAILY_END, "getEnd", "setEnd", "onEndChaged", null, null);
        this.registerStringObject(Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_WEEKLY, "getEndWeekly", "setEndWeekly", "onEndWeeklyChaged", null, null);

    //program lock
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_UNRATED, "getBlockUnrated", "setBlockUnrated", "onBlockUnratedChaged", null, null);
        this.registerIntegerVectorObject(Parental_lockModelDefines.SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV, "getUsTvRating", "setUsTvRating", "onUsTvRatingChaged", null, null);
        this.registerActionObject(Parental_lockModelDefines.SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV, [{
            name: "ActionSetUsTvRating",
            method: function (_, e, l) {
                return _.invoke(e, l)
            }
        }], "null");
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_US_MOVIE_RATING, "getUsMovieRating", "setUsMovieRating", "onUsMovieRatingChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_CA_ENGLISH_RATING, "getCanEnglishRating", "setCanEnglishRating", "onCanEnglishRatingChaged", null, null);
        this.registerIntegerObject(Parental_lockModelDefines.SL2_TVAPI_I32_PARENTAL_LOCK_CA_FRENCH_RATING, "getCanFrenchRating", "setCanFrenchRating", "onCanFrenchRatingChaged", null, null);
        this.registerStringObject(Parental_lockModelDefines.SL2_TVAPI_STR_PARENTAL_LOCK_OPEN_VCHIP, "getOpenVchip", "setOpenVchip", "onOpenVchipChaged", null, null);

        this.openVchipRegionPage = function()
        {
            try
            {
                var retval = {
                    "datalist":[],
                    "selectlist":[]
                }
                var temp=this.getOpenVchip();
                DBG_ERROR("openVchip"+JSON.stringify(temp));
                try{
                   var openVchip = JSON.parse(temp);
                }
                catch(ex) {
                    DBG_ERROR(ex.message);
                    openVchip={"Open V-chip":[]}
                }
                DBG_ERROR("openVchip"+JSON.stringify(openVchip))
                var regionNames = [];
                for (var i = 0; i < openVchip['Open V-chip'].length; i++)
                {
                    regionNames[i] = openVchip['Open V-chip'][i]['regionName'];
                }

                retval.datalist = regionNames;
                return retval;
            }
            catch (e)
            {
                DBG_ERROR(e.message)
            }
        };
        this.openVchipDimensionPage = function(RegionSelect)
        {
            try
            {
                var retval = {
                    "datalist":[],
                    "selectlist":[]
                }

                var openVchip = JSON.parse(this.getOpenVchip());
                var dimensionNames = [];
                var dimensionInfo = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'];

                for (var dimIdx = 0; dimIdx < dimensionInfo.length; dimIdx++)
                {
                    dimensionNames[dimIdx] = dimensionInfo[dimIdx]['dimensionName'];
                }
                retval.datalist = dimensionNames;
                return retval;
            }
            catch (e)
            {
                DBG_ERROR(e.message)
            }
        };
        this.openVchipRatingValuePage = function(RegionSelect, DimensionSelect)
        {
            try
            {
                var retval = {
                    "datalist":[],
                    "selectlist":[]
                }
                var temp=this.getOpenVchip();
                DBG_ERROR("getOpenVchip"+JSON.stringify(temp));
                try{
                    var openVchip = JSON.parse(temp);
                }
                catch(ex) {
                    DBG_ERROR(ex.message);
                    openVchip={"Open V-chip":[]}
                }

                //var openVchip = JSON.parse(this.getOpenVchip());
                var ratingValues = [];
                var selectList = [];
                var isFirstRatingNA = false;
                var ratingInfo = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'][DimensionSelect]['ratingValue'];
                var settingValue = openVchip['Open V-chip'][RegionSelect]['dimensionInfo'][DimensionSelect]['setting'];

                if(!ratingInfo[0]['abbrev'].length)
                {
                    DBG_INFO("first rating NA!");
                    isFirstRatingNA = true;
                }

                for (var ratingIdx = 0; ratingIdx < ratingInfo.length; ratingIdx++)
                {
                    if((ratingIdx == 0) && isFirstRatingNA)
                    {
                        continue;
                    }
                    else
                    {
                        ratingValues.push(ratingInfo[ratingIdx]['abbrev']);
                    }
                }

                for (var i = 0; i < ratingInfo.length; i++)
                {
                    if((i == 0) && isFirstRatingNA)
                    {
                        continue;
                    }
                    else
                    {
                        selectList.push(settingValue&(1<<i)?1:0)
                    }
                }

                retval.datalist = ratingValues;
                retval.selectlist = selectList;

                return retval;
            }
            catch (e)
            {
                DBG_ERROR(e.message)
            }
        };
        this.setLevelPage = function(regionSelect, dimensionSelect, ratingValueSelect, enLock)
        {
            try
            {
                var openVchip = JSON.parse(this.getOpenVchip());
                var ratingInfo = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['ratingValue'];
                var settingValue = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['setting'];
                var gradScale = openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['graduatedScale'];

                var isFirstRatingNA = false;
                var ratingInfoLength = ratingInfo.length;
                if(!ratingInfo[0]['abbrev'].length)
                {
                    DBG_INFO("first rating NA!");
                    isFirstRatingNA = true;
                }

                if(isFirstRatingNA)
                {
                    ratingInfoLength--;
                    settingValue = settingValue>>1;
                }

                if(gradScale ==1)
                {
                    if(!enLock)
                    {
                        for(var i = 0; i <= ratingValueSelect; i++)
                        {
                            settingValue &= ~(1<<i);
                        }
                    }
                    else
                    {
                        for(var i = ratingValueSelect; i < ratingInfoLength; i++)
                        {
                            settingValue |= (1<<i);
                        }
                    }
                }
                else if(gradScale ==0)
                {
                    if(!enLock)
                    {
                        settingValue &= ~(1<<ratingValueSelect);
                    }
                    else
                    {
                        settingValue |= (1<<ratingValueSelect);
                    }
                }

                var selectList = [];
                for (var i = 0; i < ratingInfoLength; i++)
                {
                    selectList.push(settingValue&(1<<i)?1:0)
                }

                if(isFirstRatingNA)
                {
                	settingValue = settingValue<<1;
                }

                openVchip['Open V-chip'][regionSelect]['dimensionInfo'][dimensionSelect]['setting']=settingValue;
                this.setOpenVchip(JSON.stringify(openVchip));

                return selectList;
            }
            catch (e)
            {
                DBG_ERROR(e.message)
            }
        };
    }

}

Parental_lockModel.prototype = new SubModel;
Parental_lockModel.prototype.constructor = Parental_lockModel;
{
    SubModel.registerStaticConstants(Parental_lockModel, Parental_lockModelDefines,
        [ { groupPrefix: "SL2_TVAPI_VI32_PARENTAL_LOCK_US_TV_", stripPrefix: "SL2_TVAPI_VI32_" },
              { groupPrefix: "SL2_TVAPI_ACTION_PARENTAL_LOCK_US_TV_", stripPrefix: "SL2_TVAPI_ACTION_" },
              { groupPrefix: "SL2_TVAPI_PARENTAL_", stripPrefix: "SL2_TVAPI_" }
        ]);
}

