/**
 * MessagesModelDefines  class.
 * Contains all defined constants from Y:/values/values-messages.h for
 * internal use.
 */

 function MessagesModelDefines() {
 }
 {
    // --------------------------------------------------------------
    // Static constants
    // --------------------------------------------------------------
        MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_MESSAGEID = "de.loewe.sl2.messages.messageid";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_VSTR_MESSAGEPARAMS = "de.loewe.sl2.messages.messageparams";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_VI32_SELECTORS = "de.loewe.sl2.messages.selectors";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_VI32_SELECTOR_TEXT_PRESETS = "de.loewe.sl2.messages.selector.text.presets";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MSG_CONFIRM = "de.loewe.sl2.messages.action.confirm";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_OSD_VISIBLE = "de.loewe.sl2.messages.osd.visible";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_OSD_VISIBLE_AREA_PERCENTAGE = "de.loewe.sl2.messages.i32.osd.visible.area.percentage";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST_TEST = "de.loewe.sl2.messages.action.test.messagerequest";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST = "de.loewe.sl2.messages.action.messagerequest";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_I32_SHOW_JS_SYMBOL = "de.loewe.sl2.messages.browser.showjssymbol";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_STR_URL = "de.loewe.sl2.messages.browser.url";
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_I32_MTYPE = "de.loewe.sl2.messages.browser.messagetype";


       // enum or defined is here



        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NONE  =  0;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TEST_LOW_PRIORITY  =  1;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TEST_MEDIUM_PRIORITY  =  2;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TEST_HIGH_PRIORITY  =  3;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIME_DATE  =  4;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPGINF  =  5;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_PARAM  =  7;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_TUNER  =  8;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_NOSIG  =  9;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROG_INFO_WAIT  =  10;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_PROG_INFO  =  11;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SUBTITLE_WAIT  =  12;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_SUBTITLE  =  13;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_VCR_REC  =  14;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_PROG  =  15;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RGCIP  =  16;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PRGNOVID  =  17;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PRGNOAUD  =  18;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PRGNOVIDAUD  =  19;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_LNC_NOSUP  =  23;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIMER_STARTED  =  24;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PREPARE_REC  =  25;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIMRECA  =  26;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOTMRFREE  =  27;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TMRPRGNAVL  =  28;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOTPEAV  =  29;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DATOUT  =  31;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TAPELOCK  =  32;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOTAPE  =  33;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIMOVR  =  34;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PERPAG_SRCH  =  35;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PGRSW_TIMER  =  36;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PGRSW_NOSIG  =  37;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PGRSW_MANREC  =  38;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PGRSW_TUNNA  =  39;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SORT_WAIT  =  40;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DVB_NODSP  =  41;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_OFF  =  42;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PVR_ALWAYSON_ON  =  43;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_FILECHECK_HINT  =  44;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_READY  =  45;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ARCHIVEREC_STARTED  =  46;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_REC_START_FAILURE  =  47;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ARCHIVEREC_NO_START  =  48;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ARCHIVEREC_ALREADY  =  49;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ARCHIVEREC_STOPPED  =  50;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ARCHIVEREC_NO_STOP  =  51;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIMERPROG_CHANGED  =  52;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RECORDING_EXTENDED  =  53;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_CRASHED  =  54;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_PROG_SWITCH  =  55;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_BOOKMARK_SET  =  56;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_FADEOUT_ABORT  =  57;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_COPY_ON_HDR  =  58;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_COPY_SUCCESS  =  59;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_COPY_CANCEL  =  60;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_CANCEL  =  61;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_WAIT_FOR_TIMER  =  62;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MACROVISION  =  63;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_PROG_REC  =  64;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIM_REC_ALREADY  =  65;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MOVED_TO_ARCHIVE  =  66;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_NOT_RECORDING  =  67;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_NO_DISC_SPACE_LONG  =  68;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_FADEOUT_SKIPPED_NEW  =  69;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PIP_NOT_POSS_HDRCOPY  =  70;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CSH_DR_DATA_MISSING  =  71;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DATA_MISSING_NOBACK  =  72;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_NOT_READY  =  73;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_ACTIVE_AGAIN  =  74;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FASTREW_NOTPOSS  =  75;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_SLOW_MOTION_HD  =  76;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_NOT_POSSIBLE  =  77;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DESCRAMBLING_STARTED  =  78;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DESCRAMBLING_SUCCESS  =  79;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DESCRAMBLING_FULL  =  80;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DESCRAMBLING_ERROR  =  81;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_NOT_READY_LONG  =  82;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TV_AS_CENTER  =  83;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_COPY_REC  =  84;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RETENTION_TIME_DEL  =  85;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RETENTION_TIME  =  86;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMAT_EXT_NOTPOSS  =  87;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SWITCH_OFFON_HINT  =  88;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMATTING_END  =  89;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMATTING_ACTIVE  =  90;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMAT_FAILED  =  91;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_ACTIVE  =  92;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_POWER_OFF  =  93;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_SUCCESS  =  94;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_SUCCESS_ERR  =  95;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_ERROR  =  96;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_FAILED  =  97;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILE_CHECK_RUN  =  98;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILE_CHECK_END  =  99;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILECHECK_ERROR_FIX_HINT  =  100;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_FOLLOW_ME_NO_SKIP  =  101;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_FOLLOW_ME_NO_WIND  =  102;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FOLLOW_ME_SWITCHOFF  =  103;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_INSTANT_PLAYBACK_NOTIFY  =  104;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROTECTED_REC  =  105;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SOUND_VIA_AURO  =  107;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SOUND_VIA_LSP  =  108;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOREC  =  109;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOVCRSOURCE  =  110;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PLAYA  =  111;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RECA  =  112;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TAPEERROR  =  113;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BATTERY_EMPTY  =  114;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_DIG_SOUND  =  115;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_DOLBY_DIGITAL  =  116;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPG_NO_SWITCH  =  117;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_FUNCTION  =  118;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_FUNCTION_TIMER  =  119;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SLEEPMES  =  120;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_RECORDER  =  121;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HEAT_SWITCHOFF  =  122;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MEMO_PROGRAMME  =  123;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_REC_CANCELLED  =  124;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PAUSE  =  125;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AV_PROG_USED  =  126;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROG_NOT_POSSIBLE  =  127;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PRG_SWITCH_BG  =  128;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RESET_FACTORY_PICSND  =  129;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CA_IN_USE  =  130;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MPEG4_DEC_IN_USE  =  131;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROG_NOT_AVAIL  =  132;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSWITCH_NEWSFL  =  133;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STDVAL_LOADED  =  134;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUDIO_DIGIN  =  135;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_COPY_STARTED  =  136;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DLINK_HD_ACTIVE  =  137;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DLINK_HD_INACTIVE  =  138;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDMI_CONTROL  =  139;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NETW_ASPECT_HINT  =  140;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MSG_WAIT  =  141;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MEDIANETWORK_STARTING  =  142;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_IRADIO_STARTING  =  143;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOTTX_DR_PLAY  =  144;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOTTX_DESCRAMBLE  =  145;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOPIP_DESCRAMBLE  =  146;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FUNCTION_NOT_POSSIBLE  =  147;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PERSPAGES_VPS_LOCK  =  148;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOPIP_DRCOPY  =  150;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CIPLUS_NO_REC  =  151;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CIPLUS_PIN_NOCAM  =  152;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_STARTING  =  153;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_VOD_WARN_LEAVE  =  154;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HOTEL_CH_HINT  =  155;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPG_ANA_HINT  =  156;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUTO_OFF_HINT  =  157;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SWITCH_HD_TO_SD  =  158;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SD_HD_SIMULCAST  =  159;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUTO_OFF_AV  =  160;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SHOPMODE_HINT  =  161;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NEWDEV_CHECK  =  162;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NEWDEV_ERROR  =  163;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_VIDEO_NO_SUPPORT  =  164;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_VIDEO_PART_SUPPORT  =  165;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUDIODES_ACTIV  =  166;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUDIODES_DEACTIV  =  167;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUDIODESC_AVAIL  =  168;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUDIODESC_NOTAVAIL  =  169;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROG_MEM_FOR_REC  =  170;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOPIP_3D  =  171;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_3D_GLASSES  =  172;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_HBBTV_PIP  =  174;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STAT_NO_HBBTV  =  175;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_SEARCH  =  176;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_TTX_SEARCH  =  177;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_END  =  178;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_END_RESTART  =  179;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_ASPECT_RATIO  =  180;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_HBBTV_TIMESHIFT  =  181;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HBBTV_PLAY_NOREC  =  182;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DCM_NIGHT_UPDATE  =  183;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DCM_NUPD_ACTIVE  =  184;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DCM_NUPD_CHG_HINT  =  185;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MHP_SW_UPDATE_ERROR_1  =  186;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MHP_SW_UPDATE_ERROR_2  =  187;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ERR_MHP_DONGLE  =  188;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_ERROR_RATE_TARGET  =  189;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_ERROR_RATE  =  190;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_OVERLOAD_TARGET  =  191;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_OVERLOAD  =  192;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_OVERLOAD_FIX_TARGET  =  193;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG_TARGET  =  194;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NOSIG  =  195;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CI_ERROR_SLOT_1  =  196;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CI_ERROR_SLOT_2  =  197;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_DR_NOT_READY  =  198;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_VIDEO_NOT_READY  =  199;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_FM_STDBY_HOURS  =  200;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_FM_STDBY  =  201;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MAX_VOLUME_HINT  =  202;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MAX_VOLUME_HINT_RADIO  =  203;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MAX_VOLUME_HINT_MUSIC  =  204;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_COPY_SUCCESS  =  205;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_COPY_NOT_STARTED  =  206;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_COPY_ERROR  =  207;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NEWDEV_SUCCESS  =  208;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NEWDEV_SUCCESS_VAR  =  209;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RECALL_TIMER_ON  =  210;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ALARM  =  211;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PIN_REQUEST  =  212;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PIN_REQUEST_RETRY  =  213;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NEWSFLASH  =  214;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_TTX  =  215;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NO_TTX_PAGE  =  216;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CIPLUS_PIN_REQUEST  =  217;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CIPLUS_PIN_REQUEST_RETRY  =  218;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_PAGE_NOTLOAD  =  219;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_KEY_NO_FUNCTION  =  220;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STOP_RECORDING  =  221;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STOP_COPYING  =  222;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STOP_DESCRAMBLING  =  223;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STOP_VPS_RECORDING  =  224;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FAV_ON_DASHBOARD  =  225;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FAV_ALREADY_ON_DASHBOARD  =  226;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPGNOTE_WATCH  =  227;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPGNOTE_LISTEN  =  228;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ADOPT_COVER  =  229;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_NETWORK_SETTINGS_RESET  =  230;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EPGNOTE_STDBY  =  231;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CA_AUTOSEARCH  =  232;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CA_UPDATE_LIST  =  233;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_CA_ADAPT_LIST  =  234;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_CONFIRM_DELETION  =  235;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ALERT  =  236;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_CONFIRM  =  237;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_PROMPT  =  238;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_AUTH  =  239;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_MEMORY  =  240;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_DOCUMENT_FORMAT  =  241;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_DOCUMENT_EMPTY  =  242;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_DOCUMENT_INVALID  =  243;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_JAVA_SCRIPT  =  244;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_PLUGIN  =  245;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_FILE_NOT_FOUND  =  246;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_FILE_NO_ACCESS  =  247;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_GENERAL  =  248;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_SERVER_INVALID  =  249;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_NETWORK_CONNECTION  =  250;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_NETWORK_TIMEOUT  =  251;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_NETWORK_NO  =  252;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_NETWORK_SOCKET  =  253;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_REQUEST  =  254;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_NO_ACCESS  =  255;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_NOT_PERMITTED  =  256;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_NOT_FOUND  =  257;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_EMPTY  =  258;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BROWSER_ERROR_HTTP_SERVER  =  259;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HIFIVOL_NOT_POSS  =  260;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PICTURE_ADJUST_CHANGE  =  261;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ENERGY_EFF_CHANGE  =  262;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_STOP_TIMESHIFT  =  263;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMAT_INTEGRATED  =  264;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FORMAT_EXTERNAL  =  265;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_FILECHECK_INT  =  266;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_MAX_DASHBOARD_ENTRIES  =  267;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_NO_TIMESHIFT  =  268;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_DEREG_QUEST  =  269;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_DEREG_CODE  =  270;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_REG_CODE  =  271;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_AUTHORIZATION_ERROR  =  272;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_RENTAL_EXPIRED  =  273;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DIVX_RENTAL_CONFIRMATION  =  274;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ADOPT_AS_START_PAGE  =  275;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_DYNAMIC_TEXT_WITH_TIMEOUT  =  276;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DCM_LIVE  =  277;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_OPTIME_USER_HINT  =  278;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ECO_MODE  =  279;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_USB_TIMESHIFT  =  280;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_LOAD_ACTIVE  =  281;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_USB_TIMESHIFT_MEM_SIZE  =  282;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_FILE_NOTSUPP  =  283;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_WRONG_AUDIO_FORMAT  =  284;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_USB_TIMESHIFT_NO_MEDIUM  =  285;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PIN_CHECK_REQUEST  =  286;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROGRESS_BAR_INFINITE  =  287;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_DYNAMIC_TEXT_WITHOUT_TIMEOUT  =  288;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_HDD_ERROR  =  289;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DUMMY_1  =  290;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STATION_NOT_RUNNING  =  291;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_STATION_LOCKED  =  292;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_PROGRAMME_LOCKED  =  293;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_INPUT_FIELD_KEYS_HINT  =  294;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SOUND_VIA_ANY  =  295;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_LOAD_ERROR  =  296;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_LOAD_SUCCESS  =  297;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_COPY_ACTIVE  =  298;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUTO_SWITCHON_CHECK  =  299;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_DR_BLOCKED  =  300;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RESET_PICTURE_SOUND_WARNING  =  301;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_EMPTY_NO_TIMEOUT  =  302;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_BATTERY_EMPTY_SHORT  =  303;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_LSP_CONNECTION_FAILED  =  304;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_TIMER_DATA_STORED  =  305;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_SFB_ANNOUNCE  =  306;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AUTO_INFO_HINT  =  307;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_COPY_PREPARED  =  308;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MOVE_ON_HDR  =  309;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_MOVE_PREPARED  =  310;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_MOVE_SUCCESS  =  311;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_MOVE_ERROR  =  312;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DR_MOVE_NOT_STARTED  =  313;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_HDR_MOVE_CANCEL  =  314;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_ENERGY_EFF_CHANGE_2  =  315;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_DVB_NOLIVE  =  316;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_RECOMMENDATIONS  =  317;

        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_STATE_NOTIFY =  378;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_DISPLAY_CARDS_NOTIFY =  379;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_ERROR_CODE_NOTIFY =  380;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_CODE_NOTIFY =  381;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_RESULT_NOTIFY =  382;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_LOGIN_STATUS_NOTIFY =  383;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_USER_PROFILE_NOTIFY =  384;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_TOKEN_NOTIFY =  385;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_INFO_NOTIFY =  386;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_RESULT_NOTIFY =  387;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HILOGIN_STATUS_NOTIFY =  388;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIUSER_PROFILE_NOTIFY =  389;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIREPORT_DEVINFO_RESULT_NOTIFY =  390;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_ALARM_FLAG_NOTIFY =  391;
        MessagesModelDefines.SL2_TVAPI_MESSAGE_ID_AVS_HIDEV_INFO_NOTIFY =  392;


        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_OK  =  0;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_CANCEL  =  1;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_YES  =  2;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_NO  =  3;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_RETRY  =  4;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_IGNORE  =  5;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_ESCAPE  =  6;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_TEXT  =  7;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_PASSWORD  =  8;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_CAM_AT_ONCE  =  9;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_CAM_AFTER_SWITCH_OFF  =  10;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_CAM_LATER  =  11;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_ADOPT  =  12;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_CLOSE  =  13;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_SELECTOR_BUTTON_OK_LONG  =  14;


        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MSG_CONFIRM_ARG_0  =  0;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MSG_CONFIRM_ARG_1  =  1;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_OSD_VISIBLE_AREA_PERCENTAGE_MAX  =  100;


        MessagesModelDefines.SL2_TVAPI_MESSAGES_OSD_VISIBLE_AREA_PERCENTAGE_MIN  =  0;


        MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST_ARG_0  =  0;


        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_NONE  =  0;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ALERT  =  1;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_CONFIRM  =  2;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_PROMPT  =  3;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_AUTHENTICATION  =  4;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ERROR_DOCUMENT  =  5;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ERROR_FILE  =  6;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ERROR_GENERAL  =  7;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ERROR_NETWORK  =  8;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_ERROR_HTTP  =  9;
        MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_MTYPE_MAX_VALUE  =  9;
}
/**
 * MessagesModel class derived from SubModel.
 */
function MessagesModel( parentModel ) {
    SubModel.call( this, parentModel, MessagesModelDefines );
    this.registerSubObject = function(){

    // --------------------------------------------------------------
    // Objects
    // --------------------------------------------------------------
    // Messageid
            this.registerIntegerObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_MESSAGEID,
            "getMessageid", "setMessageid", "onMessageidChaged",
            null, null );

    // Messageparams
            this.registerStringVectorObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_VSTR_MESSAGEPARAMS,
            "getMessageparams", "setMessageparams", "onMessageparamsChaged",
            null, null );

    // Selectors
            this.registerIntegerVectorObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_VI32_SELECTORS,
            "getSelectors", "setSelectors", "onSelectorsChaged",
            null, null );

    // SelectorTextPresets
            this.registerIntegerVectorObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_VI32_SELECTOR_TEXT_PRESETS,
            "getSelectorTextPresets", "setSelectorTextPresets", "onSelectorTextPresetsChaged",
            null, null );

// Need to fix
// MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MSG_CONFIRM=  "de.loewe.sl2.messages.action.confirm "

    // ActionConfirm
            this.registerActionObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MSG_CONFIRM,
                [
                    {name:"ActionConfirm",method:function(object,arg1, arg2){
                    return object.invoke(arg1, arg2);
                    }}
                ],null
            );

    // OsdVisible
            this.registerIntegerObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_OSD_VISIBLE,
            "getOsdVisible", "setOsdVisible", "onOsdVisibleChaged",
            null, null );

    // I32OsdVisibleAreaPercentage
            this.registerIntegerObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_I32_OSD_VISIBLE_AREA_PERCENTAGE,
            "getI32OsdVisibleAreaPercentage", "setI32OsdVisibleAreaPercentage", "onI32OsdVisibleAreaPercentageChaged",
            null, null );

// Need to fix
// MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST_TEST=  "de.loewe.sl2.messages.action.test.messagerequest "

    // ActionTestMessagerequest
            this.registerActionObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST_TEST,
                [
                    {name:"ActionTestMessagerequest",method:function(object){
                        return object.invoke();
                    }}
                ],null
            );

// Need to fix
// MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST=  "de.loewe.sl2.messages.action.messagerequest "

    // ActionMessagerequest
            this.registerActionObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_ACTION_MESSAGE_REQUEST,
                [
                    {name:"ActionMessagerequest",method:function(object,vector){
                        return object.invoke(vector[0],vector[1],vector[2],vector[3],vector[4],vector[5],vector[6],vector[7],vector[8],vector[9],vector[10],vector[11],
                        vector[12],vector[13],vector[14],vector[15]);
                    }}
                ],null
            );

    // BrowserShowjssymbol
            this.registerIntegerObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_I32_SHOW_JS_SYMBOL,
            "getBrowserShowjssymbol", "setBrowserShowjssymbol", "onBrowserShowjssymbolChaged",
            null, null );

    // BrowserUrl
            this.registerStringObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_STR_URL,
            "getBrowserUrl", "setBrowserUrl", "onBrowserUrlChaged",
            null, null );

    // BrowserMessagetype
            this.registerIntegerObject(
            MessagesModelDefines.SL2_TVAPI_MESSAGES_BROWSER_I32_MTYPE,
            "getBrowserMessagetype", "setBrowserMessagetype", "onBrowserMessagetypeChaged",
            null, null );
    }
}
MessagesModel.prototype = new SubModel();
MessagesModel.prototype.constructor = MessagesModel;
{
    // --------------------------------------------------------------
    // Static constants
    // --------------------------------------------------------------
    SubModel.registerStaticConstants(
            MessagesModel, MessagesModelDefines,[])
}
