/**
 * B2bModelDefines  class.
 * Contains all defined constants from C:/Users/Administrator/Desktop/values-b2b.h for
 * internal use.
 */

function B2bModelDefines() {
}
{
    // --------------------------------------------------------------
    // Static constants
    // -------------------------------------------------------------- 
    B2bModelDefines.TVAPI_B2B_STR_CMD_RECV = "tvapi.b2b.str.cmd.recv";
    B2bModelDefines.TVAPI_B2B_STR_CMD_PC_SET = "tvapi.b2b.str.cmd.pc.set";
    B2bModelDefines.TVAPI_B2B_STR_CMD_PC_GET = "tvapi.b2b.str.cmd.pc.get";
    B2bModelDefines.TVAPI_B2B_STR_CMD_PC_PARAM = "tvapi.b2b.str.cmd.pc.param";
    B2bModelDefines.TVAPI_B2B_STR_CMD_REPLY = "tvapi.b2b.str.cmd.reply";
    B2bModelDefines.SL2_TVAPI_I32_B2B_POWER_ON_FIXED = "tvapi.i32.b2b.pwr.on.fixed";
    B2bModelDefines.SL2_TVAPI_I32_B2B_REMOTE_CONTROL_BUTTON = "tvapi.i32.b2b.rc.button";
    B2bModelDefines.SL2_TVAPI_I32_B2B_PANEL_BUTTON = "tvapi.i32.b2b.panel.button";
    B2bModelDefines.SL2_TVAPI_I32_B2B_MENU_BUTTON = "tvapi.i32.b2b.menu.button";
    B2bModelDefines.SL2_TVAPI_I32_B2B_RS232_POWER_ON = "tvapi.i32.b2b.rs232.pwr.on";
    B2bModelDefines.TVAPI_B2B_I32_SCREEN_DISPLAY_ENABLE = "tvapi_b2b_i32_screen_display_enable";
    B2bModelDefines.TVAPI_B2B_I32_RC_PASS_THROUGH_ENABLE = "tvapi_b2b_i32_rc_pass_through_enable";
    B2bModelDefines.TVAPI_B2B_I32_USB_BEHAVIOR = "tvapi_b2b_i32_usb_behavior";
    B2bModelDefines.TVAPI_B2B_I32_FUNCTION_MODE_ENABLE = "tvapi_b2b_i32_function_mode_enable";
    B2bModelDefines.TVAPI_B2B_I32_MAX_VOLUME = "tvapi.i32.b2b.max.volume";
    B2bModelDefines.TVAPI_B2B_I32_VOLUME_FIXED_MODE = "tvapi.i32.b2b.volume.fixed.mode";
    B2bModelDefines.TVAPI_B2B_I32_VOLUME_FIXED_LEVEL = "tvapi.i32.b2b.volume.fixed.level";
    B2bModelDefines.TVAPI_B2B_I32_INPUT_SOURCE_ID = "tvapi.i32.b2b.input.source.id";
    B2bModelDefines.TVAPI_B2B_I32_INPUT_SOURCE_MODE = "tvapi.i32.b2b.input.source.mode";
    B2bModelDefines.TVAPI_B2B_I32_AV_POSITION_FIXED = "tvapi.i32.b2b.av.position.fixed";
    B2bModelDefines.TVAPI_B2B_I32_POWER_ON_MODE = "tvapi.i32.b2b.power.on.mode";
    B2bModelDefines.TVAPI_B2B_I32_RS232_MAX_VOLUME = "tvapi.i32.b2b.rs232.max.volume";
    B2bModelDefines.TVAPI_B2B_I32_RS232_VOLUME_FIXED_MODE = "tvapi.i32.b2b.rs232.volume.fixed.mode";
    B2bModelDefines.TVAPI_B2B_I32_RS232_VOLUME_FIXED_LEVEL = "tvapi.i32.b2b.rs232.volume.fixed.level";
    B2bModelDefines.SL2_TVAPI_I32_B2B_MENU_SHOW_STATUS = "tvapi.i32.b2b.menu.show.status";


    // enum or defined is here

}
/**
 * B2bModel class derived from SubModel.
 */
function B2bModel( parentModel ) {
    SubModel.call(this, parentModel, B2bModelDefines);
    this.registerSubObject = function () {
        // --------------------------------------------------------------
        // Objects
        // --------------------------------------------------------------
        // StrCmdRecv
        this.registerStringObject(
            B2bModelDefines.TVAPI_B2B_STR_CMD_RECV,
            "getStrCmdRecv", "setStrCmdRecv", "onStrCmdRecvChaged",
            null, null);

        // StrCmdPcSet
        this.registerStringObject(
            B2bModelDefines.TVAPI_B2B_STR_CMD_PC_SET,
            "getStrCmdPcSet", "setStrCmdPcSet", "onStrCmdPcSetChaged",
            null, null);

        // StrCmdPcGet
        this.registerStringObject(
            B2bModelDefines.TVAPI_B2B_STR_CMD_PC_GET,
            "getStrCmdPcGet", "setStrCmdPcGet", "onStrCmdPcGetChaged",
            null, null);

        // StrCmdPcParam
        this.registerStringObject(
            B2bModelDefines.TVAPI_B2B_STR_CMD_PC_PARAM,
            "getStrCmdPcParam", "setStrCmdPcParam", "onStrCmdPcParamChaged",
            null, null);

        // StrCmdReply
        this.registerStringObject(
            B2bModelDefines.TVAPI_B2B_STR_CMD_REPLY,
            "getStrCmdReply", "setStrCmdReply", "onStrCmdReplyChaged",
            null, null);

        // PwrOnFixed
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_POWER_ON_FIXED,
            "getPwrOnFixed", "setPwrOnFixed", "onPwrOnFixedChaged",
            null, null);

        // RcButton
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_REMOTE_CONTROL_BUTTON,
            "getRcButton", "setRcButton", "onRcButtonChaged",
            null, null);

        // PanelButton
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_PANEL_BUTTON,
            "getPanelButton", "setPanelButton", "onPanelButtonChaged",
            null, null);

        // MenuButton
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_MENU_BUTTON,
            "getMenuButton", "setMenuButton", "onMenuButtonChaged",
            null, null);

        // Rs232PwrOn
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_RS232_POWER_ON,
            "getRs232PwrOn", "setRs232PwrOn", "onRs232PwrOnChaged",
            null, null);

        // _i32_screen_display_enable
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_SCREEN_DISPLAY_ENABLE,
            "getScreenDisplayEnable", "setScreenDisplayEnable", "on_i32_screen_display_enableChaged",
            null, null);

        // _i32_rc_pass_through_enable
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_RC_PASS_THROUGH_ENABLE,
            "getRcPassThroughEnable", "setRcPassThroughEnable", "on_i32_rc_pass_through_enableChaged",
            null, null);

        // _i32_usb_behavior
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_USB_BEHAVIOR,
            "getUsbBehavior", "setUsbBehavior", "on_i32_usb_behaviorChaged",
            null, null);

        // _i32_function_mode_enable
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_FUNCTION_MODE_ENABLE,
            "getFunctionModeEnable", "setFunctionModeEnable", "on_i32_function_mode_enableChaged",
            null, null);

        // MaxVolume
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_MAX_VOLUME,
            "getMaxVolume", "setMaxVolume", "onMaxVolumeChaged",
            null, null);

        // VolumeFixedMode
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_VOLUME_FIXED_MODE,
            "getVolumeFixedMode", "setVolumeFixedMode", "onVolumeFixedModeChaged",
            null, null);

        // VolumeFixedLevel
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_VOLUME_FIXED_LEVEL,
            "getVolumeFixedLevel", "setVolumeFixedLevel", "onVolumeFixedLevelChaged",
            null, null);

        // InputSourceId
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_INPUT_SOURCE_ID,
            "getInputSourceId", "setInputSourceId", "onInputSourceIdChaged",
            null, null);

        // InputSourceMode
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_INPUT_SOURCE_MODE,
            "getInputSourceMode", "setInputSourceMode", "onInputSourceModeChaged",
            null, null);

        // AvPositionFixed
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_AV_POSITION_FIXED,
            "getAvPositionFixed", "setAvPositionFixed", "onAvPositionFixedChaged",
            null, null);

        // PowerOnMode
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_POWER_ON_MODE,
            "getPowerOnMode", "setPowerOnMode", "onPowerOnModeChaged",
            null, null);
        // Rs232MaxVolume
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_RS232_MAX_VOLUME,
            "getRs232MaxVolume", "setRs232MaxVolume", "onRs232MaxVolumeChaged",
            null, null);

        // Rs232VolumeFixedMode
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_RS232_VOLUME_FIXED_MODE,
            "getRs232VolumeFixedMode", "setRs232VolumeFixedMode", "onRs232VolumeFixedModeChaged",
            null, null);

        // Rs232VolumeFixedLevel
        this.registerIntegerObject(
            B2bModelDefines.TVAPI_B2B_I32_RS232_VOLUME_FIXED_LEVEL,
            "getRs232VolumeFixedLevel", "setRs232VolumeFixedLevel", "onRs232VolumeFixedLevelChaged",
            null, null);
        // menuShowStatus
        this.registerIntegerObject(
            B2bModelDefines.SL2_TVAPI_I32_B2B_MENU_SHOW_STATUS,
            "getMenuShowStatus", "setMenuShowStatus", "onMenuShowStatusChaged",
            null, null);
    }

}
B2bModel.prototype = new SubModel();
B2bModel.prototype.constructor = B2bModel;
{
    // --------------------------------------------------------------
    // Static constants
    // --------------------------------------------------------------    
    SubModel.registerStaticConstants(
        B2bModel, B2bModelDefines,
        []);
}
