/**
 * Created by Administrator on 16-2-3.
 */
console.log("inputsInterface.js loading start " + new Date().getTime());
var ITEM_NUM = 7;
var sourceMap = [];

function initAllInputsData(){
    var signalSourceList = [], allSourceList = [], sourceArr = [],noSignalSourceList = [];
    var inputsData = {};
    var sourceItem = [
        //id, name, signal, lock, rename, hotelLocked,
        "0", "ANT/CABLE", "0", "0", "ANT/CABLE","","",
        "1", "AV", "1", "0", "","","",
        "2", "COMPONENT", "1", "0", "COMPONENT","","",
        "3", "VGA", "1", "0", "","","",
        "4", "HDMI1", "1", "0", "","","",
        "5", "HDMI2", "1", "0", "","","",
        "6", "HDMI3", "1", "0", "","","",
        "7", "HDMI4", "1", "0", "","","",
        "8", "SCART", "1", "0", "","",""

    ];
    try{
        var sourceItema = ["TV","0","TVAAAA","","AVS","0","AV","","COMPONENT","0","COMPONENT","","HDMI1","0","HDMI1","","HDMI2","0","HDMI2","","HDMI3","0","HDMI3","","HDMI4","0","HDMI4",""];
        if(tv) sourceItema = model.source.getInputName();
        var lockList = "TV,hdmi1";
        if(tv)  lockList = model.parentlock.getInputSourceLock();
        var lockInputList=lockList.split(",");
        DBG_ERROR("sourceItema:" + objToString(sourceItema));
        DBG_ERROR("lockList:" + objToString(lockList));
        sourceItem = [];
        sourceMap=[];
        for(var i =0;i<sourceItema.length;i=i+4){
            switch (sourceItema[i]){
                case "TV":
                    var item = ["0", "ANT/CABLE", "0", "0", "ANT/CABLE","","TV"];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"TV");
                        var index1=_getIndex(lockInputList,"tv");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 0,
                        playId : sourceItema[i]
                    };

                    sourceMap.push(playMap);
                    break;
                case "AVS":
                    var item = ["1", "AV", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"AVS");
                        var index1=_getIndex(lockInputList,"avs");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 1,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
                case "COMPONENT":
                case "component":
                    var item = ["2", "COMPONENT", "1", "0", "COMPONENT","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"COMPONENT");
                        var index1=_getIndex(lockInputList,"component");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 2,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
                case "VGA":
                case "vga":
                    var item = ["3", "VGA", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"VGA");
                        var index1=_getIndex(lockInputList,"vga");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 3,
                        playId : sourceItema[i+3]
                    };
                    sourceMap.push(playMap);
                    break;
                case "HDMI1":
                case "hdmi1":
                    var item = ["4", "HDMI1", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"HDMI1");
                        var index1=_getIndex(lockInputList,"hdmi1");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 4,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
                case "HDMI2":
                case "hdmi2":
                    var item = ["5", "HDMI2", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"HDMI2");
                        var index1=_getIndex(lockInputList,"hdmi2");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id :5,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
                case "HDMI3":
                case "hdmi3":
                    var item = ["6", "HDMI3", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"HDMI3");
                        var index1=_getIndex(lockInputList,"hdmi3");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 6,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
                case "HDMI4":
                case "hdmi4":
                    var item = ["7", "HDMI4", "1", "0", "","",""];
                    if(sourceItema[i+1] == 2){
                        item[2] = 0;
                    }
                    item[4] = sourceItema[i+2];
                    if(lockInputList.length>0){
                        var index=_getIndex(lockInputList,"HDMI4");
                        var index1=_getIndex(lockInputList,"hdmi4");
                        if(index>=0 || index1>0){
                            item[3] = 1;
                        }
                    }
                    item[6]=sourceItema[i];
                    sourceItem = sourceItem.concat(item);
                    var playMap = {
                        id : 7,
                        playId : sourceItema[i]
                    };
                    sourceMap.push(playMap);
                    break;
//                case "SCART":
//                case "scart":
//                    var item = ["8", "SCART", "1", "0", "",""];
//                    if(sourceItema[i+1] == 2){
//                        item[2] = 0;
//                    }
//                    item[4] = sourceItema[i+2];
//                    sourceItem = sourceItem.concat(item);
//                    var playMap = {
//                        id : 8,
//                        playId : sourceItema[i]
//                    };
//                    sourceMap.push(playMap);
//                    break;
            }
        }

//        DBG_INFO("sourceItem:" + objToString(sourceItem));
        DBG_ERROR("sourceMap:" + objToString(sourceMap));
        var locked = false;
        var sMode = (tv)?model.parentlock.getSModel():1;
        var lockTime = getIsInlockTime();
        var isLock = false;
        if(sMode!=0 && lockTime==1){
            isLock = true;
        }
        var TVNoSignal = tv ? liveTV.getHasChannelFlag() : false;
        for (var i = 0; i < sourceItem.length / ITEM_NUM; i++) {
            if (sourceItem[i * ITEM_NUM] == 0 && !TVNoSignal)sourceItem[i * ITEM_NUM + 2] = 1;
            if(sourceItem[i * ITEM_NUM + 3] == 1 && isLock){
                locked = true;
            }else{
                locked = false;
            }
            sourceArr.push({
                id: sourceItem[i * ITEM_NUM],
                name:sourceItem[i * ITEM_NUM + 1],
                signal: sourceItem[i * ITEM_NUM + 2],
                lock: sourceItem[i * ITEM_NUM + 3],
                locked: locked,
                hotelLocked:sourceItem[i * ITEM_NUM + 5],
                rename: sourceItem[i * ITEM_NUM + 4],
                playId:sourceItem[i * ITEM_NUM + 6]
            });
            allSourceList.push(sourceItem[i * ITEM_NUM]);
            if (sourceItem[i * ITEM_NUM + 2] == 0) {
                signalSourceList.push(sourceItem[i * ITEM_NUM]);
            }else {
                noSignalSourceList.push(sourceItem[i * ITEM_NUM]);
            }
        }
        inputsData.allSourceList = allSourceList;
        inputsData.signalSourceList = signalSourceList;
        inputsData.noSignalSourceList = noSignalSourceList;
        inputsData.sourceList = sourceArr;
        GLOBAL.SOURCE_LIST = sourceArr;
        DBG_INFO("inputsData:" + objToString(inputsData));
        return inputsData;
    }catch(e){
        DBG_ERROR(e.message);
    }
}

var defaultMap = [{id : 0,playId : "TV"},
    {id : 1,playId : "AVS"},
    {id : 2,playId : "COMPONENT"},
    {id : 3,playId : "VGA"},
    {id : 4,playId : "HDMI1"},
    {id : 5,playId : "HDMI2"},
    {id : 6,playId : "HDMI3"},
    {id : 7,playId : "HDMI4"}];

function mapInputsDataById(id){
    var playId = 0;
    if(sourceMap.length == 0){
        sourceMap = defaultMap;
    }
    for(var i =0;i<sourceMap.length;i++){
        if(sourceMap[i].id == id){
            playId = sourceMap[i].playId;
            break;
        }
    }
    return playId;

}

function mapInputsDataByPlayId(playId){
    var id = 0;
    if(sourceMap.length == 0){
        sourceMap = defaultMap;
    }
    for(var i =0;i<sourceMap.length;i++){
        if(sourceMap[i].playId == playId){
            id = sourceMap[i].id;
            break;
        }
    }
    return id;
}

function getCurrentSourceId(){
    try{
//        var value = model.tvservice.getMainPlay();
        var value = model.source.getCurrentSource();
        DBG_ERROR("getCurrentSourceId!!!!!!!!!!!!!!!!!:"+JSON.stringify(value));
//        if (value.length == 0) {
//            return 0;
//        }
        var id = mapInputsDataByPlayId(value);

    }catch(e){
        DBG_ERROR(e.message);
    }
    return id;
}

function getInputsDataForLauncher(){
    var inputsData = initAllInputsData();
    var list = getRecentInputs(inputsData);
    var showData = [];
    try{
        var sourceInfo = {"signal":true,"uid":0,"channelName":"TV12345678WWWWWWWWWTTTTT"};
        sourceInfo.uid = getCurrentSourceId();
        DBG_INFO("getCurrentSourceObj:"+JSON.stringify(sourceInfo));
        var crtOtt = readFileFromNative("launcher/ott.txt", 1);
        DBG_ERROR("curr  source  OTT  is "+ JSON.stringify(crtOtt));

    }catch(e){
        DBG_ERROR(e.message);
    }

    var sMode = (tv)?model.parentlock.getSModel():1;
    var lockTime = getIsInlockTime();
    var isLock = false;
    if(sMode!=0 && lockTime==1){
        isLock = true;
    }
    var mode = tv?model.system.getUserMode():1;

    var ottIndex = -1;
    if(crtOtt!=null && crtOtt.name != 0 ){
        for(var x=0;x<g_ottList.length;x++){
            if(g_ottList[x].data.url == crtOtt.url){
                ottIndex = x;
                break;
            }
        }
    }


    if(ottIndex>-1 && mode == 0){
        var locked = false;
        if(g_ottList[ottIndex].Locked && isLock){
            locked = true;
        }
        var ott ={
            "id":"300",
            "name":g_ottList[ottIndex].Name,
            "rename":g_ottList[ottIndex].Name,
            "uid":g_ottList[ottIndex].data.url,
            "signal":true,
            "locked":locked,
            "img":g_ottList[ottIndex].Icon};
        showData.push($.extend(true,{},ott));
    }
    else{

        for(var i = 0; i < list.length; i++) {
            var item ={};
            if(list[i].id == sourceInfo.uid){
                item = list[i];
                if(list[i].id == 0) {
                    item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_tv_active.png";
                }else{
                    item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_" + list[i].uid + "_active.png";
                }
                if(list[i].signal == 0) {
                    item.signal = true;
                }else{
                    item.signal = false;
                }
                showData.push($.extend(true,{},item));
                break;
            }
        }
    }
    var addCast = false;
    for(var i = 0; i < list.length; i++) {
        if(ottIndex>-1){

        }else{
            if(list[i].id == sourceInfo.uid){
                continue;
            }
        }

        var item ={};
        item = list[i];
        if(list[i].signal == 0) {
            if(list[i].id == 0) {
                item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_tv_connected.png";
            }else{
                item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_" + list[i].uid + "_connected.png";
            }
            item.signal = true;
        }else{
            if(!addCast){
                if(mode == 0){
                    for(var x=0;x<g_ottList.length;x++){
                        var locked = false;
                        if(g_ottList[x].Locked && isLock){
                            locked = true;
                        }
                        if(ottIndex>-1){
                            if(x == ottIndex){
                                continue;
                            }
                        }
                        var ott ={
                            "id":"300",
                            "name":g_ottList[x].Name,
                            "rename":g_ottList[x].Name,
                            "uid":g_ottList[x].data.url,
                            "signal":true,
                            "locked":locked,
                            "img":g_ottList[x].Icon};
                        showData.push($.extend(true,{},ott));
                    }
                }

                var cast ={
                    "id":"100",
                    "name":"AnyviewCast",
                    "rename":"",
                    "uid":"AnyviewCast",
                    "signal":true,
                    "img":"launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/Anyview.png"};
                showData.push($.extend(true,{},cast));
                addCast = true;
            }
            item.signal = false;
            if(list[i].id == 0){
                item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_tv_disconnected.png";
            }else{
                item.img = "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/la_ic_" + list[i].uid + "_disconnected.png";
            }
        }
        showData.push($.extend(true,{},item));
    }
    if(!addCast){
        if(mode == 0){
            for(var x=0;x<g_ottList.length;x++){
                var locked = false;
                if(g_ottList[x].Locked && isLock){
                    locked = true;
                }
                if(ottIndex>-1){
                    if(x == ottIndex){
                        continue;
                    }
                }
                var ott ={
                    "id":"300",
                    "name":g_ottList[x].Name,
                    "rename":g_ottList[x].Name,
                    "uid":g_ottList[x].data.url,
                    "signal":true,
                    "locked":locked,
                    "img":g_ottList[x].Icon};
                showData.push($.extend(true,{},ott));
            }
        }

        var cast ={
            "id":"100",
            "name":"AnyviewCast",
            "rename":"",
            "uid":"AnyviewCast",
            "signal":true,
            "img":"launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/Anyview.png"};
        showData.push($.extend(true,{},cast));
        addCast = true;
    }
    DBG_ERROR("return data:" + objToString(showData));
    return showData;
}

function getRecentInputs(inputsData){
    var ret = {},
        showSourceList = [],
        recentArr = [],
        list = [];

    ret = {'source': ['4','5','6','7','0','2','1','3','8']};
    if (ret != null) {
        try {
            recentArr = ret.source;
        }
        catch (ex) {
            DBG_ERROR('err:' + ex);
        }
    }
    showSourceList = getShowSourceList(recentArr,inputsData);
    try{
        $.each(showSourceList, function (index, item) {
            var jsonObj = getSourceJsonObjById(item,inputsData);
            list[index] = {};
            list[index].id = jsonObj.id;
            list[index].playid = jsonObj.playid;
            list[index].name = jsonObj.name;
            list[index].signal = jsonObj.signal;
            list[index].lock = jsonObj.lock;
            list[index].locked = jsonObj.locked;
            list[index].rename = jsonObj.rename;
            list[index].uid = jsonObj.name.toLowerCase().replace(" ", "");
        });
    }catch(e){
        DBG_ERROR(e.message);
    }
    return list;
}

function getSourceJsonObjById(id,inputsData){
    var sourceObj = {};
    $.each(inputsData.sourceList, function (index, item) {
        if (item.id == id) {
            sourceObj = item;
            return false;
        }
    });
    return sourceObj;
}

function getShowSourceList(recentArr,inputsData){
    var showSourceList = [];
    LauncherSortSignalList(recentArr,inputsData);
    LauncherSortAllList(recentArr,inputsData);
    LauncherSortAllList(inputsData.signalSourceList,inputsData);
    for(var i=0;i<inputsData.allSourceList.length;i++){
        showSourceList.push(inputsData.allSourceList[i]);
    }
    return showSourceList;
}

function LauncherSortSignalList(recentArr,inputsData){
    var signalSourceList = inputsData.signalSourceList;
    var list = [];
    for(var i = 0;i<recentArr.length;i++){
        var index = $.inArray(recentArr[i], signalSourceList);
        if ( index > -1) {
            list.push(recentArr[i]);
            signalSourceList.splice(index, 1);
        }
    }
    list = list.concat(signalSourceList);
    inputsData.signalSourceList = list;
}
function LauncherSortAllList(recentArr,inputsData){
    var sourceList = inputsData.allSourceList;
    var list = [];
    for(var i = 0;i<recentArr.length;i++){
        var index = $.inArray(recentArr[i], sourceList);
        if ( index > -1) {
            list.push(recentArr[i]);
            sourceList.splice(index, 1);
        }
    }
    list = list.concat(sourceList);
    inputsData.allSourceList = list;
}
function getInputsDataForMixBar(){
    var inputsData = initAllInputsData();
    var list = getRecentInputs(inputsData);
    var showData = [];
    try{
        var sourceInfo = {"signal":true,"uid":0,"channelName":"TV12345678WWWWWWWWWTTTTT"};
        sourceInfo.uid = getCurrentSourceId();
//        var sourceInfo = info;
    }catch(e){
        DBG_ERROR(e.message);
    }
    for(var i = 0; i < list.length; i++) {
        var item ={};
        if(list[i].id == sourceInfo.uid){
            item = list[i];
//            if(list[i].signal == 0) {
//            item.img = "mixBar/la_ic_" + list[i].uid + "_active.png";
            item.color = "0xffffff";
//            }
            if(list[i].id == 0){
                item.img = "mixBar/la_ic_tv_active.png";
            }else{
                item.img = "mixBar/la_ic_" + list[i].uid + "_active.png";
            }
            showData.push($.extend(true,{},item));
            break;
        }
    }
    for(var i = 0; i < list.length; i++) {
        if(list[i].id == sourceInfo.uid){
            continue;
        }
        var item ={};
        item = list[i];
        if(list[i].signal == 0) {
            if(list[i].id == 0){
                item.img = "mixBar/la_ic_tv_connected.png";
            }else{
                item.img = "mixBar/la_ic_" + list[i].uid + "_connected.png";
            }

            item.color = "0xffffff";
            item.alpha = 0.6;
        }else{
            if(list[i].id == 0){
                item.img = "mixBar/la_ic_tv_disconnected.png";
            }else{
                item.img = "mixBar/la_ic_" + list[i].uid + "_disconnected.png";
            }

            item.color = "0xffffff";
            item.alpha = 0.2;
        }
        showData.push($.extend(true,{},item));
    }
    return showData;
}
console.log("inputsInterface.js loading end " + new Date().getTime());