/**
 * Created by liutiantian on 2016-01-13.
 */

var host = host || {};
var iqqi_new_array = ["ENG", "POR", "SPA", "DEU", "RUS", "ITA", "LAV", "EST", "SLV", "DUT", "ICE", "GRE", "FRA", "CES", "LIT", "SLK", "HRV","GRE", "HUN", "UKR", "MAC", "ALB", "SRP", "SRPC", "CHI", "ARA", "POL", "DAN", "FIN", "NOR", "SWE", "BUL", "TUR", "UZB"];
var iqqi_imagine_timer = null;
function initIQQI() {
    host.test = false;
    host.tv = Config.tv;
    host.lastWorkType = "";

    host.tools = host.tools || new Tools();
    host.logger = host.logger || new MyLog();
    host.keyevent = host.keyevent || new KeyEvent();
    initIQQIConstants();

    host.keyboard = host.keyboard || new KeyEventManager();

    host.config = host.config || iqqiConfig;
    if (host.tv) {
        host.config.curImeType = imejs.iqqi.ENGLISH;
        host.config.ImeDict = host.config.ImeDict || {
                "ENG": imejs.iqqi.ENGLISH,
                "FRA": imejs.iqqi.FRENCH,
                "SPA": imejs.iqqi.SPANISH,
                "POR": imejs.iqqi.BRAZILIAN,
                "ARA": imejs.iqqi.ARABIC,
                "RUS": imejs.iqqi.RUSSIAN,
                "FAS": imejs.iqqi.PERSIAN,
                "HEB": imejs.iqqi.HEBREW,
                "MSA": imejs.iqqi.MALAY,
                "CHI": imejs.iqqi.SIMPLIFIED_CHINESE_PINYIN,
                "ZHO": imejs.iqqi.TRADITIONAL_CHINESE_ZHUYIN,
                "THA": imejs.iqqi.THAI,
                "UKR": imejs.iqqi.UKRIANIAN,
                "TUR": imejs.iqqi.TURKISH,
                "SWE": imejs.iqqi.SWEDISH,
                "SLK": imejs.iqqi.SLOVAKIAN,
                "POL": imejs.iqqi.POLISH,
                "VIE": imejs.iqqi.VIETNAMESE,
                "NOR": imejs.iqqi.NORWEGIAN,
                "ITA": imejs.iqqi.ITALIAN,
                "IND": imejs.iqqi.INDONESIA,
                "HUN": imejs.iqqi.HUNGARIAN,
                "HIN": imejs.iqqi.HINDI,
                "DEU": imejs.iqqi.GERMAN,
                "FIN": imejs.iqqi.FINNISH,
                "DAN": imejs.iqqi.DANISH,
                "CES": imejs.iqqi.CZECH,
                "BUL": imejs.iqqi.BULGARIAN,
                "MYA": imejs.iqqi.MYANMAR,
                "UZB": imejs.iqqi.UZBEK,
                "EST": imejs.iqqi.ESTONIAN,
                "LAV": imejs.iqqi.LATVIAN,
                "LIT": imejs.iqqi.LITHUANIAN,
                "GRE": imejs.iqqi.GREEK,
                "ICE": imejs.iqqi.ICELANDIC,
                "DUT": imejs.iqqi.DUTCH,
                "HRV": imejs.iqqi.CROATIAN,
                "SRPC": imejs.iqqi.Serbian,//ά
                "SRP": imejs.iqqi.Serbian,//ά
                "ALB": imejs.iqqi.Albanian,//
                "MAC": imejs.iqqi.Macedonian,//
                "SLV": imejs.iqqi.Slovenian//˹
                //Romanian
                //
            }
    }
    host.config.curMode = Tools.MODE_LANGUAGE;
    host.screen = "1080P";

    host.browser = "presto";
    if (host.tv == false) {
        host.browser = host.tools.assertBrowserCore();
    }
    host.default_browser = "presto";

    host.native = host.native || new IQQINativeInterface();
    if (host.tv) {
        try {
            host.native.IQQINativeInitialize();
        }
        catch (ex) {
            host.logger.e("system", "window.onload", "show error when init iqqi system: " + ex, ex);
        }
    }

    host.initialized = true;
}

function startIQQI() {
    (!host.initialized) && initIQQI();
    try{
        pubActionVkbinvoke("1");
    } catch (ex) {
        DBG_ERROR(ex.message);
    }

	host.logger.i("invoke", "startIQQI", "iqqi is called by UI. ViewType is:" + this.viewType + " workType is:" + this.workType + " language is:" + this.curLang + " curMarket is:" + this.curMarket + " curAera is:" + this.curArea);

    host.config.IQQIInputName = this.InputName;
    host.config.curColorLanguage = this.curLang;
    host.config.market = this.curMarket;
    host.config.area = this.curArea;
    var languageCode = window.localStorage["iqqiLanguage"] || this.curLang || host.config.curLangArray[0];
    if (this.workType == "password") {
        host.config.curMode = Tools.MODE_PASSWORD;
        host.config.workType = "password";
        //var passwordLanguage = ["ENG","FRA","DEU","ITA","SPA","POR","CES","EST","LIT","LAV"];
        if(passwordLanguage.indexOf(languageCode) < 0)  {
            if(passwordLanguage.indexOf(this.curLang) < 0)  {
                this.curLang = "eng";
                languageCode = "eng";
            } else {
                languageCode = this.curLang;
            }

        }
        //host.config.PasswordLang = this.curLang;
    }
    else {
        host.config.curMode = Tools.MODE_LANGUAGE;
        host.config.workType = "text";
    }


    host.iqqi = host.iqqi || new IQQIMainPage(languageCode, host.config.curMode, this.value || "", this.position, this.min, this.max, this.maxLength, this.viewType || "text", this.workType || "text", host.config.IQQIInputName);
    if (host.lastWorkType != host.config.workType) {
        host.iqqi.buttonPanel.shiftMode = false;
        host.iqqi.buttonPanel.capsMode = false;
        host.lastWorkType = host.config.workType;
    }

    host.iqqi.buttonPanel.setLanAndMode(languageCode, host.config.curMode);
    host.iqqi.input.setAttribute(this.value || "", this.position, this.min, this.max, this.maxLength, this.viewType || "text", this.workType || "text");
    host.iqqi.input.setCallBack(this.callback);
    host.iqqi.curFocus = host.iqqi.buttonPanel;
    host.iqqi.input.html.children["0"].state = "normal";
    host.iqqi.buttonPanel.currentImagineRoot = "";
    host.iqqi.show();
    host.iqqi.inputTitle.show();
    host.iqqi.inputTitle.onNewLanguageSetted(this.InputName);
}


function changeIQQIShiftFunc(normalFlag, focusFlag, shiftMode, capsMode, language) {
    switch (language) {
        case "RUS"://
        case "DEU"://
        case "LAV"://ά
        case "EST"://ɳ
        case "DUT"://
            var iqqiShiftKey = $(".rus_shift_new12_shift_presto_1080P_normal");
            if(!!iqqiShiftKey && capsMode) {//iqqiShiftKey.length >= 1
                $(".rus_shift_new12_shift_presto_1080P_normal").addClass("rus_shift_new12_caps_presto_1080P_normal");
                $(".rus_shift_new12_shift_presto_1080P_normal").removeClass("rus_shift_new12_shift_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".rus_shift_new12_shift_presto_1080P_focus");
            if(!!iqqiShiftKey && capsMode) {
                $(".rus_shift_new12_shift_presto_1080P_focus").addClass("rus_shift_new12_caps_presto_1080P_focus");
                $(".rus_shift_new12_shift_presto_1080P_focus").removeClass("rus_shift_new12_shift_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".rus_shift_new12_normal_presto_1080P_normal");
            if(!!iqqiShiftKey && shiftMode) {
                $(".rus_shift_new12_normal_presto_1080P_normal").addClass("rus_shift_new12_shift_presto_1080P_normal");
                $(".rus_shift_new12_normal_presto_1080P_normal").removeClass("rus_shift_new12_normal_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".rus_shift_new12_normal_presto_1080P_focus");
            if(!!iqqiShiftKey && shiftMode) {
                $(".rus_shift_new12_normal_presto_1080P_focus").addClass("rus_shift_new12_shift_presto_1080P_focus");
                $(".rus_shift_new12_normal_presto_1080P_focus").removeClass("rus_shift_new12_normal_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".rus_shift_new12_caps_presto_1080P_normal");
            if(!!iqqiShiftKey && !shiftMode && !capsMode) {
                $(".rus_shift_new12_caps_presto_1080P_normal").addClass("rus_shift_new12_normal_presto_1080P_normal");
                $(".rus_shift_new12_caps_presto_1080P_normal").removeClass("rus_shift_new12_caps_presto_1080P_normal");
                $(".rus_shift_new12_shift_presto_1080P_normal").addClass("rus_shift_new12_normal_presto_1080P_normal");
                $(".rus_shift_new12_shift_presto_1080P_normal").removeClass("rus_shift_new12_shift_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".rus_shift_new12_caps_presto_1080P_focus");
            if(!!iqqiShiftKey && !shiftMode && !capsMode) {
                $(".rus_shift_new12_caps_presto_1080P_focus").addClass("rus_shift_new12_normal_presto_1080P_focus");
                $(".rus_shift_new12_caps_presto_1080P_focus").removeClass("rus_shift_new12_caps_presto_1080P_focus");
                $(".rus_shift_new12_shift_presto_1080P_focus").addClass("rus_shift_new12_normal_presto_1080P_focus");
                $(".rus_shift_new12_shift_presto_1080P_focus").removeClass("rus_shift_new12_shift_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            break;

        case "ITA"://
        case "SLV"://˹
        case "ICE"://
        case "GRE"://ϣ
        case "CHI":
        case "MYA":
            var iqqiShiftKey = $(".eng_shift_new_shift_presto_1080P_normal");//eng_shift_new_normal_presto_1080P_normal
            if(!!iqqiShiftKey && capsMode) {//iqqiShiftKey.length >= 1
                $(".eng_shift_new_shift_presto_1080P_normal").addClass("eng_shift_new_caps_presto_1080P_normal");
                $(".eng_shift_new_shift_presto_1080P_normal").removeClass("eng_shift_new_shift_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".eng_shift_new_shift_presto_1080P_focus");
            if(!!iqqiShiftKey && capsMode) {
                $(".eng_shift_new_shift_presto_1080P_focus").addClass("eng_shift_new_caps_presto_1080P_focus");
                $(".eng_shift_new_shift_presto_1080P_focus").removeClass("eng_shift_new_shift_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".eng_shift_new_normal_presto_1080P_normal");
            if(!!iqqiShiftKey && shiftMode) {
                $(".eng_shift_new_normal_presto_1080P_normal").addClass("eng_shift_new_shift_presto_1080P_normal");
                $(".eng_shift_new_normal_presto_1080P_normal").removeClass("eng_shift_new_normal_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".eng_shift_new_normal_presto_1080P_focus");
            if(!!iqqiShiftKey && shiftMode) {
                $(".eng_shift_new_normal_presto_1080P_focus").addClass("eng_shift_new_shift_presto_1080P_focus");
                $(".eng_shift_new_normal_presto_1080P_focus").removeClass("eng_shift_new_normal_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".eng_shift_new_caps_presto_1080P_normal");
            if(!!iqqiShiftKey && !shiftMode && !capsMode) {
                $(".eng_shift_new_caps_presto_1080P_normal").addClass("eng_shift_new_normal_presto_1080P_normal");
                $(".eng_shift_new_caps_presto_1080P_normal").removeClass("eng_shift_new_caps_presto_1080P_normal");
                $(".eng_shift_new_shift_presto_1080P_normal").addClass("eng_shift_new_normal_presto_1080P_normal");
                $(".eng_shift_new_shift_presto_1080P_normal").removeClass("eng_shift_new_shift_presto_1080P_normal");
                normalFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            var iqqiShiftKey = $(".eng_shift_new_caps_presto_1080P_focus");
            if(!!iqqiShiftKey && !shiftMode && !capsMode) {
                $(".eng_shift_new_caps_presto_1080P_focus").addClass("eng_shift_new_normal_presto_1080P_focus");
                $(".eng_shift_new_caps_presto_1080P_focus").removeClass("eng_shift_new_caps_presto_1080P_focus");
                $(".eng_shift_new_shift_presto_1080P_focus").addClass("eng_shift_new_normal_presto_1080P_focus");
                $(".eng_shift_new_shift_presto_1080P_focus").removeClass("eng_shift_new_shift_presto_1080P_focus");
                focusFlag = true;
                if (normalFlag && focusFlag) {
                    return;
                }
            }

            break;

        default :
            break;
    }


}

function shiftToShiftIQQI(language) {
    switch (language) {
        case "RUS"://
        case "DEU"://
        case "LAV"://ά
        case "EST"://ɳ
        case "DUT"://
            $(".rus_shift_new12_normal_presto_1080P_normal").addClass("rus_shift_new12_shift_presto_1080P_normal");
            $(".rus_shift_new12_normal_presto_1080P_normal").removeClass("rus_shift_new12_normal_presto_1080P_normal");
            $(".rus_shift_new12_normal_presto_1080P_focus").addClass("rus_shift_new12_shift_presto_1080P_focus");
            $(".rus_shift_new12_normal_presto_1080P_focus").removeClass("rus_shift_new12_normal_presto_1080P_focus");
            break;

        case "ITA"://
        case "SLV"://˹
        case "ICE"://
        case "GRE"://ϣ
        case "CHI":
        case "MYA":
            $(".eng_shift_new_normal_presto_1080P_normal").addClass("eng_shift_new_shift_presto_1080P_normal");
            $(".eng_shift_new_normal_presto_1080P_normal").removeClass("eng_shift_new_normal_presto_1080P_normal");
            $(".eng_shift_new_normal_presto_1080P_focus").addClass("eng_shift_new_shift_presto_1080P_focus");
            $(".eng_shift_new_normal_presto_1080P_focus").removeClass("eng_shift_new_normal_presto_1080P_focus");
            break;

        default :
            break;

    }

}

function shiftToCapsIQQI(language) {
    switch (language) {
        case "RUS"://
        case "DEU"://
        case "LAV"://ά
        case "EST"://ɳ
        case "DUT"://
            $(".rus_shift_new12_normal_presto_1080P_normal").addClass("rus_shift_new12_caps_presto_1080P_normal");
            $(".rus_shift_new12_normal_presto_1080P_normal").removeClass("rus_shift_new12_normal_presto_1080P_normal");
            $(".rus_shift_new12_normal_presto_1080P_focus").addClass("rus_shift_new12_caps_presto_1080P_focus");
            $(".rus_shift_new12_normal_presto_1080P_focus").removeClass("rus_shift_new12_normal_presto_1080P_focus");
            break;

        case "ITA"://
        case "SLV"://˹
        case "ICE"://
        case "GRE"://ϣ
        case "CHI":
        case "MYA":
            $(".eng_shift_new_normal_presto_1080P_normal").addClass("eng_shift_new_caps_presto_1080P_normal");
            $(".eng_shift_new_normal_presto_1080P_normal").removeClass("eng_shift_new_normal_presto_1080P_normal");
            $(".eng_shift_new_normal_presto_1080P_focus").addClass("eng_shift_new_caps_presto_1080P_focus");
            $(".eng_shift_new_normal_presto_1080P_focus").removeClass("eng_shift_new_normal_presto_1080P_focus");
            break;

        default :
            break;

    }
}

function initIQQIConstants() {
    host.constants = {};
    host.constants.MSG_REMOTE_NUMBER_KEY_EVENT = 0;
}
