/**
 * Created by liutiantian on 2015/2/3.
 */
var passwordLanguage = ["ENG", "FRA", "DEU", "ITA", "SPA", "POR", "CES", "EST", "LIT", "LAV", "GRE", "RUS", "SLV", "DUT", "ICE", "SLK", "HRV", "GRE", "HUN", "UKR", "MAC", "ALB", "SRPC", "SRP", "HEB", "UKR"];
var iqqiConfig = {
    "firstFocusId": ["FirstLineKey_0", "FirstLineKey_3"],
    "curLang": "ENG",
    "curImeType": -1,
    "curImeFirst": true,
    "curMode": Tools.MODE_LANGUAGE,
    "rows": ["FirstLineKey", "SecondLineKey", "ThirdLineKey", "FourthLineKey", "FifthLineKey", "ControlLineKey"],
    "charRows": ["FirstLineChar", "SecondLineChar", "ThirdLineChar", "FourthLineChar"],
    "ids": ["iqqi_button_panel_line1_btn", "iqqi_button_panel_line2_btn", "iqqi_button_panel_line3_btn", "iqqi_button_panel_line4_btn", "iqqi_button_panel_line_control_btn"],
    "curLangArray": ["ENG", "GER", "ITA", "POR", "SPA", "FRA", "NOR", "SWE", "DAN", "FIN", "NUM1", "NUM2", "GRE"],
    "curArea": "EU",
    "curSubArea": "",
    "lans": [
        {
            "number": 0,                                         // the language number decided by browser, may be changed from platform to platform, from version to version, fuck the tv.
            "name": "English",                                   // the language name, if no new translation, this remains unchangeable.
            "code": "ENG",                                       // ISO-639-2 T language code, never changed unless the world crashed.
            "first": true,                                      // whether this language's imagine area need to show the imagine root as the first element of imagine area.
            "market": ["SA", "NA", "EU"],                        // the market of which will need to show this language in iqqi, may be changed accordingly.
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],    // the area of which will need to show this language, this will only work when the market is EU, may be changed accordingly.
            "rtl": false,                                       // whether this language need to rtl layout, never changed unless the world crashed
            "shift": true                                       // whether this language has capital characters. never changed unless the world crashed
        },
        {
            "number": 2,
            "name": "Español",  //西班牙语
            "code": "SPA",
            "first": true,
            "market": ["SA", "NA", "EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 1,
            "name": "Français",  //法语
            "code": "FRA",
            "first": true,
            "market": ["NA", "EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 3,
            "name": "Português",  //葡萄牙语
            "code": "POR",
            "first": true,
            "market": ["SA", "EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 4,
            "name": "العربية",
            "code": "ARA",     //阿拉伯语
            "first": true,
            "market": ["EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": true,
            "shift": true
        },
        {
            "number": 5,
            "name": "русский",  //俄语
            "code": "RUS",
            "first": true,
            "market": ["EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 6,
            "name": "中文",
            "code": "CHI",
            "first": false,
            "market": ["EU"],
            "area": ["MiddleEast", "CIS", "Asian", "Africa"],
            "rtl": false,
            "shift": false
        },
        {
            "number": 7,
            "name": "Tiếng Việt",  //越南语
            "code": "VIE",
            "first": true,
            "area": ["Asian"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 8,
            "name": "ภาษาไทย",  //泰语
            "code": "THA",
            "first": true,
            "area": ["MiddleEast", "Asian"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 9,   //缅甸语
            "name": "မြန်မာ",
            "code": "MYA",
            "first": true,
            "area": ["Asian"],
            "rtl": false,
            "shift": false
        },
        {
            "number": 10,
            "name": "O'zbekiston‎",  //乌兹别克语
            "code": "UZB",
            "first": true,
            "market": ["EU"],
            "area": ["CIS"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 11,
            "name": "हिंदी",  //印地语
            "code": "HIN",
            "first": true,
            "market": ["EU"],
            "area": ["MiddleEast", "Asian", "Africa"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 12,
            "name": "український",  //乌克兰语
            "code": "UKR",
            "first": true,
            "market": ["EU"],
            "area": ["CIS"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 13,
            "name": "Bahasa Melayu",  //马来语
            "code": "MSA",
            "first": true,
            "area": ["Asian"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 14,
            "name": "עברית",  //希伯来语
            "code": "HEB",
            "first": true,
            "market": ["EU"],
            "area": ["CIS"],
            "rtl": true,
            "shift": false
        },
        {
            "number": 15,
            "name": "繁體中文",
            "code": "ZHO",
            "first": false,
            "area": ["Asian"],
            "rtl": false,
            "shift": false
        },
        {
            "number": 16,
            "name": "Deutsch",   //德语
            "code": "DEU",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 17,
            "name": "Italiano", //意大利语
            "code": "ITA",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 18,
            "name": "Svenska",  //瑞典语
            "code": "SWE",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 19,
            "name": "Dansk",   //丹麦语
            "code": "DAN",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 20,
            "name": "Suomi",  //芬兰语
            "code": "FIN",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 21,
            "name": "Norsk",  //挪威语
            "code": "NOR",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 22,
            "name": "Čeština",  //捷克语
            "code": "CES",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 23,
            "name": "Slovenčina",  //斯洛伐克语
            "code": "SLK",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 24,
            "name": "Polski",  //波兰语
            "code": "POL",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 25,
            "name": "Magyar",  //匈牙利语
            "code": "HUN",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 26,
            "name": "Български",
            "code": "BUL",  //保加利亚语
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 27,
            "name": "Türkçe",  //土耳其语
            "code": "TUR",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 28,
            "name": "فارسی‎",  //波斯语
            "code": "FAS",
            "first": true,
            "area": ["MiddleEast", "Africa"],
            "rtl": true,
            "shift": false
        },
        {
            "number": 29,
            "name": "Bhs Indonesia",  //印度尼西亚
            "code": "IND",
            "first": true,
            "area": ["Asian"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 30,
            "name": "Eesti",//爱沙尼亚语 爱思利亚语
            "code": "EST",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 31,
            "name": "Latviešu",//拉脱维亚语
            "code": "LAV",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 32,
            "name": "Lietuvių",//立陶宛语
            "code": "LIT",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 33,
            "name": "Slovenščina",//斯洛文尼亚语
            "code": "SLV",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 34,
            "name": "Nederlands",//荷兰语
            "code": "DUT",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 35,
            "name": "Icelandic",//冰岛语        //真不知道为啥要加连整机语言都没有的语言键盘
            "code": "ICE",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 41,
            "name": "Ελληνικά",//希腊语
            "code": "GRE",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 37,
            "name": "Hrvatski",//克罗地亚语
            "code": "HRV",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 38,
            "name": "Македонски",//马其顿语
            "code": "MAC",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 39,
            "name": "Shqiptar",//阿尔巴尼亚语
            "code": "ALB",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 40,
            "name": "Srpski-Ćirilica",//塞尔维亚语西里尔
            "code": "SRPC",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 42,
            "name": "Srpski-Latīna",//塞尔维亚语拉丁
            "code": "SRP",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 43,
            "name": "Հայերեն",//西亚美尼亚语
            "code": "ARM",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 44,
            "name": "Արեւելյան Հայերեն",//东亚美尼亚
            "code": "ARME",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 45,
            "name": "românesc",//罗马尼亚
            "code": "RUM",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        },
        {
            "number": 46,
            "name": "Kurdî",//库尔德语
            "code": "KUR",
            "first": true,
            "market": ["EU"],
            "rtl": false,
            "shift": true
        }
    ],
    "data": {
        "ENG": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "~"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "/", ",", "."],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "numbers": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"],
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "~"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "/", ",", "."],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "NUM1": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num_back_new"],
                        "SecondLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new"],
                        "ThirdLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new"],
                        "FourthLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new"],
                        "ControlLineKey": ["num_esc_num", "num_num_switch_num", "num_lan_switch_new", "num_white_new", "num1_center_side_new", "num_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["_", "&", "+", "1", "2", "3", "$", "~", ""],
                "SecondLineKey": ["\\", "^", "-", "4", "5", "6", "!", "\"", "'"],
                "ThirdLineKey": ["<", ">", "=", "7", "8", "9", "?", ";", ":"],
                "FourthLineKey": ["(", ")", "/", "*", "0", "#", "%", ",", "."],
                "ControlLineKey": ["", "1/2", "ABC", "", "@", "OK"]
            },
            "display": {
                "FirstLineKey": [4, 4, 4, 1, 1, 1, 4, 4, 9],
                "SecondLineKey": [4, 4, 4, 1, 1, 1, 4, 4, 4],
                "ThirdLineKey": [4, 4, 4, 1, 1, 1, 4, 4, 4],
                "FourthLineKey": [4, 4, 4, 4, 1, 4, 4, 4, 4],
                "ControlLineKey": [5, 7, 6, 8, 4, 10]
            },
            "FAS": {
                "content": {
                    "FirstLineKey": ["_", "&", "+", "1", "2", "3", "ومان", "#", "@"],
                    "SecondLineKey": ["\\", "^", "-", "4", "5", "6", "!", "\"", "'"],
                    "ThirdLineKey": ["<", ">", "*", "7", "8", "9", "؟", "،", "ـ"],
                    "FourthLineKey": ["(", ")", "/", "=", "0", "؛", "٪", "~", ":"],
                    "ControlLineKey": ["", "1/2", "ABC", "", "", "OK"]
                }
            }
        },
        "NUM2": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num_back_new"],
                        "SecondLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new"],
                        "ThirdLineKey": ["num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new", "num1_center_side_new"],
                        "FourthLineKey": [],
                        "ControlLineKey": ["num_esc_num", "num_num_switch_num", "num_lan_switch_new", "num_white_new", "num1_center_side_new", "num_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["§", "`", "|", "•", "√", "+", "÷", "×", ""],
                "SecondLineKey": ["¥", "£", "¢", "€", "[", "]", "{", "}", "№"],
                "ThirdLineKey": ["α", "β", "γ", "δ", "ε", "°", "™", "³", "®", "©"],
                "FourthLineKey": [],//"",, "", "℉"
                "ControlLineKey": ["", "2/2", "ABC", "", "@", "OK"]
            },
            "display": {
                "FirstLineKey": [4, 4, 4, 4, 4, 4, 4, 4, 9],
                "SecondLineKey": [4, 4, 4, 4, 4, 4, 4, 4, 4],
                "ThirdLineKey": [4, 4, 4, 4, 4, 4, 4, 4, 4],
                "FourthLineKey": [],
                "ControlLineKey": [5, 7, 6, 8, 4, 10]
            }
        },
        "FRA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["fra_shift", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4"],
                        "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "FourthLineKey": ["eng_shift_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", ".fr"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ":", ".com"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ";", "âãà"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side", "gl_510"],
                            "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "FourthLineKey": ["fra_shift", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4"],
                            "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                            "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ThirdLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "FourthLineKey": ["eng_shift_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", ".fr"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "/", ".com"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "?", ".", "ÂÃÀ"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 4, 4, 4, 14],//最后一个是AAA
                    "ControlLineKey": [5, 6, 7, 8, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 4, 4, 4, 14],//最后一个是AAA
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            },
            "char": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_char_panel_line", "iqqi_char_panel_line"],
                        "buttons": {
                            "FirstLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "SecondLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineChar": ["æ", "à", "á", "â", "ê", "ë"],
                    "SecondLineChar": ["ï", "ô", "œ", "ç", "é", "è"]
                },
                "upper": {
                    "content": {
                        "FirstLineChar": ["Æ", "À", "Á", "Â", "Ê", "Ë"],
                        "SecondLineChar": ["Ï", "Ô", "Œ", "Ç", "É", "È"]
                    }
                },
                "display": {
                    "FirstLineChar": [2, 2, 2, 2, 2, 2],
                    "SecondLineChar": [2, 2, 2, 2, 2, 2]
                }
            }
        },
        "SPA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "spa_white", "gl_511", "gl_511_side", "spa_back", "spa_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "ú", "-", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "ü", "¡", "!"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "í", "á", "¿", "?"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "é", "ñ", "ó", ",", "."],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                            "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                            "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                            "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "spa_shift_white", "gl_511", "gl_511", "gl_511_side", "spa_back", "spa_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13"],
                            "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                            "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                            "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                            "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13", "gl_510_new13", "spa_enter_new13"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "Ú", "_", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Ü", "+", "#"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Í", "Á", "/", "\\"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "É", "Ñ", "Ó", ";", ":"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 9],
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "ControlLineKey": [5, 6, 7, 8, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "POR": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift_new13", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "por_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "por_back_new"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["spa_shift_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["spa_esc_new", "spa_lan_switch_new", "spa_num_switch_new", "por_white_new", "gl_511_new", "por_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "´", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "`", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ç", "~", "?"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", "^", "/"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "´", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "`", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ç", "~", "!"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ";", ":", "^", "\\"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "ARA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line_ara", "iqqi_button_panel_line_ara", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow"],
                    "buttons": {
                        "FirstLineKey": ["ara_512_side", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512_side"],
                        "SecondLineKey": ["ara_512_side", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512", "ara_512_side"],
                        "FourthLineKey": ["ara_shift", "ara_511_side", "ara_511_side", "ara_511", "ara_511", "ara_511", "ara_511", "ara_511", "ara_511_side", "ara_511_side", "ara_511_side"],
                        "ControlLineKey": ["ara_esc", "ara_lan_switch", "ara_num_switch", "ara_white", "ara_back", "ara_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12small", "rus_white_new12", "gl_511_side_newtxtsmall", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],//"ذ", "ض", "ص", "ث", "ق", "ف", "غ", "ع", "خ", "ح", "ج", "د"
                "SecondLineKey": ["ذ", "ض", "ص", "ث", "ق", "ف", "غ", "ع", "خ", "ح", "ج", "د"],//"ش", "س", "ي", "ب", "ل", "ا", "ت", "ن", "م", "ك", "ط", "،"
                "ThirdLineKey": ["ش", "س", "ي", "ب", "ل", "ا", "ت", "ن", "م", "ك", "ط", "/"],
                "FourthLineKey": ["", "ئ", "ر", "لا", "ى", "ة", "ه", "و", "ز", "ظ", "،", "."],//"", "ئ", "ر", "لا", "ى", "ة", "ه", "و", "ز", "ظ", "."
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "numbers": ["٠", "١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩"],
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line_ara", "ara_center_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow"],
                        "buttons": {
                            "FirstLineKey": ["ara_510", "ara_510", "ara_510", "ara_510", "ara_510", "ara_510", "ara_510", "ara_510", "ara_510", "ara_510"],
                            "SecondLineKey": ["ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2", "ara_line2"],
                            "FourthLineKey": ["ara_shift", "ara_511_side", "ara_511_side", "ara_511", "ara_511", "ara_511", "ara_511", "ara_511", "ara_511_side", "ara_511_side", "ara_511_side"],
                            "ControlLineKey": ["ara_esc", "ara_lan_switch", "ara_num_switch", "ara_white", "ara_back", "ara_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_ara_narrow"],
                        "buttons": {
                            "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "rus_back_new12"],
                            "SecondLineKey": [],
                            "ThirdLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "FourthLineKey": ["eng_shift_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_newsmall", "eng_white_newara", "eng_narrow_new", "eng_narrow_new", "eng_enter_newsmall"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩", "٠", ""],
                    "SecondLineKey": [],
                    "ThirdLineKey": ["ّ", "َ", "ً", "ُ", "ٌ", "ِ", "ٍ", "ْ", "ـ", "؟", "،"],
                    "FourthLineKey": ["", "ء", "ؤ", "لأ", "لإ", "لآ", "أ", "إ", "آ", "؛", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                    "SecondLineKey": [],
                    "ThirdLineKey": [11, 11, 11, 11, 11, 11, 11, 11, 11, 4, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "RUS": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "rus_center_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["rus_esc", "rus_lan_switch", "rus_num_switch", "rus_white", "rus_back", "rus_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["й", "ц", "у", "к", "е", "н", "г", "ш", "щ", "з", "х", "ъ"],
                "ThirdLineKey": ["ф", "ы", "в", "а", "п", "р", "о", "л", "д", "ж", "э", "ё"],
                "FourthLineKey": ["", "я", "ч", "с", "м", "и", "т", "ь", "б", "ю", "/", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "_", ""],
                    "SecondLineKey": ["Й", "Ц", "У", "К", "Е", "Н", "Г", "Ш", "Щ", "З", "Х", "ъ"],
                    "ThirdLineKey": ["Ф", "Ы", "В", "А", "П", "Р", "О", "Л", "Д", "Ж", "Э", "Ё"],
                    "FourthLineKey": ["", "Я", "Ч", "С", "М", "И", "Т", "ь", "Б", "Ю", "?", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "FAS": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_513_side", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "FourthLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ControlLineKey": ["fas_esc", "fas_lan_switch", "fas_num_switch", "fas_white", "fas_back", "fas_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13big"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13smallC", "gl_510_new13", "gl_510_new13", "gl_510_new13small", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹", "۰", "-", ""],
                "SecondLineKey": ["ض", "ص", "ث", "ق", "ف", "غ", "ع", "ه", "خ", "ح", "ج", "چ", "/"],
                "ThirdLineKey": ["ش", "س", "ی", "ب", "ل", "آ", "ا", "ت", "ن", "م", "ک", "گ", "؟"],//"،"
                "FourthLineKey": ["ي", "ئ", "ظ", "ط", "ژ", "ز", "ر", "ذ", "د", "پ", "و", "،", "؛"],
                "ControlLineKey": ["", "", "123", "", ",", ";",".com", "@", "OK"]
            },
            "numbers": ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"],
            "display": {
                "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 4, 10]
            }
        },
        "HEB": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "eng_center_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3"],
                        "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "FourthLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "heb_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["׳", "ק", "ר", "א", "ט", "ו", "ן", "ם", "פ", "ף", "-"],
                "ThirdLineKey": ["ש", "ד", "ג", "כ", "ע", "י", "ח", "ל", "ך", ",", "/"],
                "FourthLineKey": ["ז", "ס", "ב", "ה", "נ", "מ", "צ", "ת", "ץ", ".", ".com"],
                "ControlLineKey":  ["", "", "123", "", "@", "OK"]
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "MSA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ",", ".", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "CHI": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ThirdLineKey": ["eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3"],
                        "FourthLineKey": ["eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3", "eng_line3"],
                        "ControlLineKey": ["eng_esc", "eng_lan_switch", "eng_num_switch", "chi_white", "eng_back", "eng_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new_normal", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "，", "。", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {//中文大写要求不调联想
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side", "gl_510"],
                            "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "FourthLineKey": ["fra_shift", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4"],
                            "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "gl_510"],
                            "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "FourthLineKey": ["eng_shift", "fra_shift_line4_side", "fra_shift_line4", "fra_shift_line4", "fra_shift_line4", "fra_shift_line4", "fra_shift_line4", "fra_shift_line4", "fra_shift_line4_side"],
                            "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ",", ".", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                    "SecondLineKey": [4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4],
                    "ThirdLineKey": [4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4],
                    "FourthLineKey": [3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4],
                    "ControlLineKey": [5, 6, 7, 8, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "ZHO": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["zho_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "zho_side"],
                        "SecondLineKey": ["zho_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "zho_side"],
                        "ThirdLineKey": ["zho_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "zho_side"],
                        "FourthLineKey": ["zho_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "zho_side"],
                        "ControlLineKey": ["zho_esc", "zho_lan_switch", "zho_num_switch", "zho_white", "gl_513", "zho_back", "zho_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_line3_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_newsmall", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_narrow_newtxtsmall","eng_narrow_new", "eng_enter_newsmall"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["ㄅ", "ㄉ", "ˇ", "ˋ", "ㄓ", "ˊ", "˙", "ㄚ", "ㄞ", "ㄢ", ""],
                "SecondLineKey": ["ㄆ", "ㄊ", "ㄍ", "ㄐ", "ㄔ", "ㄗ", "一", "ㄛ", "ㄟ", "ㄣ", "ㄦ "],
                "ThirdLineKey": ["ㄇ", "ㄋ", "ㄎ", "ㄑ", "ㄕ", "ㄘ", "ㄨ", "ㄜ", "ㄠ", "ㄤ", "-"],
                "FourthLineKey": ["ㄈ", "ㄌ", "ㄏ", "ㄒ", "ㄖ", "ㄙ", "ㄩ", "ㄝ", "ㄡ", "ㄥ", "/"],
                "ControlLineKey": ["", "", "123", "", ",","。", ".com", "@", "OK"]
            },
            "display": {
                "FirstLineKey": [2, 2, 11, 11, 2, 11, 11, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 4, 10]
            }
        },
        "THA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "tha_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line_narrow"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12smallB", "gl_511_side_newtxtsmall", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["ๅ", "ๆ", "ภ", "ถ", "ุ", "ึ", "ค", "ต", "จ", "ข", "ช", ""],
                "SecondLineKey": ["ไ", "ำ", "พ", "ะ", "ั", "ี", "ร", "น", "ย", "บ", "ล", "-"],
                "ThirdLineKey": ["ฟ", "ห", "ก", "ด", "เ", "้", "่", "า", "ส", "ว", "ง", "/"],
                "FourthLineKey": ["", "ผ", "ป", "แ", "อ", "ิ", "ื", "ท", "ม", "ใ", "ฝ", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "numbers": ["๐", "๑", "๒", "๓", "๔", "๕", "๖", "๗", "๘", "๙"],
            "display": {
                "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            },
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side"],
                            "SecondLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "FourthLineKey": ["tha_shift", "tha_508_side", "tha_508_side", "gl_510", "gl_510", "tha_508", "tha_508", "tha_508", "gl_510"],
                            "ControlLineKey": ["tha_esc", "tha_lan_switch", "tha_num_switch", "tha_shift_white", "tha_back", "tha_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                            "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ThirdLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "FourthLineKey": ["eng_shift_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_enter_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["๑", "๒", "๓", "๔", "ู", "๕", "๖", "๗", "๘", "๙", ""],
                    "SecondLineKey": ["๐", "ฎ", "ฑ", "ธ", "ํ", "๊", "ณ", "ฯ", "ญ", "ฐ", "-"],
                    "ThirdLineKey": ["ฤ", "ฆ", "ฏ", "โ", "ฌ", "็", "๋", "ษ", "ศ", "ซ", "/"],
                    "FourthLineKey": ["", "ฉ", "ฮ", "ฺ", "์", "ฒ", "ฬ", "ฦ", "฿", ".", ".com"],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
                }
            }
        },
        "UKR": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["ukr_shift", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ControlLineKey": ["ukr_esc", "ukr_lan_switch", "ukr_num_switch", "ukr_white", "ukr_back", "ukr_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12small", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["й", "ц", "у", "к", "е", "н", "г", "ш", "щ", "з", "х", "ї"],
                "ThirdLineKey": ["ф", "і", "в", "а", "п", "р", "о", "л", "д", "ж", "є", "/"],
                "FourthLineKey": ["", "ґ", "я", "ч", "с", "м", "и", "т", "ь", "б", "ю", ".com"],
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Й", "Ц", "У", "К", "Е", "Н", "Г", "Ш", "Щ", "З", "Х", "Ї"],
                    "ThirdLineKey": ["Ф", "І", "В", "А", "П", "Р", "О", "Л", "Д", "Ж", "Є", "/"],
                    "FourthLineKey": ["", "Ґ", "Я", "Ч", "С", "М", "И", "Т", "Ь", "Б", "Ю", ".com"],
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "TUR": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "tha_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_newtxtsmall"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12smallB", "gl_511_side_newtxtsmall", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "ı", "o", "p", "ğ", "ü"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ş", "i", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "ö", "ç", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Ğ", "Ü"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ş", "İ", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "Ö", "Ç", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "SWE": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["rus_esc", "rus_lan_switch", "rus_num_switch", "swe_white", "rus_back", "rus_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_enter_newsmall"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "å"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ö", "ä"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "-", ",", "."],
                "ControlLineKey": ["", "", "123", "", "/", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Å"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ö", "Ä"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "-", ",", "."],
                    "ControlLineKey": ["", "", "123", "","/", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey":  [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "SLK": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": [";", "+", "ľ", "š", "č", "ť", "ž", "ý", "á", "í", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", ".com"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "/", ".sk"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", "âãà"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", ".com"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "\\", ".sk"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "?", ":", "ÂÃÀ"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 14],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            },
            "char": {
                "csses": {
                    "1080P": {
                        "lines": ["iqqi_char_panel_line", "iqqi_char_panel_line"],
                        "buttons": {
                            "FirstLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "SecondLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineChar": ["á", "č", "í", "ľ"],
                    "SecondLineChar": ["š", "ť", "ý", "ž"]
                },
                "upper": {
                    "content": {
                        "FirstLineChar": ["Á", "Č", "Í", "Ľ"],
                        "SecondLineChar": ["Š", "Ť", "Ý", "Ž"]
                    }
                },
                "display": {
                    "FirstLineChar": [4, 4, 4, 4],
                    "SecondLineChar": [4, 4, 4, 4]
                }
            }
        },
        "POL": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13big"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13smallB", "gl_510_new13small", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "ż", "ś", "ó"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ł", "ń", "ć", "ź"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "ą", "ę", "/", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Ż", "Ś", "Ó"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ł", "Ń", "Ć", "Ź"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "Ą", "Ę", "/", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "VIE": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ",", ".", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "NOR": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_enter_newsmall"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "å"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ø", "æ"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "-", ",", "."],
                "ControlLineKey": ["", "", "123", "", "/", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Å"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ø", "Æ"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "-", ",", "."],
                    "ControlLineKey": ["", "", "123", "", "/", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "ITA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_shift_new_normal"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", ".it"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "#", ".com"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", ".it"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "#", ".com"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ";", ":", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "IND": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ",", ".", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "HUN": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "SecondLineKey": ["gl_513_side", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13big"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13small"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13small", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],//,, "ó"
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "í", "ö", "ü"],//"ő", "ú", "ű"
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ő", "ú", "ű", "ó"],//"é", "á"
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "é", "á", "\"", "/", ".com"],// "í",
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],// "Ö", "Ü", "Ó"
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Í", "Ö", "Ü"],// "Ő", "Ú", "Ű"
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ő", "Ú", "Ű", "Ó"],//"É", "Á"
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "É", "Á", "\"", "/", ".com"],// "Í"
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "HIN": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "FourthLineKey": ["rus_shift", "tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13big"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13small"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13small", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["ॊ", "१", "२", "३", "४", "५", "६", "७", "८", "९", "०", ""],
                "SecondLineKey": ["ौ", "ै", "ा", "ी", "ू", "ब", "ह", "ग", "द", "ज", "ड", "़", "-"],
                "ThirdLineKey": ["ो", "े", "्", "ि", "ु", "प", "र", "क", "त", "च", "ट", "|", "/"],
                "FourthLineKey": ["", "ॆ", "ं", "म", "न", "व", "ल", "स", "य", "ृ", "़", ";", ".com"],
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["ऒ", "ऍ", "ॅ", "्र", "र्", "ज्ञ", "त्र", "क्ष", "श्र", "ः", "|", ""],
                    "SecondLineKey": ["औ", "ऐ", "आ", "ई", "ऊ", "भ", "ङ", "घ", "ध", "झ", "ढ", "ऑ", "-"],
                    "ThirdLineKey": ["ओ", "ए", "अ", "इ", "उ", "फ", "ऱ", "ख", "थ", "छ", "ठ", "ष", "/"],
                    "FourthLineKey": ["", "ऎ", "ँ", "ण", "ऩ", "ऴ", "ळ", "श", "य़", "ऋ", "ञ", ";", ".com"],
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 9],
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "FourthLineKey":[3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "DEU": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["rus_esc", "rus_lan_switch", "rus_num_switch", "rus_white", "rus_back", "rus_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "ß", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "ü", ".de"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ö", "ä", "/"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", "-", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "ß", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Ü", ".de"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ö", "Ä", "\\"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", ";", ":", "_", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "FIN": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_enter_newsmall"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "å"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ö", "ä"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "-", "/", ".com"],
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Å"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ö", "Ä"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "-", "/", ".com"],
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "DAN": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_enter_newsmall"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "å"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "æ", "ø"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "-", ",", "."],
                "ControlLineKey": ["", "", "123", "", "/", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Å"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Æ", "Ø"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "-", ",", "."],
                    "ControlLineKey": ["", "", "123", "", "/", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "CES": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["fra_shift", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4"],
                        "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": [";", "ě", "š", "č", "ř", "ž", "ý", "á", "í", "é", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", ".com"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "/", ".cz"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", "âãà"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["tha_511_side", "tha_511_side", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511", "tha_511_side", "gl_510"],
                            "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "FourthLineKey": ["fra_shift", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4", "fra_line4"],
                            "ControlLineKey": ["fra_esc", "fra_lan_switch", "fra_num_switch", "fra_white", "fra_back", "fra_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                            "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                            "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                            "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", ".com"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "#", ".cz"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "?", ":", "ÂÃÀ"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],//这里实现有点问题，大小写对应数字、字母，是否联想，有问题
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 14],//最后一个是AAA
                    "ControlLineKey": [5, 6, 7, 8, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 14],//最后一个是AAA
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            },
            "char": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_char_panel_line", "iqqi_char_panel_line"],
                        "buttons": {
                            "FirstLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "SecondLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineChar": ["ě", "š", "č", "ř", "ž"],
                    "SecondLineChar": ["ý", "á", "í", "é", "ů"]
                },
                "upper": {
                    "content": {
                        "FirstLineChar": ["Ě", "Š", "Č", "Ř", "Ž"],
                        "SecondLineChar": ["Ý", "Á", "Í", "É", "Ů"]
                    }
                },
                "display": {
                    "FirstLineChar": [2, 2, 2, 2, 2],
                    "SecondLineChar": [2, 2, 2, 2, 2]
                }
            }
        },
        "BUL": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["ukr_shift", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ControlLineKey": ["ukr_esc", "ukr_lan_switch", "ukr_num_switch", "ukr_white", "ukr_back", "ukr_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12big"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_newtxtsmall"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12small", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["у", "е", "и", "ш", "щ", "к", "с", "д", "з", "ц", "-", ";"],
                "ThirdLineKey": ["ь", "я", "а", "о", "ж", "г", "т", "н", "в", "м", "ч", "/"],
                "FourthLineKey": ["", "ю", "й", "ъ", "э", "ф", "х", "п", "р", "л", "б", ".com"],
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["У", "Е", "И", "Ш", "Щ", "К", "С", "Д", "З", "Ц", "-", ";"],
                    "ThirdLineKey": ["Ь", "Я", "А", "О", "Ж", "Г", "Т", "Н", "В", "М", "Ч", "/"],
                    "FourthLineKey": ["", "Ю", "Й", "Ъ", "Э", "Ф", "Х", "П", "Р", "Л", "Б", ".com"],
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "MYA": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new_normal", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_newsmall", "eng_white_new", "eng_narrow_newtxtsmall", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["၁", "၂", "၃", "၄", "၅", "၆", "၇", "၈", "၉", "၀", ""],
                "SecondLineKey": ["ဆ", "တ", "န", "မ", "အ", "ပ", "က", "င", "သ", "စ", "-"],
                "ThirdLineKey": ["ေ", "ျ", "ိ", "်", "ါ", "့", "ြ",  "ု", "ူ", "း", "/"],
                "FourthLineKey": ["", "ဖ", "ထ", "ခ",  "လ", "ဘ", "ည", "ာ", "္", "၊", "။"],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "numbers": ["၀", "၁", "၂", "၃", "၄", "၅", "၆", "၇", "၈", "၉"],
            "upper": {
                "content": {
                    "FirstLineKey": ["ဎ", "ဍ", "ဋ", "ရ", "ဏ", "ဧ", "ဟ", "ဩ", "ဪ", "၏", ""],
                    "SecondLineKey": ["ဈ", "ဝ", "ဣ", "၎", "ဤ", "၌", "ဥ", "၍", "ႊ", "၊", "။"],
                    "ThirdLineKey": ["ဗ", "ှ", "ီ", "္", "ွ", "ံ", "ဲ", "ဒ", "ဓ", "ဂ", "-"],
                    "FourthLineKey": ["", "ဇ", "ဌ", "ဃ", "ဠ", "ယ", "ဉ", "ဦ", "ၤ", "ၥ", "/"],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                    "SecondLineKey": [2, 2, 2, 4, 2, 4, 2, 4, 2, 4, 4],
                    "ThirdLineKey": [2, 4, 4, 4, 4, 4, 4, 2, 2, 2, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2],
                    "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 4, 2, 4, 2, 4, 2, 4, 4],
                "ThirdLineKey": [2, 4, 4, 4, 4, 4, 4, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "UZB": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", ";"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "'", "-"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "/", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", ";"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "'", "-"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "/", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "EST": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["eng_esc", "eng_lan_switch", "eng_num_switch", "eng_white", "eng_back", "eng_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "ü", "õ"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ö", "ä", "'"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", "-", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                            "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                            "ThirdLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                            "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                            "ControlLineKey": ["eng_esc", "eng_lan_switch", "eng_num_switch", "eng_white", "eng_back", "eng_enter"]
                        }
                    },
                    "1080P": {
                        "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                        "buttons": {
                            "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                            "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                            "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                            "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                            "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                        }
                    }
                },
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Ü", "Õ"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ö", "Ä", "'"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "?", ":", "_", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                },
                "display": {
                    "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 9],
                    "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                    "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                    "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 3],
                    "ControlLineKey": [5, 6, 7, 8, 4, 10]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "LAV": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_513_side", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ThirdLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "f", ""],
                "SecondLineKey": ["ū", "g", "j", "r", "m", "v", "n", "z", "ē", "č", "ž", "h"],
                "ThirdLineKey": ["š", "u", "s", "i", "l", "d", "a", "t", "e", "c", "'", "ķ"],
                "FourthLineKey": ["", "ģ", "ņ", "b", "ī", "k", "p", "o", "ā", "ļ", ",", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "F", ""],
                    "SecondLineKey": ["Ū", "G", "J", "R", "M", "V", "N", "Z", "Ē", "Č", "Ž", "H"],
                    "ThirdLineKey": ["Š", "U", "S", "I", "L", "D", "A", "T", "E", "C", "°", "Ķ"],
                    "FourthLineKey": ["", "Ģ", "Ņ", "B", "Ī", "K", "P", "O", "Ā", "Ļ", ".", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "LIT": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "/"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "'"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", "âãà"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "?"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ":", "\""],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "<", ">", "ÂÃÀ"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 14],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            },
            "char": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_char_panel_line", "iqqi_char_panel_line"],
                        "buttons": {
                            "FirstLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                            "SecondLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineChar": ["ą", "č", "ę", "ė", "į"],
                    "SecondLineChar": ["š", "ų", "ū", "ž"]
                },
                "upper": {
                    "content": {
                        "FirstLineChar": ["Ą", "Č", "Ę", "Ė", "Į"],
                        "SecondLineChar": ["Š", "Ų", "Ū", "Ž"]
                    }
                },
                "display": {
                    "FirstLineChar": [2, 2, 2, 2, 2],
                    "SecondLineChar": [2, 2, 2, 2]
                }
            }
        },
        "SLV": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_shift_new_normal"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "š"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "č", "ž"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Š"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Č", "Ž"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "?", ":", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "DUT": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["rus_shift", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "ControlLineKey": ["rus_esc", "rus_lan_switch", "rus_num_switch", "rus_white", "rus_back", "rus_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_shift_new12_normal"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "-", ".nl"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "_", ".com"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", "#", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "!", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "=", ".nl"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", ":", "(", ".com"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "<", ">", "(", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "ICE": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_shift_new_normal"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "đ"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "æ"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ""],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Đ"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Æ"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "?", ":", ""],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 3],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "GRE": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": [";", "ς", "ε", "ρ", "τ", "υ", "θ", "ι", "ο", "π", "-"],
                "ThirdLineKey": ["α", "σ", "δ", "φ", "γ", "η", "ξ", "κ", "λ", "΄", "~"],
                "FourthLineKey": ["", "ζ", "χ", "ψ", "ω", "β", "ν", "μ", ",", ".", "/"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": [":", "#", "Ε", "Ρ", "Τ", "Υ", "Θ", "Ι", "Ο", "Π", "-"],
                    "ThirdLineKey": ["Α", "Σ", "Δ", "Φ", "Γ", "Η", "Ξ", "Κ", "Λ", "'", "~"],
                    "FourthLineKey": ["", "Ζ", "Χ", "Ψ", "Ω", "Β", "Ν", "Μ", ",", ".", "/"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "HRV": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", ".hr"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "/", ".com"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", "âãà"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", ".hr"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "\\", ".com"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "?", ":", "ÂÃÀ"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 14],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            },
            "char": {
                "csses": {
                    "720P": {
                        "lines": ["iqqi_char_panel_line"],
                        "buttons": {
                            "FirstLineChar": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"]
                        }
                    }
                },
                "content": {
                    "FirstLineChar": ["š", "đ", "č", "ć", "ž"]
                },
                "upper": {
                    "content": {
                        "FirstLineChar": ["Š", "Đ", "Č", "Ć", "Ž"]
                    }
                },
                "display": {
                    "FirstLineChar": [2, 2, 2, 2, 2]
                }
            }
        },
        "MAC": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["ukr_shift", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ControlLineKey": ["ukr_esc", "ukr_lan_switch", "ukr_num_switch", "ukr_white", "ukr_back", "ukr_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12small", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["ѝ", "љ", "њ", "е", "р", "т", "ѕ", "у", "и", "о", "п", "ш"],
                "ThirdLineKey": ["а", "с", "д", "ф", "г", "х", "ј", "к", "л", "ч", "ѓ", "ж"],
                "FourthLineKey": ["", "ѐ", "з", "џ", "ц", "в", "б", "н", "м", "/", "ќ", ".com"],
                "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Ѝ", "Љ", "Њ", "Е", "Р", "Т", "Ѕ", "У", "И", "О", "П", "Ш"],
                    "ThirdLineKey": ["А", "С", "Д", "Ф", "Г", "Х", "Ј", "К", "Л", "Ч", "Ѓ", "Ж"],
                    "FourthLineKey": ["", "Ѐ", "З", "Џ", "Ц", "В", "Б", "Н", "М", "/", "Ќ", ".com"],
                    "ControlLineKey": ["", "", "123", "", ",", ".", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 4, 10]
            }
        },
        "ALB": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["pol_esc", "pol_lan_switch", "pol_num_switch", "pol_white", "rus_back", "pol_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "eng_back_new"],
                        "SecondLineKey": ["gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new", "gl_510_new"],
                        "ThirdLineKey": ["eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new", "eng_line3_new"],
                        "FourthLineKey": ["eng_shift_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new", "eng_narrow_new"],
                        "ControlLineKey": ["eng_esc_new", "eng_lan_switch_new", "eng_num_switch_new", "eng_white_newsmall", "eng_narrow_new", "eng_narrow_new", "eng_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "č"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ë", "-"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", "/", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "O", "P", "Č"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ë", "-"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", "/", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "SRPC": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["ukr_shift", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ControlLineKey": ["ukr_esc", "ukr_lan_switch", "ukr_num_switch", "ukr_white", "ukr_back", "ukr_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_newtxtsmall"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["љ", "њ", "е", "р", "т", "з", "у", "и", "о", "п", "ш", "ђ"],
                "ThirdLineKey": ["а", "с", "д", "ф", "г", "х", "ј", "к", "л", "ч", "ћ", "ж"],
                "FourthLineKey": ["", "ѕ", "џ", "ц", "в", "б", "н", "м", ",", ".", "/", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Љ", "Њ", "Е", "Р", "Т", "З", "У", "И", "О", "П", "Ш", "Ђ"],
                    "ThirdLineKey": ["А", "С", "Д", "Ф", "Г", "Х", "Ј", "К", "Л", "Ч", "Ћ", "Ж"],
                    "FourthLineKey": ["", "Ѕ", "Џ", "Ц", "В", "Б", "Н", "М", ",", ".", "/", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "SRP": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["ukr_shift", "gl_513_side", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513", "gl_513_side", "gl_513_side"],
                        "ControlLineKey": ["ukr_esc", "ukr_lan_switch", "ukr_num_switch", "ukr_white", "ukr_back", "ukr_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_newtxtsmall"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "z", "u", "i", "o", "p", "š", "đ"],
                "ThirdLineKey": ["а", "s", "d", "f", "g", "h", "j", "k", "l", "č", "ć", "ž"],
                "FourthLineKey": ["", "y", "x", "c", "v", "b", "n", "m", ",", ".", "/", ".com"],
                "ControlLineKey": ["", "", "123", "", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Z", "U", "I", "О", "P", "Š", "Đ"],
                    "ThirdLineKey": ["А", "S", "D", "F", "G", "H", "Ј", "К", "L", "Č", "Ć", "Ž"],
                    "FourthLineKey": ["", "Y", "X", "C", "V", "B", "N", "M", ",", ".", "/", ".com"],
                    "ControlLineKey": ["", "", "123", "", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 10]
            }
        },
        "RUM": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "SecondLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ThirdLineKey": ["gl_511_side", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "FourthLineKey": ["spa_shift_new13", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "por_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12big"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["spa_shift_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ControlLineKey": ["spa_esc_new", "spa_lan_switch_new", "spa_num_switch_new", "rus_white_new12smallB", "gl_511_new", "gl_511_new", "por_enter_new"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "ă", "-"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "î", "â", "/"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", "ș", "ț", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Ă", "-"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Î", "Â", "/"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", "Ș", "Ț", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "ARM": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13smallB", "gl_510_new13small", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["՝", "՜", ":", "ձ", "յ", "՛", "և", "«", "»", "օ", "ռ", "ժ", ""],
                "SecondLineKey": ["խ", "վ", "է", "ր", "դ", "ե", "ը", "ի", "ո", "բ", "չ", "ջ", "-"],
                "ThirdLineKey": ["ա", "ս", "տ", "ֆ", "կ", "հ", "ճ", "ք", "լ", "թ", "փ", "՞", "/"],
                "FourthLineKey": ["", "զ", "ց", "գ", "ւ", "պ", "ն", "մ", "շ", "ղ", "ծ", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["՝", "՜", ":", "Ձ", "Յ", "՛", "և", "«", "»", "Օ", "Ռ", "Ժ", ""],
                    "SecondLineKey": ["Խ", "Վ", "Է", "Ր", "Դ", "Ե", "Ը", "Ի", "Ո", "Բ", "Չ", "Ջ", "-"],
                    "ThirdLineKey": ["Ա", "Ս", "Տ", "Ֆ", "Կ", "Հ", "Ճ", "Ք", "Լ", "Թ", "Փ", "՞", "/"],
                    "FourthLineKey": ["", "Զ", "Ց", "Գ", "Ւ", "Պ", "Ն", "Մ", "Շ", "Ղ", "Ծ", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [4, 4, 4, 2, 2, 4, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "ARME": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "spa_back_new13"],
                        "SecondLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ThirdLineKey": ["gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "FourthLineKey": ["spa_shift_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13", "gl_510_new13"],
                        "ControlLineKey": ["spa_esc_new13", "spa_lan_switch_new13", "spa_num_switch_new13", "spa_white_new13smallB", "gl_510_new13small", "gl_510_new13", "spa_enter_new13"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["՝", "՜", ":", "ձ", "յ", "՛", "և", "«", "»", "օ", "ռ", "ժ", ""],
                "SecondLineKey": ["խ", "ւ", "է", "ր", "տ", "ե", "ը", "ի", "ո", "պ", "չ", "ջ", "-"],
                "ThirdLineKey": ["ա", "ս", "դ", "ֆ", "ք", "հ", "ճ", "կ", "լ", "թ", "փ", "՞", "/"],
                "FourthLineKey": ["", "զ", "ց", "գ", "վ", "բ", "ն", "մ", "շ", "ղ", "ծ", ",", "."],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["՝", "՜", ":", "Ձ", "Յ", "՛", "և", "«", "»", "Օ", "Ռ", "Ժ", ""],
                    "SecondLineKey": ["Խ", "Ւ", "Է", "Ր", "Տ", "Ե", "Ը", "Ի", "Ո", "Ո", "Չ", "Ջ", "-"],
                    "ThirdLineKey": ["Ա", "Ս", "Դ", "Ֆ", "Ք", "Հ", "Ճ", "Կ", "Լ", "Թ", "Փ", "՞", "/"],
                    "FourthLineKey": ["", "Զ", "Ց", "Գ", "Վ", "Բ", "Ն", "Մ", "Շ", "Ղ", "Ծ", ",", "."],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [4, 4, 4, 2, 2, 4, 2, 2, 2, 2, 2, 2, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        },
        "KUR": {
            "csses": {
                "720P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510", "gl_510"],
                        "SecondLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "ThirdLineKey": ["gl_512_side", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512", "gl_512_side"],
                        "FourthLineKey": ["spa_shift", "gl_511_side", "gl_511_side", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511", "gl_511_side", "gl_511_side", "gl_511_side"],
                        "ControlLineKey": ["spa_esc", "spa_lan_switch", "spa_num_switch", "tha_white", "por_back", "por_enter"]
                    }
                },
                "1080P": {
                    "lines": ["iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line", "iqqi_button_panel_line_btn_gone", "iqqi_button_panel_line"],
                    "buttons": {
                        "FirstLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "rus_back_new12"],
                        "SecondLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "ThirdLineKey": ["gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new"],
                        "FourthLineKey": ["rus_shift_new12", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_new", "gl_511_side_newtxtsmall"],
                        "ControlLineKey": ["rus_esc_new12", "rus_lan_switch_new12", "rus_num_switch_new12", "rus_white_new12smallB", "gl_511_side_newtxtsmall", "gl_511_side_new", "rus_enter_new12"]
                    }
                }
            },
            "content": {
                "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                "SecondLineKey": ["q", "w", "e", "r", "t", "y", "u", "ı", "o", "p", "ê", "î"],
                "ThirdLineKey": ["a", "s", "d", "f", "g", "h", "j", "k", "l", "ç", "ş", "û"],
                "FourthLineKey": ["", "z", "x", "c", "v", "b", "n", "m", ",", ".", ";", "/"],
                "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
            },
            "upper": {
                "content": {
                    "FirstLineKey": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", ""],
                    "SecondLineKey": ["Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "Ê", "Î"],
                    "ThirdLineKey": ["A", "S", "D", "F", "G", "H", "J", "K", "L", "Ç", "Ş", "Û"],
                    "FourthLineKey": ["", "Z", "X", "C", "V", "B", "N", "M", ",", ".", ";", "/"],
                    "ControlLineKey": ["", "", "123", "", ".com", "@", "OK"]
                }
            },
            "display": {
                "FirstLineKey": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 9],
                "SecondLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "ThirdLineKey": [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
                "FourthLineKey": [3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4],
                "ControlLineKey": [5, 6, 7, 8, 4, 4, 10]
            }
        }
    },
    "csses": {
        "webkit": {
            "iqqi_main_page": {
                "exclude": ["hidden"]
            },
            "iqqi_app_area_text": {
                "exclude": ["hidden"]
            },
            "iqqi_imagine_content": {
                "exclude": ["hidden"]
            },
            "iqqi_imagine_content_item": {},
            "iqqi_lan_switch_page": {
                "exclude": ["hidden"]
            }
        }
    },
    "currentImagineRoot": "",
    "isShiftMode": false,
    "isCapsMode": false,
    "myaPageNum": undefined,
    "shouldUseCaps": false,
    "needRewrite": true,
    "imagineUl": null,
    "IQQINative": null,
    "InputManager": null,
    "IQQIConfig": null,
    "IQQIUtils": null,
    "IQQIInputName": "Please Input: "
};

var iqqi_imagine_test_data = [
    "c",
    "can",
    "could",
    "children",
    "come",
    "case",
    "course",
    "change",
    "care",
    "country",
    "company",
    "control",
    "community",
    "current",
    "countries",
    "call",
    "came",
    "cannot",
    "child",
    "cost",
    "class",
    "companies",
    "changes",
    "common",
    "certain",
    "clear"
];

var iqqi_imagine_test_data_y = [
    "y",
    "you",
    "your",
    "years",
    "year",
    "York",
    "york",
    "yet",
    "young",
    "yourself",
    "yes",
    "youth",
    "yesterday",
    "younger",
    "yeah",
    "yellow",
    "yahoo",
    "yield",
    "yours",
    "yards",
    "yard"
];
