/**
 * Created by liutiantian on 2015.12.23.
 */

var ltt = ltt || {};
ltt.api = ltt.api || {};
ltt.api.js = ltt.api.js || {};
ltt.api.js.util = ltt.api.js.util || {};

ltt.api.js.util.Cache = function(name, capacity) {
    this.name = name;
    this.capacity = capacity;

    this.keys = [];
    this.values = {};

    if(ltt.api.js.util.Cache.initialized == undefined) {
        ltt.api.js.util.Cache.prototype.cache = function(key, value) {
            if(this.keys.indexOf(key) == -1 && this.keys.length >= this.capacity) {
                delete this.values[this.keys.unshift(0)];
                this.keys.push(key);
            }
            else if(this.keys.length < this.capacity) {
                this.keys.push(key);
            }
            this.values[key] = value;
        };

        ltt.api.js.util.Cache.prototype.get = function(key) {
            return this.values[key];
        };

        ltt.api.js.util.Cache.prototype.containsKey = function(key) {
            return this.values && Object.keys(this.values).indexOf(key) > -1;
        };

        ltt.api.js.util.Cache.initialized = true;
    }
};
