DBG_INFO("Util.js start " + new Date().getTime());
var BigList = {};

/*
 {
 template : "0001",
 direction : CONST.GIRD_DIRECTION.H,
 distance : 30,
 container : launcher,
 pageCount : 6,
 scrollBar : true,
 scrollBarOffset : 10;
 }
 */
BigList.create = function(data, info, refreshAddPropertyFlag, noUpdate) {
    var sourceList = [];
    info.container.alpha = 0;
    var templatePath = "templates/" + info.template + ".json";
    var template = Util.readJson(templatePath);
    info.container.initSequence = [];
    info.container.position.x = info.container.initPos.x;
    info.container.position.y = info.container.initPos.y;
    var itemCount = Math.min(data.length, info.pageCount + 2);
    for (var i = 0; i < itemCount; i++) {
        var item = null;
        if (data[i].template && data[i].template != templatePath) {
            var itemTemplate = Util.readJson("templates/" + data[i].template + ".json");
            item = SubModule.setup(itemTemplate, data[i], i, sourceList).children[0];
        } else {
            item = SubModule.setup(template, data[i], i, sourceList).children[0];
        }

        var itemBounds = item.getBounds();
        item.pivot.x = itemBounds.width / 2;
        item.pivot.y = itemBounds.height / 2;
        if (info.direction == CONST.GIRD_DIRECTION.H) {
            item.position.x = (itemBounds.width + info.distance) * i + itemBounds.width / 2;
            item.position.y = itemBounds.height / 2;
        } else {
            item.position.x = itemBounds.width / 2;
            item.position.y = (itemBounds.height + info.distance) * i + itemBounds.height / 2;
        }
        info.container.addChild(item);
        info.container.initSequence.push(item);
    }
    if(refreshAddPropertyFlag){
        info.container.refreshAddPropertyFlag=true;
    }
    info.container.template = template;
    info.container.info = info;
    info.container.data = data;
    info.container.alpha = 1;
    info.container.currIndex = 0;
    info.container.posCount = 0;
    info.container.posType = 0;

    info.container.refreshNav = function() {
        if (info.direction == CONST.GIRD_DIRECTION.H) {
            for (i = 0; i < this.initSequence.length; i++) {
                this.initSequence[i].leftTo = this.initSequence[i - 1] ? this.initSequence[i - 1].name : null;
                this.initSequence[i].rightTo = this.initSequence[i + 1] ? this.initSequence[i + 1].name : null;
            }
        } else {
            for (i = 0; i < this.initSequence.length; i++) {
                this.initSequence[i].upTo = this.initSequence[i - 1] ? this.initSequence[i - 1].name : null;
                this.initSequence[i].downTo = this.initSequence[i + 1] ? this.initSequence[i + 1].name : null;
            }
        }
    };
    info.container.refreshNav();

    info.container.setScroll = function () {
        if (info["scrollBar"]) {
            this.scroll = this.parent.addChild(new PIXI.Graphics());
            this.scroll.x = this.viewRect.x + this.viewRect.rectWidth + (info["scrollBarOffset"] ? info["scrollBarOffset"] : 0);
            this.scroll.y = this.viewRect.y;
            this.scroll
                .clear()
                .beginFill(0xffffff, 0.15)
                .drawRoundedRect(0, 0, 6, info.pageCount / this.data.length * this.initSequence[0].height * info.pageCount, 1)
                .endFill();

            if (this.data.length <= info.pageCount) {
                this.scroll.alpha = 0;
            } else {
                this.scroll.alpha = 1;
            }
        }
    };

    info.container.reSetScroll = function () {
        if (!this.scroll) return;
        if (this.data.length <= info.pageCount) {
            this.scroll.alpha = 0;
        } else {
            this.scroll.alpha = 1;
        }
        this.scroll
            .beginFill(0xffffff, 0.15)
            .drawRoundedRect(0, 0, 6, info.pageCount / this.data.length * this.initSequence[0].height * info.pageCount, 1)
            .endFill();
        //this.scroll.height = info.pageCount / data.length * this.initSequence[0].height * info.pageCount;
    };

    info.container.moveScroll = function () {
        if (!this.scroll) return;
        UI.getTween(this.scroll, true)
            .to({
                y : this.viewRect.y + (this.viewRect.rectHeight - this.scroll.height) * this.currIndex / (this.data.length - 1)
            }, 300);
    };

    info.container.setScroll();

    info.container.refreshData = function(item, data ) {
        if(this.refreshAddPropertyFlag){
            item.data= data;
        }
        for (var prop in data) {
            if (!data.hasOwnProperty(prop))continue;
            var target = UI.getItem(item, prop);
            var value = data[prop];
            if (!target) {

            } else if (target.type == 6) {
                if (target.children[0].text != value) {
                    UI.setText(target, value, true);
                }
            } else if (target.type == 7) {
                if (target.children[0] && target.children[0].leftWidth) {

                } else {
                    UI.setImage(target, value);
                }
            }
        }
        /*if (data.name) {
            item.name = data.name;
        }*/
        //UI.updateStage();
    };

    info.container.addArrayLengthTo = function(targetArrayLength){
        var initX = this.initSequence[this.initSequence.length - 1].x;
        var initY = this.initSequence[this.initSequence.length - 1].y;
        var nameIndex;
        for (nameIndex = 0; nameIndex < this.initSequence.length; nameIndex++) {
            this.initSequence[nameIndex].name = info.container.name + nameIndex;
        }
        var itemCount = 1;
        while(this.initSequence.length < targetArrayLength) {
            var item = SubModule.setup(template, {}, this.initSequence.length, sourceList).children.shift();
            item.parent = null;
            var itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            if (info.direction == CONST.GIRD_DIRECTION.H) {
                item.position.x = initX + (itemBounds.width + info.distance) * itemCount;
                item.position.y = itemBounds.height / 2;
            } else {
                item.position.x = itemBounds.width / 2;
                item.position.y = initY + (itemBounds.height + info.distance) * itemCount;
            }
            itemCount++;
            info.container.addChild(item);
            info.container.initSequence.push(item);
            item.name = info.container.name + nameIndex;
            nameIndex++;
            //info.container.refreshNav();
        }
        loadImagesForComponent(sourceList);
    };

    info.container.refreshPageData = function() {
        if (this.data.length <= info.pageCount + 2) {
            if (this.initSequence.length < this.data.length) {
                this.addArrayLengthTo(this.data.length);
            } else {
                while(this.initSequence.length > this.data.length) {
                    this.removeChild(this.initSequence.pop());
                    this.currIndex = this.initSequence.length - 1;
                    this.posCount = this.initSequence.length - 1;
                }
            }
        } else {
            this.addArrayLengthTo(info.pageCount + 2);
        }
        for (var i = 0; i < this.initSequence.length; i++) {
            this.refreshData(this.initSequence[i], info.container.data[this.currIndex - this.posCount + i]);
        }
        info.container.refreshNav();
        UI.updateStage();
    };

    info.container.refreshSingleData = function(index) {
        if (index == null) index = this.currIndex;
        this.posCount = this.initSequence.indexOf(UI.getCurrFocus());
        this.refreshData(this.initSequence[this.posCount], this.data[index]);
    };

    info.container.getCurrItem = function() {
        return UI.getCurrFocus();
    };

    info.container.removeAll = function() {
        this.removeAllChildren(true);
        this.initSequence = [];
        this.parent.removeChild(info.container.scroll);
        this.currIndex = 0;
        this.posCount = 0;
        this.position.y = this.initPos.y;
    };

    info.container.navPrev = function() {
        var currFocus = UI.getCurrFocus();
        this.posCount = this.initSequence.indexOf(currFocus);
        this.currIndex --;
        if (this.currIndex <= 0) {
            this.currIndex = 0;
            this.posCount = 0;
            this.posType = 0;
            this.moveScroll();
            return;
        }
        if (currFocus == this.initSequence[2] && this.data.length > info.pageCount) {
            this.posType = 1;
        }
        if (currFocus == this.initSequence[1] && this.data.length > info.pageCount) {
            var item  = this.initSequence.pop();
            if (info.direction == CONST.GIRD_DIRECTION.H) {
                item.x = this.initSequence[0].x - itemBounds.width - info.distance;
            } else {
                item.y = this.initSequence[0].y - itemBounds.height - info.distance;
            }
            this.initSequence.unshift(item);
            this.posType = 1;
            this.refreshData(item, this.data[this.currIndex - 1]);
            this.refreshNav();
        } else {
            this.posCount--;
        }
        this.moveScroll();
    };

    info.container.navNext = function() {
        var currFocus = UI.getCurrFocus();
        this.posCount = this.initSequence.indexOf(currFocus);
        this.currIndex ++;
        if (this.currIndex >= this.data.length - 1) {
            this.currIndex = this.data.length - 1;
            this.posCount = this.initSequence.length - 1;
            this.posType = 2;
            this.moveScroll();
            return;
        }
        if (currFocus == this.initSequence[this.initSequence.length - 3] && this.data.length > info.pageCount) {
            this.posType = 1;
        }
        if (currFocus == this.initSequence[this.initSequence.length - 2] && this.data.length > info.pageCount) {
            var item = this.initSequence.shift();
            var itemBounds = item.getBounds();
            if (info.direction == CONST.GIRD_DIRECTION.H) {
                item.x = this.initSequence[this.initSequence.length - 1].x + itemBounds.width + info.distance;
            } else {
                item.y = this.initSequence[this.initSequence.length - 1].y + itemBounds.height + info.distance;
            }
            this.initSequence.push(item);
            this.posType = 1;
            this.refreshData(item, this.data[this.currIndex + 1]);
            this.refreshNav();
        } else {
            this.posCount++;
        }
        this.moveScroll();
    };

    info.container.navTo = function(index, posCount, notFocus) {
        if (posCount == null){
            this.posCount = this.initSequence.indexOf(UI.getCurrFocus());
            if (this.posCount == -1) {
                this.posCount = 0;
            }
        }else{
            this.posCount = posCount;
        }
        this.currIndex = index;
        if (0 == index) {
            this.posType = 0;
        }

        if (this.currIndex >= this.data.length - 1) {
            this.currIndex = this.data.length - 1;
            this.posCount = this.initSequence.length - 1;
        }
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }

        if (index > this.initSequence.length -2 -1 && this.posType == 0 &&!this.refreshAddPropertyFlag) {
            this.posType = 1;
        }

        var realPos = this.posCount - this.posType;

        if (this.data.length <= info.pageCount) {
            UI.refreshView(this, this.initSequence[0]);
            this.posType = 0;
            this.posCount = this.currIndex;
        } else if (this.data.length - this.currIndex <= info.pageCount) {
            this.posType = 2;
            this.posCount = this.initSequence.length - (this.data.length - this.currIndex);
            UI.refreshView(this, this.initSequence[0]);
            UI.refreshView(this, this.initSequence[this.initSequence.length - 1]);
        } else {
            if (this.currIndex - realPos <= 0) {
                UI.refreshView(this, this.initSequence[0]);
                this.posType = 0;
                this.posCount = this.currIndex;
            }
            else if (this.currIndex - realPos + info.pageCount >= this.data.length) {
                UI.refreshView(this, this.initSequence[0]);
                UI.refreshView(this, this.initSequence[this.initSequence.length - 1]);
                this.posType = 2;
                this.posCount = realPos + this.posType;
            }
            else {
                UI.refreshView(this, this.initSequence[0]);
                UI.refreshView(this, this.initSequence[this.initSequence.length - 2]);
                this.posType = 1;
                this.posCount = realPos + this.posType;
            }
        }

        for (i = 0; i < this.initSequence.length; i++) {
            this.refreshData(this.initSequence[i], this.data[this.currIndex - this.posCount + i]);
        }
        if(!notFocus){
            UI.focusTo(this.initSequence[this.posCount]);
        }

        this.moveScroll();
    };

    info.container.prevPage = function() {
        if (this.currIndex == 0) {
            return;
        }
        var offset = this.currIndex == this.data.length - 1? info.pageCount: null;
        this.currIndex -= info.pageCount;
        this.navTo(this.currIndex, offset);
    };

    info.container.nextPage = function() {
        if (this.currIndex == this.data.length - 1) {
            return;
        }
        var offset = this.currIndex == 0? 1: null;
        this.currIndex += info.pageCount;
        this.navTo(this.currIndex, offset);
    };

    info.container.firstPage = function() {
        this.currIndex = 0
        var offset = this.currIndex == this.data.length - 1? info.pageCount: null;
        this.navTo(this.currIndex, offset, true);
    };

    info.container.removeItemAt = function(index, noNav) {
        if (this.data.length == 1) {
            return;
        }
        if (typeof index == "object") {
            index.sort(function (a, b) {
                return a - b;
            });
            for (var i = index.length - 1; i >= 0; i--) {
                this.data.splice(index[i], 1);
            }
        } else {
            this.data.splice(index, 1);
        }

        if (this.data.length <= info.pageCount + 2) {
            var times = this.initSequence.length - this.data.length;
            for (i = 0; i < times; i++) {
                this.removeChild(this.initSequence[this.initSequence.length - 1]);
                this.initSequence.splice(this.initSequence.length - 1, 1);
            }
        }

        this.reSetScroll();

        if (!noNav) {
            this.navTo(this.currIndex, this.posCount);
        }

    };

    info.container.addItemAt = function(dataToAdd, index, noNav) {
        if (index == null) index = this.currIndex;
        this.data.splice(index, 0, dataToAdd);

        if (info.container.initSequence.length < info.pageCount + 2) {
            var item = null;
            if (dataToAdd.template) {
                var itemTemplate = Util.readJson("templates/" + dataToAdd.template + ".json");
                item = SubModule.setup(itemTemplate, dataToAdd, i, sourceList).children[0];
            } else {
                item = SubModule.setup(template, dataToAdd, i, sourceList).children[0];
            }

            if (dataToAdd.name) {
                item.name = dataToAdd.name;
            } else {
                item.name = null;
            }

            var itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            if (info.direction == CONST.GIRD_DIRECTION.H) {
                item.position.x = info.container.initSequence[0].position.x + (itemBounds.width + info.distance) * (info.container.initSequence.length);
                item.position.y = itemBounds.height / 2;
            } else {
                item.position.x = itemBounds.width / 2;
                item.position.y = info.container.initSequence[0].position.y + (itemBounds.height + info.distance) * (info.container.initSequence.length);
            }
            info.container.addChild(item);
            info.container.initSequence.push(item);
            info.container.refreshNav();
        }

        this.reSetScroll();

        if (!noNav) {
            this.navTo(this.currIndex);
        }

        loadImagesForComponent(sourceList)
    };

    info.container.getPosType = function() {
        return this.posType;
    };

    info.container.getBeginIdx = function() {
        return this.currIndex - this.posCount
    };

    info.container.getCurrIndex = function() {
        return this.currIndex;
    };

    loadImagesForComponent(sourceList);

    if (!noUpdate) {
        UI.getTween(UI).wait(3000);
    }
};

var Gird = {};

/*
 {
 template : "0001",
 direction : CONST.GIRD_DIRECTION.H,
 breakNum : 6,
 distance : 30,
 container : launcher
 }
 */
Gird.create = function(array, info, noUpdate) {
    var sourceList = [];
    info.container.alpha = 0;
    var template = Util.readJson("templates/" + info.template + ".json");
    info.container.initSequence = [];
    info.container.position.y = info.container.initPos.y;
    var itemsNum = array.length;
    var itemBounds;
    for (i = 0; i < itemsNum; i++) {
        var item = null;
        if (array[i].template) {
            var specifyTemplate = Util.readJson("templates/" + array[i].template + ".json");
            item = SubModule.setup(specifyTemplate, array[i], i, sourceList).children[0];
        } else {
            item = SubModule.setup(template, array[i], i, sourceList).children[0];
        }
        if (array[i].name) {
            item.name = array[i].name;
            //delete array[i].name;
        }


        if (info.direction == CONST.GIRD_DIRECTION.H) {
            if (i == 0) {
                itemBounds = item.getBounds();
            } else {
                item.getBounds();
            }
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            item.position.x = item.pivot.x + (itemBounds.width + info.distanceX) * (i % info.breakNum);
            item.position.y = item.pivot.y + (itemBounds.height + info.distanceY) * (Math.floor(i / info.breakNum));
        } else {
            var distance;
            itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            item.position.x = item.pivot.x + (itemBounds.width + info.distanceX) * (Math.floor(i / info.breakNum));
            item.position.y = item.pivot.y + (itemBounds.height + info.distanceY) * (i % info.breakNum);
            if (info.breakNum == 1 && i >= 2) {
                distance = info.container.initSequence[1].x - info.container.initSequence[0].x;
                if (item.position.x - info.container.initSequence[info.container.initSequence.length - 1].x != distance) {
                    item.position.x = info.container.initSequence[info.container.initSequence.length - 1].x + distance;
                }
            }
        }
        info.container.addChild(item);
        info.container.initSequence.push(item);
    }
    //info.container._bounds = null;
    info.container.template = template;
    info.container.info = info;
    Gird.resetNavigation(info.container, info);

    info.container.addItemAt = function(item, index, noFocus) {

        if (!item.children) {
            if (item.template) {
                var specifyTemplate = Util.readJson("templates/" + item.template + ".json");
                item = SubModule.setup(specifyTemplate, item, index, sourceList).children[0];
            } else {
                item = SubModule.setup(this.template, item, index, sourceList).children[0];
            }
            var itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
        }

        if (this.initSequence[index]) {
            item.position.x = this.initSequence[index].position.x;
            item.position.y = this.initSequence[index].position.y;
        }

        for (var i = index; i < this.initSequence.length - 1; i++) {
            this.initSequence[i].position.x = this.initSequence[i + 1].position.x;
            this.initSequence[i].position.y = this.initSequence[i + 1].position.y;
        }

        this.addChildAt(item, index);
        this.initSequence.splice(index, 0, item);

        var reCalIndex = this.initSequence.length - 1;
        var reCalItem = this.initSequence[reCalIndex];
        var reCalBounds = reCalItem.getBounds();

        if (info.direction == CONST.GIRD_DIRECTION.H) {
            reCalItem.x = reCalItem.pivot.x + (reCalBounds.width + info.distanceX) * (reCalIndex % info.breakNum);
            reCalItem.y = reCalItem.pivot.y + (reCalBounds.height + info.distanceY) * (Math.floor(reCalIndex / info.breakNum));
        } else {
            reCalItem.x = reCalItem.pivot.x + (reCalBounds.width + info.distanceX) * (Math.floor(reCalIndex / info.breakNum));
            reCalItem.y = reCalItem.pivot.y + (reCalBounds.height + info.distanceY) * (reCalIndex % info.breakNum);
        }

        Gird.resetNavigation(this, this.info);

        if (this.scrollbar) {
            UI.resetScrollbar(this);
        }
        if (!noFocus) {
            UI.focusTo(item);
        }

        loadImagesForComponent(sourceList);
    };

    info.container.removeItem = function(item, noFocus) {
        if (this.initSequence.length == 1) {
            this.removeChild(item);
            this.initSequence.pop();
            UI.updateStage();
            return 0;
        }
        var index = this.initSequence.indexOf(item);
        for (var i = this.initSequence.length - 2; i >= index; i--) {
            this.initSequence[i + 1].x = this.initSequence[i].x;
            this.initSequence[i + 1].y = this.initSequence[i].y;
        }
        if (this.initSequence[index + 1]) {
            this.lastFocus = this.initSequence[index + 1];
            if (!noFocus) {
                UI.focusTo(this.initSequence[index + 1]);
            }
        } else if (this.initSequence[index - 1]) {
            this.lastFocus = this.initSequence[index - 1];
            UI.focusTo(this.initSequence[index - 1]);
            if (!noFocus) {
                UI.focusTo(this.initSequence[index + 1]);
            }
        }
        this.removeChild(item);
        this.initSequence.splice(index, 1);
        Gird.resetNavigation(this, this.info);
        if (this.scrollbar) {
            UI.resetScrollbar(this);
        }
        UI.updateStage();
    };

    info.container.indexOf = function(item) {
        info.container.getChildIndex(item);
    };

    if (info.initNum) {
        for (var i = 0; i < info.container.initSequence.length; i++) {
            if (i > info.initNum) {
                info.container.removeChild(info.container.initSequence[i])
            }
        }
    }

    info.container.alpha = 1;

    loadImagesForComponent(sourceList);

    if (!noUpdate) {
        UI.getTween(UI).wait(3000);
    }
};

Gird.resetNavigation = function(container, info) {

    for (var i = 0; i < container.initSequence.length; i++) {
        var item = container.initSequence[i];
        if (info.direction == CONST.GIRD_DIRECTION.H) {
            item.upTo = container.initSequence[i - info.breakNum] ? container.initSequence[i - info.breakNum].name : null;
            item.downTo = container.initSequence[i + info.breakNum] ? container.initSequence[i + info.breakNum].name : null;
            item.leftTo = container.initSequence[i - 1] ? container.initSequence[i - 1].name : null;
            item.rightTo = container.initSequence[i + 1] ? container.initSequence[i + 1].name : null;
            if (i % info.breakNum == 0) {
                item.leftTo = null;
            }
            else if (i % info.breakNum == info.breakNum - 1) {
                item.rightTo = null;
            }
            if (info.breakNum == 1) {
                item.rightTo = null;
            }
        } else {
            item.upTo = container.initSequence[i - 1] ? container.initSequence[i - 1].name : null;
            item.downTo = container.initSequence[i + 1] ? container.initSequence[i + 1].name : null;
            item.leftTo = container.initSequence[i - info.breakNum] ? container.initSequence[i - info.breakNum].name : null;
            item.rightTo = container.initSequence[i + info.breakNum] ? container.initSequence[i + info.breakNum].name : null;
            if (i % info.breakNum == 0) {
                item.upTo = null;
            }
            else if (i % info.breakNum == info.breakNum - 1) {
                item.downTo = null;
            }
            if (info.breakNum == 1) {
                item.downTo = null;
            }
        }
    }
};


var SavingGrid = {};

/*
 {
 template : "0001",
 direction : CONST.GIRD_DIRECTION.H,
 breakNum : 6,
 distance : 30,
 container : launcher
 }
 */
SavingGrid.create = function(array, info, noUpdate) {
    var sourceList = [];
    info.container.alpha = 0;
    var template = Util.readJson("templates/" + info.template + ".json");
    info.container.initSequence = [];
    info.container.position.y = info.container.initPos.y;
    info.container.position.x = info.container.initPos.x;
    var itemsNum = array.length;
    var itemBounds;
    for (i = 0; i < itemsNum; i++) {
        var item = null;
        if (array[i].template) {
            var specifyTemplate = Util.readJson("templates/" + array[i].template + ".json");
            item = SubModule.setup(specifyTemplate, array[i], i, sourceList).children[0];
        } else {
            item = SubModule.setup(template, array[i], i, sourceList).children[0];
        }
        if (array[i].name) {
            item.name = array[i].name;
        }


        if (info.direction == CONST.GIRD_DIRECTION.H) {
            if (i == 0) {
                itemBounds = item.getBounds();
            } else {
                item.getBounds();
            }
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            item.position.x = item.pivot.x + (itemBounds.width + info.distanceX) * (i % info.breakNum);
            item.position.y = item.pivot.y + (itemBounds.height + info.distanceY) * (Math.floor(i / info.breakNum));
        } else {
            var distance;
            itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
            item.position.x = item.pivot.x + (itemBounds.width + info.distanceX) * (Math.floor(i / info.breakNum));
            item.position.y = item.pivot.y + (itemBounds.height + info.distanceY) * (i % info.breakNum);
            if (info.breakNum == 1 && i >= 2) {
                distance = info.container.initSequence[1].x - info.container.initSequence[0].x;
                if (item.position.x - info.container.initSequence[info.container.initSequence.length - 1].x != distance) {
                    item.position.x = info.container.initSequence[info.container.initSequence.length - 1].x + distance;
                }
            }
        }
        info.container.addChild(item);
        info.container.initSequence.push(item);
    }
    //info.container._bounds = null;
    info.container.template = template;
    info.container.info = info;
    info.container.refreshItemVisible = function (desPoint) {
        var off_x = 0;
        var off_y = 0;
        if (desPoint) {
            off_x = desPoint.x - info.container.x;
            off_y = desPoint.y - info.container.y;
        }
        var items = info.container.children;
        var viewRect = info.container.viewRect;
        var pos = null;
        if (!viewRect) {
            viewRect = {
                rectWidth: info.container.width,
                rectHeight: info.container.height
            };
            pos = info.container.parent.toGlobal(info.container.position);
        } else {
            pos = viewRect.parent.toGlobal(viewRect.position);
        }
        var viewRectPos = {
            x: pos.x,
            y: pos.y,
            rectWidth: viewRect.rectWidth,
            rectHeight: viewRect.rectHeight
        };

        var refreshDelItem = function (child, visible) {
            if (!child) return;
            if (child.canBeDel) {
                var img = {color:0xffffff, alpha:0};
                if (visible) {
                    img = child.originPic;
                }
                UI.setImage(child, img, true, true);
            }
            else if (child.children && child.children.length) {
                for (var i = 0; i < child.children.length; i++) {
                    refreshDelItem(child.children[i], visible);
                }
            }
        };
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            item.vis = true;
            var b = item.getBounds();
            item.vis = hasIntersect({x: b.x + off_x, y: b.y + off_y, w: b.width, h: b.height}, {x: viewRectPos.x, y: viewRectPos.y-viewRectPos.rectHeight*0.5, w: viewRectPos.rectWidth, h: viewRectPos.rectHeight*2});
            for(var j =0;j<item.children.length;j++){
                refreshDelItem(item.children[j], item.vis);
            }
        }
        // if (window.gc) window.gc();
    };
    SavingGrid.resetNavigation(info.container, info);

    info.container.addItemAt = function(item, index, noFocus) {

        if (!item.children) {
            if (item.template) {
                var specifyTemplate = Util.readJson("templates/" + item.template + ".json");
                item = SubModule.setup(specifyTemplate, item, index, sourceList).children[0];
            } else {
                item = SubModule.setup(this.template, item, index, sourceList).children[0];
            }
            var itemBounds = item.getBounds();
            item.pivot.x = itemBounds.width / 2;
            item.pivot.y = itemBounds.height / 2;
        }

        if (this.initSequence[index]) {
            item.position.x = this.initSequence[index].position.x;
            item.position.y = this.initSequence[index].position.y;
        }

        for (var i = index; i < this.initSequence.length - 1; i++) {
            this.initSequence[i].position.x = this.initSequence[i + 1].position.x;
            this.initSequence[i].position.y = this.initSequence[i + 1].position.y;
        }

        this.addChildAt(item, index);
        this.initSequence.splice(index, 0, item);

        var reCalIndex = this.initSequence.length - 1;
        var reCalItem = this.initSequence[reCalIndex];
        var reCalBounds = reCalItem.getBounds();

        if (info.direction == CONST.GIRD_DIRECTION.H) {
            reCalItem.x = reCalItem.pivot.x + (reCalBounds.width + info.distanceX) * (reCalIndex % info.breakNum);
            reCalItem.y = reCalItem.pivot.y + (reCalBounds.height + info.distanceY) * (Math.floor(reCalIndex / info.breakNum));
        } else {
            reCalItem.x = reCalItem.pivot.x + (reCalBounds.width + info.distanceX) * (Math.floor(reCalIndex / info.breakNum));
            reCalItem.y = reCalItem.pivot.y + (reCalBounds.height + info.distanceY) * (reCalIndex % info.breakNum);
        }

        SavingGrid.resetNavigation(this, this.info, true);

        if (this.scrollbar) {
            UI.resetScrollbar(this);
        }
        if (!noFocus) {
            UI.focusTo(item);
        }

        loadImagesForComponent(sourceList);
    };

    info.container.removeItem = function(item, noFocus) {
        if (this.initSequence.length == 1) {
            this.removeChild(item);
            this.initSequence.pop();
            UI.updateStage();
            return 0;
        }
        var index = this.initSequence.indexOf(item);
        for (var i = this.initSequence.length - 2; i >= index; i--) {
            this.initSequence[i + 1].x = this.initSequence[i].x;
            this.initSequence[i + 1].y = this.initSequence[i].y;
        }
        if (this.initSequence[index + 1]) {
            this.lastFocus = this.initSequence[index + 1];
            if (!noFocus) {
                UI.focusTo(this.initSequence[index + 1]);
            }
        } else if (this.initSequence[index - 1]) {
            this.lastFocus = this.initSequence[index - 1];
            UI.focusTo(this.initSequence[index - 1]);
            if (!noFocus) {
                UI.focusTo(this.initSequence[index + 1]);
            }
        }
        this.removeChild(item);
        this.initSequence.splice(index, 1);
        SavingGrid.resetNavigation(this, this.info, true);
        if (this.scrollbar) {
            UI.resetScrollbar(this);
        }
        UI.updateStage();
    };

    info.container.indexOf = function(item) {
        return info.container.getChildIndex(item);
    };

    if (info.initNum) {
        for (var i = 0; i < info.container.initSequence.length; i++) {
            if (i > info.initNum) {
                info.container.removeChild(info.container.initSequence[i])
            }
        }
    }

    info.container.alpha = 1;
    info.container.isSavingGrid = true;
    loadImagesForComponent(sourceList);
    if (!noUpdate) {
        UI.getTween(UI).wait(3000);
    }
};

SavingGrid.resetNavigation = function(container, info, notRefreshVisible) {

    for (var i = 0; i < container.initSequence.length; i++) {
        var item = container.initSequence[i];
        if (info.direction == CONST.GIRD_DIRECTION.H) {
            item.upTo = container.initSequence[i - info.breakNum] ? container.initSequence[i - info.breakNum].name : null;
            item.downTo = container.initSequence[i + info.breakNum] ? container.initSequence[i + info.breakNum].name : null;
            item.leftTo = container.initSequence[i - 1] ? container.initSequence[i - 1].name : null;
            item.rightTo = container.initSequence[i + 1] ? container.initSequence[i + 1].name : null;
            if (i % info.breakNum == 0) {
                item.leftTo = null;
            }
            else if (i % info.breakNum == info.breakNum - 1) {
                item.rightTo = null;
            }
            if (info.breakNum == 1) {
                item.rightTo = null;
            }
        } else {
            item.upTo = container.initSequence[i - 1] ? container.initSequence[i - 1].name : null;
            item.downTo = container.initSequence[i + 1] ? container.initSequence[i + 1].name : null;
            item.leftTo = container.initSequence[i - info.breakNum] ? container.initSequence[i - info.breakNum].name : null;
            item.rightTo = container.initSequence[i + info.breakNum] ? container.initSequence[i + info.breakNum].name : null;
            if (i % info.breakNum == 0) {
                item.upTo = null;
            }
            else if (i % info.breakNum == info.breakNum - 1) {
                item.downTo = null;
            }
            if (info.breakNum == 1) {
                item.downTo = null;
            }
        }
    }
    if (container.refreshItemVisible && !notRefreshVisible) {
        container.refreshItemVisible();
    }
};

var SubModule = {};

SubModule.create = function(data, template) {
    var sourceList = [];
    var root = new PIXI.Container();
    var node = SubModule.setup(template, data, null, sourceList).children[0];
    node.getBounds();
    var childNum = node.children.length;
    for (var i = 0; i < childNum; i++) {
        var child = node.children[0];
        child.isNode = true;
        node.removeChildAt(0, true);
        root.addChild(child);
    }
    root.name = node.name;
    root.position.x = node.position.x - node.pivot.x;
    root.position.y = node.position.y - node.pivot.y;
    root.initPos = node.initPos;
    root.visible = true;
    if (UI.getCurrModule().name == 'base' && root.name == 'liveTVCtrl') {
        window['liveTV'][root.name] = root;
    } else {
        UI.getCurrModule()[root.name] = root;
    }
    root.isSubModule = true;
    loadImagesForComponent(sourceList);
    UI.updateStage();
    return root;
};

SubModule.setup = function(template, data, itemIndex, sourceList) {
    var node = new PIXI.Container();
    for (var prop in template) {
        if (!template.hasOwnProperty(prop)) {
            return;
        }
        var item = template[prop];
        if (item.type == CONST.RES_TYPE.GROUP || item.type == CONST.RES_TYPE.MULTIPLE) {
            var group = node.addChild(SubModule.setup(item.items, data, itemIndex, sourceList));
            if (itemIndex != null && itemIndex != undefined) {
                if (data['name']) {
                    group.name = data['name'];
                } else {
                    group.name = prop + itemIndex;
                }
            } else {
                group.name = prop;
                var groupBounds = group.getBounds();
                group.pivot.x = groupBounds.width / 2;
                group.pivot.y = groupBounds.height / 2;
            }
            group.position.x = item.position.x + group.pivot.x;
            group.position.y = item.position.y + group.pivot.y;
            group.initPos = new PIXI.Point(group.x, group.y);
            group.type = item.type;
            if (item.navigation) {
                group.upTo = item.navigation.upTo;
                group.downTo = item.navigation.downTo;
                group.leftTo = item.navigation.leftTo;
                group.rightTo = item.navigation.rightTo;
            }
            continue;
        }
        var child = new PIXI.Container();
        if (!!data["itemLength"]) {
            item.bound.w = data["itemLength"];
        }
        if (item.type == CONST.RES_TYPE.PLACEHOLDER) {
            var baseTexture, texture, sprite;
            if (data[prop] && typeof data[prop] == "string") {
                var url =  null;
                if (data[prop].substring(1, 10) == "var/local") {
                    url = "file://" + data[prop];
                } else if (data[prop].substring(0, 7) == "file://") {
                    url = data[prop];
                } else if (data[prop].substring(0, 7) == "http://") {
                    url = data[prop];
                } else if (data[prop].substring(0, 8) == "https://") {
                    url = data[prop];
                }
                else {
                    url = themeDir + "" + data[prop];
                }
                child.originPic = data[prop];
                if (item.canBeDel) {
                    // baseTexture = PIXI.BaseTexture.fromImage(url);
                    // texture = new PIXI.Texture(baseTexture);
                    // var sprite2 = new PIXI.Sprite(texture);
                    // var noneFlg = true;
                    // for (var i = 0; i < sourceList.length; i++) {
                    //     if (!sourceList[i] || !sourceList[i].texture || !sourceList[i].texture.baseTexture) {
                    //         continue;
                    //     }
                    //     if (sourceList[i].texture.baseTexture.imageUrl == url) {
                    //         noneFlg = false;
                    //         break;
                    //     }
                    // }
                    // if (noneFlg) {
                    //     sourceList.push(sprite2);
                    // }
                    sprite = new PIXI.Graphics();
                    sprite.clear()
                        .beginFill(0xffffff, 0)
                        .drawRect(0, 0, item.bound.w, item.bound.h)
                        .endFill();
                } else {
                    baseTexture = PIXI.BaseTexture.fromImage(url);
                    texture = new PIXI.Texture(baseTexture);
                    sprite = new PIXI.Sprite(texture);
                    baseTexture.common = true;
                    var noneFlg = true;
                    for (var i = 0; i < sourceList.length; i++) {
                        if (!sourceList[i] || !sourceList[i].texture || !sourceList[i].texture.baseTexture) {
                            continue;
                        }
                        if (sourceList[i].texture.baseTexture.imageUrl == url || item.canBeDel) {
                            noneFlg = false;
                            break;
                        }
                    }
                    if (noneFlg) {
                        sourceList.push(sprite);
                    }


                    for (var idx = 0; idx < CONST.COMMONIMGS.length; idx++) {
                        if (CONST.COMMONIMGS[idx] == data[prop]) {
                            baseTexture.common = true;
                            break;
                        }
                    }

                    sprite.mode = item.mode;
                }
                child.addChild(sprite);
            } else if (data[prop] && data[prop].src){
                baseTexture = PIXI.BaseTexture.fromImage(data[prop].src);
                texture = new PIXI.Texture(baseTexture);
                sprite = new PIXI.Sprite(texture);
                sprite.mode = item.mode;
                child.addChild(sprite);
            } else if (data[prop] && data[prop].resolution) {
                var container = Util.connBgPics(data[prop], item.bound.w, item.bound.h);
                child.addChild(container);
            } else if (data[prop] && data[prop].color) {
                var radius = 0.1;
                if (data[prop].radius) {
                    radius = data[prop].radius;
                }
                sprite = new PIXI.Graphics();
                sprite.clear()
                    .beginFill(data[prop].color, 1)
                    .drawRoundedRect(0, 0, item.bound.w, item.bound.h, radius)
                    .endFill();
                if (!!(data[prop].alpha)) {
                    sprite.alpha = data[prop].alpha;
                }
                child.addChild(sprite);
                //if(i != undefined && i != null) delete data[prop];
            } else if (data[prop] && data[prop].beginFill) {
                child.addChild(data[prop]);
                //if(i != undefined && i != null) delete data[prop];
            } else {
                sprite = new PIXI.Graphics();
                sprite.clear()
                    .beginFill(0x000000, 0.0)
                    .drawRoundedRect(0, 0, item.bound.w, item.bound.h, 5)
                    .endFill();
                child.addChild(sprite);
            }
            if (item.canBeDel) {
                child.canBeDel = item.canBeDel;
            }
            child.children[0].width = child.oriWidth = item.bound.w;
            child.children[0].height = child.oriHeight = item.bound.h;
            child.isImage = true;
        } else if (item.type == CONST.RES_TYPE.TEXT) {

            var finalText = '';

            item.fontSize = item.font.split("px ")[0];

            if (data[prop]) {
                finalText = data[prop];
            } else {
                finalText = item.value;
            }

            if (finalText) {
                var msgId = UI.getMsgId(finalText);
                if (msgId) {
                    child.msgId = finalText;
                    finalText = finalText.replace('['+msgId+']', Config.language[msgId] ? Config.language[msgId] : '['+msgId+']');
                }
            }

            var text;
            if (item["warp"]) {

                text = new PIXI.Text(finalText,
                    {
                        fontFamily : item.font.split("px ")[1],
                        fontSize: parseInt(item.font.split("px ")[0]),
                        fill : parseInt(item.color, 16),
                        align : item.align,
                        wordWrapWidth : item.bound.w,
                        wordWrap : item["warp"],
                        lineHeight : item.lineHeight ? item.lineHeight+parseInt(item.font.split("px")[0]) : 0
                    });

                text.maxLines = item.maxLines;
                text.originAlign = item.align;
                child.textColumn = item["column"];

                if (GLOBAL.RTL) {
                    text.updateText();
                    UI.calculateAlignRTL(text);
                }

                switch (item["column"]) {
                    case "up" :
                        text.position.y = 0;
                        text.pivot.y = 0;
                        break;
                    case "down" :
                        text.position.y = item.bound.h;
                        text.pivot.y = text.getBounds().height;
                        break;
                    case "middle" :
                        text.position.y = item.bound.h / 2;
                        text.pivot.y = text.getBounds().height / 2;
                        break;
                }
            } else {

                var textWidth = TextMeasurer.measure(finalText, {
                    style:{
                        fontFamily : item.font.split("px ")[1],
                        fontSize: parseInt(item.font.split("px ")[0])
                    }
                });

                if (textWidth > item.bound.w) {
                    child.originText = finalText;
                    for (i = 0; i < finalText.length; i++) {
                        var tempStr = finalText.substring(0, finalText.length - i) + "...";
                        textWidth = TextMeasurer.measure(tempStr, {
                            style:{
                                fontFamily : item.font.split("px ")[1],
                                fontSize: parseInt(item.font.split("px ")[0])
                            }
                        });
                        if (textWidth <= item.bound.w) {
                            finalText = tempStr;
                            break;
                        }
                    }
                }

                text = new PIXI.Text(finalText,
                    {
                        fontFamily : item.font.split("px ")[1],
                        fontSize: parseInt(item.font.split("px ")[0]),
                        fill : typeof item.color == 'string' ? parseInt(item.color, 16) : item.color,
                        align : item.align
                    });

                var textBounds = text.getBounds();
                text.position.y = item.bound.h / 2;
                text.pivot.y = textBounds.height / 2;
            }

            switch (item.align) {
                case "left" :
                    text.position.x = 0;
                    text.pivot.x = 0;
                    break;
                case "right" :
                    text.position.x = item.bound.w;
                    text.pivot.x = text.width;
                    break;
                case "center" :
                    text.position.x = item.bound.w / 2;
                    text.pivot.x = text.width / 2;
                    break;
            }

            child.addChild(text);
            child.isText = true;
            child.originWidth = item.bound.w;
            child.originHeight = item.bound.h;
            UI.calculateWarpString(text, finalText, child.originWidth, text.maxLines);
        } else if (item.type == CONST.RES_TYPE.ANCHOR) {

        }
        child.name = prop;
        if (item.hasOwnProperty("alpha")) {
            child.alpha = item.alpha;
        }
        child.type = item.type;
        child.position.x = item.position.x + child.width / 2;
        child.position.y = item.position.y + child.height / 2;
        child.pivot.x = child.width / 2;
        child.pivot.y = child.height / 2;
        child.initPos = new PIXI.Point(child.x, child.y);

        if (item.navigation) {
            child.upTo = item.navigation.upTo;
            child.downTo = item.navigation.downTo;
            child.leftTo = item.navigation.leftTo;
            child.rightTo = item.navigation.rightTo;
        }
        node.addChild(child);
        node.data = {};
        for (var leftProp in data) {
            if (data.hasOwnProperty(leftProp)) {
                node.data[leftProp] = data[leftProp];
            }
        }
    }
    return node;
};

var Util = {};

Util.readJson = Util.readJsonObject = function (path) {
    if (UI.templateManager[path]) {
        return UI.templateManager[path];
    }
    var request = new XMLHttpRequest();
    request.open("GET", "" + path, false);
    request.send(null);
    var response = request.responseText;
    var json = JSON.parse(response);
    UI.templateManager[path] = json;
    return json;
};

Util.switchLR = function(container) {
    for(var i = 0; i< container.children.length; i++) {
        var child = container.children[i];
        if (child.name) {
            child.x = container.getBounds().width - child.x;
        }
        if (child.text) {
            if (child.textAlign == "left") {
                child.textAlign = "right";
                child.x = container.getBounds().width;
            } else if (child.textAlign == "right") {
                child.textAlign = "left";
                child.x = 0;
            }
        }
        if (child.children) {
            Util.switchLR(child);
        }
    }
};

var NumberInput = {};

NumberInput.create = function(target, info, onChange) {
    target.isNumberInput = true;
    target.updatePos = function(){
        switch (txt.style.align) {
            case "left" :
                txt.pivot.x = 0;
                txt.position.x = 0;
                break;
            case "right" :
                txt.pivot.x = txt.getBounds().width;
                txt.position.x = target.children[0].width;
                break;
            case "center" :
                txt.pivot.x = txt.getBounds().width / 2;
                txt.position.x = target.children[0].width / 2;
                break;
        }
    }
    target.setText=function(Txt){
        txt.text = Txt;
        target.updatePos();
        UI.updateStage();
    };
    target.setTextColor=function(color){
        txt.style.fill = color;
        UI.updateStage();
    };
    target.getText=function(){
        return txt.text;
    };
    target.changeInfo=function(info){
        txt.max = info.max +"";
        UI.updateStage();
    };
    var proIpNumKey = function() {
        var tempTxt = txt.text;
        var keyValue = CONST.NUMIPT_VALUE[UI.currKeyValue];
        tempTxt = tempTxt + "" + keyValue;

        if (tempTxt.length <= txt.max.length && parseInt(tempTxt) <= parseInt(txt.max) && parseInt(tempTxt) >= parseInt(txt.min)) {
            target.setText(tempTxt);
            UI.callTTS(keyValue+"");
            if (onChange) {
                onChange(txt);
                target.updatePos();
            }
        }
        UI.updateStage();
    };

    target.onkey_ZERO = proIpNumKey;
    target.onkey_ONE = proIpNumKey;
    target.onkey_TWO = proIpNumKey;
    target.onkey_THREE = proIpNumKey;
    target.onkey_FOUR = proIpNumKey;
    target.onkey_FIVE = proIpNumKey;
    target.onkey_SIX = proIpNumKey;
    target.onkey_SEVEN = proIpNumKey;
    target.onkey_EIGHT = proIpNumKey;
    target.onkey_NINE = proIpNumKey;

    if (!info.fontSize) {info.fontSize = target.height}
    if (!info.color) {info.color = 0xFFFFFF}
    var txt = new PIXI.Text(" ",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: info.fontSize,
            fill : info.color,
            align : info.align
        });
    txt.min = info.min + "";
    txt.max = info.max + "";
    txt.position.y =target.height / 2;
    txt.pivot.y = txt.height/ 2;
    target.updatePos();

    target.addChild(txt);
    target.txt = txt;
    UI.updateStage();
};

var TextBox = {};

TextBox.create = function(target, info, onchange,launcherflg) {

    target.onChangeCallBack = onchange;

    target.changeMaxNum=function(maxLength){
        inputTxt.maxNum = maxLength;
    };

    target.makeText = function(value) {
        if (inputCursor.index >= inputTxt.realValue.length) {
            inputCursor.index++;
            return inputTxt.realValue + value;
        } else {
            return inputTxt.realValue.substring(0, inputCursor.index) +
                value + inputTxt.realValue.substring(inputCursor.index, inputTxt.realValue.length);
        }
    };

    target.setText = function(value, addvalue) {
        if (!!addvalue) {
            value = value.substring(0, inputCursor.index) + addvalue + value.substring(inputCursor.index, value.length);
        }
        if (value.length > inputTxt.maxNum) {
            value = value.substring(0, inputTxt.maxNum);
        }
        inputTxt.realValue = value;
        if (inputTxt.showPwd) {
            inputTxt.text = "";
            for (var i = 0; i < value.length; i++) {
                inputTxt.text += "*";
            }
        } else {
            inputTxt.text = value;
        }

        var measuredWidth = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);
        inputCursor.x = measuredWidth + inputTxt.x;
        if (inputCursor.x < 0) {
            inputCursor.x = 0;
            inputTxt.x = -measuredWidth;
        }
        else if (inputCursor.x > target.maxWidth) {
            inputCursor.x = target.maxWidth;
            inputTxt.x = target.maxWidth - measuredWidth;
        }
    };
    target.backspace = function () {
        var ori_txt = inputTxt.text;
        var new_txt = ori_txt.substring(0, inputCursor.index-1) + ori_txt.substring(inputCursor.index,ori_txt.length);
        this.setText(new_txt);
        this.cursorLeft();
    };
    target.delete = function () {
        var ori_txt = inputTxt.text;
        var new_txt = ori_txt.substring(0, inputCursor.index) + ori_txt.substring(inputCursor.index+1,ori_txt.length);
        this.setText(new_txt);
    };

    target.showKeyBoard = function() {

        target.inactive();
        UI.inactiveKey();
        target.initValue = inputTxt.realValue;
        if (Config.tv) {
            UI.isSoftKeyBoard = true;
        } else {
            UI.inactiveKey();
            document.onkeydown = UI.onKeyBoardForSoft;
            UI.isSoftKeyBoard = true;
        }

        var curLang;
        switch(GLOBAL.CURRENT_LANGUAGE) {
            case "eng" :
                curLang = "ENG";
                break;
            case "fre" :
                curLang = "FRA";
                break;
            case "spa" :
                curLang = "SPA";
                break;
	    default :
                curLang = GLOBAL.CURRENT_LANGUAGE.toUpperCase();
        }

        // 第一次打开软键盘时，进行加载
        if (!GLOBAL.SOFTKEYBOAD_INITED) {
            loadCss("keyboard/css/iqqi.css");
            $LAB.script("keyboard/js/constances.js")
                .script("keyboard/js/debug.js")
                .script("keyboard/js/api/cache.js")
                .script("keyboard/js/api/json.js")
                .script("keyboard/js/api/view.js")
                .script("keyboard/js/tools.js")
                .script("keyboard/js/strings.js")
                .script("keyboard/js/html.js")
                .script("keyboard/js/native.js")
                .script("keyboard/js/config.js")
                .script("keyboard/js/keyboard.js")
                .script("keyboard/js/iqqi.js")
                .script("keyboard/js/invoke.js")
                .wait(function(){
                    // 调用软键盘打开接口call
                    startIQQI.call({
                        // 文本值
                        "value":inputTxt.realValue,
                        // 光标位置
                        "position":inputCursor.index,
                        // 最大长度
                        "maxLength":inputTxt.maxNum,
                        // 当前语言
                        "curLang": curLang,
                        // 当前模式
                        "curMode": 0,
                        // 是否是密码方式显示
                        "viewType": inputTxt.showPwd ? "password" : "text",
                        "workType": inputTxt.isPwd ? "password" : "text",
                        // 当前市场
                        "curMarket": GLOBAL.CURRENT_AREA,
                        // 当前区域
                        "curArea": GLOBAL.CURRENT_SUB_AREA,
                        //从哪调IQQI，显示啥
                        "InputName": !!info && !!info.TextName ? info.TextName : Config.language["SE1234"],//Please Input
                        // UI回调，软键盘退出时会调用该回调
                        "callback": function() {
                            // 将按键收回给UI
                            if (Config.tv) {
                                UI.isSoftKeyBoard = false;
                            } else {
                                document.onkeydown = UI.onKeyBoard;
                            }
                            // 将软键盘返回的文本设置到控件中
                            target.setText(this.value);
                            // 将软键盘返回的光标位置设置到控件中
                            inputCursor.index = this.position;
                            // 设置光标位置
                            inputCursor.x = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);
                            UI.updateStage();
                            UI.activeKey();
                            target.active();
                            // 如果配置了控件回调，则调用该回调
                            if (target.onChangeCallBack){
                                target.onChangeCallBack(inputTxt, target);
                            }
                        }
                    });
                });
            GLOBAL.SOFTKEYBOAD_INITED = true;
        } else {
            // 第二次之后打开，不需要再加载JS文件，直接打开即可
            startIQQI.call({
                "value":inputTxt.realValue,
                "position":inputCursor.index,
                "maxLength":inputTxt.maxNum,
                "curLang": curLang,
                "curMode": 0,
                "viewType": inputTxt.showPwd ? "password" : "text",
                "workType": inputTxt.isPwd ? "password" : "text",
                "curMarket": GLOBAL.CURRENT_AREA,
                "curArea": GLOBAL.CURRENT_SUB_AREA,
                "InputName": !!info && !!info.TextName ? info.TextName : Config.language["SE1234"],//Please Input
                "callback": function() {
                    if (Config.tv) {
                        UI.isSoftKeyBoard = false;
                    } else {
                        document.onkeydown = UI.onKeyBoard;
                    }
                    target.setText(this.value);
                    inputCursor.index = this.position;
                    inputCursor.x = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);
                    UI.updateStage();
                    UI.activeKey();
                    target.active();
                    if (target.onChangeCallBack){
                        target.onChangeCallBack(inputTxt, target);
                    }
                }
            });
        }
    };

    // 激活文本框，光标显示并闪烁
    target.active = function() {
        UI.activeTextBox = target;
        inputCursor.visible = true;
        inputCursor.alpha = 1;
        UI.getTween(inputCursor, true, true).to({alpha:0}, 500, UI.ease.quadIn).to({alpha:1}, 500, UI.ease.quadOut);
    };

    // inactive文本框，光标不显示
    target.inactive = function() {
        UI.activeTextBox = null;
        inputCursor.visible = false;
        createjs.Tween.removeTweens(inputCursor);
    };

    // 变为普通文本（专门给All Input页面修改通道名用的）
    target.toNormalText = function() {
        var bound = target.getBounds();
        var textLen = inputTxt.getBounds().width;
        if (textLen > bound.width) {
            for (var i = 0; i < inputTxt.text.length; i++) {
                var tmpStr = inputTxt.text.substring(0, inputTxt.text.length - i) + '...';
                if (TextMeasurer.measure(tmpStr, inputTxt) <= bound.width) {
                    target.originText = inputTxt.text;
                    inputTxt.text = tmpStr;
                    UI.base.runText(target);
                    break;
                }
            }
        } else {
            inputTxt.text = inputTxt.realValue;
            target.originText = null;
        }
        //target.originWidth = bound.width;
        switch (inputTxt.style.align) {
            case "left" :
                inputTxt.position.x = 0;
                inputTxt.pivot.x = 0;
                break;
            case "right" :
                inputTxt.position.x = target.originWidth;
                inputTxt.pivot.x = inputTxt.getBounds().width;
                break;
            case "center" :
                inputTxt.position.x = target.originWidth / 2 + bound.width * 0.07;
                inputTxt.pivot.x = inputTxt.getBounds().width / 2;
                break;
        }
        //switch (inputTxt.originAlign) {
        //    case "left" :
        //        inputTxt.x = 0;
        //        break;
        //    case "right" :
        //        inputTxt.x =bound.width;
        //        break;
        //    case "center" :
        //        inputTxt.x = target.originWidth;
        //        break;
        //}
        switch (inputTxt.textColumn) {
            case "up" :
                inputTxt.y = 0;
                break;
            case "down" :
                inputTxt.y = bound.height;
                break;
            case "middle" :
                inputTxt.y = bound.height / 2;
                break;
        }
    };

    // 光标左移
    target.cursorLeft = function() {
        var ret = false;
        if (inputCursor.index > 0) {
            inputCursor.index--;
            ret = true;
        }

        var measuredWidth = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);

        inputCursor.x = measuredWidth + inputTxt.x;
        if (inputCursor.x < 0) {
            inputCursor.x = 0;
            inputTxt.x = -measuredWidth;
        }
        return ret;
    };

    // 光标右移
    target.cursorRight = function() {
        var ret = false;
        if (inputCursor.index < inputTxt.text.length) {
            inputCursor.index++;
            ret = true;
        }

        var measuredWidth = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);

        inputCursor.x = measuredWidth + inputTxt.x;
        if (inputCursor.x > target.maxWidth) {
            inputCursor.x = target.maxWidth;
            inputTxt.x = target.maxWidth - measuredWidth;
        }
        return ret;
    };

    target.setCursor = function(index) {
        inputCursor.index = index;

        var measuredWidth = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);

        inputCursor.x = measuredWidth;
        inputTxt.x = 0;
        if (measuredWidth > target.maxWidth) {
            inputCursor.x -= measuredWidth - target.maxWidth;
            inputTxt.x -= measuredWidth - target.maxWidth;
        }
    };

    target.getCursor = function() {
        return inputCursor.index;
    };

    var bounds = target.getBounds();
    if (!info.fontSize) {info.fontSize = bounds.height}
    var inputTxt = target.children[0];
    inputTxt.text = '';
    if (info.color) {inputTxt.color = info.color;}
    inputTxt.maxNum = info.maxLength;
    inputTxt.isPwd = info.isPwd;
    if(typeof (info.showPwd) != "undefined"){
        inputTxt.showPwd = info.showPwd;
    }else{
        inputTxt.showPwd = false;
    }
    inputTxt.realValue = target.originText ? target.originText : inputTxt.text;


        var inputCursor = new PIXI.Graphics();
        inputCursor.index = info.initVal.length;
        inputTxt.text = info.initVal;

        inputCursor
            .clear()
            .lineStyle(3, 0xffffff, 1)
            .moveTo(0, 0)
            .lineTo(0, info.fontSize);
        inputCursor.x = TextMeasurer.measure(inputTxt.text.substring(0, inputCursor.index), inputTxt);
        inputCursor.visible = false;
        //inputCursor.y = info.fontSize / 2;
        target.maxWidth = info.maxWidth;
        target.inputCursor = inputCursor;
        var mask = new PIXI.Graphics();
        mask.clear().beginFill(0x000000, 0.5).drawRect(0, 0, target.originWidth, info.fontSize + 5).endFill();
        mask.y = inputTxt.y;
    mask.pivot.y = (info.fontSize + 5) /2;
    inputCursor.y = inputTxt.y;
    inputCursor.pivot.y = (info.fontSize + 5) /2;
        if (!info.noMask) {
            inputTxt.mask = mask;
        }
    if(!launcherflg){
        target.addChild(mask);
        target.addChild(inputCursor);
    }

    UI.updateStage();
};

var Select = {};

Select.create = function(target, values, flags){

    if(undefined===flags) {
        if (target.leftArrow) {
            target.removeChild(target.leftArrow);
            target.removeChild(target.rightArrow);
        }
        var baseTexture = PIXI.BaseTexture.fromImage(themeDir + "setting/ic_leftarrow_normal.png");
        baseTexture.common = true;
        var texture = new PIXI.Texture(baseTexture);
        var leftArrow = new PIXI.Sprite(texture);
        var rightArrow = new PIXI.Sprite(texture);

        leftArrow.once('refresh', function (sprite) {
            UI.renderer.textureManager.updateTexture(sprite.texture.baseTexture);
            UI.updateStage();
        }, leftArrow);

        rightArrow.once('refresh', function (sprite) {
            UI.renderer.textureManager.updateTexture(sprite.texture.baseTexture);
            UI.updateStage();
        }, rightArrow);

        leftArrow.pivot.x = 9;
        leftArrow.pivot.y = 15;
        rightArrow.pivot.x = 9;
        rightArrow.pivot.y = 15;

        leftArrow.doFlip = true;
        rightArrow.doFlip = true;

        var localPoint = target.children[0].position;
        leftArrow.x = localPoint.x - target.originWidth / 2 - 20;
        leftArrow.y = target.children[0].y;
        rightArrow.scale.x = -1;
        rightArrow.x = localPoint.x + target.originWidth / 2 + 20;
        rightArrow.y = target.children[0].y;

        target.leftArrow = target.addChild(leftArrow);
        target.rightArrow = target.addChild(rightArrow);
        target.isText = false;
    }

    target.values = values;
    target.selected = values[0];

    UI.setText(target, target.selected);
    //UI.setVoiceStr(target, target.selected);

    UI.updateStage();

    target.selectNext = function() {
        if (target.isTextRunning) {
            UI.base.stopText(target)
        }
        var index = target.values.indexOf(target.selected) + 1;
        if (index <= target.values.length - 1) {
            target.selected = target.values[index];
        } else {
            target.selected = target.values[0];
        }
        UI.setText(target, target.selected);
        UI.setVoiceStr(target,target.selected);
        UI.updateStage();
        if (target.originText) {
            UI.base.runText(target)
        }
    };
    target.selectPrev = function() {
        if (target.isTextRunning) {
            UI.base.stopText(target)
        }
        var index = target.values.indexOf(target.selected) - 1;
        if (index >= 0) {
            target.selected = target.values[index];
        } else {
            target.selected = target.values[target.values.length - 1];
        }
        UI.setText(target, target.selected);
        UI.setVoiceStr(target,target.selected);
        UI.updateStage();
        if (target.originText) {
            UI.base.runText(target)
        }
    };
    target.changeValue=function(values,selectIndex){
        target.values = values;
        target.selected = target.values[selectIndex];
        UI.setText(target, target.selected);
        //UI.setVoiceStr(target,target.selected);
    };
    target.selectCurrent = function(index,noTTS) {
        if (target.isTextRunning) {
            UI.base.stopText(target)
        }
        target.selected = target.values[index];
        UI.setText(target, target.selected);
       /* if(!noTTS){
            UI.setVoiceStr(target,target.selected);
        }*/
    };
    target.selectCurrentNoVoice = function(index) {
        if (target.isTextRunning) {
            UI.base.stopText(target)
        }
        target.selected = target.values[index];
        UI.setText(target, target.selected);
    };

    target.onNormal = function() {
        if(undefined===flags) {
            leftArrow.alpha = 0.7;
            rightArrow.alpha = 0.7;
        UI.updateStage();
        }
    };

    target.onFocus = function() {
        if(undefined===flags) {
            leftArrow.alpha = 1;
            rightArrow.alpha = 1;
        UI.updateStage();
        }
    }
};

var Percent = {};

Percent.create = function (target, txt, percent, min, max, isEnable) {

    var enableColor = 0xbb2071;
    if(GLOBAL.LAUNCHER_BRAND =="his") { enableColor = 0x00a9c2 }

    typeof min == StrDef.UNDEFINED && (min = 0);
    typeof max == StrDef.UNDEFINED && (max = 100);
    typeof isEnable == StrDef.UNDEFINED && (isEnable = true);

    target.percent = percent;
    target.isEnable = isEnable;
    target.lineColor = isEnable ? enableColor : 0x85888d;

    var bound = target.getBounds();

    var children = target.removeAllChildren();

    var back = new PIXI.Graphics();
    back.clear()
        .beginFill(0xffffff, 0.25)
        .drawRoundedRect(0, 0, bound.width, bound.height, 4)
        .endFill();
    var shape = new PIXI.Graphics();
    shape.clear()
        .beginFill(target.lineColor, 1)
        .drawRoundedRect(0, 0, bound.width, bound.height, 4)
        .endFill();
    var mask = new PIXI.Graphics();
    mask.clear()
        .beginFill(0x000000, 0.25)
        .drawRect(0, 0, bound.width, bound.height)
        .endFill();
    shape.mask = mask;
    mask.x = bound.width * ((target.percent - min) / (max-min)) - bound.width;

    target.addChild(back);
    target.addChild(shape);
    target.addChild(mask);

    txt.children[0].text = target.percent;
    UI.updateStage();

    target.plus = function() {
        if (target.percent < max) {
            target.percent++;
            mask.x = bound.width * ((target.percent - min) / (max-min)) - bound.width;
            txt.children[0].text = target.percent;
            UI.updateStage();
            UI.setVoiceStr(target,target.percent);
        }
    };
    target.minus = function() {
        if (target.percent > min) {
            target.percent--;
            UI.setVoiceStr(target,target.percent);
        }
        else {
            target.percent = min;
        }
        mask.x = bound.width * ((target.percent - min) / (max-min)) - bound.width;
        txt.children[0].text = target.percent;
        UI.updateStage();
    };
    target.setPercent = function(percent) {
        target.setPercentNoVoice(percent);
        UI.setVoiceStr(target,target.percent);
    };
    target.setPercentNoVoice = function(percent) {
        if (percent < min) {
            percent = min;
        }
        if (percent > max) {
            percent = max;
        }
        target.percent = percent;
        mask.x = bound.width * ((target.percent - min) / (max-min)) - bound.width;
        txt.children[0].text = target.percent;
        UI.updateStage();
    };
    target.setCmpEnable = function(enable){
        target.isEnable = enable;
        target.lineColor = target.isEnable ? enableColor : 0x85888d;
        shape.clear()
            .beginFill(target.lineColor, 1)
            .drawRoundedRect(0, 0, bound.width, bound.height, 4)
            .endFill();
        txt.children[0].text = target.percent;
        UI.updateStage();
    };
    target.getCmpEnable = function(){
        return target.isEnable;
    };

    target.onFocus = function() {

    };

    target.onNormal = function() {

    }
};

var Switch = {};

Switch.create = function(target, initFlg){

    var children = target.removeAllChildren();

    var baseTextureOn = PIXI.BaseTexture.fromImage(themeDir + "setting/"+GLOBAL.LAUNCHER_BRAND +"/ic_switch_on.png");
    baseTextureOn.common = true;
    var baseTextureOff = PIXI.BaseTexture.fromImage(themeDir + "setting/ic_switch_off.png");
    baseTextureOff.common = true;

    var textureOn = new PIXI.Texture(baseTextureOn);
    var textureOff = new PIXI.Texture(baseTextureOff);

    target.flag = initFlg;
    var comp;
    if (target.flag) {
        comp = new PIXI.Sprite(textureOn);
    } else {
        comp = new PIXI.Sprite(textureOff);
    }
    target.addChild(comp);
    UI.updateStage();

    target.switch = function() {
        if (target.flag) {
            target.flag = false;
            comp.texture = textureOff;
        } else {
            target.flag = true;
            comp.texture = textureOn;
        }
        UI.updateStage();
        UI.setVoiceStr(target,target.flag ? "[GE0005]":"[GE0006]");
        UI.getTween(UI).wait(3000);
    };

    target.setSwitch = function(flag) {
        target.flag = flag;
        if (flag) {
            comp.texture = textureOn;
        } else {
            comp.texture = textureOff;
        }
        UI.updateStage();
    };

    target.onFocus = function() {

    };

    target.onNormal = function() {

    }
};

var LabelValue = {};

LabelValue.create = function(target, labelText) {
    if (target.originText) {
        target.originText = null;
    }
    target.isText = false;
    target.isLabelValue = true;
    var value = target.children[0];
    var label = new PIXI.Text(labelText,value.style);
    var splitter = new PIXI.Text(": ",value.style);

    var msgId = UI.getMsgId(labelText);
    if (msgId) {
        label.text = label.text.replace('['+msgId+']', Config.language[msgId]);
        label.msgId = labelText;
    }

    if (target.msgId) {
        value.msgId = target.msgId;
        target.msgId = null;
    }

    label.y = value.y;
    label.pivot.y = value.pivot.y;
    target.addChild(label);

    splitter.y = value.y;
    splitter.pivot.y = value.pivot.y;
    target.addChild(splitter);

    target.label = label;
    target.value = value;
    target.splitter = splitter;
    target.initX = value.x;

    target.refreshPos = function() {

        this.label.updateText();
        this.value.updateText();
        this.splitter.updateText();

        var labelWidth = TextMeasurer.measure(this.label.text, this.label);
        var valueWidth = TextMeasurer.measure(this.value.text, this.value);
        var splitterWidth = TextMeasurer.measure(this.splitter.text, this.splitter);

        switch (this.value.style.align) {
            case "left" :
                this.label.x = target.initX;
                this.splitter.x = this.label.x + labelWidth;
                this.value.x = this.label.x + splitterWidth + labelWidth;
                break;
            case "right" :
                this.splitter.x = this.value.x - valueWidth;
                this.label.x = this.value.x - splitterWidth - valueWidth;
                break;
        }

        label.y = value.y;
        label.pivot.y = value.pivot.y;

        splitter.y = value.y;
        splitter.pivot.y = value.pivot.y;
    };

    target.refreshPos();
    UI.updateStage();

    target.setValue = function(valueText,fixBoundFlag) {
        this.value.text = valueText;
        var msgId = UI.getMsgId(valueText);
        if (msgId) {
            this.value.text = valueText.replace('['+msgId+']', Config.language[msgId]);
            this.value.msgId = valueText;
        }
        if (fixBoundFlag) {
            try{
                var tempOrgLableValue = new PIXI.Text(this.value.text,
                    {
                        fontFamily : value.style.fontFamily,
                        fontSize: value.style.fontSize,
                        fill : value.style.fill,
                        align : value.style.align
                    });
                //var tempOrgLableValue=new createjs.Text(this.value.text, this.value.font, this.value.color);
                var tempOrgLableWidth= tempOrgLableValue.getBounds().width;
                var tempOrgLable=target.label.getBounds().width;
                if(tempOrgLableWidth+tempOrgLable > target.originWidth -40){
                    var tempText =new PIXI.Text("",
                        {
                            fontFamily : value.style.fontFamily,
                            fontSize: value.style.fontSize,
                            fill : value.style.fill,
                            align : value.style.align
                        });
                    //var tempText = new createjs.Text('', this.value.font, this.value.color);
                    for (var i = 0; i < this.value.text.length; i++) {
                        tempText.text = this.value.text.substring(0, this.value.text.length - i) + "...";
                        if (tempOrgLable+tempText.getBounds().width <= target.originWidth -40) {
                            target.originText = this.value.text;
                            this.value.text = tempText.text;
                            break;
                        }
                    }
                }
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
        this.refreshPos();
        UI.updateStage();
    };
    target.setLabel = function(labelText) {
        this.label.text = labelText;
        var msgId = UI.getMsgId(labelText);
        if (msgId) {
            this.label.text = labelText.replace('['+msgId+']', Config.language[msgId]);
            this.label.msgId = labelText;
        }
        this.refreshPos();
        UI.updateStage();
    };
    target.getValueText = function() {
        return this.value.text;
    };
    target.getLabelText = function() {
        return this.label.text;
    };
    target.setLabelColor = function(fill) {
        this.label.style.fill = fill;
        this.splitter.style.fill = fill;
        UI.updateStage();
    };
    target.setValueColor = function(fill) {
        this.value.style.fill = fill;
        UI.updateStage();
    };
    target.setLabelFont = function(font) {
        //this.label.style.fontFamily = font;
    };
    target.setValueFont = function(font) {
        //this.value.style.fontFamily = font;
    };
};

var Checkbox = {};

Checkbox.create = function(target, isChecked) {

    var baseTextureNo = PIXI.BaseTexture.fromImage(themeDir + "setting/ic_check_box_normal.png");
    baseTextureNo.common = true;
    var baseTextureYes = PIXI.BaseTexture.fromImage(themeDir + "setting/ic_check_box_focused.png");
    baseTextureYes.common = true;
    var textureNo = new PIXI.Texture(baseTextureNo);
    var textureYes = new PIXI.Texture(baseTextureNo);
    var comp = new PIXI.Sprite(textureNo);
    target.addChild(comp);
    target.isChecked = isChecked;
    UI.updateStage();

    target.switchCheck = function() {
        if (target.isChecked) {
            comp.texture = textureNo;
            target.isChecked = false;
        } else {
            comp.texture = textureYes;
            target.isChecked = true;
        }
        UI.updateStage();
    };

    target.onFocus = function() {
    };

    target.onNormal = function() {
    };
};

Util.connBgPics = function(baseTexture, width, height) {
    var texture = new PIXI.Texture(baseTexture);
    var slicePanel = new PIXI.mesh.NineSlicePlane(
        texture,
        baseTexture.leftWidth,
        baseTexture.topHeight,
        baseTexture.rightWidth,
        baseTexture.bottomHeight
    );
    slicePanel.width = width;
    slicePanel.height = height;
    slicePanel.position.x = slicePanel.position.x - baseTexture.offsetX;
    slicePanel.position.y = slicePanel.position.y - baseTexture.offsetY;
    return slicePanel;
};


var TextMeasurer = {};
TextMeasurer.ctx = document.createElement("canvas").getContext("2d");
TextMeasurer.measure = function(text, target) {
    if (target) {
        TextMeasurer.ctx.font = target.style.fontSize + 'px ' + target.style.fontFamily;
    }
    return TextMeasurer.ctx.measureText(text).width;
};

function loadImagesForComponent(sprites) {
    for (var i = 0; i < sprites.length; i++) {
        sprites[i].once('refresh', function (sprite) {
                UI.updateStage();
        }, this)
    }
}
String.prototype.replaceAll = function(s1,s2){
    return this.replace(new RegExp(s1,"gm"),s2);
}
function  getPointStrForTTS(){
    if(GLOBAL.TTS_LANGUAGE == "spa"){
        return " Punto ";
    }else{
        return " Point ";
    }
}
function replaceSpecialTTSString(str){
    if(str.indexOf("ARC ")==0){
        str=str.replace("ARC ","A R C ");
    }
    if(str.indexOf(" ARC ")){
        str= str.replace(" ARC "," A R C ");
    }
    if(str == "ARC"){
        str= "A R C";
    }
    if(str.indexOf(" ARC")>=(str.length-4)){
        str= str.replace(" ARC"," A R C");
    }

    return str;
}

function hasIntersect (targetRect, viewRect) {
    var l = Math.max(targetRect.x, viewRect.x);
    var t = Math.max(targetRect.y, viewRect.y);
    var r = Math.min(targetRect.x+targetRect.w, viewRect.x+viewRect.w);
    var b = Math.min(targetRect.y+targetRect.h, viewRect.y+viewRect.h);
    return (l<r) && (t<b);
};
DBG_INFO("Util.js end " + new Date().getTime());