/**
 * Created by jiangbo1 on 2016/1/26.
 */

function MessagePool() {
    var myEnum = 0, _this = this, msgIdEnum = 0;
    _this.MESSAGE_NAME = {
        AM_STATE_CHANGED: myEnum++,
        AUDIO_FORMAT_INFO_CHANGED: myEnum++,
        CEC_ARC_STATE_CHANGED: myEnum++,
        CEC_DEVICE_EXIST_CHANGED: myEnum++,
        CEC_CHANGE_SOURCE: myEnum++,
        CEC_CONTROL_CHANGED: myEnum++,
        CHANNEL_FAV_SET: myEnum++,
        CHANNEL_SKIP_SET: myEnum++,
        CHANNEL_UPDATED: myEnum++,
        CURRENT_CHANNEL_CHANGED: myEnum++,
        CURRENT_COUNTRY_CHANGED: myEnum++,
        CURRENT_LANGUAGE_CHANGED: myEnum++,
        CURRENT_PROGRAM_INFO: myEnum++,
        CURRENT_INPUT_LOCK_CHANGED: myEnum++,
        CURRENT_SOURCE_CHANGED: myEnum++,
        DEVIATION_FROM_UTC_CHANGED: myEnum++,
        ENTER_SUSPEND_MODE: myEnum++,
        FACTORY_MODE_CHANGED: myEnum++,
        HISMART_DATA: myEnum++,
        INPUT_RENAMED: myEnum++,
        KEY_RELEASE: myEnum++,
        KEY_REPORT:myEnum++,
        LIVETV_INITED: myEnum++,
        MESSAGE_ID_CHANGED: myEnum++,
        MUTE_CHANGED: myEnum++,
        NEXT_PROGRAM_INFO: myEnum++,
        PARENTAL_LOCK_SWITCH: myEnum++,
        SIGNAL_CHANGED: myEnum++,
        SOURCE_DETECT_CHANGED: myEnum++,
        TIME_FORMAT_CHANGED: myEnum++,
        TIME_ZONE_CHANGED: myEnum++,
        USB_DEVICE_CHANGED: myEnum++,
        VIDEO_FORMAT_CHANGED: myEnum++,
        VIDEO_FORMAT_INFO_CHANGED: myEnum++,
        VOLUME_CHANGED: myEnum++,
        VOLUME_DEV_CHANGED: myEnum++,
        MENU_TIMEOUT_CHANGED: myEnum++,
        DAYLIGHT_SAVINGS_CHANGED: myEnum++,
        PARENTAL_LOCK_PIN_REQUEST: myEnum++,

        LIVETV_MAIN_PLAY_CHANGED: myEnum++,
        LIVETV_TV_SIGNAL_CHANGED: myEnum++,
        LIVETV_SOURCE_VIDEO_INFO_CHANGED: myEnum++,
        LIVETV_VIDEO_VIDEO_FORMAT_INFO_CHANGED: myEnum++,
        LIVETV_VIDEO_FRAME_ASPECT_CHANGED: myEnum++,
        LIVETV_CC_EXIST_CHANGED: myEnum++,
        LIVETV_AUDIO_EXIST_CHANGED: myEnum++,
        LIVETV_AUDIO_LANGUAGE_INFO_CHANGED: myEnum++,
        LIVETV_AUDIO_INDEX_CHANGED: myEnum++,
        LIVETV_AUDIO_IDENT_CHANGED: myEnum++,
        LIVETV_EIT_MAIN_NOW_CHANGED: myEnum++,
        LIVETV_EIT_MAIN_NEXT_CHANGED: myEnum++,
        PLAY_MAIN_PAUSE_CHANGED: myEnum++,

        NETWORK_CHANGED: myEnum++,
        NETWORK_ACCESS_POINTS_SEARCH_CHANGED:myEnum++,
        NETWORK_LINK_CHANGED:myEnum++,
        NETWORK_ETHERNET_CHANGED:myEnum++,
        NETWORK_STYLE_CHANGED : myEnum++,
        NETWORK_TEST_STATE_CHANGED : myEnum++,
        NETWORK_PIN_CODE_CHANGED : myEnum++,

        PICTURE_MODE:myEnum++,
        PICTURE_CONTRAST:myEnum++,
        PICTURE_COLOUR_INTENSITY:myEnum++,
        PICTURE_BRIGHTNESS:myEnum++,
        PICTURE_TINT:myEnum++,
        PICTURE_SHARPNESS:myEnum++,
        PICTURE_ZOOM:myEnum++,
        PICTURE_APPLY_MODE:myEnum++,
        PICTURE_HDMI_SIGNAL_FORMAT:myEnum++,
        PICTURE_OVERSCAN:myEnum++,
        PICTURE_COLOR_TEMP:myEnum++,
        PICTURE_SMOOTHR_MOTION:myEnum++,
        PICTURE_JUDDER_REDUCTION:myEnum++,
        PICTURE_BLUR_REDUCTION:myEnum++,
        PICTURE_NOISE_REDUCTION:myEnum++,
        PICTURE_HDMI_DYNAMIC_RANGE:myEnum++,
        PICTURE_ADAPTIVE_CONTRAST:myEnum++,
        PICTURE_COLOR_SPACE:myEnum++,
        PICTURE_GAMMA_ADJUSTMENT:myEnum++,
        PICTURE_RGB_ONLY_MODE:myEnum++,
        PICTURE_TUNER_COLOR:myEnum++,
        PICTURE_COLOR_HUE:myEnum++,
        PICTURE_COLOR_SATURATION:myEnum++,
        PICTURE_COLOR_BRIGHTNESS:myEnum++,
        PICTURE_COLOR_GAMUT:myEnum++,
        PICTURE_ROFFSET:myEnum++,
        PICTURE_GOFFSET:myEnum++,
        PICTURE_BOFFSET:myEnum++,
        PICTURE_RGAIN:myEnum++,
        PICTURE_GGAIN:myEnum++,
        PICTURE_BGAIN:myEnum++,
        PICTURE_APPLY_2POINT:myEnum++,
        PICTURE_BALANCE_10POINT:myEnum++,
        PICTURE_BALANCE_LEVEL:myEnum++,
        PICTURE_BALANCE_RED:myEnum++,
        PICTURE_BALANCE_GREEN:myEnum++,
        PICTURE_BALANCE_BLUE:myEnum++,
        PICTURE_APPLY_10POINT:myEnum++,

        AUDIO_SPEAKER:myEnum++,
        AUDIO_BASS_BOOST:myEnum++,
        AUDIO_SURROUND_SOUND:myEnum++,
        AUDIO_DIALOG_CLARIFY:myEnum++,
        AUDIO_WALL_MODE:myEnum++,
        DIGITAL_AUDIO_OUT:myEnum++,
        DIGITAL_AUDIO_DELAY:myEnum++,
        AUDIO_LIP_SYNC:myEnum++,
        AUDIO_FAVOURED:myEnum++,
        AUDIO_OUT:myEnum++,
        HEADPHONE_MODE:myEnum++,
        HEADPHONE_DEVICE_INSERT: myEnum++,
        AUDIO_AVC_OUTPUT:myEnum++,
        AUDIO_EQUA_120HZ:myEnum++,
        AUDIO_EQUA_500HZ:myEnum++,
        AUDIO_EQUA_1500HZ:myEnum++,
        AUDIO_EQUA_5000HZ:myEnum++,
        AUDIO_EQUA_10000HZ:myEnum++,
        AUDIO_DBX:myEnum++,

        CHANNEL_SEARCHING_PROCESS_CHANGED:myEnum++,
        CHANNEL_FOUND_DIGIT_SERVICES_CHANGED:myEnum++,
        CHANNEL_FOUND_ANALOG_SERVICES_CHANGED:myEnum++,
        CHANNEL_SEARCH_STATE_CHANGED:myEnum++,
        MIRACAST_STATUS_CHANGED:myEnum++,


        SYSTEM_CEC_DEV_NAME_CHANGED:myEnum++,
        SYSTEM_STANDBY_FLAG:myEnum++,
        SYSTEM_OTA_DETECT_NOTIFY:myEnum++,
        SYSTEM_OTA_DOWNLOAD_PROGRESS:myEnum++,
	    MPCTRL_STATE_CHANGED: myEnum++,
        MPCTRL_CURRENT_TIME_CHANGED: myEnum++,
        MPCTRL_REQATION_CHANGED:myEnum++,
        MPCTRL_TOTAL_TIME_CHANGED:myEnum++,
        MPCTRL_DLNA_PIC_RUNNING_CHANGED:myEnum++,
        MPCTRL_DLNA_HTML5_PLAY_CHANGED:myEnum++,
        MPCTRL_DLNA_RENDER_CHANGED:myEnum++,
        MPCTRL_DLNA_METADATA_CHANGED:myEnum++,
        MPCTRL_DLNA_DMRMUTE_CHANGED:myEnum++,
        MPCTRL_DLNA_DMRVOLUME_CHANGED:myEnum++,
        SET_RECENT_WATCH:myEnum++,
        BUILTIN_VIDEO_PROGRESS:myEnum++,
        BUILTIN_VIDEO_RETCODE:myEnum++,

        BLUETOOTH_DEVICES_ATTR_CHANGED:myEnum++,
        BLUETOOTH_STATUS_CHANGED:myEnum++,
        BLUETOOTH_PAIRING_INFO_CHANGED:myEnum++,
        VS_ONHISMESSAGECHANGED:myEnum++,
        AVS_ONAMAMESSAGECHANGED:myEnum++,
        MAX_COUNT:myEnum

    };

    var NFYMessages = [
        _this.MESSAGE_NAME.USB_DEVICE_CHANGED,
        _this.MESSAGE_NAME.HISMART_DATA,
        _this.MESSAGE_NAME.SOURCE_DETECT_CHANGED
    ];
    var noResponseInFACM = [
        _this.MESSAGE_NAME.USB_DEVICE_CHANGED,
        _this.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED,
        _this.MESSAGE_NAME.MUTE_CHANGED,
        _this.MESSAGE_NAME.SIGNAL_CHANGED,
        _this.MESSAGE_NAME.VOLUME_CHANGED,
        _this.MESSAGE_NAME.VOLUME_DEV_CHANGED,
        _this.MESSAGE_NAME.VIDEO_FORMAT_CHANGED,
        _this.MESSAGE_NAME.CEC_CHANGE_SOURCE
    ];
    var unProcessedNFY = {};

    var funcs = [];

    function publishMessage(msg, val) {
        if (!funcs[msg]) return;
        funcs[msg].forEach(
            function (item) {
                try {
                    item.apply(_this, val);
                }
                catch (ex) {
                    DBG_ERROR("func[" + item.name + "], error[" + ex.message + "]");
                }
            }
        );
    }

    function publishUIMessage() {
        var args = Array.prototype.slice.call(arguments);
        var msg = args.shift();
        publishMessage(msg, args);
    }
    function FuncArrayExist(msg){
       if(funcs[msg]!=undefined) {
           return true;
       }else{
       return false;
       }
    }
    function onTVModelChanged() {
        var args = Array.prototype.slice.call(arguments);
        var msg = args.shift();
        return msg;
        if (1 == GLOBAL.FACTORY && noResponseInFACM.indexOf(msg) > -1) return false;
        if (NFYMessages.indexOf(msg) > -1) addNotification(msg, args);
        //do global operation
        switch (msg) {
            case _this.MESSAGE_NAME.PARENTAL_LOCK_SWITCH:
                GLOBAL.PARENTAL_LOCK_SWITCH = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CURRENT_SOURCE_CHANGED:
                DBG_ERROR("current source changed: " + args[0]);
                GLOBAL.SOURCE_CHANGING = false;
                clearTimeout(GLOBAL.SOURCE_CHANGING_TIMER);

                if (LiveTVSourceMap[args[0]] != undefined) {
                    GLOBAL.CURRENT_SOURCE = mapInputsDataByPlayId(args[0]);
                }
                else {
                    GLOBAL.CURRENT_SOURCE = SourceList.TV;
                }
                DBG_ERROR("GLOBAL.CURRENT_SOURCE is " + GLOBAL.CURRENT_SOURCE);

                if (SourceList.TV == GLOBAL.CURRENT_SOURCE) {
                    GLOBAL.S_NO_SIGNAL = (model.tvservice.getNoSignalMain() == 1);
                }
                else {
                    var crntSourceObj = liveTV.getCurrentSourceObj();
                    DBG_ERROR("crntSourceObj is " + objToString(crntSourceObj));
                    GLOBAL.S_NO_SIGNAL = (crntSourceObj.signal == SvrMsg.NO_SIGNAL);
                }
                fetchSignalAndPublish();
                break;
            case _this.MESSAGE_NAME.SIGNAL_CHANGED:
                GLOBAL.NO_SIGNAL = (1 == args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_ARC_STATE_CHANGED:
                GLOBAL.CEC_ARC_STATE = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_CONTROL_CHANGED:
                GLOBAL.CEC_CONTROL = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED:
                GLOBAL.CEC_DEVICE_EXIST = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.TIME_FORMAT_CHANGED:
                GLOBAL.TIME_FORMAT = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.TIME_ZONE_CHANGED:
                GLOBAL.TIMEZONE_SECONDS = args[0];
                break;
            case _this.MESSAGE_NAME.DEVIATION_FROM_UTC_CHANGED:
                DBG_ERROR("deviation from utc change: " + args[0]);
                GLOBAL.DEVIATION_FROM_UTC = args[0];
                break;
            case _this.MESSAGE_NAME.MENU_TIMEOUT_CHANGED:
                GLOBAL.SETTING_TIMEOUT_DELAY = 1000 * parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CURRENT_COUNTRY_CHANGED:
                GLOBAL.CURRENT_COUNTRY = ChangeCountryNumToCode(args[0]);
                DBG_ALWAYS(" GLOBAL.CURRENT_COUNTRY"+ GLOBAL.CURRENT_COUNTRY);
                updateDateFormat();
                //delete the appinfo file, to fresh the appdate for app settings .
                Hisense.File.delete("launcher/settingappinfo.txt", 1);
                break;
            case _this.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED:
                DBG_ALWAYS(" LANUAGE CHANGED");
                GLOBAL.CURRENT_LANGUAGE = ChangeLangNumToCode(args[0]);
                updateDateFormat();
                break;
            case _this.MESSAGE_NAME.DAYLIGHT_SAVINGS_CHANGED:
                DBG_ERROR("DAYLIGHT SAVINGS CHANGED: " + args[0]);
                GLOBAL.DST_SECONDS = 0;//(parseInt(args[0]) * 3600);
                break;
            case _this.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST:
                DBG_ALWAYS("PARENTAL_LOCK_PIN_REQUEST:"+args);
                break;
            case _this.MESSAGE_NAME.USB_DEVICE_CHANGED:
                DBG_ERROR("USB DEVICE CHANGED: " + args[0]);
                break;
            default :
                break;
        }
        publishMessage(msg, args);
    }

    function subjectMessage(msg, func) {
        //DBG_INFO("subject msg[" + msg + "], func[" + func.name + "]");
        if (!funcs[msg]) funcs[msg] = [];
        unsubscribeMessage(msg, func);
        funcs[msg].push(func);
    }

    function unsubscribeMessage(msg, func) {
        //DBG_INFO("unsbuject msg[" + msg + "], func[" + func.name + "]");
        if (!funcs[msg]) return;
        funcs[msg] = funcs[msg].filter(
            function (item) {
                if (item !== func) {
                    return item;
                }
            }
        );
    }

    function addNotification(msg, args) {
        if (!funcs[msg]) return;
        var item = {
            "MsgName": msg,
            "MsgId": msgIdEnum++,
            "date": getSystemLongTimeForNotification(),
            "data": args,
            "cmd": ""
        }

        //Temp. Actually, We should not do these operations here.
        switch (msg) {
            case _this.MESSAGE_NAME.USB_DEVICE_CHANGED:
                item.cmd = LauncherCMD.HIMEDIA;
//                deleteNotificationByMsg(msg, null);
                break;
            case _this.MESSAGE_NAME.SOURCE_DETECT_CHANGED:
                item.cmd = LauncherCMD.INPUT;
                break;
            default :
                return;
        }
        if(!unProcessedNFY[msg]) {
            unProcessedNFY[msg] = [item];
        }
        else{
            unProcessedNFY[msg].push(item);
        }
    }

    function getNotifications() {
        return unProcessedNFY;
    }

    function clearNotifications() {
        unProcessedNFY = {};
        return true;
    }

    function deleteNotificationByMsg(msg, id) {
        if(null == id) {
            delete unProcessedNFY[msg];
        }
        else{
            var allMsg = unProcessedNFY[msg];
            for (var i = 0; i < allMsg.length; i++) {
                if (allMsg[i].MsgId == id) {
                    allMsg.splice(i, 1);
                    break;
                }
            }
        }
    }

    _this.getNotifications = getNotifications;
    _this.clearNotifications = clearNotifications;
    _this.deleteNotificationByMsg = deleteNotificationByMsg;
    _this.subscribeMessage = subjectMessage;
    _this.unsubscribeMessage = unsubscribeMessage;
    _this.publishMessage = onTVModelChanged;
    _this.FuncArrayExist=FuncArrayExist;

    _this.registerNotify = function() {
        try {
            model.tvservice.getChannelNowPfInfoCallBack = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CURRENT_PROGRAM_INFO);
            model.tvservice.getChannelNextPfInfoCallBack = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.NEXT_PROGRAM_INFO);
            model.tvservice.onMainPlayVideoFormatInfoChanged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.VIDEO_FORMAT_INFO_CHANGED);
            model.tvservice.onMainPlayAudioFormatInfoChanged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.AUDIO_FORMAT_INFO_CHANGED);
            model.source.onCurrentSourceChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CURRENT_SOURCE_CHANGED);
            model.tvservice.onCurrentSourceVideoFormatChanged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.VIDEO_FORMAT_CHANGED);
            model.parentlock.onSModelChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.PARENTAL_LOCK_SWITCH);
            model.parentlock.onPinRequestChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST);
            model.source.onInputCurrentInLockChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CURRENT_INPUT_LOCK_CHANGED);
            model.source.onInputRenameCallback = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.INPUT_RENAMED);
            model.cec.onCecSourceChanged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CEC_CHANGE_SOURCE);
            model.sound.onMainMuteChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.MUTE_CHANGED);
            model.sound.onMainVolumeChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.VOLUME_CHANGED);
            model.sound.onMainVolumeDevChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.VOLUME_DEV_CHANGED);
            model.channelSearch.onFavSetCallback = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CHANNEL_FAV_SET);
            model.channelSearch.onSkipSetCallback = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CHANNEL_SKIP_SET);
            //model.system.onAmStateChanged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.AM_STATE_CHANGED);
            model.sound.onArcDevExistChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED);
            model.cec.onHdmiDevicesArcStateChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CEC_ARC_STATE_CHANGED);
            model.cec.onFunctionalityChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CEC_CONTROL_CHANGED);
            model.basicSetting.onTvsetLocationChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CURRENT_COUNTRY_CHANGED);
            model.language.onOsdChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED);
            model.datetime.onNewAreaTimeZoneChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.TIME_ZONE_CHANGED);
            model.datetime.onDeviationFromutcChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.DEVIATION_FROM_UTC_CHANGED);
            model.datetime.onTimeFormatChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.TIME_FORMAT_CHANGED);
            model.basicSetting.onMenuDelayDisappearChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.MENU_TIMEOUT_CHANGED);
            model.source.onSourceStatusChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.SOURCE_DETECT_CHANGED);
            model.volume.onVstrLatestEventChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.USB_DEVICE_CHANGED);
            model.datetime.onDaylightSavingsChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.DAYLIGHT_SAVINGS_CHANGED);
            model.message.onMessageidChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MESSAGE_ID_CHANGED);

            //liveTV
            model.tvservice.onMainPlayChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_MAIN_PLAY_CHANGED);
            model.tvservice.onNoSignalMainChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_TV_SIGNAL_CHANGED);
            model.servicemode.onSourceVideoInfoChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_SOURCE_VIDEO_INFO_CHANGED);
            model.video.onVideoFormatInfoChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_VIDEO_VIDEO_FORMAT_INFO_CHANGED);
            model.video.onVideoFrameAspectChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_VIDEO_FRAME_ASPECT_CHANGED);
            model.video.onCcExistChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_CC_EXIST_CHANGED);
            model.tvservice.onAudioExistChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_AUDIO_EXIST_CHANGED);
            model.tvservice.onAudioLanguageInfoChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_AUDIO_LANGUAGE_INFO_CHANGED);
            model.tvservice.onAudioIndexChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_AUDIO_INDEX_CHANGED);
            model.sound.onAudioIdentChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_AUDIO_IDENT_CHANGED);
            model.tvservice.onEitMainNowChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_EIT_MAIN_NOW_CHANGED);
            model.tvservice.onEitMainNextChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.LIVETV_EIT_MAIN_NEXT_CHANGED);

            //Start picture
            model.video.onEnumPictureModeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_MODE);
            model.video.onContrastChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_CONTRAST);
            model.video.onColourIntensityChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOUR_INTENSITY);
            model.video.onBrightnessChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BRIGHTNESS);
            model.video.onTintChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_TINT);
            model.video.onSharpnessChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_SHARPNESS);
            model.video.onEnumZoomChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_ZOOM);
            model.video.onApplyModeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_APPLY_MODE);
            model.video.onHdmiSignalFormatChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_HDMI_SIGNAL_FORMAT);

            model.video.onOverscanChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_OVERSCAN);
            model.video.onEnumColourTemperatureChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOR_TEMP);
            model.video.onEnumSmoothMotionChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_SMOOTHR_MOTION);
            model.video.onJudderReductionChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_JUDDER_REDUCTION);
            model.video.onBlurReductionChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BLUR_REDUCTION);
            model.video.onEnumNoiseReductionChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_NOISE_REDUCTION);
            model.video.onHdmiDynamicRangeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_HDMI_DYNAMIC_RANGE);
            model.video.onAdaptiveContrastChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_ADAPTIVE_CONTRAST);
            model.video.onColorSpaceChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOR_SPACE);
            model.video.onHdmiGammaAdjustmentChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_GAMMA_ADJUSTMENT);
            model.video.onRgbOnlyModeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_RGB_ONLY_MODE);

            model.video.onColorChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_TUNER_COLOR);
            model.video.onColorHueChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOR_HUE);
            model.video.onColorSaturationChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOR_SATURATION);
            model.video.onColorBrightnessChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_COLOR_BRIGHTNESS);

            model.video.onRoffsetChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_ROFFSET);
            model.video.onGoffsetChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_GOFFSET);
            model.video.onBoffsetChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BOFFSET);
            model.video.onRgainChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_RGAIN);
            model.video.onGgainChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_GGAIN);
            model.video.onBgainChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BGAIN);
            model.video.onApply2p_wbChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_APPLY_2POINT);

            model.video.onWhite_balance10PointChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BALANCE_10POINT);
            model.video.onLevelChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BALANCE_LEVEL);
            model.video.onRedChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BALANCE_RED);
            model.video.onGreenChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BALANCE_GREEN);
            model.video.onBlueChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_BALANCE_BLUE);
            model.video.onApply10p_wbChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PICTURE_APPLY_10POINT);
            //picture end

            //Audio start
            model.sound.onSpeakerArcChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_SPEAKER);
            model.sound.onDTSBassBoostChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_BASS_BOOST);
            model.sound.onDTSSurroundSoundChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_SURROUND_SOUND);
            model.sound.onDTSDialogClarifyChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_DIALOG_CLARIFY);
            model.sound.onWallModeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_WALL_MODE);

            model.sound.onDigitalAudioOutChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.DIGITAL_AUDIO_OUT);
            model.sound.onDigitalAudioDelayChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.DIGITAL_AUDIO_DELAY);
            model.sound.onLipsyncChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_LIP_SYNC);
            model.language.onAudioFavouredChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_FAVOURED);
            model.sound.onAudioOutChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_OUT);
            model.sound.onHeadphoneModeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.HEADPHONE_MODE);
            model.sound.onHeadphoneInsertChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT);
            model.sound.onAvcOutputChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_AVC_OUTPUT);

            model.sound.onEqualizerFreq120hzChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_EQUA_120HZ);
            model.sound.onEqualizerFreq500hzChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_EQUA_500HZ);
            model.sound.onEqualizerFreq1k5hzChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_EQUA_1500HZ);
            model.sound.onEqualizerFreq5khzChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_EQUA_5000HZ);
            model.sound.onEqualizerFreq10khzChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_EQUA_10000HZ);
            model.sound.ongetTotalSonicschaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.AUDIO_DBX);
            //Audio end
            //channel start
            model.channelSearch.onSearchingProgressChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.CHANNEL_SEARCHING_PROCESS_CHANGED);
            model.channelSearch.onFoundDigitServicesChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.CHANNEL_FOUND_DIGIT_SERVICES_CHANGED);
            model.channelSearch.onFoundAnalogServicesChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.CHANNEL_FOUND_ANALOG_SERVICES_CHANGED);
            model.channelSearch.onSearchStateChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.CHANNEL_SEARCH_STATE_CHANGED);
            //channel end
            //miracast start
            model.miracast.onStatusChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MIRACAST_STATUS_CHANGED);
            //miracast end
            model.tvservice.onPlayMainPauseChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.PLAY_MAIN_PAUSE_CHANGED);

            //network start
            model.network.onEnumNetworkAvailableChaged = onTVModelChanged.bind(_this, _this.MESSAGE_NAME.NETWORK_CHANGED);
            model.network.onEnumAccess_pointsSearchChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED);
            model.network.onEnumLinkChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_LINK_CHANGED);
            model.network.onEthernetConnected = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_ETHERNET_CHANGED);
            model.network.onEnumNetworkingChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_STYLE_CHANGED);
            model.network.onEnumTestStateChaged  = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_TEST_STATE_CHANGED);
            model.network.onWpsPinCodeChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.NETWORK_PIN_CODE_CHANGED);
            //network end

            model.cec.onHdmiDevicesNameChaged =onTVModelChanged.bind(_this,_this.MESSAGE_NAME.SYSTEM_CEC_DEV_NAME_CHANGED);
            model.timerfunc.onPowerOffflagchanged= onTVModelChanged.bind(_this,_this.MESSAGE_NAME.SYSTEM_STANDBY_FLAG);
            model.softupdate.onAutoAnnouncementChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.SYSTEM_OTA_DETECT_NOTIFY);
            model.softupdate.onDownloadProgressChaged=onTVModelChanged.bind(_this,_this.MESSAGE_NAME.SYSTEM_OTA_DOWNLOAD_PROGRESS);
	    
	        //mpctrl start
	        model.mpctrl.onMpCtrlStatchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_STATE_CHANGED);
            model.mpctrl.onMpCtrlPlaytimeCurrentchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED);
            //model.mpctrl.onMpCtrlReqationchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_REQATION_CHANGED);
            model.mpctrl.onMpCtrlPlaytimeTotalchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_TOTAL_TIME_CHANGED);

            model.picture.onDLNAPictureRunningchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_PIC_RUNNING_CHANGED);
            model.picture.onVstrHTML5PlayChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_HTML5_PLAY_CHANGED);
            model.mpctrl.onMpCtrlRenderchanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_RENDER_CHANGED);
            model.mpctrl.onMetadataChanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED);
            model.mpctrl.onMpCtrlDMRMutechanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_DMRMUTE_CHANGED);
            model.mpctrl.onMpCtrlDMRVolumechanged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.MPCTRL_DLNA_DMRVOLUME_CHANGED);
            //mpctrl end
            //update video
            model.system.onUpgradeBuiltInVideoProgress = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.BUILTIN_VIDEO_PROGRESS);
            model.system.onUpgradeBuiltInVideoRetcode = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.BUILTIN_VIDEO_RETCODE);
            //update video

            //bluetooth start
            model.bluetooth.onDevicesAddrChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.BLUETOOTH_DEVICES_ATTR_CHANGED);
            model.bluetooth.onBluetoothStatusChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.BLUETOOTH_STATUS_CHANGED);
            model.bluetooth.onPairingInfoChaged = onTVModelChanged.bind(_this,_this.MESSAGE_NAME.BLUETOOTH_PAIRING_INFO_CHANGED);
            //bluetooth end
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    }
}
MessagePool.prototype.constructor = MessagePool;
