/**
 * Created by jiangbo1 on 2016/1/26.
 */

function MessagePool() {
    var myEnum = 0, _this = this, msgIdEnum = 0;
    _this.MESSAGE_NAME = {
        BLUETOOTH_DEVICES_ATTR_CHANGED: "de.loewe.sl2.vint32.bluetooth.device.attributes",
        BLUETOOTH_DEVICES_NAME_CHANGED: "de.loewe.sl2.vstr.bluetooth.device.name",
        BLUETOOTH_PAIRING_INFO_CHANGED: "de.loewe.sl2.vstr.bluetooth.pairing.info",
        BLUETOOTH_STATUS_CHANGED: "de.loewe.sl2.i32.bluetooth.enum.status",
        BLUETOOTH_RC_PAIRED:"de.loewe.sl2.i32.bluetooth.remote.connect.state",
        VIDEO_FORMAT_INFO_CHANGED : "tvapi.str.tvservice.video.format.info",
        CURRENT_SOURCE_CHANGED : "de.loewe.sl2.str.source.input.current",
        VIDEO_FORMAT_CHANGED : "tvapi.str.tvservice.source.video.format.info",
        PARENTAL_LOCK_SWITCH : "de.loewe.sl2.i32.parental.lock.switch.mode",
        PARENTAL_LOCK_PIN_REQUEST : "de.loewe.sl2.vstr.parental.lock.pin.request",
        CURRENT_INPUT_LOCK_CHANGED : "tvapi.i32.system.input.current.inLock",
        CEC_CHANGE_SOURCE : "tvapi.i32.cec.hdmi.device.requestsourcechange",
        VOLUME_CHANGED : "de.loewe.sl2.i32.sound.main.volume",
        VOLUME_DEV_CHANGED : "de.loewe.sl2.i32.sound.main.volume.dev",
        CEC_DEVICE_EXIST_CHANGED : "de.loewe.sl2.i32.sound.arcdev.exist",
        CEC_ARC_STATE_CHANGED : "de.loewe.sl2.i32.cec.amp.audiomode",
        CEC_CONTROL_CHANGED : "de.loewe.sl2.i32.cec.functionality",
        CURRENT_COUNTRY_CHANGED : "de.loewe.sl2.i32.basic.settings.tvset.location",
        CURRENT_LANGUAGE_CHANGED : "de.loewe.sl2.i32.language.osd",
        TIME_ZONE_CHANGED : "de.loewe.sl2.i32.datetime.deviation.timezone",
        DEVIATION_FROM_UTC_CHANGED : "de.loewe.sl2.i32.datetime.deviation.fromutc",
        DEVICE_ID_CHANGED : "de.loewe.sl2.str.network.device.id",
        TIME_FORMAT_CHANGED : "de.loewe.sl2.i32.datetime.format",
        MENU_TIMEOUT_CHANGED : "de.loewe.sl2.i32.basic.settings.menu.delay.disappear",
        PARENT_LOCK_RESET :  "de.loewe.sl2.action.parental.lock.reset",
        OTA_DETECT_REPORT : "de.loewe.sl2.action.software.update.start.search.update",
        SOURCE_DETECT_CHANGED : "de.loewe.sl2.str.sourcedection.sourcestatus",
        INPUT_NAME_CHANGED: "de.loewe.sl2.vstr.source.input.name",
        USB_DEVICE_CHANGED : "de.loewe.sl2.volume.vstr.latest.event",
        DAYLIGHT_SAVINGS_CHANGED : "de.loewe.sl2.i32.datetime.daylight.saving.time",
        MESSAGE_ID_CHANGED : "de.loewe.sl2.messages.messageid",
        LIVETV_MAIN_PLAY_CHANGED : "de.loewe.sl2.vstr.tvservice.play.main",
        LIVETV_TV_SIGNAL_CHANGED : "de.loewe.sl2.i32.tvservice.nosignal.main",
        LIVETV_SOURCE_VIDEO_INFO_CHANGED : "de.loewe.sl2.str.servicemode.videoinfo.source",
        LIVETV_VIDEO_VIDEO_FORMAT_INFO_CHANGED : "de.loewe.sl2.str.video.format.info",
        LIVETV_VIDEO_FRAME_ASPECT_CHANGED : "de.loewe.sl2.str.video.frame.aspect",
        LIVETV_CC_EXIST_CHANGED : "de.loewe.sl2.i32.video.cc.exist",
        LIVETV_AUDIO_EXIST_CHANGED : "de.loewe.sl2.i32.tvservice.audio.exist",
        LIVETV_AUDIO_LANGUAGE_INFO_CHANGED : "de.loewe.sl2.str.tvservice.audio.info",
        LIVETV_AUDIO_INDEX_CHANGED : "de.loewe.sl2.i32.tvservice.audio.index",
        LIVETV_AUDIO_FORMAT_CHANGED: "de.loewe.sl2.str.audio.diagnosis.info",
        DIANOSIS_VIDEO_FORMAT_CHANGED:"de.loewe.sl2.str.video.diagnosis.info",
        LIVETV_AUDIO_ONLY_CHANGED : "de.loewe.sl2.i32.tvservice.audio.only",
        LIVETV_EIT_MAIN_NOW_CHANGED : "de.loewe.sl2.vstr.tvservice.eit.main-now",
        LIVETV_EIT_MAIN_NEXT_CHANGED : "de.loewe.sl2.vstr.tvservice.eit.main-next",
        PICTURE_MODE : "de.loewe.sl2.i32.video.enum.picture.adjustment",
        PICTURE_CONTRAST : "de.loewe.sl2.i32.video.contrast",
        PICTURE_COLOUR_INTENSITY : "de.loewe.sl2.i32.video.colour.intensity",
        PICTURE_BRIGHTNESS : "de.loewe.sl2.i32.video.brightness",
        PICTURE_TINT : "de.loewe.sl2.i32.video.hue",
        PICTURE_SHARPNESS : "de.loewe.sl2.i32.video.sharpness",
        PICTURE_ZOOM : "de.loewe.sl2.i32.video.format",
        PICTURE_APPLY_MODE : "de.loewe.sl2.i32.video.apply.mode",
        PICTURE_HDMI_SIGNAL_FORMAT : "de.loewe.sl2.i32.video.enum.hdmi.signal.format",
        PICTURE_OVERSCAN : "de.loewe.sl2.i32.video.overscan",
        PICTURE_COLOR_TEMP : "de.loewe.sl2.i32.video.enum.colour.temperature",
        PICTURE_SMOOTHR_MOTION : "de.loewe.sl2.i32.video.enum.memc",
        PICTURE_JUDDER_REDUCTION : "de.loewe.sl2.i32.video.judder.reduction",
        PICTURE_BLUR_REDUCTION : "de.loewe.sl2.i32.video.blur.reduction",
        PICTURE_NOISE_REDUCTION : "de.loewe.sl2.i32.video.enum.dnc",
        PICTURE_HDMI_DYNAMIC_RANGE : "de.loewe.sl2.i32.video.hdmi.range",
        PICTURE_ADAPTIVE_CONTRAST : "de.loewe.sl2.i32.video.dynamic.contrast",
        PICTURE_COLOR_SPACE : "de.loewe.sl2.i32.video.color.space",
        PICTURE_GAMMA_ADJUSTMENT : "de.loewe.sl2.i32.video.gamma",
        PICTURE_GAMMA_CALIBRATION_LEVEL : "de.loewe.sl2.i32.video.gamma.calibration.level",
        PICTURE_GAMMA_CALIBRATION_GAIN : "de.loewe.sl2.i32.video.gamma.calibration.gain",
        PICTURE_RGB_ONLY_MODE : "de.loewe.sl2.i32.video.rgb.only",
        PICTURE_TUNER_COLOR : "de.loewe.sl2.i32.video.color.tuner",
        PICTURE_COLOR_HUE : "de.loewe.sl2.i32.video.color.tuner.hue",
        PICTURE_COLOR_SATURATION : "de.loewe.sl2.i32.video.color.tuner.sat",
        PICTURE_COLOR_BRIGHTNESS : "de.loewe.sl2.i32.video.color.tuner.luma",
        PICTURE_ROFFSET : "de.loewe.sl2.i32.video.roffset",
        PICTURE_GOFFSET : "de.loewe.sl2.i32.video.goffset",
        PICTURE_BOFFSET : "de.loewe.sl2.i32.video.boffset",
        PICTURE_RGAIN : "de.loewe.sl2.i32.video.rgain",
        PICTURE_GGAIN : "de.loewe.sl2.i32.video.ggain",
        PICTURE_BGAIN : "de.loewe.sl2.i32.video.bgain",
        PICTURE_BALANCE_10POINT : "de.loewe.sl2.i32.video.10point.wb.enable",
        PICTURE_BALANCE_LEVEL : "de.loewe.sl2.i32.video.10point.wb.level",
        PICTURE_BALANCE_RED : "de.loewe.sl2.i32.video.10point.wb.red",
        PICTURE_BALANCE_GREEN : "de.loewe.sl2.i32.video.10point.wb.green",
        PICTURE_BALANCE_BLUE : "de.loewe.sl2.i32.video.10point.wb.blue",
        PICTURE_BALANCE_20POINT: "de.loewe.sl2.i32.video.20point.wb.enable",
        PICTURE_BALANCE_20POINT_BLUE: "de.loewe.sl2.i32.video.20point.wb.blue",
        PICTURE_BALANCE_20POINT_GREEN: "de.loewe.sl2.i32.video.20point.wb.green",
        PICTURE_BALANCE_20POINT_RED: "de.loewe.sl2.i32.video.20point.wb.red",
        PICTURE_BALANCE_20POINT_LEVEL: "de.loewe.sl2.i32.video.20point.wb.level",
        AUDIO_SPEAKER : "de.loewe.sl2.i32.sound.speaker.arc.mode",
        AUDIO_BASS_BOOST : "de.loewe.sl2.i32.sound.dts.bass.boost",
        AUDIO_SURROUND_SOUND : "de.loewe.sl2.i32.sound.dts.surround.sound",
        AUDIO_DIALOG_CLARIFY : "de.loewe.sl2.i32.sound.dts.dialog.clarity",
        AUDIO_WALL_MODE : "de.loewe.sl2.i32.sound.wallmount",
        DIGITAL_AUDIO_OUT : "de.loewe.sl2.i32.sound.spdif.mode",
        DIGITAL_AUDIO_DELAY : "de.loewe.sl2.i32.sound.spdif.delay.time",
        AUDIO_LIP_SYNC : "de.loewe.sl2.i32.sound.lipsync",
        AUDIO_FAVOURED : "de.loewe.sl2.i32.language.audio.favoured",
        AUDIO_OUT : "de.loewe.sl2.i32.sound.audio.out",
        HEADPHONE_MODE : "de.loewe.sl2.i32.sound.headphone.mode",
        HEADPHONE_DEVICE_INSERT : "de.loewe.sl2.i32.sound.headphone.exist",
        AUDIO_AVC_OUTPUT: "de.loewe.sl2.vint32.sound.avc.output",
        AUDIO_EQUA_120HZ : "de.loewe.sl2.i32.sound.equalizer.freq.120hz",
        AUDIO_EQUA_500HZ : "de.loewe.sl2.i32.sound.equalizer.freq.500hz",
        AUDIO_EQUA_1500HZ : "de.loewe.sl2.i32.sound.equalizer.freq.1k5hz",
        AUDIO_EQUA_5000HZ : "de.loewe.sl2.i32.sound.equalizer.freq.5khz",
        AUDIO_EQUA_10000HZ : "de.loewe.sl2.i32.sound.equalizer.freq.10khz",
        AUDIO_EQUA_RESET:"de.loewe.sl2.action.sound.reset.equalizer",
        AUDIO_DBX:"de.loewe.sl2.vint32.sound.dbx",
        CHANNEL_SEARCHING_PROCESS_CHANGED : "de.loewe.sl2.i32.channel.search.searching.progress",
        CHANNEL_FOUND_DIGIT_SERVICES_CHANGED : "de.loewe.sl2.i32.channel.search.found.services",
        CHANNEL_FOUND_ANALOG_SERVICES_CHANGED : "de.loewe.sl2.i32.channel.search.found.analogservices",
        CHANNEL_SEARCH_STATE_CHANGED : "de.loewe.sl2.tvapi.i32.channel.search.search.state",
        MIRACAST_STATUS_CHANGED : "de.loewe.sl2.i32.miracast.status",
        NETWORK_CHANGED : "de.loewe.sl2.i32.local.network.available",
        NETWORK_ACCESS_POINTS_SEARCH_CHANGED : "de.loewe.sl2.i32.network.enum.access-points.search",
        NETWORK_LINK_CHANGED : "de.loewe.sl2.i32.network.enum.link",
        NETWORK_ETHERNET_CHANGED : "de.loewe.sl2.i32.network.enum.interface.state",
        NETWORK_STYLE_CHANGED : "de.loewe.sl2.i32.network.enum.networking",
        NETWORK_TEST_STATE_CHANGED : "de.loewe.sl2.i32.network.enum.test.state",
        NETWORK_PIN_CODE_CHANGED : "de.loewe.sl2.str.network.wps.pin.code",
        SYSTEM_CEC_DEV_NAME_CHANGED : "de.loewe.sl2.cec.input.names",
        USB_UPGRADE_PACK_NUM: "de.loewe.sl2.volume.action.start.search.usb.bin",
        SYSTEM_STANDBY_FLAG : "de.loewe.sl2.i32.timerfunctions.switch.off.notify",
        CHANNEL_LIST_NAME_UPDATE : "tvapi.i32.tvservice.list.name.update",
        CHANNEL_LIST_UPDATE : "de.loewe.sl2.i32.tvservice.list.update",
        GET_NAME_TO_INFO : "de.loewe.sl2.vstr.tvservice.channel.name.to.info",
        AUDIO_FORMAT_INFO_CHANGED	:	"tvapi.str.tvservice.audio.information",
        CHANNEL_FAV_SET	:	"tvapi.action.atsc.channel.search.favourite.set",
        CHANNEL_SKIP_SET	:	"tvapi.action.atsc.channel.search.skip.set",
        CURRENT_PROGRAM_INFO	:	"tvapi.action.tvservice.get.pfinfo",
        INPUT_RENAMED 	:	"de.loewe.sl2.action.source.input.rename",
        MPCTRL_CURRENT_TIME_CHANGED 	:	"de.loewe.sl2.mpctrl.i32.playtime.current",
        MPCTRL_DLNA_HTML5_PLAY_CHANGED	:	"de.loewe.sl2.picture.vstr.html5.play",
        MPCTRL_DLNA_METADATA_CHANGED	:	"de.loewe.sl2.mpctrl.vstr.metadata",
        MPCTRL_DLNA_DMRMUTE_CHANGED     :   "de.loewe.sl2.mpctrl.i32.dmr.mute",
        MPCTRL_DLNA_DMRVOLUME_CHANGED   :   "de.loewe.sl2.mpctrl.i32.dmr.volume",
        MPCTRL_DLNA_PIC_RUNNING_CHANGED	:	"de.loewe.sl2.picture.dlna.running",
        MPCTRL_DLNA_RENDER_CHANGED	:	"de.loewe.sl2.mpctrl.i32.gui.render",
        MPCTRL_REQATION_CHANGED	:	"de.loewe.sl2.mpctrl.reqaction",
        MPCTRL_STATE_CHANGED 	:	"de.loewe.sl2.mpctrl.vstr.state",
        MPCTRL_TOTAL_TIME_CHANGED	:	"de.loewe.sl2.mpctrl.i32.playtime.total",
        MUTE_CHANGED 	:	"de.loewe.sl2.i32.sound.main.mute",
        NEXT_PROGRAM_INFO	:	"tvapi.action.tvservice.get.pfinfo2",
        SYSTEM_OTA_DETECT_NOTIFY	:	"de.loewe.sl2.i32.software.update.auto.check.result",
        SYSTEM_OTA_DOWNLOAD_PROGRESS	:	"de.loewe.sl2.i32.software.update.download.progress",
        SYTEM_NTP_TIME_CHANGED:"de.loewe.sl2.i32.datetime.system.time.validity",
        SYSTEM_PWR_USE_CASE : "de.loewe.sl2.i32.system.enum.pwr.use.case",
        SYSTEM_STOREMODE_UPGRADE_VIDEO_PROGRESS : "de.loewe.sl2.i32.storemode.copy.progress",
        SYSTEM_STOREMODE_COPY_RETURN_CODE : "de.loewe.sl2.i32.storemode.copy.retcode",
        PICTURE_COLOR_GAMUT	:	"PICTURE_COLOR_GAMUT",
        REGISTER_NOTIFY_FINISH: "REGISTER_NOTIFY_FINISH",
        SIGNAL_CHANGED	:	"SIGNAL_CHANGED",
        AM_STATE_CHANGED	:	"AM_STATE_CHANGED",
        CHANNEL_UPDATED	:	"CHANNEL_UPDATED",
        CURRENT_CHANNEL_CHANGED	:	"CURRENT_CHANNEL_CHANGED",
        KEY_RELEASE 	:	"KEY_RELEASE",
        KEY_REPORT	:	"KEY_REPORT",
        LIVETV_INITED	:	"LIVETV_INITED",
        ENTER_SUSPEND_MODE	:	"ENTER_SUSPEND_MODE",
        FACTORY_MODE_CHANGED	:	"FACTORY_MODE_CHANGED",
        HISMART_DATA 	:	"HISMART_DATA",
        PICTURE_APPLY_20POINT	:	"PICTURE_APPLY_20POINT",
        PICTURE_APPLY_10POINT	:	"PICTURE_APPLY_10POINT",
        PICTURE_APPLY_2POINT	:	"PICTURE_APPLY_2POINT",
	    SET_RECENT_WATCH:"SET_RECENT_WATCH",

        //languageList current
        AVS_CUR_LANGUAGE:"de.loewe.sl2.str.avs.current.language.locale",
        AVS_LANGUAGE_RESULT:"de.loewe.sl2.i32.avs.set.language.status",

        AVS_ONSETALEXALANGUAGERESULT:"AVS_ONSETALEXALANGUAGERESULT",
        AVS_ONCULANGUAGE:"AVS_ONCULANGUAGE",
        /////

        //for avs
        AVS_ONSPEECHSTATECHANGED: "AVS_ONSPEECHSTATECHANGED",
        AVS_ONAMAZONREGISTERRESULT: "AVS_ONAMAZONREGISTERRESULT",
        AVS_ONHISENSEREGISTERRESULT: "AVS_ONHISENSEREGISTERRESULT",
        AVS_ONHISENSEDEVICEREPORTRESULT: "AVS_ONHISENSEDEVICEREPORTRESULT",
        AVS_ONHISMESSAGECHANGED:"AVS_ONHISMESSAGECHANGED",
        AVS_ONAMAMESSAGECHANGED:"AVS_ONAMAMESSAGECHANGED",



        AVS_RECOG_STATE: "de.loewe.sl2.i32.avs.recogintion.state",
        AVS_DISPLAY_CARDS: "de.loewe.sl2.str.avs.display.cards",
        AVS_RECOG_ERRCODE: "de.loewe.sl2.i32.avs.recogintion.error.code",
        AVS_AUTH_CODE: "de.loewe.sl2.str.avs.auth.code",
        AVS_AUTH_RESULT: "de.loewe.sl2.i32.avs.auth.result",
        AVS_LOGIN_STATUS: "de.loewe.sl2.i32.avs.login.status",
        AVS_USER_PROFILE: "de.loewe.sl2.str.avs.user.profile",
        AVS_HIAUTH_TOKEN: "de.loewe.sl2.str.avs.hiauth.token",
        AVS_HIAUTH_INFO: "de.loewe.sl2.str.avs.hiauth.info",
        AVS_HIAUTH_RESULT:"de.loewe.sl2.i32.avs.hiauth.result",
        AVS_HILOGIN_STATUS: "de.loewe.sl2.i32.avs.hilogin.status",
        AVS_HIUSER_PROFILE: "de.loewe.sl2.str.avs.hiuser.profile",
        AVS_HIDEV_REPORT: "de.loewe.sl2.i32.avs.hireport.devinfo.result",
        AVS_ALARM_FLAG: "de.loewe.sl2.i32.avs.alarm.flag",
        AVS_HIDEV_INFO: "de.loewe.sl2.str.avs.hidev.info",
        AVS_ONPCOENABLERESULT:'de.loewe.sl2.str.avs.enable.skill.name',
        AVS_ONPCORESETRESULT:"de.loewe.sl2.str.avs.reset.skill.name",
        AVS_ONPULLCLOUDMSGRECEIVED:"de.loewe.sl2.str.avs.pull.cloud.msg",
        SYSTEM_OTT_SHOW_PWD_DIALOG:"tvapi.i32.system.ott.show.pwd.dialog",
        B2B_RECEIVE_COMMAND_STRING:"de.loewe.sl2.str.b2b.cmd.recv"

//        ACR_MSG:""

    };

    var NFYMessages = [
        _this.MESSAGE_NAME.USB_DEVICE_CHANGED,
        _this.MESSAGE_NAME.HISMART_DATA,
        _this.MESSAGE_NAME.SOURCE_DETECT_CHANGED
    ];
    var noResponseInFACM = [
        _this.MESSAGE_NAME.USB_DEVICE_CHANGED,
        _this.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED,
        _this.MESSAGE_NAME.MUTE_CHANGED,
        _this.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT,
        _this.MESSAGE_NAME.SIGNAL_CHANGED,
        _this.MESSAGE_NAME.VOLUME_CHANGED,
        _this.MESSAGE_NAME.VOLUME_DEV_CHANGED,
        _this.MESSAGE_NAME.VIDEO_FORMAT_CHANGED,
        _this.MESSAGE_NAME.CEC_CHANGE_SOURCE
    ];
    var unProcessedNFY = {};

    var funcs = [];

    function publishMessage(msg, val) {
        if (!funcs[msg]) return;
        funcs[msg].forEach(
            function (item) {
                try {
                    item.apply(_this, val);
                }
                catch (ex) {
                    DBG_ERROR("func[" + item.name + "], error[" + ex.stack + "]");
                }
            }
        );
    }

    function FuncArrayExist(msg){
       if(funcs[msg]!=undefined) {
           return true;
       }else{
       return false;
       }
    }

    function convertToArray(arg, type){
        var convertedArgs = [];
        if ((type == 'notifyIntegerVector' || type == 'notifyStringVector') && arg.length) {
            for (var i = 0; i < arg.length; i++) {
                convertedArgs[i] = arg[i];
            }
            return convertedArgs;
        }
        else if ((type == 'notifyResult') && arg.keys) {

            for (var i = 0; i < arg.keys.length; i++) {
                var key = arg.keys[i];
                convertedArgs[key] = arg[key];
            }
            return convertedArgs;
        }
        else {
            return arg;
        }
    }

    function onTVModelChanged() {
        if (!UI.initFinishFlag) return;
        var oriArgs = Array.prototype.slice.call(arguments);
        var type = oriArgs.shift();
        var msg = oriArgs.shift();
        var args = [];

        for (var i = 0; i < oriArgs.length; i++) {
            args[i] = convertToArray(oriArgs[i], type);
        }

        //if (!_this.MESSAGE_NAME[msg]) return;
        if (1 == GLOBAL.FACTORY && noResponseInFACM.indexOf(msg) > -1) return false;
        if (NFYMessages.indexOf(msg) > -1) addNotification(msg, args);
        //do global operation
        switch (msg) {
            case _this.MESSAGE_NAME.PARENTAL_LOCK_SWITCH:
                GLOBAL.PARENTAL_LOCK_SWITCH = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CURRENT_SOURCE_CHANGED:
                DBG_ERROR("current source changed: " + args[0]);
                GLOBAL.SOURCE_CHANGING = false;
                clearTimeout(GLOBAL.SOURCE_CHANGING_TIMER);

                if (LiveTVSourceMap[args[0]] != undefined) {
                    GLOBAL.CURRENT_SOURCE = mapInputsDataByPlayId(args[0]);
                }
                else {
                    GLOBAL.CURRENT_SOURCE = SourceList.TV;
                }
                DBG_ERROR("GLOBAL.CURRENT_SOURCE is " + GLOBAL.CURRENT_SOURCE);

                if (SourceList.TV == GLOBAL.CURRENT_SOURCE) {
                    GLOBAL.S_NO_SIGNAL = (model.tvservice.getNoSignalMain() == 1);
                }
                else {
                    var crntSourceObj = liveTV.getCurrentSourceObj();
                    DBG_ERROR("crntSourceObj is " + objToString(crntSourceObj));
                    GLOBAL.S_NO_SIGNAL = (crntSourceObj.signal == SvrMsg.NO_SIGNAL);
                }
                fetchSignalAndPublish();
                try{
                    pubActionSourcechange();
                }
                catch(ex){
                    DBG_ERROR(ex.message);
                }
                break;
            case _this.MESSAGE_NAME.SIGNAL_CHANGED:
                GLOBAL.NO_SIGNAL = (1 == args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_ARC_STATE_CHANGED:
                GLOBAL.CEC_ARC_STATE = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_CONTROL_CHANGED:
                GLOBAL.CEC_CONTROL = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED:
                GLOBAL.CEC_DEVICE_EXIST = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.TIME_FORMAT_CHANGED:
                GLOBAL.TIME_FORMAT = parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.TIME_ZONE_CHANGED:
                GLOBAL.TIMEZONE_SECONDS = args[0];
                break;
            case _this.MESSAGE_NAME.DEVIATION_FROM_UTC_CHANGED:
                DBG_ERROR("deviation from utc change: " + args[0]);
                GLOBAL.DEVIATION_FROM_UTC = args[0];
                break;
            case _this.MESSAGE_NAME.MENU_TIMEOUT_CHANGED:
                GLOBAL.SETTING_TIMEOUT_DELAY = 1000 * parseInt(args[0]);
                break;
            case _this.MESSAGE_NAME.CURRENT_COUNTRY_CHANGED:
                GLOBAL.CURRENT_COUNTRY = ChangeCountryNumToCode(args[0]);
                DBG_ALWAYS(" GLOBAL.CURRENT_COUNTRY"+ GLOBAL.CURRENT_COUNTRY);
                updateDateFormat();
                if('CAN' == GLOBAL.CURRENT_COUNTRY && GLOBAL.TTS){
                    setTTSSwitch(0);
                }
                //delete the appinfo file, to fresh the appdate for app settings .
                Hisense.File.delete("launcher/settingappinfo.txt", 1);
                break;
            case _this.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED:
                DBG_ALWAYS(" LANUAGE CHANGED");
                GLOBAL.CURRENT_LANGUAGE = ChangeLangNumToCode(args[0]);
                updateDateFormat();
                break;
            case _this.MESSAGE_NAME.DAYLIGHT_SAVINGS_CHANGED:
                DBG_ERROR("DAYLIGHT SAVINGS CHANGED: " + args[0]);
                GLOBAL.DST_SECONDS = 0;//(parseInt(args[0]) * 3600);
                break;
            case _this.MESSAGE_NAME.PARENTAL_LOCK_PIN_REQUEST:
                //DBG_ALWAYS("PARENTAL_LOCK_PIN_REQUEST:"+args);
                break;
            case _this.MESSAGE_NAME.USB_DEVICE_CHANGED:
                DBG_ERROR("USB DEVICE CHANGED: " + args[0]);
                break;
            case _this.MESSAGE_NAME.DEVICE_ID_CHANGED:
                DBG_ALWAYS("deviceId changed");
                GLOBAL.LOG_Report_DEVICEID_InitFlag = false;
                break;
            default :
                break;
        }
        publishMessage(msg, args);
    }

    function subjectMessage(msg, func) {
        if (!funcs[msg]) funcs[msg] = [];
        unsubscribeMessage(msg, func);
        funcs[msg].push(func);
    }

    function unsubscribeMessage(msg, func) {
        if (!funcs[msg]) return;
        funcs[msg] = funcs[msg].filter(
            function (item) {
                if (item !== func) {
                    return item;
                }
            }
        );
    }

    function addNotification(msg, args) {
        if (!funcs[msg]) return;
        var item = {
            "MsgName": msg,
            "MsgId": msgIdEnum++,
            "date": getSystemLongTimeForNotification(),
            "data": args,
            "cmd": ""
        }

        //Temp. Actually, We should not do these operations here.
        switch (msg) {
            case _this.MESSAGE_NAME.USB_DEVICE_CHANGED:
                item.cmd = LauncherCMD.HIMEDIA;
//                g_notificationCrtTimeStamp = item.date;
//                deleteNotificationByMsg(msg, null);
                break;
            case _this.MESSAGE_NAME.SOURCE_DETECT_CHANGED:
                item.cmd = LauncherCMD.INPUT;
//                g_notificationCrtTimeStamp = item.date;
                break;
            default :
                return;
        }
        if(!unProcessedNFY[msg]) {
            unProcessedNFY[msg] = [item];
        }
        else{
            unProcessedNFY[msg].push(item);
        }
    }

    function getNotifications() {
        return unProcessedNFY;
    }

    function clearNotifications() {
        unProcessedNFY = {};
        return true;
    }

    function deleteNotificationByMsg(msg, id) {
        if(null == id) {
            delete unProcessedNFY[msg];
        }
        else{
            var allMsg = unProcessedNFY[msg];
            for (var i = 0; i < allMsg.length; i++) {
                if (allMsg[i].MsgId == id) {
                    allMsg.splice(i, 1);
                    break;
                }
            }
        }
    }

    _this.getNotifications = getNotifications;
    _this.clearNotifications = clearNotifications;
    _this.deleteNotificationByMsg = deleteNotificationByMsg;
    _this.subscribeMessage = subjectMessage;
    _this.unsubscribeMessage = unsubscribeMessage;
    _this.publishMessage = onTVModelChanged.bind(_this, "UIInternalMessage");
    _this.FuncArrayExist=FuncArrayExist;

    _this.registerNotify = function() {
        DBG_INFO("UI.registerNotify start " + debugRunTime());
        model.addEventListener("notifyObjectRemoved",onTVModelChanged.bind(_this, "notifyObjectRemoved"));
        model.addEventListener("notifyResult",onTVModelChanged.bind(_this, "notifyResult"));
        model.addEventListener("notifyExecutionError",onTVModelChanged.bind(_this, "notifyExecutionError"));
        model.addEventListener("notifyNewValue",onTVModelChanged.bind(_this, "notifyNewValue"));
        model.addEventListener("notifyIntegerVector",onTVModelChanged.bind(_this, "notifyIntegerVector"));
        model.addEventListener("notifyStringVector",onTVModelChanged.bind(_this, "notifyStringVector"));
        model.addEventListener("notifyUpdate",onTVModelChanged.bind(_this, "notifyUpdate"));
        model.sound;
        model.system;
        model.message;
        model.servicelist;
        model.hisfactory;
        model.basicSetting;
        model.usb;
        model.tvservice;
        model.closedcaption;
        model.appsetting;
        model.language;
        model.parentlock;
        model.softupdate;
        model.cec;
        model.timerfunc;
        model.source;
        model.network;
        model.video;
        model.miracast;
        model.picture;
        model.mpctrl;
        model.volume;
        model.directory;
        model.bluetooth;
        model.datetime;
        model.tts;
        model.avs;
        model.b2b;
//        try{
//            if(acrflag){
//                DBG_ERROR("!!!!!!!!!!!!!start Acr setListener!!!!!!!!!!");
//                AcrJSI.setListener(function (msg, len) {
//                    onTVModelChanged(_this.MESSAGE_NAME.ACR_MSG,msg);
//                });
//                AcrJSI.init();
//            }
//        }catch(e){
//            DBG_ERROR("AcrJSI.setListener:"+ e.message);
//        }
        DBG_INFO("UI.registerNotify end " + debugRunTime());
    }
}
MessagePool.prototype.constructor = MessagePool;
