/**
 * Created by tony on 17/6/14.
 */

var fourknowUtil = {};
(function () {
    VIDEO_TYPE = {
        VIDEO: "video",
        MOVIE: "movie",
        TV_SHOW: "tv show",
        TV_APPLICATION: "tv application"
    };
    //getString("Yestoday")
    fourknowUtil.historyTitleArray = ["[GE0017]","[GE0018]","[LA0107]","[LA0108]"];
    fourknowUtil.isLaunchingApplication=false;
    var historyJsonArray = null;
    var historyFile = "fourknowHistory";
    var videoJsonString = '{"accessDate": "03/04/2016","id": "","title": "","poster": "","poster_type": "","parent_control": "","has_detail_page": "","deep_linking": ""}';
    //predefine 4K app in priority order sequence.
    var appCollectionWith4K = [
        {name: "netflix", type: "", command: "" },
        {name: "youtube", type: "", command: ""},
        {name: "amazon", type: "", command: ""},
        {name: "ultraflix", type: "tv_store", command: ""},
        {name: "toongoggles", type: "tv_store", command: ""},
        {name: "fandangonow", type: "tv_store", command: ""}

    ];
    var AppByAppJson = {
        "host":"4KNow",//The App name which will launch other Apps.
        "action":"",//To launch an App(value: app) or play a video(value: deeplink);
        "client":"", //The App name which is launched by host App;
        "clientUrl":"",//If the client App is from Opera Store, write the App Url here, let TV launch client App by Opera Store;
        "deepLink":"",//deep link video URL
        "command":""//AM command. Note: This is only for pre compatible. Different platform should generate the AM command by itself.
    };
    function TVPlatform() {
    }
    TVPlatform.NONE = 0;
    TVPlatform.MT5655 = 1;
    TVPlatform.MT5657 = 2;
    TVPlatform.MT5658 = 3;
    TVPlatform.MST6586 = 4;//0321+

    function TVBrand() {
    }

    TVBrand.Hisense = 0;
    TVBrand.Sharp = 1;

    fourknowUtil.getResolution = function(width, height) {
        var w = parseInt(width), h = parseInt(height);

        if (w == 1920 && h == 1080) {
            return "FHD";
        }

        if (w >= 1920 && h >= 1080) {
            return "UHD";
        }

        if ((w >= 1280 && w < 1920) && (h >= 720 && h < 1080)) {
            return "HD";
        }

        return "SD";
    };
    fourknowUtil.inResolutionRange = function(resolution, width, height) {
        var w = parseInt(width), h = parseInt(height);
        //console.log(w, h);
        resolution = resolution || "";
        if (resolution == "") {
            return true;
        }
        switch (resolution.toLowerCase()) {
            case "uhd":
            case "4k":
                if (w >= 1920 && h >= 1080) {
                    return "true";
                }
                break;
            case "fhd":
            case "1080p":
                if (w == 1920 && h == 1080) {
                    return true;
                }
                break;
            case "720p":
            case "hd":
                if ((w >= 1280 && w < 1920) && (h >= 720 && h < 1080)) {
                    return true;
                }
                break;
            default:
                break;
        }
        return false;
    }

    fourknowUtil.is4K = function(width, height) {
        var w = parseInt(width), h = parseInt(height);
        //console.log(w, h);
        if (w >= 2160) {
            return true;
        }
        return false;
    }




    fourknowUtil.partition = function(arr,  low,  high) {
        var privotKey = arr[low];                             //基准元素
        while(low < high){                                   //从表的两端交替地向中间扫描
            while(low < high  && arr[high] >= privotKey) --high;  //从high 所指位置向前搜索，至多到low+1 位置。将比基准元素小的交换到低端
            //swap(arr[low], arr[high]);
            var tempLow=arr[low];
            var temphigh=arr[high];
            arr[low]=temphigh;
            arr[high]=tempLow;
            while(low < high  && arr[low] <= privotKey ) ++low;
            //swap(arr[low], arr[high]);
        }
        return low;
    }

    fourknowUtil.quickSort = function(arr, low,high) {//quick sort algorithm
        if(low < high){
            var privotLoc = fourknowUtil.partition(arr,  low,  high);  //将表一分为二
            fourknowUtil.quickSort(arr,  low,  privotLoc -1);          //递归对低子表递归排序
            fourknowUtil.quickSort(arr,   privotLoc + 1, high);        //递归对高子表递归排序
        }
    }

    ///////below cache video functions
    // need to save all language get from cloud server

    fourknowUtil.generateCachedVideo = function(videoInfo){
        var videoJson = (typeof videoInfo.length == "undefined") ? JSON.parse(JSON.stringify(videoInfo)) : JSON.parse(videoInfo);
        var tempVideoJson = JSON.parse(videoJsonString);
        tempVideoJson.accessDate = Date().toISOString();
        tempVideoJson.id = videoJson.id;
        tempVideoJson.title = videoJson.title;
        tempVideoJson.poster = videoJson.poster;
        tempVideoJson.poster_type = videoJson.poster_type;
        tempVideoJson.parent_control = videoJson.parent_control;
        tempVideoJson.has_detail_page = videoJson.has_detail_page;
        tempVideoJson.deep_linking = videoJson.deep_linking;

        return tempVideoJson;
    }

    fourknowUtil.cacheToHistory = function(videoInfo){
        try
        {
            var historyJson = localStorage.getItem(historyFile);
            //var videoData = (typeof videoInfo.length == "undefined") ? JSON.parse(JSON.stringify(videoInfo)) : JSON.parse(videoInfo);
            DBG_ERROR("historyJson="+historyJson);
            //remove the json element with same videoId
            if(historyJson){
                historyJsonArray = JSON.parse(historyJson);
                for(var i=0; i < historyJsonArray.length; i++){
                    if(historyJsonArray[i].id == videoInfo.id){
                        historyJsonArray.splice(i,1);
                        break;
                    }
                }
            }
            if(historyJsonArray == null){
                historyJsonArray = [];
            }
            var today = new Date();
            videoInfo["accessDate"] = today.toISOString();
            historyJsonArray.splice(0,0,videoInfo);

            localStorage.setItem(historyFile, JSON.stringify(historyJsonArray));
        }
        catch(e)
        {
            // handle error
            console.log(e);
        }
    }
    fourknowUtil.clearCacheHistory = function(){
        try
        {
            historyJsonArray = null;
            localStorage.removeItem(historyFile);
        }
        catch(e)
        {
            // handle error
            console.log(e);
        }
    }
    fourknowUtil.getCachedVideoByIndex = function(index){
        if(historyJsonArray == null){
            var historyJson = localStorage.getItem(historyFile);
            if(historyJson){
                historyJsonArray = JSON.parse(historyJson);
            }else{
                return null;
            }
        }

        return (index <= historyJsonArray.length && index > 0) ? historyJsonArray[index] : null;
    }

    fourknowUtil.getCachedVideoById = function(id){

            var historyJson = localStorage.getItem(historyFile);
            if(historyJson==null||historyJson== "null"){
                return null;

            }else{
                historyJsonArray = JSON.parse(historyJson);
            }


        for(var i=0; i< historyJsonArray.length; i++){
            if(historyJsonArray[i].id == id){
                return historyJsonArray[i];
                break;
            }
        }
        return null;
    }

    fourknowUtil.getCachedVideoByDate = function(from, to){

            var historyJson = localStorage.getItem(historyFile);

            if(historyJson== null||historyJson== "null"){
                return null;
            }else{

                historyJsonArray = JSON.parse(historyJson);
            }


        var histories = [];
        var todayTemp = new Date();
        var today = new Date(todayTemp.getFullYear(),todayTemp.getMonth(),todayTemp.getDate());

        to = to || from;
        for(var i=0; i< historyJsonArray.length; i++){
            var dateTemp = new  Date(historyJsonArray[i].accessDate);
            var date = new Date(dateTemp.getFullYear(),dateTemp.getMonth(),dateTemp.getDate());
            var days = Math.floor((today.getTime() - date.getTime())/86400000);//Date.UTC(date.getYear(), date.getMonth(), date.getDay())/1000/60/60/24;
            if(days >= from && days <= to){
                histories.push(historyJsonArray[i]);
            }
        }

        return (histories.length > 0) ? histories : null;
    }
    fourknowUtil.getNameByCurrentLanguage= function(nameArr) {
        var langs = ["chi", "eng", "fre", "kor", "rus", "jpn", "spa", "ger", "zho", "ara", "per",
            "tha", "ita", "dut", "por", "cze", "hun", "gre", "bul", "rum", "mal",
            "hbr", "tur", "ind", "uzb", "nor", "swe", "dan", "fin", "vie"
            , "mya", "hin", "eng", "ukr", "slk", "pol", "srp", "mac", "alb", "hrv", "lav", "est", "lit"];
        var languageId = langs.indexOf(GLOBAL.CURRENT_LANGUAGE);
        var name = "";
        for (var i = 0; i < nameArr.length; i++) {
            if (nameArr[i].languageId == languageId) {
                name = nameArr[i].name;
                break;
            }else{
                name = nameArr[i].name;
            }
        }
        return name;
    }
    //TV plugins
    fourknowUtil.launchApplication= function(currentVideo) {
        var url="https://www.youtube.com/tv?launch=menu&t=0&v=gwrf1LLJmY4";//currentVideo.deep_linking;//https://www.youtube.com/tv?launch=menu&t=0&v=gwrf1LLJmY4   //http://html5.toongoggles.com/?redirect=episode:%2F%2F196893
        var appName="youtube";//currentVideo.providerName;//youtube //toongoggles
        var cmd=getLaunchCommand(appName, url);
        /*
        if(fourknowUtil.isLaunchingApplication){
            return;
        }
        */
        fourknowUtil.isLaunchingApplication = true;
        try {
            //debugG(cmd);
            DBG_ERROR("cmd="+cmd);
            var url = "";
            DBG_ERROR("getRunningEnvDetails()="+getRunningEnvDetails());
            if(getRunningEnvDetails() == TVPlatform.MT5658||getRunningEnvDetails() == TVPlatform.MST6586){
                var appbyappString = "";
                var urlIndex = cmd.indexOf("http");
                if(urlIndex != -1 && isTVStoreApp(appName)){
                    url = cmd.substring(urlIndex, cmd.length-1);
                    //for(var i = 0; i < appCollectionWith4K.length; i++){
                    //    if(appName.toLowerCase().indexOf(appCollectionWith4K[i].name) != -1){
                    //        url = appCollectionWith4K[i].command;
                    //        break;
                    //    }
                    //}
                    //appbyappString = "4KNow" + "||" + appName + "||" +decodeURIComponent(cmd);
                    appbyappString = decodeURIComponent(url) + " " + decodeURIComponent(cmd);
                }else{
                    //appbyappString = "4KNow" + "||" + appName.toLowerCase().replace(/\s+/g, "") + "||" + decodeURIComponent(cmd);
                    DBG_ERROR("appbyappStringDecode");
                    appbyappString = appName.toLowerCase().replace(/\s+/g, "") + " " + decodeURIComponent(cmd);
                    DBG_ERROR("appbyappString="+appbyappString);
                }

                writeLocalFile("4know", appbyappString, 0);

                //AppByAppJson.action = (currentVideo.type == VIDEO_TYPE.TV_APPLICATION) ? "app": "deeplink";
                AppByAppJson.action ="deeplink";//for testing
                AppByAppJson.client =  decodeURIComponent(getInstalledAppExeName(appName));
                if(getRunningEnvDetails() == TVPlatform.MST6586) {
                    AppByAppJson.clientUrl = isTVStoreApp(appName)?getInstalledAppExeUrl(appName):"";
                }else{
                    AppByAppJson.clientUrl = isTVStoreApp(appName)?getInstalledAppExeName(appName):"";
                }
                //AppByAppJson.deepLink = (currentVideo.type == VIDEO_TYPE.TV_APPLICATION) ? "" : decodeURIComponent(cmd);
                AppByAppJson.deepLink=decodeURIComponent(cmd);//for testing
                AppByAppJson.command = decodeURIComponent(cmd);
                //debugG(JSON.stringify(AppByAppJson));
                DBG_ERROR("JSON.stringify(AppByAppJson)="+JSON.stringify(AppByAppJson));
                writeLocalFile("appbyapp.json", JSON.stringify(AppByAppJson), 0);
                DBG_ERROR("navigator.userAgent.toLowerCase()="+navigator.userAgent.toLowerCase());
                if(getRunningEnvDetails() == TVPlatform.MT5658&&navigator.userAgent.toLowerCase().indexOf('custdown') > -1){//0629+
                    Hisense_StartApp(":am,am,:stop=opera4x");
                }else{
                    Hisense_StartApp(":am,opera4x,:pause=");
                }

            }else{
                writeLocalFile("appbyapp", cmd, 1);
                AppByAppJson.action = (currentVideo.type == VIDEO_TYPE.TV_APPLICATION) ? "app": "deeplink";
                AppByAppJson.client = getInstalledAppExeName(appName);
                AppByAppJson.clientUrl = decodeURIComponent(isTVStoreApp(appName)?getInstalledAppExeName(appName):"");
                AppByAppJson.deepLink = (currentVideo.type == VIDEO_TYPE.TV_APPLICATION) ? "" : decodeURIComponent(currentVideo.provider[0].videoUrl);
                AppByAppJson.command = decodeURIComponent(cmd);
                //debugG(JSON.stringify(AppByAppJson));
                DBG_ERROR("JSON.stringify(AppByAppJson)="+JSON.stringify(AppByAppJson));
                writeLocalFile("appbyapp.json", JSON.stringify(AppByAppJson), 0);
                Hisense_StartApp(cmd);
            }
        }
        catch(e){

            isLaunchingApplication = false;

        }
    };
    function isTVStoreApp(appName){
        for(var i=0; i<appCollectionWith4K.length; i++){
            var appIndex = appName.replace(/\s+/g, "").toLowerCase().indexOf(appCollectionWith4K[i].name);
            if(appIndex > -1){
                if(appCollectionWith4K[i].type == "tv_store") {
                    return true;
                }
                break;
            }
        }
        return false;
    };
    function getLaunchCommand(appName, url){
        var command = "";
        appName = appName.toLowerCase().replace(/\s+/g, "");
        url = url || "";
        var platform = getRunningEnvDetails();
        if(url.length){
            if(isTVStoreApp(appName)){
                if(platform == TVPlatform.MT5658||platform == TVPlatform.MST6586) {
                    if(getRunningEnvDetails() == TVPlatform.MT5658&&navigator.userAgent.toLowerCase().indexOf('custdown') > -1){//0629+
                        command = ":am,am,:start=[opera4x,-t,store,-u," + url + "]";
                    }
                    else{
                        command = ":am,opera4x,:resume=[-s,store,-u," + url + "]";
                    }
                }else{
                    command = ":am,am,:restart=[tv_store,-u,"+url+"]";
                }
            }else {
                if (appName.indexOf("youtube") > -1) {
                    command = ":am,am,:start_ex=[youtube,-w,1280,-h,720,-x,youtube,-m,NO,-u," + url + "]";
                } else if (appName.indexOf("netflix") > -1) {
                    command = ":am,am,menu:start=[netflix,-Q,source_type=2&additionalDataUrl=http%3A%2F%2Flocalhost%3A56789%2Fapps%2FNetflix%2Fdial_data%3F]";
                } else if (appName.indexOf("vudu") > -1) {
                    command = ":am,am,menu:start=vudu";
                }else if (appName.indexOf("amazon") > -1) {
                    command = ":am,am,menu:start="+getAmazonAmName();
                } else {
                    command = ":am,am,:start=" + appName;
                }

            }
        }else{
            if (appName.indexOf("youtube") > -1) {
                command = ":am,am,menu:start=youtube";
            } else if (appName.indexOf("netflix") > -1) {
                command = ":am,am,menu:start=[netflix,-Q,source_type=2&additionalDataUrl=http%3A%2F%2Flocalhost%3A56789%2Fapps%2FNetflix%2Fdial_data%3F]";
            } else if (appName.indexOf("vudu") > -1) {
                command = ":am,am,menu:start=vudu";
            }else if (appName.indexOf("amazon") > -1) {
                command = ":am,am,menu:start="+getAmazonAmName();
            } else {
                command = ":am,am,:start=" + appName;
            }
        }
        return command;
    };
    function getRunningEnvDetails(){
        var agentString = navigator.userAgent;

        if(agentString.toLowerCase().indexOf('hisense') > -1) {
            if (agentString.toLowerCase().indexOf("5658") > -1) {
                return TVPlatform.MT5658;
            }else if(agentString.toLowerCase().indexOf("6586") > -1){//0321+
                return TVPlatform.MST6586;
            }else{
                //try{
                //    var support4K = false;
                //    support4K = Hisense_Get4KSupportState()
                //}catch(e){
                //    debugG(e);
                //}
                //if(support4K){
                //    return TVPlatform.MT5657;
                //}else{
                //    return TVPlatform.MT5655;
                //}
                return TVPlatform.MT5657;
            }
        }

        return TVPlatform.NONE;
    };
    function getAmazonAmName() {
        if(getRunningEnvDetails() == TVPlatform.MT5658||getRunningEnvDetails() == TVPlatform.MST6586){
            return "amazonruby";
        }else {
            var brand = getTVBrandDetails();
            if (brand != null) {
                if (getTVBrandDetails() == TVBrand.Sharp) {
                    return "ruby-sharp";
                }
                else {
                    return "ruby-hisense";
                }
            } else {
                return "amazonruby";
            }
        }
    };
    function getTVBrandDetails(){
        var brand = null;//TVPlatform.Hisense;
        try{
            var brandName = "";
            if(getRunningEnvDetails() == TVPlatform.MT5658||getRunningEnvDetails() == TVPlatform.MST6586){
                brandName = Hisense_GetBrand();
            }else {
                brandName = readLocalFile("brandcode", 1);
            }
            if(brandName.indexOf("shp") > -1){
                brand = TVBrand.Sharp;
            }else if(brandName.indexOf("his") > -1){
                brand = TVBrand.Hisense;
            }
        }catch(e){

        }

        return brand;
    };
    function writeLocalFile(path, content, location){
        var platform = getRunningEnvDetails();
        if(platform == TVPlatform.MT5658||platform == TVPlatform.MST6586){
            HiBrowser.File.write(path, content, location);
        }else{
            Hisense.File.write(path, content, location);
        }
    };
    function getInstalledAppExeName(appName){
        var appExeName = appName;
        for(var i=0; i<appCollectionWith4K.length; i++){
            var appIndex = appName.replace(/\s+/g, "").toLowerCase().indexOf(appCollectionWith4K[i].name);
            if(appIndex > -1){
                if(getRunningEnvDetails() != TVPlatform.MST6586){//6586 donot chang the appExeName
                    appExeName = appCollectionWith4K[i].command;
                    break;
                }else{//6586 platform
                    appExeName=appName.replace(/\s+/g, "").toLowerCase();
                }
            }
        }
        return appExeName;
    }
    function getInstalledAppExeUrl(appName){
        var appExeName = appName;
        var appUrl="";
        for(var i=0; i<appCollectionWith4K.length; i++){
            var appIndex = appName.replace(/\s+/g, "").toLowerCase().indexOf(appCollectionWith4K[i].name);
            if(appIndex > -1){
                appUrl = appCollectionWith4K[i].command;
                break;
            }
        }
        return appUrl;
    }





})();