// Init
UI.moduleBuilder['setting']['wifiAdvanced'] = function(){

    var mainPanelData = {
        wifiAdvancedDialogBgImg:UI['bg_overlay'],
        wifiAdvancedImg:UI.window_bg,
        wifiWpsPinBtnImg:UI.item_bg,
        wifiWpsPushBtnImg:UI.item_bg,
        wifiIpSettingBtnImg:UI.item_bg,
        wifiAdvancedName:"[SE0037]",//"Advanced Settings"
        wifiWpsPinBtnText:"[SE0961]",//"PIN Code"
        wifiWpsPushBtnText:"[SE0171]",//"PBC"
        wifiIpSettingBtnText:"[SE0172]"//"IP Setting"

    };
    var template = Util.readJson("module/setting/wifiAdvanced.json");
    var wifiAdvanced = SubModule.create(mainPanelData, template);
    var wifiWpsPinBtn = UI.getItem(wifiAdvanced, "wifiWpsPinBtn");
    var wifiWpsPushBtn = UI.getItem(wifiAdvanced, "wifiWpsPushBtn");
    var wifiIpSettingBtn = UI.getItem(wifiAdvanced, "wifiIpSettingBtn");

    wifiAdvanced.currFocus = UI.getItem(wifiAdvanced, "wifiWpsPinBtn");

    function wifiAdvancedOnNetworkStatusChanged(val){
        var netLinkStatus = tv ? model.network.getEnumLink() : 0;//0:establish
        DBG_ERROR("wifiAdvancedOnNetworkStatusChanged:"+val+","+netLinkStatus);
        if(val == NetWorkConnect.CONNECT || netLinkStatus == 0){
            wifiIpSettingBtn.disable = false;
            wifiIpSettingBtn.alpha = 1;
        }else{
            wifiIpSettingBtn.disable = true;
            wifiIpSettingBtn.alpha = 0.3;
        }
        UI.updateStage();
    }
    wifiAdvanced.onPush =  function(){
        try{
//            UI.focusTo(wifiWpsPinBtn);
//            wifiAdvanced.currFocus = UI.getItem(wifiAdvanced, "wifiWpsPinBtn");
            var NetStatus = tv ? model.network.getEnumNetworkAvailable() : 0; //1 success  0 fail
            var netLinkStatus = tv ? model.network.getEnumLink() : 0;//0:establish
            DBG_ERROR("getEnumNetworkAvailable():" + NetStatus+",netLinkStatus"+netLinkStatus);
            if(NetStatus == NetWorkConnect.CONNECT || netLinkStatus == 0){
                wifiIpSettingBtn.disable = false;
                wifiIpSettingBtn.alpha = 1;
            }else{
                wifiIpSettingBtn.disable = true;
                wifiIpSettingBtn.alpha = 0.3;
            }
            UI.updateStage();
//            UI.focusTo(wifiWpsPinBtn);
            wifiAdvanced.currFocus = UI.getItem(wifiAdvanced, "wifiWpsPinBtn");
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, wifiAdvancedOnNetworkStatusChanged);
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    wifiAdvanced.onShow = function(caller){
        if(caller == "networkIpSet" && wifiIpSettingBtn.disable == true){
            UI.focusTo(wifiWpsPinBtn);
        }
    }
    wifiWpsPinBtn.onkey_ENTER = function () {
        UI.pushSubModule("setting", "wifiWpsPin", true);
        return true;
    };
    wifiWpsPinBtn.onNormal = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };
    wifiWpsPinBtn.onFocus = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };

    wifiWpsPushBtn.onkey_ENTER = function () {
        UI.pushSubModule("setting", "wifiWpsPush", true);
        return false;
    };

    wifiWpsPushBtn.onNormal = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };
    wifiWpsPushBtn.onFocus = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };

    wifiIpSettingBtn.onkey_ENTER = function () {
        UI.pushSubModule("setting", "networkIpSet", true);
        return false;
    };

    wifiIpSettingBtn.onNormal = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };
    wifiIpSettingBtn.onFocus = function(){
        UI.setTextColor(wifiAdvanced.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };

    wifiAdvanced.onkey_BACKSPACE = function() {
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        networkConfigPanel.openFromPwd = 1;
        UI.popSubModule();
    };
    wifiAdvanced.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED,wifiAdvancedOnNetworkStatusChanged);
    }

};

