// Init
UI.moduleBuilder['setting']['picPQAdjust'] = function(){
    var initData = {
        percentBG: UI["liveTV_bg"],
        UpArrow: "setting/pic/card_wheel/UpArrow.png",
        DownArrow: "setting/pic/card_wheel/DownArrow.png",
        cardWheelBg: {color: getCardWheelColor()},
        cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
        cardWheelIcon_0: "setting/pic/card_wheel/contrast.png",
        cardWheelIcon_1: "setting/pic/card_wheel/brightness.png",
        cardWheelIcon_2: "setting/pic/card_wheel/color.png",
        cardWheelIcon_3: "setting/pic/card_wheel/tint.png",
        cardWheelIcon_4: "setting/pic/card_wheel/sharpness.png"
    };
    var template = Util.readJsonObject("module/setting/picPQAdjust.json");

    var pctCmpVec = ['Contrast', 'Brightness', 'Color', 'Tint', 'Sharpness'];
    var pctCmpTitleVec = ['[SE0012]', '[SE0011]', '[SE1833]', '[SE0054]', '[SE0053]'];
    var pctCmpDescriptionVec = ['[SE0459]', '[SE0458]', '[SE0460]', '[SE0479]', '[SE0480]'];

    for (var i = 0; i < pctCmpVec.length; i++) {
        template.picPQAdjust.items[pctCmpVec[i]] = getObjCopy(Util.readJsonObject("templates/percentSingle.json")).percentBar;
        template.picPQAdjust.items[pctCmpVec[i]].position.y = 0;
        template.picPQAdjust.items[pctCmpVec[i]].items.title.value = pctCmpTitleVec[i];
        template.picPQAdjust.items[pctCmpVec[i]].items.description.value = pctCmpDescriptionVec[i];
        template.picPQAdjust.items[pctCmpVec[i]].navigation =
        {
            "leftTo": null,
            "rightTo": null,
            "upTo": pctCmpVec[i - 1 >= 0 ? i - 1 : 4],
            "downTo": pctCmpVec[i + 1 <= 4 ? i + 1 : 0]
        };
        if (pctCmpVec[i] != PictureConfig.PQAdjustSign.substr(3)) {
            template.picPQAdjust.items[pctCmpVec[i]].position.y = 2000;
        }
    }


    var cardWheel = {
        "type": 0,
        "position": {
            "x": -250,
            "y": 20
        },
        "items": {}
    };

    var cardWheelItem = {
        "type": 0,
        "position": {
            "x": 0,
            "y": 124
        },
        "navigation": {
            "leftTo": null,
            "rightTo": null,
            "upTo": null,
            "downTo": null
        },
        "items": {
            "cardWheelBg": {
                "type": 7,
                "bound": {
                    "w": 230,
                    "h": 160
                },
                "position": {
                    "x": 0,
                    "y": 0
                }
            },
            "cardWheelShadow": {
                "type": 7,
                "bound": {
                    "w": 280,
                    "h": 200
                },
                "position": {
                    "x": -30,
                    "y": -20
                }
            },
            "cardWheelIcon": {
                "type": 7,
                "bound": {
                    "w": 72,
                    "h": 72
                },
                "position": {
                    "x": 79,
                    "y": 44
                }
            }
        }
    };


    // 20 50 150 200 0
    //位置不准确，缩放为中心缩放
    var cardWheelItemIndexVec = [{y: 0}, {y: 95}, {y: 190}, {y: 95}, {y: 95}];

    for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
        var cardWheelItemTemp = getObjCopy(cardWheelItem);
        cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
        cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
        delete (cardWheelItemTemp.items.cardWheelIcon);
        cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;
    }
    template.picPQAdjust.items['cardWheel'] = cardWheel;
    var picPQAdjust = SubModule.create(initData, template);

    picPQAdjust.onPush = function () {
        try {
            var CmpVec = [Contrast, Brightness, Color, Tint, Sharpness];
            for (var i = 0; i < CmpVec.length; i++) {
                CmpVec[i].alpha = 0;
                CmpVec[i].y = 0;
            }

            cardWheelObj.init();
            picPQAdjust.currFocus = UI.getItem(picPQAdjust, PictureConfig.PQAdjustSign.substr(3));
            getPQAdjustModelValue();

            setOnkeyLeftRightFunc(Contrast, ContrastComp, PicPQAdjustPageData.ContrastVal);
            setOnkeyLeftRightFunc(Color, ColorComp, PicPQAdjustPageData.ColorVal);
            setOnkeyLeftRightFunc(Tint, TintComp, PicPQAdjustPageData.TintVal);
            UI.setText(TintTxt, (0 == PicPQAdjustPageData.TintVal ? 0 : (PicPQAdjustPageData.TintVal < 0 ? 'R' + (-PicPQAdjustPageData.TintVal) : 'G' + PicPQAdjustPageData.TintVal)));

            setOnkeyLeftRightFunc(Sharpness, SharpnessComp, PicPQAdjustPageData.SharpnessVal);
            setOnkeyLeftRightFunc(Brightness, BrightnessComp, PicPQAdjustPageData.BrightnessVal);
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    picPQAdjust.onShow = function () {
        var normalCfg = {y: 0 + 175, alpha: 1};
        UI.getItem(picPQAdjust, PictureConfig.PQAdjustSign.substr(3)).alpha = 1;
        UI.getItem(picPQAdjust, PictureConfig.PQAdjustSign.substr(3)).y = normalCfg.y;
        UI.hideCursor();
    };


    var PicPQAdjustPageData = {
        ContrastVal: 0,
        ColorVal: 0,
        BrightnessVal: 0,
        TintVal: 0,
        SharpnessVal: 0
    };
    DBG_INFO("getPicSharpnessStep: "+getPicSharpnessStep());

    function getPQAdjustModelValue() {
        try {
            PicPQAdjustPageData.ContrastVal = tv ? model.video.getContrast() : parseInt(Math.random()*10);
            DBG_INFO("model.video.getContrast(): " + PicPQAdjustPageData.ContrastVal);
            ContrastComp.setPercentNoVoice(PicPQAdjustPageData.ContrastVal);

            PicPQAdjustPageData.ColorVal = tv ? model.video.getColourIntensity() : 11;
            DBG_INFO("model.video.getColourIntensity(): " + PicPQAdjustPageData.ColorVal);
            ColorComp.setPercentNoVoice(PicPQAdjustPageData.ColorVal);

            PicPQAdjustPageData.BrightnessVal = tv ? model.video.getBrightness() : 12;
            DBG_INFO("model.video.getBrightness(): " + PicPQAdjustPageData.BrightnessVal);
            BrightnessComp.setPercentNoVoice(PicPQAdjustPageData.BrightnessVal);

            PicPQAdjustPageData.TintVal = tv ? model.video.getTint() : -13;
            DBG_INFO("model.video.getTint(): " + PicPQAdjustPageData.TintVal);
            TintComp.setPercentNoVoice(PicPQAdjustPageData.TintVal);

            PicPQAdjustPageData.SharpnessVal = tv ? model.video.getSharpness() : 100;
            DBG_INFO("model.video.getSharpness(): " + PicPQAdjustPageData.SharpnessVal);
            PicPQAdjustPageData.SharpnessVal = Math.round(PicPQAdjustPageData.SharpnessVal/PicTunerStep.SharpnessStep);
            SharpnessComp.setPercentNoVoice(PicPQAdjustPageData.SharpnessVal);
            var index=pctCmpVec.indexOf(PictureConfig.PQAdjustSign.substr(3));
            TTSCall(index);

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function TTSCall(index){
        if(PictureConfig.PQAdjustSign == "picTint" && 0 != PicPQAdjustPageData.TintVal){
            if(PicPQAdjustPageData.TintVal < 0 ){
                UI.callTTS(pctCmpTitleVec[index]+'R' + eval((-PicPQAdjustPageData.TintVal)) + " ");
                DBG_INFO("UI.callTTS: " + 'R' + eval((-PicPQAdjustPageData.TintVal)));
            }else{
                UI.callTTS(pctCmpTitleVec[index]+'G' + eval(PicPQAdjustPageData.TintVal) + " ");
                DBG_INFO("UI.callTTS: "+ 'G' + eval(PicPQAdjustPageData.TintVal));
            }
        }else{
            UI.callTTS(pctCmpTitleVec[index]+eval("PicPQAdjustPageData."+PictureConfig.PQAdjustSign.substr(3)+"Val") + " ");
            DBG_INFO("UI.callTTS: "+ pctCmpTitleVec[index]+eval("PicPQAdjustPageData."+PictureConfig.PQAdjustSign.substr(3)+"Val"));
        }
    }


    var Contrast = UI.getItem(picPQAdjust, "Contrast");
    var ContrastComp = UI.getItem(Contrast, "percentBarLine");
    var ContrastTxt = UI.getItem(Contrast, "percentBarText");
    Percent.create(ContrastComp, ContrastTxt, PicPQAdjustPageData.ContrastVal, 0, 100);

    var Brightness = UI.getItem(picPQAdjust, "Brightness");
    var BrightnessComp = UI.getItem(Brightness, "percentBarLine");
    var BrightnessTxt = UI.getItem(Brightness, "percentBarText");
    Percent.create(BrightnessComp, BrightnessTxt, PicPQAdjustPageData.BrightnessVal, 0, 100);

    var Color = UI.getItem(picPQAdjust, "Color");
    var ColorComp = UI.getItem(Color, "percentBarLine");
    var ColorTxt = UI.getItem(Color, "percentBarText");
    Percent.create(ColorComp, ColorTxt, PicPQAdjustPageData.ColorVal, 0, 100);

    var Tint = UI.getItem(picPQAdjust, "Tint");
    var TintComp = UI.getItem(Tint, "percentBarLine");
    var TintTxt = UI.getItem(Tint, "percentBarText");
    Percent.create(TintComp, TintTxt, PicPQAdjustPageData.TintVal, -50, 50);

    var Sharpness = UI.getItem(picPQAdjust, "Sharpness");
    var SharpnessComp = UI.getItem(Sharpness, "percentBarLine");
    var SharpnessTxt = UI.getItem(Sharpness, "percentBarText");
    Percent.create(SharpnessComp, SharpnessTxt, PicPQAdjustPageData.SharpnessVal,
        SharpnessData.SharpnessValMin, SharpnessData.SharpnessValMax);

    function setModelValue(name, val) {
        try {
            switch (name) {
                case "Contrast":
                    tv && model.video.setContrast(val);
                    DBG_INFO("model.video.setContrast(" + val + ")");
                    break;
                case "Brightness":
                    tv && model.video.setBrightness(val);
                    DBG_INFO("model.video.setBrightness(" + val + ")");
                    break;
                case "Color":
                    tv && model.video.setColourIntensity(val);
                    DBG_INFO("model.video.setColourIntensity(" + val + ")");
                    break;
                case "Tint":
                    tv && model.video.setTint(val);
                    DBG_INFO("model.video.setTint(" + val + ")");
                    break;
                case "Sharpness":
                    tv && model.video.setSharpness(val);
                    DBG_INFO("model.video.setSharpness(" + val + ")");
                    break;
                default:
                    break;
            }
            eval("PicPQAdjustPageData."+ name +"Val"+"=val");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function setBarPercentValue (bar, comp, val){
        if(bar.name == "Tint"){
            comp.setPercentNoVoice(val);
            "Tint" == bar.name && (UI.setText(TintTxt, (0 == val ? 0 : (val < 0 ? 'R' + (-val) : 'G' + val))));
            UI.callTTS((0 == val ? 0 : (val < 0 ? 'R' + eval(-val)+ " " : 'G' + eval(val) + " ")));
            DBG_INFO("UI.callTTS: "+ (0 == val ? 0 : (val < 0 ? 'R' + eval(-val): 'G' + eval(val))));

        }else{
            comp.setPercent(val);
        }
    }

    function setOnkeyLeftRightFunc(bar, comp, val) {

        bar.onkey_LEFT = function () {
            DBG_INFO(bar.name + "onkey_LEFT");
            val -= 1;
            var minVal = 0;
            if (bar.name == "Tint") {
                minVal = -50
            }
            val < minVal && (val = minVal);
            setBarPercentValue (bar, comp, val);
            var botVal = val;
            if(bar.name == "Sharpness"){
                botVal = botVal*PicTunerStep.SharpnessStep;
            }
            setModelValue(bar.name, botVal);
        };
        bar.onkey_RIGHT = function () {
            DBG_INFO(bar.name + "onkey_RIGHT");
            val += 1;
            var maxVal = 100;
            if (bar.name == "Tint") {
                maxVal = 50
            } else if (bar.name == "Sharpness") {
                maxVal = 20
            }
            val > maxVal && (val = maxVal);
            setBarPercentValue (bar, comp, val);
            var botVal = val;
            if(bar.name == "Sharpness"){
                botVal = botVal*PicTunerStep.SharpnessStep;
            }
            setModelValue(bar.name, botVal);
        };
        bar.onFocus = function () {
            return false;
        }
    }

    function CardWheelFunc() {

        var self = this;
        var cardWheelVec = [];
        var cardWheelLength = 5;
        var posYVec = [0 + 80, 95 + 80, 190 + 80, 95 + 80, 95 + 80];
        var DelayTimeData = {
            Time_0: 0,
            Time_400: 400
        };
        var ToVecNumeber = {
            Vec0: 0,
            Vec1: 1,
            Vec2: 2
        };
        var ToYPosition = {
            Y_57: 57,
            Y_80: 80,
            Y_105: 105
        };

        self.setHeadIdx = function (idx) {
            try {
                DBG_INFO('self.setHeadIdx: ' + idx);
                for (var i = 0; i < idx; i++) {
                    cardWheelVec.unshift(cardWheelVec.pop());
                }
                getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                switchLayer(cardWheelVec)
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        self.init = function () {
            var PQAdjustSignVec = ['picContrast', 'picBrightness', 'picColor', 'picTint', 'picSharpness'];
            var idx = PQAdjustSignVec.indexOf(PictureConfig.PQAdjustSign);
            DBG_INFO("CARD "+ PictureConfig.PQAdjustSign);

            cardWheelVec = [];
            for (var i = 0; i < cardWheelLength; i++) {
                cardWheelVec.push(UI.getItem(picPQAdjust, "cardWheel_" + i));
            }
            self.setHeadIdx(({0: 1, 1: 0, 2: 4, 3: 3, 4: 2}[idx]));
        };

        function switchLayer(cardWheelVec) {
            UI.moveTo(cardWheelVec[1], 4);
            UI.moveTo(cardWheelVec[2], 3);
            UI.moveTo(cardWheelVec[3], 2);
            UI.moveTo(cardWheelVec[4], 1);
            UI.moveTo(cardWheelVec[0], 0);
        }


        self.keyUp = function () {
            cardWheelVec.unshift(cardWheelVec.pop());
            getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
        };

        self.keyDown = function () {
            cardWheelVec.push(cardWheelVec.shift());
            getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
        };
        function getTweenTime(number,time,position) {
            DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
            UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                y: posYVec[1]
            }, time/2, UI.ease.quadIn);
            UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
            UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

            UI.getTween(cardWheelVec[2]).to({y: posYVec[2], alpha: 0.8}, time);
            UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10))).to({y: 105, alpha: 0.8}, 100);
            UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10)).scale).to({x: 0.67, y: 0.67});
            UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
            UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
            UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});

            UI.getTween(cardWheelVec[3]).to({y: posYVec[3], alpha: 0}, 0);
            UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10))).to({y: 80, alpha: 0}, 100);
            UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10)).scale).to({x: 1, y: 1});
            UI.getTween(cardWheelVec[4]).to({y: posYVec[4], alpha: 0}, 0);
            UI.getTween(UI.getItem(cardWheelVec[4],"cardWheelIcon_"+cardWheelVec[4].name.substr(10))).to({y: 80, alpha: 0}, 100);
            UI.getTween(UI.getItem(cardWheelVec[4],"cardWheelIcon_"+cardWheelVec[4].name.substr(10)).scale).to({x: 1, y: 1});
        }
    }
    var cardWheelObj = new CardWheelFunc();

    function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
        var topCfg = {y: -100 + 175, alpha: 0};
        var normalCfg = {y: 0 + 175, alpha: 1};
        var btmCfg = {y: 100 + 175, alpha: 0};
        var ToDirection = 1;

        cmpOri.onkey_UP = function (focus) {
            ToDirection = 1;
            UpDownKeyHandler(focus);
            cardWheelObj.keyUp();
        };

        cmpOri.onkey_DOWN = function (focus) {
            ToDirection = 0;
            UpDownKeyHandler(focus);
            cardWheelObj.keyDown();
        };
        function UpDownKeyHandler(focus){
            var cmpTo = ToDirection ? cmpUpTo : cmpDownTo;//UP:1;Down:0;
            DBG_INFO("onkey_UP_Down  cmpOri.name: "+cmpOri.name + "cmpTo.name: "+cmpTo.name);
            UI.getTween(cmpOri).to(!!ToDirection ? btmCfg : topCfg, 300);
            UI.getTween(cmpTo).to(!!ToDirection ? topCfg : btmCfg, 0).to(normalCfg, 400);
            picPQAdjust.currFocus = UI.getItem(picPQAdjust, !!ToDirection ? focus.upTo : focus.downTo);
            PictureConfig.PQAdjustSign =
                !!ToDirection ? "pic" + focus.upTo : "pic" +focus.downTo;
            var index=pctCmpVec.indexOf(PictureConfig.PQAdjustSign.substr(3));
            TTSCall(index);
        }
    }


    function setOnkeyEnterFunc(cmp){
        cmp.onkey_ENTER = function (focus) {
            return false;
        }
    }

    for (var i = 0; i < pctCmpVec.length; i++) {
        var j,k;
        j = (i-1)<0 ? 4 : i-1;
        k = (i+1)>4 ? 0 : i+1;
        setOnkeyUpDownFunc(eval(pctCmpVec[i]), eval(pctCmpVec[j]), eval(pctCmpVec[k]));
        setOnkeyEnterFunc(eval(pctCmpVec[i]));
    }


};