// Init

UI.moduleBuilder['setting']['picGammaCalibrationAdjust'] = function(){
    try {
        var initData = {
            percentBG: UI["liveTV_bg"],

            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: CardColorDef.BLUEGREEN},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/level.png",
            cardWheelIcon_1: "setting/pic/card_wheel/red.png"
        };
        var template = Util.readJsonObject("module/setting/picGammaCalibrationAdjust.json");

        var pctCmpVec = ['InputLevel', 'Gain'];
        var pctCmpLanVec = ['[SE3567]', '[SE3568]'];//专门为多语言添加
        var pctCmpDescriptionVec = ['[SE3743]', '[SE3744]'];

        for (var i = 0; i < pctCmpVec.length; i++) {
            template.picGammaCalibrationAdjust.items[pctCmpVec[i]] = getObjCopy(Util.readJson("templates/percentSingle.json")).percentBar;
            template.picGammaCalibrationAdjust.items[pctCmpVec[i]].position.y = 0;
            template.picGammaCalibrationAdjust.items[pctCmpVec[i]].items.title.value = pctCmpLanVec[i];
            template.picGammaCalibrationAdjust.items[pctCmpVec[i]].items.description.value = pctCmpDescriptionVec[i];
            template.picGammaCalibrationAdjust.items[pctCmpVec[i]].navigation =
            {
                "leftTo": null,
                "rightTo": null,
                "upTo": pctCmpVec[i - 1 >= 0 ? i - 1 : pctCmpVec.length-1],
                "downTo": pctCmpVec[i + 1 <= pctCmpVec.length-1 ? i + 1 : 0]
            };
//            if (pctCmpVec[i] != PictureConfig.PicGammaCalibrationSign.substr(14)) {
//                template.picGammaCalibrationAdjust.items[pctCmpVec[i]].position.y = 2000;
//            }
        }

        var cardWheel = {
            "type": 0,
            "position": {
                "x": -250,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": 0,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };


        // 20 50 150 200 0
        //位置不准确，缩放为中心缩放
        var cardWheelItemIndexVec = [{y: 0}, {y: 95}];

        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;
        }
        template.picGammaCalibrationAdjust.items['cardWheel'] = cardWheel;
        var picGammaCalibrationAdjust = SubModule.create(initData, template);

        var picGammaCalibrationAdjustPageData = {
            InputLevelTextVec:[5, 10, 15, 20, 25, 30, 35, 40, 45,
                50,55, 60, 65, 70, 75, 80, 85, 90, 95, 100],
            InputLevelVal: 0,
            GainVal: 0
        };

        picGammaCalibrationAdjust.onPush = function () {
            try {
                var CmpVec = [InputLevel, Gain];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }

                cardWheelObj.init();

                picGammaCalibrationAdjust.currFocus = UI.getItem(picGammaCalibrationAdjust, PictureConfig.PicGammaCalibrationSign);

                picGammaCalibrationAdjustPageInit();

                for (var i = 0; i < pctCmpVec.length; i++) {
                    var bar = eval(pctCmpVec[i]);
                    var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                    setOnkeyLeftRightFunc(bar, cmp, eval('picGammaCalibrationAdjustPageData.' + pctCmpVec[i] + "Val"));
                }

                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        picGammaCalibrationAdjust.onShow = function () {

            var normalCfg = {y: 0 + 175, alpha: 1};
            UI.getItem(picGammaCalibrationAdjust, PictureConfig.PicGammaCalibrationSign).alpha = 1;
            UI.getItem(picGammaCalibrationAdjust, PictureConfig.PicGammaCalibrationSign).y = normalCfg.y;
            UI.hideCursor();
        };

        function picGammaCalibrationAdjustPageInit() {
            try {
                var InputLevelValTemp = tv ? model.video.getGammaCalibrationLevel() : 3;
                DBG_INFO('model.video.getGammaCalibrationLevel(): ' + InputLevelValTemp);
                picGammaCalibrationAdjustPageData.InputLevelVal = picGammaCalibrationAdjustPageData.InputLevelTextVec[InputLevelValTemp];
                UI.getItem(eval(pctCmpVec[0]), "percentBarLine").setPercent(picGammaCalibrationAdjustPageData.InputLevelVal);
                UI.setText(InputLevelPercentBarText, picGammaCalibrationAdjustPageData.InputLevelVal + '%');


                var gainValTmp = tv ? model.video.getGammaCalibrationGain() : 0;
                picGammaCalibrationAdjustPageData.GainVal = gainValTmp / 2;
                DBG_INFO('model.video.getGammaCalibrationGain(): ' + picGammaCalibrationAdjustPageData.GainVal);
                UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercentNoVoice(picGammaCalibrationAdjustPageData.GainVal);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var InputLevel = UI.getItem(picGammaCalibrationAdjust, "InputLevel");
        var Gain = UI.getItem(picGammaCalibrationAdjust, "Gain");
        var InputLevelPercentBarText = UI.getItem(InputLevel,"percentBarText");

        function CardWheelFunc() {

            var self = this;
            var cardWheelVec = [];
            var cardWheelLength = 2;
            var posYVec = [0 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };

            self.init = function () {
                var picAdjustJudderBlurSignVec = ['InputLevel', 'Gain'];
                var idx = picAdjustJudderBlurSignVec.indexOf(PictureConfig.PicGammaCalibrationSign);
                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picGammaCalibrationAdjust, "cardWheel_" + i));
                    var cardWheelShadow = UI.getItem(cardWheelVec[cardWheelVec.length - 1], "cardWheelShadow");
                    cardWheelShadow.doFlip = true;
                }
                self.setHeadIdx(({0: 1, 1: 0}[idx]));
            };

            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }

            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0, DelayTimeData.Time_400, ToYPosition.Y_57);
            };
            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});
            }
        }

        var cardWheelObj = new CardWheelFunc();


        function CreatePercent(cmp, cmpTxt, val) {
            try {
                if (cmp.parent.name == 'InputLevel') {
                    Percent.create(cmp, cmpTxt, val, 5, 100);
                } else {
                    Percent.create(cmp, cmpTxt, val, -25, 25);
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setModelValue(name, val) {
            try {
                switch (name) {
                    case "InputLevel":
                        var valTemp = (val - 5) / 5;
                        tv && model.video.setGammaCalibrationLevel(valTemp);
                        DBG_INFO("model.video.setGammaCalibrationLevel(" + valTemp + ")");
                        setTimeout(function(){
                            var gainValTmp = tv ? model.video.getGammaCalibrationGain() : 0;
                            picGammaCalibrationAdjustPageData.GainVal = gainValTmp / 2;
                            DBG_INFO('model.video.getGammaCalibrationGain(): ' + picGammaCalibrationAdjustPageData.GainVal);
                            UI.getItem(eval(pctCmpVec[1]), "percentBarLine").setPercent(picGammaCalibrationAdjustPageData.GainVal);

                            for (var i = 1; i < pctCmpVec.length; i++) {
                                var bar = eval(pctCmpVec[i] );
                                var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
                                setOnkeyLeftRightFunc(bar, cmp, eval('picGammaCalibrationAdjustPageData.' + pctCmpVec[i] + "Val"));
                            }
                        }, 100);
                        break;
                    case "Gain":
                        tv && model.video.setGammaCalibrationGain(val * 2);
                        DBG_INFO("model.video.setGammaCalibrationGain(" + val * 2 + ")");
                        break;
                    default:
                        DBG_ERROR('name error');
                        break;
                }
                eval("picGammaCalibrationAdjustPageData."+name+"Val"+"=val");
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setOnkeyLeftRightFunc(bar, comp, val) {

            bar.onkey_LEFT = function () {
                DBG_INFO(bar.name + "onkey_LEFT");
                var minVal = 0;
                if ('InputLevel' == bar.name) {
                    val -= 5;
                    minVal = 5;
                } else {
                    val -= 1;
                    minVal = -25;
                }

                val < minVal && (val = minVal);
                comp.setPercent(val);
                'InputLevel' == bar.name && UI.setText(InputLevelPercentBarText, val + '%');
                setModelValue(bar.name, val);
            };
            bar.onkey_RIGHT = function () {
                DBG_INFO(bar.name + "onkey_RIGHT");
                var maxVal = 0;
                if ('InputLevel' == bar.name) {
                    val += 5;
                    maxVal = 100;
                } else {
                    val += 1;
                    maxVal = 25;
                }

                val > maxVal && (val = maxVal);
                comp.setPercent(val);
                'InputLevel' == bar.name && UI.setText(InputLevelPercentBarText, val + '%');
                setModelValue(bar.name, val);
            };
            bar.onFocus = function () {
                return false;
            }
        }

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                DBG_INFO(cmpOri.name + ".onkey_UP to " + cmpUpTo.name);
                UI.getTween(cmpOri).to(btmCfg, 300);
                UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);
                picGammaCalibrationAdjust.currFocus = UI.getItem(picGammaCalibrationAdjust, focus.upTo);
                PictureConfig.PicGammaCalibrationSign = cmpUpTo.name;
                DBG_INFO("PictureConfig.PicGammaCalibrationSign: " + cmpUpTo.name);
                cardWheelObj.keyUp();
//                if (GLOBAL.RTL && GLOBAL.CURRENT_LANGUAGE != "hbr") {
//                    UI.getCurrFocus().nokeyRTL = true;
//                } else {
//                    UI.getCurrFocus().nokeyRTL = false;
//                }
            };

            cmpOri.onkey_DOWN = function (focus) {
                DBG_INFO(cmpOri.name + "onkey_DOWN");
                DBG_INFO(cmpDownTo.name + "onkey_DOWN");
                UI.getTween(cmpOri).to(topCfg, 300);
                UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);
                picGammaCalibrationAdjust.currFocus = UI.getItem(picGammaCalibrationAdjust, focus.downTo);
                PictureConfig.PicGammaCalibrationSign = cmpDownTo.name;
                DBG_INFO("PictureConfig.PicGammaCalibrationSign: " + cmpDownTo.name);
                cardWheelObj.keyDown();
//                if (GLOBAL.RTL && GLOBAL.CURRENT_LANGUAGE != "hbr") {
//                    UI.getCurrFocus().nokeyRTL = true;
//                } else {
//                    UI.getCurrFocus().nokeyRTL = false;
//                }
            };
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }
        setOnkeyEnterFunc(InputLevel);
        setOnkeyEnterFunc(Gain);

        for (var i = 0; i < pctCmpVec.length; i++) {
            var bar = eval(pctCmpVec[i]);
            var cmp = UI.getItem(eval(pctCmpVec[i]), "percentBarLine");
            var cmpTxt = UI.getItem(eval(pctCmpVec[i]), "percentBarText");

            CreatePercent(cmp, cmpTxt, eval('picGammaCalibrationAdjustPageData.' + pctCmpVec[i] + "Val"));
            setOnkeyUpDownFunc(bar, eval(pctCmpVec[i - 1 >= 0 ? i - 1 : i + 2 - 1]), eval(pctCmpVec[i + 1 <= 1 ? i + 1 : i - 2 + 1]));
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};