// Init
UI.moduleBuilder['setting']['picExpert'] = function(){
    try {
        var heightEnum = {
            H_120: 120,
            H_72: 72
        };

        var cmpSpaceEnum = {
            H_0: 0,
            H_10: 10,
            H_24: 24,
            H_48: 48
        };
        var firMagTop = cmpSpaceEnum.H_48;

        var cmpCfgVector = [
            {
                id: "ExpertColorSpace",
                height: heightEnum.H_120
            },
            {
                id: "ExpertColorTuner",
                height: heightEnum.H_120
            },
            {
                id: "ExpertWhiteBalance",
                height: heightEnum.H_120
            },
            {
                id: "ExpertGammaAdjustment",
                height: heightEnum.H_120
            },
            {
                id: "ExpertGammaCalibration",
                height: heightEnum.H_120
            },
            {
                id: "ExpertRGBOnlyMode",
                height: heightEnum.H_120
            }
        ];
        var cmpIdVec = [];

        for (var i = 0; i < cmpCfgVector.length; i++) {
            cmpIdVec.push(cmpCfgVector[i].id);
        }

        function getCmpSpacing(idx) {
            if (0 == idx) {
                return firMagTop;//first
            } else {
                if (cmpCfgVector[idx].height == heightEnum.H_72 && cmpCfgVector[idx - 1].height == heightEnum.H_72) {
                    return cmpSpaceEnum.H_10;
                } else {
                    return cmpSpaceEnum.H_24
                }
            }
        }

        function getCmpPosY(cmpId) {
            var idx = cmpIdVec.indexOf(cmpId);
            var posY = cmpSpaceEnum.H_0;
            for (var i = 0; i < idx; i++) {
                posY += cmpCfgVector[i].height + getCmpSpacing(i + 1);
            }
            return posY;
        }

        var initData = {
            "picExpertSheet": UI.setting_bg,
            "picExpertIconImg": "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_picture_154x154.png",
            "ExpertColorSpaceBar": UI.btn_normal_bg,
            "ExpertColorTunerBg": UI.btn_normal_bg,
            "ExpertWhiteBalanceBg": UI.btn_normal_bg,
            "ExpertGammaAdjustmentBar": UI.btn_normal_bg,
            "ExpertGammaCalibrationBG": UI.btn_normal_bg,
            "ExpertRGBOnlyModeBar": UI.btn_normal_bg
        };
        var template = Util.readJsonObject("module/setting/picExpert.json");
        for (var i = 0; i < cmpCfgVector.length; i++) {
            DBG_INFO(cmpCfgVector[i].id + getCmpPosY(cmpCfgVector[i].id));
            template.picExpert.items.picExpertGrp.items[cmpCfgVector[i].id].position.y = getCmpPosY(cmpCfgVector[i].id);
            template.picExpert.items.picExpertGrp.items[cmpCfgVector[i].id].position.x = 0;
        }

        var picExpert = SubModule.create(initData, template);
        picExpert.noAutoClose = true;
        var picExpertGrp = UI.getItem(picExpert, "picExpertGrp");

        picExpert.onPush = function () {
            ModelNotifyInit();
            PicExpertPageInit();
            if (PicExpertPageData.isColorSpaceExist && PicExpertPageData.isColorSpaceEnable) {
                picExpert.currFocus = UI.getItem(picExpert, "ExpertColorSpace");
            } else {
                picExpert.currFocus = UI.getItem(picExpert, "ExpertColorTuner");
            }

            UI.updateStage();
        };
        picExpert.onShow = function () {
            UI.getItem(setting, 'picMain').alpha = 0;
            picExpert.alpha = 1;
        };

        var PicExpertPageData = {
            isHDRFlag: 0,
            isColorSpaceExist: true,
            isColorSpaceEnable: true,
            picColorSpaceTextVec: ["[GE0012]", "[SE2746]"], //["Auto", "Native"]
            ExpertRGBOnlyModeTextVec: ["[GE0006]", "[SE0517]", "[SE0519]", "[SE0521]"],
            ExpertGammaAdjustmentVal: 0,
            ExpertGammaAdjustmentTextVec: ["1.8", "2.0", "2.2", "2.4", "ITU.BT1886"],
            isGammaAdjustmentExist: 0,
            ExpertColorSpaceVal: 0,
            ExpertRGBOnlyModeVal: 0
        };

        var PictureModeData = {
            Vivid: 0,
            Standard: 1,
            EnergySaving:2,
            Movie: 3,
            Game: 4,
            Sport: 5,
            Calibrated: 6
        };

        var ExpertColorSpace = UI.getItem(picExpert, "ExpertColorSpace");
        var ExpertColorTuner = UI.getItem(picExpert, "ExpertColorTuner");
        var ExpertWhiteBalance = UI.getItem(picExpert, "ExpertWhiteBalance");
        var ExpertGammaAdjustment = UI.getItem(picExpert, "ExpertGammaAdjustment");
        var ExpertGammaCalibration = UI.getItem(picExpert, "ExpertGammaCalibration");
        var ExpertRGBOnlyMode = UI.getItem(picExpert, "ExpertRGBOnlyMode");

        SetHelpInfo();
        function SetHelpInfo() {
            var CmpHelpInfo = {
                ExpertColorSpace: {
                    title: " ",
                    info: "[SE3143]"
                },
                ExpertColorTuner: {
                    title: " ",
                    info: "[SE0485]"
                },
                ExpertWhiteBalance: {
                    title: " ",
                    info: "[SE0495]"
                },
                ExpertGammaAdjustment: {
                    title: " ",
                    info: "[SE3298]"
                },
                ExpertGammaCalibration: {
                    title: " ",
                    info: "[SE3742]"
                },
                ExpertRGBOnlyMode: {
                    title: " ",
                    info: "[SE3205]"
                }
            };
            try {
                var CmpVec = [ExpertColorSpace, ExpertColorTuner, ExpertWhiteBalance, ExpertGammaAdjustment, ExpertGammaCalibration, ExpertRGBOnlyMode];
                var infoCmp = UI.getItem(picExpert, 'picExpertInfo');
                for (var i = 0; i < CmpVec.length; i++) {
                    cmpSetOnNormalFocusFunc(CmpVec[i]);
                }
                function cmpSetOnNormalFocusFunc(cmp) {
                    cmp.onFocus = function () {
                        DBG_INFO('info: ' + CmpHelpInfo[cmp.name].info);
                        UI.setText(infoCmp, CmpHelpInfo[cmp.name].info);
                        return true;
                    };
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function PicExpertPageInit() {
            try {
                PicExpertPageData.isColorSpaceExist = tv ? model.video.getColorSpaceExist() : 1;
                DBG_INFO("model.video.getColorSpaceExist(): " + PicExpertPageData.isColorSpaceExist);
                if(PicExpertPageData.isColorSpaceExist){
                    var ExpertColorSpaceValTmp = tv ? model.video.getColorSpace() : 0;
                    DBG_INFO("model.video.getColorSpace(): " + ExpertColorSpaceValTmp);
                    PicExpertPageData.ExpertColorSpaceVal = PicExpertPageData.picColorSpaceTextVec[ExpertColorSpaceValTmp];
                    onColorSpaceChaged(ExpertColorSpaceValTmp);
                    PicExpertPageData.isColorSpaceEnable = checkColorSpaceEnable();
                    SetExpertEnable(ExpertColorSpace, PicExpertPageData.isColorSpaceEnable);
                }else{
                    setHideColorSpace();
                }

                var isGammaAdjustmentExist = tv ? model.video.getHdmiGammaAdjustmentExist() : 1;//1
                DBG_INFO("model.video.getHdmiGammaAdjustmentExist(): " + isGammaAdjustmentExist);
                if(isGammaAdjustmentExist){
                    var ExpertGammaAdjustmentValTmp = tv ? model.video.getHdmiGammaAdjustment() : 1;
                    PicExpertPageData.ExpertGammaAdjustmentVal = ({0: 1, 1: 2, 2: 3, 3: 4, 4: 0}[ExpertGammaAdjustmentValTmp]);
                    DBG_INFO("model.video.getHdmiGammaAdjustment(): " + PicExpertPageData.ExpertGammaAdjustmentVal);
                    onHdmiGammaAdjustmentChaged(ExpertGammaAdjustmentValTmp);
                    try {
                        PicExpertPageData.isHDRFlag = tv ? model.video.getHdrFlag() : 0;
                        DBG_INFO("model.video.getHdrFlag(): " + PicExpertPageData.isHDRFlag);
                        SetExpertEnable(ExpertGammaAdjustment, !PicExpertPageData.isHDRFlag);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }else{
                    setHideGammaAdjustment();
                }

                var ExpertRGBOnlyModeValTemp = tv ? model.video.getRgbOnlyMode() : 1;
                DBG_INFO("model.video.getRgbOnlyMode(): " + ExpertRGBOnlyModeValTemp);
                PicExpertPageData.ExpertRGBOnlyModeVal = PicExpertPageData.ExpertRGBOnlyModeTextVec[ExpertRGBOnlyModeValTemp];
                onRgbOnlyModeChaged(ExpertRGBOnlyModeValTemp);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function SetExpertEnable(disableItem, isEnable) {
            try{
                DBG_INFO(disableItem.name + ' '+ isEnable);
                if(!isEnable){
                    DBG_INFO(disableItem.name + ' '+ 'hide');
                    disableItem.disable = true;
                    disableItem.alpha = 0.3;
                }else{
                    DBG_INFO(disableItem.name + ' '+ 'show');
                    disableItem.disable = false;
                    disableItem.alpha = 1;
                }
            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function checkColorSpaceEnable(){
            var isPicMode = tv ? model.video.getEnumPictureMode() : 1;
            if((isPicMode == PictureModeData.Vivid) || (isPicMode == PictureModeData.Sport)){
                return false;
            }
            return true;
        }

        function setHideColorSpace(){
            try {
                DBG_INFO("Hide Color Space");
                ExpertColorSpace.disable = true;
                ExpertColorSpace.alpha = 0;

                ExpertColorTuner.y = ExpertColorSpace.y;
                ExpertWhiteBalance.y = ExpertColorTuner.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                ExpertGammaAdjustment.y = ExpertWhiteBalance.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                ExpertGammaCalibration.y = ExpertGammaAdjustment.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                ExpertRGBOnlyMode.y = ExpertGammaCalibration.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setHideGammaAdjustment() {
            try {
                DBG_INFO("Hide Smooth Motion");
                if(ExpertGammaCalibration.y == ExpertGammaAdjustment.y) return;
                ExpertGammaAdjustment.disable = true;
                ExpertGammaAdjustment.alpha = 0;
                ExpertGammaCalibration.y = ExpertGammaAdjustment.y;
                ExpertRGBOnlyMode.y = ExpertGammaCalibration.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function CreateLabelFunc(label, labelStr) {
            try {
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, FontDef.Arial_36, "0xFFFFFF");
                cmpValue.setValue(eval('PicExpertPageData.' + label.name + "Val").toString());
                UI.updateStage();
                label.onkey_ENTER = function () {
                    if(label.name == "ExpertGammaAdjustment" && !!PicExpertPageData.isHDRFlag){
                        UI.showSimpleTip("[SE3321]");
                    } else {
                        PictureConfig.picModeSign = 'pic' + label.name.substr(6);
                        HidePicExpertMain();
                        UI.pushSubModule("setting", "picMode", true);
                        DBG_INFO(label.name + ".onkey_ENTER");
                    }
                };
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        CreateLabelFunc(ExpertColorSpace, "[SE3138]");
        CreateLabelFunc(ExpertGammaAdjustment, "[SE3139]");
        CreateLabelFunc(ExpertRGBOnlyMode, "[SE3140]");

        var onColorSpaceChaged = function (val) {
            try {
                DBG_INFO("onColorSpaceChaged: " + val);
                PicExpertPageData.ExpertColorSpaceVal = PicExpertPageData.picColorSpaceTextVec[val];
                UILabelSetVal(ExpertColorSpace);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var onHdmiGammaAdjustmentChaged = function (val) {
            try {
                DBG_INFO("onHdmiGammaAdjustmentChaged: " + val);
                val = ({0: 1, 1: 2, 2: 3, 3: 4, 4: 0}[val]);
                PicExpertPageData.ExpertGammaAdjustmentVal = PicExpertPageData.ExpertGammaAdjustmentTextVec[val];
                UILabelSetVal(ExpertGammaAdjustment);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var onRgbOnlyModeChaged = function (val) {
            try {
                DBG_INFO("onRgbOnlyChaged: " + val);
                PicExpertPageData.ExpertRGBOnlyModeVal = PicExpertPageData.ExpertRGBOnlyModeTextVec[val];
                UILabelSetVal(ExpertRGBOnlyMode);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicExpertPageData.' + label.name + "Val"));
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SPACE, onColorSpaceChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_ADJUSTMENT, onHdmiGammaAdjustmentChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_RGB_ONLY_MODE, onRgbOnlyModeChaged);
//                model.video.onHdmiGammaAdjustmentChaged = onHdmiGammaAdjustmentChaged;
//                model.video.onRgbOnlyModeChaged = onRgbOnlyModeChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        ExpertWhiteBalance.onkey_ENTER = function () {
            DBG_INFO('ExpertWhiteBalance.onkey_ENTER');
            HidePicExpertMain();
            var curPot = tv ? model.video.getWhiteBalanceTenTwoPointsMode() : 0;//0 2point 1 10point
            DBG_INFO("model.video.getWhiteBalanceTenTwoPointsMode(): " + curPot);
            if (0 == curPot) {
                PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_2_POT;
//                UI.pushSubModule("setting", "picPanelBal2Pot", true);
            } else {
                PictureConfig.PicWteBalSign=PicSignDefine.PicWteBalSign.PIC_BALANCE_10_POT;
//                UI.pushSubModule("setting", "picPanelBal10Pot", true);
            }
            UI.pushSubModule("setting", "picPanelWhiteBalance", true);
        };

        ExpertColorTuner.onkey_ENTER = function () {
            HidePicExpertMain();
            UI.pushSubModule("setting", "picPanelColorTuner", true);
            DBG_INFO('ExpertColorTuner.onkey_ENTER');
        };

        ExpertGammaCalibration.onkey_ENTER = function(){
            DBG_INFO('SettingsGammaCalibration.onkey_ENTER');
            HidePicExpertMain();
            UI.pushSubModule("setting", "picGammaCalibration", true);
        };

        function HidePicExpertMain() {
            picExpert.alpha = 0;
        }
        picExpert.onPop = function(){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SPACE, onColorSpaceChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_ADJUSTMENT, onHdmiGammaAdjustmentChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_RGB_ONLY_MODE, onRgbOnlyModeChaged);
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};