// Init
UI.moduleBuilder['setting']['SysTimeInputPanel'] = function(){

    var initData = {
            ImgBg: UI.bg_overlay,
            InputDialogBg: UI.window_bg,
            numIpt0: "setting/input_password_focused.png",
            numIpt1: "setting/input_password_normal.png",
            Bg: UI.window_bg,
            DeleteBg: UI.item_bg,
            NumDelete:"setting/key_delete.png",
            ZeroBg: UI.item_bg,
            PreBg: UI.item_bg,
            NextBg: UI.item_bg,
            DeleteText:"[GE0014]",//"Delete"
            InputDialogTitle: "[SE0251]",//"Time",
            PreText:"[GE0011]", // "Previous",
            NextText:"[GE0010]" //"Next"
        };
        var operateData = {
            "curtimeformat": 0,
            "clearflag": 0
        }
        var template = Util.readJson("module/setting/SysTimeInputPanel.json");
        var SysTimeInputPanel = SubModule.create(initData, template);
        var InputDialog = UI.getItem(SysTimeInputPanel, "InputDialog");
        var numberInput = UI.getItem(InputDialog, "numberInput");
        var NumPadPanel = UI.getItem(SysTimeInputPanel, "NumPadPanel");
        var NumPadList = UI.getItem(NumPadPanel, "NumPadList");

        var info = {
            template: "NumPadTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceX: 40,
            distanceY: 20,
            container: NumPadList
        };
        var allArray = [];
        var NumData = ["1", "2", "3", "4", "5", "6", "7", "8", "9"];
        for (var i = 0; i < 9; i++) {
            allArray.push(
                {
                    tileBg: UI.item_bg,
                    Num: NumData[i],
                    name: "NumData" + i
                }
            )
        }
        info.container = NumPadList;
        // ����Gird.create�������Gird����ӵ�ê��λ����
        Gird.create(allArray, info);
        // �������ַ�Χ��������ʾ���µ�ͼ��
        //UI.addMask(NumPadList, 988, 354);
        // ������Ұ��Χ�������㳬���˷�Χʱ�����gird�ᷴ���ƶ����ﵽ����Ч��˴����õ�x��y��ȫ����꣩
        //UI.setView(NumPadList, 988, 354);

        SysTimeInputPanel.currFocus = UI.getItem(NumPadList, "NumData0");
        SysTimeInputPanel.operateData = operateData;
        var NumData2 = UI.getItem(NumPadList, "NumData2");
        var NumData5 = UI.getItem(NumPadList, "NumData5");
        var NumData6 = UI.getItem(NumPadList, "NumData6");
        var NumData7 = UI.getItem(NumPadList, "NumData7");
        var NumData8 = UI.getItem(NumPadList, "NumData8");
        var NumPadDelete = UI.getItem(NumPadPanel, "NumPadDelete");
        var NumPadZero = UI.getItem(NumPadPanel, "NumPadZero");
        var NumPadPre = UI.getItem(NumPadPanel, "NumPadPre");
        var NumPadNext = UI.getItem(NumPadPanel, "NumPadNext");
        NumData2.rightTo = "NumPadDelete";
        NumData5.rightTo = "NumPadDelete";
        NumData8.rightTo = "NumPadZero";
        NumPadDelete.leftTo = "NumData2";
        //NumPadDelete.upTo = "numIpt1";
        NumPadZero.leftTo = "NumData8";
        //numberInput.downTo = "NumData0";
        //NumPadList.upTo = "numIpt1";
        NumData6.downTo = "NumPadPre";
        NumData7.downTo = "NumPadPre";
        NumData8.downTo = "NumPadNext";
        NumPadZero.downTo = "NumPadNext";
    NumPadPre.upTo = "NumData7";
    NumPadNext.upTo = "NumPadZero";
        NumPadPre.rightTo = "NumPadNext";
        NumPadNext.leftTo = "NumPadPre";

        var noIptBar = UI.getItem(SysTimeInputPanel, "numberInput");
        var noIpt0 = UI.getItem(noIptBar, "numIpt0");
        var noIpt1 = UI.getItem(noIptBar, "numIpt1");
        var NumInfoHour = {
            initVal: "",
            min: 0,
            max: 9999,
            fontSize: 40,
            align: "center",
        color: 0xFFFFFF
    };
    var NumInfoMin = {
        initVal: "",
        min: 0,
        max: 9999,
        fontSize: 40,
        align: "center",
        color: 0xFFFFFF
        };
        NumberInput.create(noIpt0, NumInfoHour);
        NumberInput.create(noIpt1, NumInfoMin);
    numberInput.noRTL=true;
    noIpt0.nokeyRTL=true;
    noIpt1.nokeyRTL=true;

    function SysTimeInputInit(operateData) {
        try {
            operateData.curtimeformat = model.datetime.getTimeFormat();
        }
        catch
            (e) {
            DBG_ERROR(e.message);

        }

    }
    var SysTimeInputPanel = UI.getSubModule("SysTimeInputPanel");
    var NumPadPanel = UI.getItem(SysTimeInputPanel, "NumPadPanel");
    var NumPadList = UI.getItem(NumPadPanel, "NumPadList");
    var NumPadDelete = UI.getItem(NumPadPanel, "NumPadDelete");
    var NumPadZero = UI.getItem(NumPadPanel, "NumPadZero");
    var NumPadPre = UI.getItem(NumPadPanel, "NumPadPre");
    var NumPadNext = UI.getItem(NumPadPanel, "NumPadNext");
    var NextText = UI.getItem(NumPadNext, "NextText");
    // ��������Ϊ���������
    var noIptBar = UI.getItem(SysTimeInputPanel, "numberInput");
    var noIpt0 = UI.getItem(noIptBar, "numIpt0");
    var noIpt1 = UI.getItem(noIptBar, "numIpt1");

    SysTimeInputPanel.onPush = function () {
        SysTimeInputInit(SysTimeInputPanel.operateData);
        initPageData(SysTimeInputPanel);
        SysTimeInputPanel.currFocus = UI.getItem(NumPadList, "NumData0");
        SysTimeInputPanel.operateData.clearflag = 1;
        UI.updateStage();
    };
    function initPageData(submodule) {
        var time = submodule.param.time;
      //  noIpt0.children[1].text = time.hour;
        noIpt0.setText(time.hour);
       // noIpt1.children[1].text = time.min;
        noIpt1.setText(time.min);
        SysTimeInputPanel.clearFlag = true;
        SysTimeInputPanel.currInputIndex = submodule.param.inputIndex;
        if (SysTimeInputPanel.currInputIndex == 0) {
            UI.setText(NextText, "[GE0010]");
            UI.setImage(noIpt0, "setting/input_password_focused.png");
            UI.setImage(noIpt1, "setting/input_password_normal.png");
        } else {
            UI.setText(NextText, "[GE0007]");
            UI.setImage(noIpt0, "setting/input_password_normal.png");
            UI.setImage(noIpt1, "setting/input_password_focused.png");
        }
    }

    NumPadList.onkey_ENTER = function () {
        DBG_INFO("NumPadList.onkey_ENTER" + SysTimeInputPanel.currFocus.children[1].children[0]);
        var text = SysTimeInputPanel.currFocus.children[1].children[0].text;
        setInputTxtAndIndex(text);
    };
    NumPadDelete.onkey_ENTER = function () {
        DeleteInputTxtAndIndex();
    };
    NumPadZero.onkey_ENTER = function () {
        var text = SysTimeInputPanel.currFocus.children[1].children[0].text;
        DBG_INFO("NumPadZero.onkey_ENTER" + text);
        setInputTxtAndIndex(text);
    };
    NumPadNext.onkey_ENTER = function () {
        DBG_INFO("NumPadNext.onkey_ENTER");
        switch (SysTimeInputPanel.currInputIndex) {
            case 0:
                setCurrIndexAndImg(0, 1);
                break;
            case 1:
                if (isInputValid()) {
                    settingUpdateInputTime();
                    UI.popSubModule();
                }
                else {
                    //todo to popup toast to tell the input is notvalid
                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.INPUTCHECK;
                    UI.pushGhostModule("setting", "SettingSysToast")

                }

                break;
            default :
                break;
        }
        SysTimeInputPanel.clearFlag = true;
    };
    function isInputValid() {
        var input1 = noIpt0.children[1].text;
        var input2 = noIpt1.children[1].text;
        var hour = parseInt(input1, 10);
        var min = parseInt(input2, 10);
        if (isNaN(hour) || isNaN(min)) return false;

        if (SysTimeInputPanel.operateData.curtimeformat == 0
            && (hour <= 0 || hour >= 13 || min >= 60)) {
            return false;
        }
        if (SysTimeInputPanel.operateData.curtimeformat == 1
            && (hour >= 24 || min >= 60)) {
            return false;
        }
        return true;

    }

    function settingUpdateInputTime() {
        var input1 = noIpt0.children[1].text;
        var input2 = noIpt1.children[1].text;
        var hour = input1;
        var min = input2;
        if (setting.sysdata.curInputType == 0) {
            var SettingSysBlockTime = UI.getSubModule("SettingSysBlockTime");
            if (!!SettingSysBlockTime) {
                SettingSysBlockTime.operateData.refreshstartcallback.call(this,hour, min);
            }
        }
        else if (setting.sysdata.curInputType == 1) {
            var SettingSysBlockTime = UI.getSubModule("SettingSysBlockTime");
            if (!!SettingSysBlockTime) {
                SettingSysBlockTime.operateData.refreshendcallback.call(this,hour, min);
            }

        }
        else if (setting.sysdata.curInputType == 2) {
            var SettingSysDateTime = UI.getSubModule("SettingSysDateTime");
            if (!!SettingSysDateTime) {
                SettingSysDateTime.operateData.refreshtimecallback.call(this,hour, min);
            }

        }
        else if (setting.sysdata.curInputType ==3) {
            var SettingSysPowerOn = UI.getSubModule("SettingSysPowerOn");
            if (!!SettingSysPowerOn) {
                SettingSysPowerOn.operateData.refreshtimecallback.call(this,hour, min);
            }

        }
        else if (setting.sysdata.curInputType ==4) {
            var SettingSysPowerOff = UI.getSubModule("SettingSysPowerOff");
            if (!!SettingSysPowerOff) {
                SettingSysPowerOff.operateData.refreshtimecallback.call(this,hour, min);
            }

        }
    }

    NumPadPre.onkey_ENTER = function () {
        DBG_INFO("NumPadPre.onkey_ENTER");
        switch (SysTimeInputPanel.currInputIndex) {
            case 0:
                break;
            case 1:
                setCurrIndexAndImg(1, 0);
                break;
            default :
                break;
        }
        SysTimeInputPanel.clearFlag = true;
    };
    function setInputTxtAndIndex(text) {
        if (SysTimeInputPanel.currInputIndex == 0) {
            var txt = noIpt0.children[1];
            var txtNext = noIpt1.children[1];
            var tempTxt = txt.text;
            tempTxt = tempTxt + text;
            var tempinput = parseInt(text, 10);
            var tempNum = parseInt(tempTxt, 10);
            if (SysTimeInputPanel.clearFlag) {
                txt.text = ((tempinput + 100) + "").substring(1);
                SysTimeInputPanel.clearFlag = false;
            }
            else {
                if (SysTimeInputPanel.operateData.curtimeformat == 0) {
                    if (tempNum > 0 && tempNum < 13) {
                        txt.text = ((tempNum + 100) + "").substring(1);

                    }
                    else if (tempNum >= 13) {
                        //  var currValue = parseInt(tempNum / 10);
                        var nextValue = tempNum % 10;
                        txtNext.text = ((nextValue + 100) + "").substring(1);
                        setCurrIndexAndImg(0, 1);
                    }

                }
                else {
                    if (tempNum >= 0 && tempNum < 24) {
                        txt.text = ((tempNum + 100) + "").substring(1);
                    }
                    else if (tempNum >= 24) {
                        var nextValue = tempNum % 10;
                        txtNext.text = ((nextValue + 100) + "").substring(1);
                        setCurrIndexAndImg(0, 1);
                    }
                }


            }
            UI.updateStage();
        } else if (SysTimeInputPanel.currInputIndex == 1) {
            var txt = noIpt1.children[1];
            var tempTxt = txt.text;
            tempTxt = tempTxt + text;
            var tempinput = parseInt(text, 10);
            if (SysTimeInputPanel.clearFlag) {
                txt.text = ((tempinput + 100) + "").substring(1);
                SysTimeInputPanel.clearFlag = false;
            }
            else {
                var tempNum = parseInt(tempTxt, 10);
                if (tempNum >= 0 && tempNum < 60) {
                    txt.text = ((tempNum + 100) + "").substring(1);

                }
                else
                {
                  var nextValue = tempNum % 10;
                  txt.text = ((nextValue + 100) + "").substring(1);
                }

            }
            UI.updateStage();
        }
    }

    function setCurrIndexAndImg(curr, next) {
        var Currtarget = UI.getItem(noIptBar, "numIpt" + curr);
        var Nexttarget = UI.getItem(noIptBar, "numIpt" + next);
        UI.setImage(Currtarget, "setting/input_password_normal.png");
        UI.setImage(Nexttarget, "setting/input_password_focused.png");
        SysTimeInputPanel.currInputIndex = next;
        if (next == 1) {
            UI.setText(NextText, "[GE0007]");//"OK",
        }
        else {
            UI.setText(NextText, "[GE0010]");//"Next"
        }
    }

    function DeleteInputTxtAndIndex() {
        if (SysTimeInputPanel.currInputIndex == 0) {
            noIpt0.children[1].text = noIpt0.children[1].text.slice(0, -1);
            UI.updateStage();
        } else if (SysTimeInputPanel.currInputIndex == 1) {
            if (noIpt1.children[1].text != "") {
                noIpt1.children[1].text = noIpt1.children[1].text.slice(0, -1);
                UI.updateStage();
            } else {
                noIpt0.children[1].text = noIpt0.children[1].text.slice(0, -1);
                UI.updateStage();
                setCurrIndexAndImg(1, 0);
            }
        }
    }

    var proIpNumKey = function (foucs, event) {
        if (event.keyState == 1) {
            var keyValue = CONST.NUMIPT_VALUE[UI.currKeyValue];
            setInputTxtAndIndex(keyValue);
        }
    };
    NumPadPanel.onkey_ZERO = proIpNumKey;
    NumPadPanel.onkey_ONE = proIpNumKey;
    NumPadPanel.onkey_TWO = proIpNumKey;
    NumPadPanel.onkey_THREE = proIpNumKey;
    NumPadPanel.onkey_FOUR = proIpNumKey;
    NumPadPanel.onkey_FIVE = proIpNumKey;
    NumPadPanel.onkey_SIX = proIpNumKey;
    NumPadPanel.onkey_SEVEN = proIpNumKey;
    NumPadPanel.onkey_EIGHT = proIpNumKey;
    NumPadPanel.onkey_NINE = proIpNumKey;
    SysTimeInputPanel.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }
};