// Init
UI.moduleBuilder['setting']['ChScanTypePanel'] = function(){
    var initData = {
        ChScanTypeBg:UI.bg_overlay,
        ChScanTypeListBg:UI.window_bg,
        ChScanTypeTitle:"[SE0582]"//"Tuner Mode",
    };
    var template = Util.readJson("module/setting/ChScanTypePanel.json");
    var ChScanTypePanel = SubModule.create(initData, template);

    ChScanTypePanel.operateData = {
        "tunerModeMapList" : [
            {
                "map":15,
                "name":"[SE0384]",//"Antenna",
                "flag":false
            },
            {
                "map":16,
                "name":"[SE0385]",//"Cable",
                "flag":false
            }
        ],
        "currTunerModeIdx" : 0
    };
    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(ChScanTypePanel, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template : "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction : CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum : 1,
        // 每隔图标之间的距离
        distanceX : 0,
        distanceY : 20,
        // 要将此Grid添加到哪个锚点位置上
        container : List
    };
    // 声明一个初始化用数组，将数据配置好
    var allArray =[];
    for (var i = 0; i < ChScanTypePanel.operateData.tunerModeMapList.length; i++) {
        allArray.push(
            {
                ItemName : ChScanTypePanel.operateData.tunerModeMapList[i].name,
                tileBg:UI.item_bg,
                name : "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）
    //UI.addMask(List, 820, 394);
    //UI.setView(List, 820, 394);
    //UI.addScrollbar(List);
    ChScanTypePanel.currFocus = UI.getItem(List, "item"+ChScanTypePanel.operateData.currTunerModeIdx);
    ChScanTypePanel.onShow = function(){
        DBG_INFO("setChScanTypePanel.onShow");
        ChScanTypePanel.operateData.currTunerModeIdx = ChgetCurrScanTypeIdx();
        for(var i = 0; i< List.initSequence.length;i++){
            UI.setImage(List.children[i].children[2],"setting/ic_radiobutton_normal.png");
        }
        ChScanTypePanel.currFocus = UI.getItem(List, "item"+ChScanTypePanel.operateData.currTunerModeIdx);
        UI.focusTo(ChScanTypePanel.currFocus);
        UI.setImage(ChScanTypePanel.currFocus.children[2],"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_radiobutton_focused.png");
    };
    function ChgetCurrScanTypeIdx(){
        try{
            if(!tv){
                var ChMainPanel = UI.getSubModule("ChMainPanel");
                return ChMainPanel.CurrTunerMode;
            }else
            {
                var scanType = model.channelSearch.getSource();
                DBG_INFO("ChgetCurrScanTypeIdx:scanType="+scanType,DebugLevel.ALWAYS);
                for(var i = 0; i < ChScanTypePanel.operateData.tunerModeMapList.length; i++){
                    if(scanType == ChScanTypePanel.operateData.tunerModeMapList[i].map){
                        break;
                    }
                }
                if(i == ChScanTypePanel.operateData.tunerModeMapList.length){
                    DBG_INFO("ChgetCurrScanTypeIdx:error!!");
                    i = 0;
                    model.channelSearch.setSource(ChScanTypePanel.operateData.tunerModeMapList[0].map);
                }
                return i;
            }
        }catch (ex){
            DBG_INFO("ChgetCurrScanTypeIdx:"+ex.message,DebugLevel.ERROR);
        }
    }

    ChScanTypePanel.TimeOutTimer = null;
    function ChSetCurrScanTypeIdx(idx){
        try{
            ChScanTypePanel.operateData.currTunerModeIdx = idx;
            if(tv){
                var channelScanTypeMapList = ChScanTypePanel.operateData.tunerModeMapList;
                if(idx > channelScanTypeMapList.length-1){
                    DBG_INFO("ChSetCurrScanTypeIdx:idx="+idx,DebugLevel.ERROR);
                    idx = 0;
                }
                model.channelSearch.setSource(channelScanTypeMapList[idx].map);
                setPlayedChListIndex(CHLISTINDEX.ALL);
            }
            var ChMainPanel = UI.getSubModule("ChMainPanel");
            ChMainPanel.setTunerMode(idx);
        }catch(ex){
            DBG_INFO("ChSetCurrScanTypeIdx:"+ex.message,DebugLevel.ERROR);
        }

    }
    List.onkey_ENTER = function(focus) {
        var index = List.initSequence.indexOf(focus);//ChScanTypePanel.currFocus.name.slice(-1);
        for(var i = 0; i < List.initSequence.length;i++){
            UI.setImage(List.children[i].children[2],"setting/ic_radiobutton_normal.png");
        }
        UI.setImage(ChScanTypePanel.currFocus.children[2],"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_radiobutton_focused.png");
        ChSetCurrScanTypeIdx(index);
        liveTV.playAfterChangeTunerMode(index);

        DBG_INFO("currTunerModeIdx::"+index ,DebugLevel.ALWAYS);
        clearTimeout(ChScanTypePanel.TimeOutTimer);
        ChScanTypePanel.TimeOutTimer = setTimeout(function(){
                UI.popSubModule();
            }
          ,500);
        return false;
    };

}