// Init
UI.moduleBuilder['setting']['ChManualScanPanel'] = function(){

    var initData = {
        ImgBg:UI.bg_overlay,
        ManualScanImg:UI.window_bg,
        numIpt1:"setting/"+GLOBAL.LAUNCHER_BRAND+"/NumInputFocus.png",
        ScanBtnImg:UI.item_bg,
        ManualScanTitle:"[SE3149]",//"Add a Channel",
        ManualScanInfo:"[SE3018]",//"Manually install a channel",
        ChNumText:"[SE2159]",//"Channel Number:",
        NumInfoText:"[SE3015]",//Please enter 1-135
        ScanBtntext:"[SE0271]" // "Start"

    };
    var template = Util.readJson("module/setting/ChManualScanPanel.json");
    var ChManualScanPanel = SubModule.create(initData, template);
    var ManualScanPage = UI.getItem(ChManualScanPanel, "ManualScanPage");
    var NumInfoText = UI.getItem(ManualScanPage,"NumInfoText");
    var DTVBtn = UI.getItem(ManualScanPage,"DTVBtn");
    var DTVNum = UI.getItem(DTVBtn,"DTVNum");
    var ATVBtn = UI.getItem(ManualScanPage,"ATVBtn");
    var ATVNum = UI.getItem(ATVBtn,"ATVNum");
    var ManualScanBtn = UI.getItem(ManualScanPage,"ManualScanBtn");
    var ScanBtntext = UI.getItem(ManualScanBtn,"ScanBtntext");
    var noIptBar = UI.getItem(ManualScanPage, "numberInput");
    var numberInput = UI.getItem(ChManualScanPanel, "numberInput");
    var ChNumText = UI.getItem(numberInput, "ChNumText");
    var ChNum1 = UI.getItem(numberInput, "ChNum1");
    var numIpt1 = UI.getItem(numberInput, "numIpt1");
    // 根据字符宽度动态设置坐标
    //ChNum1.x = UI.getTextWidth(ChNumText);
    //DBG_INFO("ChNum1.x"+ChNum1.x);
    //numIpt1.x = ChNum1.x +numIpt1.getBounds().width / 2 + ChNum1.getBounds().width +20 ;
    //DBG_INFO(" numIpt1.x"+numIpt1.x);
    // 设置遮罩范围，隐藏显示不下的图标
    ChManualScanPanel.InfoText = ["[SE3016]","[SE3015]"];//Please enter 2-69;Please enter 1-135
    ChManualScanPanel.currFocus = UI.getItem(numberInput, "numIpt1");
    ChManualScanPanel.noAutoClose = true;
    ChManualScanPanel.protected=true;
    ChManualScanPanel.enableKeyGroup = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_BACKSPACE, CONST.KEY.VK_ENTER, CONST.KEY.VK_EXIT,
        CONST.KEY.VK_POWER,
        CONST.KEY.VK_1, CONST.KEY.VK_2, CONST.KEY.VK_3, CONST.KEY.VK_4, CONST.KEY.VK_5,
        CONST.KEY.VK_6, CONST.KEY.VK_7, CONST.KEY.VK_8, CONST.KEY.VK_9, CONST.KEY.VK_0,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,
        CONST.KEY.VK_KEYPAD_VOLUME_UP,CONST.KEY.VK_KEYPAD_VOLUME_DOWN,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_CHANNEL_UP, CONST.KEY.VK_CHANNEL_DOWN,CONST.KEY.VK_KEYPAD_CHANNEL_UP,
        CONST.KEY.VK_KEYPAD_CHANNEL_DOWN
    ];

    ChManualScanPanel.onPush =  function(){
        DBG_INFO("ChManualScanPanel.onPush");
        UI.registerKeyCodes(ChManualScanPanel.enableKeyGroup);
        UI.setKeyGroup(7);
        settingInitChSetAutoScanPage();
        ChManualScanPanel.currFocus = UI.getItem(numberInput, "numIpt1");
    };
    ChManualScanPanel.setManualInputNum = function(txt){
        DBG_INFO("setManualInputNum="+txt,DebugLevel.INFO);
        numIpt1.setText(txt);
    };
    function settingInitChSetAutoScanPage(){
        //data init
        ChManualScanPanel.chScanState = 0;//0:设置；1;搜台
        ChManualScanPanel.chScanText = 0; // 0: scan text ;1:complete text
        ChManualScanPanel.currtunerMode = tv? model.channelSearch.getSource():15;
        ChManualScanPanel.origTunerMode = ChManualScanPanel.currtunerMode;
        if (ChManualScanPanel.currtunerMode == 15)
            ChManualScanPanel.currtunerMode = 0; //ATSCT
        else
            ChManualScanPanel.currtunerMode = 1; //ATSCC
        ChManualScanPanel.currTunerModeNum = 1; // 1: scan DTV ; 2: scan ATV
        ChManualScanPanel.analogChannelNum = 0;
        ChManualScanPanel.digitChannelNum = 0;
        ChManualScanPanel.clearFlag = false;

        // UI init
        UI.setText(DTVNum,"0");
        UI.setText(ATVNum,"0");
        UI.setText(NumInfoText,ChManualScanPanel.InfoText[ChManualScanPanel.currtunerMode]);
        numIpt1.setText("");
        DTVBtn.alpha = 0;
        ATVBtn.alpha = 0;
        //NumInfoText.alpha = 1;
        ManualScanPage.alpha = 1;
        ManualScanBtn.alpha = 1;
        UI.setText(ScanBtntext,"[SE0271]");//"Start"
        //注册callback函数
        try{
            if(tv){
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_DIGIT_SERVICES_CHANGED, settingChScanDigitServicesChangeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_ANALOG_SERVICES_CHANGED, settingChScanAnalogServicesChangeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCH_STATE_CHANGED, settingChScanStateChangeCallBack);
            }
        }catch (ex){
            DBG_INFO("settingInitChSetAutoScanPage: "+ex.message,DebugLevel.ERROR);
        }
    }
    function settingChScanDigitServicesChangeCallBack(value){
        DBG_INFO("settingChScanDigitServicesChangeCallBack::"+value,DebugLevel.ALWAYS);
        ChManualScanPanel.digitChannelNum = value;
        UI.setText(DTVNum,value+"");
    }
    function settingChScanAnalogServicesChangeCallBack(value){
        DBG_INFO("settingChScanAnalogServicesChangeCallBack::"+value,DebugLevel.ALWAYS);
        UI.setText(ATVNum,value+"");
    }
    function settingChScanStateChangeCallBack(value){
        try{
            DBG_INFO("settingChScanStateChangeCallBack:"+value,DebugLevel.ALWAYS);
            switch (value){
                case 0://complete
                    if ((ChManualScanPanel.currTunerModeNum == 1) &&(ChManualScanPanel.digitChannelNum <= 0)) {
                        DBG_INFO("the dtv is not found channel,need to start atv manual scan",DebugLevel.ALWAYS);
                        ChManualScanPanel.currTunerModeNum = 2;
                        ChangeTunerMode();
                    } else {
                        ChManualScanPanel.chScanState = 0;
                        ChManualScanPanel.chScanText = 1;
                        ManualScanBtn.alpha = 1;
                        UI.setText(ScanBtntext,"[SE0589]");
                        ChManualScanPanel.ScanFlag = 0;
                        if (ChManualScanPanel.currTunerModeNum == 2){
                            DBG_INFO("need to change source from atv to dtv",DebugLevel.ALWAYS);
                            model.channelSearch.setSource(ChManualScanPanel.origTunerMode);
                        }
                        model.channelSearch.Finish();
                        UI.setVoiceStr(ScanBtntext,"[SE0589]");
                    }
                    break;
                case 1://searching
                    break;
                default :
                    ChManualScanPanel.chScanState = 1;
                    ManualScanBtn.alpha = 0.3;
                    UI.updateStage();
                    break;
            }
        }catch(ex){
            DBG_INFO("settingChScanStateChangeCallBack:"+ex.message,DebugLevel.ERROR);
        }
    }

    function ChangeTunerMode(){
        if(tv){
            if(ChManualScanPanel.currtunerMode == 0){    //from ATSC-T
                model.channelSearch.setSource(17);//to   Analog-T
            }else{                                                       //from ATSC-C
                model.channelSearch.setSource(18);//to   Analog-C
            }

            model.channelSearch.setSearchFrequency(ChManualScanPanel.CurrNum);
            model.channelSearch.Start(1);
        }
    }
    var NumInfo = {
        initVal : "",
        min : 0,
        max : 9999,
        fontSize : 40,
        align:"center",
        color : 0xFFFFFF
    };
    NumberInput.create(numIpt1, NumInfo,onNumChanged);
    function onNumChanged(txt) {
        UI.updateStage();
        DBG_INFO("crt txt:" +txt.text);
        if (!!txt.text) {
            var currInputVal = parseInt(txt.text,10);
            if(txt.text =="0000"){
                numIpt1.setText("000");
            }
        } else {
            var currInputVal = 0;
        }
        currInputVal = currInputVal +"";
        if(ChManualScanPanel.clearFlag){ // 再次进输入框按下数字键清原始数据，显示输入的数字
            currInputVal = currInputVal.slice(currInputVal.length-1);
            ChManualScanPanel.clearFlag = false;
        }
        if(ChManualScanPanel.currtunerMode == 1){    //cable 1-135
            if (currInputVal < 135) {
                numIpt1.setText(currInputVal);
            }
            else if (currInputVal > 135) {
                var currValue = currInputVal.slice(1,currInputVal.length);
                if(parseInt(currValue) > 135){
                    currValue = currValue.slice(1,currInputVal.length-1);
                }
                numIpt1.setText(currValue);
            }
        }else{
            if (currInputVal < 69) {  //antanne 2-69
                numIpt1.setText(currInputVal);
            }
            else if (currInputVal > 69) {
                var currValue = currInputVal.slice(1,currInputVal.length);
                if(parseInt(currValue) > 69){
                    currValue = currValue.slice(1,currInputVal.length-1);
                }
                numIpt1.setText(currValue);
            }
        }

    }
    numIpt1.onkey_DOWN = function(){
        if(numIpt1.children[1].text ==""
            ||(parseInt(numIpt1.children[1].text) < 2 && ChManualScanPanel.currtunerMode == 0)
            ||(parseInt(numIpt1.children[1].text) < 1 && ChManualScanPanel.currtunerMode == 1))
        {
            GLOBAL.CURRENT_TOAST_TYPE = 1;
            UI.pushGhostModule("setting","SettingSysToast");
            return false;
        }else{
            ChManualScanPanel.clearFlag = true;
            //NumInfoText.alpha = 0;
            DTVBtn.alpha = 1;
            ATVBtn.alpha = 1;
            UI.updateStage();
            return true;
        }
    };
    numIpt1.onkey_ENTER = function(){
        UI.pushSubModule("setting", "ChManualInput", true);
        return true;
    };
    ChManualScanPanel.onFocus = function (focus) {
        if (focus.name == "numIpt1") {
            UI.base.cursor.alpha = 0;
            UI.getTween(UI.base.cursor).set({alpha : 0});
            UI.setImage(numIpt1, "setting/"+GLOBAL.LAUNCHER_BRAND+"/NumInputFocus.png");
            //focus.uncache();
            return false;
        }
        else {
            return true;
        }
    };
    ChManualScanPanel.onNormal = function (focus) {
        if (focus.name == "numIpt1") {
            UI.base.cursor.alpha = 0;
            UI.setImage(numIpt1, "setting/NumInputNormal.png");
            return false;
        }
        else {
            return true;
        }
    };
    ManualScanBtn.onkey_UP = function(){
        if(ChManualScanPanel.chScanState == 1){
            return false;
        }else{
            if(ChManualScanPanel.origTunerMode == 15){
                ChManualScanPanel.currtunerMode = 0;
            }else{
                ChManualScanPanel.currtunerMode = 1;
            }
            ChManualScanPanel.analogChannelNum = 0;
            ChManualScanPanel.digtaChannelNum = 0;
            //NumInfoText.alpha = 0.5;
            DTVBtn.alpha = 0;
            ATVBtn.alpha = 0;
            UI.setText(DTVNum,"0");
            UI.setText(ATVNum,"0");
            UI.setText(ScanBtntext,"[SE0271]");
            ChManualScanPanel.chScanText = 0;
            UI.updateStage();
            return true;
        }
    };
    ManualScanBtn.onkey_ENTER = function(){
        if(ChManualScanPanel.chScanState == 0){
            if(ChManualScanPanel.chScanText == 1){
              UI.popSubModule();
            }else{
                if ((appControl.getCurrentAPPName() == APPNAME.EPOS) && checkIsAppOn()) {
                    DBG_ERROR("ManualScanBtn.onkey_ENTER:epos is on,stop it");
                    appControl.stopCurrentApp();
                    appStoppedFunc = function () {
                    };
                }
                ChManualScanPanel.needRefreshChannelListFlag = 1;
                ChManualScanPanel.ScanFlag = 1;
                ChManualScanPanel.chScanState = 1;
                ManualScanBtn.alpha = 0.3;
                UI.updateStage();
                ChManualScanPanel.CurrNum = parseInt(numIpt1.children[1].text);
                DBG_INFO("ChManualScanPanel.CurrNum::"+ChManualScanPanel.CurrNum);
                ChManualScanPanel.currTunerModeNum = 1;
                var currSource = tv ? getCurrentSourceId():0;
                if(currSource != 0){
                    DBG_INFO("settingChSetStartChScan:currSource="+currSource,DebugLevel.ERROR);
                    changeSourceTo(0);
                }
                if(tv){
                    model.channelSearch.setSearchFrequency(ChManualScanPanel.CurrNum);
                    model.channelSearch.Start(1);
                }else{
                    setTimeout(ChSetManuTestSearch,5000);
                }
                return false;
            }
        }else{
            DBG_ERROR("channel is searching return !!");
            return false;
        }

    };
    function ChSetManuTestSearch(){
        ChManualScanPanel.chScanState = 0;
        ChManualScanPanel.chScanText = 1;
        ManualScanBtn.alpha = 1;
        UI.setText(ScanBtntext,"[SE0589]");
        UI.setVoiceStr(ScanBtntext,"[SE0589]");
        UI.setText(DTVNum,"4");
        UI.setText(ATVNum,"5");
    }
    ChManualScanPanel.onPop = function() {
        DBG_INFO("ChManualScanPanel.onPop!!!!!!!!!!!!!!!");
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
        if(tv && model.channelSearch.getRunning() == 1){
            DBG_INFO("ChManualScanPanel.onPop :channel is searching!!");
            model.channelSearch.Stop();
        }
        if(ChManualScanPanel.needRefreshChannelListFlag){
            liveTV.initChannelList();
            liveTV.setChannelListOprtData(0, 0);    //Reset focus on channel list
        }
        if(tv){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_DIGIT_SERVICES_CHANGED, settingChScanDigitServicesChangeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_FOUND_ANALOG_SERVICES_CHANGED, settingChScanAnalogServicesChangeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CHANNEL_SEARCH_STATE_CHANGED, settingChScanStateChangeCallBack);
        }
    };
    ChManualScanPanel.onkey_BACKSPACE = function(){
        if(ChManualScanPanel.chScanState == 0){
            UI.popSubModule();
        }
    }
    ChManualScanPanel.onkey_EXIT = function(){
        if(ChManualScanPanel.chScanState == 0){
            UI.popSubModule();
        }
    };

}