// Init
UI.moduleBuilder['setting']['AudioHeadphone'] = function(){

    var AudioHeadphoneData = {
        audioSheetImg: UI["setting_bg"],
        audioImg1: "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_audio_154x154.png",
        sndModeImg1: UI.btn_normal_bg,
        audiotitle1:"[SE0058]",//Sound
        headphoneModeTitle:"[SE2691]",//HeadPhone mode
        audioOutTitle:"[SE0064]"//Headphone volume

    };
    var template = Util.readJson("module/setting/AudioHeadphone.json");
    var AudioHeadphone = SubModule.create(AudioHeadphoneData, template);

    var audioRightGrp = UI.getItem(AudioHeadphone, "audioRightGrp");

    var headphoneModeMenu = UI.getItem(AudioHeadphone, "headphoneModeMenu");
    var headphoneVoMenu = UI.getItem(audioRightGrp, "headphoneVoMenu");
    var AudioOut = UI.getItem(headphoneVoMenu, "CurrAudioOut");

    AudioHeadphone.currFocus = headphoneModeMenu;
    AudioHeadphone.pageData = {
        "audioOut": ["[OT0436]","[OT0435]"], //[OT0436]Fixed","[OT0435]Variable
        "HeadphoneModeList": ["[OT0434]","[SE2693]"], //"Headphone with Speakers","Headphone Only"
        "HeadphoneState": {
            insert: 1,
            UnInsert: 0
        },
        ARCDeviceWorkingState: {
            Working: 1,
            RestIng: 0
        },
        headphoneInsertFlag:0
    };

   /* UI.addMask(audioRightGrp, 1148, 926, 80, 6);
    UI.setView(audioRightGrp, 1148, 926);*/
    //UI.addScrollbar(audioRightGrp);

    AudioHeadphone.onPush = function(){
        try{
            AudioHeadphone.currFocus = headphoneModeMenu;

            getAudioOutData();

            initHeadphoneMode();
            getHeadphone();

            UI.updateStage();

            if(tv){
                try{

                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_OUT, AudioOutChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_MODE, HeadphoneModeChaged);
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneDisable);

                }
                catch (ex){
                    DBG_ERROR(ex.message)
                }
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }

    };
    AudioHeadphone.onShow = function () {
        try {
            UI.getItem(setting, 'AudioMainPanel').alpha = 0;
            AudioHeadphone.alpha = 1;
        }catch (ex) {
            DBG_ERROR(ex.message);
        }

    };

    function initHeadphoneMode() {
        try {
            var headPhoneMode = tv ? model.sound.getHeadphoneMode() : 0;
            DBG_INFO("model.sound.getHeadphoneMode:" + headPhoneMode);
            HeadphoneModeChaged (headPhoneMode);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }
    function getHeadphone() {
        try {
            var headphoneInsert = tv ? model.sound.getHeadphoneInsert() : 1;
            HeadphoneDisable(headphoneInsert);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function HeadphoneDisable(val) {  //todo xiugai
        try {
            AudioHeadphone.pageData.headphoneInsertFlag=val;
            var headphoneModeMenu = UI.getItem(AudioHeadphone, "headphoneModeMenu");
            var headphoneVoMenu = UI.getItem(AudioHeadphone, "headphoneVoMenu");
            DBG_INFO("headphone insert changed:" + val);
            if (val == AudioHeadphone.pageData.HeadphoneState.insert) {
                headphoneModeMenu.disable = false;
                headphoneVoMenu.disable = false;
                headphoneModeMenu.alpha = 1;
                headphoneVoMenu.alpha = 1;
            }
            else if (val == AudioHeadphone.pageData.HeadphoneState.UnInsert) {
                UI.popSubModule();
                UI.pushSubModule("setting", "AudioMainPanel", true);
            }
            UI.updateStage();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function HeadphoneModeChaged (val) {
        DBG_INFO("HeadphoneModeChaged :" + val);
        var CurrHeadphoneMode = UI.getItem(AudioHeadphone, "CurrHeadphoneMode");
        CurrHeadphoneMode.selectCurrent(val);
    }


    function getAudioOutData() {
        try {
            var AudioOutValue = tv ? model.sound.getAudioOut() : 1;
            DBG_INFO("model.sound.getAudioOut():" + AudioOutValue);
            AudioOutChaged(AudioOutValue);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }


    function AudioOutChaged(val){
        try{
            DBG_INFO("AudioOutChaged:"+val);
            AudioOut.selectCurrent(val);
        }
        catch (ex){
            DBG_ERROR(ex.message)
        }
    }


    var audioLeftGrp = UI.getItem(AudioHeadphone, "audioLeftGrp");
    var audioHelpInfo = UI.getItem(AudioHeadphone, "audioHelpInfo");
    var audioInfoGrp = UI.getItem(AudioHeadphone, "audioLeftGrp");
    var audiotitle1 = UI.getItem(audioInfoGrp, "audiotitle1");


    selectBar_common(AudioHeadphone, "headphoneVoMenu", "audioOutTitle", "CurrAudioOut", AudioHeadphone.pageData.audioOut, "AudioOutList");
    selectBar_common(AudioHeadphone, "headphoneModeMenu", "headphoneModeTitle", "CurrHeadphoneMode", AudioHeadphone.pageData.HeadphoneModeList, "AudioHeadphoneModeList");


    AudioHeadphone.sndHelpInfo = {
        headphoneModeMenu: {
            title: "TV Speaker",
            info: "[SE2753]"//"Disable TV speaker when you are using sound bar, ARC or any other external audio amplifier."
        },
        headphoneVoMenu: {
            title: "Audio Out",
            info: "[SE0576]"//"Change the way audio is sent through the type of device that's connected to your TV Audio Out port."
        }
    };
    function sndMainPageHelpInfo(id) {
        //UI.setText(audiotitle1,AudioHeadphone.sndHelpInfo[id].title);
        UI.setText(audioHelpInfo, AudioHeadphone.sndHelpInfo[id].info);
    }


    function selectBar_common(submodule, group_name, select_title, select_txt, item_value_arrary, subname) {
        try {
            var selectBar = UI.getItem(submodule, group_name);
            var selectComp = UI.getItem(selectBar, select_txt);
            Select.create(selectComp, item_value_arrary);

            selectBar.onFocus = function () {
                sndMainPageHelpInfo(group_name);
                return true;
            };
            selectBar.onkey_RIGHT = function () {
                selectComp.selectNext();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                DBG_INFO("set " + group_name + ":" + index);
                selectBarMoveHandler(group_name, index);

            };
            selectBar.onkey_LEFT = function () {
                selectComp.selectPrev();
                UI.updateStage();
                var index = item_value_arrary.indexOf(selectComp.selected);
                DBG_INFO("set " + group_name + ":" + index);
                selectBarMoveHandler(group_name, index);
            };
            selectBar.onkey_ENTER = function () {
                UI.pushSubModule("setting", subname, true);
            }

        }
        catch (e) {
            DBG_ERROR("Selectbar_common func is error");
        }
    }

    function selectBarMoveHandler(group_name, index) {
        switch (group_name) {
            case "headphoneVoMenu":
                DBG_INFO("model.sound.setAudioOut:" + index);
                tv ? model.sound.setAudioOut(index) : true;
                break;
            case "headphoneModeMenu":
                DBG_INFO("model.sound.setHeadphoneMode:" + index);
                tv ? model.sound.setHeadphoneMode(index):true;
                break;
            default:
                break;

        }
    }


    AudioHeadphone.onPop = function () {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_OUT, AudioOutChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_MODE, HeadphoneModeChaged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, HeadphoneDisable);
    }

};
