UI.templateManager["module/notificationToast/notificationToast.json"] = {
    notificationToast: {
        type: 0,
        position: {
            x: 495,
            y: 840
        },
        items: {
            mainToast:{
                type : 0,
                position : {x :0, y :0},
                navigation : {leftTo : "", rightTo : "", upTo : "", downTo : ""},
                items : {
                    mainToastBgImg : {
                        type : 7,
                        bound : {w :930, h :264},
                        position : {x :0, y :0}
                    },
                    mainToastImg : {
                        type : 7,
                        bound : {w :144, h :144},
                        position : {x :60, y :60}
                    },
                    mainToastText : {
                        type : 6,
                        bound : {w:650, h:264},
                        innerPos : {x :0, y :0},
                        value :"HDMI1 Lost Signal",
                        font :"36px SourceSansPro-Light",
                        color :"0x363E4D",
                        align :"left",
                        column :"middle",
                        warp:true,
                        position : {x :226, y :0}
                    }
                }
            }
        }
    }
};


UI.moduleBuilder['notificationToast']['notificationToast'] = function(){
    /*default data*/
    var template = Util.readJson("module/notificationToast/notificationToast.json");
    var mainPanelData = {
        mainToastBgImg : "toast/Toast_bg2.png",
        mainToastImg:"launcher/inputs/la_ic_av_active.png"
    };
    var reportToastMsgId='';
    var notificationToast = SubModule.create(mainPanelData, template);
    var mainToast = UI.getItem(notificationToast, "mainToast");
    var mainToastImg = UI.getItem(mainToast, "mainToastImg");
    var mainToastBgImg = UI.getItem(mainToast, "mainToastBgImg");
    var mainToastText = UI.getItem(mainToast, "mainToastText");
    mainToast.alpha = 0;
    var sourceMap = {
        0: "tv",
        1: "av",
        2: "component",
        3: "vga",
        4: "hdmi1",
        5: "hdmi2",
        6: "hdmi3",
        7: "hdmi4",
        8: "SCART"
    };
    var timeOut = 0;
    mainToastBgImg.doFlip = true;

    var sourceItem = ["TV","0","TVAAAA","","AVS","0","AV","","COMPONENT","0","COMPONENT","","HDMI1","0","HDMI1","","HDMI2","0","HDMI2","","HDMI3","0","HDMI3","","HDMI4","0","HDMI4",""];
    if(tv) sourceItem = model.source.getInputName();

    function toastOnInputNameChanged(){
        sourceItem = model.source.getInputName();
        DBG_ERROR("notificationToast toastOnInputNameChanged:" + objToString(sourceItem));
    }

    function parseInputRename(){
        var sourceArr = [];
        for (var i = 0; i < sourceItem.length / 4; i++) {
            sourceArr.push({
                id: sourceItem[i*4],
                signal: sourceItem[i*4+ 1],
                rename: sourceItem[i*4+ 2]
            });
        }
        return sourceArr;
    }

    function toastOnSourceDetectChanged(val){
        DBG_INFO("notificationToast!!!!!!!!!!!!"+val +"GLOBAL.DISABLE_MESSAGE:"+GLOBAL.DISABLE_MESSAGE);
        if (checkIsAppOn(APPNAME.NETFLIX) || (model.system.getNotificationSwitch()==0)
            || GLOBAL.FACTORY == 1 || GLOBAL.DISABLE_MESSAGE){
            mainToast.alpha = 0;
            UI.updateStage();
            return;
        }

        var array = val.split("-");
        if (array.length > 1) {
            if (array[1] == 1) {
                return;
            }
            var allInputsData = parseInputRename();
            var name = "";
            for (var x = 0; x < allInputsData.length; x++) {
                if (array[0].toLowerCase() == allInputsData[x].id.toLowerCase()) {
                    name = allInputsData[x].name;
                    if(!!allInputsData[x].rename){
                        name = allInputsData[x].rename;
                    }
                    break;
                }
            }
            reportToastMsgId=name;
            array[0] = sourceIdMap(array[0]);
            var icon = "launcher/inputs/la_ic_tv_connected.png";
            if (array[1] == 2) {
                g_notificationCrtTimeStamp = getSystemLongTimeForNotification();
                icon = "launcher/inputs/la_ic_" + sourceMap[array[0]] + "_connected.png";
                name = name + " [SE3212]";
            }else{
                g_notificationTimeStamp = getSystemLongTimeForNotification();
                icon = "launcher/inputs/la_ic_" + sourceMap[array[0]] + "_disconnected.png";
                name = name + " [SE3213]";
            }
        }
        mainToast.alpha = 1;
        UI.setImageForGhost(mainToastImg,icon);
        UI.setText(mainToastText,name);
        UI.setVoiceStr(mainToastText,name);
        UI.updateStage();
//        try{
//            var param={
//                MsgType:1,
//                MsgId:reportToastMsgId,
//                DismissCause:1
//            }
//            DBG_INFO("GTLauncherNOTToastReport is open");
//            LGReport.GTLauncherNOTToastReport(param.MsgType,param.MsgId,param.DismissCause);
//        }catch(ex){DBG_ERROR(ex.message);}
        clearTimeout(timeOut);
        timeOut = setTimeout(hideNotificationToast,3000);
    }
    function hideNotificationToast(){
        try{
            var param={
                MsgType:1,
                MsgId:reportToastMsgId,
                DismissCause:2
            }
            DBG_INFO("GTLauncherNOTToastReport is closed");
            LGReport.GTLauncherNOTToastReport(param.MsgType,param.MsgId,param.DismissCause);
        }catch(ex){DBG_ERROR(ex.message);}
        mainToast.alpha = 0;
        UI.updateStage();
    }
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SOURCE_DETECT_CHANGED, toastOnSourceDetectChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.INPUT_NAME_CHANGED, toastOnInputNameChanged);

    function hideNotificationToastForVoice(){
        mainToast.alpha = 0;
        UI.updateStage();
    }

    /*
    Voice Out Toast
     */
    VoiceOutchage();
//0--speaker 1---HP 2--ARC 3--BT,4--HP&ARC,5--HP&BT
    function ExternalDeviceChaged(val){
        try{
            mainToast.alpha = 1;
            DBG_INFO("onExternalDeviceChaged:"+val);
            var DeviceStr = ["Speaker voice out","HP voice out","ARC voice out","BT voice out","HP&ARC voice out","HP&BT voice out"];
            var icon = "toast/ic_success.png"
            UI.setImage(mainToastImg,icon);
            UI.setText(mainToastText,DeviceStr[val]);
            clearTimeout(timeOut);
            timeOut = setTimeout(hideNotificationToastForVoice,3000);


            var speaker = tv ? model.sound.getTvSpeaker() :1;
            DBG_INFO("model.sound.getTvSpeaker:"+speaker);
            if(val == 3){
                GLOBAL.BLUETOOTH_VOICEOUT = true;
            }
            else if(val == 5){
                if(speaker == 0){
                    GLOBAL.BLUETOOTH_VOICEOUT = true;
                }
                else {
                    GLOBAL.BLUETOOTH_VOICEOUT = false;
                }
            }
            else {
                GLOBAL.BLUETOOTH_VOICEOUT = false;
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    }
    function VoiceOutchage(){
        //Volume
        try{
            GLOBAL.BLUETOOTH_SUPPORT = tv ? model.system.getBluetoothSupport() : 1;
            DBG_INFO("model.system.getBluetoothSupport()" +  GLOBAL.BLUETOOTH_SUPPORT);
            if(GLOBAL.BLUETOOTH_SUPPORT){
                model.sound.onExternalDeviceChaged = ExternalDeviceChaged;
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    }
};