/**
 * Created by jiangbo1 on 2016/2/24.
 */

UI.moduleBuilder['launcher']['launcherPassword'] = function(){

    var pwdData = {
        ImgBg: "setting/dialog_bg.png",
        pwd_dlg_bg: UI.window_bg,
        pwd_pad_bg: UI.window_bg,
        pwdImg1: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg2: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg3: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg4: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdBoxImg1: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg2: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg3: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg4: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdText1: " ",
        pwdText2: " ",
        pwdText3: " ",
        pwdText4: " ",
        delete_bg: UI.item_bg,
        zero_bg: UI.item_bg,
        delete_icon: "setting/key_delete.png",
        zeroText: "0",
        pwdTip: "[SE1543]",
        toastBgImg : "toast/Toast_bg2.png",
        toastImg:"launcher/ic_warn.png"
    };

    var template = Util.readJson("module/launcher/launcherPassword.json");
    var pwdDialog = SubModule.create(pwdData, template);

    var pwdDlgPanel = UI.getItem(pwdDialog, "pwdDlgPanel");
    var pwdPadPanel = UI.getItem(pwdDialog, "pwdPadPanel");

    var deleteBtn = UI.getItem(pwdPadPanel, "deleteBtn");
    var zeroBtn = UI.getItem(pwdPadPanel, "zeroBtn");
    var msgPanel = UI.getItem(pwdDialog, "msgPanel");
    var msgTxt = UI.getItem(pwdDialog, "msgTxt");
    msgPanel.alpha = 0;
    var pwdNumArr = [], pwdImgArr = [], pwdBoxImgArr = [], pwdTextArr = [], numList, crntIndex = 0, pinCode;
    var CALLMODE;

    var inputedArr = [], space = " ", btnMap = [
        "1", "2", "3",
        "4", "5", "6",
        "7", "8", "9"
    ];
    var numKeyMap = ["ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"];
    function initUIElement() {
        for (var i = 1; i <= 4; i++) {
            pwdNumArr.push(UI.getItem(pwdDlgPanel, "pwdNum" + i));
            pwdImgArr.push(UI.getItem(pwdNumArr[i - 1], "pwdImg" + i));
            pwdBoxImgArr.push(UI.getItem(pwdNumArr[i - 1], "pwdBoxImg" + i));
            pwdTextArr.push(UI.getItem(pwdNumArr[i - 1], "pwdText" + i));
        }
        numList = UI.getItem(pwdPadPanel, "numList");
        var gridInfo = {
            template: "NumPadTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceY: 20,
            distanceX: 40,
            container: numList
        };

        var allArray = [];
        for (var i = 0; i < btnMap.length; i++) {
            allArray.push(
                {
                    tileBg: UI.item_bg,
                    Num: btnMap[i],
                    name: "BTN" + i
                }
            )
        }
        Gird.create(allArray, gridInfo);
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
    }

    function moveBorderTo(frm, to) {
        if (to < 0 || to > 3) return;

        if (frm >= 0) {
            pwdBoxImgArr[frm].alpha = 0;
            pwdImgArr[frm].alpha = 1;
        }
        pwdBoxImgArr[to].alpha = 1;
        pwdImgArr[to].alpha = 0;

        crntIndex = to;
    }

    pwdDlgPanel.onkey_LEFT = function () {
        if (0 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex - 1);
        return true;
    };
    pwdDlgPanel.onkey_RIGHT = function () {
        if (3 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex + 1);
        return true;
    };

    pwdPadPanel.onkey_RIGHT = function() {
        var index = numList.initSequence.indexOf(UI.getCurrFocus());
        if (index == 2 || index == 5) {
            UI.focusTo(deleteBtn);
        }
        else if (index == 8) {
            UI.focusTo(zeroBtn);
        }
        else {
            return true;
        }
    };
    deleteBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN2"))
    };
    zeroBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN8"))
    };

    deleteBtn.onkey_ENTER = function() {
        inputedArr[crntIndex] = "";
        moveBorderTo(crntIndex, crntIndex - 1);
        UI.setText(pwdTextArr[crntIndex], space);
        UI.updateStage();
    };

    zeroBtn.onkey_ENTER = function() {
        if (crntIndex < 4) {
            inputedArr[crntIndex] = "0";
            UI.setText(pwdTextArr[crntIndex], "*",true);
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        checkPwdAndUnlock(inputedArr);
        UI.updateStage();
    };

    function checkPwdAndUnlock(arr) {
        var pwd = arr.join("");
        if (pwd.length == 4) {
            DBG_INFO("password is: " + pwd);
           var password;

            if (pwd == pinCode || pwd == GLOBAL.MASTER_KEY) {
                if(pwdDialog.param.caller.toString()=="appInstaller"){
                    launcher.AppInstallNeedUpdate = true;
                    launcher.deleteMainresult = true;
                        UI.setText(UI.getItem(launcher.lastfocus, "nameTxt"), "[OT0131]");
                    launcher.lastfocus.data.voiceStr = "[OT0131]" +launcher.lastfocus.data.name;
                        setLauncherInstallerAppByUser(launcher.lastfocus.data.url ,false);
                        launcher.lastfocus.data.flg = false;
                        var appInstaller = launcher['appInstaller'];
                        var msgPanel2 = UI.getItem(appInstaller, "msgPanel");
                        var msgTxt2 = UI.getItem(appInstaller, "msgTxt");
                        UI.setText(msgTxt2, "[OT0134]");
                        UI.getTween(msgPanel2).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);
                    var InstallAnchor = UI.getItem(appInstaller, "InstallAnchor");
                    launcher.lastfocus.data.locked = false;
                    var lockImg = UI.getItem(launcher.lastfocus, "lockImg");
                    if (lockImg) {
                        lockImg.alpha = 0;
                    }
                    UI.popSubModule();
                   // UI.focusTo(launcher.lastfocus);
                }
                else {
                   password = setTimeout(function () {
                       clearTimeout(password);
                    if(pwdDialog.param.caller.toString()=="mainTiles"){
                      UI.popAllModule();
                    GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMMAIN";
                     launcher.firstRefresh = true;
                        var appName = null;
                        if(launcher.lastfocus.data.obj.url == "search-hisense"){
                            appName = APPNAME.SEARCH;
                        }else if(launcher.lastfocus.data.obj.url == "4know-hisense"){
                            appName = APPNAME.NEW4KNOW ;
                        }else if(launcher.lastfocus.data.obj.url == "appstore-hisense"){
                            appName = APPNAME.HISENSESTORE;
                        }
                     startThirdPartyApp(appName, launcher.lastfocus.data.obj.url, launcher.lastfocus.data.obj.urlType, CMDMethod.MENU, false, 0xFFFFFF, launcher.lastfocus.data.name, launcher.lastfocus.data.obj.storeType);
                    }
                    else if(pwdDialog.param.caller.toString()=="allApps"){
                        UI.popAllModule();
                        GLOBAL.LAUNCHER_INFO_EVENT = "OPENFROMAPP";
                        var appName = null;
                        if(launcher.lastfocus.data.url == "search-hisense"){
                            appName = APPNAME.SEARCH;
                        }else if(launcher.lastfocus.data.url == "4know-hisense"){
                            appName = APPNAME.NEW4KNOW ;
                        }else if(launcher.lastfocus.data.url == "appstore-hisense"){
                            appName = APPNAME.HISENSESTORE;
                        }
                        startThirdPartyApp(appName, launcher.lastfocus.data.url, launcher.lastfocus.data.urlType, CMDMethod.MENU, false, "0xFFFFFF",launcher.lastfocus.data.name,launcher.lastfocus.data.storeType);

                    }
                    else if(pwdDialog.param.caller.toString()=="allDeleteApps"){
                        UI.popSubModule();
                        UI.pushSubModule("launcher", "deleteConfirm", true);
                    }
                    else if(pwdDialog.param.caller.toString()=="AccuWeather"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.ACCUWEATHER, APPNAME.ACCUWEATHER, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()== APPNAME.APP4KNOW){
                        UI.popAllModule();
                        startThirdPartyApp(null, APPNAME.APP4KNOW, CMDType.NATIVEAPP, CMDMethod.MENU, false,0xFFFFFF,"4k now");
                    }else if(pwdDialog.param.caller.toString()=="VEWD"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.TVSTORE, APPNAME.TVSTORE, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()=="Dailymotion"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.DAILYMOTION, APPNAME.DAILYMOTION, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()==APPNAME.NEW4KNOW){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.NEW4KNOW, "4know-hisense", CMDType.NATIVEAPP, CMDMethod.MENU, false);
                    }else if(pwdDialog.param.caller.toString()=="FandangoNow"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.FANDANGONOW, APPNAME.FANDANGONOW, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()=="TikiLive"){
                        UI.popAllModule();
                        var url = getAppUrlByName("TikiLive");
                        if(url ==null){
                            url ="http://tikilive.com/hisense";
                        }
                        try{
                            startThirdPartyApp(null,url, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false,0xFFFFFF,"TikiLive");
                        }catch (e){
                            DBG_ERROR("http://tikilive.com/hisense:"+ e.message);
                        }
                    }
                    else if(pwdDialog.param.caller.toString()=="TV Browser"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.TVBROWSER, APPNAME.TVBROWSER, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()=="Clarovideo"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.CLAROVIDEO, APPNAME.CLAROVIDEO, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }else if(pwdDialog.param.caller.toString()=="SearchNOW"){
                        UI.popAllModule();
                        startThirdPartyApp(APPNAME.SEARCH, "search-hisense", CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                    }

                    GLOBAL.UNLOCKED = true;
                return true;
            }, 1000);  }
            }
            else {
                DBG_TODO("password error.");
                for (var i = 0; i < 4; i++) {
                    UI.setText(pwdTextArr[i], space);
                }
                moveBorderTo(crntIndex, 0);
                inputedArr = [];
                GLOBAL.CURRENT_TOAST_TYPE=0;
                UI.setText(msgTxt, "[SE0372]");
                UI.getTween(msgPanel).to({alpha:1}, 400).wait(1000).to({alpha:0}, 400);
                UI.callTTS("[SE0372]");
                UI.updateStage();
            }
        }
        return false;
    }

    function passwordDialgHandler(focus, evt){
        if (crntIndex < 4) {
            inputedArr[crntIndex] = (evt.keyCode - CONST.KEY.VK_0) + "";
            UI.setText(pwdTextArr[crntIndex], "*");
            if(3 == crntIndex) UI.updateStage();
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        if(!checkPwdAndUnlock(inputedArr)){
//            UI.focusTo(pwdNumArr[crntIndex]);
        }
        UI.updateStage();
        return false;
    }

    pwdPadPanel.onkey_BACKSPACE = function () {
        if(!!pwdDialog.caller && (pwdDialog.param.caller.toString()=="AccuWeather"
            || pwdDialog.param.caller.toString()=="4K Now"
            || pwdDialog.param.caller.toString()== APPNAME.NEW4KNOW
            || pwdDialog.param.caller.toString()== APPNAME.APP4KNOW
            || pwdDialog.param.caller.toString()=="VEWD"
            || pwdDialog.param.caller.toString()=="Dailymotion"
            || pwdDialog.param.caller.toString()=="FandangoNow"
            || pwdDialog.param.caller.toString()=="Clarovideo"
            || pwdDialog.param.caller.toString()=="SearchNOW"
            || pwdDialog.param.caller.toString()=="TikiLive"
            || pwdDialog.param.caller.toString()=="TV Browser")){
            if(checkIsAppOn()){
                UI.popSubModule();
                UI.popModule(true);
            }else{
                UI.popSubModule();
                UI.popModule(true);
                openLiveTVModule([Msg.INFO, 0]);
            }


        }
        else{
            return true;
        }
    };
    pwdPadPanel.onkey_ENTER = function (focus) {
        switch (focus.name) {

            default :
                if (crntIndex < 4) {
                    inputedArr[crntIndex] = btnMap[numList.initSequence.indexOf(focus)];
                    UI.setText(pwdTextArr[crntIndex], "*");
                    moveBorderTo(crntIndex, crntIndex + 1);
                }
                break;
        }
        UI.updateStage();
        checkPwdAndUnlock(inputedArr);
    }

    function recoverInputBox(){
        for (var i = 0; i < 4; i++) {
            UI.setText(pwdTextArr[i], space);
        }
        moveBorderTo(crntIndex, 0);
        inputedArr = [];
    }

    pwdDialog.onPush = function () {
        if (Config.tv) pinCode = model.parentlock.getPin();
        moveBorderTo(-1, 0);
        CALLMODE = true;
        pwdDialog.firstTime = true;
        if(checkIsAppOn()){
            registerKeyCodesForUI();
        }
    }

    pwdDialog.onPop = function () {
        recoverInputBox();
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scaleX = 1;
        UI.base.cursor.scaleY = 1;
        UI.base.cursor.alpha = 0;
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
        if(checkIsAppOn()){
            registerKeyCodesForApp();
        }
    };

    pwdDialog.onFocus = function (focus) {
        if(!!focus && focus.name == "deleteBtn"){
            focus.voiceStr = "[GE0014]";
            //UI.callTTS("[GE0014]");
        }
        if(!!pwdDialog.firstTime){
            numList.initSequence[0].voiceStr = "[SE1543]" + "1";
            pwdDialog.firstTime = false;
        }else{
            numList.initSequence[0].voiceStr = null;
        }
        return true;
    };

    numKeyMap.forEach(function (v) {
//        pwdDlgPanel["onkey_" + v] = passwordDialgHandler;
        pwdPadPanel["onkey_" + v] = passwordDialgHandler;
    });

    initUIElement();
};