/**
 * Created by Administrator on 16-1-29.
 */
// Init
UI.moduleBuilder['hiMedia']['picPlayer'] = function () {

    var initData = {
        //picStatus: "hiMedia/play_status.png",
        picMenuBak: "hiMedia/menu_chip_bg.png",
        picMenuBak2: "hiMedia/menu_chip_bg.png",
        PreBt: "hiMedia/btn/icn_previous_normal.png",
        PlayPauseBt: "hiMedia/btn/icn_pause_normal.png",
        NextBt: "hiMedia/btn/icn_next_normal.png",
        arrowLeft: "hiMedia/arrow_left.png",
        arrowRight: "hiMedia/arrow_right.png",
        picPlayerHeaderBg: "hiMedia/backgroundheader.png",
        picPlayerFooterBg: "hiMedia/backgroundfooter.png"
    };
    var template = Util.readJson("module/hiMedia/picPlayer.json");
    var picPlayer = SubModule.create(initData, template);
    var picPlayerMenu = UI.getItem(picPlayer, "picPlayerMenu");
    var picPlayerMenu2 = UI.getItem(picPlayer, "picPlayerMenu2");
    var picPlayerMenuList = UI.getItem(picPlayerMenu, "picPlayerMenuList");
    var picPlayerMenuList2 = UI.getItem(picPlayerMenu2, "picPlayerMenuList2");
    var pMenuListContainer = UI.getItem(picPlayerMenuList, "pMenuListContainer");
    var pMenuListContainer_2 = UI.getItem(picPlayerMenuList2, "pMenuListContainer_2");

    var picPlayerCtl = UI.getItem(picPlayer, "picPlayerCtl");
    var PreBt = UI.getItem(picPlayer, "PreBt");
    var PlayPauseBt = UI.getItem(picPlayer, "PlayPauseBt");
    var NextBt = UI.getItem(picPlayer, "NextBt");
    var arrowLeft = UI.getItem(picPlayer, "arrowLeft");
    var arrowRight = UI.getItem(picPlayer, "arrowRight");
    var picPlayerFooterBg = UI.getItem(picPlayer,"picPlayerFooterBg");
    var picPlayerHeaderBg = UI.getItem(picPlayer,"picPlayerHeaderBg");
    var bmgSwitch = null;

    PreBt.voiceStr = "[GE0011]";
    PlayPauseBt.voiceStr = "[DMP0027]";
    NextBt.voiceStr = "[GE0010]";

    picPlayerMenu.visible = false;
    picPlayerMenu.alpha = 0;
    picPlayer.currFocus = picPlayerMenu;
    picPlayer.picList = [];
    picPlayer.picIndex = 0;
    picPlayer.playerStatus = 1;
    picPlayer.playTime = null;
    picPlayer.isPMenuOn = false;
    picPlayer.picList = hiMedia.initPicList;
    picPlayer.picIndex = hiMedia.initPicIndex;
    picPlayer.rotateDegree = [1, 2, 3, 0, 1, 2, 3];
    picPlayer.rotateIndex = 3;
    picPlayer.hasPicExifRotate = false;
    picPlayer.picSpeed = [2, 3, 5, 10, 20];
    picPlayer.picSpeedFocus = 2;
    picPlayer.picSpeedIndex = 2;
    picPlayer.needUnlockKey = false;
    picPlayer.currentMenuIndex = 0;
    picPlayer.currentMenuFocus = "";
    picPlayer.retryTime = 5;
    picPlayer.initIndex = 0;
    picPlayer.openMenuByHotkey = false;
    picPlayer.needgetInfo = true;
    picPlayer.pWidth = 0;
    picPlayer.pHeight = 0;
    picPlayer.zpWidth = 0;
    picPlayer.zpHeight = 0;
    picPlayer.canMove = false;
    picPlayer.bgmState = 0;
    picPlayer.bgmOpen = false;
    picPlayer.musicIndex = 0;
    var wMove = 0;
    var hMove = 0;
    if (!localStorage.PrepeatIndex) {
        localStorage.PrepeatIndex = 0;
    }
    if (!localStorage.MrepeatIndex) {
        localStorage.MrepeatIndex = 0;
    }
    if (!Config.tv) {
        picPlayer.picList = [
            {picUrl: "a", picName: "a"}
        ];
        picPlayer.picIndex = 0;
    }
    //初始化MENU菜单内容
    picPlayerMenu.menuData = {
        menuPicInit: [
            {"icon": "hiMedia/menu/ic_rotate.png", "text": "[LA0096]"},//rotate
            {"icon": "hiMedia/menu/ic_zoom.png", "text": "[SE0049]"},//zoom
            {"icon": "hiMedia/menu/ic_repeatMode.png", "text": "[DMP0120]"},//repeat mode
            {"icon": "hiMedia/menu/ic_interval.png", "text": "[DMP0134]"},//interval
            {"icon": "hiMedia/menu/ic_bgmusic.png", "text": "[DMP0094]"},//Background Music
            {"icon": "hiMedia/menu/ic_information.png", "text": "[SE0628]"},//info
            {"icon": "hiMedia/menu/ic_picturelist.png", "text": "[DMP0095]"},//list
            {"icon": "hiMedia/menu/ic_SystemSetting.png", "text": "[DMP0123]"}//setting
        ],
        menuPicList: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "no pic"}
        ],
        menuPicMode: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "None"}
        ],
        menuSetting: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "None"}
        ],
        menuPicRepeatMode: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0057]"},//repeat all
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0165]"} //no repeat
        ],
        menuZoomMode: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0153]"},//normal
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[SE2523]"},//Original Size
            {"icon": "setting/ic_radiobutton_normal.png", "text": "200%"},
            {"icon": "setting/ic_radiobutton_normal.png", "text": "300%"},
            {"icon": "setting/ic_radiobutton_normal.png", "text": "400%"}
        ],
        menuPicRotate: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0136]"},//right 90
            {"icon": "setting/ic_radiobutton_normal.png", "text": "[DMP0135]"} //left 90
        ],
        menuPicInfo: [
            {"icon": "hiMedia/normal.png", "text": "[DMP0051]"},
            {"icon": "hiMedia/normal.png", "text": "[DMP0005]"}
        ],
        menuPicInterval: [
            {"icon": "setting/ic_radiobutton_normal.png", "text": "5S"},
            {"icon": "setting/ic_radiobutton_normal.png", "text": "10S"},
            {"icon": "setting/ic_radiobutton_normal.png", "text": "20S"}
        ]}
    picPlayer.menuArray = [picPlayerMenu.menuData.menuPicInit,
        picPlayerMenu.menuData.menuPicRotate , picPlayerMenu.menuData.menuZoomMode,
        picPlayerMenu.menuData.menuPicRepeatMode,
        picPlayerMenu.menuData.menuPicInterval, picPlayerMenu.menuData.menuPicMode,
        picPlayerMenu.menuData.menuPicInfo, picPlayerMenu.menuData.menuPicList,
        picPlayerMenu.menuData.menuSetting
    ];
    picPlayer.createMenuList = function (menuData, menuList, bgmMenuIndex, bgmInit) {

        DBG_INFO(menuList.name);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {chip_bg: UI.item_bg,
                    chipIcon: menuData[i].icon,
                    chipText: menuData[i].text,
                    name: menuList.name + i


                };
                array.push(data);
            }
            var info = {
                template: "chipTile",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 6,
                container: menuList
            };
            Gird.create(array, info);
            if (!!bgmMenuIndex) {
                bmgSwitch = menuList.initSequence[bgmMenuIndex].children[3];
                Switch.create(bmgSwitch, bgmInit);
                UI.updateStage();
            }
            if (hiMedia.BGMList.length < 1) {
                menuList.initSequence[bgmMenuIndex].children[1].alpha = 0.3;
                menuList.initSequence[bgmMenuIndex].children[2].alpha = 0.3;
                menuList.initSequence[bgmMenuIndex].children[2].w = 190;
                menuList.initSequence[bgmMenuIndex].children[3].alpha = 0.3;
            } else {
                menuList.initSequence[bgmMenuIndex].children[1].alpha = 1;
                menuList.initSequence[bgmMenuIndex].children[2].alpha = 1;
                menuList.initSequence[bgmMenuIndex].children[2].w = 190;
                menuList.initSequence[bgmMenuIndex].children[3].alpha = 1;
            }

        }
    }
    picPlayer.createMenu2List = function (menuData, menuList) {

        DBG_INFO(menuData[0].text);
        var array = [];
        if (menuData.length > 0) {
            for (var i = 0; i < menuData.length; i++) {
                var data = {chip_bg: UI.item_bg,
                    chipIcon: menuData[i].icon,
                    chipText: menuData[i].text,
                    name: menuList.name + i


                };
                array.push(data);
            }
            var info = {
                template: "chipTileMedia2",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 10,
                container: menuList
            };
            Gird.create(array, info);
        }
    };
    //var picStatus = UI.getItem(picPlayer, "picStatus");
    var picNameTitle = UI.getItem(picPlayer, "picName");
    var picPlayerMenuName = UI.getItem(picPlayer, "picPlayerMenuName");
    var picPlayerMenuName2 = UI.getItem(picPlayer, "picPlayerMenuName2");
    var menuNameArray = ["[DMP0056]", "[LA0096]", "[SE0049]", "[DMP0120]", "[DMP0134]", "[DMP0094]", "[SE0628]", "[DMP0095]", "[DMP0123]"];


    var decodeLock = false;
    var picStartTimer = null;
    var getImageSizeTimer1 = null;
    var getImageSizeTimer2 = null;
    var picStartCount = 0;
    picPlayer.onShow = function () {
        DBG_INFO("picPlayer.onShow");
        /*
         if (!picPlayerMenu.visible) {
         UI.base.cursor.alpha = 0;
         } else {
         UI.base.cursor.alpha = 1;
         }
         */

    }
    picPlayer.afterPush = function () {
        DBG_INFO("picPlayer.afterPush");


        try {
            picPlayer.currFocus = picPlayerMenu;
            picPlayer.picList = [];
            picPlayer.picIndex = 0;
            picPlayer.playerStatus = 0;
            UI.setImage(PlayPauseBt, "hiMedia/btn/icn_play_normal.png");
            picPlayer.picIntervalIndex = 0;
            picPlayer.picZoomIndex = 0;
            picPlayer.canMove = false;
            picPlayer.picRotateIndex = 0;
            picPlayer.playTime = null;
            picPlayer.isPMenuOn = false;
            picPlayerMenu.visible = false;
            picPlayerMenu.alpha = 0;
            picPlayerMenu2.alpha = 0;
            picPlayer.rotateIndex = 3;
            picPlayer.hasPicExifRotate = false;
            picPlayer.picSpeedFocus = 2;
            picPlayer.picSpeedIndex = 2;
            picPlayer.currentMenuIndex = 0;
            picPlayer.currentMenuFocus = "";
            picPlayer.picList = hiMedia.initPicList;
            picPlayer.picIndex = hiMedia.initPicIndex;
            picPlayer.isPBarShow = 1;
            picPlayer.initIndex = 0;
            picPlayer.intervalArray = [5, 10, 20];//picPlayer.intervalArray[picPlayer.picIntervalIndex];
            decodeLock = false;
            picStartTimer = null;
            getImageSizeTimer1 = null;
            getImageSizeTimer2 = null;
            picStartCount = 0;
            picPlayer.ControlTimer = null;
            picPlayer.bgmState = 0;
            picPlayer.bgmOpen = false;
            picPlayer.musicIndex = 0;
            arrowLeft.alpha = 0;
            arrowRight.alpha = 0;
            picPlayer.ArrowShowTimer = null;
            picPlayer.needUnlockKey = true;
            picPlayer.openMenuByHotkey = false;
            picPlayer.needgetInfo = true;
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, picPlayer.onPStateChanged);
            picPlayer.playPicByUrl(picPlayer.picList[picPlayer.picIndex].picUrl);
            UI.clearMediaTimeout();
            //if (hiMedia.picPlayMode == 0) {
            //    if (!hiMedia.fileBrowserPicRotateData[hiMedia.curFilePath]) {
            //        hiMedia.fileBrowserPicRotateData[hiMedia.curFilePath] = hiMedia.picRotateContainer;
            //    }
            //}
        }
        catch (ex) {
            DBG_ERROR("[playPicByUrl]" + ex.message);
        }
        if (Config.tv) {
            picPlayerMenu.menuData.menuPicList = [];
            for (var i = 0; i < picPlayer.picList.length; i++) {
                picPlayerMenu.menuData.menuPicList.push({"icon": "setting/ic_radiobutton_normal.png", "text": picPlayer.picList[i].picName });
            }
        }
        else {
            picPlayer.picList = picPlayerMenu.menuData.menuPicList;
        }
        pMenuListContainer.removeAllChildren();
        picPlayer.createMenuList(picPlayerMenu.menuData.menuPicInit, pMenuListContainer, 4, picPlayer.bgmState);
        //picPlayer.currentMenuFocus = pPicList.initSequence[picPlayer.picIndex];
        picPlayer.reFocusMenu();
        UI.addMask(picPlayerMenuList, 440, 504, 20, 10);
        UI.setView(picPlayerMenuList, 440, 504);
        UI.resetViewPos(pMenuListContainer);
        UI.setView(pMenuListContainer, 440, 504);
        UI.addScrollbar(pMenuListContainer);
        hiMedia.hideListData(pMenuListContainer, 0, 6);
        picPlayer.reopenBar();
    }
    var hasSetPlayDone = false;
    picPlayer.onPStateChanged = function (value) {
        DBG_INFO("onPStateChanged value = " + value);
        var nState = parseInt(value[2]);
        if (!picPlayer.bgmOpen && value[1] != picPlayer.picList[picPlayer.picIndex].picUrl) {
            DBG_ERROR("not current url,return!!!");
            return;
        }
        if (parseInt(value[5]) & 16 && !hasSetPlayDone) {
            //关字幕
            DBG_INFO("[PicPlayDone]");
            hasSetPlayDone = true;
        }
        if(!!picPlayer.bgmOpen && parseInt(value[5]) & ( 4 | 2 )){
            picPlayer.playNextWhenStop();
            return
        }
        if (nState == hiMedia.playerstatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_INFO("drop duplicated state event" + nState);
            return;
        }
        DBG_INFO("hiMedia.playerstatus = " + hiMedia.playerstatus + " nState = " + nState);
        hiMedia.playerstatus = nState;

        DBG_INFO("[onPStateChanged] state changed : " + hiMedia.playerstatus);
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        DBG_INFO("currentSubModel: !" + currentSubModel);
        if (currentSubModel == "picPlayer") {
            switch (nState) {
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                    //UI.setImage(videoStatus, "hiMedia/play_status.png");
                    if(!!picPlayer.bgmOpen){
                        hiMedia.endLoading("picPlayer");
                    }
                    if (!!picPlayer.needgetInfo) {
                        picPlayer.getPicInfo();
                        picPlayer.needgetInfo = false;
                    }
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                    break;

                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE:
                    try {
                        model.mpctrl.MpCtrl(1);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                    //UI.focusTo(PlayPauseBt);
                    //UI.moveCursor(UI.getCurrFocus());
                    //UI.base.cursor.alpha = 1;
                    DBG_INFO("SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED!");
                    try {
                        picPlayer.rotateAfterplay();
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    try {
                        model.mpctrl.MpCtrl(1);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    hiMedia.endLoading("picPlayer");
                    if (!!picPlayer.needUnlockKey) {
                        picPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playPic");
                    }
                    try {
                        var playstate = picPlayer.playerStatus ? "slide" : "single";
                        picPlayer.pWidth = tv ? parseInt(model.mpctrl.getMetadata()[26]) : 400;
                        picPlayer.pHeight = tv ? parseInt(model.mpctrl.getMetadata()[27]) : 400;
                        pubStateMediaDmp(picPlayer.picList[picPlayer.picIndex].picName, 0, 0, 0, playstate, "picture", picPlayer.pWidth + "*" + picPlayer.pHeight);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    picPlayer.canMove = false;
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP://no get
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_RELEASING:


                    break;

                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_OPEN_FILE_FAIL:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                    //"File not supported"  leftover
                    hiMedia.endLoading("picPlayer");
                    if (!!picPlayer.needUnlockKey) {
                        picPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playPic");
                    }
                    hiMedia.toastMsg("[DMP0031]");//fileNotSupported
                    picPlayer.closePicPlayer();
                    break;
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_FILE_EXPIRED:
                    //"The file has expired and can not be played."   leftover
                    hiMedia.toastMsg("[DMP0132]");//fileNotSupported
                    break;
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
                    //endLoading  leftover
                    hiMedia.endLoading("picPlayer");
                    if (!!picPlayer.needUnlockKey) {
                        picPlayer.needUnlockKey = false;
                        UI.unlockAllKeys("playPic");
                    }
                    picPlayer.closePicPlayer();
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PVR_CHANNEL_LOCK:
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PVR_RATING_LOCK:
                    //PVR password .leftover
                    break;
                default :

                    break;
            }
        } else {
            DBG_ERROR("current subModel is " + currentSubModel + ",not picPlayer!!");
        }
    }
    picPlayer.playPicByUrl = function (pUrl) {
        if (pUrl != null) {
            DBG_ERROR("pic Url is :" + pUrl);//应底层要求修改播放时的打印为error级别方便调试问题：MSD6586EU-5010
            if (picPlayer.playerStatus == 0) {
                hiMedia.startLoading("picPlayer", picPlayer.retryTime);
            }
            else {
                hiMedia.startLoading("picPlayer", picPlayer.retryTime, true);
            }
            picPlayer.needgetInfo = true;
            picPlayer.picZoomIndex = 0;
            picPlayer.picRotateIndex = 0;
            picPlayer.zpWidth = 0;
            picPlayer.zpHeight = 0;
            wMove = 0;
            hMove = 0;
            decodeLock = true;
            try {
                UI.setText(picNameTitle, picPlayer.picList[picPlayer.picIndex].picName);
                DBG_INFO(" picName is : " + picPlayer.picList[picPlayer.picIndex].picName);
                if (!!picPlayer.bgmOpen) {
                    model.mpctrl.setBGMusicUrl(createStringVector([pUrl, "16"]));
                } else if (picPlayer.bgmState == 0) {
                    model.mpctrl.PlayMedia(pUrl, null, null, null, null, null, 16, null, null, null);
                }
                clearTimeout(picStartTimer);

            }
            catch (ex) {
                DBG_ERROR("[playPicByUrl]" + ex.message);
            }

            //隐藏与显示进度条
            //if (picPlayer.playerStatus == 0) {
            //    if (picPlayer.isPBarShow == 0) {
            //        //picPlayer.reopenBar();
            //    }
            //    /*
            //     clearTimeout(picPlayer.ControlTimer);
            //     picPlayer.ControlTimer = setTimeout(function () {
            //     picPlayer.hideBar();
            //     }, 3000);
            //     */
            //}
        }
    };


    picPlayer.onkey_BACKSPACE = function () {
        if (!picPlayerMenu.visible) {
            if (picPlayer.isPBarShow == 1) {
                picPlayer.hideBar();
            } else if (!picPlayerMenu.visible) {
                picPlayer.closePicPlayer();
            }
        } else {
            picPlayer.closeGhostModule();
            if (picPlayer.currentMenuIndex == 0) {
                picPlayer.closeMenu("key_back");
            } else {
                if (picPlayer.openMenuByHotkey) {
                    picPlayer.closeMenu("key_back");
                }
                picPlayerMenu2.alpha = 0;
                picPlayerMenu.alpha = 1;
                picPlayer.currentMenuIndex = 0;
                pMenuListContainer.removeAllChildren();
                UI.removeScrollbar(pMenuListContainer);
                picPlayer.createMenuList(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer, 4, picPlayer.bgmState);
                UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);
                picPlayer.reFocusMenu();
                UI.resetViewPos(pMenuListContainer);
                UI.setView(pMenuListContainer, 440, 504);
                UI.addScrollbar(pMenuListContainer, 0);
                UI.focusTo(UI.getCurrFocus());

            }
        }

    };
    picPlayer.onkey_ENTER = function () {
        DBG_ALWAYS("picPlayer.onkey_ENTER");
        if (!picPlayerMenu.visible) {
            //picPlayer.picPlayOrPause();
            picPlayer.reopenBar();
        } else {
            picPlayer.menuOKEvent();
            //if (!picPlayer.currentMenuIndex) {
            //    picPlayer.closeMenu("key_enter");
            //}
        }

    };

    picPlayer.onkey_INFO = function (focus, event) {
        if (!Config.tv) {
            event.keyState = 1;
        }
        if (event.keyState == 1) {
            if (!picPlayerMenu.visible) {
                picPlayer.refreshMenuArray();
                //picPlayer.onkey_MENU(focus, event);
                picPlayer.currentMenuIndex = 6;
                picPlayerMenu.visible = true;
                picPlayerMenu.alpha = 0;
                picPlayerMenu2.alpha = 1;
                pMenuListContainer_2.removeAllChildren(true);
                UI.removeScrollbar(pMenuListContainer_2);
                UI.setText(picPlayerMenuName2, menuNameArray[picPlayer.currentMenuIndex]);
                picPlayer.createMenu2List(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer_2);
                picPlayer.reFocusMenu();
                UI.addMask(picPlayerMenuList2, 760, 520, 40, 10);
                UI.resetViewPos(pMenuListContainer_2);
                UI.setView(pMenuListContainer_2, 760, 520);
                UI.addScrollbar(pMenuListContainer_2, 5);

                UI.focusTo(UI.getCurrFocus());
                picPlayer.openMenuByHotkey = true;
            }
            else {
                if (picPlayer.currentMenuIndex == 6) {
                    picPlayer.closeMenu("key_menu");
                } else {
                    picPlayer.currentMenuIndex = 6;
                    pMenuListContainer_2.removeAllChildren(true);
                    UI.removeScrollbar(pMenuListContainer_2);
                    UI.setText(picPlayerMenuName2, menuNameArray[picPlayer.currentMenuIndex]);
                    picPlayer.createMenu2List(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer_2);
                    picPlayer.reFocusMenu();
                    UI.addMask(picPlayerMenuList2, 760, 520, 40, 10);
                    UI.resetViewPos(pMenuListContainer_2);
                    UI.setView(pMenuListContainer_2, 760, 520);
                    UI.addScrollbar(pMenuListContainer_2, 5);
                    picPlayerMenu.visible = true;
                    picPlayerMenu.alpha = 0;
                    picPlayerMenu2.alpha = 0;
                    UI.focusTo(UI.getCurrFocus());
                }

            }
        }
        else {
            DBG_INFO("picPlayer.onkey_MENU" + event.keyState);
        }
    }
    //MENU处理
    picPlayer.menuOKEvent = function () {
        picPlayer.refreshMenuArray();
        switch (picPlayer.currentMenuIndex) {
            case 7:
                //piclist
                var cpIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                if (cpIndex >= 0) {
                    picPlayer.picIndex = cpIndex;
                    picPlayer.playPicByUrl(picPlayer.picList[cpIndex].picUrl);
                } else {
                    DBG_ERROR("menuIndex error!!" + cpIndex + "cfocus is : " + UI.getCurrFocus().name);
                }
                UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                picPlayer.closeMenu("key_enter");
                break;
            case 2:
                var czIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                picPlayer.picZoomIndex = czIndex;
                picPlayer.setScreenSize(czIndex);
                UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                picPlayer.changeMenuFocus();
                //picPlayer.closeMenu("key_enter");
                break;
            case 3:
                var crIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                switch (crIndex) {
                    case 0:
                        localStorage.PrepeatIndex = 0;//repeat all
                        break;
                    case 1:
                        localStorage.PrepeatIndex = 1;//repeat one
                        break;
                    default :
                        DBG_ERROR("repeat index error!!" + crIndex);
                        break;
                }
                UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                picPlayer.changeMenuFocus();
                //picPlayer.closeMenu("key_enter");
                break;
            case 4:
                picPlayer.picIntervalIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                picPlayer.changeMenuFocus();
                //picPlayer.closeMenu("key_enter");
                break;
            case 1:
                //rotate
                var croIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                picPlayer.picRotateIndex = croIndex;
                switch (croIndex) {
                    case 0:
                        picPlayer.imgRight();
                        break;
                    case 1:
                        picPlayer.imgLeft();
                        break;
                    default :
                        DBG_ERROR("rotate index error!!" + croIndex);
                        break;
                }
                UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                picPlayer.changeMenuFocus();
                //picPlayer.closeMenu("key_enter");
                break;
            case 0:
                picPlayer.initIndex = pMenuListContainer.initSequence.indexOf(UI.getCurrFocus());
                picPlayer.closeGhostModule();
                if (picPlayer.initIndex == 4) {
//                    picPlayer.currentMenuIndex = 0;
//                    PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_MODE;
//                    picPlayer.needReopenMenu = true;
//                    UI.pushSubModule("setting", "picMode", true, {caller: "hiMedia"});
//                    picPlayer.closeMenu("pic MODE");
                    if(hiMedia.BGMList.length < 1){
                        hiMedia.toastMsg("[DMP0175]", 5000);
                    }else {
                        if (picPlayer.bgmState == 1) {
                            picPlayer.pauseBGM();
                        } else {
                            picPlayer.playBGM();
                        }
                    }
                    //特殊处理PIC MODE 跳转
                }
                else if (picPlayer.initIndex == 7) {
                    picPlayer.currentMenuIndex = 0;
                    UI.pushSubModule("setting", "mainPanel", true, {caller: "hiMedia"});
                    picPlayer.closeMenu("setting");
                }
                else {
                    picPlayer.currentMenuIndex = picPlayer.initIndex + 1;
                    pMenuListContainer_2.removeAllChildren(true);
                    UI.removeScrollbar(pMenuListContainer_2);
                    UI.setText(picPlayerMenuName2, menuNameArray[picPlayer.currentMenuIndex]);
                    picPlayer.createMenu2List(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer_2);
                    picPlayer.reFocusMenu();
                    UI.addMask(picPlayerMenuList2, 760, 520, 40, 10);
                    UI.resetViewPos(pMenuListContainer_2);
                    UI.setView(pMenuListContainer_2, 760, 520);
                    UI.addScrollbar(pMenuListContainer_2, 5);
                    picPlayerMenu.alpha = 0;
                    picPlayerMenu2.alpha = 1;
                    if (picPlayer.currentMenuIndex != 6) {
                        UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
                    }
                    UI.focusTo(UI.getCurrFocus());
                }
                break;
            default :
                break;
        }
    }
    picPlayer.changeMenuFocus = function (){
        if(picPlayer.currentMenuFocus != UI.getCurrFocus()) {
            UI.setImage(picPlayer.currentMenuFocus.children[1], "setting/ic_radiobutton_normal.png");
            picPlayer.currentMenuFocus = UI.getCurrFocus();
            UI.setImage(UI.getCurrFocus().children[1], "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_radiobutton_focused.png");
        }
    }
    picPlayer.closeMenu = function (desc) {
        DBG_ALWAYS(desc);
        UI.clearMediaMenuTimeout();
        picPlayerMenu2.alpha = 0;
        hiMedia.startLoading("animation", 3, true);
        //UI.getTween(picPlayerMenu, true).to({alpha: 0, visible: false}, 500).call(function () {
        picPlayerMenu.alpha = 0;
        picPlayerMenu.visible = false;
        //createjs.Tween.removeTweens(UI.getCurrFocus().scale);
        try{
            UI.getCurrFocus().scale.x = UI.getCurrFocus().scale.y = 1;
        }catch(ex){
            DBG_ERROR(ex.message);
        }
        picPlayer.openMenuByHotkey = false;
        if (picPlayer.currentMenuIndex != 0) {
            picPlayer.currentMenuIndex = 0;
            pMenuListContainer.removeAllChildren(true);
            UI.removeScrollbar(pMenuListContainer);
            picPlayer.createMenuList(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer, 4, picPlayer.bgmState);
            UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);
            picPlayer.reFocusMenu();
            UI.resetViewPos(pMenuListContainer);
            UI.setView(pMenuListContainer, 440, 504);
            UI.addScrollbar(pMenuListContainer, 0);
            UI.focusTo(UI.getCurrFocus());

        }
        hiMedia.endLoading("animation");
        //});
    }

    picPlayer.onkey_MENU = function (foucs, event) {
        //DBG_ALWAYS("picPlayer.onkey_MENU" + event.keyState);
        if (picPlayer.playerStatus == 1) {
            hiMedia.toastMsg("[DMP0150]", 5000);
            return;
        }
        if (picPlayer.isPBarShow == 1) {
            picPlayer.hideBar();
        }
        if (event.keyState == 1 || !Config.tv) {
            if (!picPlayerMenu.visible) {
                picPlayer.closeGhostModule();
                if (picPlayer.currentMenuIndex == 5) {
                    picPlayer.refreshMenuArray();
                    pMenuListContainer.removeAllChildren(true);
                    UI.removeScrollbar(pMenuListContainer);
                    picPlayer.createMenuList(picPlayer.menuArray[picPlayer.currentMenuIndex], pMenuListContainer, 4, picPlayer.bgmState);
                    picPlayer.reFocusMenu();
                    UI.resetViewPos(pMenuListContainer);
                    UI.setView(pMenuListContainer, 440, 504);
                    UI.addScrollbar(pMenuListContainer, 0);
                }
                UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);
                hiMedia.startLoading("animation", 3, true);
                //UI.getTween(picPlayerMenu, true).to({alpha: 1, visible: true}, 500).call(function () {
                picPlayerMenu.alpha = 1;
                picPlayerMenu.visible = true;
                if (!!picPlayer.currentMenuFocus) {
                    picPlayer.reFocusMenu();
                    UI.focusTo(picPlayer.currentMenuFocus);
                } else {
                    DBG_ERROR("Missing menu focus!!");
                }
                if (GLOBAL.SETTING_TIMEOUT_DELAY != 0) {
                    UI.setMediaMenuTimeout(function () {
                        picPlayer.closeMenu("timeout");
                    }, GLOBAL.SETTING_TIMEOUT_DELAY);
                }
                hiMedia.endLoading("animation");
                //});
            }
            else {
                picPlayer.closeMenu("key_menu");
                picPlayer.closeGhostModule();
            }
        } else {
            DBG_INFO("picPlayer.onkey_MENU" + event.keyState);
        }
    }


    picPlayer.onkey_LEFT = function () {
        DBG_INFO("picPlayer.onkey_LEFT");
        if (!picPlayerMenu.visible) {
            //上一张
            clearTimeout(picPlayer.ArrowShowTimer);
            arrowRight.alpha = 0;
            arrowLeft.alpha = 1;
            picPlayer.ArrowShowTimer = setTimeout(function () {
                arrowLeft.alpha = 0;
            }, 1000);
            if (!!picPlayer.canMove) {
                try {
                    model.mpctrl.ViewMove("2", "20");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                picPlayer.prev();
            }
        }
//        else {
//            if (picPlayer.currentMenuIndex > 0) {
//                picPlayer.currentMenuIndex--;
//                //hiMedia.showMenuChipByIndex(circleName, picPlayerMenuList, picPlayer.currentMenuIndex, picPlayer.currentMenuIndex + 1, 743);
//
//                UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);
//                picPlayer.reFocusMenu();
//                UI.focusTo(UI.getCurrFocus());
//            }

        //   }

    }
    picPlayer.onkey_RIGHT = function () {
        DBG_INFO("picPlayer.onkey_RIGHT");
        if (!picPlayerMenu.visible) {
            clearTimeout(picPlayer.ArrowShowTimer);
            arrowLeft.alpha = 0;
            arrowRight.alpha = 1;
            picPlayer.ArrowShowTimer = setTimeout(function () {
                arrowRight.alpha = 0;
            }, 1000);
            if (!!picPlayer.canMove) {
                try {
                    model.mpctrl.ViewMove("3", "20");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                picPlayer.next();
            }
        }
//        else {
//            if (picPlayer.currentMenuIndex < circleName.length - 1) {
//                picPlayer.currentMenuIndex++;
//                hiMedia.showMenuChipByIndex(circleName, picPlayerMenuList, picPlayer.currentMenuIndex, picPlayer.currentMenuIndex - 1, 743);
//
//                UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);
//                picPlayer.reFocusMenu();
//                UI.focusTo(UI.getCurrFocus());
//            }
//
//        }
    }
    NextBt.onkey_LEFT = function () {
        DBG_INFO("NextBt.onkey_LEFT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            UI.focusTo(PlayPauseBt);
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.alpha = 1;
            UI.updateStage();
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
        } else {
            return true;
        }
    }
    NextBt.onkey_RIGHT = function () {
        DBG_INFO("NextBt.onkey_RIGHT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
            return false;
        } else {
            return true;
        }
    }
    NextBt.onkey_ENTER = function () {
        DBG_INFO("NextBt.onkey_ENTER, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
            if (!picPlayerMenu.visible) {
                clearTimeout(picPlayer.ArrowShowTimer);
                arrowLeft.alpha = 0;
                arrowRight.alpha = 1;
                picPlayer.ArrowShowTimer = setTimeout(function () {
                    arrowRight.alpha = 0;
                }, 1000);
                picPlayer.next();
            }
            return false;
        } else {
            return true;
        }
    }
    PreBt.onkey_LEFT = function () {
        DBG_INFO("PreBt.onkey_LEFT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
            return false;
        } else {
            return true;
        }
    }
    PreBt.onkey_RIGHT = function () {
        DBG_INFO("PreBt.onkey_RIGHT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            UI.focusTo(PlayPauseBt);
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.alpha = 1;
            UI.updateStage();
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
        } else {
            return true;
        }
    }
    PreBt.onkey_ENTER = function () {
        DBG_INFO("PreBt.onkey_ENTER, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
            if (!picPlayerMenu.visible) {
                clearTimeout(picPlayer.ArrowShowTimer);
                arrowRight.alpha = 0;
                arrowLeft.alpha = 1;
                picPlayer.ArrowShowTimer = setTimeout(function () {
                    arrowLeft.alpha = 0;
                }, 1000);
                picPlayer.prev();
            }
            return false;
        } else {
            return true;
        }
    }

    PlayPauseBt.onkey_LEFT = function () {
        DBG_INFO("PlayPauseBt.onkey_LEFT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            UI.focusTo(PreBt);
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.alpha = 1;
            UI.updateStage();
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
        } else {
            return true;
        }
    }
    PlayPauseBt.onkey_RIGHT = function () {
        DBG_INFO("PlayPauseBt.onkey_RIGHT, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            UI.focusTo(NextBt);
            UI.moveCursor(UI.adjustView());
            UI.base.cursor.alpha = 1;
            UI.updateStage();
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
        } else {
            return true;
        }
    }
    PlayPauseBt.onkey_ENTER = function () {
        DBG_INFO("PreBt.onkey_ENTER, picPlayerCtl.y: " + picPlayerCtl.y);
        if (picPlayerCtl.y < 1080) {
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.ControlTimer = setTimeout(function () {
                picPlayer.hideBar();
            }, 5000);
            picPlayer.picPlayOrPause();
            return false;
        } else {
            return true;
        }
    }
    picPlayer.onkey_PLAY = function () {
        if(!!picPlayerMenu.visible){
            picPlayer.closeMenu("key_Play");
        }
        picPlayer.closeGhostModule();
        picPlayer.reopenBar();
        UI.callTTS("[PI0010]");
        if (picPlayer.playerStatus == 0) {
            picPlayer.showStatus("stop");
            picPlayer.playTime = setInterval(function () {
                if (localStorage.PrepeatIndex == 1) {
                    if (picPlayer.picIndex < picPlayer.picList.length - 1)
                        picPlayer.next();
                    else {
                        clearInterval(picPlayer.playTime);
                        //设置PAUSE图标
                        picPlayer.playerStatus = 0;
                    }
                }
                else if (localStorage.PrepeatIndex == 0) {
                    if (picPlayer.picIndex < picPlayer.picList.length - 1)
                        picPlayer.next();
                    else {
                        picPlayer.picIndex = 0;
                        picPlayer.playPicByUrl(picPlayer.picList[0].picUrl);
                    }
                }
                //默认为6S，不需要调整了
            }, picPlayer.intervalArray[picPlayer.picIntervalIndex] * 1000);

            picPlayer.playerStatus = 1;
        }
    }
    picPlayer.onkey_PAUSE = function () {
        if(!!picPlayerMenu.visible){
            picPlayer.closeMenu("key_Pause");
        }
        picPlayer.closeGhostModule();
        picPlayer.reopenBar();
        UI.callTTS("[DMP0027]");
        if (picPlayer.playerStatus == 1) {
            picPlayer.showStatus("play");
            clearInterval(picPlayer.playTime);
            picPlayer.playerStatus = 0;
        }
    }

    picPlayer.onkey_PLAYPAUSE = function () {
        if(!!picPlayerMenu.visible){
            picPlayer.closeMenu("key_Pause");
        }
        picPlayer.closeGhostModule();
        picPlayer.reopenBar();
        if (picPlayer.playerStatus == 1) {
            UI.callTTS("[DMP0027]");
        }else{
            UI.callTTS("[PI0010]");
        }
        picPlayer.picPlayOrPause();
    }

    picPlayer.onkey_STOP = function () {
        UI.callTTS("[SE0100]");
        picPlayer.closePicPlayer();
    }
    picPlayer.resetInfoMenu = function (index, content) {
        DBG_INFO("menuData length" + picPlayerMenu.menuData.menuPicInfo.length);
        picPlayerMenu.menuData.menuPicInfo[index].text = content;
    }
    picPlayer.setInfoMenu = function (infoName, infoRel, infoSize, infoDate) {
        picPlayerMenu.menuData.menuPicInfo = [];
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0051]" + ":" + infoName });
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0005]" + infoRel });
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0004]" + infoSize });
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3906]" + ":" + infoDate });

    }
    picPlayer.setExifInfoMenu = function (infoCam, infoRot, infoDateM, infoExp, infoFNum, infoFocal, infoColorSp, infoGPS) {
        //picPlayerMenu.menuData.menuPicInfo = [];
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0169]" + ":" + infoCam });//Camera model
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[SE0130]" + ":" + infoRot });//Orientation
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[OT0398]" + ":" + infoDateM});//Date Modified
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3907]" + ":" + infoExp });//EXPOSURE TIME
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[SE3908]" + ":" + infoFNum });//F Number
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0170]" + ":" + infoFocal });//Focal length
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0171]" + ":" + infoColorSp });//Colour space
        picPlayerMenu.menuData.menuPicInfo.push({"icon": "hiMedia/normal.png", "text": "[DMP0172]" + ":" + infoGPS });//Geographic Location
    }

    picPlayer.closePicPlayer = function () {
        //leftover  3D&MEMC处理
        try {
            if(!!picPlayer.bgmOpen){
                model.mpctrl.setBGMusicUrl(createStringVector(["stop", "8"]));
            }
            UI.popSubModule();
            hiMedia.needRefreshFB = false;
            UI.pushSubModule("hiMedia", "fileBrowser", true);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    picPlayer.onPop = function (to) {
        try {
            DBG_ALWAYS("[onExit]PicPlayer");

            clearTimeout(picStartTimer);
            clearTimeout(getImageSizeTimer1);
            clearTimeout(getImageSizeTimer2);
            clearTimeout(picPlayer.playTime);
            clearTimeout(picPlayer.closeStatusTimer);
            clearTimeout(picPlayer.ControlTimer);
            picPlayer.closeStatus();
            //退出时复位焦点缩放
            try{
                UI.getCurrFocus().scale.x = UI.getCurrFocus().scale.x = 1.0;
            }catch(ex){
                DBG_ERROR(ex.message);
            }
            picPlayer.resetMenu();
            picPlayer.closeMenu("onpop");
            UI.removeMask(picPlayerMenuList);
            UI.removeView(picPlayerMenuList);
            UI.removeScrollbar(pMenuListContainer);

            model.mpctrl.MpCtrl(3);
            //if (!!playNextTimer) {
            //    clearTimeout(playNextTimer);
            //    playNextTimer = null;
            //}
            if (!!hiMedia.loadingtimer) {
                hiMedia.endLoading("pop picPlayer");
            }
            hiMedia.setNoSignalTimeout();
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, picPlayer.onPStateChanged);
            DBG_INFO("picPlayer poped!");
            pubStateMediaDmp(picPlayer.picList[picPlayer.picIndex].picName, 0, 0, 0, "stop", "picture", picPlayer.pWidth + "*" + picPlayer.pHeight);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }
    picPlayer.picPlayOrPause = function () {

        //playing = true;
        if (picPlayer.playerStatus == 0) {
            if (localStorage.PrepeatIndex == 1 && picPlayer.picIndex >= picPlayer.picList.length - 1) {
                hiMedia.toastMsg("[DMP0126]");
            } else {
                picPlayer.showStatus("stop");
                picPlayer.retryTime = 6;
                picPlayer.playTime = setInterval(function () {
                    if (localStorage.PrepeatIndex == 1) {
                        if (picPlayer.picIndex < picPlayer.picList.length - 1) {
                            picPlayer.next();
                        } else {
                            clearInterval(picPlayer.playTime);
                            //设置PAUSE图标
                            picPlayer.playerStatus = 0;
                            picPlayer.showStatus("play");
                            //hiMedia.toastMsg("[DMP0126]");
                        }
                    }
                    else if (localStorage.PrepeatIndex == 0) {
                        if (picPlayer.picIndex < picPlayer.picList.length - 1)
                            picPlayer.next();
                        else {
                            picPlayer.picIndex = 0;
                            picPlayer.playPicByUrl(picPlayer.picList[0].picUrl);
                        }
                    }
                    //默认为6S，不需要调整了
                }, picPlayer.intervalArray[picPlayer.picIntervalIndex] * 1000);

                //$("#picPlayerStatus").attr("src", "img/himedia/picPlayer/play_status.png");

                picPlayer.playerStatus = 1;
                try {
                    pubStateMediaDmp(picPlayer.picList[picPlayer.picIndex].picName, 0, 0, 0, "slide", "picture", picPlayer.pWidth + "*" + picPlayer.pHeight);
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        }
        else if (picPlayer.playerStatus == 1) {
            picPlayer.showStatus("play");
            picPlayer.retryTime = 30;
            clearInterval(picPlayer.playTime);
            //$("#picPlayerStatus").attr("src", "img/himedia/picPlayer/pause_status.png");

            picPlayer.playerStatus = 0;
            try {
                pubStateMediaDmp(picPlayer.picList[picPlayer.picIndex].picName, 0, 0, 0, "single", "picture", picPlayer.pWidth + "*" + picPlayer.pHeight);
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }

        }

    };

    picPlayer.prev = function () {
        if (localStorage.PrepeatIndex == 1 && picPlayer.picIndex <= 0) {
            hiMedia.toastMsg("[DMP0126]");//Already last file
            return;
        }
        if (picPlayer.picIndex == 0) {
            picPlayer.picIndex = picPlayer.picList.length - 1;
            picPlayer.playPicByUrl(picPlayer.picList[picPlayer.picIndex].picUrl);
        } else {
            picPlayer.picIndex--;
            picPlayer.playPicByUrl(picPlayer.picList[picPlayer.picIndex].picUrl);
        }
    };
    picPlayer.next = function () {
        if (localStorage.PrepeatIndex == 1) {
            if (picPlayer.picIndex >= picPlayer.picList.length - 1) {
                hiMedia.toastMsg("[DMP0126]");
                return;
            }
            if (picPlayer.picIndex == picPlayer.picList.length - 2) {
                clearInterval(picPlayer.playTime);
                picPlayer.showStatus("play");
                if(picPlayer.playerStatus == 1){
                    picPlayer.playerStatus = 0;
                    hiMedia.toastMsg("[DMP0126]");
                }
            }
        }
        if (picPlayer.picIndex < picPlayer.picList.length - 1) {
            picPlayer.picIndex++;
            picPlayer.playPicByUrl(picPlayer.picList[picPlayer.picIndex].picUrl);
        } else {
            picPlayer.picIndex = 0;
            picPlayer.playPicByUrl(picPlayer.picList[picPlayer.picIndex].picUrl);
        }
    };

    picPlayer.imgLeft = function () {
        DBG_INFO("current function : imgLEFT");
        if (picPlayer.picList[picPlayer.picIndex].picName.indexOf(".gif") != -1) {
            hiMedia.toastMsg("[SE0452]");//Not available
            return;
        }
        if (picPlayer.picList[picPlayer.picIndex].picExifRotate != 3) {
            picPlayer.hasPicExifRotate = true;
            picPlayer.rotateIndex = picPlayer.picList[picPlayer.picIndex].picExifRotate;
        } else {
            picPlayer.readRotate();
        }
        if (picPlayer.rotateIndex >= 0 && picPlayer.rotateIndex <= 6) {
            // DBG_INFO("LEFT-1", imgArr[curr].width);
            picPlayer.rotateIndex--;
            if (picPlayer.rotateIndex == -1) {
                picPlayer.rotateIndex = 3;
            }
            picPlayer.rotate(picPlayer.rotateDegree[picPlayer.rotateIndex]);
            if (!!picPlayer.hasPicExifRotate) {
                picPlayer.picList[picPlayer.picIndex].picExifRotate = picPlayer.rotateIndex;
            }
            hiMedia.picRotateContainer.push(
                {
                    "path": picPlayer.picList[picPlayer.picIndex].picUrl,
                    "rotate": picPlayer.rotateIndex
                }
            )
            hiMedia.picRotateContainer = removeDuplicates(hiMedia.picRotateContainer).length > 0 ? removeDuplicates(hiMedia.picRotateContainer) : hiMedia.picRotateContainer;
            if(hiMedia.picRotateContainer.length > 100){
                hiMedia.picRotateContainer = null;
            }
        }
    };

    picPlayer.imgRight = function () {
        DBG_INFO("current function : imgRight");
        if (picPlayer.picList[picPlayer.picIndex].picName.indexOf(".gif") != -1) {
            hiMedia.toastMsg("[SE0452]");//Not available
            return;
        }
        if (picPlayer.picList[picPlayer.picIndex].picExifRotate != 3) {
            picPlayer.hasPicExifRotate = true;
            picPlayer.rotateIndex = picPlayer.picList[picPlayer.picIndex].picExifRotate;
        } else {
            picPlayer.readRotate();
        }
        if (picPlayer.rotateIndex >= 0 && picPlayer.rotateIndex <= 6) {
            picPlayer.rotateIndex++;
            if (picPlayer.rotateIndex == 7) {
                picPlayer.rotateIndex = 3;
            }
            picPlayer.rotate(picPlayer.rotateDegree[picPlayer.rotateIndex]);
            if (!!picPlayer.hasPicExifRotate) {
                picPlayer.picList[picPlayer.picIndex].picExifRotate = picPlayer.rotateIndex;
            }
            hiMedia.picRotateContainer.push(
                {
                    "path": picPlayer.picList[picPlayer.picIndex].picUrl,
                    "rotate": picPlayer.rotateIndex
                }
            )
            hiMedia.picRotateContainer = removeDuplicates(hiMedia.picRotateContainer).length > 0 ? removeDuplicates(hiMedia.picRotateContainer) : hiMedia.picRotateContainer;
            if(hiMedia.picRotateContainer.length > 100){
                hiMedia.picRotateContainer = null;
            }
        }
    };
    picPlayer.rotateAfterplay = function () {
        picPlayer.readRotate();
        if(picPlayer.rotateIndex != 3){
            picPlayer.rotate(picPlayer.rotateDegree[picPlayer.rotateIndex]);
        }
    }

    picPlayer.imgInfo = function () {
        picPlayer.dialogShowStatus = 2;
        $("#picInformation").css("display", "block");
    }
    picPlayer.imgSetting = function () {
        picPlayer.dialogShowStatus = 1;
        $("#picPlayBackSetting").css("display", "block");

    };
    picPlayer.rotate = function (degree) {
        DBG_INFO("rotate degree is : " + degree);
        try {
            model.mpctrl.rotate(degree);
        }
        catch (ex) {
            DBG_ERROR("rotate error " + ex.message);
        }
        //picPlayer.setScreenSize(picPlayer.picZoomIndex);

    };

    picPlayer.resetMenu = function () {
        //hiMedia.showMenuChipByIndex(circleName, picPlayerMenuList, 0, picPlayer.currentMenuIndex, 743);
        picPlayer.currentMenuIndex = 0;
        UI.setText(picPlayerMenuName, menuNameArray[picPlayer.currentMenuIndex]);

        //UI.setText();

    }
    picPlayer.onNormal = function (focus) {
        if (!!picPlayerMenu.visible) {
            //createjs.Tween.removeTweens(focus.scale);
            focus.scale.x = 1;
            focus.scale.y = 1;
            UI.base.stopText(focus.children[2]);
            return true;
        } else {
            return false;
        }
    };
    picPlayer.onFocus = function (focus) {

        if (!!picPlayerMenu.visible) {
            createjs.Tween.removeTweens(UI.base.cursor);
            UI.moveCursor(UI.adjustView());
            focus.scale.x = 1.05;
            focus.scale.y = 1.05;
            UI.base.cursor.alpha = 1;
            UI.base.cursor.visible = true;
            UI.base.runText(focus.children[2]);
            try {
                if (picPlayerMenu.alpha == 1) {
                    var currentIndex = pMenuListContainer.initSequence.indexOf(UI.getCurrFocus());
                    hiMedia.hideListData(pMenuListContainer, currentIndex, 6);
                }
                else if (picPlayerMenu2.alpha == 1) {
                    var currentIndex = pMenuListContainer_2.initSequence.indexOf(UI.getCurrFocus());
                    hiMedia.hideListData(pMenuListContainer_2, currentIndex, 6);
                }
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }
            //UI.base.cursor.scale.x = UI.base.cursor.scale.y = 1.05;
//            UI.base.cursor.alpha = 1;
//            UI.base.cursor.visible = true;
            return true;
//            UI.getTween(UI.base.cursor).to({scaleX: 1.05, scaleY: 1.05}, 500, UI.ease.quartOut);
        } else {
            return picPlayer.isPBarShow == 1;
        }
    };
    picPlayer.closeStatusTimer = null;
    picPlayer.showStatus = function (status) {
        switch (status) {
            case "play":
                //UI.setImage(picStatus, "hiMedia/play_status_pic.png");
                UI.setImage(PlayPauseBt, "hiMedia/btn/icn_play_normal.png");
                //picStatus.visible = true;
                UI.updateStage();
                if (!!picPlayer.closeStatusTimer) {
                    clearTimeout(picPlayer.closeStatusTimer);
                }
                picPlayer.closeStatusTimer = setTimeout(function () {
                    picPlayer.closeStatus();
                }, 3000);
                break;
            case "stop":
                //UI.setImage(picStatus, "hiMedia/btn/icn_pause_normal.png");
                UI.setImage(PlayPauseBt, "hiMedia/btn/icn_pause_normal.png");
                //picStatus.visible = true;
                UI.updateStage();
                if (!!picPlayer.closeStatusTimer) {
                    clearTimeout(picPlayer.closeStatusTimer);
                }
                picPlayer.closeStatusTimer = setTimeout(function () {
                    picPlayer.closeStatus();
                }, 3000);
                break;
            default :
                break;
        }
    }
    picPlayer.closeStatus = function () {
        //picStatus.visible = false;
        UI.updateStage();
    }
    picPlayer.reFocusMenu = function () {
        switch (picPlayer.currentMenuIndex) {
            case 0:
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer.initSequence[picPlayer.initIndex];
                break;
            case 1:
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[picPlayer.picRotateIndex];
                break;
            case 2:
                //更新循环模式
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[picPlayer.picZoomIndex];
                break;
            case 3:
                //更新循环模式
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[parseInt(localStorage.PrepeatIndex)];
                break;
            case 4:
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[picPlayer.picIntervalIndex];
                break;

            case 7:
                //更新播放列表
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[picPlayer.picIndex];
                break;


            default ://旋转不需要记录焦点
                picPlayer.currFocus = picPlayer.currentMenuFocus =
                    pMenuListContainer_2.initSequence[0];
                break;
        }
    }
    picPlayer.onkey_UP = function () {
        if (!picPlayerMenu.visible) {
            if (!!picPlayer.canMove) {
                try {
                    model.mpctrl.ViewMove("0", "20");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                picPlayer.reopenBar();
            }
        } else {
            picPlayer.closeGhostModule();
            return true;
        }
    }
    picPlayer.onkey_DOWN = function () {
        DBG_INFO("onkey_DOWN");
        if (!picPlayerMenu.visible) {
            if (!!picPlayer.canMove) {
                try {
                    model.mpctrl.ViewMove("1", "20");
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {
                picPlayer.reopenBar();
            }
        } else {
            picPlayer.closeGhostModule();
            return true;
        }
    }

    //添加对图片名称显示的超时处理
    picPlayer.hideBar = function () {
        picPlayer.isPBarShow = 0;
        picNameTitle.y = -80;
        picPlayerCtl.y = 1100;
        picPlayerHeaderBg.y = -200;
        picPlayerFooterBg.y = 1210;
        //picPlayerCtl.visible = false;
        //memc leftover
        UI.updateStage();
    }
    picPlayer.reopenBar = function () {
        picPlayer.isPBarShow = 1;
        //$("#picPlayerPanel").css("visibility", "visible");
        //UI.getTween(picPlayerMenu, true).to({alpha: 0, visible: false}, 500);
        UI.focusTo(PlayPauseBt);
        UI.moveCursor(UI.adjustView());
        UI.base.cursor.alpha = 1;
        picNameTitle.y = 48;
        picPlayerCtl.y = 984;
        picPlayerHeaderBg.y = 70;
        picPlayerFooterBg.y = 880;
        DBG_INFO("clear Timer");
        UI.updateStage();
        clearTimeout(picPlayer.ControlTimer);
        picPlayer.ControlTimer = setTimeout(function () {
            picPlayer.hideBar();
        }, 3000);
    }
    picPlayer.refreshMenuArray = function () {
        picPlayer.menuArray = [picPlayerMenu.menuData.menuPicInit,
            picPlayerMenu.menuData.menuPicRotate, picPlayerMenu.menuData.menuZoomMode,
            picPlayerMenu.menuData.menuPicRepeatMode,
            picPlayerMenu.menuData.menuPicInterval, picPlayerMenu.menuData.menuPicMode,
            picPlayerMenu.menuData.menuPicInfo, picPlayerMenu.menuData.menuPicList,
            picPlayerMenu.menuData.menuSetting
        ];
    }
    picPlayer.getPicInfo = function () {
        var width = 0;
        var height = 0;
        var size = "N/A";
        var format = " ";
        try {
            var infoData = model.mpctrl.getMetadata();
            width = picPlayer.pWidth = parseInt(infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_VIDEO_WIDTH]);
            height = picPlayer.pHeight = parseInt(infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_VIDEO_HEIGHT]);
            size = parseInt(infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_FILE_SIZE] / 1024) + "kB";
            format = infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_VIDEO_FORMAT];
            DBG_INFO("picplayer width:" + width + "height:" + height + "size:" + size + "format:" + format);
            picPlayer.setInfoMenu(picPlayer.picList[picPlayer.picIndex].picName, width + "*" + height, size, Config.language.DMP0129);
            var exifdata = model.mpctrl.getMpctrlEInfo();
            DBG_INFO("EXIF INFO :  " + exifdata);

            if (!!exifdata[0]) {
                var cameraModel = exifdata[2] ? exifdata[2] : Config.language.DMP0129;
                var rotate = exifdata[4] ? exifdata[4] : Config.language.DMP0129;
                var date = picPlayer.picList[picPlayer.picIndex].picTime;
                date = date ? changeUTCDate(parseInt(date)) + " " + UTCToLocalTime(parseInt(date), false) : Config.language.DMP0129;
                var tmpTime = exifdata[5] + "-" + exifdata[6] + "-" + exifdata[7] + " " + checkTime(exifdata[8]) + ":" + checkTime(exifdata[9]) + ":" + checkTime(exifdata[10]);
                tmpTime = exifdata[5] && exifdata[5] != 0 ? tmpTime : Config.language.DMP0129;
                var exposureTime = exifdata[0] ? exifdata[0] : Config.language.DMP0129;
                var FNumber = exifdata[1] && exifdata[1] != 0 ? "f/" + exifdata[1] : Config.language.DMP0129;
                var focalLength = exifdata[11] / exifdata[12];
                focalLength = exifdata[11] && exifdata[11] != 0 ? focalLength : Config.language.DMP0129;
                var colorSpace = exifdata[13] ? exifdata[13] : Config.language.DMP0129;
                var gpsinfo = exifdata[14] + ":" + exifdata[17] + "°" + exifdata[18] + "\'" + exifdata[19] + "\"" + ", " + //latitude
                    exifdata[15] + ":" + exifdata[20] + "°" + exifdata[21] + "\'" + exifdata[22] + "\"" + ", " + //longitude
                    exifdata[23];  //altitude
                gpsinfo = exifdata[14] ? gpsinfo : Config.language.DMP0129;

                //infoCam, infoRot, infoDateM, infoExp, infoFNum, infoFocal,infoColorSp, infoGPS
                picPlayer.setExifInfoMenu(
                    cameraModel, //Camera Model
                    rotate,//Rotate
                    date,//date modified
                    exposureTime,//Exposure time
                    FNumber,//F Number
                    focalLength, //focal length
                    colorSpace,//color space
                    gpsinfo// GPS
                    //tmpTime, //infoDate
                    //exifdata[3],//Manufactory
                );
                picPlayer.resetInfoMenu(3, "[SE3906]"+ ":" + tmpTime);
                var rotate = parseInt(exifdata[4]);
                switch (rotate) {
                    case 0:
                    case 360:
                        rotate = 3;
                        break;
                    case 90:
                        rotate = 0;
                        break;
                    case 180:
                        rotate = 1;
                        break;
                    case 270:
                        rotate = 2;
                }
                if (rotate != 3) {
                    picPlayer.rotate(picPlayer.rotateDegree[rotate]);
                    picPlayer.picList[picPlayer.picIndex].picExifRotate = rotate;
                }
                //picPlayer.imgLeft();//测试旋转使用
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        function checkTime(a) {
            return(a < 10 ? "0" : "") + a;
        };
    }
    function changeUTCDate(Time) {
        var date = new Date(getLocalTimeByUTC(Time) * GLOBAL.MILLIBASE);
        var yy = date.getUTCFullYear();
        var mm = ("0" + (date.getUTCMonth() + 1)).slice(-2);
        var dd = ("0" + date.getUTCDate()).slice(-2);
        var dateString = yy + "-" + mm + "-" + dd;
        return dateString;
    }

    picPlayer.setScreenSize = function (index) {
        if (!tv) {
            return;
        }
        var screenWidth = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_WIDTH;
        var screenHeight = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_HEIGHT;
        var screenMode = MpCtrlModelDefines.ENUM_SL2_TVAPI_MPCTRL_VI32_SCREEN_MODE_NORMAL;
//        if (picPlayer.rotateIndex % 2 == 1) {
        picPlayer.pWidth = tv ? parseInt(model.mpctrl.getMetadata()[26]) : 400;
        picPlayer.pHeight = tv ? parseInt(model.mpctrl.getMetadata()[27]) : 400;
//        }
//        else {
//            picPlayer.pWidth = tv ? parseInt(model.mpctrl.getMetadata()[27]) : 400;
//            picPlayer.pHeight = tv ? parseInt(model.mpctrl.getMetadata()[26]) : 400;
//        }
        picPlayer.resolution = picPlayer.pWidth + "*" + picPlayer.pHeight;
        DBG_INFO("resolution : " + picPlayer.resolution);
        switch (index) {
            case 0:
                /*
                 //if (picPlayer.pHeight <= screenHeight && picPlayer.pWidth <= screenWidth) {
                 var wh = picPlayer.pWidth / picPlayer.pHeight;
                 if (wh < screenWidth / screenHeight) {
                 var w1 = screenHeight * wh;
                 var x1 = (screenWidth - w1) / 2;
                 model.mpctrl.setScreenPosition(createIntergerVector([x1, 0, w1, screenHeight, screenMode, 0]));
                 } else if (wh > screenWidth / screenHeight) {
                 var h1 = screenWidth / wh;
                 var y1 = (screenHeight - h1) / 2;
                 model.mpctrl.setScreenPosition(createIntergerVector([0, y1, screenWidth, h1, screenMode, 0]));
                 } else {
                 model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                 }
                 //}
                 */
                model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                picPlayer.canMove = false;
                DBG_INFO("zoom: Fit");
                break;
            case 1:
                if (picPlayer.pHeight >= screenHeight || picPlayer.pWidth >= screenWidth) {
                    model.mpctrl.setScreenPosition(createIntergerVector([0, 0, screenWidth, screenHeight, screenMode, 0]));
                } else {
                    if (picPlayer.pHeight >= screenWidth || picPlayer.pWidth >= screenHeight) {
                        if (picPlayer.pHeight >= screenWidth) {
                            picPlayer.pWidth = screenWidth;
                        }
                        if (picPlayer.pWidth >= screenHeight) {
                            picPlayer.pHeight = screenHeight;
                        }
                    } else {
                        if (picPlayer.pWidth > picPlayer.pHeight) {
                            picPlayer.pHeight = picPlayer.pWidth;
                        }
                        else {
                            picPlayer.pWidth = picPlayer.pHeight;
                        }
                    }
                    var x2 = (screenWidth - picPlayer.pWidth) / 2;
                    var y2 = (screenHeight - picPlayer.pHeight) / 2;
                    model.mpctrl.setScreenPosition(createIntergerVector([x2, y2, picPlayer.pWidth, picPlayer.pHeight, screenMode, 0]));
                }

                /*
                 if (picPlayer.pHeight <= screenHeight && picPlayer.pWidth <= screenWidth) {
                 var x2 = (screenWidth - picPlayer.pWidth) / 2;
                 var y2 = (screenHeight - picPlayer.pHeight) / 2;
                 model.mpctrl.setScreenPosition([x2, y2, picPlayer.pWidth, picPlayer.pHeight, screenMode, 0]);
                 } else {//如果超出了就做FIT处理
                 var wh = picPlayer.pWidth / picPlayer.pHeight;
                 if (wh < screenWidth / screenHeight) {
                 var w1 = screenHeight * wh;
                 var x1 = (screenWidth - w1) / 2;
                 model.mpctrl.setScreenPosition([x1, 0, w1, screenHeight, screenMode, 0]);
                 } else if (wh > screenWidth / screenHeight) {
                 var h1 = screenWidth / wh;
                 var y1 = (screenHeight - h1) / 2;
                 model.mpctrl.setScreenPosition([0, y1, screenWidth, h1, screenMode, 0]);
                 } else {
                 model.mpctrl.setScreenPosition([0, 0, screenWidth, screenHeight, screenMode, 0]);
                 }
                 }
                 */
                picPlayer.canMove = false;
                DBG_INFO("zoom: Original");
                break;
            case 2:
                picPlayer.zoomPic(screenWidth,screenHeight,screenMode,2);
                break;
            case 3:
                picPlayer.zoomPic(screenWidth,screenHeight,screenMode,3);
                break;
            case 4:
                picPlayer.zoomPic(screenWidth,screenHeight,screenMode,4);
                break;
            default:
                DBG_ERROR("screenIndex error!!" + picPlayer.screenIndex);
                break;
        }
    }
    picPlayer.zoomPic = function (screenW,screenH,screenM,zoomIndex) {
        try {
            var zoomWidth = parseInt(screenW * Math.sqrt(zoomIndex));
            var zoomHeight = parseInt(screenH * Math.sqrt(zoomIndex));
            var x2 = parseInt((screenW - zoomWidth) / 2);
            var y2 = parseInt((screenH - zoomHeight) / 2);
            model.mpctrl.setScreenPosition(createIntergerVector([x2, y2, zoomWidth, zoomHeight, screenM, 0]));
            picPlayer.canMove = true;
            hiMedia.toastMsg("[OT0399]", 5000);
            DBG_INFO("zoom Index:" + zoomIndex + " zoom Width:" + zoomWidth + " zoom Height:" + zoomHeight + " x2:" + x2 + " y2:" + y2);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    picPlayer.playBGM = function () {
        try {
            if (!picPlayer.bgmOpen) {
                picPlayer.playMusicByUrl(hiMedia.BGMList[picPlayer.musicIndex]);

                DBG_INFO("play BGM first");
            }
            else {
                model.mpctrl.setBGMusicUrl(createStringVector(["play", "8"]));
                DBG_INFO("BGM play");
            }
            bmgSwitch.switch();
            picPlayer.bgmState = 1;
            picPlayer.bgmOpen = true;
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    picPlayer.pauseBGM = function () {
        try {
            model.mpctrl.setBGMusicUrl(createStringVector(["pause", "8"]));
            DBG_INFO("BGM pause");
            if (picPlayer.bgmState == 1) {
                bmgSwitch.switch();
                picPlayer.bgmState = 0;
                UI.updateStage();
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    picPlayer.playNextWhenStop = function () {
        switch (parseInt(localStorage.MrepeatIndex)) {
            //调整repeat模式把ALL和once对调
            case 1:
                if (picPlayer.musicIndex < hiMedia.BGMList.length - 1) {
                    picPlayer.musicIndex++;
                    picPlayer.playMusicByUrl(hiMedia.BGMList[picPlayer.musicIndex]);
                }
                else if (picPlayer.musicIndex >= hiMedia.BGMList.length - 1) {
                    DBG_INFO("Stop music,because the last one.");
                    model.mpctrl.setBGMusicUrl(createStringVector(["stop", "8"]));
                }
                break;
            case 0:
                if (picPlayer.musicIndex < hiMedia.BGMList.length - 1) {
                    picPlayer.musicIndex++;
                    picPlayer.playMusicByUrl(hiMedia.BGMList[picPlayer.musicIndex]);
                }
                else if (picPlayer.musicIndex >= hiMedia.BGMList.length - 1) {
                    picPlayer.musicIndex = 0;
                    picPlayer.playMusicByUrl(hiMedia.BGMList[0]);
                }

                break;
            case 2:
                picPlayer.playMusicByUrl(hiMedia.BGMList[picPlayer.musicIndex]);
                break;
            case 3:
                picPlayer.musicIndex = Math.floor(Math.random() * hiMedia.BGMList.length);
                DBG_INFO("[random] musicIndex=" + picPlayer.musicIndex);
                picPlayer.playMusicByUrl(hiMedia.BGMList[picPlayer.musicIndex]);
                break;
            default :
                break;
        }

    }
    picPlayer.playMusicByUrl = function (url) {
        DBG_ALWAYS("current bgm url is : " + url);
        try {
            model.mpctrl.setBGMusicUrl(createStringVector([url, "8"]));
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
//
    function removeDuplicates(array) {
        var cont = [];
        if (array.length == 1) {
            cont.push(array[0]);
        }else{
            for (var i = 0; i < array.length; i++) {
                for (var j = i + 1; j < array.length; j++) {
                    if (array[i].path === array[j].path){
                        j = ++i;
                    }
                }
                cont.push(array[i]);
            }
        }
        return cont;
    }
    picPlayer.readRotate =function(){
        for(var i=0; i < hiMedia.picRotateContainer.length;i++){
            if(hiMedia.picRotateContainer[i].path === picPlayer.picList[picPlayer.picIndex].picUrl){
                picPlayer.rotateIndex = hiMedia.picRotateContainer[i].rotate;
                break;
            }else{
                picPlayer.rotateIndex=3;
            }
        }
    }
    picPlayer.closeGhostModule =function() {
        if (!!UI.getGhostModule("hiMediaToast")) {
            UI.popGhostModule("hiMediaToast");
        }
    }
};

