/**
 * Created by Brad on 2016/5/11.
 */

UI.moduleBuilder['hiMedia']['hiMediaDialog'] = function () {
    /*default data*/
    var template = Util.readJson("module/hiMedia/hiMediaDialog.json");
    var hiMediaDialogData = {
        hiMediaDialog_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "[SE2642]",
        btn_left_text: "[GE0008]",
        hiMediaDialogContent: "[DMP0163]"
    };

    var hiMediaDialog = SubModule.create(hiMediaDialogData, template);
    hiMediaDialog.protected = true;
    hiMediaDialog.storeTime = 0;
    var BtnRight = UI.getItem(hiMediaDialog, "BtnRight");
    var BtnLeft = UI.getItem(hiMediaDialog, "BtnLeft");
    var hiMediaDialogContent = UI.getItem(hiMediaDialog, "hiMediaDialogContent");
    hiMediaDialog.currFocus = BtnRight;
    BtnRight.alpha = BtnLeft.alpha = 0.6;
    hiMediaDialogContent.alpha = 0.6;

    hiMediaDialog.onFocus = function (focus) {
        DBG_INFO("hiMediaDialog_onFocus");
        onFocusLiveTVTarget(focus, 1.05, 500);
        return true;
    }

    hiMediaDialog.onNormal = function (focus) {
        DBG_INFO("hiMediaDialog_onNormal");
        onNormalLiveTVTarget(focus, 0.6, 500);
        return true;
    }

    BtnRight.onkey_ENTER = function () {
        UI.popSubModule();
        try {
            if (!!hiMediaDialog.param) {
                var StorageTime = hiMediaDialog.param.StorageTime;
                DBG_INFO("Try to play at " + parseInt(StorageTime));
                model.mpctrl.MpCtrl(8, null, parseInt(StorageTime));
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    hiMediaDialog.onPush = function () {
        if (!!hiMediaDialog.param) {
            hiMediaDialog.storeTime = hiMediaDialog.param.StorageTime;
            var str = Config.language.DMP0163;
            var time = hiMedia.getTimeText(hiMediaDialog.storeTime, "HMS");
            str = str.replace(/\[.*?\]/g, time);
            //str = str.replace("[****]", time);
            UI.setText(hiMediaDialogContent, str);
            hiMedia.endLoading("hiMediaDialog");
        }
    }
    hiMediaDialog.onPop = function () {
        BtnRight.scale.x = 1;
        BtnRight.scale.y = 1;
        BtnLeft.scale.x = 1;
        BtnLeft.scale.y = 1;
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
    }

    function closeHiMediaDialog() {
        try {
            UI.popSubModule();
            model.mpctrl.MpCtrl(1);

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    BtnLeft.onkey_ENTER = hiMediaDialog.onkey_BACKSPACE = closeHiMediaDialog;
};