// Global Module Var
var hiMedia = window["hiMedia"];

// Init
(function () {
    //[FORDB],添加MEDIA模块配置开关
    hiMedia.M_PVR = false;
    hiMedia.M_SORT = false;
    hiMedia.M_TOP = false;
    hiMedia.M_LIST = false;
    hiMedia.M_HEADPHONE = false;
    //配置结束
    hiMedia.devceBrowserEnable = true;//用于标志设备浏览器当前是否可用，因为设备浏览器一直在
    hiMedia.fileBrowserAllData = [];
    hiMedia.fileBrowserFileData = [];
    hiMedia.fileBrowserVideoData = [];
    hiMedia.fileBrowserMusicData = [];
    hiMedia.fileBrowserPicData = [];
    // save the search data
    hiMedia.fileBrowserSearchedAllData = [];
    hiMedia.fileBrowserSearchedFileData = [];
    hiMedia.fileBrowserSearchedVideoData = [];
    hiMedia.fileBrowserSearchedMusicData = [];
    hiMedia.fileBrowserSearchedPicData = [];
    hiMedia.picRotateContainer = [];
    hiMedia.searchMode = false;

    hiMedia.fileBrowserList = null;
    hiMedia.curFilePath = "";
    hiMedia.curVolumeId = "";
    hiMedia.lyricsDIndex = 0;//用于记录歌词的编码格式
    hiMedia.needRefreshFB = true;
    hiMedia.fileType = {
        all: 0,
        pic: 1,
        music: 2,
        video: 3,
        search: -1
    };
    hiMedia.currentDevice = 0;
    hiMedia.device = {
        usb: 0,
        dms: 1,
        pvr: 2
    };
    hiMedia.DEVICE_INIT_PAGE = 0;
    hiMedia.DEVICE_DLNA_PAGE = 1;
    hiMedia.DEVICE_PVR_PAGE = 2;
    hiMedia.initVideoList = [];
    hiMedia.initVideoIndex = 0;
    hiMedia.initMusicList = [];
    hiMedia.initMusicIndex = 0;
    hiMedia.initPicList = [];
    hiMedia.initPicIndex = 0;
    hiMedia.toastText = null;
    hiMedia.playerstatus = 0;
    hiMedia.needPopCurSubModule = false;
    hiMedia.playerToSearch = false;
    //新增记录USB列表的全局变量用于适配DB接口  [FORDB]
    hiMedia.volumesList = [];
    hiMedia.pauseFromFB = false;
    hiMedia.noSaveList = true;
    hiMedia.BGMList = [];


})();

// Actions
(function () {
    //轮询获取USB的内容的iterator
    var UsbCount = 0;
    var UsbTableReadStatus = 0;
    var UsbTableReadCnt = 0;
    var UsbTableReadCnt_plus = 0;
    var table_read_once = 60;//暂时改为60
    var usbTimeOut = null;
    var dlnaTimeOut = null;
    hiMedia.needWizard = false;
    //注册U盘和DLNA设备上下线通知
    hiMedia.onPush = function (from) {
        //添加MEDIA全局标志
        GLOBAL.MEDIA_STARTUP_FLAG = true;

        //北美不需要WIZARD
//        try {
//            if (!tv) {
//                hiMedia.needWizard = false;
//            } else {
//                hiMedia.needWizard = !model.system.getEnterHimediaFlag();
//            }
//            DBG_ALWAYS("hiMedia.needWizard = " + hiMedia.needWizard);
//        }
//        catch (ex) {
//            DBG_ERROR(ex.message);
//        }
        hiMedia.fileBrowserAllData = [];
        hiMedia.fileBrowserFileData = [];
        hiMedia.fileBrowserVideoData = [];
        hiMedia.fileBrowserMusicData = [];
        hiMedia.fileBrowserPicData = [];
        hiMedia.picRotateContainer = [];
        hiMedia.curFilePath = "";
        hiMedia.curVolumeId = "";
        hiMedia.needRefreshFB = true;
        hiMedia.currentDevice = 0;
        hiMedia.initVideoList = [];
        hiMedia.initVideoIndex = 0;
        hiMedia.initMusicList = [];
        hiMedia.initMusicIndex = 0;
        hiMedia.initPicList = [];
        hiMedia.currentSortType = "name";
        hiMedia.initPicIndex = 0;
        hiMedia.deviceName = "";
        hiMedia.needPopCurSubModule = false;
        hiMedia.storage = window.localStorage;
        hiMedia.volumesList = [];
        hiMedia.pauseFromFB = false;
        UsbCount = 0;
        UsbTableReadStatus = 0;
        UsbTableReadCnt = 0;
        UsbTableReadCnt_plus = 0;
        table_read_once = 60;
        usbTimeOut = null;
        dlnaTimeOut = null;
        hiMedia.BGMList = [];
        hiMedia.noSaveList = true;
        //DBG_INFO(hiMedia.info.caller);
        if (!hiMedia.needWizard) {
            UI.pushSubModule("hiMedia", "deviceBrowser", true, hiMedia.info);
        }
        else {
            try {
                UI.pushSubModule("hiMedia", "mediaWizard", true, hiMedia.info);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }

        }

        try {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, onUSBSTATEChanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkChanged);
            //UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, onHeadPhoneChanged);
            //model.volume.onVstrLatestEventChaged = onVstrLatestEventChaged;
//            model.mpctrl.onITTXTrackResult = onITTXTrackResult;
//            model.mpctrl.onISUBTrackResult = onISUBTrackResult;
//            model.mpctrl.onAudioTrackResult = onAudioTrackResult;
//            model.mpctrl.onSeekToResult = onSeekToResult;
//            sendAM(":am,opera4x,hbbtv:resumetv=" + 0);//暫時屏蔽
            pauseDTV();
            pauseHBBTV();
            model.source.appStatusSet("media", "started");

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        try {
            var tmp_param = {
                AppName: APPNAME.HIMEDIA,
                LaunchSource: 1
            }
            DBG_INFO("log report GTAPPRun is start");
            LGReport.GTAPPRunStart(tmp_param.AppName, tmp_param.LaunchSource);
        } catch (ex) {
            DBG_ERROR(ex.message)
        }
        hiMedia.setNoSignalTimeout();
        try {
            hiMedia.preLoadMediaImg();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
        try {
            pubStateApp("Media", "media");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    hiMedia.onPop = function () {
        clearTimeout(usbTimeOut);
        hiMedia.endLoading("onPop");
        try {
            var tmp_param = {
                AppName: APPNAME.HIMEDIA,
                LaunchSource: 1
            }
            DBG_INFO("log report GTAPPRun is closed");
            LGReport.GTAPPRunClose(tmp_param.AppName, tmp_param.LaunchSource);
        } catch (ex) {
            DBG_ERROR(ex.message)
        }
        try {

            try {
                model.source.appStatusSet("media", "stoped");
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }


            try {
                //在hiMedia中的OnPop获取当前页面只有deviceBrowser，这里的判断去除了。
//                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
//                DBG_INFO("media exit."+currentSubModel);
//                if (currentSubModel == "deviceBrowser" || currentSubModel == "fileBrowser") {
//
//                    UI.popSubModule();
//                    resumeDTV();
//                } else {
//                    UI.popSubModule();
                //这个DELAY是必须的，场景就是在MEDIA上按launcher，并在Launcher上启动应用时，如果没有这个500ms的DELAY就回出现闪TV信号的问题
                //DBG_ALWAYS("Delay resumeDTV by DMP.");
//                sendAM(":am,opera4x,hbbtv:resumetv=" + 1);//暫時屏蔽
                if (GLOBAL.MEDIA_EXIT_NOT_RESUEME_DTV) {
                    DBG_ERROR("hiMedia.onPop,not resumeDTV");
                    GLOBAL.MEDIA_EXIT_NOT_RESUEME_DTV = false;
                } else {
                    resumeDTV();
                }

//                }
            }
            catch (ex) {
                DBG_ERROR(ex.message);
            }

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        GLOBAL.MEDIA_STARTUP_FLAG = false;
        //添加MEDIA退出的全局标识
        UI.clearMediaTimeout();
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.USB_DEVICE_CHANGED, onUSBSTATEChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkChanged);
//        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, onHeadPhoneChanged);

    }
    hiMedia.onExit = function (to) {

    }
    //U盘上下线处理函数
    function onUSBSTATEChanged(value) {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        DBG_INFO("[onUSBSTATEChanged]value is :  " + value + "| currentSubModel= " + currentSubModel);
        //2,FSL2://2AC6-B6E9,USB1,,1,1520420,3618621,0| currentSubModel= fileBrowser
        var usbType = value[0];
        var usbId = value[1];
        var usbName = value[2];
        var eventType = value[4];
        DBG_INFO("eventType  :  " + eventType + " hiMedia.currentDevice  " + hiMedia.currentDevice);
        if (eventType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_HDD) {
            if (usbId.indexOf("FSL2") != -1) {
                if (usbType == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_ADDED) {
                    hiMedia.volumesList.push({deviceId: usbId, deviceName: usbName, deviceType: "usb"});
                } else if (usbType == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) {
                    var fileBrowser = UI.getSubModule("fileBrowser");
                    if(!!fileBrowser){fileBrowser.searchMode = false;}
                    for (var i = 0; i < hiMedia.volumesList.length; i++) {

                        if (hiMedia.volumesList[i].deviceId == usbId) {

                            hiMedia.volumesList.splice(i, 1);
                        }
                    }
                    try {
                        if (!!m_usbIterator) {
                            DBG_INFO("m_usbIterator disconnect");
                            m_usbIterator.disconnect();
                        }
                        if (!!m_directoryIterator) {
                            DBG_INFO("m_directoryIterator disconnect");
                            m_directoryIterator.disconnect();
                        }
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }
            }
            switch (currentSubModel) {
                case "deviceBrowser":
                    var deviceBrowser = UI.getSubModule("deviceBrowser");
                    if (!!value[0]) {
                        //Brad add to test BT17!!    !!usbTimeOut用于区分第一次启动
                        //该处更改对应的JIRA两个BUG :   MT5655SA-349和K321-8733
                        // if (deviceBrowser.HiMedia_initPage == 1) {  leftover

                        //MSD6586EU-7928
                        if (value[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) {
                            if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                                hiMedia.curVolumeId = "";
                            }
                        }
                        clearTimeout(usbTimeOut);
                        usbTimeOut = setTimeout(function () {
                            var usbTimeOutSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
                            if (usbTimeOutSubModel == "deviceBrowser") {
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                            }
                            else {
                                DBG_ERROR("current subModule is " + usbTimeOutSubModel + " not deviceBrowser!!!");
                            }
                        }, 2000);
                    }
                    break;
                case "fileBrowser":
                case "videoPlayer":
                case "musicPlayer":
                case "picPlayer":
                    if (value[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) {

                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        DBG_INFO("USB OFFLINE" + value[1] + " and " + hiMedia.curVolumeId);
                        if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                            clearTimeout(usbTimeOut);
                            usbTimeOut = setTimeout(function () {
                                hiMedia.devceBrowserEnable = true;
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                //拔下正在播放的U盘后不需要记录该U盘的ID了
                                hiMedia.curVolumeId = "";
                                UI.popSubModule();
                                deviceBrowser.visible = 1;

                            }, 500);

                        }
                    }
                    break;
                case "hiMediaDialog":
                    DBG_INFO("curVolumeId= " + hiMedia.curVolumeId + " value[1] " + value[1]);
                    if (value[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) {

                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        DBG_INFO("USB OFFLINE" + value[1] + " and " + hiMedia.curVolumeId);
                        if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                            clearTimeout(usbTimeOut);
                            usbTimeOut = setTimeout(function () {
                                hiMedia.devceBrowserEnable = true;
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                //拔下正在播放的U盘后不需要记录该U盘的ID了
                                hiMedia.curVolumeId = "";
                                UI.popModule();
                                UI.pushModule("hiMedia", {caller: "hiMediaDialog"});
                                //deviceBrowser.visible = 1;

                            }, 500);

                        }
                    }
                    break;
                default :
                    if (value[0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED) { //MSD6586EUU25-4441
                        //有飘LAUNCHER与SETTING等情况下拔出U盘的处理
                        DBG_INFO("offline videoplayer status is : " + hiMedia.playerstatus);
                        //在音乐或者视频正在播放或者暂停时拔下U盘，需要先手动停止一下播放器
                        if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1 &&
                            (hiMedia.playerstatus == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING ||
                            hiMedia.playerstatus == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE ||
                            hiMedia.playerstatus == MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST ||
                            hiMedia.playerstatus == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE)) {
                            try {
                                hiMedia.curVolumeId = "";
                                hiMedia.needPopCurSubModule = true;
                                model.mpctrl.MpCtrl(3);
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }

                        }
                        DBG_INFO("curVolumeId  :  " + hiMedia.curVolumeId + " value[1] : " + value[1]);
                        if (!!hiMedia.pauseFromFB && !!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                            hiMedia.curVolumeId = "";
                            hiMedia.needPopCurSubModule = true;
                        }
                        break;
                    }
            }
        }
        else if (eventType == VolumeModelDefines.SL2_TVAPI_VOLUME_FSAL2_MEDIA_TYPE_UPNP && hiMedia.currentDevice == hiMedia.device.dms) {
            //处理DMS事件
            try{
                var networkConfig = tv ? readFileFromNative('networkConfig.txt', 1) : null;
                if (networkConfig == null) {
                    var info = {"netwok": 0, "dlna": 1};
                    if (tv)writeFileToNative("networkConfig.txt", objToString(info), 1);
                } else {
                    if (networkConfig.dlna == 0) {
                        networkConfig.dlna = 1;
                        if (tv)writeFileToNative("networkConfig.txt", objToString(networkConfig), 1);
                    }
                }
            }
            catch(e){
                DBG_ERROR(e.message)
            }
            var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
            DBG_INFO("currentSubModel  :  " + currentSubModel);

            switch (currentSubModel) {
                case "videoPlayer":
                case "musicPlayer":
                case "picPlayer":
                case "fileBrowser":
                    DBG_INFO("curVolumeId= " + hiMedia.curVolumeId + " value[1] " + value[1]);
                    if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                        clearTimeout(usbTimeOut);
                        usbTimeOut = setTimeout(function () {
                            var deviceBrowser = UI.getSubModule("deviceBrowser");
                            UI.popSubModule();
                            deviceBrowser.visible = 1;
                            hiMedia.devceBrowserEnable = true;
                            deviceBrowser.onkey_BACKSPACE();
                            //deviceBrowser.RefreshUSBData(value[0], value[1]);

                            UI.updateStage();
                        }, 500);
                    }
                    break;

                case "deviceBrowser":
                    DBG_INFO("deviceBrowser.onkey_BACKSPACE();");
                    var deviceBrowser = UI.getSubModule("deviceBrowser");
                    deviceBrowser.onkey_BACKSPACE();
                    break;

            }
        } else {
            DBG_ERROR("other type : " + eventType);
        }
//        if (hiWebOsFrame.getCurrentPage().id == "himedia_videoPlayer") {
//            if (value[0] == "offline") {
//                if (!!HiFileBrowser.latestUsbId && HiFileBrowser.latestUsbId.indexOf(value[1]) != -1) {
//                    DBG_INFO("User remove the device which is playing now!");
//                    try {
//                        HiFileBrowser.RefreshUSBdata(value[0], value[1]);
//                    } catch (e) {
//                    }
//                    setTimeout(function () {
//                        HiVideoPlayer.closeVideoPlayer(1);
//                    }, 500);
//
//
//                }
//
//            }
//        }
//        if (hiWebOsFrame.getCurrentPage().id == "himedia_musicPlayer") {
//            if (value[0] == "offline") {
//                if (!!HiFileBrowser.latestUsbId && HiFileBrowser.latestUsbId.indexOf(value[1]) != -1) {
//                    DBG_INFO("User remove the device which is playing now!");
//                    try {
//                        HiFileBrowser.RefreshUSBdata(value[0], value[1]);
//                    } catch (e) {
//                    }
//                    setTimeout(function () {
//                        HiAudioPlayer.closeAudioPlayer(1);
//                    }, 500);
//
//
//                }
//
//            }
//        }
//        if (hiWebOsFrame.getCurrentPage().id == "himedia_picPlayer") {
//            if (value[0] == "offline") {
//                if (!!HiFileBrowser.latestUsbId && HiFileBrowser.latestUsbId.indexOf(value[1]) != -1) {
//                    DBG_INFO("User remove the device which is playing now!");
//                    try {
//                        HiFileBrowser.RefreshUSBdata(value[0], value[1]);
//                    } catch (e) {
//                    }
//                    setTimeout(function () {
//                        HiPicPlayer.closePicPlayer(1)
//                    }, 500);
//
//
//                }
//
//            }
//        }

    }

    //处理断网信息（目前主要用于DMP设备的显示与播放）
    function onNetworkChanged(value) {
        var deviceBrowser = UI.getSubModule("deviceBrowser");
        DBG_INFO("[onNetworkChanged] value is :  " + value + "hiMedia.currentDevice = "
            + hiMedia.currentDevice + "deviceBrowser.currentState = " + deviceBrowser.currentState);
        if (value == 0 && deviceBrowser.currentState == hiMedia.DEVICE_DLNA_PAGE) {
            //模拟成DMP设备下线处理
            var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
            switch (currentSubModel) {
                case "videoPlayer":
                case "musicPlayer":
                case "picPlayer":
                case "fileBrowser":
                    //if (!!hiMedia.curVolumeId && hiMedia.curVolumeId.indexOf(value[1]) != -1) {
                    clearTimeout(usbTimeOut);
                    usbTimeOut = setTimeout(function () {
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        UI.popSubModule();
                        deviceBrowser.visible = 1;
                        hiMedia.devceBrowserEnable = true;
                        deviceBrowser.onkey_BACKSPACE();
                        //deviceBrowser.RefreshUSBData(value[0], value[1]);

                        UI.updateStage();
                    }, 500);
                    //}
                    break;
                case "deviceBrowser":
                    DBG_INFO("deviceBrowser.onkey_BACKSPACE();");
                    var deviceBrowser = UI.getSubModule("deviceBrowser");
                    deviceBrowser.onkey_BACKSPACE();
                    break;

            }
        }
    }

    //处理耳机插拔消息
    function onHeadPhoneChanged(value) {

        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        DBG_INFO("[onHeadPhoneChanged]currentSubModel = " + currentSubModel + "value = " + value);
        switch (currentSubModel) {
            case "videoPlayer":
                var videoPlayer = UI.getCurrSubModule();
                var videoPlayerMenu = UI.getItem(videoPlayer, "videoPlayerMenu");
                if (!!videoPlayerMenu.visible) {
                    videoPlayer.closeMenu("key_menu");
                }
                break;
            case "musicPlayer":
                var musicPlayer = UI.getCurrSubModule();
                var musicPlayerMenu = UI.getItem(musicPlayer, "musicPlayerMenu");
                if (!!musicPlayerMenu.visible) {
                    musicPlayer.closeMenu("key_menu");
                }
                break;

        }
    }


    var onUSBIteratorEvent = function (param, event) {
        DBG_INFO("onUSBIteratorEvent and path is : " + param[0]);
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            function readUsbTable() {
                // DBG_ALWAYS("file Time:" + event.row[0][3] + "   file Path:" + event.row[0][4]);
                for (var i = 0; i < event.rows.length; i++) {
                    var tempType = event.rows[i][0];
                    var tempName = event.rows[i][2];
                    var tempPath = event.rows[i][1];
                    var tempTime = event.rows[i][3];
                    var tempSize = event.rows[i][4];
                    DBG_ALWAYS("tempTime:" + tempTime + " Name:" + tempName);
                    if(!hiMedia.searchMode) {
                        if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_FOLDER) {
                            hiMedia.fileBrowserFileData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "file", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_PHOTO) {
                            hiMedia.fileBrowserPicData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "pic", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                            hiMedia.fileBrowserMusicData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "music", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                            hiMedia.fileBrowserVideoData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "video", fileSelect: 0,fileSize:tempSize});}
                        //TODO size
                    }else{
                        if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_FOLDER) {
                            hiMedia.fileBrowserSearchedFileData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "file", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_PHOTO) {
                            hiMedia.fileBrowserSearchedPicData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "pic", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                            hiMedia.fileBrowserSearchedMusicData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "music", fileSelect: 0,fileSize:tempSize});
                        } else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                            hiMedia.fileBrowserSearchedVideoData.push({deviceId: param[0], filePath: tempPath,
                                fileName: tempName, fileTime: tempTime, fileType: "video", fileSelect: 0,fileSize:tempSize});}
                        //TODO size
                    }
                }
                if (!hiMedia.searchMode) {
                    hiMedia.fileBrowserFileData = orderHiFileData(hiMedia.fileBrowserFileData);
                    hiMedia.fileBrowserPicData = orderHiFileData(hiMedia.fileBrowserPicData);
                    hiMedia.fileBrowserMusicData = orderHiFileData(hiMedia.fileBrowserMusicData);
                    hiMedia.fileBrowserVideoData = orderHiFileData(hiMedia.fileBrowserVideoData);
                } else {
                    hiMedia.fileBrowserSearchedFileData = orderHiFileData(hiMedia.fileBrowserSearchedFileData);
                    hiMedia.fileBrowserSearchedPicData = orderHiFileData(hiMedia.fileBrowserSearchedPicData);
                    hiMedia.fileBrowserSearchedMusicData = orderHiFileData(hiMedia.fileBrowserSearchedMusicData);
                    hiMedia.fileBrowserSearchedVideoData = orderHiFileData(hiMedia.fileBrowserSearchedVideoData);
                }
                //对PVR进行排序
//                if (HiFileBrowser.files["pvr"].length > 1) {
//                    HiFileBrowser.files["pvr"].sort(function (a, b) {
//                        DBG_INFO("a.usbFileName    " + a.usbFileName.split(".pvr")[0].replace("_", "") + "    b.usbFileName   " + b.usbFileName.split(".pvr")[0].replace("_", ""));
//                        return (b.usbFileName.split(".pvr")[0].replace("_", "") - a.usbFileName.split(".pvr")[0].replace("_", ""));
//                    });
//                }
            }


            if (UsbTableReadStatus == 0 || UsbTableReadStatus == 4) {
                hiMedia.fileBrowserAllData = [];
                if (event.rows.length > 0) {
                    readUsbTable();
                }
                if (UsbTableReadStatus == 4) {
                    UsbTableReadStatus = 2;
                }
            }
            else if (UsbTableReadStatus == 1 || UsbTableReadStatus == 3) {
                readUsbTable();
                if (UsbTableReadStatus == 3) {
                    UsbTableReadStatus = 2;
                }
            }
            if (UsbTableReadStatus == 2) {
                UsbTableReadStatus = 0;
                UsbCount = 0;
                UsbTableReadCnt = 0;
                UsbTableReadCnt_plus = 0;
                if (hiMedia.searchMode) {
                    hiMedia.fileBrowserSearchedAllData =
                        hiMedia.fileBrowserSearchedVideoData.concat(hiMedia.fileBrowserSearchedMusicData).
                            concat(hiMedia.fileBrowserSearchedPicData);
                } else {
                    hiMedia.curFilePath = param[1];
                    hiMedia.curVolumeId = param[0];
                    //PVR需要单独处理

                    hiMedia.fileBrowserAllData =
                        hiMedia.fileBrowserAllData.concat(hiMedia.fileBrowserFileData).
                            concat(hiMedia.fileBrowserVideoData).concat(hiMedia.fileBrowserMusicData).
                            concat(hiMedia.fileBrowserPicData);
                }

                //endLoading  and create or refresh fileBrowser.0218
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        // deviceBrowser.visible = false;
                        hiMedia.needRefreshFB = true;
                        hiMedia.currentDevice = hiMedia.device.usb;
                        UI.pushSubModule("hiMedia", "fileBrowser", true);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        var fileBrowserListContainer = UI.getItem(fileBrowser, "fileBrowserListContainer");
                        var FBSearchInput = UI.getItem(fileBrowser, "FBSearchInput");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.listMode = " + fileBrowser.listMode);

                        if (!fileBrowser.listMode) {
                            if (!hiMedia.searchMode) {
                                switch (fileBrowser.currClassify) {
                                    case hiMedia.fileType.all:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
//                                fileBrowser.currentSortType = "time";
//                                UI.setText(fileBrowserSortType, "[DMP0139]");
                                        break;
                                    case hiMedia.fileType.pic:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData), true);
//                                fileBrowser.currentSortType = "time";
//                                UI.setText(fileBrowserSortType, "[DMP0139]");
                                        break;
                                    case hiMedia.fileType.music:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData), true);
//                                fileBrowser.currentSortType = "time";
//                                UI.setText(fileBrowserSortType, "[DMP0139]");
                                        break;
                                    case hiMedia.fileType.video:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData), true);
//                                fileBrowser.currentSortType = "time";
//                                UI.setText(fileBrowserSortType, "[DMP0139]");
                                        break;
                                    default :
                                        break;
                                }
                            }
                            else {
                                var FBSearchInputTip = UI.getItem(fileBrowser, "FBSearchInputTip");
                                var FBSearchInput = UI.getItem(fileBrowser, "FBSearchInput");
                                switch (fileBrowser.currClassify) {
                                    case hiMedia.fileType.all:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedAllData, true);
                                        if (hiMedia.fileBrowserSearchedAllData.length > 0) {
                                            FBSearchInputTip.alpha = 0;
                                            FBSearchInput.onNormal();
                                        } else {
                                            FBSearchInputTip.alpha = 1;
                                            fileBrowser.changeDeviceName();
                                            UI.focusTo(FBSearchInput);
                                        }
                                        break;
                                    case hiMedia.fileType.pic:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedPicData, true);
                                        if (hiMedia.fileBrowserSearchedPicData.length > 0) {
                                            FBSearchInputTip.alpha = 0;
                                            FBSearchInput.onNormal();
                                        } else {
                                            FBSearchInputTip.alpha = 1;
                                            fileBrowser.changeDeviceName();
                                            UI.focusTo(FBSearchInput);
                                        }
                                        break;
                                    case hiMedia.fileType.music:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedMusicData, true);
                                        if (hiMedia.fileBrowserSearchedMusicData.length > 0) {
                                            FBSearchInputTip.alpha = 0;
                                            FBSearchInput.onNormal();
                                        } else {
                                            FBSearchInputTip.alpha = 1;
                                            fileBrowser.changeDeviceName();
                                            UI.focusTo(FBSearchInput);
                                        }
                                        break;
                                    case hiMedia.fileType.video:
                                        fileBrowserList.removeAllChildren();
                                        fileBrowser.createFileList(hiMedia.fileBrowserSearchedVideoData, true);
                                        if (hiMedia.fileBrowserSearchedVideocData.length == 0) {
                                            FBSearchInputTip.alpha = 0;
                                            FBSearchInput.onNormal();
                                        } else {
                                            FBSearchInputTip.alpha = 1;
                                            fileBrowser.changeDeviceName();
                                            UI.focusTo(FBSearchInput);
                                        }
                                        break;
                                    default :
                                        break;
                                }

                                hiMedia.endLoading("showUsbDetail");
                                return;
                            }
                        }
                        else {
                            //list Mode.
                            switch (fileBrowser.currClassify) {
                                case hiMedia.fileType.all:
                                    // not support in listMode
                                    //fileBrowserList.removeAllChildren();
                                    //fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                                    break;
                                case hiMedia.fileType.pic:
                                    for (var i = 0; i < hiMedia.fileBrowserPicData.length; i++) {
                                        if (hiMedia.fileBrowserPicData[i].fileSelect == 0) {
                                            fileBrowser.allPic[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    //fileBrowser.selectedPicStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserPicData);
                                    fileBrowser.createFileList(fileBrowser.allPic.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserPicData), true);
                                    break;
                                case hiMedia.fileType.music:
                                    for (var i = 0; i < hiMedia.fileBrowserMusicData.length; i++) {
                                        if (hiMedia.fileBrowserMusicData[i].fileSelect == 0) {
                                            fileBrowser.allMusic[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    //fileBrowser.selectedPicStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserPicData);
                                    fileBrowser.createFileList(fileBrowser.allMusic.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserMusicData), true);
                                    break;
                                case hiMedia.fileType.video:
                                    for (var i = 0; i < hiMedia.fileBrowserVideoData.length; i++) {
                                        if (hiMedia.fileBrowserVideoData[i].fileSelect == 0) {
                                            fileBrowser.allVideo[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(fileBrowser.allVideo.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserVideoData), true);
                                    break;
                                /*
                                 case hiMedia.fileType.search:
                                 fileBrowserList.removeAllChildren();
                                 fileBrowser.createFileList(hiMedia.fileBrowserAllData, true, 0, 560);
                                 fileBrowserListContainer.y = 300;
                                 //                                fileBrowser.currentSortType = "time";
                                 //                                UI.setText(fileBrowserSortType, "[DMP0139]");
                                 break;
                                 */
                                default :
                                    break;
                            }
                        }
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
                try {
                    DBG_INFO("disconnet!");
                    m_usbIterator.disconnect();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                setTimeout(function () {
                    UI.updateStage();
                }, 200);
            }
            if (UsbTableReadCnt > 0) {
                DBG_INFO(UsbTableReadCnt + "_______" + UsbCount);
                UsbTableReadCnt--;
                UsbTableReadCnt_plus++;
                UsbTableReadStatus = 1;
                if (UsbTableReadCnt == 0) {
                    UsbTableReadStatus = 3;
                }

                m_usbIterator.seekToRow(table_read_once * UsbTableReadCnt_plus, TableIterator.SEEK_SET);
                if (UsbTableReadCnt != 0 || (UsbCount % table_read_once == 0))
                    m_usbIterator.readNextRows(table_read_once);
                else
                    m_usbIterator.readNextRows(UsbCount % table_read_once);
            }

        }


        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {

            UsbCount = event.totalCount;
            DBG_INFO("FETCH TOTAL CONT ______________________________" + UsbCount);
            if (UsbCount > 0) {
                if (UsbCount > 500) {
                    UsbCount = 500;
                }
                if (UsbCount > table_read_once) {
                    UsbTableReadStatus = 0;
                    if (UsbCount % table_read_once == 0) {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once) - 1;
                    }
                    else {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once);
                    }
                    m_usbIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_usbIterator.readNextRows(table_read_once);
                }
                else {
                    UsbTableReadStatus = 4;
                    m_usbIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_usbIterator.readNextRows(UsbCount);
                }
            }
            else if (UsbCount == 0) {
                // hiMedia.endLoading("showUsbDetail");
                //没有资源时进入无资源的状态。分第一次进入以及打开无文件文件夹。leftover
                UsbTableReadStatus = 0;
                UsbCount = 0;
                UsbTableReadCnt = 0;
                UsbTableReadCnt_plus = 0;
                hiMedia.curFilePath = param[1];
                hiMedia.curVolumeId = param[0];
                //PVR需要单独处理
                if (hiMedia.searchMode) {
                    hiMedia.fileBrowserSearchedAllData = hiMedia.fileBrowserSearchedFileData
                        = hiMedia.fileBrowserSearchedVideoData = hiMedia.fileBrowserSearchedMusicData
                        = hiMedia.fileBrowserSearchedPicData = [];
                } else {
                    hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData
                        = hiMedia.fileBrowserVideoData = hiMedia.fileBrowserMusicData
                        = hiMedia.fileBrowserPicData = [];
                }
                //endLoading  and create or refresh fileBrowser.0218
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "")
                DBG_INFO("FETCH TOTAL CONT=0 currentSubModel  =" + currentSubModel);
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        //  deviceBrowser.visible = false;
                        hiMedia.needRefreshFB = true;
                        hiMedia.currentDevice = hiMedia.device.usb;
                        UI.pushSubModule("hiMedia", "fileBrowser", true);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        var FBSearchInputTip = UI.getItem(fileBrowser, "FBSearchInputTip");
                        var FBSearchInput = UI.getItem(fileBrowser, "FBSearchInput");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);
                        fileBrowserList.removeAllChildren();
                        if (hiMedia.searchMode) {
                            FBSearchInputTip.alpha = 1;
                            UI.removeScrollbar(fileBrowserList);
                            UI.focusTo(FBSearchInput);
                            DBG_ERROR("No matching file is found.");
                            hiMedia.endLoading("showUsbDetail");

                            return;
                        }
                        if (fileBrowser.listMode) {
                            var headerItem = [];
                            switch (fileBrowser.currClassify) {
                                case hiMedia.fileType.pic:
                                    headerItem = fileBrowser.allPic;
                                    break;
                                case hiMedia.fileType.music:
                                    headerItem = fileBrowser.allMusic;
                                    break;
                                case hiMedia.fileType.video:
                                    headerItem = fileBrowser.allVideo;
                                    break;
                                default:
                                    DBG_ERROR("list mode, error type.");
                                    break;
                            }
                            fileBrowser.createFileList(headerItem, true);
                        } else {
                            fileBrowser.createFileList([], true);
                        }
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
                try {
                    DBG_INFO("disconnet!");
                    m_usbIterator.disconnect();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            } else {

            }


        }
        else if (event.type == TableIterator.EVENT_TYPE_SEEK_TO_ROW) {
            DBG_INFO('seek to row index = ' + event.result);
            // m_usbIterator.readNextRows(HiFileBrowser.table_read_once);
        }
        else {
            DBG_INFO("other Type________________" + event.type);
            try {
                m_usbIterator.disconnect();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        //m_directoryIterator.readNextRows(90);

    };
    var m_usbIterator = null;
    //增加PVR读取
    var onPVRIteratorEvent = function (path, event) {
        DBG_INFO("onPVRIteratorEvent and path is : " + path);
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            function readUsbTable() {

                for (var i = 0; i < event.rows.length; i++) {
                    //DBG_INFO("onPVRIteratorEvent and path is : " + event.rows[i]);
                    var tempType = event.rows[i][1];
                    var tempName = event.rows[i][0];
                    var tempTime = event.rows[i][3];
                    var tempPath = event.rows[i][4];
                    //DBG_ALWAYS(" Name:" + tempName + " tempTime:" + tempTime);
                    if (tempType == 0) {
                        hiMedia.fileBrowserFileData.push({
                            deviceId: path,
                            filePath: path + tempName + "/",
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "file",
                            fileSelect: 0
                        });
                    }
                    else if (tempType == 1) {
                        hiMedia.fileBrowserPicData.push({
                            deviceId: path,
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "pic",
                            fileSelect: 0
                        });
                    }
                    else if (tempType == 3) {
                        hiMedia.fileBrowserMusicData.push({
                            deviceId: path,
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "music",
                            fileSelect: 0
                        });
                    }
                    else if (tempType == 2) {
                        hiMedia.fileBrowserVideoData.push({
                            deviceId: path,
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "video",
                            fileSelect: 0
                        });
                    }
                    else if (tempType == 4) {
                        //pvr处理
                        hiMedia.fileBrowserVideoData.push({
                            deviceId: path,
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "video",
                            fileSelect: 0
                        });
                    }

                }
                hiMedia.fileBrowserFileData = orderHiFileData(hiMedia.fileBrowserFileData);
                hiMedia.fileBrowserPicData = orderHiFileData(hiMedia.fileBrowserPicData);
                hiMedia.fileBrowserMusicData = orderHiFileData(hiMedia.fileBrowserMusicData);
                hiMedia.fileBrowserVideoData = orderHiFileData(hiMedia.fileBrowserVideoData);
                //对PVR进行排序
//                if (HiFileBrowser.files["pvr"].length > 1) {
//                    HiFileBrowser.files["pvr"].sort(function (a, b) {
//                        DBG_INFO("a.usbFileName    " + a.usbFileName.split(".pvr")[0].replace("_", "") + "    b.usbFileName   " + b.usbFileName.split(".pvr")[0].replace("_", ""));
//                        return (b.usbFileName.split(".pvr")[0].replace("_", "") - a.usbFileName.split(".pvr")[0].replace("_", ""));
//                    });
//                }
            }


            if (UsbTableReadStatus == 0 || UsbTableReadStatus == 4) {
                hiMedia.fileBrowserAllData = [];
                if (event.rows.length > 0) {
                    readUsbTable();
                }
                if (UsbTableReadStatus == 4) {
                    UsbTableReadStatus = 2;
                }
            }
            else if (UsbTableReadStatus == 1 || UsbTableReadStatus == 3) {
                readUsbTable();
                if (UsbTableReadStatus == 3) {
                    UsbTableReadStatus = 2;
                }
            }
            if (UsbTableReadStatus == 2) {
                UsbTableReadStatus = 0;
                UsbCount = 0;
                UsbTableReadCnt = 0;
                UsbTableReadCnt_plus = 0;
                hiMedia.curFilePath = path;
                //PVR需要单独处理

                hiMedia.fileBrowserAllData =
                    hiMedia.fileBrowserAllData.concat(hiMedia.fileBrowserFileData).
                        concat(hiMedia.fileBrowserVideoData).concat(hiMedia.fileBrowserMusicData).
                        concat(hiMedia.fileBrowserPicData);

                //endLoading  and create or refresh fileBrowser.0218
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "")
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        // deviceBrowser.visible = false;
                        hiMedia.needRefreshFB = true;
                        hiMedia.currentDevice = hiMedia.device.pvr;
                        UI.pushSubModule("hiMedia", "fileBrowser", true);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        var fileBrowserListContainer = UI.getItem(fileBrowser, "fileBrowserListContainer");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);

                        switch (fileBrowser.currClassify) {
                            case hiMedia.fileType.all:
                                fileBrowserList.removeAllChildren();
                                fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                                break;
                            case hiMedia.fileType.pic:
                                fileBrowserList.removeAllChildren();
                                fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData), true);
                                break;
                            case hiMedia.fileType.music:
                                fileBrowserList.removeAllChildren();
                                fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData), true);
                                break;
                            case hiMedia.fileType.video:
                                fileBrowserList.removeAllChildren();
                                fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData), true);
                                break;
                            /*
                             case hiMedia.fileType.search:
                             fileBrowser.createFileList(hiMedia.fileBrowserAllData, true, 0, 560);
                             setTimeout(function () {
                             //DBG_ERROR("300!!!!!!!!!!!!!!!!!");
                             fileBrowserListContainer.y = 300;
                             }, 1000);

                             break;
                             */
                            default :
                                break;
                        }
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
                try {
                    m_pvrIterator.disconnect();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
            if (UsbTableReadCnt > 0) {
                DBG_INFO(UsbTableReadCnt + "_______" + UsbCount);
                UsbTableReadCnt--;
                UsbTableReadCnt_plus++;
                UsbTableReadStatus = 1;
                if (UsbTableReadCnt == 0) {
                    UsbTableReadStatus = 3;
                }

                m_pvrIterator.seekToRow(table_read_once * UsbTableReadCnt_plus, TableIterator.SEEK_SET);
                if (UsbTableReadCnt != 0 || (UsbCount % table_read_once == 0))
                    m_pvrIterator.readNextRows(table_read_once);
                else
                    m_pvrIterator.readNextRows(UsbCount % table_read_once);
            }

        }


        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {

            UsbCount = event.totalCount;
            DBG_INFO("FETCH TOTAL CONT ______________________________" + UsbCount);
            if (UsbCount > 0) {
                if (UsbCount > 500) {
                    UsbCount = 500;
                }
                if (UsbCount > table_read_once) {
                    UsbTableReadStatus = 0;
                    if (UsbCount % table_read_once == 0) {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once) - 1;
                    }
                    else {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once);
                    }
                    m_pvrIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_pvrIterator.readNextRows(table_read_once);
                }
                else {
                    UsbTableReadStatus = 4;
                    m_pvrIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_pvrIterator.readNextRows(UsbCount);
                }
            }
            else {
                // hiMedia.endLoading("showUsbDetail");
                //没有资源时进入无资源的状态。分第一次进入以及打开无文件文件夹。leftover
                UsbTableReadStatus = 0;
                UsbCount = 0;
                UsbTableReadCnt = 0;
                UsbTableReadCnt_plus = 0;
                hiMedia.curFilePath = path;
                //PVR需要单独处理

                hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData
                    = hiMedia.fileBrowserVideoData = hiMedia.fileBrowserMusicData
                    = hiMedia.fileBrowserPicData = [];
                //endLoading  and create or refresh fileBrowser.0218
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "")
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        //  deviceBrowser.visible = false;
                        hiMedia.needRefreshFB = true;
                        hiMedia.currentDevice = hiMedia.device.pvr;
                        UI.pushSubModule("hiMedia", "fileBrowser", true);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);
                        fileBrowserList.removeAllChildren();
                        fileBrowser.createFileList([], true);
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
                try {
                    m_pvrIterator.disconnect();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }


        }
        else if (event.type == TableIterator.EVENT_TYPE_SEEK_TO_ROW) {
            DBG_INFO('seek to row index = ' + event.result);
            // m_usbIterator.readNextRows(HiFileBrowser.table_read_once);
        }
        else {
            DBG_INFO("other Type________________" + event.type);
            try {
                m_pvrIterator.disconnect();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        //m_directoryIterator.readNextRows(90);

    };

    hiMedia.showUsbDetail = function (id, path, keyword) {
        //startLoading!!
        //path = "/mnt/usb/sda1";
        try {
            clearTimeout(usbTimeOut);//MSD6586EU-7930
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        DBG_INFO("id is " + id + "path is :" + path + "   keyword is : " + keyword);
        if (!keyword) {
            hiMedia.startLoading("showUsbDetail", 30);
        }
        if (hiMedia.searchMode) {
            hiMedia.fileBrowserSearchedAllData = [];
            hiMedia.fileBrowserSearchedFileData = [];
            hiMedia.fileBrowserSearchedVideoData = [];
            hiMedia.fileBrowserSearchedMusicData = [];
            hiMedia.fileBrowserSearchedPicData = [];
        } else {
            hiMedia.fileBrowserAllData = [];
            hiMedia.fileBrowserFileData = [];
            hiMedia.fileBrowserVideoData = [];
            hiMedia.fileBrowserMusicData = [];
            hiMedia.fileBrowserPicData = [];
        }
        var fileCondition = [
            {
                field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_VOLUME_ID,
                condition: Model.FIELD_COND_EQUAL,
                value: id
            },
            {
                field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_ANCESTOR,
                condition: Model.FIELD_COND_EQUAL,
                value: path
            },
            {
                field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE,
                condition: Model.FIELD_COND_EQUAL,
                value: 92//all = 4+8+16+64
            }
        ];
        var fileResult = [
            DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE, /**< item type (e.g. tv_launcher, video, ...), see #ENUM_SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE for different values */
            DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_LOCATOR, /**< item URL */
            DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_CAPTION, /**< add item name (no postfix type) */
            DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_DATE_NUMERIC,
            DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_FILE_SIZE
//            UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_FILE_MOD_TIME,
//            UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_FILE_URL

        ];
        if (!!keyword) {
            fileCondition = [

                {
                    field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_VOLUME_ID,
                    condition: Model.FIELD_COND_EQUAL,
                    value: id
                },
                {
                    field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_ANCESTOR,
                    condition: Model.FIELD_COND_EQUAL,
                    value: path
                },
                {
                    field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE,
                    condition: Model.FIELD_COND_EQUAL,
                    value: 28//all = 4+8+16+64
                },
                {
                    field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_SEARCH_KEYWORD,
                    condition: Model.FIELD_COND_EQUAL,
                    value: keyword
                }
            ];

        }
        try {
            m_usbIterator = new TableIterator(
                model.directory.createDirectoryIterator,
                true,
                fileCondition,
                fileResult,
                [
                    {field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_CAPTION, direction: 1}
                ],
                onUSBIteratorEvent.bind(this, [id, path]));
        }
        catch (ex) {
            DBG_ERROR("model.usb.creatUSBTableMainIterator Error" + ex.message);
        }
        m_usbIterator.fetchTotalCount();


    }
    var m_pvrIterator = null;
    hiMedia.showPvrDetail = function (path) {
        DBG_INFO("PATH IS :" + path);
        hiMedia.startLoading("showUsbDetail", 30);
        hiMedia.fileBrowserAllData = [];
        hiMedia.fileBrowserFileData = [];
        hiMedia.fileBrowserVideoData = [];
        hiMedia.fileBrowserMusicData = [];
        hiMedia.fileBrowserPicData = [];
        var fileCondition = [

            {
                field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH,
                condition: Model.FIELD_COND_EQUAL,
                value: path
            },
            {
                field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_TYPE,
                condition: Model.FIELD_COND_EQUAL,
                value: UsbModelDefines.SL2_TVAPI_USB_FILE_TYPE_PVR
            }
        ];

        try {
            m_pvrIterator = new TableIterator(
                model.usb.creatUSBTableMainIterator,
                true, fileCondition
                ,
                [
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH, /**< ancestor */
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_TYPE, /**< item name */
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_ISDIR,
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_FILE_MOD_TIME,
                    UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_FILE_URL

                ],
                [
                    {field: UsbModelDefines.SL2_TVAPI_USB_TABLE_FIELD_PATH, direction: 1}
                ],
                onPVRIteratorEvent.bind(this, path));
        }
        catch (ex) {
            DBG_ERROR("model.usb.creatPVRTableMainIterator Error" + ex.message);
        }
        m_pvrIterator.fetchTotalCount();


    }


    //DMP设备读取
    var m_directoryIterator = null;

    hiMedia.showDmpDetail = function (id, path, type, isReturn) {
        //列出文件夹
        //startLoading!!
        hiMedia.startLoading("showDmpDetail", 15);
        hiMedia.fileBrowserAllData = [];
        hiMedia.fileBrowserFileData = [];
        hiMedia.fileBrowserVideoData = [];
        hiMedia.fileBrowserMusicData = [];
        hiMedia.fileBrowserPicData = [];
//        HiFileBrowser.currentUsbId = id;
//        HiFileBrowser.latestUsbId = id;
        if (!isReturn) {
            isReturn = false;
        }
        var param = [id, path, isReturn];
        try {
            m_directoryIterator = new TableIterator(
                model.directory.createDirectoryIterator,
                true,
                [
                    {
                        field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_VOLUME_ID,
                        condition: Model.FIELD_COND_EQUAL,
                        value: id
                    },
                    {
                        field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_ANCESTOR,
                        condition: Model.FIELD_COND_EQUAL,
                        value: path
                    },
                    {
                        field: DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE,
                        condition: Model.FIELD_COND_EQUAL,
                        value: type//all = 4+8+16+64
                    }
                ],
                [
                    DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_ANCESTOR, /**< ancestor */
                    DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TITLE, /**< item name */
                    DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE, /**< item type (e.g. tv_launcher, video, ...), see #ENUM_SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE for different values */
                    DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_LOCATOR, /**< item URL */
                    DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_FILE_SIZE/**< item URL */
                ],
                [
                    {}
                ],
                onDirectoryIteratorEvent.bind(this, param));
        }
        catch (e) {
            DBG_ERROR("model.directory.createDirectoryIterator  error" + e.message);
        }
        m_directoryIterator.fetchTotalCount();
        UsbTableReadStatus = 0;
        UsbCount = 0;
        UsbTableReadCnt = 0;
        UsbTableReadCnt_plus = 0;


    }


    var onDirectoryIteratorEvent = function (param, event) {
        ////hide("dropboxloading");
        DBG_INFO("onDirectoryIteratorEvent_begin");
        // var usbDetail=[];
        if (event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            function readUsbTable() {
                DBG_INFO("readUsbTable");
                for (var i = 0; i < event.rows.length; i++) {
                    var tempType = event.rows[i][2];
                    var tempName = event.rows[i][1];
                    var tempPath = event.rows[i][3];
                    var tempTime = event.rows[i][4];
                    DBG_INFO("readUsbTable______________" + event.rows[i]);
                    if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_FOLDER) {
                        hiMedia.fileBrowserFileData.push({
                            deviceId: param[0],
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "file",
                            fileSelect: 0
                        });

                    }
                    else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_PHOTO) {
                        hiMedia.fileBrowserPicData.push({
                            deviceId: param[0],
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "pic",
                            fileSelect: 0,
                            Rotate:0
                        });
                    }
                    else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_AUDIO) {
                        hiMedia.fileBrowserMusicData.push({
                            deviceId: param[0],
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "music",
                            fileSelect: 0
                        });
                    }
                    else if (tempType == DirectoryModelDefines.SL2_TVAPI_TABLE_DIRECTORY_FIELD_TYPE_VIDEO) {
                        hiMedia.fileBrowserVideoData.push({
                            deviceId: param[0],
                            filePath: tempPath,
                            fileName: tempName,
                            fileTime: tempTime,
                            fileType: "video",
                            fileSelect: 0
                        });
                    }

                }
                hiMedia.fileBrowserFileData = orderHiFileData(hiMedia.fileBrowserFileData);
                hiMedia.fileBrowserPicData = orderHiFileData(hiMedia.fileBrowserPicData);
                hiMedia.fileBrowserMusicData = orderHiFileData(hiMedia.fileBrowserMusicData);
                hiMedia.fileBrowserVideoData = orderHiFileData(hiMedia.fileBrowserVideoData);
            }

            DBG_INFO("UsbTableReadStatus = " + UsbTableReadStatus);
            if (UsbTableReadStatus == 0 || UsbTableReadStatus == 4) {
                hiMedia.fileBrowserAllData = [];
                if (event.rows.length > 0) {
                    DBG_INFO("event.rows.length = " + event.rows.length);
                    readUsbTable();
                }
//                    chl_g_channelList.push(channelList);
                if (UsbTableReadStatus == 4) {
                    UsbTableReadStatus = 2;
                }
            }
            else if (UsbTableReadStatus == 1 || UsbTableReadStatus == 3) {
                readUsbTable();
                if (UsbTableReadStatus == 3) {
                    UsbTableReadStatus = 2;
                }
            }
            if (UsbTableReadStatus == 2) {
                hiMedia.curFilePath = param[1];
                hiMedia.curVolumeId = param[0];
                hiMedia.fileBrowserAllData = hiMedia.fileBrowserAllData.concat(hiMedia.fileBrowserFileData).
                    concat(hiMedia.fileBrowserVideoData).concat(hiMedia.fileBrowserMusicData).concat(hiMedia.fileBrowserPicData);

                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "")
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        // deviceBrowser.visible = false;

                        hiMedia.needRefreshFB = true;
                        hiMedia.currentDevice = hiMedia.device.dms;
                        UI.pushSubModule("hiMedia", "fileBrowser", true);
                        hiMedia.endLoading("showDmpDetail");
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);

                        if (!fileBrowser.listMode) {
                            switch (fileBrowser.currClassify) {
                                case hiMedia.fileType.all:
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                                    break;
                                case hiMedia.fileType.pic:
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserPicData), true);
                                    break;
                                case hiMedia.fileType.music:
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserMusicData), true);
                                    break;
                                case hiMedia.fileType.video:
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(hiMedia.fileBrowserFileData.concat(hiMedia.fileBrowserVideoData), true);
                                    break;
                                default :
                                    break;
                            }
                        } else {
                            //list Mode.
                            switch (fileBrowser.currClassify) {
                                case hiMedia.fileType.all:
                                    // not support in listMode
                                    //fileBrowserList.removeAllChildren();
                                    //fileBrowser.createFileList(hiMedia.fileBrowserAllData, true);
                                    break;
                                case hiMedia.fileType.pic:
                                    for (var i = 0; i < hiMedia.fileBrowserPicData.length; i++) {
                                        if (hiMedia.fileBrowserPicData[i].fileSelect == 0) {
                                            fileBrowser.allPic[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    //fileBrowser.selectedPicStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserPicData);
                                    fileBrowser.createFileList(fileBrowser.allPic.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserPicData), true);
                                    break;
                                case hiMedia.fileType.music:
                                    for (var i = 0; i < hiMedia.fileBrowserMusicData.length; i++) {
                                        if (hiMedia.fileBrowserMusicData[i].fileSelect == 0) {
                                            fileBrowser.allMusic[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    //fileBrowser.selectedPicStack[hiMedia.curFilePath] = [].concat(hiMedia.fileBrowserPicData);
                                    fileBrowser.createFileList(fileBrowser.allMusic.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserMusicData), true);
                                    break;
                                case hiMedia.fileType.video:
                                    for (var i = 0; i < hiMedia.fileBrowserVideoData.length; i++) {
                                        if (hiMedia.fileBrowserVideoData[i].fileSelect == 0) {
                                            fileBrowser.allVideo[0].fileSelect = 0;
                                        }
                                    }
                                    fileBrowserList.removeAllChildren();
                                    fileBrowser.createFileList(fileBrowser.allVideo.concat(hiMedia.fileBrowserFileData)
                                        .concat(hiMedia.fileBrowserVideoData), true);
                                    break;
                                /*
                                 case hiMedia.fileType.search:
                                 fileBrowserList.removeAllChildren();
                                 fileBrowser.createFileList(hiMedia.fileBrowserAllData, true, 0, 560);
                                 fileBrowserListContainer.y = 300;
                                 break;
                                 */
                                default :
                                    break;
                            }
                        }
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showDmpDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
                if (!!param[2]) {
                    //leftover重置焦点
                    // HiFileBrowser.resumeFocus();
                }
                try {
                    m_directoryIterator.disconnect();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                setTimeout(function () {
                    UI.updateStage();
                }, 200);
            }
            if (UsbTableReadCnt > 0) {
                DBG_INFO(UsbTableReadCnt + "_______" + UsbCount);
                UsbTableReadCnt--;
                UsbTableReadCnt_plus++;
                UsbTableReadStatus = 1;
                if (UsbTableReadCnt == 0) {
                    UsbTableReadStatus = 3;
                }

                m_directoryIterator.seekToRow(table_read_once * UsbTableReadCnt_plus, TableIterator.SEEK_SET);
                if (UsbTableReadCnt != 0 || (UsbCount % table_read_once == 0))
                    m_directoryIterator.readNextRows(table_read_once);
                else
                    m_directoryIterator.readNextRows(UsbCount % table_read_once);
            }

        }


        else if (event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {

            UsbCount = event.totalCount;
            DBG_INFO("UsbCount" + UsbCount);
            if (UsbCount > 0) {
                if (UsbCount > 500) {
                    UsbCount = 500;
                }
                if (UsbCount > table_read_once) {
                    UsbTableReadStatus = 0;
                    if (UsbCount % table_read_once == 0) {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once) - 1;
                    }
                    else {
                        UsbTableReadCnt = Math.floor(UsbCount / table_read_once);
                    }
                    m_directoryIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_directoryIterator.readNextRows(table_read_once);

                }
                else {
                    UsbTableReadStatus = 4;

                    m_directoryIterator.seekToRow(0, TableIterator.SEEK_SET);
                    m_directoryIterator.readNextRows(UsbCount);
                }
            }

            else {
                //没有资源时直接进入。
                UsbTableReadStatus = 0;
                UsbCount = 0;
                UsbTableReadCnt = 0;
                UsbTableReadCnt_plus = 0;
                hiMedia.endLoading("showDmpDetail");
                //没有资源的处理方法。leftover

                hiMedia.curFilePath = param[1];
                hiMedia.curVolumeId = param[0];
                //PVR需要单独处理

                hiMedia.fileBrowserAllData = hiMedia.fileBrowserFileData
                    = hiMedia.fileBrowserVideoData = hiMedia.fileBrowserMusicData
                    = hiMedia.fileBrowserPicData = [];
                //endLoading  and create or refresh fileBrowser.0218
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "")
                switch (currentSubModel) {
                    case "deviceBrowser":
                        //从设备浏览器进入文件浏览器
                        //var deviceBrowser = UI.getSubModule("deviceBrowser");
                        ////  deviceBrowser.visible = false;
                        //hiMedia.needRefreshFB = true;
                        //UI.pushSubModule("hiMedia", "fileBrowser", true);
                        //hiMedia.endLoading("showUsbDetail");
                        //hiMedia.currentDevice = hiMedia.device.dms;
                        UI.pushSubModule("hiMedia", "hiMediaNoFileTips", true);
                        break;
                    case "fileBrowser":
                        //文件浏览器进入文件夹
                        var fileBrowser = UI.getSubModule("fileBrowser");
                        var fileBrowserList = UI.getItem(fileBrowser, "fileBrowserList");
                        DBG_INFO("[onUSBIteratorEvent] fileBrowser.currClassify= " + fileBrowser.currClassify);
                        fileBrowserList.removeAllChildren();
                        if (fileBrowser.listMode) {
                            var headerItem = [];
                            switch (fileBrowser.currClassify) {
                                case hiMedia.fileType.pic:
                                    headerItem = fileBrowser.allPic;
                                    break;
                                case hiMedia.fileType.music:
                                    headerItem = fileBrowser.allMusic;
                                    break;
                                case hiMedia.fileType.video:
                                    headerItem = fileBrowser.allVideo;
                                    break;
                                default:
                                    DBG_ERROR("list mode, error type.");
                                    break;
                            }
                            fileBrowser.createFileList(headerItem, true);
                        } else {
                            fileBrowser.createFileList([], true);
                        }
                        DBG_INFO("pathStack.push" + hiMedia.curFilePath + "Current is " + fileBrowser.pathStack);
                        fileBrowser.pathStack.push(hiMedia.curFilePath);
                        fileBrowser.fileStack[hiMedia.curFilePath] = fileBrowser.fileBrowserData;
                        fileBrowser.folderFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserFileData;
                        fileBrowser.videoFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserVideoData;
                        fileBrowser.musicFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserMusicData;
                        fileBrowser.picFileStack[hiMedia.curFilePath] = hiMedia.fileBrowserPicData;
                        fileBrowser.setFBPath(hiMedia.curFilePath);
                        hiMedia.endLoading("showUsbDetail");
                        break;
                    default :
                        DBG_ERROR("Current SubModel Error : " + currentSubModel);
                        break;
                }
            }


        }
        else if (event.type == TableIterator.EVENT_TYPE_SEEK_TO_ROW) {
            DBG_INFO('seek to row index = ' + event.result);
            // m_directoryIterator.readNextRows(HiFileBrowser.table_read_once);
        }
        else {
            DBG_INFO("oother Type________________" + event.type);
            try {
                m_directoryIterator.disconnect();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        //m_directoryIterator.readNextRows(90);

    }
    hiMedia.onFocus = function (focus) {
        // UI.moveCursor(UI.adjustView());
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if (GLOBAL.TTS) {
            var Timer;
            clearTimeout(Timer);
            if (!GLOBAL.NO_VOICE) {
                Timer = setTimeout(function () {
                    if (focus.voiceStr) {
                        UI.callTTS(focus.voiceStr);
                    } else {
                        UI.callTTS(UI.base.getVoiceStr(focus))
                    }
                }, 1)
            }

        }
    };

    hiMedia.onNormal = function (focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toNormalContrast(focus);
        }
    };


    var orderHiFileData = function (hiFileDataArray) {
        DBG_INFO("orderHiFileData function begin! and param length is :" + hiFileDataArray.length);
        if (hiFileDataArray.length > 1) {
            if (hiFileDataArray[0].fileTime == "unsupported") {
                hiFileDataArray.sort(hiMedia.sortBy("fileName", false, "localeCompare"));

            } else {
                if (hiMedia.currentSortType == "time") {
                    hiFileDataArray.sort(hiMedia.sortBy("fileName", false, "localeCompare"));
                    hiFileDataArray.sort(hiMedia.sortBy("fileTime", true, String));
                } else if (hiMedia.currentSortType == "size") {
                    hiFileDataArray.sort(hiMedia.sortBy("fileName", false, "localeCompare"));
                    hiFileDataArray.sort(hiMedia.sortBy("fileSize", true, Number));
                } else {
                    hiFileDataArray.sort(hiMedia.sortBy("fileName", false, "localeCompare"));
                }
            }
            //content.sort(hiMedia.sortBy("fileTime", true, String));
        }
        return hiFileDataArray;
    };
    hiMedia.sortBy = function (filed, rev, primer) {
        rev = (rev) ? -1 : 1;
        return function (a, b) {
            a = a[filed];
            b = b[filed];
            if (primer == "localeCompare") {
                return a.localeCompare(b);
            }
            if (typeof (primer) != 'undefined') {
                a = primer(a);
                b = primer(b);
            }
            if (a < b) {
                return rev * -1;
            }
            if (a > b) {
                return rev * 1;
            }
//            if (a == b) {
//                return -1;
//            }
            return 1;
        }
    };
    //切换MENUCHIP
    hiMedia.showMenuChipByIndex = function (cArray, listGroup, currIdx, lastIdx, startx) {
        //切换圆点
        var currC = UI.getItem(listGroup.parent, cArray[currIdx]);
        var lastC = UI.getItem(listGroup.parent, cArray[lastIdx]);
        UI.setImage(lastC, "hiMedia/circle_normal.png");
        UI.setImage(currC, "hiMedia/circle_focus.png");
        var toX = startx - 480 * currIdx;
        //切换List
        //DBG_INFO("x is ==============" + toX);
        UI.getTween(listGroup, true).to({x: toX}, 500, UI.ease.quadOut);
        //leftover 焦点处理
    }
    //公用切换时间方法
    hiMedia.getTimeText = function (c, format) {
        var d = Math.floor(c);
        var b = Math.floor(d / 3600);//hour
        var e = Math.floor((d % 3600) / 60);//minute
        var a = Math.floor(d % 60);//second
        if (b > 100)
            return formatTimeHMS(0, 0, 0);
        else
            return formatTimeHMS(b, e, a);
        function formatTimeHMS(c, a, b) {
            switch (format) {
                case "MS":
                    return checkTime(a) + ":" + checkTime(b);
                    break;
                case "HMS":
                    return checkTime(c) + ":" + checkTime(a) + ":" + checkTime(b);
                    break;
                default :
                    break;
                    return
            }
        };
        function checkTime(a) {
            return (a < 10 ? "0" : "") + a;
        };
    };
    hiMedia.loadingtimer = null;
    hiMedia.loadingIcon = null;
    hiMedia.startLoading = function (from, timeout, hideLoading) {
        DBG_INFO("[hiMedia.startLoading]" + from);
        if (!timeout) {
            timeout = 5;
        }
        if (!hideLoading) {
            UI.startLoading();
        } else {
            UI.inactiveKey();
            //need sync this param
            UI.base.loading.number++;
        }
        //add the protect time for media by jiaguili 2017/7/11
        //the ota dialog may lost the focus
        GLOBAL.PROTECTED_TIME = true;

//        hiMedia.loadingIcon = new createjs.Bitmap(UI.loader.getResult("loading"));
//        hiMedia.loadingIcon.pivot.x = UI.loader.getResult("loading").width / 2;
//        hiMedia.loadingIcon.pivot.y = UI.loader.getResult("loading").height / 2;
//        hiMedia.loadingIcon.x = 960;
//        hiMedia.loadingIcon.y = 540;
//        hiMedia.loadingIcon.name = "loadingIcon";
//        UI.frontStage.addChild(hiMedia.loadingIcon);
//        UI.getTween(hiMedia.loadingIcon, true, true).to({rotation: hiMedia.loadingIcon.rotation + 360}, 1000);

        hiMedia.loadingtimer = setTimeout(function () {
            hiMedia.endLoading("startLoading timeout " + from);
        }, timeout * 1000);
    };
    hiMedia.endLoading = function (from) {
        DBG_INFO("[hiMedia.endLoading]" + from);
        try {
            if (!!hiMedia.loadingtimer) {
                DBG_INFO("[hiMedia.endLoading] not current timeout ,need  number-- !");
                UI.base.loading.number--;
                clearTimeout(hiMedia.loadingtimer);
                hiMedia.loadingtimer = null;
            }
            //add the protect time for media by jiaguili 2017/7/11.
            GLOBAL.PROTECTED_TIME = false;
//            if (!!hiMedia.loadingIcon) {
//                createjs.Tween.removeTweens(hiMedia.loadingIcon);
//                UI.frontStage.removeChild(hiMedia.loadingIcon);
//                hiMedia.loadingIcon = null;
//            }
            DBG_INFO("loading.number=" + UI.base.loading.number);
            UI.endLoading();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    hiMedia.hideListData = function (target, cIndex, maxItem, checkFlag) {
        if (!!target.initSequence) {
            var minI = Math.max(0, cIndex - maxItem),
                maxI = Math.min(target.initSequence.length, cIndex + maxItem);
            if (!!checkFlag) {
                target.initSequence.forEach(function (v) {
                    v.alpha = 0;
                    if (checkFlag == "hide") {
                        v.children[3].alpha = 0;
                    } else if (checkFlag == "show") {
                        v.children[3].alpha = 1;
                    } else {
                        //do nothing
                    }
                });
            } else {
                target.initSequence.forEach(function (v) {
                    v.alpha = 0;
                });
            }
            for (var i = minI; i < maxI; i++) {
                target.initSequence[i].alpha = 1;
            }
        } else {
            DBG_ERROR("[hiMedia.hideListData] target is null!!!");
        }
    }
    //用于media上飘launcher时的处理。
    hiMedia.changeByLauncher = function (value) {
        //有些页面是在onpop中发出该命令，这时候判断当前页面还是未退出的页面。所以延时处理


        switch (value) {
            case "pause":
                var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
                DBG_ALWAYS(value + " |||  " + currentSubModel);
                switch (currentSubModel) {
                    case "musicPlayer":
                        //暂停动画
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        //musicPlayer.pauseAnimation();
                        musicPlayer.closeMenu("pause");
                        break;
                    case "picPlayer":
                        //暂停图片播放
                        var picPlayer = UI.getSubModule("picPlayer");
                        if (picPlayer.playerStatus == 1) {
                            picPlayer.showStatus("play");
                            clearInterval(picPlayer.playTime);
                            picPlayer.playerStatus = 0;
                        }
                        var picPlayerMenu2 = UI.getItem(picPlayer, "picPlayerMenu2");
                        if (picPlayerMenu2.alpha == 1) {
                            picPlayerMenu2.alpha = 0;
                        } else {
                            picPlayer.closeMenu("pause");
                        }
                        break;
                    case "videoPlayer":
                        //暂停图片播放
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        var videoPlayerMenu2 = UI.getItem(videoPlayer, "videoPlayerMenu2");
                        if (videoPlayerMenu2.alpha == 1) {
                            videoPlayerMenu2.alpha = 0;
                        } else {
                            videoPlayer.closeMenu("pause");
                        }
                        break;
                    case "fileBrowser":
                        //用于处理在文件浏览器时按返回键不做刷新
                        hiMedia.pauseFromFB = true;
                        hiMedia.needRefreshFB = false;
                        UI._callBubble(UI.getCurrFocus(), "onNormal", UI.getCurrFocus());
                    case "deviceBrowser":
                        var deviceBrowser = UI.getSubModule("deviceBrowser");
                        var device_focus = UI.getItem(deviceBrowser, "device_focus");
                        device_focus.alpha = 0;
                        UI.updateStage();
                        break;
                    default :
                        break;

                }
                break;
            case "resume":
                setTimeout(function () {
                    var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
                    if (!!UI.getCurrSubModule()) {
                        UI.refreshSubModuleLanguage(UI.getCurrSubModule());
                    }
                    DBG_ALWAYS(value + " |||  " + currentSubModel);
                    switch (currentSubModel) {
                        case "musicPlayer":
                            //暂停动画
                            var musicPlayer = UI.getSubModule("musicPlayer");

                            if (!!hiMedia.needPopCurSubModule) {
                                DBG_INFO("usb pop.close musicPlayer!");
                                var deviceBrowser = UI.getSubModule("deviceBrowser");
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                UI.popSubModule();
                                deviceBrowser.visible = 1;
                                hiMedia.needPopCurSubModule = false;
                                hiMedia.devceBrowserEnable = true;
                            } else {
                                //musicPlayer.resumeAnimation();
                                DBG_INFO("resume musicPlayer status is : " + hiMedia.playerstatus);
                                if (hiMedia.playerstatus == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP) {
                                    musicPlayer.playNextWhenStop();
                                }
                            }
                            try {
                                if (!GLOBAL.RTL) {
                                    model.mpctrl.setMusicSubtitlePosition(createIntergerVector([930, 440, 700, 300, 0, 0]));
                                }
                                else {
                                    model.mpctrl.setMusicSubtitlePosition(createIntergerVector([210, 440, 700, 300, 0, 0]));
                                }
                            } catch (ex) {
                                DBG_ERROR(ex.message);
                            }
                            break;
                        case "videoPlayer":
                            var videoPlayer = UI.getSubModule("videoPlayer");
                            var videoPlayerMenu = UI.getItem(videoPlayer, "videoPlayerMenu");
                            createjs.Tween.removeTweens(UI.base.cursor);
                            if (!videoPlayerMenu.visible) {
                                UI.base.cursor.alpha = 0;
                            } else {
                                if (videoPlayerMenu.alpha == 0) {
                                    DBG_INFO("need close menu");
                                    videoPlayer.closeMenu("resume");
                                }
                            }

                            if (!!hiMedia.needPopCurSubModule) {
                                DBG_INFO("usb pop.close videoPlayer!");
                                var deviceBrowser = UI.getSubModule("deviceBrowser");
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                UI.popSubModule();
                                deviceBrowser.visible = 1;
                                hiMedia.needPopCurSubModule = false;
                                hiMedia.devceBrowserEnable = true;
                            } else {
                                DBG_INFO("resume videoplayer status is : " + hiMedia.playerstatus);
                                if (hiMedia.playerstatus == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP) {
                                    videoPlayer.playNextWhenStop();
                                }
                                //处理MEMC，在ONSHOW不进入时
                                videoPlayer.onShow();
                            }
                            break;
                        case "picPlayer":
                            createjs.Tween.removeTweens(UI.base.cursor);
                            var picPlayer = UI.getSubModule("picPlayer");
                            var picPlayerMenu = UI.getItem(picPlayer, "picPlayerMenu");

                            if (!picPlayerMenu.visible) {
                                UI.moveCursor(UI.adjustView());
                                UI.base.cursor.alpha = 1;
                                UI.base.cursor.visible = true;
                            } else {
                                if (picPlayerMenu.alpha == 0) {
                                    DBG_INFO("need close menu");
                                    picPlayer.closeMenu("resume");
                                }

                            }

                            UI.updateStage();
                            if (!!hiMedia.needPopCurSubModule) {
                                DBG_INFO("usb pop.close videoPlayer!");
                                var deviceBrowser = UI.getSubModule("deviceBrowser");
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                UI.popSubModule();
                                deviceBrowser.visible = 1;
                                hiMedia.needPopCurSubModule = false;
                                hiMedia.devceBrowserEnable = true;
                            }
                            break;
                        case "fileBrowser":
                            DBG_INFO("hiMedia.needPopCurSubModule   =   " + hiMedia.needPopCurSubModule + "hiMedia.pauseFromFB = " + hiMedia.pauseFromFB);
                            var fileBrowser = UI.getSubModule("fileBrowser");
                            if (!!hiMedia.needPopCurSubModule) {
                                DBG_INFO("usb pop.close videoPlayer!");
                                var deviceBrowser = UI.getSubModule("deviceBrowser");
                                deviceBrowser.RefreshUSBData(value[0], value[1]);
                                UI.popSubModule();
                                deviceBrowser.visible = 1;
                                hiMedia.needPopCurSubModule = false;
                                hiMedia.devceBrowserEnable = true;
                                hiMedia.pauseFromFB = false;//也需要focus current focus.所有去掉else
                            }else{
                                fileBrowser.resumeFileBrowser();
                            }
                            UI.focusTo(UI.getCurrFocus());
                            break;
                        case "deviceBrowser":
                            var deviceBrowser = UI.getSubModule("deviceBrowser");
                            var device_focus = UI.getItem(deviceBrowser, "device_focus");
                            device_focus.alpha = 1;
                            UI.updateStage();
                            break;
                        default :
                            break;

                    }
                }, 100);
                break;
            default :

                break;
        }

    }

    hiMedia.setThumbImage = function (target, urlOrObj, noUpdate,w,h) {
        if (!urlOrObj || !target) {
            return;
        }
        if (urlOrObj.color) {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
            var graphics = new PIXI.Graphics();
            graphics.clear()
                .beginFill(urlOrObj.color)
                .drawRect(0, 0, target.oriWidth, target.oriHeight)
                .endFill();
            target.addChild(graphics);
        }
        else if (urlOrObj.constructor.name == 'Graphics') {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
            target.addChild(urlOrObj);
        }
        else if (urlOrObj.constructor.name == 'BaseTexture') {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
            var pic = Util.connBgPics(urlOrObj, target.oriWidth, target.oriHeight);
            target.addChild(pic);
        }
        else {
            var url = null;
            if (urlOrObj.substring(1, 7) == "3rd_rw") {
                url = "file://" + urlOrObj;
            } else if (urlOrObj.substring(0, 7) == "file://") {
                url = urlOrObj;
            } else if (urlOrObj.substring(0, 7) == "http://") {
                url = urlOrObj;
            } else if (urlOrObj.substring(0, 8) == "https://") {
                url = urlOrObj;
            } else {
                url = themeDir + "" + urlOrObj;
            }
            var baseTexture = PIXI.BaseTexture.fromImage(url);
            if (target.children[0].texture) {
                // UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
                target.children[0].texture.destroy(true);
                target.children[0].texture = null;
                target.originPic = urlOrObj;
                target.children[0].texture = new PIXI.Texture(baseTexture);
            } else {
                // UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                target.removeAllChildren(true)
                target.addChild(new PIXI.Sprite(new PIXI.Texture(baseTexture)));
                target.originPic = urlOrObj;
            }
        }
        target.children[0].width = !!w?w:470;
        target.children[0].height = !!h?h:470;
        if (!noUpdate) {
            UI.updateStage();
        }
    };
    hiMedia.toastMsg = function (msg, time) {
        hiMedia.toastText = msg;
        if (!!time) {
            hiMedia.toastTime = time;
        } else {
            hiMedia.toastTime = 3000;
        }
        UI.pushGhostModule("hiMedia", "hiMediaToast");
    }
    //增加对字幕，音轨的转换返回值监听
    function onISUBTrackResult(act, value) {
        DBG_ALWAYS("[onISUBTrackResult] value:" + value);
        var tmpStr = value + "";
        try {
            var videoPlayer = UI.getSubModule("videoPlayer");
            var tmpArr = tmpStr.split(",");
            videoPlayer.subtitleList = [];
            if (tmpArr.length > 0) {
                for (var i = 0; i < tmpArr.length + 1; i++) {
                    if (i == 0) {
                        //需要OFF多语言
                        videoPlayer.subtitleList.push("[GE0006]");//off
                    }
                    else {
                        if (!!tmpArr[i - 1] && tmpArr[i - 1] != "NULL" && tmpArr[i - 1] != "und") {
                            if (videoPlayer.subtitleList.indexOf(tmpArr[i - 1]) > -1) {
                                videoPlayer.subtitleList.push(tmpArr[i - 1] + i);
                            } else {
                                videoPlayer.subtitleList.push(tmpArr[i - 1]);
                            }

                        } else {
                            videoPlayer.subtitleList.push("[SE0381]" + i);
                        }
                    }
                }
            }
            videoPlayer.setSubtitleMenu();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onITTXTrackResult(act, value) {
        DBG_ALWAYS("[onITTXTrackResult] value:" + value);
        var tmpStr = value + "";
        try {
            var videoPlayer = UI.getSubModule("videoPlayer");
            var tmpArr = tmpStr.split(",");
            if (videoPlayer.subtitleList.length > 0) {
                if (tmpArr.length > 0) {
                    for (var i = 0; i < tmpArr.length + 1; i++) {

                        if (!!tmpArr[i - 1] && tmpArr[i - 1] != "NULL" && tmpArr[i - 1] != "und") {
                            if (videoPlayer.subtitleList.indexOf(tmpArr[i - 1]) > -1) {
                                videoPlayer.subtitleList.push(tmpArr[i - 1] + i);
                            } else {
                                videoPlayer.subtitleList.push(tmpArr[i - 1]);
                            }

                        } else {
                            videoPlayer.subtitleList.push("[SE0381]" + i);
                        }

                    }
                }
            }
            else {
                if (tmpArr.length > 0) {
                    for (var i = 0; i < tmpArr.length + 1; i++) {
                        if (i == 0) {
                            //需要OFF多语言
                            videoPlayer.subtitleList.push("[GE0006]");//off
                        }
                        else {
                            if (!!tmpArr[i - 1] && tmpArr[i - 1] != "NULL" && tmpArr[i - 1] != "und") {
                                if (videoPlayer.subtitleList.indexOf(tmpArr[i - 1]) > -1) {
                                    videoPlayer.subtitleList.push(tmpArr[i - 1] + i);
                                } else {
                                    videoPlayer.subtitleList.push(tmpArr[i - 1]);
                                }

                            } else {
                                videoPlayer.subtitleList.push("[SE0381]" + i);
                            }
                        }
                    }
                }
            }
            videoPlayer.setSubtitleMenu();
            //还需要该选择时的逻辑
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onAudioTrackResult(act, value) {
        DBG_ALWAYS("[onAudioTrackResult] value:" + value);
        var tmpStr = value + "";
        try {
            var videoPlayer = UI.getSubModule("videoPlayer");
            var dolbyPic = UI.getItem(videoPlayer, "dolbyPic");
            var tmpArr = tmpStr.split(";");
            videoPlayer.audioTrackList = [];
            if (tmpArr.length > 0) {
                for (var i = 0; i < tmpArr.length; i++) {

                    if (!!tmpArr[i] && tmpArr[i].split(",")[0] != "NULL" && !!tmpArr[i] && tmpArr[i].split(",")[0] != "und") {
                        videoPlayer.audioTrackList.push(tmpArr[i]);
                    }
                    else {
                        videoPlayer.audioTrackList.push("[SE0380]" + i + "," + tmpArr[i].split(",")[1]);
                    }


                }
            }

            videoPlayer.setAudioTrackMenu();

        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onSeekToResult(act, value) {
        //这里不能使用videoPlayer来判断是否处理快进快退，因为有漂浮情况，由于音乐无快进需求，所以videoPlayer对该事件有唯一性
        DBG_ALWAYS("[onSeekToResult] value:" + value);
        try {
            var videoPlayer = UI.getSubModule("videoPlayer");

            var videoStatus = UI.getItem(videoPlayer, "videoStatus");
            if (value == 1) {
                DBG_INFO("Seek success.");
            } else {
                DBG_ERROR("Fail to seek.");
                //videoPlayer.hideFfTime();
                videoPlayer.nowIsSeeking = false;
                //重置标志位
                if (videoPlayer.playerStatus == 1) {
                    UI.setImage(videoStatus, "hiMedia/play_status.png");
                }
                else {
                    UI.setImage(videoStatus, "hiMedia/pause_status.png");
                }
                UI.updateStage();
                hiMedia.toastMsg("[DMP0069]");//Time seek function is not supported!
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    hiMedia.isSubModuleExist = function (sModule) {
        var tmp = UI.getItem(UI.frontStage, sModule);
        if (tmp == null) {
            return false;
        }
        else {
            return true;
        }
    }
    //需要做定向删除，只删除断点续播记录，所以不能用clear
    hiMedia.limitStorage = function () {
        DBG_INFO("hiMedia.storage.length = " + hiMedia.storage.length);
        if (hiMedia.storage.length > 500) {
            DBG_ERROR("localstorage is more than 500,clear it!!!");
            hiMedia.storage.clear();
        }
    }
    var preloadImgList = ["hiMedia/btn/icn_pause_focus.png",
        "hiMedia/btn/icn_play_focus.png",
        "hiMedia/btn/icn_pause_normal.png",
        "hiMedia/btn/icn_play_normal.png",
        "hiMedia/btn/icn_previous_normal.png",
        "hiMedia/btn/icn_forward_normal.png",
        "hiMedia/btn/icn_backward_normal.png",
        "hiMedia/btn/icn_next_normal.png",
        "hiMedia/btn/icn_repeat_normal",
        "hiMedia/btn/icn_once_normal.png",
        "hiMedia/btn/icn_repeat_one_normal.png",
        "hiMedia/btn/icn_repeat_random_normal.png",
        "hiMedia/bg_all.png",
        "hiMedia/bg_music.png",
        "hiMedia/bg_photo.png",
        "hiMedia/bg_video.png"
    ];

    hiMedia.preLoadMediaImg = function () {
        while (preloadImgList.length > 0) {
            var url = preloadImgList.pop();
            PIXI.loader.add(themeDir + url, themeDir + url);
        }
        PIXI.loader.once('complete', function () {
            DBG_ERROR("media preloadImgList load complete");
        });
        PIXI.loader.load();

    }

    hiMedia.setNoSignalTimeout = function () {
        if (!!UI.MediaTimeout) {
            UI.refreshMediaTimeout();
        } else {
            UI.setMediaTimeout(function () {
                //openMsgBoxByType(MsgBoxType.STANDBY_TIP);
                onStandbyTipChanged(StandbyFlag.NO_SIGNAL);
                UI.refreshMediaTimeout();
            }, 14 * 60 * 1000);
        }

    };
    hiMedia.funcForAVS = function (type, val) {
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        switch (type) {
            case "seek":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        if (!val) {
                            val = 0;
                        } else {
                            val = videoPlayer.videoCurrentTime + val;
                        }
                        var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
                        if (!!canSpeed) {
                            if (!videoPlayer.nowIsSeeking) {
                                videoPlayer.nowIsSeeking = true;
                                if (val > videoPlayer.videoTotalTime - 1) {
                                    try {
                                        videoPlayer.nowIsSeeking = true;
                                        model.mpctrl.setMpCtrlPlaytimeCurrent(videoPlayer.videoTotalTime - 1);
                                    }
                                    catch (ex) {
                                        DBG_ERROR(ex.message);
                                    }
                                } else if (val <= 0) {
                                    try {
                                        videoPlayer.nowIsSeeking = true;
                                        model.mpctrl.setMpCtrlPlaytimeCurrent(0);
                                    }
                                    catch (ex) {
                                        DBG_ERROR(ex.message);
                                    }
                                }
                                else {
                                    DBG_INFO("seek to  :   " + val);
                                    try {
                                        videoPlayer.nowIsSeeking = true;
                                        model.mpctrl.setMpCtrlPlaytimeCurrent(val);
                                    }
                                    catch (ex) {
                                        DBG_ERROR(ex.message);
                                    }
                                }
                            } else {
                                DBG_ERROR("Now is seeking!");
                            }
                        } else {
                            hiMedia.toastMsg("[DMP0069]");//Time seek function is not supported!
                        }
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        if (!val) {
                            val = 0;
                        } else {
                            val = musicPlayer.musicCurrentTime + val;
                        }
                        var canSpeed = parseInt(model.mpctrl.getMpCtrlStat()[4]) & 1;
                        if (!!canSpeed) {
                            musicPlayer.nowIsSeeking = true;
                            musicPlayer.musicTotalTime = model.mpctrl.getMpCtrlPlaytimeTotal();
                            if (val > musicPlayer.musicTotalTime - 1) {
                                try {
                                    musicPlayer.nowIsSeeking = true;
                                    model.mpctrl.setMpCtrlPlaytimeCurrent(musicPlayer.musicTotalTime - 1);
                                }
                                catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                            } else if (val <= 0) {
                                try {
                                    musicPlayer.nowIsSeeking = true;
                                    model.mpctrl.setMpCtrlPlaytimeCurrent(0);
                                }
                                catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                            }
                            else {
                                DBG_INFO("seek to  :   " + val);
                                try {
                                    musicPlayer.nowIsSeeking = true;
                                    model.mpctrl.setMpCtrlPlaytimeCurrent(val);
                                }
                                catch (ex) {
                                    DBG_ERROR(ex.message);
                                }
                            }
                        } else {
                            hiMedia.toastMsg("[DMP0069]");//Time seek function is not supported!
                        }
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "next":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.next();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.next();
                        break;
                    case "picPlayer":
                        var picPlayer = UI.getSubModule("picPlayer");
                        picPlayer.next();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "pre":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.pre();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.pre();
                        break;
                    case "picPlayer":
                        var picPlayer = UI.getSubModule("picPlayer");
                        picPlayer.prev();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "startOver":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.videoIndex = 0;
                        videoPlayer.playVideoByUrl(videoPlayer.videoList[0].videoUrl, videoPlayer.videoList[0].videoName);
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.removeIndicator();
                        musicPlayer.resetMusicListItem();
                        musicPlayer.musicIndex = 0;
                        musicPlayer.playMusicByUrl(musicPlayer.musicList[0].musicUrl, musicPlayer.musicList[0].musicName);
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "play":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.onkey_PLAY();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.onkey_PLAY();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "pause":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.onkey_PAUSE();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.onkey_PAUSE();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "stop":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.onkey_STOP();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.onkey_STOP();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "fastfwd":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.onkey_FAST_FWD();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.onkey_FAST_FWD();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            case "fastbwd":
                switch (currentSubModel) {
                    case "videoPlayer":
                        var videoPlayer = UI.getSubModule("videoPlayer");
                        videoPlayer.onkey_FAST_BKW();
                        break;
                    case "musicPlayer":
                        var musicPlayer = UI.getSubModule("musicPlayer");
                        musicPlayer.onkey_FAST_BKW();
                        break;
                    default :
                        DBG_ERROR("current submodule is : " + currentSubModel);
                        break;
                }
                break;
            default :
                break;
        }
    };
})();