/**
 * Created by Administrator on 2018/5/5.
 */

UI.moduleBuilder['common']['dlnaDialog'] = function () {
    var template = Util.readJson("module/common/dlnaDialog.json");
    var dlnaDialogData = {
        dlnaDialog_bg: UI.window_bg,
        dlnaCheckBox: "setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png",
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "[SE1205]",
        btn_left_text: "[SE1206]",
        dlnaDialogContent: "[SE0181]"
    };

    var dlnaDialog = SubModule.create(dlnaDialogData, template);
    var BtnRight = UI.getItem(dlnaDialog, "BtnRight");
    var BtnLeft = UI.getItem(dlnaDialog, "BtnLeft");
    var dlnaDialogContent = UI.getItem(dlnaDialog, "dlnaDialogContent");
    var dlnaCheckBox = UI.getItem(dlnaDialog, "dlnaCheckBox");
    dlnaDialog.currFocus = BtnRight;
    BtnRight.alpha = BtnLeft.alpha = 0.6;
    dlnaDialogContent.alpha = 0.6;

    dlnaDialog.protected = true;
    var dlnaCheckStatus = 0;
    var dlnaDeviceMac = null;
    dlnaDialog.storage = window.localStorage;



    dlnaDialog.onFocus = function (focus) {
        DBG_INFO("dlnaDialog_onFocus");
        onFocusLiveTVTarget(focus, 1.05, 500);
        return true;
    }

    dlnaDialog.onNormal = function (focus) {
        DBG_INFO("dlnaDialog_onNormal");
        onNormalLiveTVTarget(focus, 0.6, 500);
        return true;
    }
    dlnaCheckBox.onkey_ENTER = function(){
        if(dlnaCheckStatus == 0){
            UI.setImage(dlnaCheckBox,"setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox01.png");

            dlnaCheckStatus = 1;
        }else{
            UI.setImage(dlnaCheckBox,"setting/" + GLOBAL.LAUNCHER_BRAND + "/checkbox02.png");
            dlnaCheckStatus = 0;
        }
    }
    BtnRight.onkey_ENTER = function () {
        UI.popSubModule();
        try {
            if(!!dlnaDialog.param){
                DBG_INFO("dlnaDialog param" + dlnaDialog.param);
                saveTrust();
                if(dlnaDialog.param.Type == "Pic"){
                    Dlna.onPictureRunningchanged(dlnaDialog.param.Value);
                }else if(dlnaDialog.param.Type == "MpCtrl"){
                    Dlna.onMpCtrlRenderchanged(dlnaDialog.param.Value);
                }
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    dlnaDialog.onPush = function () {
        try {
            dlnaDeviceMac = !!dlnaDialog.param ? dlnaDialog.param.deviceMac : Config.language.SE1521;
            DBG_INFO("Device Mac Address" + dlnaDeviceMac);
            var str = Config.language.SE0181 + ":" + dlnaDeviceMac;
            UI.setText(dlnaDialogContent, str);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    dlnaDialog.onPop = function () {
        BtnRight.scale.x = 1;
        BtnRight.scale.y = 1;
        BtnLeft.scale.x = 1;
        BtnLeft.scale.y = 1;
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI.base.cursor.alpha = 0;
    }

    function closedlnaDialog() {
        try {
            UI.popSubModule();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function saveTrust(){
        try {
            DBG_INFO("dlnaCheckStatus " + dlnaCheckStatus + "DLNADIALOG_AGREE " + GLOBAL.DLNADIALOG_AGREE);
            if(dlnaCheckStatus == 0){
                GLOBAL.DLNADIALOG_AGREE = true;
            }
            if(!!dlnaDialog.param) {
                dlnaDialog.storage.setItem(dlnaDialog.param.deviceMac, dlnaCheckStatus);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    BtnLeft.onkey_ENTER = dlnaDialog.onkey_BACKSPACE = closedlnaDialog;
};