/**
 * Created by jiangbo1 on 2016/2/24.
 */

UI.moduleBuilder['common']['commonPasswordDialog'] =function () {

    var pwdData = {
        pwd_dlg_bg: UI.window_bg,
        pwd_pad_bg: UI.window_bg,
        pwdImg1: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg2: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg3: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdImg4: GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM,
        pwdBoxImg1: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg2: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg3: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdBoxImg4: GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL,
        pwdText1: " ",
        pwdText2: " ",
        pwdText3: " ",
        pwdText4: " ",
        delete_bg: UI.item_bg,
        zero_bg: UI.item_bg,
        delete_icon: "setting/key_delete.png",
        zeroText: "0",
        pwdTip: "[SE1543]"
    };

    var template = Util.readJson("module/common/commonPasswordDialog.json");
    var pwdDialog = SubModule.create(pwdData, template);

    var pwdDlgPanel = UI.getItem(pwdDialog, "pwdDlgPanel");
    var pwdPadPanel = UI.getItem(pwdDialog, "pwdPadPanel");

    var deleteBtn = UI.getItem(pwdPadPanel, "deleteBtn");
    var zeroBtn = UI.getItem(pwdPadPanel, "zeroBtn");

    var pwdNumArr = [], pwdImgArr = [], pwdBoxImgArr = [], pwdTextArr = [], numList, crntIndex = 0, pinCode;
    var CALLMODE;

    var inputedArr = [], space = " ", btnMap = [
        "1", "2", "3",
        "4", "5", "6",
        "7", "8", "9"
    ];
    var numKeyMap = ["ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"];
    UI.setVoiceStr(deleteBtn,"[GE0014]");
    function initUIElement() {
        for (var i = 1; i <= 4; i++) {
            pwdNumArr.push(UI.getItem(pwdDlgPanel, "pwdNum" + i));
            pwdImgArr.push(UI.getItem(pwdNumArr[i - 1], "pwdImg" + i));
            pwdBoxImgArr.push(UI.getItem(pwdNumArr[i - 1], "pwdBoxImg" + i));
            pwdTextArr.push(UI.getItem(pwdNumArr[i - 1], "pwdText" + i));
        }
        numList = UI.getItem(pwdPadPanel, "numList");
        var gridInfo = {
            template: "NumPadTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 3,
            distanceY: 20,
            distanceX: 40,
            container: numList
        };

        var allArray = [];
        for (var i = 0; i < btnMap.length; i++) {
            allArray.push(
                {
                    tileBg: UI.item_bg,
                    Num: btnMap[i],
                    name: "BTN" + i
                }
            )
        }
        Gird.create(allArray, gridInfo);
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
    }

    function moveBorderTo(frm, to) {
        if (to < 0 || to > 3) return;
        //if (frm >= 0) UI.setImage(pwdImgArr[frm], GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM);
//        if (frm >= 0) setLiveTVImage(pwdImgArr[frm], GLOBAL.IMAGE_LIST.PASSWORD_BOX_BTM);
        //UI.setImage(pwdImgArr[to], GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL);
//        setLiveTVImage(pwdImgArr[to], GLOBAL.IMAGE_LIST.PASSWORD_BOX_NORMAL);

        if (frm >= 0) {
            pwdBoxImgArr[frm].alpha = 0;
            pwdImgArr[frm].alpha = 1;
        }
        pwdBoxImgArr[to].alpha = 1;
        pwdImgArr[to].alpha = 0;

        crntIndex = to;
    }

    pwdDlgPanel.onkey_LEFT = function () {
        if (0 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex - 1);
        return true;
    }

    pwdDlgPanel.onkey_RIGHT = function () {
        if (3 == crntIndex) return;
        moveBorderTo(crntIndex, crntIndex + 1);
        return true;
    }

    pwdPadPanel.onkey_RIGHT = function() {
        var index = numList.initSequence.indexOf(UI.getCurrFocus());
        if (index == 2 || index == 5) {
            UI.focusTo(deleteBtn);
        }
        else if (index == 8) {
            UI.focusTo(zeroBtn);
        }
        else {
            return true;
        }
    };
    deleteBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN2"))
    };
    zeroBtn.onkey_LEFT = function() {
        UI.focusTo(UI.getItem(numList, "BTN8"))
    };

    deleteBtn.onkey_ENTER = function() {
        inputedArr[crntIndex] = "";
        moveBorderTo(crntIndex, crntIndex - 1);
        setLiveTVText(pwdTextArr[crntIndex], space);
        UI.updateStage();
    };

    zeroBtn.onkey_ENTER = function() {
        if (crntIndex < 4) {
            inputedArr[crntIndex] = "0";
            setLiveTVText(pwdTextArr[crntIndex], "*");
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        checkPwdAndUnlock(inputedArr);
        UI.updateStage();
    };

    /*pwdDlgPanel.onkey_DOWN = function (focus) {
        UI.focusTo(UI.getItem(numList, "BTN5"));
    }

    pwdPadPanel.onkey_UP = function () {
        var index = numList.initSequence.indexOf(UI.getCurrFocus());
        if (index == -1 || index > 3) return true;
        moveBorderTo(-1, crntIndex);
        UI.focusTo(pwdNumArr[crntIndex]);
        return false;
    }

    pwdPadPanel.onkey_DOWN = function () {
        var index = numList.initSequence.indexOf(UI.getCurrFocus());
        if (index < 8) return true;
        if (8 == index || 9 == index) {
            UI.focusTo(deleteBtn);
        }
        else if (10 == index || 11 == index) {
            UI.focusTo(zeroBtn);
        }
        return false;
    }*/

    function checkPwdAndUnlock(arr) {
        var pwd = arr.join("");
        if (pwd.length == 4) {
            DBG_INFO("password is: " + pwd);
            if (pwd == pinCode || pwd == GLOBAL.MASTER_KEY) {
                setTimeout(function(){
                    UI.popSubModule();
                    try {
                        var crntChannel = liveTV.getCurrentChannelInfo();
                        if (Config.tv && 1 == model.source.getInputCurrentInLock()) {
                            model.source.unlockInput(liveTV.getCurrentSourceObj().uid);
                        }
                        //if (Config.tv && SourceList.TV == GLOBAL.CURRENT_SOURCE/* && crntChannel.eCode == ECode.LOCK*/) {
                        //    model.tvservice.unLockPlayChannel(crntChannel.uid);
                        //}
                        if(liveTV.isParentalLockPinRequest())// add by samuel qin 2016/9/26
                        {
                            DBG_INFO("PinRequestConfirm:" + pwd);
                            model.parentlock.PinRequestConfirm(Parental_lockModel.PARENTAL_PIN_REQUEST_STATUS_CONFIRMED, pwd);
                        }
						model.system.setOttPwdCheckFlag(1);
                    }
                    catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    GLOBAL.UNLOCKED = true;
                    if(checkIsAppOn()){
                        appControl.focusCurrentApp();
                    }
//                    openLiveTVModule([Msg.PASSWORD, 0]);
                }, 50);
                return true;
            }
            else {
                DBG_TODO("password error.");
                for (var i = 0; i < 4; i++) {
                    setLiveTVText(pwdTextArr[i], space);
                }
                moveBorderTo(crntIndex, 0);
                inputedArr = [];
                GLOBAL.CURRENT_TOAST_TYPE=0;
                UI.pushGhostModule("setting","SettingSysToast");
                UI.updateStage();
            }
        }
        return false;
    }

    function passwordDialgHandler(focus, evt){
        if (crntIndex < 4) {
            inputedArr[crntIndex] = (evt.keyCode - CONST.KEY.VK_0) + "";
            setLiveTVText(pwdTextArr[crntIndex], "*");
            if(3 == crntIndex) UI.updateStage();
            moveBorderTo(crntIndex, crntIndex + 1);
        }
        if(!checkPwdAndUnlock(inputedArr)){
//            UI.focusTo(pwdNumArr[crntIndex]);
        }
        UI.updateStage();
        return false;
    }

    pwdPadPanel.onkey_ENTER = function (focus) {
        switch (focus.name) {
            /*case "deleteBtn":
                moveBorderTo(crntIndex, crntIndex - 1);
                break;
            case "zeroBtn":
                moveBorderTo(crntIndex, crntIndex + 1);
                break;
            case "BTN7"://Dot
                return false;
            case "BTN3"://Delete
                if (space == UI.getText(pwdTextArr[crntIndex])) {
                    moveBorderTo(crntIndex, crntIndex - 1);
                }
                else {
                    inputedArr[crntIndex] = "";
                    setLiveTVText(pwdTextArr[crntIndex], space);
                }
                break;*/
            default :
                if (crntIndex < 4) {
                    inputedArr[crntIndex] = btnMap[numList.initSequence.indexOf(focus)];
                    setLiveTVText(pwdTextArr[crntIndex], "*");
                    moveBorderTo(crntIndex, crntIndex + 1);
                }
                break;
        }
        UI.updateStage();
        checkPwdAndUnlock(inputedArr);
    }

    function recoverInputBox(){
        for (var i = 0; i < 4; i++) {
            setLiveTVText(pwdTextArr[i], space);
        }
        moveBorderTo(crntIndex, 0);
        inputedArr = [];
    }

    pwdDialog.onPush = function () {
        DBG_ONXX(LIVETV.PASSWORD_DIALOG, "onPush");
        pinCode =tv? model.parentlock.getPin():"0000";
        moveBorderTo(-1, 0);
        CALLMODE = true;
    }

    pwdDialog.onPop = function () {
        DBG_ONXX(LIVETV.PASSWORD_DIALOG, "onPop");
        recoverInputBox();
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.scaleX = 1;
        UI.base.cursor.scaleY = 1;
        UI.base.cursor.alpha = 0;
        pwdDialog.currFocus = UI.getItem(numList, "BTN0");
    }

    pwdDialog.onFocus = function (focus) {
        DBG_ONXX(LIVETV.PASSWORD_DIALOG, "onFocus");
        if (CALLMODE == true) {
            CALLMODE = false;
            UI.callTTS("[SE1543] 1");
            onFocusLiveTVTarget(focus, 1, 500, null, null, true);
        }
        else {
            onFocusLiveTVTarget(focus, 1, 500);
        }
    }
    pwdPadPanel.onkey_BACKSPACE = function(){
//        DBG_ERROR("pwdDialog.onkey_BACKSPACE !!!!!!!!!!!!!!!!!!");
//        UI.popSubModule();
//        appControl.focusCurrentApp(true);
        return false;
    };
    pwdDialog.onNormal = function(focus){
        onNormalLiveTVTarget(focus, 1, 500);
    }
    pwdDialog.onkey_BACKSPACE=function(){
       return false;
    }
    numKeyMap.forEach(function (v) {
//        pwdDlgPanel["onkey_" + v] = passwordDialgHandler;
        pwdPadPanel["onkey_" + v] = passwordDialgHandler;
    });

    initUIElement();
}